(function(){this._ycssjs||(this._ycssjs=function(k, f){return !(k in _ycssjs||_ycssjs[k]++)})})();
if(_ycssjs('Z8D+Mh1Zja6vVjrIwgOxlZdy1RU')){
/* ../../lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: begin */ /**/
/**
 * Inheritance plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (dfilatov@yandex-team.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.3.3
 */

(function($) {

var hasIntrospection = (function(){_}).toString().indexOf('_') > -1,
    needCheckProps = $.browser.msie, // fucking ie hasn't toString, valueOf in for
    specProps = needCheckProps? ['toString', 'valueOf'] : null,
    emptyBase = function() {};

function override(base, result, add) {

    var hasSpecProps = false;
    if(needCheckProps) {
        var addList = [];
        $.each(specProps, function() {
            add.hasOwnProperty(this) && (hasSpecProps = true) && addList.push({
                name : this,
                val  : add[this]
            });
        });
        if(hasSpecProps) {
            $.each(add, function(name) {
                addList.push({
                    name : name,
                    val  : this
                });
            });
            add = addList;
        }
    }

    $.each(add, function(name, prop) {
        if(hasSpecProps) {
            name = prop.name;
            prop = prop.val;
        }
        if($.isFunction(prop) &&
           (!hasIntrospection || prop.toString().indexOf('.__base') > -1)) {

            var baseMethod = base[name] || function() {};
            result[name] = function() {
                var baseSaved = this.__base;
                this.__base = baseMethod;
                var result = prop.apply(this, arguments);
                this.__base = baseSaved;
                return result;
            };

        }
        else {
            result[name] = prop;
        }

    });

}

$.inherit = function() {

    var args = arguments,
        hasBase = $.isFunction(args[0]),
        base = hasBase? args[0] : emptyBase,
        props = args[hasBase? 1 : 0] || {},
        staticProps = args[hasBase? 2 : 1],
        result = props.__constructor || (hasBase && base.prototype.__constructor)?
            function() {
                return this.__constructor.apply(this, arguments);
            } : function() {};

    if(!hasBase) {
        result.prototype = props;
        result.prototype.__self = result.prototype.constructor = result;
        return $.extend(result, staticProps);
    }

    $.extend(result, base);

    var inheritance = function() {},
        basePtp = inheritance.prototype = base.prototype,
        resultPtp = result.prototype = new inheritance();

    resultPtp.__self = resultPtp.constructor = result;

    override(basePtp, resultPtp, props);
    staticProps && override(base, result, staticProps);

    return result;

};

$.inheritSelf = function(base, props, staticProps) {

    var basePtp = base.prototype;

    override(basePtp, basePtp, props);
    staticProps && override(base, base, staticProps);

    return base;

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: begin */ /**/
/**
 * Identify plugin
 *
 * @version 1.0.0
 */

(function($) {

var counter = 0,
    expando = '__' + (+new Date),
    get = function() {
        return 'uniq' + ++counter;
    };

/**
 * Makes unique ID
 * @param {Object} [obj] Object that needs to be identified
 * @param {Boolean} [onlyGet=false] Return a unique value only if it had already been assigned before
 * @returns {String} ID
 */
$.identify = function(obj, onlyGet) {

    if(!obj) return get();

    var key = 'uniqueID' in obj? 'uniqueID' : expando; // Use when possible. native uniqueID for elements in IE

    return onlyGet || key in obj?
        obj[key] :
        obj[key] = get();

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: begin */ /**/
(function($) {

$.isEmptyObject || ($.isEmptyObject = function(obj) {
        for(var i in obj) return false;
        return true;
    });

})(jQuery);
;
/* ../../lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: begin */ /**/
/**
 * Debounce and throttle function's decorator plugin 1.0.6
 *
 * Copyright (c) 2009 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

(function($) {

$.extend({

    debounce : function(fn, timeout, invokeAsap, ctx) {

        if(arguments.length == 3 && typeof invokeAsap != 'boolean') {
            ctx = invokeAsap;
            invokeAsap = false;
        }

        var timer;

        return function() {

            var args = arguments;
            ctx = ctx || this;

            invokeAsap && !timer && fn.apply(ctx, args);

            clearTimeout(timer);

            timer = setTimeout(function() {
                invokeAsap || fn.apply(ctx, args);
                timer = null;
            }, timeout);

        };

    },

    throttle : function(fn, timeout, ctx) {

        var timer, args, needInvoke;

        return function() {

            args = arguments;
            needInvoke = true;
            ctx = ctx || this;

            timer || (function() {
                if(needInvoke) {
                    fn.apply(ctx, args);
                    needInvoke = false;
                    timer = setTimeout(arguments.callee, timeout);
                }
                else {
                    timer = null;
                }
            })();

        };

    }

});

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: begin */ /**/
/**
 * Observable plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.0.0
 * @requires $.identify
 * @requires $.inherit
 */

(function($) {

var storageExpando = '__' + +new Date + 'storage',
    getFnId = function(fn, ctx) {
        return $.identify(fn) + (ctx? $.identify(ctx) : '');
    },
    Observable = /** @lends $.observable.prototype */{

        /**
         * Builds full event name
         * @protected
         * @param {String} e Event type
         * @returns {String}
         */
        buildEventName : function(e) {

            return e;

        },

        /**
         * Adding event handler
         * @param {String} e Event type
         * @param {Object} [data] Additional data that the handler gets as e.data
         * @param {Function} fn Handler
         * @param {Object} [ctx] Handler context
         * @returns {$.observable}
         */
        on : function(e, data, fn, ctx, _special) {

            if(typeof e == 'string') {
                if($.isFunction(data)) {
                    ctx = fn;
                    fn = data;
                    data = undefined;
                }

                var id = getFnId(fn, ctx),
                    storage = this[storageExpando] || (this[storageExpando] = {}),
                    eList = e.split(' '),
                    i = 0,
                    eStorage;

                while(e = eList[i++]) {
                    e = this.buildEventName(e);
                    eStorage = storage[e] || (storage[e] = { ids : {}, list : {} });

                    if(!(id in eStorage.ids)) {
                        var list = eStorage.list,
                            item = { fn : fn, data : data, ctx : ctx, special : _special };
                        if(list.last) {
                            list.last.next = item;
                            item.prev = list.last;
                        } else {
                            list.first = item;
                        }

                        eStorage.ids[id] = list.last = item;
                    }
                }
            } else {
                var _this = this;
                $.each(e, function(e, fn) {
                    _this.on(e, fn, data, _special);
                });
            }

            return this;

        },

        onFirst : function(e, data, fn, ctx) {

            return this.on(e, data, fn, ctx, { one : true });

        },

        /**
         * Removing event handler(s)
         * @param {String} [e] Event type
         * @param {Function} [fn] Handler
         * @param {Object} [ctx] Handler context
         * @returns {$.observable}
         */
        un : function(e, fn, ctx) {

            if(typeof e == 'string' || typeof e == 'undefined') {
                var storage = this[storageExpando];
                if(storage) {
                    if(e) { // if event type was passed
                        var eList = e.split(' '),
                            i = 0,
                            eStorage;
                        while(e = eList[i++]) {
                            e = this.buildEventName(e);
                            if(eStorage = storage[e]) {
                                if(fn) {  // if specific handler was passed
                                    var id = getFnId(fn, ctx),
                                        ids = eStorage.ids;
                                    if(id in ids) {
                                        var list = eStorage.list,
                                            item = ids[id],
                                            prev = item.prev,
                                            next = item.next;

                                        if(prev) {
                                            prev.next = next;
                                        }
                                        else if(item === list.first) {
                                            list.first = next;
                                        }

                                        if(next) {
                                            next.prev = prev;
                                        }
                                        else if(item === list.last) {
                                            list.last = prev;
                                        }

                                        delete ids[id];
                                    }
                                } else {
                                    delete this[storageExpando][e];
                                }
                            }
                        }
                    } else {
                        delete this[storageExpando];
                    }
                }
            } else {
                var _this = this;
                $.each(e, function(e, fn) {
                    _this.un(e, fn, ctx);
                });
            }

            return this;

        },

        /**
         * Fires event handlers
         * @param {String|$.Event} e Event
         * @param {Object} [data] Additional data
         * @returns {$.observable}
         */
        trigger : function(e, data) {

            var _this = this,
                storage = _this[storageExpando],
                rawType;

            typeof e === 'string'?
                e = $.Event(_this.buildEventName(rawType = e)) :
                e.type = _this.buildEventName(rawType = e.type);

            e.target || (e.target = _this);

            if(storage && (storage = storage[e.type])) {
                var item = storage.list.first,
                    ret;
                while(item) {
                    e.data = item.data;
                    ret = item.fn.call(item.ctx || _this, e, data);
                    if(typeof ret !== 'undefined') {
                        e.result = ret;
                        if(ret === false) {
                            e.preventDefault();
                            e.stopPropagation();
                        }
                    }

                    item.special && item.special.one &&
                        _this.un(rawType, item.fn, item.ctx);
                    item = item.next;
                }
            }

            return this;

        }

    };

$.observable = $.inherit(Observable, Observable);

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/i-bem.js: begin */ /**/
/** @requires jquery.inherit */
/** @requires jquery.isEmptyObject */
/** @requires jquery.identify */
/** @requires jquery.observable */

(function($, undefined) {

/**
 * Storage for deferred functions
 * @private
 * @type Array
 */
var afterCurrentEventFns = [],

/**
 * Storage for block declarations (hash by block name)
 * @private
 * @type Object
 */
    blocks = {},

/**
 * Communication channels
 * @static
 * @private
 * @type Object
 */
    channels = {};

/**
 * Builds the name of the handler method for setting a modifier
 * @static
 * @private
 * @param {String} elemName Element name
 * @param {String} modName Modifier name
 * @param {String} modVal Modifier value
 * @returns {String}
 */
function buildModFnName(elemName, modName, modVal) {

    return (elemName? '__elem_' + elemName : '') +
           '__mod' +
           (modName? '_' + modName : '') +
           (modVal? '_' + modVal : '');

}

/**
 * Transforms a hash of modifier handlers to methods
 * @static
 * @private
 * @param {Object} modFns
 * @param {Object} props
 * @param {String} [elemName]
 */
function modFnsToProps(modFns, props, elemName) {

    $.isFunction(modFns)?
        (props[buildModFnName(elemName, '*', '*')] = modFns) :
        $.each(modFns, function(modName, modFn) {
            $.isFunction(modFn)?
                (props[buildModFnName(elemName, modName, '*')] = modFn) :
                $.each(modFn, function(modVal, modFn) {
                    props[buildModFnName(elemName, modName, modVal)] = modFn;
                });
        });

}

function buildCheckMod(modName, modVal) {

    return modVal?
        Array.isArray(modVal)?
            function(block) {
                var i = 0, len = modVal.length;
                while(i < len)
                    if(block.hasMod(modName, modVal[i++]))
                        return true;
                return false;
            } :
            function(block) {
                return block.hasMod(modName, modVal);
            } :
        function(block) {
            return block.hasMod(modName);
        };

}

/** @namespace */
this.BEM = $.inherit($.observable, /** @lends BEM.prototype */ {

    /**
     * @class Base block for creating BEM blocks
     * @constructs
     * @private
     * @param {Object} mods Block modifiers
     * @param {Object} params Block parameters
     * @param {Boolean} [initImmediately=true]
     */
    __constructor : function(mods, params, initImmediately) {

        var _this = this;

        /**
         * Cache of block modifiers
         * @private
         * @type Object
         */
        _this._modCache = mods || {};

        /**
         * Current modifiers in the stack
         * @private
         * @type Object
         */
        _this._processingMods = {};

        /**
         * The block's parameters, taking into account the defaults
         * @protected
         * @type Object
         */
        _this._params = params; // это нужно для правильной сборки параметров у блока из нескольких нод
        _this.params = null;

        initImmediately !== false?
            _this._init() :
            _this.afterCurrentEvent(function() {
                _this._init();
            });

    },

    /**
     * Initializes the block
     * @private
     */
    _init : function() {

        if(!this._initing && !this.hasMod('js', 'inited')) {
            this._initing = true;

            this.params = $.extend(this.getDefaultParams(), this._params);
            delete this._params;

            this.setMod('js', 'inited');
            delete this._initing;
            this.trigger('init');
        }

        return this;

    },

    /**
     * Changes the context of the function being passed
     * @protected
     * @param {Function} fn
     * @param {Object} [ctx=this] Context
     * @returns {Function} Function with a modified context
     */
    changeThis : function(fn, ctx) {

        return fn.bind(ctx || this);

    },

    /**
     * Executes the function in the context of the block, after the "current event"
     * @protected
     * @param {Function} fn
     * @param {Object} [ctx] Context
     */
    afterCurrentEvent : function(fn, ctx) {

        this.__self.afterCurrentEvent(this.changeThis(fn, ctx));

    },

    /**
     * Executes the block's event handlers and live event handlers
     * @protected
     * @param {String} e Event name
     * @param {Object} [data] Additional information
     * @returns {BEM}
     */
    trigger : function(e, data) {

        this
            .__base(e = this.buildEvent(e), data)
            .__self.trigger(e, data);

        return this;

    },

    buildEvent : function(e) {

        typeof e == 'string' && (e = $.Event(e));
        e.block = this;

        return e;

    },

    /**
     * Checks whether a block or nested element has a modifier
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {Boolean}
     */
    hasMod : function(elem, modName, modVal) {

        var len = arguments.length,
            invert = false;

        if(len == 1) {
            modVal = '';
            modName = elem;
            elem = undefined;
            invert = true;
        }
        else if(len == 2) {
            if(typeof elem == 'string') {
                modVal = modName;
                modName = elem;
                elem = undefined;
            }
            else {
                modVal = '';
                invert = true;
            }
        }

        var res = this.getMod(elem, modName) === modVal;
        return invert? !res : res;

    },

    /**
     * Returns the value of the modifier of the block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @returns {String} Modifier value
     */
    getMod : function(elem, modName) {

        var type = typeof elem;
        if(type === 'string' || type === 'undefined') { // elem either omitted or undefined
            modName = elem || modName;
            var modCache = this._modCache;
            return modName in modCache?
                modCache[modName] :
                modCache[modName] = this._extractModVal(modName);
        }

        return this._getElemMod(modName, elem);

    },

    /**
     * Returns the value of the modifier of the nested element
     * @private
     * @param {String} modName Modifier name
     * @param {Object} elem Nested element
     * @param {Object} [elem] Nested element name
     * @returns {String} Modifier value
     */
    _getElemMod : function(modName, elem, elemName) {

        return this._extractModVal(modName, elem, elemName);

    },

    /**
     * Returns values of modifiers of the block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} [modName1, ..., modNameN] Modifier names
     * @returns {Object} Hash of modifier values
     */
    getMods : function(elem) {

        var hasElem = elem && typeof elem != 'string',
            _this = this,
            modNames = [].slice.call(arguments, hasElem? 1 : 0),
            res = _this._extractMods(modNames, hasElem? elem : undefined);

        if(!hasElem) { // caching
            modNames.length?
                modNames.forEach(function(name) {
                    _this._modCache[name] = res[name];
                }):
                _this._modCache = res;
        }

        return res;

    },

    /**
     * Sets the modifier for a block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @returns {BEM}
     */
    setMod : function(elem, modName, modVal) {

        if(typeof modVal == 'undefined') {
            modVal = modName;
            modName = elem;
            elem = undefined;
        }

        var _this = this;

        if(!elem || elem[0]) {

            var modId = (elem && elem[0]? $.identify(elem[0]) : '') + '_' + modName;

            if(this._processingMods[modId]) return _this;

            var elemName,
                curModVal = elem?
                    _this._getElemMod(modName, elem, elemName = _this.__self._extractElemNameFrom(elem)) :
                    _this.getMod(modName);

            if(curModVal === modVal) return _this;

            this._processingMods[modId] = true;

            var needSetMod = true,
                modFnParams = [modName, modVal, curModVal];

            elem && modFnParams.unshift(elem);

            [['*', '*'], [modName, '*'], [modName, modVal]].forEach(function(mod) {
                needSetMod = _this._callModFn(elemName, mod[0], mod[1], modFnParams) !== false && needSetMod;
            });

            !elem && needSetMod && (_this._modCache[modName] = modVal);

            needSetMod && _this._afterSetMod(modName, modVal, curModVal, elem, elemName);

            delete this._processingMods[modId];
        }

        return _this;

    },

    /**
     * Function after successfully changing the modifier of the block/nested element
     * @protected
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {String} oldModVal Old modifier value
     * @param {Object} [elem] Nested element
     * @param {String} [elemName] Element name
     */
    _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {},

    /**
     * Sets a modifier for a block/nested element, depending on conditions.
     * If the condition parameter is passed: when true, modVal1 is set; when false, modVal2 is set.
     * If the condition parameter is not passed: modVal1 is set if modVal2 was set, or vice versa.
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal1 First modifier value
     * @param {String} [modVal2] Second modifier value
     * @param {Boolean} [condition] Condition
     * @returns {BEM}
     */
    toggleMod : function(elem, modName, modVal1, modVal2, condition) {

        if(typeof elem == 'string') { // if this is a block
            condition = modVal2;
            modVal2 = modVal1;
            modVal1 = modName;
            modName = elem;
            elem = undefined;
        }
        if(typeof modVal2 == 'undefined') {
            modVal2 = '';
        } else if(typeof modVal2 == 'boolean') {
            condition = modVal2;
            modVal2 = '';
        }

        var modVal = this.getMod(elem, modName);
        (modVal == modVal1 || modVal == modVal2) &&
            this.setMod(
                elem,
                modName,
                typeof condition === 'boolean'?
                    (condition? modVal1 : modVal2) :
                    this.hasMod(elem, modName, modVal1)? modVal2 : modVal1);

        return this;

    },

    /**
     * Removes a modifier from a block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @returns {BEM}
     */
    delMod : function(elem, modName) {

        if(!modName) {
            modName = elem;
            elem = undefined;
        }

        return this.setMod(elem, modName, '');

    },

    /**
     * Executes handlers for setting modifiers
     * @private
     * @param {String} elemName Element name
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {Array} modFnParams Handler parameters
     */
    _callModFn : function(elemName, modName, modVal, modFnParams) {

        var modFnName = buildModFnName(elemName, modName, modVal);
        return this[modFnName]?
           this[modFnName].apply(this, modFnParams) :
           undefined;

    },

    /**
     * Retrieves the value of the modifier
     * @private
     * @param {String} modName Modifier name
     * @param {Object} [elem] Element
     * @returns {String} Modifier value
     */
    _extractModVal : function(modName, elem) {

        return '';

    },

    /**
     * Retrieves name/value for a list of modifiers
     * @private
     * @param {Array} modNames Names of modifiers
     * @param {Object} [elem] Element
     * @returns {Object} Hash of modifier values by name
     */
    _extractMods : function(modNames, elem) {

        return {};

    },

    /**
     * Returns a named communication channel
     * @param {String} [id='default'] Channel ID
     * @param {Boolean} [drop=false] Destroy the channel
     * @returns {$.observable|undefined} Communication channel
     */
    channel : function(id, drop) {

        return this.__self.channel(id, drop);

    },

    /**
     * Returns a block's default parameters
     * @returns {Object}
     */
    getDefaultParams : function() {

        return {};

    },

    /**
     * Helper for cleaning up block properties
     * @param {Object} [obj=this]
     */
    del : function(obj) {

        var args = [].slice.call(arguments);
        typeof obj == 'string' && args.unshift(this);
        this.__self.del.apply(this.__self, args);
        return this;

	},

    /**
     * Deletes a block
     */
    destruct : function() {}

}, /** @lends BEM */{

    _name : 'i-bem',

    /**
     * Storage for block declarations (hash by block name)
     * @static
     * @protected
     * @type Object
     */
    blocks : blocks,

    /**
     * Declares blocks and creates a block class
     * @static
     * @protected
     * @param {String|Object} decl Block name (simple syntax) or description
     * @param {String} decl.block|decl.name Block name
     * @param {String} [decl.baseBlock] Name of the parent block
     * @param {String} [decl.modName] Modifier name
     * @param {String} [decl.modVal] Modifier value
     * @param {Object} [props] Methods
     * @param {Object} [staticProps] Static methods
     */
    decl : function(decl, props, staticProps) {

        if(typeof decl == 'string')
            decl = { block : decl };
        else if(decl.name) {
            decl.block = decl.name;
        }

        if(decl.baseBlock && !blocks[decl.baseBlock])
            throw('baseBlock "' + decl.baseBlock + '" for "' + decl.block + '" is undefined');

        props || (props = {});

        if(props.onSetMod) {
            modFnsToProps(props.onSetMod, props);
            delete props.onSetMod;
        }

        if(props.onElemSetMod) {
            $.each(props.onElemSetMod, function(elemName, modFns) {
                modFnsToProps(modFns, props, elemName);
            });
            delete props.onElemSetMod;
        }

        var baseBlock = blocks[decl.baseBlock || decl.block] || this;

        if(decl.modName) {
            var checkMod = buildCheckMod(decl.modName, decl.modVal);
            $.each(props, function(name, prop) {
                $.isFunction(prop) &&
                    (props[name] = function() {
                        var method;
                        if(checkMod(this)) {
                            method = prop;
                        } else {
                            var baseMethod = baseBlock.prototype[name];
                            baseMethod && baseMethod !== props[name] &&
                                (method = this.__base);
                        }
                        return method?
                            method.apply(this, arguments) :
                            undefined;
                    });
            });
        }

        var block;
        decl.block == baseBlock._name?
            // makes a new "live" if the old one was already executed
            (block = $.inheritSelf(baseBlock, props, staticProps))._processLive(true) :
            (block = blocks[decl.block] = $.inherit(baseBlock, props, staticProps))._name = decl.block;

        return block;

    },

    /**
     * Processes a block's live properties
     * @private
     * @param {Boolean} [heedLive=false] Whether to take into account that the block already processed its live properties
     * @returns {Boolean} Whether the block is a live block
     */
    _processLive : function(heedLive) {

        return false;

    },

    /**
     * Factory method for creating an instance of the block named
     * @static
     * @param {String|Object} block Block name or description
     * @param {Object} [params] Block parameters
     * @returns {BEM}
     */
    create : function(block, params) {

        typeof block == 'string' && (block = { block : block });

        return new blocks[block.block](block.mods, params);

    },

    /**
     * Returns the name of the current block
     * @static
     * @protected
     * @returns {String}
     */
    getName : function() {

        return this._name;

    },

    /**
     * Retrieves the name of an element nested in a block
     * @static
     * @private
     * @param {Object} elem Nested element
     * @returns {String|undefined}
     */
    _extractElemNameFrom : function(elem) {},

    /**
     * Adds a function to the queue for executing after the "current event"
     * @static
     * @protected
     * @param {Function} fn
     * @param {Object} ctx
     */
    afterCurrentEvent : function(fn, ctx) {

        afterCurrentEventFns.push({ fn : fn, ctx : ctx }) == 1 &&
            setTimeout(this._runAfterCurrentEventFns, 0);

    },

    /**
     * Executes the queue
     * @private
     */
    _runAfterCurrentEventFns : function() {

        var fnsLen = afterCurrentEventFns.length;
        if(fnsLen) {
            var fnObj,
                fnsCopy = afterCurrentEventFns.splice(0, fnsLen);

            while(fnObj = fnsCopy.shift()) fnObj.fn.call(fnObj.ctx || this);
        }

    },

    /**
     * Changes the context of the function being passed
     * @protected
     * @param {Function} fn
     * @param {Object} ctx Context
     * @returns {Function} Function with a modified context
     */
    changeThis : function(fn, ctx) {

        return fn.bind(ctx || this);

    },

    /**
     * Helper for cleaning out properties
     * @param {Object} [obj=this]
     */
    del : function(obj) {

        var delInThis = typeof obj == 'string',
            i = delInThis? 0 : 1,
            len = arguments.length;
        delInThis && (obj = this);

        while(i < len) delete obj[arguments[i++]];

        return this;

	},

    /**
     * Returns/destroys a named communication channel
     * @param {String} [id='default'] Channel ID
     * @param {Boolean} [drop=false] Destroy the channel
     * @returns {$.observable|undefined} Communication channel
     */
    channel : function(id, drop) {

        if(typeof id == 'boolean') {
            drop = id;
            id = undefined;
        }

        id || (id = 'default');

        if(drop) {
            if(channels[id]) {
                channels[id].un();
                delete channels[id];
            }
            return;
        }

        return channels[id] || (channels[id] = new $.observable());

    }

});

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-bem/i-bem.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: begin */ /**/
(function() {

/**
 * Возвращает массив свойств объекта
 * @param {Object} obj объект
 * @returns {Array}
 */
Object.keys || (Object.keys = function(obj) {
    var res = [];

    for(var i in obj) obj.hasOwnProperty(i) &&
        res.push(i);

    return res;
});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: begin */ /**/
(function() {

var ptp = Array.prototype,
    toStr = Object.prototype.toString,
    methods = {

        /**
         * Finds the index of an element in an array
         * @param {Object} item
         * @param {Number} [fromIdx] Starting from index (length - 1 - fromIdx, if fromIdx < 0)
         * @returns {Number} Element index or -1, if not found
         */
        indexOf : function(item, fromIdx) {

            fromIdx = +(fromIdx || 0);

            var t = this, len = t.length;

            if(len > 0 && fromIdx < len) {
                fromIdx = fromIdx < 0? Math.ceil(fromIdx) : Math.floor(fromIdx);
                fromIdx < -len && (fromIdx = 0);
                fromIdx < 0 && (fromIdx = fromIdx + len);

                while(fromIdx < len) {
                    if(fromIdx in t && t[fromIdx] === item)
                        return fromIdx;
                    ++fromIdx;
                }
            }

            return -1;

        },

        /**
         * Calls the callback for each element
         * @param {Function} callback Called for each element
         * @param {Object} [ctx=null] Callback context
         */
        forEach : function(callback, ctx) {

            var i = -1, t = this, len = t.length;
            while(++i < len) i in t &&
                (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));

        },

        /**
         * Creates array B from array A so that B[i] = callback(A[i])
         * @param {Function} callback Called for each element
         * @param {Object} [ctx=null] Callback context
         * @returns {Array}
         */
        map : function(callback, ctx) {

            var i = -1, t = this, len = t.length,
                res = new Array(len);

            while(++i < len) i in t &&
                (res[i] = ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));

            return res;

        },

        /**
         * Creates an array containing only the elements from the source array that the callback returns true for. 
         * @param {Function} callback Called for each element
         * @param {Object} [ctx] Callback context
         * @returns {Array}
         */
        filter : function(callback, ctx) {

            var i = -1, t = this, len = t.length,
                res = [];

            while(++i < len) i in t &&
                (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)) && res.push(t[i]);

            return res;

        },

        /**
         * Wraps the array using an accumulator
         * @param {Function} callback Called for each element
         * @param {Object} [initialVal] Initial value of the accumulator
         * @returns {Object} Accumulator
         */
        reduce : function(callback, initialVal) {

            var i = -1, t = this, len = t.length,
                res;

            if(arguments.length < 2) {
                while(++i < len) {
                    if(i in t) {
                        res = t[i];
                        break;
                    }
                }
            }
            else {
                res = initialVal;
            }

            while(++i < len) i in t &&
                (res = callback(res, t[i], i, t));

            return res;

        },

        /**
         * Checks whether at least one element in the array meets the condition in the callback
         * @param {Function} callback
         * @param {Object} [ctx=this] Callback context
         * @returns {Boolean}
         */
        some : function(callback, ctx) {

            var i = -1, t = this, len = t.length;

            while(++i < len)
                if(i in t && (ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                    return true;

            return false;

        },

        /**
         * Checks whether every element in the array meets the condition in the callback
         * @param {Function} callback
         * @param {Object} [ctx=this] Context of the callback call
         * @returns {Boolean}
         */
        every : function(callback, ctx) {

            var i = -1, t = this, len = t.length;

            while(++i < len)
                if(i in t && !(ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                    return false;

            return true;

        }

    };

for(var name in methods)
    ptp[name] || (ptp[name] = methods[name]);

Array.isArray || (Array.isArray = function(obj) {
    return toStr.call(obj) === '[object Array]';
});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: begin */ /**/
(function() {

var slice = Array.prototype.slice;

Function.prototype.bind || (Function.prototype.bind = function(ctx) {

    var fn = this,
        args = slice.call(arguments, 1);

    return function () {
        return fn.apply(ctx, args.concat(slice.call(arguments)));
    }

});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: begin */ /**/
/** @fileOverview Module for internal BEM helpers */
/** @requires BEM */

(function(BEM, $, undefined) {

/**
 * Separator for modifiers and their values
 * @const
 * @type String
 */
var MOD_DELIM = '_',

/**
 * Separator between names of a block and a nested element
 * @const
 * @type String
 */
    ELEM_DELIM = '__',

/**
 * Pattern for acceptable element and modifier names
 * @const
 * @type String
 */
    NAME_PATTERN = '[a-zA-Z0-9-]+';

function buildModPostfix(modName, modVal, buffer) {

    buffer.push(MOD_DELIM, modName, MOD_DELIM, modVal);

}

function buildBlockClass(name, modName, modVal, buffer) {

    buffer.push(name);
    modVal && buildModPostfix(modName, modVal, buffer);

}

function buildElemClass(block, name, modName, modVal, buffer) {

    buildBlockClass(block, undefined, undefined, buffer);
    buffer.push(ELEM_DELIM, name);
    modVal && buildModPostfix(modName, modVal, buffer);

}

BEM.INTERNAL = {

    NAME_PATTERN : NAME_PATTERN,

    MOD_DELIM : MOD_DELIM,
    ELEM_DELIM : ELEM_DELIM,

    buildModPostfix : function(modName, modVal, buffer) {

        var res = buffer || [];
        buildModPostfix(modName, modVal, res);
        return buffer? res : res.join('');

    },

    /**
     * Builds the class of a block or element with a modifier
     * @private
     * @param {String} block Block name
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @param {Array} [buffer] Buffer
     * @returns {String|Array} Class or buffer string (depending on whether the buffer parameter is present)
     */
    buildClass : function(block, elem, modName, modVal, buffer) {

        var typeOf = typeof modName;
        if(typeOf == 'string') {
            if(typeof modVal != 'string') {
                buffer = modVal;
                modVal = modName;
                modName = elem;
                elem = undefined;
            }
        } else if(typeOf != 'undefined') {
            buffer = modName;
            modName = undefined;
        } else if(elem && typeof elem != 'string') {
            buffer = elem;
            elem = undefined;
        }

        if(!(elem || modName || buffer)) { // оптимизация для самого простого случая
            return block;
        }

        var res = buffer || [];

        elem?
            buildElemClass(block, elem, modName, modVal, res) :
            buildBlockClass(block, modName, modVal, res);

        return buffer? res : res.join('');

    },

    /**
     * Builds full classes for a buffer or element with modifiers
     * @private
     * @param {String} block Block name
     * @param {String} [elem] Element name
     * @param {Object} [mods] Modifiers
     * @param {Array} [buffer] Buffer
     * @returns {String|Array} Class or buffer string (depending on whether the buffer parameter is present)
     */
    buildClasses : function(block, elem, mods, buffer) {

        if(elem && typeof elem != 'string') {
            buffer = mods;
            mods = elem;
            elem = undefined;
        }

        var res = buffer || [];

        elem?
            buildElemClass(block, elem, undefined, undefined, res) :
            buildBlockClass(block, undefined, undefined, res);

        mods && $.each(mods, function(modName, modVal) {
            if(modVal) {
                res.push(' ');
                elem?
                    buildElemClass(block, elem, modName, modVal, res) :
                    buildBlockClass(block, modName, modVal, res);
            }
        });

        return buffer? res : res.join('');

        /*var typeOf = typeof elem;
        if(typeOf != 'string' && typeOf != 'undefined') {
            buffer = mods;
            mods = elem;
            elem = undefined;
        }
        if($.isArray(mods)) {
            buffer = mods;
            mods = undefined;
        }

        var res = buffer || [];
        buildClasses(block, elem, mods, res);
        return buffer? res : res.join('');*/

    }

}

})(BEM, jQuery);;
/* ../../lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: begin */ /**/
/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};;
/* ../../lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: end */ /**/

/* ../../lego/blocks-desktop/i-bem/html/i-bem__html.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.INTERNAL */
/** @requires jquery.stringify */

(function(BEM, $, undefined) {

var INTERNAL = BEM.INTERNAL,
    ELEM_DELIM = INTERNAL.ELEM_DELIM,
    SHORT_TAGS = { // хэш для быстрого определения, является ли тэг коротким
        area : 1, base : 1, br : 1, col : 1, command : 1, embed : 1, hr : 1, img : 1,
        input : 1, keygen : 1, link : 1, meta : 1, param : 1, source : 1, wbr : 1 },
    buildClass = INTERNAL.buildClass,
    buildClasses = INTERNAL.buildClasses,
    decls = {};

function addPropToDecl(decl, name, fn) {

    (decl[name] || (decl[name] = [])).unshift(fn);

}

function buildDeclFn(fn, desc) {

    return desc.modName?
        function(ctx) {
            (ctx._curBlock.mods || {})[desc.modName] === desc.modVal && fn(ctx);
        } :
        fn;

}

function join(a, b) {

    var isArrayB = $.isArray(b),
        res;

    $.isArray(a)?
        isArrayB? res = a.concat(b) : (res = a).push(b) :
        isArrayB? (res = b).unshift(a) : res = [a, b];

    return res;

}

var attrEscapes = { '\'' : '\\\'', '"': '\'', '&': '&amp;', '<': '&lt;', '>': '&gt;' },
    attrEscapesRE = /['"&<>]/g;
function escapeAttr(attrVal) {
    return attrVal.replace(attrEscapesRE, function(needToEscape) {
        return attrEscapes[needToEscape];
    });
}

/**
 * @namespace
 * @name BEM.HTML
 */
BEM.HTML = {

    /**
     * Декларация
     * @protected
     * @param {String|Object} decl имя блока (простой синтаксис) или описание
     * @param {String} decl.block имя блока
     * @param {String} [decl.modName] имя модификатора
     * @param {String} [decl.modVal] значение модификатора
     * @param {Object} props свойства
     */
    decl : function(desc, props) {

        typeof desc == 'string' && (desc = { block : desc });
        desc.name && (desc.block = desc.name);

        var decl = decls[desc.block] || (decls[desc.block] = {});

        props.onBlock && addPropToDecl(decl, '_block', buildDeclFn(props.onBlock, desc));

        if(props.onElem) {
            $.isFunction(props.onElem)?
                addPropToDecl(decl, '_elem', buildDeclFn(props.onElem, desc)) :
                $.each(props.onElem, function(elem, fn) {
                    addPropToDecl(decl, '_elem' + (elem === '*'? '' : ELEM_DELIM + elem), buildDeclFn(fn, desc));
                });
        }

    },

    /**
     * Строит HTML-представление
     * @param {Object|Array} params JSON-описание
     */
    build : function(params) {

        var builder = new this.Ctx(params);
        builder._buildAll();
        return builder._flush();

    },

    Ctx : $.inherit(/** @lends BEM.HTML.Ctx.prototype */{
        /**
         * @class Внутренний класс контекста билдера HTML-представления
         * @constructs
         * @param {Object|Array|String} params параметры
         */
        __constructor : function(params) {

            /**
             * буфер
             * @private
             * @type Array
             */
            this._buffer = [];

            /**
             * текущие параметры
             * @private
             * @type Object
             */
            this._params = params;

            /**
             * туннелированные параметры
             * @private
             * @type Object
             */
            this._tParams = null;

            this._tParamsChanges = null;

            /**
             * имя текущего блока
             * @private
             * @type String
             */
            this._curBlock = undefined;

        },

        /**
         * Возвращает позицию контекста
         * @returns {Number}
         */
        pos : function() {

            return this._params._pos;

        },

        /**
         * Проверяет, является ли текущий контекст первым
         * @returns {Boolean}
         */
        isFirst : function() {

            return this._params._pos === 1;

        },

        /**
         * Проверяет, является ли текущий контекст последним
         * @returns {Boolean}
         */
        isLast : function() {

            var params = this._params;
            return params._pos === params._siblingsCount;

        },

        /**
         * Возвращает/устанавливает параметры контекста
         * @param {Object} [params] параметры
         */
        params : function(params) {

            var _this = this;
            if(typeof params == 'undefined') return _this._params;

            _this._params = params;
            return _this;

        },

        /**
         * Возвращает/устанавливает один параметр контекста
         * @param {String} name имя параметра
         * @param {String} [val] значение параметра
         * @param {Boolean} [force=false] установить параметр независимо от его наличия в контексте
         * @param {Boolean} [needExtend=false] расширять параметр
         */
        param : function(name, val, force, needExtend) {

            var _this = this,
                params = _this._params;

            if(typeof val == 'undefined') return params[name];

            if(force || !(name in params)) {
                params[name] = val;
            } else if(needExtend) {
                params[name] = $.extend(val, params[name]);
            }

            return _this;

        },

        /**
         * Возвращает/устанавливает html-атрибуты контекста (шорткат к params('attrs', val))
         * @param {Object} [val] хэш атрибутов
         * @param {Boolean} [force=false]
         */
        attrs : function(val, force) {

            return this.param('attrs', val, force, true);

        },

        /**
         * Возвращает/устанавливает один html-атрибут контекста
         * @param {String} name имя атрибута
         * @param {String} [val] значение атрибута
         * @param {Boolean} [force=false]
         */
        attr : function(name, val, force) {

            var _this = this;
            if(typeof val == 'undefined') return (_this._params.attrs || {})[name];

            var attrs = _this._params.attrs;
            attrs?
                (force || !(name in attrs)) && (attrs[name] = val) :
                (_this._params.attrs = {})[name] = val;

            return _this;

        },

        /**
         * Возвращает/устанавливает имя html-тэга контекста (шорткат к params('tag', val))
         * @param {String} [val] тэг
         * @param {Boolean} [force=false]
         */
        tag : function(val, force) {

            return this.param('tag', val, force);

        },

        /**
         * Возвращает/устанавливает дополнительные CSS-классы контекста (шорткат к params('cls', val))
         * @param {String} [val] CSS-класс
         * @param {Boolean} [force=false]
         */
        cls : function(val, force) {

            return this.param('cls', val, force);

        },

        /**
         * Возвращает/устанавливает модификаторы контекста (шорткат к params('mods', val))
         * @param {Object} [val] хэш модификаторов
         * @param {Boolean} [force=false]
         */
        mods : function(val, force) {

            return this.param('mods', val, force, true);

        },

        /**
         * Возвращает/устанавливает один модификатор контекста
         * @param {String} name имя модификатора
         * @param {String} [val] значение модификатора
         * @param {Boolean} [force=false]
         */
        mod : function(name, val, force) {

            var _this = this;
            if(typeof val == 'undefined') return (_this._params.mods || {})[name];

            var mods = _this._params.mods;
            mods?
                (force || !(name in mods)) && (mods[name] = val) :
                (_this._params.mods = {})[name] = val;

            return _this;

        },

        /**
         * Возвращает/добавляет/устанавливает миксы
         * @param {Array} [val] миксы
         * @param {Boolean} [force=false]
         */
        mix : function(val, force) {

            var _this = this,
                params = _this._params;

            if(typeof val == 'undefined') return params.mix;

            if(force || !('mix' in params)) {
                params.mix = val;
            } else {
                params.mix = params.mix.concat(val);
            }

            return _this;

        },

        /**
         * Возвращает/устанавливает js-параметры контекста (шорткат к params('js', val))
         * @param {Boolean|Object} [val] параметры
         */
        js : function(val) {

            return this.param('js', val);

        },

        /**
         * Возвращает/устанавливает контент контекста (шорткат к params('content', val))
         * @param {String|Object|Array} [val] контент
         * @param {Boolean} [force=false] установить контент независимо от его наличия
         */
        content : function(val, force) {

            return this.param('content', val, force);

        },

        /**
         * Оборачивает контент контекста (например, другим элементом)
         * @param {Object} obj
         */
        wrapContent : function(obj) {

            var _this = this,
                params = _this._params;

            obj.content = params.content;
            params.content = obj;

            return _this;

        },

        /**
         * Добавляет контент перед контентом контекста (например, еще один элемент)
         * @param {Object|Array} obj
         */
        beforeContent : function(obj) {

            var _this = this,
                params = _this._params;

            params.content = join(obj, params.content);

            return _this;

        },

        /**
         * Добавляет контент после контента контекста (например, еще один элемент)
         * @param {Object|Array} obj
         */
        afterContent : function(obj) {

            var _this = this,
                params = _this._params;

            params.content = join(params.content, obj);

            return _this;

        },

        /**
         * Оборачивает контекста (например, другим элементом или блоком)
         * @param {Object} obj
         */
        wrap : function(obj) {

            var _this = this,
                params = _this._params;

            obj.block || (obj._curBlock = _this._curBlock);
            obj.content = params._wrapper? params._wrapper : params;
            params._wrapper = obj;

            return _this;

        },

        /**
         * Возвращает/устанавливает один туннелированный параметр контекста
         * @param {String} name имя параметра
         * @param {String} [val] значение параметра
         */
        tParam : function(name, val) {

            var _this = this,
                tParams = _this._tParams || (_this._tParams = {});

            if(typeof val == 'undefined') return tParams[name];

            var tParamsChanges = _this._tParamsChanges || (_this._tParamsChanges = {});

            name in tParamsChanges || (tParamsChanges[name] = tParams[name]);

            tParams[name] = val;

            return _this;

        },

        /**
         * Генерирует уникальный идентификатор
         * returns {String}
         */
        generateId : function() {

            return $.identify();

        },

        /**
         * Останавливает применение более базовых шаблонов
         */
        stop : function() {

            this._params._isStopped = true;

        },

        /**
         * Выполняет одну итерацию билда в зависимости от типа контекста
         * @private
         */
        _buildAll : function() {

            var _this = this,
                buffer = _this._buffer,
                params = _this._params,
                paramsType = typeof params;

            if(paramsType == 'string' || paramsType == 'number') {
                buffer.push(params);
            } else if($.isArray(params)) {
                var i = 0, len = params.length, currParams, currParamsType;
                while(i < len) {
                     _this._params = currParams = params[i++];
                    currParamsType = typeof currParams;
                    if(currParamsType == 'string' || currParamsType == 'number') {
                        buffer.push(currParams);
                    } else if(currParams) {
                        currParams._pos = i;
                        currParams._siblingsCount = len;
                        _this._buildByDecl();
                    }
                }
            } else if(params) {
                _this._params._pos = _this._params._siblingsCount = 1;
                _this._buildByDecl();
            }

        },

        /**
         * Дефолтный билд
         * @private
         */
        _build : function() {

            var _this = this,
                buffer = _this._buffer,
                params = _this._params,
                tag = params.tag || 'div',
                jsParams,
                isBEM = params.block || params.elem,
                curBlock = isBEM && (params.block || _this._curBlock.block),
                addInitingCls = false;

            if(params.js) {
                (jsParams = {})[buildClass(curBlock, params.elem)] = params.js === true? {} : params.js;
                addInitingCls = !params.elem;
            }

            buffer.push('<', tag);

            if(isBEM || params.cls) {
                buffer.push(' class="');
                if(isBEM) {
                    buildClasses(curBlock, params.elem, params.mods, buffer);
                    params.mix && $.each(params.mix, function(i, mix) {
                        if(mix) {
                            buffer.push(' ');
                            buildClasses(mix.block, mix.elem, mix.mods, buffer);
                            if(mix.js) {
                                (jsParams || (jsParams = {}))[buildClass(mix.block, mix.elem)] = mix.js === true? {} : mix.js;
                                addInitingCls || (addInitingCls = !mix.elem);
                            }
                        }
                    });
                }

                params.cls && buffer.push(isBEM? ' ' : '', params.cls);

                addInitingCls && buffer.push(' i-bem');
                buffer.push('"');
            }

            jsParams && buffer.push(
                ' onclick="return ',
                escapeAttr(JSON.stringify(jsParams)),
                '"');

            params.attrs && $.each(params.attrs, function(name, val) {
                typeof val != 'undefined' && val !== null && val !== false && buffer.push(
                    ' ',
                    name,
                    '="',
                    val.toString().replace(/"/g, "&quot;"),
                    '"');
            });

            if(SHORT_TAGS[tag]) {
                buffer.push('/>');
            } else {
                buffer.push('>');

                if(typeof params.content != 'undefined') {
                    _this._params = params.content;
                    _this._buildAll();
                }

                buffer.push('</', tag, '>');
            }

        },

        /**
         * Очищает буфер и возвращает его содержимое
         * @private
         * @returns {String} содержимое буфера
         */
        _flush : function() {

            var res = this._buffer.join('');
            delete this._buffer;
            return res;

        },

        _buildByDecl : function() {

            var _this = this,
                currBlock = _this._curBlock,
                params = _this._params;

            params._curBlock && (_this._curBlock = params._curBlock);
            params.block && (_this._curBlock = params);

            if(!params._wrapper) {
                if(params.block || params.elem) {
                    var decl = decls[_this._curBlock.block];
                    if(decl) {
                        var fns;
                        if(params.elem) {
                            fns = decl['_elem' + ELEM_DELIM + params.elem];
                            decl._elem && (fns = (fns? fns.concat(decl._elem) : decl._elem));
                        } else {
                            fns = decl._block;
                        }

                        if(fns) {
                            var i = 0, fn;
                            while(fn = fns[i++]) {
                                fn(_this);
                                if(params._isStopped) break;
                            }
                        }
                    }
                }

                if(params._wrapper) {
                    params._curBlock = _this._curBlock;
                    _this._params = params._wrapper;
                    return _this._buildAll();
                }
            }

            var tParamsChanges = _this._tParamsChanges;
                _this._tParamsChanges = null;

            _this._build();

            _this._curBlock = currBlock;

            if(tParamsChanges) {
                var tParams = _this._tParams;
                $.each(tParamsChanges, function(name, val) {
                    typeof val == 'undefined'?
                        delete tParams[name] :
                        tParams[name] = val;
                });
            }

        }

    })

};

})(BEM, jQuery);
;
/* ../../lego/blocks-desktop/i-bem/html/i-bem__html.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: begin */ /**/
(function(undefined) {

if(window.JSON) return;

var _toString = Object.prototype.toString,
    escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
    meta = {
        '\b' : '\\b',
        '\t' : '\\t',
        '\n' : '\\n',
        '\f' : '\\f',
        '\r' : '\\r',
        '"'  : '\\"',
        '\\' : '\\\\'
    },
    stringify;

window.JSON = {
    stringify : stringify = function(val) {
        if(val === null) {
            return 'null';
        }
        if(typeof val === 'undefined') {
            return undefined;
        }
        switch(_toString.call(val)) {
            case '[object String]':
                return '"' +
                    (escapable.test(val)?
                        val.replace(escapable, function(a) {
                            var c = meta[a];
                            return typeof c === 'string'? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                        }) :
                        val) +
                    '"';
            case '[object Number]':
            case '[object Boolean]':
                return '' + val;
            case '[object Array]':
                var res = '[', i = 0, len = val.length, strVal;
                while(i < len) {
                    strVal = stringify(val[i]);
                    res += (i++? ',' : '') + (typeof strVal === 'undefined'? 'null' : strVal);
                }
                return res + ']';
            case '[object Object]':
                var res = '{', i = 0, strVal;
                for(var key in val) {
                    if(val.hasOwnProperty(key)) {
                        strVal = stringify(val[key]);
                        typeof strVal !== 'undefined' && (res += (i++? ',' : '') + '"' + key + '":' + strVal);
                    }
                }
                return res + '}';
            default:
                return undefined;
        }
    }
};
})();
;
/* ../../lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.INTERNAL */

(function(BEM, $, undefined) {

var win = $(window),
    doc = $(document),

/**
 * Storage for DOM elements by unique key
 * @private
 * @type Object
 */
    uniqIdToDomElems = {},

/**
 * Storage for blocks by unique key
 * @static
 * @private
 * @type Object
 */
    uniqIdToBlock = {},

/**
 * Storage for block parameters
 * @private
 * @type Object
 */
    domElemToParams = {},

/**
 * Storage for liveCtx event handlers 
 * @private
 * @type Object
 */
    liveEventCtxStorage = {},

/**
 * Storage for liveClass event handlers
 * @private
 * @type Object
 */
    liveClassEventStorage = {},

    blocks = BEM.blocks,

    INTERNAL = BEM.INTERNAL,

    NAME_PATTERN = INTERNAL.NAME_PATTERN,

    MOD_DELIM = INTERNAL.MOD_DELIM,
    ELEM_DELIM = INTERNAL.ELEM_DELIM,

    buildModPostfix = INTERNAL.buildModPostfix,
    buildClass = INTERNAL.buildClass;

/**
 * Initializes blocks on a DOM element
 * @private
 * @param {jQuery} domElem DOM element
 * @param {String} uniqInitId ID of the "initialization wave"
 */
function init(domElem, uniqInitId) {

    var domNode = domElem[0];
    $.each(getParams(domNode), function(blockName, params) {
        processParams(params, domNode, blockName, uniqInitId);
        var block = uniqIdToBlock[params.uniqId];
        if(block) {
            if(block.domElem.index(domNode) < 0) {
                block.domElem = block.domElem.add(domElem);
                $.extend(block._params, params);
            }
        } else {
            initBlock(blockName, domElem, params);
        }
    });

}

/**
 * Initializes a specific block on a DOM element, or returns the existing block if it was already created
 * @private
 * @param {String} blockName Block name
 * @param {jQuery} domElem DOM element
 * @param {Object} [params] Initialization parameters
 * @param {Boolean} [forceLive] Force live initialization
 * @param {Function} [callback] Handler to call after complete initialization
 */
function initBlock(blockName, domElem, params, forceLive, callback) {

    if(typeof params == 'boolean') {
        callback = forceLive;
        forceLive = params;
        params = undefined;
    }

    var domNode = domElem[0];
    params = processParams(params || getParams(domNode)[blockName], domNode, blockName);

    var uniqId = params.uniqId;
    if(uniqIdToBlock[uniqId]) {
        return uniqIdToBlock[uniqId]._init();
    }

    uniqIdToDomElems[uniqId] = uniqIdToDomElems[uniqId]?
        uniqIdToDomElems[uniqId].add(domElem) :
        domElem;

    var parentDomNode = domNode.parentNode;
    if(!parentDomNode || parentDomNode.nodeType === 11) { // jquery doesn't unique disconnected node
        $.unique(uniqIdToDomElems[uniqId]);
    }

    var blockClass = blocks[blockName] || DOM.decl(blockName, {}, { live : true });
    if(!(blockClass._liveInitable = !!blockClass._processLive()) || forceLive || params.live === false) {
        var block = new blockClass(uniqIdToDomElems[uniqId], params, !!forceLive);
        delete uniqIdToDomElems[uniqId];
        callback && callback.apply(block, Array.prototype.slice.call(arguments, 4));
        return block;
    }

}

/**
 * Processes and adds necessary block parameters
 * @private
 * @param {Object} params Initialization parameters
 * @param {HTMLElement} domNode DOM node
 * @param {String} blockName Block name
 * @param {String} [uniqInitId] ID of the "initialization wave"
 */
function processParams(params, domNode, blockName, uniqInitId) {

    (params || (params = {})).uniqId ||
        (params.uniqId = (params.id? blockName + '-id-' + params.id : $.identify()) + (uniqInitId || $.identify()));

    var domUniqId = $.identify(domNode),
        domParams = domElemToParams[domUniqId] || (domElemToParams[domUniqId] = {});

    domParams[blockName] || (domParams[blockName] = params);

    return params;

}

/**
 * Helper for searching for a DOM element using a selector inside the context, including the context itself
 * @private
 * @param {jQuery} ctx Context
 * @param {String} selector CSS selector
 * @param {Boolean} [excludeSelf=false] Exclude context from search
 * @returns {jQuery}
 */
function findDomElem(ctx, selector, excludeSelf) {

    var res = ctx.find(selector);
    return excludeSelf?
       res :
       res.add(ctx.filter(selector));

}

/**
 * Returns parameters of a block's DOM element
 * @private
 * @param {HTMLElement} domNode DOM node
 * @returns {Object}
 */
function getParams(domNode) {

    var uniqId = $.identify(domNode);
    return domElemToParams[uniqId] ||
           (domElemToParams[uniqId] = extractParams(domNode));

}

/**
 * Retrieves block parameters from a DOM element
 * @private
 * @param {HTMLElement} domNode DOM node
 * @returns {Object}
 */
function extractParams(domNode) {

    var fn = domNode.onclick || domNode.ondblclick;
    if(!fn && domNode.tagName.toLowerCase() == 'body') { // LEGO-2027 in FF onclick doesn't work on body
        var elem = $(domNode),
            attr = elem.attr('onclick') || elem.attr('ondblclick');
        attr && (fn = Function(attr));
    }
    return fn? fn() : {};

}

/**
 * Cleans up all the BEM storages associated with a DOM node
 * @private
 * @param {HTMLElement} domNode DOM node
 */
function cleanupDomNode(domNode) {

    delete domElemToParams[$.identify(domNode)];

}

/**
 * Uncople DOM node from the block. If this is the last node, then destroys the block.
 * @private
 * @param {BEM.DOM} block block
 * @param {HTMLElement} domNode DOM node
 */
function removeDomNodeFromBlock(block, domNode) {

    block.domElem.length === 1?
        block.destruct(true) :
        block.domElem = block.domElem.not(domNode);

}

/**
 * Returns a DOM node for calculating the window size in IE
 * @returns {HTMLElement}
 */
function getClientNode() {

    return doc[0][$.support.boxModel? 'documentElement' : 'body'];

}

/**
 * Returns a block on a DOM element and initializes it if necessary 
 * @param {String} blockName Block name
 * @param {Object} params Block parameters
 * @returns {BEM}
 */
$.fn.bem = function(blockName, params) {
    return initBlock(blockName, this, params, true);
};

/**
 * @namespace
 * @name BEM.DOM
 */
var DOM = BEM.DOM = BEM.decl('i-bem__dom',/** @lends BEM.DOM.prototype */{
    /**
     * @class Base block for creating BEM blocks that have DOM representation 
     * @constructs
     * @private
     * @param {jQuery} domElem DOM element that the block is created on
     * @param {Object} params Block parameters
     * @param {Boolean} [initImmediately=true]
     */
    __constructor : function(domElem, params, initImmediately) {

        var _this = this;

        /**
         * Block's DOM elements
         * @protected
         * @type jQuery
         */
        _this.domElem = domElem;

        /**
         * Cache for names of events on DOM elements
         * @private
         * @type Object
         */
        _this._eventNameCache = {};

        /**
         * Cache for elements
         * @private
         * @type Object
         */
        _this._elemCache = {};

        /**
         * Unique block ID
         * @private
         * @type String
         */
        uniqIdToBlock[_this._uniqId = params.uniqId || $.identify(_this)] = _this;

        /**
         * Flag for whether it's necessary to unbind from the document and window when destroying the block
         * @private
         * @type Boolean
         */
        _this._needSpecialUnbind = false;

        _this.__base(null, params, initImmediately);

    },

    /**
     * Finds blocks inside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksInside : function(elem, block) {

        return this._findBlocks('find', elem, block);

    },

    /**
     * Finds the first block inside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockInside : function(elem, block) {

        return this._findBlocks('find', elem, block, true);

    },

    /**
     * Finds blocks outside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksOutside : function(elem, block) {

        return this._findBlocks('parents', elem, block);

    },

    /**
     * Finds the first block outside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockOutside : function(elem, block) {

        return this._findBlocks('closest', elem, block)[0] || null;

    },

    /**
     * Finds blocks on DOM elements of the current block or its elements
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksOn : function(elem, block) {

        return this._findBlocks('', elem, block);

    },

    /**
     * Finds the first block on DOM elements of the current block or its elements
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockOn : function(elem, block) {

        return this._findBlocks('', elem, block, true);

    },

    _findBlocks : function(select, elem, block, onlyFirst) {

        if(!block) {
            block = elem;
            elem = undefined;
        }

        var ctxElem = elem?
                (typeof elem == 'string'? this.findElem(elem) : elem) :
                this.domElem,
            isSimpleBlock = typeof block == 'string',
            blockName = isSimpleBlock? block : (block.block || block.blockName),
            selector = '.' +
                (isSimpleBlock?
                    buildClass(blockName) :
                    buildClass(blockName, block.modName, block.modVal)) +
                (onlyFirst? ':first' : ''),
            domElems = ctxElem.filter(selector);

        select && (domElems = domElems.add(ctxElem[select](selector)));

        if(onlyFirst) {
            return domElems[0]? initBlock(blockName, domElems.eq(0), true) : null;
        }

        var res = [],
            uniqIds = {};

        $.each(domElems, function(i, domElem) {
            var block = initBlock(blockName, $(domElem), true);
            if(!uniqIds[block._uniqId]) {
                uniqIds[block._uniqId] = true;
                res.push(block);
            }
        });

        return res;

    },

    /**
     * Adds an event handler for any DOM element
     * @protected
     * @param {jQuery} domElem DOM element where the event will be listened for
     * @param {String|Object} event Event name or event object
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToDomElem : function(domElem, event, fn) {

        var _this = this;

        fn?
            domElem.bind(
                _this._buildEventName(event),
                function(e) {
                    (e.data || (e.data = {})).domElem = $(this);
                    return fn.apply(_this, arguments);
                }
            ) :
            $.each(event, function(event, fn) {
                _this.bindToDomElem(domElem, event, fn);
            });

        return _this;

    },

    /**
     * Adds an event handler to the document
     * @protected
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToDoc : function(event, fn) {

        this._needSpecialUnbind = true;
        return this.bindToDomElem(doc, event, fn);

    },

    /**
     * Adds an event handler to the window
     * @protected
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToWin : function(event, fn) {

        this._needSpecialUnbind = true;
        return this.bindToDomElem(win, event, fn);

    },

    /**
     * Adds an event handler to the block's main DOM elements or its nested elements
     * @protected
     * @param {jQuery|String} [elem] Element
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindTo : function(elem, event, fn) {

        if(!event || $.isFunction(event)) { // if there is no element
            fn = event;
            event = elem;
            elem = this.domElem;
        } else if(typeof elem == 'string') {
            elem = this.elem(elem);
        }

        return this.bindToDomElem(elem, event, fn);

    },

    /**
     * Removes event handlers from any DOM element
     * @protected
     * @param {jQuery} domElem DOM element where the event was being listened for
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromDomElem : function(domElem, event) {

        domElem.unbind(this._buildEventName(event));
        return this;

    },

    /**
     * Removes event handler from document
     * @protected
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromDoc : function(event) {

        return this.unbindFromDomElem(doc, event);

    },

    /**
     * Removes event handler from window
     * @protected
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromWin : function(event) {

        return this.unbindFromDomElem(win, event);

    },

    /**
     * Removes event handlers from the block's main DOM elements or its nested elements
     * @protected
     * @param {jQuery|String} [elem] Nested element
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFrom : function(elem, event) {

        if(!event) {
            event = elem;
            elem = this.domElem;
        } else if(typeof elem == 'string') {
            elem = this.elem(elem);
        }

        return this.unbindFromDomElem(elem, event);

    },

    /**
     * Builds a full name for an event
     * @private
     * @param {String} event Event name
     * @returns {String}
     */
    _buildEventName : function(event) {

        var _this = this;
        return event.indexOf(' ') > 1?
            event.split(' ').map(function(e) {
                return _this._buildOneEventName(e);
            }).join(' ') :
            _this._buildOneEventName(event);

    },

    /**
     * Builds a full name for a single event
     * @private
     * @param {String} event Event name
     * @returns {String}
     */
    _buildOneEventName : function(event) {

        var _this = this,
            eventNameCache = _this._eventNameCache;

        if(event in eventNameCache) return eventNameCache[event];

        var uniq = '.' + _this._uniqId;

        if(event.indexOf('.') < 0) return eventNameCache[event] = event + uniq;

        var lego = '.bem_' + _this.__self._name;

        return eventNameCache[event] = event.split('.').map(function(e, i) {
            return i == 0? e + lego : lego + '_' + e;
        }).join('') + uniq;

    },

    /**
     * Triggers block event handlers and live event handlers
     * @protected
     * @param {String} e Event name
     * @param {Object} [data] Additional information
     * @returns {BEM}
     */
    trigger : function(e, data) {

        this
            .__base(e = this.buildEvent(e), data)
            .domElem && this._ctxTrigger(e, data);

        return this;

    },

    _ctxTrigger : function(e, data) {

        var _this = this,
            storage = liveEventCtxStorage[_this.__self._buildCtxEventName(e.type)],
            ctxIds = {};

        storage && _this.domElem.each(function() {
            var ctx = this,
                counter = storage.counter;
            while(ctx && counter) {
                var ctxId = $.identify(ctx, true);
                if(ctxId) {
                    if(ctxIds[ctxId]) break;
                    var storageCtx = storage.ctxs[ctxId];
                    if(storageCtx) {
                        $.each(storageCtx, function(uniqId, handler) {
                            handler.fn.call(
                                handler.ctx || _this,
                                e,
                                data);
                        });
                        counter--;
                    }
                    ctxIds[ctxId] = true;
                }
                ctx = ctx.parentNode;
            }
        });

    },

    /**
     * Sets a modifier for a block/nested element
     * @protected
     * @param {jQuery} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @returns {BEM}
     */
    setMod : function(elem, modName, modVal) {

        if(elem && typeof modVal != 'undefined' && elem.length > 1) {
            var _this = this;
            elem.each(function() {
                var item = $(this);
                item.__bemElemName = elem.__bemElemName;
                _this.setMod(item, modName, modVal);
            });
            return _this;
        }
        return this.__base(elem, modName, modVal);

    },

    /**
     * Retrieves modifier value from the DOM node's CSS class
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery} [elem] Nested element
     * @param {String} [elemName] Name of the nested element
     * @returns {String} Modifier value
     */
    _extractModVal : function(modName, elem, elemName) {

        var domNode = (elem || this.domElem)[0],
            matches;

        domNode &&
            (matches = domNode.className
                .match(this.__self._buildModValRE(modName, elemName || elem)));

        return matches? matches[2] : '';

    },

    /**
     * Retrieves a name/value list of modifiers
     * @private
     * @param {Array} [modNames] Names of modifiers
     * @param {Object} [elem] Element
     * @returns {Object} Hash of modifier values by names
     */
    _extractMods : function(modNames, elem) {

        var res = {},
            extractAll = !modNames.length,
            countMatched = 0;

        ((elem || this.domElem)[0].className
            .match(this.__self._buildModValRE(
                '(' + (extractAll? NAME_PATTERN : modNames.join('|')) + ')',
                elem,
                'g')) || []).forEach(function(className) {
                    var iModVal = (className = className.trim()).lastIndexOf(MOD_DELIM),
                        iModName = className.substr(0, iModVal - 1).lastIndexOf(MOD_DELIM);
                    res[className.substr(iModName + 1, iModVal - iModName - 1)] = className.substr(iModVal + 1);
                    ++countMatched;
                });

        // empty modifier values are not reflected in classes; they must be filled with empty values
        countMatched < modNames.length && modNames.forEach(function(modName) {
            modName in res || (res[modName] = '');
        });

        return res;

    },

    /**
     * Sets a modifier's CSS class for a block's DOM element or nested element
     * @private
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {String} oldModVal Old modifier value
     * @param {jQuery} [elem] Element
     * @param {String} [elemName] Element name
     */
    _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {

        var _self = this.__self,
            classPrefix = _self._buildModClassPrefix(modName, elemName),
            classRE = _self._buildModValRE(modName, elemName),
            needDel = modVal === '';

        (elem || this.domElem).each(function() {
            var className = this.className;
            className.indexOf(classPrefix) > -1?
                this.className = className.replace(
                    classRE,
                    (needDel? '' : '$1' + classPrefix + modVal) + '$3') :
                needDel || $(this).addClass(classPrefix + modVal);
        });

        elemName && this
            .dropElemCache(elemName, modName, oldModVal)
            .dropElemCache(elemName, modName, modVal);

    },

    /**
     * Finds elements nested in a block
     * @protected
     * @param {String|jQuery} [ctx=this.domElem] Element where search is being performed
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    findElem : function(ctx, names, modName, modVal) {

        if(arguments.length % 2) { // if the number of arguments is one or three
            modVal = modName;
            modName = names;
            names = ctx;
            ctx = this.domElem;
        } else if(typeof ctx == 'string') {
            ctx = this.findElem(ctx);
        }

        var _self = this.__self,
            selector = '.' +
                names.split(' ').map(function(name) {
                    return buildClass(_self._name, name, modName, modVal);
                }).join(',.');
        return findDomElem(ctx, selector);

    },

    /**
     * Finds elements nested in a block
     * @protected
     * @param {String} name Nested element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    _elem : function(name, modName, modVal) {

        var key = name + buildModPostfix(modName, modVal),
            res;

        if(!(res = this._elemCache[key])) {
            res = this._elemCache[key] = this.findElem(name, modName, modVal);
            res.__bemElemName = name;
        }

        return res;

    },

    /**
     * Lazy search for elements nested in a block (caches results)
     * @protected
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    elem : function(names, modName, modVal) {

        if(modName && typeof modName != 'string') {
            modName.__bemElemName = names;
            return modName;
        }

        if(names.indexOf(' ') < 0) {
            return this._elem(names, modName, modVal);
        }

        var res = $([]),
            _this = this;
        names.split(' ').forEach(function(name) {
            res = res.add(_this._elem(name, modName, modVal));
        });
        return res;

    },

    /**
     * Clearing the cache for elements
     * @protected
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {BEM}
     */
    dropElemCache : function(names, modName, modVal) {

        if(names) {
            var _this = this,
                modPostfix = buildModPostfix(modName, modVal);
            names.indexOf(' ') < 0?
                delete _this._elemCache[names + modPostfix] :
                names.split(' ').forEach(function(name) {
                    delete _this._elemCache[name + modPostfix];
                });
        } else {
            this._elemCache = {};
        }

        return this;

    },

    /**
     * Retrieves parameters of a block element
     * @param {String|jQuery} elem Element
     * @returns {Object} Parameters
     */
    elemParams : function(elem) {

        var elemName;
        if(typeof elem ==  'string') {
            elemName = elem;
            elem = this.elem(elem);
        } else {
            elemName = this.__self._extractElemNameFrom(elem);
        }

        return extractParams(elem[0])[buildClass(this.__self.getName(), elemName)] || {};

    },

    /**
     * Checks whether a DOM element is in a block
     * @protected
     * @param {jQuery} domElem DOM element
     * @returns {Boolean}
     */
    containsDomElem : function(domElem) {

        var res = false;

        this.domElem.each(function() {
            return !(res = domElem.parents().andSelf().index(this) > -1);
        });

        return res;

    },

    /**
     * Builds a CSS selector corresponding to a block/element and modifier
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {String}
     */
    buildSelector : function(elem, modName, modVal) {

        return this.__self.buildSelector(elem, modName, modVal);

    },

    /**
     * Deletes a block
     * @param {Boolean} [keepDOM=false] Whether to keep the block's DOM nodes in the document
     */
    destruct : function(keepDOM) {

        var _this = this,
            _self = _this.__self;

        _this._isDestructing = true;

        _this._needSpecialUnbind && _self.doc.add(_self.win).unbind('.' + _this._uniqId);

        _this.dropElemCache().domElem.each(function(i, domNode) {
            var params = getParams(domNode);
            $.each(params, function(blockName, blockParams) {
                var block = uniqIdToBlock[blockParams.uniqId];
                if(block) {
                    if(!block._isDestructing) {
                        removeDomNodeFromBlock(block, domNode);
                        delete params[blockName];
                    }
                }
                else {
                    delete uniqIdToDomElems[blockParams.uniqId];
                }
            });
            $.isEmptyObject(params) && cleanupDomNode(domNode);
        });

        keepDOM || _this.domElem.remove();

        delete uniqIdToBlock[_this.un()._uniqId];
        delete _this.domElem;
        delete _this._elemCache;

        _this.__base();

    }

}, /** @lends BEM.DOM */{

    /**
     * Document shortcut
     * @protected
     * @type jQuery
     */
    doc : doc,

    /**
     * Window shortcut
     * @protected
     * @type jQuery
     */
    win : win,

    /**
     * Processes a block's live properties
     * @private
     * @param {Boolean} [heedLive=false] Whether to take into account that the block already processed its live properties
     * @returns {Boolean} Whether the block is a live block
     */
    _processLive : function(heedLive) {

        var _this = this,
            res = _this._liveInitable;

        if('live' in _this) {
            var noLive = typeof res == 'undefined';

            if(noLive ^ heedLive) {
                if($.isFunction(_this.live)) {
                    res = _this.live() !== false;
                    _this.live = function() {};
                } else {
                    res = _this.live;
                }
            }
        }

        return res;

    },

    /**
     * Initializes blocks on a fragment of the DOM tree
     * @static
     * @protected
     * @param {jQuery} [ctx=document] Root DOM node
     * @returns {jQuery} ctx Initialization context
     */
    init : function(ctx, callback, callbackCtx) {

        if(!ctx || $.isFunction(ctx)) {
            callbackCtx = callback;
            callback = ctx;
            ctx = doc;
        }

        var uniqInitId = $.identify();
        findDomElem(ctx, '.i-bem').each(function() {
            init($(this), uniqInitId);
        });

        callback && this.afterCurrentEvent(
            function() {
                callback.call(callbackCtx || this, ctx);
            });

        // makes initialization completely synchronous
        this._runAfterCurrentEventFns();

        return ctx;

    },

    /**
     * Destroys blocks on a fragment of the DOM tree
     * @static
     * @protected
     * @param {Boolean} [keepDOM=false] Whether to keep DOM nodes in the document
     * @param {jQuery} ctx Root DOM node
     * @param {Boolean} [excludeSelf=false] Exclude the context
     */
    destruct : function(keepDOM, ctx, excludeSelf) {

        if(typeof keepDOM != 'boolean') {
            excludeSelf = ctx;
            ctx = keepDOM;
            keepDOM = undefined;
        }

        findDomElem(ctx, '.i-bem', excludeSelf).each(function(i, domNode) {
            var params = getParams(this);
            $.each(params, function(blockName, blockParams) {
                if(blockParams.uniqId) {
                    var block = uniqIdToBlock[blockParams.uniqId];
                    if(block) {
                        removeDomNodeFromBlock(block, domNode);
                        delete params[blockName];
                    }
                    else {
                        delete uniqIdToDomElems[blockParams.uniqId];
                    }
                }
            });
            $.isEmptyObject(params) && cleanupDomNode(this);
        });
        keepDOM || (excludeSelf? ctx.empty() : ctx.remove());

    },

    /**
     * Replaces a fragment of the DOM tree inside the context, destroying old blocks and intializing new ones
     * @static
     * @protected
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content New content
     * @param {Function} [callback] Handler to be called after initialization
     * @param {Object} [callbackCtx] Handler's context
     */
    update : function(ctx, content, callback, callbackCtx) {

        this.destruct(ctx, true);
        this.init(ctx.html(content), callback, callbackCtx);

    },

    /**
     * Adds a fragment of the DOM tree at the end of the context and initializes blocks
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content Content to be added
     */
    append : function(ctx, content) {

        this.init($(content).appendTo(ctx));

    },

    /**
     * Adds a fragment of the DOM tree at the beginning of the context and initializes blocks
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content Content to be added
     */
    prepend : function(ctx, content) {

        this.init($(content).prependTo(ctx));

    },

    /**
     * Adds a fragment of the DOM tree before the context and initializes blocks
     * @param {jQuery} ctx Contextual DOM node
     * @param {jQuery|String} content Content to be added
     */
    before : function(ctx, content) {

        this.init($(content).insertBefore(ctx));

    },

    /**
     * Adds a fragment of the DOM tree after the context and initializes blocks
     * @param {jQuery} ctx Contextual DOM node
     * @param {jQuery|String} content Content to be added
     */
    after : function(ctx, content) {

        this.init($(content).insertAfter(ctx));

    },

    /**
     * Builds a full name for a live event
     * @static
     * @private
     * @param {String} e Event name
     * @returns {String}
     */
    _buildCtxEventName : function(e) {

        return this._name + ':' + e;

    },

    _liveClassBind : function(className, e, callback, invokeOnInit) {

        var _this = this;
        if(e.indexOf(' ') > -1) {
            e.split(' ').forEach(function(e) {
                _this._liveClassBind(className, e, callback, invokeOnInit);
            });
        }
        else {
            var storage = liveClassEventStorage[e],
                uniqId = $.identify(callback);

            if(!storage) {
                storage = liveClassEventStorage[e] = {};
                doc.bind(e, _this.changeThis(_this._liveClassTrigger, _this));
            }

            storage = storage[className] || (storage[className] = { uniqIds : {}, fns : [] });

            if(!(uniqId in storage.uniqIds)) {
                storage.fns.push({ uniqId : uniqId, fn : _this._buildLiveEventFn(callback, invokeOnInit) });
                storage.uniqIds[uniqId] = storage.fns.length - 1;
            }
        }

        return this;

    },

    _liveClassUnbind : function(className, e, callback) {

        var storage = liveClassEventStorage[e];
        if(storage) {
            if(callback) {
                if(storage = storage[className]) {
                    var uniqId = $.identify(callback);
                    if(uniqId in storage.uniqIds) {
                        var i = storage.uniqIds[uniqId],
                            len = storage.fns.length - 1;
                        storage.fns.splice(i, 1);
                        while(i < len) storage.uniqIds[storage.fns[i++].uniqId] = i - 1;
                        delete storage.uniqIds[uniqId];
                    }
                }
            } else {
                delete storage[className];
            }
        }

        return this;

    },

    _liveClassTrigger : function(e) {

        var storage = liveClassEventStorage[e.type];
        if(storage) {
            var node = e.target, classNames = [];
            for(var className in storage) storage.hasOwnProperty(className) && classNames.push(className);
            do {
                var nodeClassName = ' ' + node.className + ' ', i = 0;
                while(className = classNames[i++]) {
                    if(nodeClassName.indexOf(' ' + className + ' ') > -1) {
                        var j = 0, fns = storage[className].fns, fn;
                        while(fn = fns[j++]) fn.fn.call($(node), e);
                        if(e.isPropagationStopped()) return;
                        classNames.splice(--i, 1);
                    }
                }
            } while(classNames.length && (node = node.parentNode));
        }

    },

    _buildLiveEventFn : function(callback, invokeOnInit) {

        var _this = this;
        return function(e) {
            var args = [
                    _this._name,
                    ((e.data || (e.data = {})).domElem = $(this)).closest(_this.buildSelector()),
                    true ],
                block = initBlock.apply(null, invokeOnInit? args.concat([callback, e]) : args);
            block && (invokeOnInit || (callback && callback.apply(block, arguments)));
        };

    },

    /**
     * Helper for live initialization for an event on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String} [elemName] Element name or names (separated by spaces)
     * @param {String} event Event name
     * @param {Function} [callback] Handler to call after successful initialization
     */
    liveInitOnEvent : function(elemName, event, callback) {

        return this.liveBindTo(elemName, event, callback, true);

    },

    /**
     * Helper for subscribing to live events on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String|Object} [to] Description (object with modName, modVal, elem) or name of the element or elements (space-separated)
     * @param {String} event Event name
     * @param {Function} [callback] Handler
     */
    liveBindTo : function(to, event, callback, invokeOnInit) {

        if(!event || $.isFunction(event)) {
            callback = event;
            event = to;
            to = undefined;
        }

        if(!to || typeof to == 'string') {
            to = { elem : to };
        }

        to.elemName && (to.elem = to.elemName);

        var _this = this;

        if(to.elem && to.elem.indexOf(' ') > 1) {
            to.elem.split(' ').forEach(function(elem) {
                _this._liveClassBind(
                    buildClass(_this._name, elem, to.modName, to.modVal),
                    event,
                    callback,
                    invokeOnInit);
            });
            return _this;
        }

        return _this._liveClassBind(
            buildClass(_this._name, to.elem, to.modName, to.modVal),
            event,
            callback,
            invokeOnInit);

    },

    /**
     * Helper for unsubscribing from live events on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String} [elem] Name of the element or elements (space-separated)
     * @param {String} event Event name
     * @param {Function} [callback] Handler
     */
    liveUnbindFrom : function(elem, event, callback) {

        var _this = this;

        if(elem.indexOf(' ') > 1) {
            elem.split(' ').forEach(function(elem) {
                _this._liveClassUnbind(
                    buildClass(_this._name, elem),
                    event,
                    callback);
            });
            return _this;
        }

        return _this._liveClassUnbind(
            buildClass(_this._name, elem),
            event,
            callback);

    },

    /**
     * Helper for live initialization when a different block is initialized
     * @static
     * @private
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     * @param {String} findFnName Name of the method for searching
     */
    _liveInitOnBlockEvent : function(event, blockName, callback, findFnName) {

        var name = this._name;
        blocks[blockName].on(event, function(e) {
            var args = arguments,
                blocks = e.block[findFnName](name);

            callback && blocks.forEach(function(block) {
                callback.apply(block, args);
            });
        });
        return this;

    },

    /**
     * Helper for live initialization for a different block's event on the current block's DOM element
     * @static
     * @protected
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockEvent : function(event, blockName, callback) {

        return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOn');

    },

    /**
     * Helper for live initialization for a different block's event inside the current block
     * @static
     * @protected
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} [callback] Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInsideEvent : function(event, blockName, callback) {

        return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOutside');

    },

    /**
     * Helper for live initialization when a different block is initialized on a DOM element of the current block
     * @deprecated - use liveInitOnBlockEvent
     * @static
     * @protected
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInit : function(blockName, callback) {

        return this.liveInitOnBlockEvent('init', blockName, callback);

    },

    /**
     * Helper for live initialization when a different block is initialized inside the current block
     * @deprecated - use liveInitOnBlockInsideEvent
     * @static
     * @protected
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} [callback] Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInsideInit : function(blockName, callback) {

        return this.liveInitOnBlockInsideEvent('init', blockName, callback);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @static
     * @protected
     * @param {jQuery} [ctx] The element in which the event will be listened for
     * @param {String} e Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler's context
     */
    on : function(ctx, e, data, fn, fnCtx) {

        return ctx.jquery?
            this._liveCtxBind(ctx, e, data, fn, fnCtx) :
            this.__base(ctx, e, data, fn);

    },

    /**
     * Removes the live event handler from a block, based on a specified element where the event was being listened for 
     * @static
     * @protected
     * @param {jQuery} [ctx] The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    un : function(ctx, e, fn, fnCtx) {

        return ctx.jquery?
            this._liveCtxUnbind(ctx, e, fn, fnCtx) :
            this.__base(ctx, e, fn);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @deprecated Use on
     * @static
     * @protected
     * @param {jQuery} ctx The element in which the event will be listened for
     * @param {String} e Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler context
     */
    liveCtxBind : function(ctx, e, data, fn, fnCtx) {

        return this._liveCtxBind(ctx, e, data, fn, fnCtx);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @static
     * @private
     * @param {jQuery} ctx The element in which the event will be listened for
     * @param {String} e  Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler context
     */
    _liveCtxBind : function(ctx, e, data, fn, fnCtx) {

        var _this = this;

        if(typeof e == 'string') {
            if($.isFunction(data)) {
                fnCtx = fn;
                fn = data;
                data = undefined;
            }

            if(e.indexOf(' ') > -1) {
                e.split(' ').forEach(function(e) {
                    _this._liveCtxBind(ctx, e, data, fn, fnCtx);
                });
            } else {
                var ctxE = _this._buildCtxEventName(e),
                    storage = liveEventCtxStorage[ctxE] ||
                        (liveEventCtxStorage[ctxE] = { counter : 0, ctxs : {} });

                ctx.each(function() {
                    var ctxId = $.identify(this),
                        ctxStorage = storage.ctxs[ctxId];
                    if(!ctxStorage) {
                        ctxStorage = storage.ctxs[ctxId] = {};
                        ++storage.counter;
                    }
                    ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')] = {
                        fn   : fn,
                        data : data,
                        ctx  : fnCtx
                    };
                });
            }
        } else {
            $.each(e, function(e, fn) {
                _this._liveCtxBind(ctx, e, fn, data);
            });
        }

        return _this;

    },

    /**
     * Removes a live event handler from a block, based on a specified element where the event was being listened for
     * @deprecated Use on
     * @static
     * @protected
     * @param {jQuery} ctx The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    liveCtxUnbind : function(ctx, e, fn, fnCtx) {

        return this._liveCtxUnbind(ctx, e, fn, fnCtx);

    },

    /**
     * Removes a live event handler from a block, based on a specified element where the event was being listened for
     * @static
     * @private
     * @param {jQuery} ctx The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    _liveCtxUnbind : function(ctx, e, fn, fnCtx) {

        var _this = this,
            storage = liveEventCtxStorage[e =_this._buildCtxEventName(e)];

        if(storage) {
            ctx.each(function() {
                var ctxId = $.identify(this, true),
                    ctxStorage;
                if(ctxId && (ctxStorage = storage.ctxs[ctxId])) {
                    fn && delete ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')];
                    if(!fn || $.isEmptyObject(ctxStorage)) {
                        storage.counter--;
                        delete storage.ctxs[ctxId];
                    }
                }
            });
            storage.counter || delete liveEventCtxStorage[e];
        }

        return _this;

    },

    /**
     * Retrieves the name of an element nested in a block
     * @static
     * @private
     * @param {jQuery} elem Nested element
     * @returns {String|undefined}
     */
    _extractElemNameFrom : function(elem) {

        if(elem.__bemElemName) return elem.__bemElemName;

        var matches = elem[0].className.match(this._buildElemNameRE());
        return matches? matches[1] : undefined;

    },

    /**
     * Retrieves block parameters from a DOM element
     * @static
     * @param {HTMLElement} domNode DOM node
     * @returns {Object}
     */
    extractParams : extractParams,

    /**
     * Builds a prefix for the CSS class of a DOM element or nested element of the block, based on modifier name
     * @static
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery|String} [elem] Element
     * @returns {String}
     */
    _buildModClassPrefix : function(modName, elem) {

        return buildClass(this._name) +
               (elem?
                   ELEM_DELIM + (typeof elem === 'string'? elem : this._extractElemNameFrom(elem)) :
                   '') +
               MOD_DELIM + modName + MOD_DELIM;

    },

    /**
     * Builds a regular expression for extracting modifier values from a DOM element or nested element of a block
     * @static
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery|String} [elem] Element
     * @param {String} [quantifiers] Regular expression quantifiers
     * @returns {RegExp}
     */
    _buildModValRE : function(modName, elem, quantifiers) {

        return new RegExp('(\\s?)' + this._buildModClassPrefix(modName, elem) + '(' + NAME_PATTERN + ')(\\s|$)', quantifiers);

    },

    /**
     * Builds a regular expression for extracting names of elements nested in a block
     * @static
     * @private
     * @returns {RegExp}
     */
    _buildElemNameRE : function() {

        return new RegExp(this._name + ELEM_DELIM + '(' + NAME_PATTERN + ')(?:\\s|$)');

    },

    /**
     * Builds a CSS selector corresponding to the block/element and modifier
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {String}
     */
    buildSelector : function(elem, modName, modVal) {

        return '.' + buildClass(this._name, elem, modName, modVal);

    },

    /**
     * Returns a block instance by unique ID
     * @deprecated
     * @param {String} [uniqId]
     * @returns {BEM.DOM}
     */
    getBlockByUniqId : function(uniqId) {

        return uniqIdToBlock[uniqId];

    },

    /**
     * Returns the size of the current window
     * @returns {Object} Object with width and height fields
     */
    getWindowSize : function() {

        return {
            width  : win.width(),
            height : win.height()
        };

    }

});

})(BEM, jQuery);
;
/* ../../lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: begin */ /**/
(function() {

String.prototype.trim || (String.prototype.trim = function () {

    var str = this.replace(/^\s\s*/, ''),
        ws = /\s/,
        i = str.length;

    while(ws.test(str.charAt(--i)));

    return str.slice(0, i + 1);

});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: end */ /**/

/* ../../lego/blocks-common/i-common/check-session/i-common__check-session.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};
/**
 * Проверяет жива ли сессия пользователя (наличие куки yandex_login).
 *
 * @return  true, если сессия пользователя живая.
 */
Lego.isSessionValid = function() {
    return !!Lego.getCookie('yandex_login');
}
})(window.Lego);
;
/* ../../lego/blocks-common/i-common/check-session/i-common__check-session.js: end */ /**/

/* ../../lego/blocks-common/i-global/i-global.js: begin */ /**/

BEM.DOM.decl('i-global', {

    onSetMod : {

        'js' : function() {

            // удаляем системные свойства
            this.del(this.__self._params = $.extend({}, this.params), 'uniqId', 'name');

            var params = this.__self._params;

            params['passport-msg'] || (params['passport-msg'] = params.id);

            if(params['show-counters'] === undefined) {
                params['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];
            }
            params.locale = params.lang;

            $(function(){
                params.oframebust && Lego.oframebust(params.oframebust);
            });

        }

    },

    getDefaultParams : function() {

        return {
            id : '',
            login : Lego.isSessionValid() ? $.cookie('yandex_login') || '' : '',
            yandexuid : $.cookie('yandexuid'),
            lang : 'ru',
            retpath : window.location.toString(),
            'passport-host' : 'https://passport.yandex.ru',
            'pass-host' : '//pass.yandex.ru',
            'social-host' : '//social.yandex.ru',
            'lego-path' : '/lego',
            'show-counters-percent' : 100
        };

    }

}, {

    param  : function(name) {

        return (this._params || {})[name];

    }

});
;
/* ../../lego/blocks-common/i-global/i-global.js: end */ /**/

/* ../../lego/blocks-common/i-counter/i-counter.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

!Lego.params && (Lego.params = {});


/**
 * Хелпер удаляющий протокол из переданного хоста, для приведения
 * к каноническому виду.
 *
 * @param h {String}
 * @returns {String}
 */
function preparseHost(h) {
    return h.replace(/^(?:https?:)?\/\//, '');
}

/**
 * Счётчик клика на ссылку или просто показа.
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт скрипт с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onmousedown="Lego.c('stred/pid=7/cid=433',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">Lego.c('stred/pid=7/cid=433')< /script>
 *
 * @param w     параметры счётчика
 * @param a     (optional) ссылка, клик на которую надо учитывать
 * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
 */ /**/
Lego.c = function(w, a, opts) {
/*
    new Image().src = location.protocol + '//clck.yandex.ru/click/dtype=' + w +
        '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
        '/*' + (a ? (a.href || location.href) : '');
*/

    var host = preparseHost((opts && opts.host) || BEM.blocks['i-global'].param('click-host') || 'clck.yandex.ru'),
        url = function(w, h, t, a) {

            h = h.replace("'", "%27"); //см. LEGO-6428

            return h.indexOf('/dtype=') > -1?
                h :
                location.protocol + '//' + host + '/' + t + '/dtype=' + w +
                    '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
                    (a?
                        '/*' + (h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)) :
                        '/*data=' + encodeURIComponent('url='+ encodeURIComponent((h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)))));
        },
        click = function() {
            var head = document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0];
            var script = document.createElement('script');
            script.setAttribute('src', url(w, location.href, 'jclck'));
            head.insertBefore(script, head.firstChild);
        };

    if (a) {
        // для псевдоссылки и ссылки mailto просто считаем click, создавая iframe и в него грузим счётчик
        if (a.className.match(/b-link_pseudo_yes/) || (a.href && a.href.match(/^mailto:/)) || (opts && opts.noRedirect === true)) {
            click();
        } else if (a.href) { // клик на ссылку, подменяем href на redir'овский, потом по таймауту обратно
            var h = a.href;
            a.href = url(w, h, "redir");
            setTimeout(function() { a.href = h }, 500);
        } else if (a.form) { // клик на элемент формы
            if (a.type.match(/submit|button|image/)) { // клик на кнопку, подменяем action на redir'овский, потом по таймауту обратно
                var h = a.form.action;
                a.form.action = url(w, h, "redir", true);
                setTimeout(function() { a.form.action = h }, 500);
            } else { // просто считаем click, создавая iframe и в него грузим счётчик
                click();
            }
        } else if (a.action) { //случай сабмита формы - подменяем его action на redir'овский, назад нам его менять не нужно
            a.action = url(w, a.action, "redir", true);
        } else {
            throw "counter.js: not link and not form!";
        }
    } else { // ссылки нет, просто учёт показа, создаём iframe и в него грузим счётчик
        click();
    }
}

})(window.Lego);

(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Параметризованный счётчик клика на ссылку или просто показа.
 * Перевызывает Lego.c(w, a) из counter.js
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт iframe с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onclick="Lego.cp(0,1917,'weather.tabs.fotki',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">Lego.cp(0,1917,'weather.tabs.fotki')< /script>
 *
 * @param pi    номер проекта (pid)
 * @param ci    номер счётчика (cid)
 * @param p     (optional) parameter
 * @param a     (optional) ссылка, клик на которую надо учитывать
 * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
 */
Lego.cp = function(pi, ci, p, a, opts) {
    Lego.c('stred/pid=' + pi + '/cid=' + ci + (p ? '/path=' + p : ''), a, opts);
}

})(window.Lego);

(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Параметризованный счётчик клика на ссылку в шапке. Перевызывает cp(w, a) из counter-cp.js
 * Используется для уменьшения веса страницы.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onclick="ch('weather.tabs.fotki',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">ch('weather')< /script>
 *
 * @param p     parameter
 * @param a     (optional) ссылка, клик на которую надо учитывать
 */
Lego.ch = function(p, a) {
    BEM.blocks['i-global'].param('show-counters') && Lego.cp(0, 2219, p, a);
}

})(window.Lego);
;
/* ../../lego/blocks-common/i-counter/i-counter.js: end */ /**/

/* ../../lego/blocks-common/i-common/cookie/i-common__cookie.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

Lego.getCookie = function(n) {
    var c = document.cookie;
    if (c.length < 1) return false;

    var b = c.indexOf(n + '=');
    if (b == -1) return false;

    b += (n.length + 1);
    var e = c.indexOf(';', b);

    return decodeURIComponent((e == -1) ? c.substring(b) : c.substring(b, e));
}

})(window.Lego);
;
/* ../../lego/blocks-common/i-common/cookie/i-common__cookie.js: end */ /**/

/* ../../lego/blocks-common/i-common/init/i-common__init.js: begin */ /**/
(function($, Lego){
if (!Lego) Lego = window.Lego = {};
// Использует cookie.js и check-session.js. Без них не работает.

/**
 * Инициализирует Лего некоторыми параметрами (для вариативности в пределах разных страниц).
 *
 * @param params объект Лего-параметров, необходимые параметры инициализируются умолчательными значениями
 *        params.login логин текущего пользователя ('' для неавторизованного)
 *        params.locale двухбуквенный код локали в нижнем регистре
 *        params.id идентификатор сервиса
 *        params['show-counters-percent'] процент срабатывания счётчиков Lego.ch() (по умолчанию 100)
 *
 * @return возвращает установленные параметры с учетом умолчательных значений
 */
Lego.init || (Lego.init = function(params) {
    (params = Lego.params = $.extend(
        {
            id : '',
            login : Lego.isSessionValid() ? Lego.getCookie('yandex_login') || '' : '',
            yandexuid : Lego.getCookie('yandexuid'),
            locale : 'ru',
            retpath : window.location.toString(),
            'passport-host' : '//passport.yandex.ru',
            'pass-host' : '//pass.yandex.ru',
            'passport-msg' : params.id,
            'social-host' : '//social.yandex.ru',
            'lego-path' : '/lego',
            'show-counters-percent' : 100
        },
        params,
        Lego.params))
        ['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];

    BEM.blocks['i-global']._params || $.extend(BEM.blocks['i-global']._params = {}, params);

    $(function(){
        params.oframebust && Lego.oframebust(params.oframebust);
    });

    return params;
});

Lego.block || (Lego.block = {});

Lego.blockInit || (Lego.blockInit = function(context, blockSelector) {
    context = context || document;
    blockSelector = blockSelector || '.g-js';
    $(context).find(blockSelector).each(function(){
        var block = $(this),
            params = this.onclick ? this.onclick() : {},
            name = params.name || '',
            init = Lego.block[name];
        if (init && !block.data(name)) {
            init.call(block, params);
            block
                .data(name, true)
                .addClass(name + '_js_inited');
        }
    });
});

Lego.blockInitBinded || (Lego.blockInitBinded = !!$(document).ready(function(){ Lego.blockInit() }));

})(jQuery, window.Lego);
;
/* ../../lego/blocks-common/i-common/init/i-common__init.js: end */ /**/

/* ../../lego/blocks-common/i-common/i-common.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

Lego.messages = Lego.messages || {};

Lego.message = function(id, text) {
    return Lego.params.locale == 'ru' ? text : (Lego.messages[id] || text);
};

})(window.Lego);;
/* ../../lego/blocks-common/i-common/i-common.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: begin */ /**/
/* дефолтная инициализация */
$(function() {
    BEM.DOM.init();
});;
/* ../../lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: end */ /**/

/* ../../blocks-desktop/i-widget-helper/i-widget-helper.js: begin */ /**/
(function() {

    (function() {
        var map = { '&': '&amp;', '  ': '&nbsp; ', '<': '&lt;', '>': '&gt;', '\n': '<br />', '\r\n': '<br />', '"': '&quot;' };
        var map2 = { '&amp;': '&', '&nbsp;': ' ', '&lt;': '<', '&gt;': '>', '<br />': '\n', '<br/>': '\n', '<br>': '\n', '&quot;': '"' };
        var funcReplace = function(str) { 
            return map[str]; 
        };
        var funcReplace2 = function(str) { 
            return map2[str.toLowerCase()]; 
        };
        /**
         * Escape HTML spec chars
         */
        String.prototype.toHTML = function() { 
            return this.replace(/&|  |<|>|\r\n|\n|"|"/g, funcReplace); 
        };
        /**
         * Unescape HTML spec chars
         */
        String.prototype.fromHTML = function() { 
            return this.replace(/&amp;|&nbsp;|&lt;|&gt;|<(br|BR)\s*\/?>|&quot;/g, funcReplace2); 
        };
    })();
    
    Function.empty = function(){};
    
    /**
     * Create callback, what not called until minTimeout timeout.
     * @param {Number} minTimeout minimum timeout, in ms.
     * @return {Function} callback.
     */
    Function.prototype.callbackDelay = function(minTimeout) {
        if (!minTimeout || (minTimeout < 1)) {
            return this;
        }
        var endTime = (new Date()).valueOf() + minTimeout;
        var func = this;
        return function() {
            var interval = endTime - (new Date()).valueOf();
            var args = arguments, self = this;
            if (interval > 0) {
                setTimeout(function() {
                    func.apply(self, args);
                }, interval);
            } else {
                func.apply(self, args);
            }
        }
    };

    BEM.decl('i-widget-helper', {}, {
    
        _localStringPrefix: '',
        _initialized: false,

        /**
         * Helper initialization.
         */
        init: function(platform, localStringPrefix) {
            if (this._initialized) {
                return;
            }
            this._initialized = true;
            this._platform = platform;
            this._localStringPrefix = (localStringPrefix || '');
            
            var self = this;
            this._helperPlatformListener = function(message) {
                var topic = message.message || message;
                var data = message.data || null;
                self.fireEvent(topic, data);
            };
            
            this._platform.onMessage.addListener(this._helperPlatformListener);
            
            jQuery.ajaxSetup({
                crossDomain: false
            });
            
            if (!this._enableContextMenu) {
                document.oncontextmenu = function(e) { 
                    e = e || window.event;
                    var tag = (e.target || e.srcElement).tagName;
                    return ((tag === 'INPUT') || (tag === 'TEXTAREA'));
                };
                window.onerror = function(e, ur, ln) {
                    //=log('ERROR: ' + e + '  (' + ln + '  url=' + ur + ')');
                    return false;
                };
			}
        },
        
        branding: function(conf) {
            if (!conf.current) {
                conf.current = {};
                var bran = (conf.branding || {})[this._platform.brandID];
                $.extend(conf.current, conf.common || {}, bran || {});
            }
            return conf.current;
        },
        
        getScript: function(url, callback) {
            this.ajax({
	            type: 'GET',
	            url: url,
	            success: callback,
	            dataType: 'script'
            });
        },
        
        ajax: function(config, attemptsCount) {
            attemptsCount = attemptsCount || 1;
            
            if ((config.dataType == 'script') || (config.dataType == 'jsonp')) {
                config.crossDomain = true;
            }
            
            function request() {
                attemptsCount--;
                $.ajax(config);
            }
            
            if (attemptsCount > 1) {
                var oldError = config.error || Function.empty;
                config.error = function() {
                    if (attemptsCount) {
                        request();
                    } else {
                        oldError.apply(this, arguments);
                    }
                }
            }
            
            request();
        },

        /**
         * Opens widget settings.
         */
        openSettings: function() {
            if (!window.closed) {
                window.close();
            }
            this._platform.showSettings();
        },
        
        /**
        for IE (new Date('YYYY-MM-DD hh:mm:ss') not work in IE)
        */
        parseDate: function (str) {
            if ((typeof str !== 'string') || !str) { 
                return str;
            }
            var i, part = str.match(/\d+/g);
            for(i = 0; i<part.length; ++i) { 
                part[i] = parseInt(part[i], 10); 
            }
            return new Date(part[0], part[1]-1, part[2], part[3], part[4], part[5]);
        },

        /**
         * Opens |url| in new tab.
         * @param {String} url URL of page to open.
         */
        openNewTab: function(url) {
            this._platform.navigate(url, 'new tab');
            window.close();
        },
        
        localStr: function(key) {
            return this._platform.getLocalizedString(this._localStringPrefix + key) || '';
        },
        
        lang: function() {
            return this._platform.language;
        },
        
        getParam: function(param, url) {
            return (RegExp('[?&]' + param + '=([^&#]*)', 'i').exec(url || document.location.href)||'')[1]||'';
        },
        
        platformLocalization: function(mainBlock) {
            if (mainBlock.platform_i18n) {
                mainBlock.platform_i18n(this);
            }
            for(var bl in BEM.blocks) {
                if (/^b-/.test(bl)) {
                    var blocks = mainBlock.findBlocksInside(bl);
                    if (blocks) {
                        for (var i=0; i<blocks.length; ++i) {
                            if (blocks[i].platform_i18n) {
                                blocks[i].platform_i18n(this, i);
                            }
                        }
                    }
                }
            }
        },
        
        

        /**
         * Logs user's actions.
         * @param {Number} actionCode Any of this.Action.*
         */
        logAction: function(actionCode) {
            this._platform.logCustomAction(actionCode);
        },
        
        _helperPlatformListener: null,
        _pltfListeners: {},
        _removePlatformListener: function() {
            if (this._helperPlatformListener) {
                this._platform.onMessage.removeListener(this._helperPlatformListener);
                this._helperPlatformListener = null;
            }
        },
        
        reloadSlice: function() {
            this._removePlatformListener();
            window.location.reload(true);
		},
        removeListener: function(topic, callback) {
            if (!this._pltfListeners[topic]) {
                return;
            }
            if (!callback) {
                this._pltfListeners[topic] = null;
            } else {
                var listeners = this._pltfListeners[topic];
                for (var i=0; i<listeners.length; ++i) {
                    if (listeners[i].func == callback) {
                        listeners.splice(i, 1);
                        --i;
                    }
                }
            }
        },
        addListener: function(topic, callback, scope) {
            this._pltfListeners[topic] = this._pltfListeners[topic] || [];
            this._pltfListeners[topic].push({func: callback, scope: scope});
            return this;
        },
        fireEvent: function(topic, data) {
            var listeners = this._pltfListeners[topic];
            if (listeners) {
                for (var i=0; i<listeners.length; ++i) {
                    var ret = listeners[i].func.call(listeners[i].scope || window, topic, data);
                    if (ret === false) {
                        break;
                    }
                }
            }
        }
        
    });
})();
;
/* ../../blocks-desktop/i-widget-helper/i-widget-helper.js: end */ /**/

/* ../../blocks-desktop/i-widget-mail/i-widget-mail.js: begin */ /**/
(function($) {

    BEM.decl('i-widget-mail', {}, {
        /**
         * Errors list.
         * @enum {Number}
         * @const
         */
        Error: {
            GENERIC: 1,
            NETWORK_IS_NOT_AVAILABLE: 2
        },

        /**
         * Actions list.
         * @enum {Number}
         * @const
         */
        Action: {
            CLICK_LOGO: 2,
            CLICK_COMPOSE_NEW: 3,
            CLICK_REFRESH: 4,
            CLICK_GO_TO_WEB: 5,
            OPEN_MESSAGE: 6,
            MESSAGE_ACTION: 7,
            CLICK_COLLECTOR_LINK: 9,
            CLICK_FOLDER: 8,
            HIDE_COLLECTOR_LINK_IN_FOOTER: 10
        },
        
        _domain: '',
        _domainInited: false,

        /**
         * Initialization.
         */
        init: function(platform) {
            'use strict';
            this._platform = platform;
            this._helper = BEM.blocks['i-widget-helper'];
            this._config = BEM.blocks['i-widget-mail__config'].current;
            this._domain = this._config.COOKIE_DOMAIN;
            this._platform.resizeWindowTo(this._config.windowSize[0], this._config.windowSize[1]);
            
            this._helper.addListener('auth.user', function(topic, auth) {
                this._domain = (auth.getYandexDomain() || this._domain).replace('ya.ru', 'yandex.ru');
                this._domainInited = true;
            }, this);
        },
        
        
        /**
         * Get last message date (for detect new messages).
         * @param {String} email user mail.
         * @return {Date} last message date.
         */
        getLastMessageDate: function(email) {
            // yandex.(kz|ua) == yandex.ru
            email = email.replace(/yandex\.(kz|ua)$/, 'yandex.ru');
            
            var dates = (this._platform.getOption('lastDate')||'').split('||');
            
            for(var i=0; i<dates.length; ++i) {
                var date = dates[i].split('|');
                if ((date[0] == email) && (/^\d+$/.test(date[1]))) {
                    return new Date(parseInt(date[1]));
                }
            }
        },
        
        /**
         * Set last message date.
         * @param {String} email user mail.
         * @param {Date} date msg date.
         */
        setLastMessageDate: function(email, date) {
            // yandex.(kz|ua) == yandex.ru
            email = this.normalizeEMail(email);
        
            var dates = (this._platform.getOption('lastDate')||'').split('||');
            var found = -1;
            
            for(var i=0; i<dates.length; ++i) {
                var date = dates[i].split('|');
                if (date[0] == email) {
                    found = i;
                    break;
                }
            }
            
            if (found >= 0) {
                dates.splice(found, 1);
            } else {
                dates.pop();
            }
            dates.unshift(email + '|' + date.valueOf());
            this._platform.getOption('lastDate', dates.split('||'));
        },
        
        /**
         * Add stat params to url and ensure using https
         * @param {String} url URL.
         * @return {String} Updated URL.
         */
        prepareURL: function(url) {
            return this.mailDomain(this._addParamToURL(url, {
                name: 'elmt',
                value: 'mail'
            }).replace(/^http:/, 'https:'));
        },
        
        mailDomain: function(url, opt_onlyInited) {
            if (!this._domainInited && opt_onlyInited) {
                return url;
            }
            return (url || '').replace(/__maildomain__/, this._domain);
        },

        /**
         * Opens |url| in new tab.
         * @param {String} url URL of page to open.
         */
        openURL: function(url) {
            'use strict';
            url = this.prepareURL(url);
            this._helper.openNewTab(url);
        },

        /**
         * Adds param to search query of the url.
         * scheme://username:password@domain:port/path?query_string#fragment_id
         * @private
         * @param {String} urlString URL string.
         * @param {Object} param Param name and value.
         * @return {String} Updated URL.
         */
        _addParamToURL: function(urlString, param) {
            'use strict';
            var NUMBER_SIGN = '#',
                QUESTION_MARK = '?',
                url = urlString,
                base,
                queryString,
                fragment;

            // check fragment presence
            var numberSignPosition = url.indexOf(NUMBER_SIGN);
            if (-1 != numberSignPosition) {
                // url has fragment, save it and remove from url
                fragment = url.substring(numberSignPosition + 1);
                url = url.substring(0, numberSignPosition)
            }

            // check query presence
            var questionMarkPosition = url.indexOf(QUESTION_MARK);
            if (-1 != questionMarkPosition) {
                // url has fragment, save it and remove from url
                queryString = url.substring(questionMarkPosition + 1);
                url = url.substring(0, questionMarkPosition)
            }

            base = url;

            // add new param to query string
            var params;
            if ('undefined' != typeof queryString) {
                params = this._getParamsFromQueryString(queryString);
            }
            else {
                params = {};
            }

            // add or replace param
            params[param.name] = param.value;

            // create new url string
            var newURL = base + QUESTION_MARK + $.param(params);
            if ('undefined' != typeof fragment) {
                newURL += NUMBER_SIGN;
                newURL += fragment;
            }

            return newURL;
        },

        /**
         * Extracts params names and values from query string.
         * @param {String} queryString
         * @return {Object} Params list.
         * @private
         */
        _getParamsFromQueryString: function(queryString) {
            'use strict';
            var params = {};
            var pairs = queryString.split('&');
            for (var i = 0, len = pairs.length; i < len; ++i) {
                var split = pairs[i].split('=');
                params[split[0]] = split[1] || '';
            }
            return params;
        },

        /**
         * Returns date in human-friendly format.
         * @param {String} dateString
         * @return {String}
         */
        getHumanFriendlyDate: function(dateString) {
            'use strict';
            var MILLISECONDS_IN_DAY = 1000 * 60 * 60 * 24;
            
            function lpad(str) {
                return (str < 10) ? ('0' + str) : str;
            }

            var date = this._helper.parseDate(dateString);
            var now = new Date();
            var messageAgeInMilliseconds = Math.abs(now.getTime() - date.getTime());
            var prettyDate = '';

            if ((messageAgeInMilliseconds < MILLISECONDS_IN_DAY) && (date.getDate() == now.getDate())) {
                // '15:45' (current day)
                prettyDate = lpad(date.getHours()) + ':' + lpad(date.getMinutes());
            }
            else if (date.getFullYear() == now.getFullYear()) {
                // '21 february' (current year)
                prettyDate = date.getDate() + ' '
                    + this._getMonthName(date.getMonth());
            }
            else {
                // '21 february 2002' (full date)
                prettyDate = date.getDate() + ' '
                    + this._getMonthName(date.getMonth()) + ' '
                    + date.getFullYear();
            }
            return prettyDate;
        },
        
        
        normalizeEMail: function(email) {
            return email.replace(/@(yandex\.(kz|ua|by)|ya.ru)$/i, '@yandex.ru');
        },

        /**
         * Returns month name for date.
         *   E.g. "июня", "декабря" etc.
         * @private
         * @param {Number} monthNumber 0-11
         * @return {String} Month name.
         */
        _getMonthName: function(monthNumber) {
            'use strict';
            return this._helper.localStr('month.g' + (monthNumber + 1)).toLowerCase();
        }
    });

})(jQuery);
;
/* ../../blocks-desktop/i-widget-mail/i-widget-mail.js: end */ /**/

/* ../../blocks-desktop/i-widget-mail/__config/i-widget-mail__config.js: begin */ /**/
(function() {
    BEM.decl('i-widget-mail__config', {}, {
        current: null,
        common: {
            URL_COUNTER: 'http://export.__maildomain__/for/counters.xml',
            API_URL_ROOT: 'https://mail.__maildomain__/api/',
            XIVA_CREDENTIALS_URL: 'https://mail.__maildomain__/neo2/handlers/xiva_sub.jsx',
            XIVA_CONNECT_URL: 'https://xiva-daria.mail.yandex.net/events/iframe',
            COOKIE_DOMAIN: 'yandex.ru',
            maxVisibleMsgCount: 20,
            windowSize: [740, 400]
        },
        branding: {
            tb: {
                COOKIE_DOMAIN: 'yandex.com.tr'
            }
        }
    });
})();
;
/* ../../blocks-desktop/i-widget-mail/__config/i-widget-mail__config.js: end */ /**/

/* ../../blocks-desktop/i-yandex-auth/i-yandex-auth.js: begin */ /**/
(function() {
    BEM.decl('i-yandex-auth', {}, {

        /**
         * Known messages list.
         * @enum {String}
         */
        _KnownMessages: {
            USER_GET: 'user.get',
            AUTH_USER: 'auth.user',
            USER_LOGOUT: 'user.logout'
        },

        /**
         * Block initialization.
         */
        init: function(platform) {
            'use strict';

            this._platform = platform;
            this._helper = BEM.blocks['i-widget-helper'];
            
            /**
             * Current users data.
             * @type {Array}
             * @private
             */
            this._users = [];

            this._helper.addListener(this._KnownMessages.USER_GET, this._handleMessageUserGet, this);
        },

        /**
         * get authorized user mail address, e.g. "username@domain.com"
         */
        getMailAddress: function() {
            var user = this.getUser();
            return  (null !== user) ? (user.login + '@' + user.domain) : '';
        },
        
        /**
         * Getter for Yandex domain name.
         */
        getYandexDomain: function() {
            var user = this.getUser();
            return  (null !== user) ? user.domain : '';
        },
        
        /**
         * Getter for User ID (for xiva).
         */
        getUserId: function() {
            var user = this.getUser();
            return  (null !== user) ? user.id : '';
        },

        /**
         * Getter for current user data.
         */
        getUser: function() {
            return (null !== this._users) ? (this._users[0] || null) : null;
        },

        /**
         * Logs user out.
         */
        logout: function() {
            this._platform.sendMessage({
                message: this._KnownMessages.USER_LOGOUT
            });
        },

        getPassportId: function(opt_domain) {
            opt_domain = opt_domain || this.getYandexDomain();
            if (!opt_domain) {
                return '';
            }
            var sid = this._platform.getCookie('http://' + opt_domain, 'Session_id', true);
            return (sid ? sid.split('.')[3] : '');
        },

        /**
         * Handles messages from platform.
         * @param {String} topic Message from platform.
         * @param data Message data from platform.
         * @private
         */
        _handleMessageUserGet: function(topic, data) {
            this._saveUser(data);
            if (this.getUser()) {
                this._helper.fireEvent(this._KnownMessages.AUTH_USER, this);
            }
        },

        /**
         * Requests user data from platform.
         * @private
         * @param {Function} callback Callback function.
         */
        updateUserData: function() {
            var MESSAGE_ID = this._KnownMessages.USER_GET;
            this._platform.sendMessage({message: MESSAGE_ID});
        },

        /**
         * Save user data locally.
         * @private
         * @param {Object} userData User data object
         *     w/ 'id, 'login', 'domain' and 'type' fields.
         */
        _saveUser: function(userData) {
            //=log('user mail = ' + userData[0].login + '@' + userData[0].domain + ', type = ' + userData[0].type + ', users count = ' + userData.length);
            this._users = userData;
        }
    });

})();
;
/* ../../blocks-desktop/i-yandex-auth/i-yandex-auth.js: end */ /**/

/* ../../blocks-desktop/i-yandex-mail-api/i-yandex-mail-api.js: begin */ /**/
(function($) {

    BEM.decl('i-yandex-mail-api', {}, {


        /**
         * API request timeout.
         * @type {Number}
         * @private
         * @const
         */
        _REQUEST_TIMEOUT_IN_SECONDS: 10,
        
        _folderList: null,


        /**
         * Initialization.
         */
        init: function(platform) {
            'use strict';
            this._config = BEM.blocks['i-widget-mail__config'].current;
            this._platform = platform;
            this._helper = BEM.blocks['i-widget-helper'];
            this._widget = BEM.blocks['i-widget-mail'];
        },

        /**
         * Requests list of messages in folder w/ id |opt_folderId|.
         * @param {Object=} opt_folder Folder data. Optional.
         *     Might has id and page properties.
         * @param {Function} successCallback Callback for successful request.
         * @param {Function} opt_errorCallback Callback for erroneous request.
         *     Optional.
         */
        getMessagesInFolder: function(opt_folder, successCallback, opt_errorCallback) {
            'use strict';

            var folderId;
            var page;
            var DEFAULT_PAGE = 1;

            if ('object' == typeof opt_folder) {
                folderId = opt_folder.id; // id might be undefined, but it's ok
                page = opt_folder.page ? opt_folder.page : DEFAULT_PAGE;
            }
            else {
                // Folder data is not provided.
                opt_errorCallback = successCallback;
                successCallback = opt_folderId;
            }

            var errorCallback = ('function' == typeof opt_errorCallback) ?
                opt_errorCallback :
                Function.empty;

            var self = this;
            var params = {
                page_number: page
            };
            if ('undefined' !== typeof folderId) {
                switch (folderId) {
                    case 'unread':
                        // unread messages requested
                        params.extra_cond = 'only_new';
                        params.goto = 'all';
                        break;

                    case 'inbox':
                        // It is default behaviour of Mail API,
                        // we do not need to do anything special here.
                        break;

                    default:
                        params.current_folder = folderId;
                }
            }
           
            this.request('GET', 'mailbox_list', params, function(xml) {
                self._handleMessagesListResponse(xml, successCallback, errorCallback);
            }, errorCallback);
        },


        /**
         * Handles response of messages list request.
         * @private
         * @param {Document} xml Server response as XML document.
         * @param {Function} successCallback Callback for successful request.
         * @param {Function} errorCallback Callback for erroneous request.
         */
        _handleMessagesListResponse: function (xml, successCallback,
                                               errorCallback) {
            'use strict';
            var data;
            try {
                data = this._extractMessagesDataFromXML(xml);
            }
            catch (e) {
                // nobody cares
            }
            if ('undefined' === typeof data) {
                errorCallback();
            }
            else {
                successCallback(data.folder, data.messages);
            }
        },
        
       

        /**
         * Extracts messages list from API response XML.
         *     Might throws an exception.
         * @private
         * @throws Error
         * @param {Document} xml Mail API response.
         * @return {Array.<object>} Messages list.
         */
        _extractMessagesDataFromXML: function(xml) {
            'use strict';
            var doc = $(xml);
            var messagesNodes = $('mailbox_list>message', doc);
            var messages = [];
            
            this._folderList = this._extractFoldersListFromXML(xml);
            var folderList = this._folderList;
            
            //=log('1 this._folderList = ' + this._folderList, 'b');
            
            var self = this;
            
            $.each(messagesNodes, function(index, messageNode) {
                messageNode = $(messageNode);
                var fold = folderList.map[messageNode.attr('fid')];
                if (fold && fold.ignoreMsgList) {
                    return;
                }
                
                var message = {};

                message.id = messageNode.attr('mid');
                
                var fromNode = $('from', messageNode);
                
                message.sender = {
                    name: $('name', fromNode).text(),
                    email: $('email', fromNode).text()
                };
                message.subject = $('subject text', messageNode).text();
                message.firstline = $('firstline', messageNode).text();
                message.date = messageNode.attr('date');
                message.isUnread = messageNode.attr('status') === 'New';
                message.hasAttach = messageNode.attr('att_count') > 0;
                message.url = self._widget.mailDomain('http://mail.__maildomain__/neo2/#message/', true) + messageNode.attr('mid');

                messages.push(message);
            });

            var foldersDetailsNode = $('details', doc);
            var folder = {
                name: foldersDetailsNode.attr('name'),
                page: foldersDetailsNode.attr('page_number'),
                messagesCount: parseInt(foldersDetailsNode.attr('msg_count'), 10),
                unreadCount: folderList.unreadCount
            };

            return {
                folder: folder,
                messages: messages
            };
        },

        /**
         * Requests list of mail folders for current user.
         * @param {Function} successCallback Callback for successful request.
         * @param {Function} errorCallback Callback for erroneous request.
         */
        getFoldersList: function(successCallback, errorCallback, opt_fromCache) {
            'use strict';
            var self = this;
            if (opt_fromCache && self._folderList) {
                //=log('getFoldersList (from cache)');
                successCallback(self._folderList);
                return;
            }
            //=log('getFoldersList (request)');
            this.request('GET', 'folder_list', function(xml) {
                self._folderList = self._extractFoldersListFromXML(xml);
                successCallback(self._folderList);
            }, errorCallback);
        },

        /**
         * Parses  list of folder returned by Mail API. Returns
         *    list as Object.<number, string>, there keys are folders'
         *    ids and values are folders' names.
         *    Returns undefined if extraction failed.
         * @param {Document} xml Mail API response.
         * @private
         * @return {(Object.<number, string>)|undefined} Folder list.
         */
        _extractFoldersListFromXML: function(xml) {
            'use strict';
            var doc = $(xml);
            var folderNodes = $('folder_list>folder', doc);
            var folders = [];
            var map = {};
            var ignoreUnreadCountFids = { outbox: true, sent: true, spam: true, trash: true, draft: true };
            var unreadCount = 0;
            $.each(folderNodes, function(index, folderNode) {
                folderNode = $(folderNode);
                var folder = {};
                folder.id = $('fid', folderNode).text();
                folder.special = $('special', folderNode).text();
                folder.symbol = $('symbol', folderNode).text();
                folder.name = $('name', folderNode).text();
                folder.messages = {
                  total: $('count', folderNode).text(),
                  "new": $('new', folderNode).text() || '0'
                };
                folder.ignoreXivaInsert = ignoreUnreadCountFids[folder.symbol] || false;
                folder.ignoreMsgList = ignoreUnreadCountFids[folder.symbol] || false;
                folder.unreadCount = (folder.ignoreMsgList ? 0 : parseInt(folder.messages['new'], 10));

                folders.push(folder);
                map[folder.id] = folder;
                
                unreadCount += folder.unreadCount;
            });
            
            return { list: folders, map: map, unreadCount: unreadCount };
        },

        /**
         * Marks message as read.
         * @param {Number} messageId
         * @param {Function} callback
         */
        markMessageAsRead: function(messageId, callback) {
            'use strict';
            this.request('POST', 'mailbox_oper', {
                ids: messageId,
                oper: 'mark_read'
            }, callback);
        },

        /**
         * Marks message as spam.
         * @param {Number} messageId
         * @param {Function} callback
         */
        markMessageAsSpam: function(messageId, callback) {
            'use strict';
            this.request('POST', 'mailbox_oper', {
                ids: messageId,
                oper: 'tospam'
            }, callback);
        },

        /**
         * Deletes message from mailbox.
         * @param {Number} messageId
         * @param {Function} callback
         */
        deleteMessage: function(messageId, callback) {
            'use strict';
            this.request('POST', 'mailbox_oper', {
                ids: messageId,
                oper: 'delete'
            }, callback);
        },
        
        
        getCounterInfo: function(callback, errback) {
            errback = errback || Function.empty;
            this._helper.ajax({
                cache: false,
                data: { services: 43 },
                dataType: 'xml',
                error: errback,
                success: function(data) {
                    var mail = $('mail', data);
                    var count = mail.attr('v');
                    if (/^\d+$/.test(count)) {
                        var c = mail.parent();
                        callback({ 
                            count: parseInt(count, 10), 
                            login: c.attr('l') || '',
                            name: c.attr('d') || '',
                            type: c.attr('p') || ''
                        });
                    } else {
                        errback({status: 500});
                    }
                },
                timeout: this._REQUEST_TIMEOUT_IN_SECONDS * 1000,
                type: 'GET',
                url: this._widget.mailDomain(this._config.URL_COUNTER)
            }, 5);
        },

        /**
         * Makes request to API.
         * @param {String} httpMethod HTTP protocol method. E.g. 'get', 'post'.
         * @param {String} apiMethod Mail API method name.
         * @param {Object} opt_params Request parameters as key-value pairs.
         *    Optional.
         * @param {Function} opt_successCallback Callback for successful request.
         *    Optional.
         * @param {Function} opt_errorCallback Callback for erroneous request.
         *    Optional.
         */
        request: function(httpMethod, apiMethod, opt_params,
                          opt_successCallback, opt_errorCallback) {
            'use strict';

            var params;
            if ('object' == typeof opt_params) {
                params = opt_params;
            }
            else if ('function' == typeof opt_params) {
                // Request w/o param, callbacks are third and maybe forth arguments.
                opt_errorCallback = opt_successCallback;
                opt_successCallback = opt_params;
            }

            // All requests must have param 'elmt' w/ value 'mail'.
            if ('undefined' === typeof params || null === params) {
                params = {
                    elmt: 'mail'
                };
            }
            else {
                params.elmt = 'mail';
            }

            var successCallback = null,
                errorCallback = null;
            if ('function' == typeof opt_successCallback) {
                successCallback = opt_successCallback;
            }
            if ('function' == typeof opt_errorCallback) {
                errorCallback = opt_errorCallback;
            }

            var requestURL = this._getRequestURL(apiMethod);
            this._helper.ajax({
                data: params,
                dataType: 'xml',
                error: errorCallback,
                success: successCallback,
                timeout: this._REQUEST_TIMEOUT_IN_SECONDS * 1000,
                type: httpMethod,
                url: this._widget.mailDomain(requestURL)
            }, 3);
        },

        /**
         * Returns URL for given API method.
         * @private
         * @param {String} methodName API method name.
         * @return {String} Request URL.
         */
        _getRequestURL: function(methodName) {
            'use strict';
            return this._config.API_URL_ROOT + methodName;
        }
    });

})(jQuery);
;
/* ../../blocks-desktop/i-yandex-mail-api/i-yandex-mail-api.js: end */ /**/

/* ../../blocks-desktop/i-yandex-mail-notifications/i-yandex-mail-notifications.js: begin */ /**/
(function($) {
    BEM.decl('i-yandex-mail-notifications', {}, {


        /**
         * Current connection to Xiva.
         * @private
         * @type {XMLHttpRequest}
         */
        _connection: null,
        
        
        _notWorkStartDate: 0,


        /**
         * Current user id.
         * @private
         * @type {String}
         */
        _userId: '',
        
        _passpId: '',
        
        _onMsg: null,
        
        _helper: null,
        
        _lcn: null,
        
        _lastAction: { interval: 3000 },
        
        
        /**
         * Offline detector
         */
        _offline: { 
            _interval: 10000,
            _onlineInterval: 2000,
            
            init: function(onTimeout) {
                this._onTimeout = onTimeout;
                this._startOnline = 0;
                this.start();
            },
            start: function() {
                this._startOffline = (new Date()).valueOf();
            },
            connect: function() {
                var date = (new Date()).valueOf();
                var dateStartOffline = this._startOffline;
                if (date - dateStartOffline > this._interval) {
                    this.start();
                    this._onTimeout(date - dateStartOffline);
                }
                this._startOnline = date;
            },
            error: function() {
                var date = (new Date()).valueOf();
                var dateStartOffline = this._startOffline;
                if (date - this._startOnline > this._onlineInterval) {
                    this.start();
                }
            }
         },


        /**
         * Initialization.
         * @param {String} user Yandex user info.
         * @param {Function} onMsg handler.
         * @param {Function} onTimeout timeout handler.
         * @param {Function} onDisconnect disconnect handler.
         */
        init: function(userId, passpId, onMsg, onTimeout, onDisconnect) {
            'use strict';
            
            this._helper = BEM.blocks['i-widget-helper'];
            this._widget = BEM.blocks['i-widget-mail'];
            this._config = BEM.blocks['i-widget-mail__config'].current;
            
            this._passpId = passpId;
            this._userId = userId;
            this._onMsg = onMsg;
            this._onDisconnect = onDisconnect;
            
            //=log('passpId = ' + passpId);
            
            //=log('XIVA_CONNECT_URL=' + this._config.XIVA_CONNECT_URL);
            
            this._notWorkStartDate = (new Date()).valueOf();
            
            this._lastAction.time = 0;
            
            this._offline.init(onTimeout || function(){});
            
            
            
            if (this._userId) {
                this._connect();
            }
        },
        
        /**
         * Action with message.
         * @param type - action type ('readed', 'spam', 'remove')
         */
        lastAction: function(type) {
            this._lastAction.time = (new Date()).valueOf();
            this._lastAction.type = type;
        },
        
        /**
         * Restart work, if this block in fail.
         */
        ensureWork: function() {
            if (this._notWorkStartDate && ((new Date()).valueOf() - this._notWorkStartDate > 10000)) {
                this._connect();
            }
        },
        
        /**
         * setTimeout, work with _notWorkStartDate and save context.
         * @private
         * @param {Function} callback Callback function.
         * @param {Number} ms Time, in milliseconds.
         * @return {Object} Wrapper for timer with method abort.
         */
        _setTimeout: function(callback, ms) {
            var self = this;
            var timer = setTimeout(function() {
                self._notWorkStartDate = (new Date()).valueOf();
                callback.call(self);
            }, ms);
            if (timer) {
                this._notWorkStartDate = 0;
                return {
                    _timer: timer,
                    abort: function() {
                        if (this._timer) {
                            self._notWorkStartDate = (new Date()).valueOf();
                            var tmr = this._timer;
                            this._timer = null;
                            clearTimeout(tmr);
                        }
                    }
                }
            } else {
                return null;
            }
        },
        
        /**
         * $.ajax, work with _notWorkStartDate and save context.
         * @private
         * @param {Object} config Config object for $.ajax.
         * @return {Object} Result of $.ajax(config).
         */
        _ajax: function(config) {
            this._notWorkStartDate = 0;
            var self = this;
            if (!config.__handlersRewrite) {
                config.__handlersRewrite = true;
                
                var oldSuccess = config.success;
                config.success = function() {
                    self._notWorkStartDate = (new Date()).valueOf();
                    oldSuccess.apply(self, arguments);
                };
                
                var oldError = config.error || function(){};
                config.error = function() {
                    self._notWorkStartDate = (new Date()).valueOf();
                    oldError.apply(self, arguments);
                };
            }
            return $.ajax(config);
        },
        

        /**
         * Creates new connection to Xiva.
         * Optional connection delay can be provided.
         * @private
         * @param {Number=} opt_delay Connect delay in seconds.
         *    Optional, 0 by default.
         */
        _connect: function(opt_delay) {
            var delay = ('number' === typeof opt_delay) ? Math.max(1, opt_delay) : 1;

            var attemptsCount = 0;
            
            var connect = function () {
                var credentials = this._getXivaCredentials();
                if (credentials) {
                    this._offline.connect();
                    
                    //=log('xiva connect begin', 'g');
                    this._connection = this._ajax({
                        url: this._widget.mailDomain(this._config.XIVA_CONNECT_URL),
                        dataType: 'json',
                        data: {
                            _tr: Math.random(), // for IE
                            single: '1',
                            client_id: 'bar',
                            service: 'mail',
                            uid: credentials.uid,
                            //suid2: credentials.suid2,
                            //uid: this._passpId,
                            sign: credentials.sign,
                            ts: credentials.ts
                        },
                        timeout: 90000*100,
                        success: function(data) {
                            var jqXHR = this._connection;
                            this._connection = null;
                            
                            if (data && data.lcn) {
                                //=log('xiva connect success', 'g');
                                this._offline.start();
                                this._handleXivaConnectionResponse(data);
                            } else {
                                //=log('xiva connect error (no data)', 'r');
                                this._offline.error();
                                this._handleXivaConnectionError(0, '', jqXHR);
                            }
                            
                        }, 
                        error: function(jqXHR, textStatus) {
                            this._connection = null;
                            var status = jqXHR.status;
                            //=log('xiva connect error ' + status + ' ' + textStatus, 'r');
                            this._offline.error();
                            this._handleXivaConnectionError((status > 600 ? 0 : status), textStatus, jqXHR);
                        }
                    });
                } else {
                    if (attemptsCount < 5) {
                        attemptsCount++;
                        this._requestXivaCredentials(connect);
                    } else {
                        this._connect(10000);
                    }
                }
            };
                
            this._setTimeout(connect, delay);
        },


        /**
         * Aborts current connection to Xiva.
         * @private
         */
        _abortConnection: function() {
            'use strict';
            if (null !== this._connection &&
                this._connection.readyState !== 4) {
                // Connection exists and is not in 'LOADED' state.
                this._connection.abort();
            }
            this._connection = null;
        },


        /**
         * Drops current connection to Xiva and establishes a new one.
         * Optional connection delay can be provided.
         * @private
         * @param {Number=} opt_delay Reconnect delay in seconds.
         *    Optional, 0 by default.
         */
        _reconnect: function(opt_delay) {
            'use strict';
            this._abortConnection();
            this._connect(opt_delay);
        },


        /**
         * Xiva credentials.
         * @type {Object}
         * @private
         */
        _xivaCredentials: null,


        /**
         * Requests credentials for Xiva connection.
         * @private
         * @param {Function} callback Callback function.
         *      Will be called both for successful and erroneous requests.
         */
        _requestXivaCredentials: function(callback) {
            'use strict';
            this._lcn = null;
            
            
            (function request() {
                this._ajax({
                    url: this._widget.mailDomain(this._config.XIVA_CREDENTIALS_URL),
                    dataType: 'json',
                    data: {
                        req: this._userId
                        //req: this._passpId
                    },
                    success: function(credentials) {
                        //=log('requestXivaCredentials OK ' + (credentials && credentials.timestamp) + '  ' + (credentials && credentials.sign));
                        this._setXivaCredentials(credentials);
                        callback.call(this);
                    }, 
                    error: function() {
                        this._setTimeout(request, 15000);
                    }
                });
            }).call(this);
        },


        /**
         * Sets current Xiva credentials.
         * @private
         * @param {Object} credentials Xiva credentials.
         */
        _setXivaCredentials: function(credentials) {
            if (credentials && credentials.timestamp && credentials.ts) {
                this._xivaCredentials = credentials;
                this._xivaCredentials.expire = (new Date()).valueOf() + (parseInt(credentials.ts, 10) - parseInt(credentials.timestamp, 10)) * 1000;
            } else {
                this._xivaCredentials = null;
            }
        },


        /**
         * Returns latest Xiva credentials.
         * @private
         * @return {Object} Xiva credentials.
         */
        _getXivaCredentials: function() {
            if (!this._isValidXivaCredentials(this._xivaCredentials)) {
                this._xivaCredentials = null;
            }
            return this._xivaCredentials;
        },


        /**
         * Returns true if given |credentials| are valid Xiva credentials,
         *     return false otherwise.
         * @private
         * @param {Object} credentials Object to test.
         * @return {Boolean} Whether given credentials are valid.
         */
        _isValidXivaCredentials: function(credentials) {
            return ((credentials != null) && credentials.sign && credentials.uid && (credentials.expire > (new Date()).valueOf()));
        },

        /**
         * Parse xml with message.
         * @private
         * @param {xml} message
         */
        _parseMsgXML: function(xml) {
            if (!xml) { 
                return null; 
            }
            //=log(xml);
            xml = $.parseXML(xml);
            
            var mess = $('message', xml);
            var msgObj = {
                id: mess.attr('id'),
                folderId: $('folder', mess).attr('id'),
                date: this._helper.parseDate($('date iso', mess).text()),
                from: $('from name', mess).text(),
                to: $('to name', mess).text(),
                from_email: $('from email', mess).text(),
                to_email: $('to email', mess).text(),
                subject: $('subject', mess).text(),
                firstline: $('firstline', mess).text(),
                isUnread: (mess.children('new').length > 0),
                hasAttach: ($('flags attachment', mess).length > 0)
            };
            
            msgObj.url = 'http://mail.__maildomain__/neo2/#message/' + msgObj.id;
            msgObj.sender = { 
                name: msgObj.from, 
                email: msgObj.from_email 
            };
            return msgObj;
        },

        /**
         * Handles notification from Xiva.
         * @private
         * @param {Object} response Response body.
         */
        _handleXivaConnectionResponse: function(response) {
            var timeout = 10;
            var resp;
            var isNewData = (this._lcn !== response.lcn);
            
            //=log('xiva response ' + response.operation + ' ' + isNewData, 'g');
            
            if (isNewData) {
                
                var currtime = (new Date()).valueOf();
                if ((response.operation == 'unsupported') && (currtime - this._lastAction.time < this._lastAction.interval)) {
                    // notify about my action
                    //=log('my action', 'b');
                    isNewData = false;
                } else {
                    this._lcn = (response.lcn || this._lcn);
                    
                    resp = { operation: response.operation };
                    
                    if (response.operation == 'insert') {
                        //=log('parseMsgXML', 'b');
                        resp.msg = this._parseMsgXML(response.data);
                    }
                }
            }
            
            this._connect(timeout);
            
            if (isNewData) {
                if (typeof this._onMsg == 'function') {
                    this._onMsg(resp);
                }
            }
        },


        /**
         * Handles Xiva connection error.
         * @private
         */
        _handleXivaConnectionError: function(status, textStatus, xhr) {
            if (textStatus == 'abort') {
                return;
            }
        
            var timeout = 5000;
            if (status == 0) {
                // connection error
                timeout = 15000;
                if ((textStatus !== 'timeout')&&(this._onDisconnect)) {
                    this._onDisconnect();
                }
            }
            if (textStatus === 'timeout') {
                // js timeout
                timeout = 1;
            }
            if (status == 503) {
                
                var retryAfter = xhr.getResponseHeader('Retry-After');
                //=log('503, header Retry-After = ' + retryAfter);
                if (retryAfter) {
                    var responseDate = xhr.getResponseHeader('Date');
                    //=log('503, header Date = ' + xhr.getResponseHeader('Date'));
                    
                    responseDate = new Date(responseDate);
                    retryAfter = new Date(retryAfter);
                    
                    timeout = Math.max(retryAfter.valueOf() - responseDate.valueOf(), 30000);
                    if (isNaN(timeout)) {
                        //=log('timeout is NaN !!!', 'r');
                        timeout = 600000;
                    }
                    //=log('503, Retry-After timeout = '+timeout + ' ms', 'r');
                } else {
                    timeout = 600000; // 10 min
                }
            }
            if (status == 403) {
                // Credentials is not valid
                this._setXivaCredentials(null);
                timeout = 100;
            }
            
            this._connect(timeout);
        }
    });
})(jQuery);
;
/* ../../blocks-desktop/i-yandex-mail-notifications/i-yandex-mail-notifications.js: end */ /**/

/* ../../blocks-desktop/b-mail-actions/b-mail-actions.js: begin */ /**/
(function($) {

    BEM.DOM.decl('b-mail-actions', {

        _waitingActionItem: null,
        _handleAction: function(e) {
            'use strict';
            if (this._waitingActionItem) {
                return;
            }
            var item = $(e.target);
            this._waitingActionItem = item;
            var action = this._getItemAction(item);
            action && this._getParentMessage().handleAction(action);
        },
        
        endAction: function() {
            if (this._waitingActionItem) {
                this._waitingActionItem = null;
            }
        },

        _getItemAction: function(itemElem) {
            'use strict';
            var action;
            // XXX (jj-spoon): this.getMod() always returns empty string.
            // var action = this.getMod(itemElem, 'type');

            var KNOWN_ACTIONS_LIST = this.__self._KNOWN_ACTIONS_LIST;
            for (var i = 0, len = KNOWN_ACTIONS_LIST.length; i < len; ++i) {
                action = KNOWN_ACTIONS_LIST[i];
                var itemClass = this.__self._getItemClass(action);
                if (itemElem.hasClass(itemClass)) {
                    return action;
                }
            }
        },

        _getParentMessage: function() {
            'use strict';
            return this._message ||
                (this._message = this.findBlockOutside('b-mail-message'));
        }
    }, {
        _KNOWN_ACTIONS_LIST: [
            'readed',
            'remove',
            'spam'
        ],

        live: function() {
            'use strict';
            this.liveBindTo('leftclick', function(e) {
                e.preventDefault();
                this._handleAction(e);
            });
        },

        _getItemClass: function(type) {
            'use strict';
            // memoization
            var cacheEntryName = '__cache_' + type;
            return this._getItemClass[cacheEntryName] ||
                (this._getItemClass[cacheEntryName] = this.buildSelector('item', 'type', type).slice(1));
        }
    });

})(jQuery);
;
/* ../../blocks-desktop/b-mail-actions/b-mail-actions.js: end */ /**/

/* ../../blocks-desktop/b-mail-message/b-mail-message.js: begin */ /**/
(function($) {

    BEM.DOM.decl('b-mail-message', {
        onSetMod: {
            js: function() {
                'use strict';
                this._mailAPI = BEM.blocks['i-yandex-mail-api'];
                this._helper = BEM.blocks['i-widget-helper'];
                this._widget = BEM.blocks['i-widget-mail'];
                this._notifications = BEM.blocks['i-yandex-mail-notifications'];
                this._widgetBlock = this.findBlockOutside('b-mail-widget');

                this._id = this.domElem.attr('data-id');
            }
        },
        
        _getLink: function() {
            'use strict';
            return this._link || (this._link = this.findElem('link'));
        },

        _handleLinkClick: function() {
            'use strict';
            this._notifications.lastAction('readed');
            this._helper.logAction(this._widget.Action.OPEN_MESSAGE);
            this._widget.openURL(this._getMessageURL());
            this._widgetBlock.removeMessage(this._id);
        },

        _getMessageURL: function() {
            'use strict';
            return this._getLink().attr('href');
        },

        handleAction: function(actionName) {
            'use strict';
            this._helper.logAction(this._widget.Action.MESSAGE_ACTION);
            this._notifications.lastAction(actionName);
            switch (actionName) {
                case 'readed':
                    this._markAsRead();
                    break;
                case 'spam':
                    this._markAsSpam();
                    break;
                case 'remove':
                    this._delete();
                    break;
            }
        },
        
        _handleActionError: function() {
            this.findBlockInside('b-mail-actions').endAction();
        },

        _markAsRead: function() {
            'use strict';
            var self = this;
            this._mailAPI.markMessageAsRead(this._id, function() {
                self._widgetBlock.removeMessage(self._id);
                
                // (jj-spoon): While there is only unread messages in list,
                // it has no sense to keep them.
                // self.findBlockInside('b-mail-actions').endAction();
                // self.setMod('type', 'readed');
            }, function() {
                self._handleActionError();
            });
        },

        _markAsSpam: function() {
            'use strict';
            var self = this;
            this._mailAPI.markMessageAsSpam(this._id, function() {
                self._widgetBlock.removeMessage(self._id);
            }, function() {
                self._handleActionError();
            });
        },

        _delete: function() {
            'use strict';
            var self = this;
            this._mailAPI.deleteMessage(this._id, function() {
                self._widgetBlock.removeMessage(self._id);
            }, function() {
                self._handleActionError();
            });
        }
    }, {

        live: function() {
            'use strict';
            this.liveBindTo('link', 'leftclick', function(e) {
                e.preventDefault();
                this._handleLinkClick(e);
            });
        }
    });

})(jQuery);
;
/* ../../blocks-desktop/b-mail-message/b-mail-message.js: end */ /**/

/* ../../blocks-desktop/b-mail-widget/b-mail-widget.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-widget', {
        onSetMod: {
            js: function() {
                'use strict';
                var self = this;
                var loadListener = function() {
                    $(window).unbind('load', loadListener);
                    self.__init();
                };
                $(window).bind('load', loadListener);
            }
        },

        /**
         * Widget's alerts list. Number stands for order of alert in DOM.
         * @enum {Object.<string, number>}
         * @const
         * @private
         */
        _Alert: {
            SPINNER: 0,
            GENERIC_ERROR: 1,
            NETWORK_IS_NOT_AVAILABLE: 2,
            NO_NEW_MESSAGES: 3
        },
        
        /**
         * Known messages list.
         * @enum {String}
         */
        _KnownMessages: {
            SHOW_SLICE: 'mail-before-popup',
            HIDE_SLICE: 'mail-before-hide'
        },

        _initialized: false,
        
        _refreshTimer: null,
        
        _sliceVisible: false,
        _deferredListRefresh: false,
        
        _emailValueFromExport: '',
        

        /**
         * Block initialization.
         * XXX (jj-spoon): This method cannot be named '_init',
         *     because this name is already used in block prototype.
         * @private
         */
        __init: function() {
            'use strict';
            if (this._initialized) {
                // already initialized
                return;
            }

            this._helper = BEM.blocks['i-widget-helper'];
            this._widget = BEM.blocks['i-widget-mail'];
            this._mailAPI = BEM.blocks['i-yandex-mail-api'];
            this._auth = BEM.blocks['i-yandex-auth'];
            this._mailNotifications = BEM.blocks['i-yandex-mail-notifications'];
            this._unreadInfo = this.findBlockInside('b-mail-unread');
            this._messagesBox = this.findBlockInside('b-mail-messages');
            this._configs = BEM.blocks['i-widget-mail__config'];

            if (window.parent && window.parent.__debug_Tools_) { window.parent.__debug_Tools_(this, window); }
            
            var platform = window.platform;
            
            this._helper.init(platform, 'slice.mail.');
            
            this._helper.branding(this._configs);
            
            this._helper.platformLocalization(this);
            
            this._widget.init(platform);
            this._mailAPI.init(platform);
            this._auth.init(platform);
            this._messagesBox.init();

            this._currentFolderId = undefined;
            
            this._helper.addListener(this._KnownMessages.SHOW_SLICE, function() {
                this.findBlockInside('b-mail-options').hide();
                this._mailNotifications.ensureWork();
                //=log('*** SHOW_SLICE ***');
                this.ensureVisible(true);
            }, this);
            
            this._helper.addListener(this._KnownMessages.HIDE_SLICE, function() {
                //=log('*** HIDE_SLICE ***');
                this._sliceVisible = false;
            }, this);
            
            //=log('brandID = ' + platform.brandID);
            
            this._helper.addListener('auth.user', function(topic, auth) {
                var user = auth.getUser();
                if (null !== user) {
                    this._showUserName(user.login);
                    
                    var widget = this._widget;
                    var self = this;
                    
                    this.findBlockInside('b-mail-head').domElem.find('a').each(function() {
                        this.href = widget.mailDomain(this.href);
                    });
                    
                    this._mailNotifications.init(
                        user.id,
                        auth.getPassportId(),
                        function(resp) {
                            self._handleXivaMsg(resp);
                        },
                        function(timeout) {
                            self.refresh();
                        },
                        function() {
                            self._showError(widget.Error.NETWORK_IS_NOT_AVAILABLE);
                        });
                }
            }, this);
            
            this._auth.updateUserData();
            
            this._retryUpdating = true;
            this.refresh();
            
            this._initialized = true;
        },
        
        ensureVisible: function(doRefresh) {
            this._sliceVisible = true;
            if (doRefresh && this._deferredListRefresh) {
                this._deferredListRefresh = false;
                //=log('deffered refresh call', 'b');
                this.refresh();
            }
        },
        
        notifyWidgetMsgCount: function(count) {
            window.platform.sendMessage({
                message: "messages.unread_count",
                data: (typeof count === 'undefined') ? this._unreadInfo.getCount() : count
            });
        },
        
        _handleXivaMsg: function(resp) {
            if (resp.operation == 'insert') {
                if (!resp.msg.isUnread) {
                    //=log('*** readed msg ***', 'b');
                    return;
                }
                
                var email = this._widget.normalizeEMail(resp.msg.from_email);
                //=log('insert: from=' + email + ', exprt=' + this._emailValueFromExport + ', auth=' + this._widget.normalizeEMail(this._auth.getMailAddress()), 'b');
                if ((email == this._emailValueFromExport) || (email == this._widget.normalizeEMail(this._auth.getMailAddress()))) {
                    //=log('*** my msg ***', 'b');
                    return;
                }
                 
                var self = this;
                function insert() {
                    // =log(JSON.stringify(resp.msg));
                
                    self._insertMessages([resp.msg], true);
                    self._unreadInfo.setCount(self._unreadInfo.getCount() + 1);
                    self.notifyWidgetMsgCount();
                    
                    resp.msg.url = self._widget.prepareURL(resp.msg.url);
                    window.platform.sendMessage({
                        message: "messages.new",
                        data: {
                            inbox_url: self._widget.prepareURL('http://mail.__maildomain__/neo2/#inbox'),
                            messages: [ resp.msg ]
                        }
                    });
                }
                
                this._mailAPI.getFoldersList(function(folders) {
                        var folder = folders.map[resp.msg.folderId];
                        //=log('folder.ignoreXivaInsert = ' + (folder ? folder.ignoreXivaInsert : false), 'b');
                        if (folder && folder.ignoreXivaInsert) {
                            return;
                        }
                        insert();
                    },
                    insert, true);
            } else {
                this._setRefreshTimeout(1500);
            }
        },
        
        _platform_i18n: function() {
            //var l18n_blocks = ['b-mail-unread'];
            for(var bl in BEM.blocks) {
                if (/^b-/.test(bl)) {
                    var blocks = this.findBlocksInside(bl);
                    if (blocks) {
                        for (var i=0; i<blocks.length; ++i) {
                            if (blocks[i].platform_i18n) {
                                blocks[i].platform_i18n(this._helper, i);
                            }
                        }
                    }
                }
            }
        },
        
        _setRefreshTimeout: function(timeout) {
            var self = this;
            if (self._refreshTimer) {
                clearTimeout(self._refreshTimer);
                self._refreshTimer = null;
                //=log('clear refreshTimer', 'b'); 
            }
            
            //=log('setRefreshTimeout ' + timeout);
            self._refreshTimer = setTimeout(function() {
                self._refreshTimer = null;
                self.refresh();
            }, timeout);
        },

        /**
         * Refreshes widget state.
         */
        refresh: function(fId, opt_minSpinnerTime) {
            'use strict';
            var DEFAULT_FOLDER_ID = 'unread';
            var folderId = fId || this._currentFolderId || DEFAULT_FOLDER_ID;
            this.showMessagesInFolder(folderId, null, opt_minSpinnerTime);
        },
        
        

        /**
         * Show messages from folder w/ id |fid|.
         * @param {String} fid Folder id.
         * @param {(Number|String)=} opt_page Messages page. Optional.
         */
        showMessagesInFolder: function(fid, opt_page, opt_minSpinnerTime) {
            'use strict';
            if (this._updatingMsgList || this._refreshTimer) {
                return;
            }
            
            //=log('refresh begin');
            this._updatingMsgList = true;
            this._showAlert(this._Alert.SPINNER);

            // Save current folder id.
            this._currentFolderId = fid;

            var self = this;
            
            this.getMessagesList(fid, opt_page, 
                (function(folderInfo, messages) {
                    self._updatingMsgList = false;
                    self._retryUpdating = false;
                    //=log('refresh success', 'g');
                    folderInfo.folderId = fid;
                    self._handleMessageList(folderInfo, messages);
                    
                }).callbackDelay(opt_minSpinnerTime), 
                (function(error) {
                    self._updatingMsgList = false;
                    //=log('refresh error ' + error, 'r');
                    self._showError(error);
                    if (self._retryUpdating) {
                        self._retryUpdating = false;
                        //=log('retryUpdating !!!!!', 'b');
                        self._setRefreshTimeout(1200);
                    }
                }).callbackDelay(opt_minSpinnerTime));
        },

        /**
         * Requests messages list in folder w/ id |folderId|.
         * @private
         * @param {String} folderId Mail folder id.
         * @param {(Number|String)=} opt_page Messages page.
         *      Optional, by default request all pages.
         * @param {Function} successCallback Success callback.
         * @param {Function} errorCallback Error callback.
         */
        getMessagesList: function(folderId, opt_page, successCallback, errorCallback) {
            if ('function' === typeof opt_page) {
                // seconds argument is omitted
                errorCallback = successCallback;
                successCallback = opt_page;
                opt_page = null;
            }
            
            var page = opt_page || 1;
            var widget = this._widget;
            var mailAPI = this._mailAPI;
            var maxMsgCount = this._messagesBox.getMaxVisibleCount() * 2;
            
            var result = { folder: null, messages: [] };
            var msgIDs = {};
            
            var unreadCount = 0;
            
            function getListCallback(folder, messages) {
                if (!result.folder) {
                    result.folder = folder;
                    if (unreadCount) {
                        result.folder.unreadCount = unreadCount;
                    }
                }
                for (var i=0; i<messages.length; ++i) {
                    if (!msgIDs[messages[i].id]) {
                        msgIDs[messages[i].id] = true;
                        result.messages.push(messages[i]);
                    }
                }
                if (!opt_page && (result.messages.length < Math.min(maxMsgCount, result.folder.unreadCount))) {
                    page++;
                    getList();
                } else {
                    successCallback(result.folder, result.messages);
                }
            }
            
            function handleError(jqXHR, textStatus, errorThrown) {
                var errorType = (jqXHR && (0 === jqXHR.status || 600 < jqXHR.status)) ?
                    'NETWORK_IS_NOT_AVAILABLE' :
                    'GENERIC';
                errorCallback(widget.Error[errorType]);
            }
            
            function getList() {
                self._deferredListRefresh = false;
                mailAPI.getMessagesInFolder({id: folderId, page: page},
                    getListCallback,
                    function() {
                        result.folder = result.folder || {unreadCount: unreadCount, folderId: folderId};
                        result.folder.apiError = true;
                        successCallback(result.folder, result.messages)
                    });
            };
            
            var self = this;
            mailAPI.getCounterInfo(function(data) {
                if (!self._emailValueFromExport && data.login) {
                    var domain = self._auth.getYandexDomain();
                    if (domain) {
                        self._emailValueFromExport = self._widget.normalizeEMail(data.login + '@' + domain);
                        //=log('self._emailValueFromExport = ' + self._emailValueFromExport);
                    }
                }
                unreadCount = data.count;
                
                
                if (self._sliceVisible) {
                    //=log('FULL refresh', 'b');
                    if (unreadCount) { 
                        getList(); 
                    } else {
                        successCallback({unreadCount: unreadCount, folderId: folderId}, result.messages)
                    }
                } else {
                    //=log('DEFFERED refresh', 'b');
                    self._deferredListRefresh = true;
                    successCallback({unreadCount: unreadCount, folderId: folderId}, result.messages);
                }
            }, handleError);
            
            
        },

        /**
         * Handles API response for messages list request.
         * @private
         * @param {Object} folderInfo Folder info.
         * @param {Array.<object>} messages Messages list.
         */
        _handleMessageList: function(folderInfo, messages) {
            'use strict';
            this._messagesBox.clear();
            if (folderInfo.folderId === 'unread') {
                this._unreadInfo.setCount(0);
            }
            this._showMessagesList(messages, folderInfo.apiError);
            // TODO (jj-spoon): If folder is 'unread', notify widget about
            // number of messages in it.
            if (folderInfo.folderId === 'unread') {
                this._unreadInfo.setCount(folderInfo.unreadCount);
                this.notifyWidgetMsgCount();
                //=log('showMessagesList ' + this._unreadInfo.getCount());
            }
        },

        /**
         * Show list of |messages| to user.
         * @private
         * @param {Array} messages Messages list.
         */
        _showMessagesList: function(messages, apiError) {
            'use strict';
            
            if (this._deferredListRefresh) {
                this._hideAllAlerts();
                return;
            }

            if ((0 == messages.length) && !apiError) {
                this._showAlert(this._Alert.NO_NEW_MESSAGES);
            }
            else {
                this._insertMessages(messages);
            }
        },
        
        /**
         * Removes message w/ id |messageId| from list.
         * @param {Number} messageId
         * @return {Boolean} Was message removed or not.
         */
        removeMessage: function(messageId) {
            var result = this._messagesBox.removeMessage(messageId);
            if (result) {
                this._decrementUnread();
                var len = this._messagesBox.getCount();
                //=log('message count = ' + len);
                if (0 === len) {
                    this._showAlert(this._Alert.NO_NEW_MESSAGES);
                } else {
                    if ((len < this._messagesBox.getMaxVisibleCount()) && (this._unreadInfo.getCount() > len)) {
                        //=log('refresh after removeMessage');
                        this.refresh();
                    }
                }
            }
            return result;
        },

        /**
         * Inserts messages blocks to container.
         * @param {Array.<object>} messages Messages list.
         * @private
         */
        _insertMessages: function(messages, bFirst) {
            this._hideAllAlerts();
            this._messagesBox.insertMessages(messages, bFirst);
        },
        
        /**
         * decrement unread count.
         */
        _decrementUnread: function() {
            this._unreadInfo.setCount(this._unreadInfo.getCount() - 1);
            this.notifyWidgetMsgCount();
        },

        

        /**
         * Shows error to user.
         * @param {Number} error Error id.
         * @private
         */
        _showError: function(error) {
            'use strict';
            this._hideAlert(this._Alert.SPINNER);
            this._unreadInfo.setCount(0);
            this.notifyWidgetMsgCount();
            switch (error) {
                case this._widget.Error.GENERIC:
                    this._showAlert(this._Alert.GENERIC_ERROR);
                    break;
                case this._widget.Error.NETWORK_IS_NOT_AVAILABLE:
                    this._showAlert(this._Alert.NETWORK_IS_NOT_AVAILABLE);
                    break;
            }
        },

        /**
         * Returns widget alerts list.
         * @return {*}
         * @private
         */
        _getAlertsList: function() {
            'use strict';
            return this._alerts ||
                (this._alerts = this.findBlocksInside('b-mail-alerts'));
        },

        /**
         * Returns alert block by it's index.
         * @param {String} alertIndex Alert index.
         * @return {*}
         * @private
         */
        _getAlert: function(alertIndex) {
            'use strict';
            return this._getAlertsList()[alertIndex];
        },

        /**
         * Shows alert.
         * @private
         * @param {String} alertType Type of alert to show.
         */
        _showAlert: function(alertType) {
            'use strict';
            this._hideAllAlerts();
            // TODO (jj-spoon): Hide messages list.
            this._getAlert(alertType).domElem.show();
        },

        /**
         * Hides alert.
         * @private
         * @param {String} alertType Type of alert to show.
         */
        _hideAlert: function(alertType) {
            'use strict';
            this._getAlert(alertType).domElem.hide();
        },

        /**
         * Hides all widget alerts.
         * @private
         */
        _hideAllAlerts: function() {
            'use strict';
            for (var i in this._Alert) {
                if (this._Alert.hasOwnProperty(i)){
                    this._hideAlert(this._Alert[i]);
                }
            }
        },

        /**
         * Shows user login in settings menu.
         * @private
         */
        _showUserName: function(login) {
            'use strict';
            var userBlock = this.findBlockInside('b-mail-user');
            userBlock.setUser(login);
        }
    }, {

    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-widget/b-mail-widget.js: end */ /**/

/* ../../blocks-desktop/b-mail-logo/b-mail-logo.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-logo', {
        _handleClick: function(e) {
            e.preventDefault();

            var url = this._getLink().domElem.attr('href');
            var helper = this._getHelper();
            var widget = this._getWidget();
            helper.logAction(widget.Action.CLICK_LOGO);
            widget.openURL(url);
        },

        _getLink: function() {
            return this._link ||
                (this._link = this.findBlockInside('b-link'));
        },

        _getHelper: function() {
            return this._helper ||
                (this._helper = BEM.blocks['i-widget-helper']);
        },

        _getWidget: function() {
            return this._widget ||
                (this._widget = BEM.blocks['i-widget-mail']);
        },
        platform_i18n: function(helper, i) {
            var url = '/mail/logo.png'; // using platform xb localization
            this.domElem.find('.b-icon')
                .attr('alt', helper.localStr('logo'))
                .attr('src', url)
                .parent().css('backgroundImage', 'url("' + url + '")').attr('title', helper.localStr('tt.logo'));
        }
    }, {
        live: function() {
            this.liveBindTo('leftclick', function(e) {
               this._handleClick(e);
            });
        }
    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-logo/b-mail-logo.js: end */ /**/

/* ../../lego/blocks-desktop/b-link/b-link.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.HTML */

BEM.HTML.decl('b-link', {
    onBlock: function(ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'));

        var props = ['title', 'target'], p;
        while(p = props.pop()) ctx.param(p) && (ctx.attr(p, ctx.param(p)));
    }
});
;
/* ../../lego/blocks-desktop/b-link/b-link.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: begin */ /**/
/**
 * leftClick event plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.0.0
 */

(function($) {

var leftClick = $.event.special.leftclick = {

    setup : function() {

        $(this).bind('click', leftClick.handler);

    },

    teardown : function() {

        $(this).unbind('click', leftClick.handler);

    },

    handler : function(e) {

        if(!e.button) {
            e.type = 'leftclick';
            $.event.handle.apply(this, arguments);
            e.type = 'click';
        }

    }

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: end */ /**/

/* ../../lego/bem-bl/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: begin */ /**/
BEM.DOM.decl({'name': 'b-link', 'modName': 'pseudo', 'modVal': 'yes'}, {

    _onClick : function(e) {

        e.preventDefault();

        this.hasMod('disabled', 'yes') || this.afterCurrentEvent(function() {
            this.trigger('click');
        });

    }

}, {

    live : function() {

        this.__base.apply(this, arguments);

        this.liveBindTo({ modName : 'pseudo', modVal : 'yes' }, 'leftclick', function(e) {
            this._onClick(e);
        });

    }

});
;
/* ../../lego/bem-bl/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: end */ /**/

/* ../../lego/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.HTML */

BEM.HTML.decl({name: 'b-link', modName: 'pseudo', modVal: 'yes'}, {
    onBlock: function(ctx) {
        ctx.tag(ctx.param('url') ? 'a': 'span');

        ctx.wrapContent({ elem : 'inner' });
    },

    onElem : {
        'inner': function(ctx) {
            ctx.tag('span');
        }
     }
});

;
/* ../../lego/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: end */ /**/

/* ../../lego/blocks-desktop/b-icon/b-icon.js: begin */ /**/
BEM.HTML.decl('b-icon', {

    onBlock : function(ctx) {

        var a = { src: '//yandex.st/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif', alt: '' },
            params = ctx.params(),
            props = ['alt', 'width', 'height'], p;

        params.url && (a.src = params.url);
        while(p = props.shift()) params[p] && (a[p] = params[p]);

        ctx
           .tag('img')
           .attrs(a);

    }

});
;
/* ../../lego/blocks-desktop/b-icon/b-icon.js: end */ /**/

/* ../../blocks-desktop/b-mail-create/b-mail-create.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-create', {
        _handleClick: function(e) {
            'use strict';
            e.preventDefault();

            var url = this._getLink().domElem.attr('href');
            var helper = this._getHelper();
            var widget = this._getWidget();
            
            helper.logAction(widget.Action.CLICK_COMPOSE_NEW);
            widget.openURL(url);
        },

        _getLink: function() {
            'use strict';
            return this._link ||
                (this._link = this.findBlockInside('b-link'));
        },

        _getHelper: function() {
            'use strict';
            return this._helper ||
                (this._helper = BEM.blocks['i-widget-helper']);
        },

        _getWidget: function() {
            'use strict';
            return this._widget ||
                (this._widget = BEM.blocks['i-widget-mail']);
        },
        platform_i18n: function(helper) {
            //=log('b-mail-create locale: tip=' + helper.localStr('tt.create'));
            this.domElem.attr('title', helper.localStr('tt.create'));
            this.domElem.find('img').attr('alt', helper.localStr('create'));
        }
    }, {
        live: function() {
            'use strict';
            this.liveBindTo('leftclick', function(e) {
                this._handleClick(e);
            });
        }
    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-create/b-mail-create.js: end */ /**/

/* ../../blocks-desktop/b-mail-unread/b-mail-unread.js: begin */ /**/
BEM.DOM.decl('b-mail-unread', {

    _count: 0,
    setCount: function(count) {
        if (typeof count === 'string') {
            count = parseInt(count, 10);
        }
        if ((typeof count === 'number') && !isNaN(count)) {
            this._count = Math.max(count, 0);
            this.elem('count').text(count||'');
        }
    },
    getCount: function(count) {
        return this._count || 0;
    },
    
    platform_i18n: function(helper) {
        var c = this.elem('title');
        c.text(helper.localStr('ft.unread'));
    }
});
;
/* ../../blocks-desktop/b-mail-unread/b-mail-unread.js: end */ /**/

/* ../../blocks-desktop/b-mail-refresh/b-mail-refresh.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-refresh', {
        _refresh: function() {
            'use strict';
            this._getHelper().logAction(this._getWidget().Action.CLICK_REFRESH);
            var widget = this._getWidgetBlock();
            widget.ensureVisible();
            widget.refresh('', 800);
        },

        _getWidgetBlock: function() {
            'use strict';
            return this._widgetBlock ||
                (this._widgetBlock = this.findBlockOutside('b-mail-widget'));
        },

        _getWidget: function() {
            'use strict';
            return this._widget ||
                (this._widget = BEM.blocks['i-widget-mail']);
        },

        _getHelper: function() {
            'use strict';
            return this._helper ||
                (this._helper = BEM.blocks['i-widget-helper']);
        },
        platform_i18n: function(helper) {
            this.domElem.attr('title', helper.localStr('tt.refresh'));
            this.domElem.find('img').attr('alt', helper.localStr('refresh'));
        }
    }, {
        live: function() {
            'use strict';
            this.liveBindTo('leftclick', function(e) {
                this._refresh();
            });
        }
    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-refresh/b-mail-refresh.js: end */ /**/

/* ../../blocks-desktop/b-mail-user/b-mail-user.js: begin */ /**/
(function() {
    BEM.DOM.decl('b-mail-user', {
            setUser: function(name) {
                'use strict';
                var firstLetter = name.slice(0, 1);
                this._getUserBlock().elem('first-letter').text(firstLetter);

                var tail = name.slice(1);
                this._getUserBlock().domElem.append(tail);
            },

            _getUserBlock: function() {
                'use strict';
                return this._userBlock ||
                    (this._userBlock = this.findBlockInside('b-user'));
            },

            _toggleSettings: function() {
                'use strict';
                this._getSettingsBlock().toggle();
            },

            _getWidgetBlock: function() {
                'use strict';
                return this._widgetBlock ||
                    (this._widgetBlock = this.findBlockOutside('b-mail-widget'));
            },

            _getSettingsBlock: function() {
                'use strict';
                return this._settings ||
                    (this._settings = this._getWidgetBlock().findBlockInside({
                        block: 'b-mail-options',
                        modName: 'type',
                        modVal: 'settings'
                    }));
            }
        },
        {
            live: function() {
                'use strict';
                this.liveBindTo('leftclick', function(e) {
                    if (e.target != this.domElem[0]) {
                        this._toggleSettings();
                    }
                });
            }
        });
})();
;
/* ../../blocks-desktop/b-mail-user/b-mail-user.js: end */ /**/

/* ../../lego/blocks-desktop/i-common/string/i-common__string.js: begin */ /**/
(function(Lego){
if(!Lego) Lego = window.Lego = {};

var ellipsisChar = '…';

/**
 * Обрезать входную строку `str` до `maxLength` символов.
 * Порт функции `lego:clever-substring()` из i-common.xsl.
 *
 * @param {String} str строка на вход
 * @param {Nubmer} maxLength максимальная длина в символах
 * @param {Number} maxLengthRelative погрешность при обрезе сверх макс. длины
 *
 * @return {String}
 */
Lego.cleverSubstring = function(str, maxLength, maxLengthRelative) {
    return (str.length > maxLength + maxLengthRelative) ? str.substring(0, maxLength - 1) + ellipsisChar : str;
}


/**
 * Экранирование специальных символов HTML
 *
 * @param {String} str экранируемая строка
 *
 * @return {String}
 */
 Lego.escapeHTML = (function() {

    var map = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': '&quot;',
            "'": '&#39;'
        },
        f = function(t) { return map[t] || t };

    return function(string) {
        return String(string).replace(/&(?!\w+;)|[<>"']/g, function(s) {
            return map[s] || s
        });
    }

 })();

})(window.Lego);
;
/* ../../lego/blocks-desktop/i-common/string/i-common__string.js: end */ /**/

/* ../../blocks-desktop/b-mail-alerts/b-mail-alerts.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-alerts', {

        onSetMod: {
            js: function() {
                'use strict';
                var link = this._getLink();
                if (null === link) {
                    return;
                }

                var self = this;
                link.domElem.click(function(e) {
                    self._handleClick(e);
                });
            }
        },

        _handleClick: function(e) {
            'use strict';
            e.preventDefault();

            var link = this._getLink();

            var isRefreshButton = ('refresh' === link.getMod('type'));
            if (isRefreshButton) {
                this._getWidgetBlock().refresh();
                return;
            }

            var url = link.domElem.attr('href');
            if (!url) {
                return;
            }

            // XXX (jj-spoon): The only link in alerts for now is link to
            // mail web interface.
            var helper = this._getHelper();
            var widget = this._getWidget();
            helper.logAction(widget.Action.CLICK_GO_TO_WEB);
            widget.openURL(url);
        },

        _getLink: function() {
            'use strict';
            return this._link ||
                (this._link = this.findBlockInside('b-link'));
        },

        _getHelper: function() {
            'use strict';
            return this._helper ||
                (this._helper = BEM.blocks['i-widget-helper']);
        },

        _getWidget: function() {
            'use strict';
            return this._widget ||
                (this._widget = BEM.blocks['i-widget-mail']);
        },

        _getWidgetBlock: function() {
            'use strict';
            return this._widgetBlock ||
                (this._widgetBlock = this.findBlockOutside('b-mail-widget'));
        },
        platform_i18n: function(helper, i) {
            var types = this._getWidgetBlock()._Alert;
            var msg = this.elem('message');
            
            if (i === types.SPINNER) {
                msg.text(helper.localStr('wait'));
            }
            if (i === types.GENERIC_ERROR) {
                this.findBlockInside('b-icon').domElem.attr('alt', helper.localStr('error.refresh'));
                msg.text(helper.localStr('error.refresh'));
                this._getLink().elem('inner').text(helper.localStr('retry'));
            }
            
            if (i === types.NETWORK_IS_NOT_AVAILABLE) {
                this.findBlockInside('b-icon').domElem.attr('alt', helper.localStr('error.net'));
                msg.text(helper.localStr('error.net'));
            }
            
            if (i === types.NO_NEW_MESSAGES) {
                this.findBlockInside('b-icon').domElem.attr('alt', helper.localStr('nounread'));
                msg.text(helper.localStr('nounread'));
                this._getLink().elem('inner').text(helper.localStr('continuewm'));
            }
        }
    }, {
    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-alerts/b-mail-alerts.js: end */ /**/

/* ../../blocks-desktop/b-mail-options/b-mail-options.js: begin */ /**/
(function ($) {
    BEM.DOM.decl({name: 'b-mail-options', modName: 'type', modVal: 'settings'}, {

            onSetMod: {
              js: function() {
                  this._auth = BEM.blocks['i-yandex-auth'];
                  this._helper = BEM.blocks['i-widget-helper'];
                  this._widget = BEM.blocks['i-widget-mail'];
              }
            },

            toggle: function() {
                'use strict';
                this.toggleMod('hidden', 'yes', 'no');
            },

            hide: function(topic) {
                'use strict';
                this.setMod('hidden', 'yes');
            },

            _handleItemClick: function (e) {
                'use strict';
                var target = $(e.target),
                    // TODO (jj-spoon): Try to avoid using of hardcoded element's class.
                    item = this.findBlockOutside(target, 'b-mail-options__item'),
                    link = item.findBlockInside('b-link'),
                    url = link.domElem.attr('href');
                if (e.target != item.domElem[0]) {
                    this.hide();
                    this._handleURL(url);
                }
            },

            _handleURL: function (url) {
                'use strict';
                var ACTION_PREFIX = 'action:';
                if (url.indexOf(ACTION_PREFIX) !== -1) {
                    var actionName = url.replace(ACTION_PREFIX, '');
                    this._performAction(actionName);
                }
                else {
                    // XXX (jj-spoon) Collector link is the only link in menu for now.
                    this._helper.logAction(
                        this._widget.Action.CLICK_COLLECTOR_LINK);
                    this._widget.openURL(url);
                }
            },

            _performAction: function (actionName) {
                'use strict';
                switch (actionName) {
                    case 'logout':
                        this._auth.logout();
                        break;

                    case 'open-settings':
                        this._helper.openSettings();
                        break;

                    default:
                        break;
                }
            },
            
            platform_i18n: function(helper) {
                this.domElem.find('a[href="action:open-settings"] .b-link__inner').text(helper.localStr('settings'));
                this.domElem.find('a[href="action:logout"] .b-link__inner').text(helper.localStr('logout'));
            }
        },
        {
            live: function () {
                'use strict';
                this.liveBindTo('item', 'click', function (e) {
                    e.preventDefault();
                    this._handleItemClick(e);
                });
            }
        }
    );
})(jQuery);
;
/* ../../blocks-desktop/b-mail-options/b-mail-options.js: end */ /**/

/* ../../blocks-desktop/b-mail-messages/b-mail-messages.js: begin */ /**/
(function($) {
    BEM.DOM.decl('b-mail-messages', {
    
        _content: null,
        _bar: null,
        _box: null,
        
        _list: null,
        
        _sbarWidth: 11,
        
        _count: 0,
        
        _scrollBarVisible: false,
    
        init: function() {
            this._helper = BEM.blocks['i-widget-helper'];
            this._widget = BEM.blocks['i-widget-mail'];
            this._config = BEM.blocks['i-widget-mail__config'].current;
        
            this._box = this.elem('box');
            this._content = this.elem('content');
            this._list = this.elem('list');
            
            this._list.css('maxHeight', (this._config.maxVisibleMsgCount * 52 - 1) + 'px');
            
            this._bar = this.elem('bar');
            this._bardrag = this.elem('bardrag');
            this._sbarWidth = this._bar.outerWidth();
            this._updateScrollBar();
            
            this._initScrollBarEvents();
            
            this.findBlockInside('b-mail-over30').init();
        },
        
        _updateScrollBar: function() {
            var contentHeight = this._content.height();
            var height = this.domElem.height();
            var parentWidth = this.domElem.width();
            
            this._scrollBarVisible = (contentHeight > height);
            if (this._scrollBarVisible) {
                var scrollTop = this._box.scrollTop();
                var hDrag = height * height / contentHeight;
                var tDrag = scrollTop * (height - hDrag) / (contentHeight - height);
                
                this._content.css('width', (parentWidth - this._sbarWidth) + 'px');
                this._bardrag.css({height: Math.round(hDrag) + 'px', top: Math.round(tDrag) + 'px'});
                this._bar.css({display: 'block'});
            } else {
                this._bar.css('display', 'none');
                this._content.css('width', parentWidth + 'px');
            }
        },
        
        _initScrollBarEvents: function() {
            var self = this;
            this._box.bind('scroll', function() {
                self._updateScrollBar();
            });
        
            // drag-n-drop
            var yd, scrolld, contentHeight, height, hDrag;
            var doc = $(document);
            function mouseMove(e) {
                if (e.which != 1) {
                    return mouseUp(e);
                }
                var delta = e.pageY - yd;
                self._box.scrollTop(scrolld + Math.round(delta * (contentHeight - height) / (height - hDrag)));
                e.preventDefault();
                return false;
            }
            function mouseUp(e) {
                doc.unbind('mousemove', mouseMove).unbind('mouseup', mouseUp);
                e.preventDefault();
                return false;
            }
            this._box.bind('mousedown', function(e) {
                if (!self._scrollBarVisible) {
                    return;
                }
                yd = e.pageY;
                scrolld = self._box.scrollTop();
                contentHeight = self._content.height();
                height = self.domElem.height();
                hDrag = height * height / contentHeight;
                var dragTop = self._bardrag.offset().top;
                
                if (yd < dragTop) {
                    self._box.scrollTop(scrolld - 300);
                    return false;
                } 
                if (yd > dragTop + hDrag) {
                    self._box.scrollTop(scrolld + 300);
                    return false;
                }
                doc.bind('mousemove', mouseMove).bind('mouseup', mouseUp);
                return false;
            });
            this._content.bind('mousedown', function(e) {
                e.stopPropagation();
                return false;
            });
        },
    
    
        getCount: function() {
            return this._count;
        },
        
        getMaxVisibleCount: function() {
            return this._config.maxVisibleMsgCount;
        },
        
        clear: function() {
            var messages = this.findBlocksInside('b-mail-message');
            for (var i = 0, len = messages.length; i < len; ++i) {
                var message = messages[i];
                message.destruct();
            }
            this._count = 0;
            this._updateScrollBar();
        },
        
        /**
         * Removes message w/ id |messageId| from list.
         * @param {Number} messageId
         * @return {Boolean} Was message removed or not.
         */
        removeMessage: function(messageId) {
            var messages = this.findBlocksInside('b-mail-message');
            for (var i = 0, len = messages.length; i < len; ++i) {
                var currentMessage = messages[i];
                var currentMessageId = currentMessage.domElem.attr('data-id');
                if (currentMessageId === messageId) {
                    currentMessage.destruct();
                    this._count--;
                    this._updateScrollBar();
                    return true;
                }
            }
            return false;
        },

        /**
         * Inserts messages blocks to container.
         * @param {Array.<object>} messages Messages list.
         * @private
         */
        insertMessages: function(messages, bFirst) {
            if (!messages.length) {
                return;
            }
            
            var list = this.elem('list');
            
            for (var i = 0, len = messages.length; i < len; ++i) {
                var data = messages[i];
                BEM.DOM[bFirst ? 'prepend' : 'append'](list, this._createMessage(data));
                this._count++;
            }
            this._updateScrollBar();
        },
        
        /**
         * Create block for single message.
         * @private
         * @param {Object} messageData Message data.
         * @return {Object}
         */
        _createMessage: function(messageData) {
            var blockContent = [];
            var blockConfig = {
                block: 'b-mail-message',
                js: true,
                attrs: {
                    'data-id': messageData.id
                },
                content: blockContent
            };
            if (!messageData.isUnread) {
                blockConfig.mods = {
                    type: 'readed'
                }
            }

            var linkContent = [];
            var link = {
                elem: 'link',
                tag: 'a',
                attrs: {
                    href: messageData.url
                },
                content: linkContent
            };
            var date = this._widget.getHumanFriendlyDate(messageData.date);
            var leftPart = {
                elem: 'left',
                    content: [
                    {
                        elem: 'from',
                        attrs: { title: messageData.sender.email },
                        content: (messageData.sender.name || messageData.sender.email).toHTML()
                    },
                    {
                        elem: 'date',
                        title: date,
                        content: date
                    }
                ]
            };
            linkContent.push(leftPart);

            var rightPartContent = [
                {
                    elem: 'subject',
                    content: messageData.subject.toHTML() || '&#160;'
                },
                {
                    elem: 'firstline',
                    content: messageData.firstline.toHTML() || '&#160;'
                }
            ];
            if (messageData.hasAttach) {
                // insert as first element of array
                rightPartContent.splice(0, 0, {
                    elem: 'attach',
                    attrs: { title: this._helper.localStr('attach') },
                    content: [
                        {
                            block: 'b-icon',
                            url: 'img/b-icon-empty.gif',
                            alt: this._helper.localStr('attach')
                        }
                    ]
                });
            }
            var rightPart =  {
                elem: 'right',
                content: rightPartContent
            };
            linkContent.push(rightPart);

            blockContent.push(link);

            var actions = {
                block: 'b-mail-actions',
                js: true,
                content: [
                    {
                        elem: 'item',
                        tag: 'span',
                        mods: { type: 'readed' },
                        attrs: { title: this._helper.localStr('setreaded') },
                        content: [
                            {
                                block: 'b-icon',
                                url: 'img/b-icon-empty.gif',
                                alt: this._helper.localStr('setreaded')
                            }
                        ]
                    },
                    {
                        elem: 'item',
                        tag: 'span',
                        mods: { type: 'remove' },
                        attrs: { title: this._helper.localStr('delete') },
                        content: [
                            {
                                block: 'b-icon',
                                url: 'img/b-icon-empty.gif',
                                alt: this._helper.localStr('delete')
                            }
                        ]
                    },
                    {
                        elem: 'item',
                        tag: 'span',
                        mods: { type: 'spam' },
                        attrs: { title: this._helper.localStr('spam') },
                        content: [
                            {
                                block: 'b-icon',
                                url: 'img/b-icon-empty.gif',
                                alt: this._helper.localStr('spam')
                            }
                        ]
                    }
                ]
            };
            blockContent.push(actions);

            return BEM.HTML.build(blockConfig);
        }
    }, {
        
    });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-messages/b-mail-messages.js: end */ /**/

/* ../../blocks-desktop/b-mail-over30/b-mail-over30.js: begin */ /**/
BEM.DOM.decl('b-mail-over30', {

    _getWidget: function() {
        'use strict';
        return this._widget ||
            (this._widget = BEM.blocks['i-widget-mail']);
    },
    _getHelper: function() {
        'use strict';
        return this._helper ||
            (this._helper = BEM.blocks['i-widget-helper']);
    },
    
    _handleLinkClick: function(e) {
        'use strict';
        this._getHelper().logAction(this._getWidget().Action.CLICK_GO_TO_WEB);
        this._getWidget().openURL(this.findBlockInside('b-link').domElem.attr('href'));
    },
    init: function() {
        if (this._inited) {
            return;
        }
        this._inited = true;
        this._getHelper().addListener('auth.user', function(topic, auth) {
            var a = this._link.domElem[0];
            a.href = this._getWidget().mailDomain(a.href);
        }, this);
    },
    
    platform_i18n: function(helper) {
        this._link = this.findBlockInside('b-link');
        this._link.elem('inner').text(helper.localStr('continuewm'));
    }
},{
    live: function() {
        'use strict';
        this.liveBindTo('inner', 'leftclick', function(e) {
            e.preventDefault();
            this._handleLinkClick(e);
            return false;
        });
    }
});
;
/* ../../blocks-desktop/b-mail-over30/b-mail-over30.js: end */ /**/

/* ../../blocks-desktop/b-mail-foot/b-mail-foot.js: begin */ /**/
(function($) {

    BEM.DOM.decl('b-mail-foot', {
            onSetMod: {
                js: function() {
                    'use strict';
                    var self = this;
                    var loadListener = function() {
                        $(window).unbind('load', loadListener);
                        self.__init();
                    };
                    $(window).bind('load', loadListener);
                }
            },

            __init: function() {
                'use strict';
                var self = this;
                this._platform = window.platform;

                this.domElem.on('leftclick', function(e) {
                    self._handleClick(e);
                });

                this._updateContentState();

                if ('undefined' !== typeof this._platform &&
                    'function' === typeof this._platform.observeSettings) {
                    this._platform.observeSettings(function (name, value) {
                        if ('showCollectorOffer' === name) {
                            self._updateContentState();
                        }
                    });
                }
            },

            _handleClick: function(e) {
                'use strict';
                var link = this.findBlockOutside($(e.target), 'b-link');
                if (!link) {
                    return;
                }

                switch (true) {
                    case link.hasMod('is-collector-link'):
                        this._goToCollector();
                        break;
                    case link.hasMod('hide-collector'):
                        if ('undefined' !== typeof this._platform &&
                            'function' === typeof this._platform.setOption) {
                            this._platform.setOption('showCollectorOffer', false);
                        }
                        this.hideContent();
                        break;
                    default:
                        break;
                }
            },

            _updateContentState: function() {
                'use strict';
                if ('undefined' === typeof this._platform ||
                    'function' !== typeof this._platform.getOption) {
                    return;
                }

                if (true === this._platform.getOption('showCollectorOffer')) {
                    this.showContent();
                }
                else {
                    this.hideContent();
                }
            },

            showContent: function() {
                'use strict';
                this.setMod('hidden', 'no');
            },

            hideContent: function() {
                'use strict';
                this.setMod('hidden', 'yes');
            },

            _goToCollector: function() {
                'use strict';
                var link = this._getCollectorLink(),
                    url = link.domElem.attr('href'),
                    helper = this._getHelper(),
                    widget = this._getWidget();

                helper.logAction(widget.Action.CLICK_COLLECTOR_LINK);
                widget.openURL(url);
            },

            _getCollectorLink: function() {
                'use strict';
                return this._collectorLink ||
                    (this._collectorLink = this.findBlockInside({
                        block: 'b-link',
                        modName: 'is-collector-link',
                        modVal: 'true'
                    }));
            },

            _getHelper: function() {
                'use strict';
                return this._helper ||
                    (this._helper = BEM.blocks['i-widget-helper']);
            },

            _getWidget: function() {
                'use strict';
                return this._widget ||
                    (this._widget = BEM.blocks['i-widget-mail']);
            }
        },
        {

        });
})(jQuery);
;
/* ../../blocks-desktop/b-mail-foot/b-mail-foot.js: end */ /**/



// XXX: Support tanker-like syntax of keys in `i-bem__i18n`
// i18n['prj']['keyset']['key'](params);
var i18n = i18n || {};

(function(bem_, undefined) {

var cache = {},
    // {String[]} A stack used for restoring context with dynamic keysets
    stack = [],
    /** {String} */
    MOD_DELIM = '_',
    /** {String} */
    ELEM_DELIM = '__',
    /** {String} */
    DEFAULT_LANG = 'ru';

function bemName(decl) {

    typeof decl === 'string' && (decl = { block: decl });

    return decl.block +
        (decl.elem ? (ELEM_DELIM + decl.elem) : '') +
        (decl.modName ? MOD_DELIM + decl.modName + MOD_DELIM + decl.modVal : '');

}

function bemParse(name) {

    var bemitem = {};

    name.split(ELEM_DELIM).forEach(function(item, i) {
        var keys = [ i ? 'elem' : 'block', 'mod', 'val' ];

        item.split(MOD_DELIM).forEach(function(part, j) {
            bemitem[keys[j]] = part;
        });
    });

    return bemitem;

}

function _pushStack(name) {
    if(!name) return false;

    var len = stack.length;
    return !(len && stack[len - 1] === name) && stack.push(name);
}

function _popStack(name) {
    var len = stack.length;
    return len && stack[len - 1] !== name && stack.pop();
}

/**
 * @constructor
 */
function _i18n() {
    this._lang = '';
    this._prj = 'lego'; // FIXME: bem-bl?
    this._keyset = '';
    this._key = '';
}

_i18n.prototype = {

    lang : function(name) {
        this._lang = name;
        return this;
    },

    project : function(name) {
        this._prj = name;
        return this;
    },

    keyset : function(name) {
        _pushStack(this._keyset);

        this._keyset = bemName(name);
        return this;
    },

    key : function(name) {
        this._key = name;
        return this;
    },

    /**
     * FIXME: Move legacy-syntax support into separat method
     * @param {Object|Function} v
     */
    decl : function(v) {
        var bemitem = bemParse(this._keyset),
            // tanker legacy syntax
            prj = bemitem.block === 'i-tanker' ? 'tanker' : this._prj,
            keyset = bemitem.elem || this._keyset,
            key = this._key;

        prj = i18n[prj] || (i18n[prj] = {});
        keyset = prj[keyset] || (prj[keyset] = {});
        keyset[key] = typeof v === 'function' ? v : (function(p) { return (v); });

        // `BEM.I18N` syntax
        var l = cache[this._lang] || (cache[this._lang] = {}),
            k = l[this._keyset] || (l[this._keyset] = {});

        k[key] = v;
    },

    val : function(params, thisCtx) {
        var value = cache[this._lang] && cache[this._lang][this._keyset];
        if(!value) {
            console && console.log &&
                console.log("[Error] keyset: " + this._keyset + " key: " + this._key + " (lang: " + this._lang + ")");
            return '';
        }

        value = value[this._key];
        if(!value) return '';

        try{
            return typeof value === 'string' ?
                value : thisCtx ? value.call(thisCtx, params) : value.call(this, params);
        } catch(e) {
            throw "[Error] keyset: " + this._keyset + " key: " + this._key + " (lang: " + this._lang + ")";
        }
    },

    _c : function() { return cache; }

};

/**
 * @namespace
 * @lends BEM.I18N
 */
bem_.I18N = (function(base) {

    /**
     * Shortcut to get key value
     *
     * @param {String|Object} keyset
     * @param {String} key
     * @param {Object} [params]
     * @return {String}
     */
    var klass = function(keyset, key, params) {
        return klass.keyset(keyset).key(key, params);
    };

    ['project', 'keyset'].forEach(function(p) {
        klass[p] = function(v) { this._i18n[p](v); return this; };
    });

    /**
     * @param {String} name Key name
     * @param {Object} params
     * @return {String}
     */
    klass.key = function(name, params) {
        var proto = this._i18n,
            _keyset, result;

        proto.lang(this._currentLang).key(name);

        result = proto.val.call(proto, params, klass);

        // восстанавливаем значение предыдущего кейсета, если нужно
        _keyset = _popStack(proto._keyset);
        _keyset && proto.keyset(_keyset);

        return result;
    };

    /**
     * Declaration of translations
     *
     * @param {String|Object} bemitem
     * @param {Object} keysets
     * @param {Object} [declProps] declaration params
     */
    klass.decl = function(bemitem, keysets, declProps) {
        var proto = this._i18n, k;

        declProps || (declProps = {});
        declProps.lang && proto.lang(declProps.lang);

        proto.keyset(bemitem);

        for(k in keysets)
            proto.key(k).decl(keysets[k]);

        return this;
    };

    /**
     * Get/set current language
     *
     * @param {String} [lang]
     * @return {String}
     */
    klass.lang = function(lang) {
        typeof lang !== undefined
            && (this._currentLang = lang);

        return this._currentLang;
    };

    klass._i18n = base;

    klass._currentLang = DEFAULT_LANG;

    return klass;

}(new _i18n()));

/** Global */
BEM = this.BEM = bem_;

})(typeof BEM === 'undefined' ? {} : BEM);

BEM.I18N.decl('i-tanker__months', {"g1": 'Января',"g10": 'Октября',"g11": 'Ноября',"g12": 'Декабря',"g2": 'Февраля',"g3": 'Марта',"g4": 'Апреля',"g5": 'Мая',"g6": 'Июня',"g7": 'Июля',"g8": 'Августа',"g9": 'Сентября',"n1": 'Январь',"n10": 'Октябрь',"n11": 'Ноябрь',"n12": 'Декабрь',"n2": 'Февраль',"n3": 'Март',"n4": 'Апрель',"n5": 'Май',"n6": 'Июнь',"n7": 'Июль',"n8": 'Август',"n9": 'Сентябрь',"name": function(params) { return (function(params) { 
 var month = i18n['tanker']['months'][(params['case'] || 'n') + params.month]();
 return Boolean(params.lowercase) ? month.toLowerCase() : month;
  }).call(this, params); },"short1": 'янв',"short10": 'окт',"short11": 'ноя',"short12": 'дек',"short2": 'фев',"short3": 'мрт',"short4": 'апр',"short5": 'май',"short6": 'июн',"short7": 'июл',"short8": 'авг',"short9": 'сен'}, {
"lang": "ru"
});

BEM.I18N.lang('ru');

}
