if (window.yandexTranslateService)
	delete window.yandexTranslateService;

window.yandexTranslateService = {
	constructor: function() {

		this.debug = false;
		this.log("constructor: " + _pagetranslator_original + "-" + _pagetranslator_target);

		this.data = {
			direction: {
				original: "en",
				target: "ru"
			}
		};

		if (typeof(_pagetranslator_original) !== 'undefined')
			this.data.direction.original = _pagetranslator_original;

		if (typeof(_pagetranslator_target) !== 'undefined')
			this.data.direction.target = _pagetranslator_target;

		if (typeof(yandexTranslateServiceListener) !== 'undefined')
			this.listener = yandexTranslateServiceListener;

		this.injected = false;
		this.translate();
	},
	
	log: function(message) {
		if (this.debug)
			console.log("Yandex Translate Service: " + message);
	},

	translate: function() {
		this.log("translate()");
		this.loadScripts();
	},
	
	attemptLoadScripts: function() {
		if (!this.injected && document && document.documentElement && document.head && document.body) {
			this.loadScripts();
			return true;
		}
		return false;
	},
	
	loadScripts: function() {
		this.log("loadScripts()");

		if (this.injected)
			return;
		this.injected = true;
		
		var version = '1.40';
		var prefix = "http://translate.yandex.net/v" + version + "/js/";
		var urls = [prefix + "lib.js", prefix + "tr-url.js"];

		for (var i = 0; i < urls.length; i++)
			this.createScript(urls[i]);

		var context = this;
		setTimeout(function () { context.onScriptLoadTimeout(); }, 10000);
	},

	createScript: function (url) {
		var context = this;
		var script = document.createElement("script");

		script.setAttribute("type", "text/javascript");
		script.setAttribute("src", url);
		script.attachEvent("onreadystatechange", function() {
			context.onScriptLoad();
		});

		document.getElementsByTagName('head')[0].appendChild(script);
	},

	onScriptLoadTimeout: function () {
		this.log("onScriptLoadTimeout");
		if (!this.available())
			this.reportError();
	},

	reportError: function () {
		this.log("reportError");
		if (this.listener)
			this.listener.onError();
	},

	onScriptLoad: function() {
		this.log("onScriptLoad()");
		//this.wait();
		if (this.available() && !this.translator) {
			this.translateStart();
		}
	},
	
	//wait: function() {
		////this.log("wait()");
		//return;
		//if (this.available())
			//this.translateStart();
		//else {
			//var context = this;
			//setTimeout(function() { context.wait(); }, 500);
		//}
	//},
	
	available: function() {
		var available = !!window.Doc && !!window.TrUrl && !!window.LangCtrl;
		this.log("available: " + available);
		return available;
	},
	
	generateUID: function() {
		this.log("generateUID()");
		var uid = "";
		for (var i = 0; i < 8; i ++)
			uid += Math.floor((Math.random() * 16)).toString(16);
		return uid;
	},
	
	translateStart: function() {
		this.log("translateStart()");
		var data = this.data;
		var lang = data.direction.original + "-" + data.direction.target;
		
		var uid = this.generateUID();
		
		if (!this.translator) {
			this.translator = new Doc(uid, window.location.href);
			this.translator.setListener(this);
			this.translator.trUrl = "http://translate.yandex.net/tr.json"; // Oops.
		} else {
			this.translator.undo();
		}
		this.translator.translate(lang);
	},

	translatePage: function(original, target) {
		this.log("translatePage()");
		this.data = {
			direction: {
				original: original,
				target: target
			}
		};
		
		this.translateStart();
	},
	
	//restore: function() {
		//this.log("restore()");
		//if (this.translator)
			//this.translator.undo();
	//},
	
	onProgressChanged: function(progress) {
		this.log("onProgressChanged: " + progress);
	},
	
	onStateChanged: function(doc) {
		this.state = doc.getState();
		this.log("onStateChanged: this.state" + this.state);
		if (this.state == Doc.STATE_TR_END) {
			if (this.listener)
				this.listener.onStateChanged("complete");
		}
	},

	onError: function(err) {
		this.log("onError:  " + err.message);
		this.reportError();
	}
};

window.yandexTranslateService.constructor();

