/* pages-desktop/traffic/traffic.ru.js: begin */ /**/
    /* lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: begin */ /**/
        /**
         * Inheritance plugin
         *
         * Copyright (c) 2010 Filatov Dmitry (dfilatov@yandex-team.ru)
         * Dual licensed under the MIT and GPL licenses:
         * http://www.opensource.org/licenses/mit-license.php
         * http://www.gnu.org/licenses/gpl.html
         *
         * @version 1.3.3
         */
        
        (function($) {
        
        var hasIntrospection = (function(){_}).toString().indexOf('_') > -1,
            needCheckProps = $.browser.msie, // fucking ie hasn't toString, valueOf in for
            specProps = needCheckProps? ['toString', 'valueOf'] : null,
            emptyBase = function() {};
        
        function override(base, result, add) {
        
            var hasSpecProps = false;
            if(needCheckProps) {
                var addList = [];
                $.each(specProps, function() {
                    add.hasOwnProperty(this) && (hasSpecProps = true) && addList.push({
                        name : this,
                        val  : add[this]
                    });
                });
                if(hasSpecProps) {
                    $.each(add, function(name) {
                        addList.push({
                            name : name,
                            val  : this
                        });
                    });
                    add = addList;
                }
            }
        
            $.each(add, function(name, prop) {
                if(hasSpecProps) {
                    name = prop.name;
                    prop = prop.val;
                }
                if($.isFunction(prop) &&
                   (!hasIntrospection || prop.toString().indexOf('.__base') > -1)) {
        
                    var baseMethod = base[name] || function() {};
                    result[name] = function() {
                        var baseSaved = this.__base;
                        this.__base = baseMethod;
                        var result = prop.apply(this, arguments);
                        this.__base = baseSaved;
                        return result;
                    };
        
                }
                else {
                    result[name] = prop;
                }
        
            });
        
        }
        
        $.inherit = function() {
        
            var args = arguments,
                hasBase = $.isFunction(args[0]),
                base = hasBase? args[0] : emptyBase,
                props = args[hasBase? 1 : 0] || {},
                staticProps = args[hasBase? 2 : 1],
                result = props.__constructor || (hasBase && base.prototype.__constructor)?
                    function() {
                        return this.__constructor.apply(this, arguments);
                    } : function() {};
        
            if(!hasBase) {
                result.prototype = props;
                result.prototype.__self = result.prototype.constructor = result;
                return $.extend(result, staticProps);
            }
        
            $.extend(result, base);
        
            var inheritance = function() {},
                basePtp = inheritance.prototype = base.prototype,
                resultPtp = result.prototype = new inheritance();
        
            resultPtp.__self = resultPtp.constructor = result;
        
            override(basePtp, resultPtp, props);
            staticProps && override(base, result, staticProps);
        
            return result;
        
        };
        
        $.inheritSelf = function(base, props, staticProps) {
        
            var basePtp = base.prototype;
        
            override(basePtp, basePtp, props);
            staticProps && override(base, base, staticProps);
        
            return base;
        
        };
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: begin */ /**/
        /**
         * Identify plugin
         *
         * @version 1.0.0
         */
        
        (function($) {
        
        var counter = 0,
            expando = '__' + (+new Date),
            get = function() {
                return 'uniq' + ++counter;
            };
        
        /**
         * Уникализатор
         * @param {Object} [obj] объект, который нужно идентифицировать
         * @param {Boolean} [onlyGet=false] возвращать уникальное значение, только если оно уже до этого было присвоено
         * @returns {String} идентификатор
         */
        $.identify = function(obj, onlyGet) {
        
            if(!obj) return get();
        
            var key = 'uniqueID' in obj? 'uniqueID' : expando; // используем, по возможности. нативный uniqueID для элементов в IE
        
            return onlyGet || key in obj?
                obj[key] :
                obj[key] = get();
        
        };
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: begin */ /**/
        (function($) {
        
        $.isEmptyObject || ($.isEmptyObject = function(obj) {
                for(var i in obj) return false;
                return true;
            });
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: begin */ /**/
        /**
         * Debounce and throttle function's decorator plugin 1.0.6
         *
         * Copyright (c) 2009 Filatov Dmitry (alpha@zforms.ru)
         * Dual licensed under the MIT and GPL licenses:
         * http://www.opensource.org/licenses/mit-license.php
         * http://www.gnu.org/licenses/gpl.html
         *
         */
        
        (function($) {
        
        $.extend({
        
            debounce : function(fn, timeout, invokeAsap, ctx) {
        
                if(arguments.length == 3 && typeof invokeAsap != 'boolean') {
                    ctx = invokeAsap;
                    invokeAsap = false;
                }
        
                var timer;
        
                return function() {
        
                    var args = arguments;
                    ctx = ctx || this;
        
                    invokeAsap && !timer && fn.apply(ctx, args);
        
                    clearTimeout(timer);
        
                    timer = setTimeout(function() {
                        invokeAsap || fn.apply(ctx, args);
                        timer = null;
                    }, timeout);
        
                };
        
            },
        
            throttle : function(fn, timeout, ctx) {
        
                var timer, args, needInvoke;
        
                return function() {
        
                    args = arguments;
                    needInvoke = true;
                    ctx = ctx || this;
        
                    timer || (function() {
                        if(needInvoke) {
                            fn.apply(ctx, args);
                            needInvoke = false;
                            timer = setTimeout(arguments.callee, timeout);
                        }
                        else {
                            timer = null;
                        }
                    })();
        
                };
        
            }
        
        });
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: begin */ /**/
        /**
         * Observable plugin
         *
         * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
         * Dual licensed under the MIT and GPL licenses:
         * http://www.opensource.org/licenses/mit-license.php
         * http://www.gnu.org/licenses/gpl.html
         *
         * @version 1.0.0
         * @requires $.identify
         * @requires $.inherit
         */
        
        (function($) {
        
        var storageExpando = '__' + +new Date + 'storage',
            getFnId = function(fn, ctx) {
                return $.identify(fn) + (ctx? $.identify(ctx) : '');
            },
            Observable = /** @lends $.observable.prototype */{
        
                /**
                 * Строит полное имя события
                 * @protected
                 * @param {String} e тип события
                 * @returns {String}
                 */
                buildEventName : function(e) {
        
                    return e;
        
                },
        
                /**
                 * Добавление обработчика события
                 * @param {String} e тип события
                 * @param {Object} [data] дополнительные данные, приходящие в обработчик как e.data
                 * @param {Function} fn обработчик
                 * @param {Object} [ctx] контекст обработчика
                 * @returns {$.observable}
                 */
                on : function(e, data, fn, ctx, _special) {
        
                    if(typeof e == 'string') {
                        if($.isFunction(data)) {
                            ctx = fn;
                            fn = data;
                            data = undefined;
                        }
        
                        var id = getFnId(fn, ctx),
                            storage = this[storageExpando] || (this[storageExpando] = {}),
                            eList = e.split(' '),
                            i = 0,
                            eStorage;
        
                        while(e = eList[i++]) {
                            e = this.buildEventName(e);
                            eStorage = storage[e] || (storage[e] = { ids : {}, list : {} });
        
                            if(!(id in eStorage.ids)) {
                                var list = eStorage.list,
                                    item = { fn : fn, data : data, ctx : ctx, special : _special };
                                if(list.last) {
                                    list.last.next = item;
                                    item.prev = list.last;
                                } else {
                                    list.first = item;
                                }
        
                                eStorage.ids[id] = list.last = item;
                            }
                        }
                    } else {
                        var _this = this;
                        $.each(e, function(e, fn) {
                            _this.on(e, fn, data, _special);
                        });
                    }
        
                    return this;
        
                },
        
                onFirst : function(e, data, fn, ctx) {
        
                    return this.on(e, data, fn, ctx, { one : true });
        
                },
        
                /**
                 * Удаление обработчика/обработчиков события
                 * @param {String} [e] тип события
                 * @param {Function} [fn] обработчик
                 * @param {Object} [ctx] контекст обработчика
                 * @returns {$.observable}
                 */
                un : function(e, fn, ctx) {
        
                    if(typeof e == 'string' || typeof e == 'undefined') {
                        var storage = this[storageExpando];
                        if(storage) {
                            if(e) { // если передан тип события
                                var eList = e.split(' '),
                                    i = 0,
                                    eStorage;
                                while(e = eList[i++]) {
                                    e = this.buildEventName(e);
                                    if(eStorage = storage[e]) {
                                        if(fn) {  // если передан конкретный обработчик
                                            var id = getFnId(fn, ctx),
                                                ids = eStorage.ids;
                                            if(id in ids) {
                                                var list = eStorage.list,
                                                    item = ids[id],
                                                    prev = item.prev,
                                                    next = item.next;
        
                                                if(prev) {
                                                    prev.next = next;
                                                }
                                                else if(item === list.first) {
                                                    list.first = next;
                                                }
        
                                                if(next) {
                                                    next.prev = prev;
                                                }
                                                else if(item === list.last) {
                                                    list.last = prev;
                                                }
        
                                                delete ids[id];
                                            }
                                        } else {
                                            delete this[storageExpando][e];
                                        }
                                    }
                                }
                            } else {
                                delete this[storageExpando];
                            }
                        }
                    } else {
                        var _this = this;
                        $.each(e, function(e, fn) {
                            _this.un(e, fn, ctx);
                        });
                    }
        
                    return this;
        
                },
        
                /**
                 * Запускает обработчики события
                 * @param {String|$.Event} e событие
                 * @param {Object} [data] дополнительные данные
                 * @returns {$.observable}
                 */
                trigger : function(e, data) {
        
                    var _this = this,
                        storage = _this[storageExpando],
                        rawType;
        
                    typeof e === 'string'?
                        e = $.Event(_this.buildEventName(rawType = e)) :
                        e.type = _this.buildEventName(rawType = e.type);
        
                    e.target || (e.target = _this);
        
                    if(storage && (storage = storage[e.type])) {
                        var item = storage.list.first,
                            ret;
                        while(item) {
                            e.data = item.data;
                            ret = item.fn.call(item.ctx || _this, e, data);
                            if(typeof ret !== 'undefined') {
                                e.result = ret;
                                if(ret === false) {
                                    e.preventDefault();
                                    e.stopPropagation();
                                }
                            }
        
                            item.special && item.special.one &&
                                _this.un(rawType, item.fn, item.ctx);
                            item = item.next;
                        }
                    }
        
                    return this;
        
                }
        
            };
        
        $.observable = $.inherit(Observable, Observable);
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-bem/i-bem.js: begin */ /**/
        /** @requires jquery.inherit */
        /** @requires jquery.isEmptyObject */
        /** @requires jquery.identify */
        /** @requires jquery.observable */
        
        (function($, undefined) {
        
        /**
         * Хранилище для отложенных функций
         * @private
         * @type Array
         */
        var afterCurrentEventFns = [],
        
        /**
         * Хранилище деклараций блоков (хэш по имени блока)
         * @private
         * @type Object
         */
            blocks = {},
        
        /**
         * Каналы сообщений
         * @static
         * @private
         * @type Object
         */
            channels = {};
        
        /**
         * Строит имя метода-обработчика установки модификатора
         * @static
         * @private
         * @param {String} elemName имя элемента
         * @param {String} modName имя модификатора
         * @param {String} modVal значение модификатора
         * @returns {String}
         */
        function buildModFnName(elemName, modName, modVal) {
        
            return (elemName? '__elem_' + elemName : '') +
                   '__mod' +
                   (modName? '_' + modName : '') +
                   (modVal? '_' + modVal : '');
        
        }
        
        /**
         * Преобразует хэш обработчиков модификаторов в методы
         * @static
         * @private
         * @param {Object} modFns
         * @param {Object} props
         * @param {String} [elemName]
         */
        function modFnsToProps(modFns, props, elemName) {
        
            $.isFunction(modFns)?
                (props[buildModFnName(elemName, '*', '*')] = modFns) :
                $.each(modFns, function(modName, modFn) {
                    $.isFunction(modFn)?
                        (props[buildModFnName(elemName, modName, '*')] = modFn) :
                        $.each(modFn, function(modVal, modFn) {
                            props[buildModFnName(elemName, modName, modVal)] = modFn;
                        });
                });
        
        }
        
        function buildCheckMod(modName, modVal) {
        
            return modVal?
                Array.isArray(modVal)?
                    function(block) {
                        var i = 0, len = modVal.length;
                        while(i < len)
                            if(block.hasMod(modName, modVal[i++]))
                                return true;
                        return false;
                    } :
                    function(block) {
                        return block.hasMod(modName, modVal);
                    } :
                function(block) {
                    return block.hasMod(modName);
                };
        
        }
        
        /** @namespace */
        this.BEM = $.inherit($.observable, /** @lends BEM.prototype */ {
        
            /**
             * @class Базовый блок для создания bem-блоков
             * @constructs
             * @private
             * @param {Object} mods модификаторы блока
             * @param {Object} params параметры блока
             * @param {Boolean} [initImmediately=true]
             */
            __constructor : function(mods, params, initImmediately) {
        
                var _this = this;
        
                /**
                 * кэш модификаторов блока
                 * @private
                 * @type Object
                 */
                _this._modCache = mods || {};
        
                /**
                 * текущие модификаторы в стэке установки
                 * @private
                 * @type Object
                 */
                _this._processingMods = {};
        
                /**
                 * параметры блока с учетом дефолтных
                 * @protected
                 * @type Object
                 */
                _this._params = params; // это нужно для правильной сборки параметров у блока из нескольких нод
                _this.params = null;
        
                initImmediately !== false?
                    _this._init() :
                    _this.afterCurrentEvent(function() {
                        _this._init();
                    });
        
            },
        
            /**
             * Инициализирует блок
             * @private
             */
            _init : function() {
        
                if(!this._initing && !this.hasMod('js', 'inited')) {
                    this._initing = true;
        
                    this.params = $.extend(this.getDefaultParams(), this._params);
                    delete this._params;
        
                    this.setMod('js', 'inited');
                    delete this._initing;
                    this.trigger('init');
                }
        
                return this;
        
            },
        
            /**
             * Изменяет контекст передаваемой функции
             * @protected
             * @param {Function} fn
             * @param {Object} [ctx=this] контекст
             * @returns {Function} функция с измененным контекстом
             */
            changeThis : function(fn, ctx) {
        
                return fn.bind(ctx || this);
        
            },
        
            /**
             * Выполняет функцию в контексте блока после "текущего события"
             * @protected
             * @param {Function} fn
             * @param {Object} [ctx] контекст
             */
            afterCurrentEvent : function(fn, ctx) {
        
                this.__self.afterCurrentEvent(this.changeThis(fn, ctx));
        
            },
        
            /**
             * Запускает обработчики события у блока и обработчики live-событий
             * @protected
             * @param {String} e имя события
             * @param {Object} [data] дополнительные данные
             * @returns {BEM}
             */
            trigger : function(e, data) {
        
                this
                    .__base(e = this.buildEvent(e), data)
                    .__self.trigger(e, data);
        
                return this;
        
            },
        
            buildEvent : function(e) {
        
                typeof e == 'string' && (e = $.Event(e));
                e.block = this;
        
                return e;
        
            },
        
            /**
             * Проверят наличие модификатора у блока/вложенного элемента
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {Boolean}
             */
            hasMod : function(elem, modName, modVal) {
        
                var len = arguments.length,
                    invert = false;
        
                if(len == 1) {
                    modVal = '';
                    modName = elem;
                    elem = undefined;
                    invert = true;
                }
                else if(len == 2) {
                    if(typeof elem == 'string') {
                        modVal = modName;
                        modName = elem;
                        elem = undefined;
                    }
                    else {
                        modVal = '';
                        invert = true;
                    }
                }
        
                var res = this.getMod(elem, modName) === modVal;
                return invert? !res : res;
        
            },
        
            /**
             * Возвращает значение модификатора блока/вложенного элемента
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @returns {String} значение модификатора
             */
            getMod : function(elem, modName) {
        
                var type = typeof elem;
                if(type === 'string' || type === 'undefined') { // elem либо отсутствует, либо undefined
                    modName = elem || modName;
                    var modCache = this._modCache;
                    return modName in modCache?
                        modCache[modName] :
                        modCache[modName] = this._extractModVal(modName);
                }
        
                return this._getElemMod(modName, elem);
        
            },
        
            /**
             * Возвращает значение модификатора вложенного элемента
             * @private
             * @param {String} modName имя модификатора
             * @param {Object} elem вложенный элемент
             * @param {Object} [elem] имя вложенного элемента
             * @returns {String} значение модификатора
             */
            _getElemMod : function(modName, elem, elemName) {
        
                return this._extractModVal(modName, elem, elemName);
        
            },
        
            /**
             * Возвращает значения модификаторов блока/вложенного элемента
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} [modName1, ..., modNameN] имена модификаторов
             * @returns {Object} значения модификаторов в виде хэша
             */
            getMods : function(elem) {
        
                var hasElem = elem && typeof elem != 'string',
                    _this = this,
                    modNames = [].slice.call(arguments, hasElem? 1 : 0),
                    res = _this._extractMods(modNames, hasElem? elem : undefined);
        
                if(!hasElem) { // кэшируем
                    modNames.length?
                        modNames.forEach(function(name) {
                            _this._modCache[name] = res[name];
                        }):
                        _this._modCache = res;
                }
        
                return res;
        
            },
        
            /**
             * Устанавливает модификатор у блока/вложенного элемента
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @param {String} modVal значение модификатора
             * @returns {BEM}
             */
            setMod : function(elem, modName, modVal) {
        
                if(typeof modVal == 'undefined') {
                    modVal = modName;
                    modName = elem;
                    elem = undefined;
                }
        
                var _this = this;
        
                if(!elem || elem[0]) {
        
                    var modId = (elem && elem[0]? $.identify(elem[0]) : '') + '_' + modName;
        
                    if(this._processingMods[modId]) return _this;
        
                    var elemName,
                        curModVal = elem?
                            _this._getElemMod(modName, elem, elemName = _this.__self._extractElemNameFrom(elem)) :
                            _this.getMod(modName);
        
                    if(curModVal === modVal) return _this;
        
                    this._processingMods[modId] = true;
        
                    var needSetMod = true,
                        modFnParams = [modName, modVal, curModVal];
        
                    elem && modFnParams.unshift(elem);
        
                    [['*', '*'], [modName, '*'], [modName, modVal]].forEach(function(mod) {
                        needSetMod = _this._callModFn(elemName, mod[0], mod[1], modFnParams) !== false && needSetMod;
                    });
        
                    !elem && needSetMod && (_this._modCache[modName] = modVal);
        
                    needSetMod && _this._afterSetMod(modName, modVal, curModVal, elem, elemName);
        
                    delete this._processingMods[modId];
                }
        
                return _this;
        
            },
        
            /**
             * Функция после успешного изменения модификатора у блока/вложенного элемента
             * @protected
             * @param {String} modName имя модификатора
             * @param {String} modVal значение модификатора
             * @param {String} oldModVal старое значение модификатора
             * @param {Object} [elem] вложенный элемент
             * @param {String} [elemName] имя элемента
             */
            _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {},
        
            /**
             * Устанавливает модификатор у блока/вложенного элемента в зависимости от условия.
             * Если передан параметр condition, то при true устанавливается modVal1, при false - modVal2,
             * если же condition не передан, то устанавливается modVal1, если установлен modVal2, и наоборот
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @param {String} modVal1 первое значение модификатора
             * @param {String} [modVal2] второе значение модификатора
             * @param {Boolean} [condition] условие
             * @returns {BEM}
             */
            toggleMod : function(elem, modName, modVal1, modVal2, condition) {
        
                if(typeof elem == 'string') { // если это блок
                    condition = modVal2;
                    modVal2 = modVal1;
                    modVal1 = modName;
                    modName = elem;
                    elem = undefined;
                }
                if(typeof modVal2 == 'undefined') {
                    modVal2 = '';
                } else if(typeof modVal2 == 'boolean') {
                    condition = modVal2;
                    modVal2 = '';
                }
        
                var modVal = this.getMod(elem, modName);
                (modVal == modVal1 || modVal == modVal2) &&
                    this.setMod(
                        elem,
                        modName,
                        typeof condition === 'boolean'?
                            (condition? modVal1 : modVal2) :
                            this.hasMod(elem, modName, modVal1)? modVal2 : modVal1);
        
                return this;
        
            },
        
            /**
             * Удаляет модификатор у блока/вложенного элемента
             * @protected
             * @param {Object} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @returns {BEM}
             */
            delMod : function(elem, modName) {
        
                if(!modName) {
                    modName = elem;
                    elem = undefined;
                }
        
                return this.setMod(elem, modName, '');
        
            },
        
            /**
             * Выполняет обработчики установки модификаторов
             * @private
             * @param {String} elemName имя элемента
             * @param {String} modName имя модификатора
             * @param {String} modVal значение модификатора
             * @param {Array} modFnParams параметры обработчика
             */
            _callModFn : function(elemName, modName, modVal, modFnParams) {
        
                var modFnName = buildModFnName(elemName, modName, modVal);
                return this[modFnName]?
                   this[modFnName].apply(this, modFnParams) :
                   undefined;
        
            },
        
            /**
             * Извлекает значение модификатора
             * @private
             * @param {String} modName имя модификатора
             * @param {Object} [elem] элемент
             * @returns {String} значение модификатора
             */
            _extractModVal : function(modName, elem) {
        
                return '';
        
            },
        
            /**
             * Извлекает имя/значение списка модификаторов
             * @private
             * @param {Array} modNames имена модификаторов
             * @param {Object} [elem] элемент
             * @returns {Object} хэш значений модификаторов по имени
             */
            _extractMods : function(modNames, elem) {
        
                return {};
        
            },
        
            /**
             * Возвращает именованный канал сообщений
             * @param {String} [id='default'] идентификатор канала
             * @param {Boolean} [drop=false] уничтожить канал
             * @returns {$.observable|undefined} канал сообщений
             */
            channel : function(id, drop) {
        
                return this.__self.channel(id, drop);
        
            },
        
            /**
             * Возвращает дефолтные параметры блока
             * @returns {Object}
             */
            getDefaultParams : function() {
        
                return {};
        
            },
        
            /**
             * Хелпер для очистки свойств блока
             * @param {Object} [obj=this]
             */
            del : function(obj) {
        
                var args = [].slice.call(arguments);
                typeof obj == 'string' && args.unshift(this);
                this.__self.del.apply(this.__self, args);
                return this;
        
        	},
        
            /**
             * Удаляет блок
             */
            destruct : function() {}
        
        }, /** @lends BEM */{
        
            _name : 'i-bem',
        
            /**
             * Хранилище деклараций блоков (хэш по имени блока)
             * @static
             * @protected
             * @type Object
             */
            blocks : blocks,
        
            /**
             * Декларатор блоков, создает класс блока
             * @static
             * @protected
             * @param {String|Object} decl имя блока (простой синтаксис) или описание
             * @param {String} decl.block|decl.name имя блока
             * @param {String} [decl.baseBlock] имя родительского блока
             * @param {String} [decl.modName] имя модификатора
             * @param {String} [decl.modVal] значение модификатора
             * @param {Object} [props] методы
             * @param {Object} [staticProps] статические методы
             */
            decl : function(decl, props, staticProps) {
        
                if(typeof decl == 'string')
                    decl = { block : decl };
                else if(decl.name) {
                    decl.block = decl.name;
                }
        
                if(decl.baseBlock && !blocks[decl.baseBlock])
                    throw('baseBlock "' + decl.baseBlock + '" for "' + decl.block + '" is undefined');
        
                props || (props = {});
        
                if(props.onSetMod) {
                    modFnsToProps(props.onSetMod, props);
                    delete props.onSetMod;
                }
        
                if(props.onElemSetMod) {
                    $.each(props.onElemSetMod, function(elemName, modFns) {
                        modFnsToProps(modFns, props, elemName);
                    });
                    delete props.onElemSetMod;
                }
        
                var baseBlock = blocks[decl.baseBlock || decl.block] || this;
        
                if(decl.modName) {
                    var checkMod = buildCheckMod(decl.modName, decl.modVal);
                    $.each(props, function(name, prop) {
                        $.isFunction(prop) &&
                            (props[name] = function() {
                                var method;
                                if(checkMod(this)) {
                                    method = prop;
                                } else {
                                    var baseMethod = baseBlock.prototype[name];
                                    baseMethod && baseMethod !== props[name] &&
                                        (method = this.__base);
                                }
                                return method?
                                    method.apply(this, arguments) :
                                    undefined;
                            });
                    });
                }
        
                var block;
                decl.block == baseBlock._name?
                    // делаем новый live в том случае, если уже запускался старый
                    (block = $.inheritSelf(baseBlock, props, staticProps))._processLive(true) :
                    (block = blocks[decl.block] = $.inherit(baseBlock, props, staticProps))._name = decl.block;
        
                return block;
        
            },
        
            /**
             * Осуществляет обработку live-свойств блока
             * @private
             * @param {Boolean} [heedLive=false] нужно ли учитывать то, что блок обрабатывал уже свои live-свойства
             * @returns {Boolean} является ли блок live-блоком
             */
            _processLive : function(heedLive) {
        
                return false;
        
            },
        
            /**
             * Фабричный метод для создания экземпляра блока по имени
             * @static
             * @param {String|Object} block имя блока или описание
             * @param {Object} [params] параметры блока
             * @returns {BEM}
             */
            create : function(block, params) {
        
                typeof block == 'string' && (block = { block : block });
        
                return new blocks[block.block](block.mods, params);
        
            },
        
            /**
             * Возвращает имя текущего блока
             * @static
             * @protected
             * @returns {String}
             */
            getName : function() {
        
                return this._name;
        
            },
        
            /**
             * Извлекает имя вложенного в блок элемента
             * @static
             * @private
             * @param {Object} elem вложенный элемент
             * @returns {String|undefined}
             */
            _extractElemNameFrom : function(elem) {},
        
            /**
             * Добавляет функцию в очередь для запуска после "текущего события"
             * @static
             * @protected
             * @param {Function} fn
             * @param {Object} ctx
             */
            afterCurrentEvent : function(fn, ctx) {
        
                afterCurrentEventFns.push({ fn : fn, ctx : ctx }) == 1 &&
                    setTimeout(this._runAfterCurrentEventFns, 0);
        
            },
        
            /**
             * Запускает очерель
             * @private
             */
            _runAfterCurrentEventFns : function() {
        
                var fnsLen = afterCurrentEventFns.length;
                if(fnsLen) {
                    var fnObj,
                        fnsCopy = afterCurrentEventFns.splice(0, fnsLen);
        
                    while(fnObj = fnsCopy.shift()) fnObj.fn.call(fnObj.ctx || this);
                }
        
            },
        
            /**
             * Изменяет контекст передаваемой функции
             * @protected
             * @param {Function} fn
             * @param {Object} ctx контекст
             * @returns {Function} функция с измененным контекстом
             */
            changeThis : function(fn, ctx) {
        
                return fn.bind(ctx || this);
        
            },
        
            /**
             * Хелпер для очистки свойств
             * @param {Object} [obj=this]
             */
            del : function(obj) {
        
                var delInThis = typeof obj == 'string',
                    i = delInThis? 0 : 1,
                    len = arguments.length;
                delInThis && (obj = this);
        
                while(i < len) delete obj[arguments[i++]];
        
                return this;
        
        	},
        
            /**
             * Возвращает/уничтожает именованный канал сообщений
             * @param {String} [id='default'] идентификатор канала
             * @param {Boolean} [drop=false] уничтожить канал
             * @returns {$.observable|undefined} канал сообщений
             */
            channel : function(id, drop) {
        
                if(typeof id == 'boolean') {
                    drop = id;
                    id = undefined;
                }
        
                id || (id = 'default');
        
                if(drop) {
                    if(channels[id]) {
                        channels[id].un();
                        delete channels[id];
                    }
                    return;
                }
        
                return channels[id] || (channels[id] = new $.observable());
        
            }
        
        });
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-bem/i-bem.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: begin */ /**/
        (function() {
        
        /**
         * Возвращает массив свойств объекта
         * @param {Object} obj объект
         * @returns {Array}
         */
        Object.keys || (Object.keys = function(obj) {
            var res = [];
        
            for(var i in obj) obj.hasOwnProperty(i) &&
                res.push(i);
        
            return res;
        });
        
        })();
    /* lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: begin */ /**/
        (function() {
        
        var ptp = Array.prototype,
            toStr = Object.prototype.toString,
            methods = {
        
                /**
                 * Находит индекс элемента в массиве
                 * @param {Object} item
                 * @param {Number} [fromIdx] начиная с индекса (length - 1 - fromIdx, если fromIdx < 0)
                 * @returns {Number} индекс элемента или -1, если не найдено
                 */
                indexOf : function(item, fromIdx) {
        
                    fromIdx = +(fromIdx || 0);
        
                    var t = this, len = t.length;
        
                    if(len > 0 && fromIdx < len) {
                        fromIdx = fromIdx < 0? Math.ceil(fromIdx) : Math.floor(fromIdx);
                        fromIdx < -len && (fromIdx = 0);
                        fromIdx < 0 && (fromIdx = fromIdx + len);
        
                        while(fromIdx < len) {
                            if(fromIdx in t && t[fromIdx] === item)
                                return fromIdx;
                            ++fromIdx;
                        }
                    }
        
                    return -1;
        
                },
        
                /**
                 * Вызывает callback для каждого элемента
                 * @param {Function} callback вызывается для каждого элемента
                 * @param {Object} [ctx=null] контекст для callback
                 */
                forEach : function(callback, ctx) {
        
                    var i = -1, t = this, len = t.length;
                    while(++i < len) i in t &&
                        (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));
        
                },
        
                /**
                 * Создает массив B из массива A, такой что B[i] = callback(A[i])
                 * @param {Function} callback вызывается для каждого элемента
                 * @param {Object} [ctx=null] контекст для callback
                 * @returns {Array}
                 */
                map : function(callback, ctx) {
        
                    var i = -1, t = this, len = t.length,
                        res = new Array(len);
        
                    while(++i < len) i in t &&
                        (res[i] = ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));
        
                    return res;
        
                },
        
                /**
                 * Создает массив, содержащий только те элементы из исходного массива, для которых callback возвращает true.
                 * @param {Function} callback вызывается для каждого элемента
                 * @param {Object} [ctx] контекст для callback
                 * @returns {Array}
                 */
                filter : function(callback, ctx) {
        
                    var i = -1, t = this, len = t.length,
                        res = [];
        
                    while(++i < len) i in t &&
                        (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)) && res.push(t[i]);
        
                    return res;
        
                },
        
                /**
                 * Свертывает массив, используя аккумулятор
                 * @param {Function} callback вызывается для каждого элемента
                 * @param {Object} [initialVal] начальное значение аккумулятора
                 * @returns {Object} аккумулятор
                 */
                reduce : function(callback, initialVal) {
        
                    var i = -1, t = this, len = t.length,
                        res;
        
                    if(arguments.length < 2) {
                        while(++i < len) {
                            if(i in t) {
                                res = t[i];
                                break;
                            }
                        }
                    }
                    else {
                        res = initialVal;
                    }
        
                    while(++i < len) i in t &&
                        (res = callback(res, t[i], i, t));
        
                    return res;
        
                },
        
                /**
                 * Проверяет, удовлетворяет ли хотя бы один элемент массива условию в callback
                 * @param {Function} callback
                 * @param {Object} [ctx=this] контекст callback
                 * @returns {Boolean}
                 */
                some : function(callback, ctx) {
        
                    var i = -1, t = this, len = t.length;
        
                    while(++i < len)
                        if(i in t && (ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                            return true;
        
                    return false;
        
                },
        
                /**
                 * Проверяет, удовлетворяет ли каждый элемент массива условию в callback
                 * @param {Function} callback
                 * @param {Object} [ctx=this] контекст вызова callback
                 * @returns {Boolean}
                 */
                every : function(callback, ctx) {
        
                    var i = -1, t = this, len = t.length;
        
                    while(++i < len)
                        if(i in t && !(ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                            return false;
        
                    return true;
        
                }
        
            };
        
        for(var name in methods)
            ptp[name] || (ptp[name] = methods[name]);
        
        Array.isArray || (Array.isArray = function(obj) {
            return toStr.call(obj) === '[object Array]';
        });
        
        })();
    /* lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: begin */ /**/
        (function() {
        
        var slice = Array.prototype.slice;
        
        Function.prototype.bind || (Function.prototype.bind = function(ctx) {
        
            var fn = this,
                args = slice.call(arguments, 1);
        
            return function () {
                return fn.apply(ctx, args.concat(slice.call(arguments)));
            }
        
        });
        
        })();
    /* lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: begin */ /**/
        /** @fileOverview модуль для внутренних BEM-хелперов */
        /** @requires BEM */
        
        (function(BEM, $, undefined) {
        
        /**
         * Разделитель для модификаторов и их значений
         * @const
         * @type String
         */
        var MOD_DELIM = '_',
        
        /**
         * Разделитель между именами блока и вложенного элемента
         * @const
         * @type String
         */
            ELEM_DELIM = '__',
        
        /**
         * Паттерн для допустимых имен элементов и модификаторов
         * @const
         * @type String
         */
            NAME_PATTERN = '[a-zA-Z0-9-]+';
        
        function buildModPostfix(modName, modVal, buffer) {
        
            buffer.push(MOD_DELIM, modName, MOD_DELIM, modVal);
        
        }
        
        function buildBlockClass(name, modName, modVal, buffer) {
        
            buffer.push(name);
            modVal && buildModPostfix(modName, modVal, buffer);
        
        }
        
        function buildElemClass(block, name, modName, modVal, buffer) {
        
            buildBlockClass(block, undefined, undefined, buffer);
            buffer.push(ELEM_DELIM, name);
            modVal && buildModPostfix(modName, modVal, buffer);
        
        }
        
        BEM.INTERNAL = {
        
            NAME_PATTERN : NAME_PATTERN,
        
            MOD_DELIM : MOD_DELIM,
            ELEM_DELIM : ELEM_DELIM,
        
            buildModPostfix : function(modName, modVal, buffer) {
        
                var res = buffer || [];
                buildModPostfix(modName, modVal, res);
                return buffer? res : res.join('');
        
            },
        
            /**
             * Строит класс блока или элемента с учетом модификатора
             * @private
             * @param {String} block имя блока
             * @param {String} [elem] имя элемента
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @param {Array} [buffer] буфер
             * @returns {String|Array} строка класса или буфер (в зависимости от наличия параметра buffer)
             */
            buildClass : function(block, elem, modName, modVal, buffer) {
        
                var typeOf = typeof modName;
                if(typeOf == 'string') {
                    if(typeof modVal != 'string') {
                        buffer = modVal;
                        modVal = modName;
                        modName = elem;
                        elem = undefined;
                    }
                } else if(typeOf != 'undefined') {
                    buffer = modName;
                    modName = undefined;
                } else if(elem && typeof elem != 'string') {
                    buffer = elem;
                    elem = undefined;
                }
        
                if(!(elem || modName || buffer)) { // оптимизация для самого простого случая
                    return block;
                }
        
                var res = buffer || [];
        
                elem?
                    buildElemClass(block, elem, modName, modVal, res) :
                    buildBlockClass(block, modName, modVal, res);
        
                return buffer? res : res.join('');
        
            },
        
            /**
             * Строит полные классы блока или элемента с учетом модификаторов
             * @private
             * @param {String} block имя блока
             * @param {String} [elem] имя элемента
             * @param {Object} [mods] модификаторы
             * @param {Array} [buffer] буфер
             * @returns {String|Array} строка класса или буфер (в зависимости от наличия параметра buffer)
             */
            buildClasses : function(block, elem, mods, buffer) {
        
                if(elem && typeof elem != 'string') {
                    buffer = mods;
                    mods = elem;
                    elem = undefined;
                }
        
                var res = buffer || [];
        
                elem?
                    buildElemClass(block, elem, undefined, undefined, res) :
                    buildBlockClass(block, undefined, undefined, res);
        
                mods && $.each(mods, function(modName, modVal) {
                    if(modVal) {
                        res.push(' ');
                        elem?
                            buildElemClass(block, elem, modName, modVal, res) :
                            buildBlockClass(block, modName, modVal, res);
                    }
                });
        
                return buffer? res : res.join('');
        
                /*var typeOf = typeof elem;
                if(typeOf != 'string' && typeOf != 'undefined') {
                    buffer = mods;
                    mods = elem;
                    elem = undefined;
                }
                if($.isArray(mods)) {
                    buffer = mods;
                    mods = undefined;
                }
        
                var res = buffer || [];
                buildClasses(block, elem, mods, res);
                return buffer? res : res.join('');*/
        
            }
        
        }
        
        })(BEM, jQuery);
    /* lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: end */ /**/
    
    /* lego/blocks-common/i-counter/i-counter.js: begin */ /**/
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        
        !Lego.params && (Lego.params = {});
        
        
        /**
         * Хелпер удаляющий протокол из переданного хоста, для приведения
         * к каноническому виду.
         *
         * @param h {String}
         * @returns {String}
         */
        function preparseHost(h) {
            return h.replace(/^(?:https?:)?\/\//, '');
        }
        
        /**
         * Счётчик клика на ссылку или просто показа.
         *
         * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
         *
         * В случае учёта показа динамически создаёт скрипт с URL системы учёта.
         *
         * Пример использования:
         *
         * <a href="http://meteoinfo.ru" onmousedown="Lego.c('stred/pid=7/cid=433',this)">Гидрометцентр</a>
         *
         * или
         *
         * < script type="text/javascript">Lego.c('stred/pid=7/cid=433')< /script>
         *
         * @param w     параметры счётчика
         * @param a     (optional) ссылка, клик на которую надо учитывать
         * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
         */ /**/
        Lego.c = function(w, a, opts) {
        /*
            new Image().src = location.protocol + '//clck.yandex.ru/click/dtype=' + w +
                '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
                '/*' + (a ? (a.href || location.href) : '');
        */
        
            var host = preparseHost((opts && opts.host) || Lego.params['click-host'] || 'clck.yandex.ru'),
                url = function(w, h, t, a) {
        
                    h = h.replace("'", "%27"); //см. LEGO-6428
        
                    return h.indexOf('/dtype=') > -1?
                        h :
                        location.protocol + '//' + host + '/' + t + '/dtype=' + w +
                            '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
                            (a?
                                '/*' + (h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)) :
                                '/*data=' + encodeURIComponent('url='+ encodeURIComponent((h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)))));
                },
                click = function() {
                    var head = document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0];
                    var script = document.createElement('script');
                    script.setAttribute('src', url(w, location.href, 'jclck'));
                    head.insertBefore(script, head.firstChild);
                };
        
            if (a) {
                // для псевдоссылки и ссылки mailto просто считаем click, создавая iframe и в него грузим счётчик
                if (a.className.match(/b-link_pseudo_yes/) || (a.href && a.href.match(/^mailto:/)) || (opts && opts.noRedirect === true)) {
                    click();
                } else if (a.href) { // клик на ссылку, подменяем href на redir'овский, потом по таймауту обратно
                    var h = a.href;
                    a.href = url(w, h, "redir");
                    setTimeout(function() { a.href = h }, 500);
                } else if (a.form) { // клик на элемент формы
                    if (a.type.match(/submit|button|image/)) { // клик на кнопку, подменяем action на redir'овский, потом по таймауту обратно
                        var h = a.form.action;
                        a.form.action = url(w, h, "redir", true);
                        setTimeout(function() { a.form.action = h }, 500);
                    } else { // просто считаем click, создавая iframe и в него грузим счётчик
                        click();
                    }
                } else if (a.action) { //случай сабмита формы - подменяем его action на redir'овский, назад нам его менять не нужно
                    a.action = url(w, a.action, "redir", true);
                } else {
                    throw "counter.js: not link and not form!";
                }
            } else { // ссылки нет, просто учёт показа, создаём iframe и в него грузим счётчик
                click();
            }
        }
        
        })(window.Lego);
        
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        
        /**
         * Параметризованный счётчик клика на ссылку или просто показа.
         * Перевызывает Lego.c(w, a) из counter.js
         *
         * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
         *
         * В случае учёта показа динамически создаёт iframe с URL системы учёта.
         *
         * Пример использования:
         *
         * <a href="http://meteoinfo.ru" onclick="Lego.cp(0,1917,'weather.tabs.fotki',this)">Гидрометцентр</a>
         *
         * или
         *
         * < script type="text/javascript">Lego.cp(0,1917,'weather.tabs.fotki')< /script>
         *
         * @param pi    номер проекта (pid)
         * @param ci    номер счётчика (cid)
         * @param p     (optional) parameter
         * @param a     (optional) ссылка, клик на которую надо учитывать
         * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
         */
        Lego.cp = function(pi, ci, p, a, opts) {
            Lego.c('stred/pid=' + pi + '/cid=' + ci + (p ? '/path=' + p : ''), a, opts);
        }
        
        })(window.Lego);
        
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        
        !Lego.params && (Lego.params = {});
        
        /**
         * Параметризованный счётчик клика на ссылку в шапке. Перевызывает cp(w, a) из counter-cp.js
         * Используется для уменьшения веса страницы.
         *
         * Пример использования:
         *
         * <a href="http://meteoinfo.ru" onclick="ch('weather.tabs.fotki',this)">Гидрометцентр</a>
         *
         * или
         *
         * < script type="text/javascript">ch('weather')< /script>
         *
         * @param p     parameter
         * @param a     (optional) ссылка, клик на которую надо учитывать
         */
        Lego.ch = function(p, a) {
            if (Lego.params['show-counters']) Lego.cp(0, 2219, p, a);
        }
        
        })(window.Lego);
    /* lego/blocks-common/i-counter/i-counter.js: end */ /**/
    
    /* lego/blocks-common/i-common/cookie/i-common__cookie.js: begin */ /**/
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        
        Lego.getCookie = function(n) {
            var c = document.cookie;
            if (c.length < 1) return false;
        
            var b = c.indexOf(n + '=');
            if (b == -1) return false;
        
            b += (n.length + 1);
            var e = c.indexOf(';', b);
        
            return decodeURIComponent((e == -1) ? c.substring(b) : c.substring(b, e));
        }
        
        })(window.Lego);
    /* lego/blocks-common/i-common/cookie/i-common__cookie.js: end */ /**/
    
    /* lego/blocks-common/i-common/check-session/i-common__check-session.js: begin */ /**/
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        /**
         * Проверяет жива ли сессия пользователя (наличие куки yandex_login).
         *
         * @return  true, если сессия пользователя живая.
         */
        Lego.isSessionValid = function() {
            return !!Lego.getCookie('yandex_login');
        }
        })(window.Lego);
    /* lego/blocks-common/i-common/check-session/i-common__check-session.js: end */ /**/
    
    /* lego/blocks-common/i-common/init/i-common__init.js: begin */ /**/
        (function($, Lego){
        if (!Lego) Lego = window.Lego = {};
        // Использует cookie.js и check-session.js. Без них не работает.
        
        /**
         * Инициализирует Лего некоторыми параметрами (для вариативности в пределах разных страниц).
         *
         * @param params объект Лего-параметров, необходимые параметры инициализируются умолчательными значениями
         *        params.login логин текущего пользователя ('' для неавторизованного)
         *        params.locale двухбуквенный код локали в нижнем регистре
         *        params.id идентификатор сервиса
         *        params['show-counters-percent'] процент срабатывания счётчиков Lego.ch() (по умолчанию 100)
         *
         * @return возвращает установленные параметры с учетом умолчательных значений
         */
        Lego.init || (Lego.init = function(params) {
            (params = Lego.params = $.extend(
                {
                    id : '',
                    login : Lego.isSessionValid() ? Lego.getCookie('yandex_login') || '' : '',
                    yandexuid : Lego.getCookie('yandexuid'),
                    locale : 'ru',
                    retpath : window.location.toString(),
                    'passport-host' : '//passport.yandex.ru',
                    'pass-host' : '//pass.yandex.ru',
                    'passport-msg' : params.id,
                    'social-host' : '//social.yandex.ru',
                    'lego-path' : '/lego',
                    'show-counters-percent' : 100
                },
                params,
                Lego.params))
                ['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];
        
            BEM.blocks['i-global']._params || $.extend(BEM.blocks['i-global']._params = {}, params);
        
            $(function(){
                params.oframebust && Lego.oframebust(params.oframebust);
            });
        
            return params;
        });
        
        Lego.block || (Lego.block = {});
        
        Lego.blockInit || (Lego.blockInit = function(context, blockSelector) {
            context = context || document;
            blockSelector = blockSelector || '.g-js';
            $(context).find(blockSelector).each(function(){
                var block = $(this),
                    params = this.onclick ? this.onclick() : {},
                    name = params.name || '',
                    init = Lego.block[name];
                if (init && !block.data(name)) {
                    init.call(block, params);
                    block
                        .data(name, true)
                        .addClass(name + '_js_inited');
                }
            });
        });
        
        Lego.blockInitBinded || (Lego.blockInitBinded = !!$(document).ready(function(){ Lego.blockInit() }));
        
        })(jQuery, window.Lego);
    /* lego/blocks-common/i-common/init/i-common__init.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: begin */ /**/
        /**
         * Cookie plugin
         *
         * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
         * Dual licensed under the MIT and GPL licenses:
         * http://www.opensource.org/licenses/mit-license.php
         * http://www.gnu.org/licenses/gpl.html
         *
         */
        
        /**
         * Create a cookie with the given name and value and other optional parameters.
         *
         * @example $.cookie('the_cookie', 'the_value');
         * @desc Set the value of a cookie.
         * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
         * @desc Create a cookie with all available options.
         * @example $.cookie('the_cookie', 'the_value');
         * @desc Create a session cookie.
         * @example $.cookie('the_cookie', null);
         * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
         *       used when the cookie was set.
         *
         * @param String name The name of the cookie.
         * @param String value The value of the cookie.
         * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
         * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
         *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
         *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
         *                             when the the browser exits.
         * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
         * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
         * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
         *                        require a secure protocol (like HTTPS).
         * @type undefined
         *
         * @name $.cookie
         * @cat Plugins/Cookie
         * @author Klaus Hartl/klaus.hartl@stilbuero.de
         */
        
        /**
         * Get the value of a cookie with the given name.
         *
         * @example $.cookie('the_cookie');
         * @desc Get the value of a cookie.
         *
         * @param String name The name of the cookie.
         * @return The value of the cookie.
         * @type String
         *
         * @name $.cookie
         * @cat Plugins/Cookie
         * @author Klaus Hartl/klaus.hartl@stilbuero.de
         */
        jQuery.cookie = function(name, value, options) {
            if (typeof value != 'undefined') { // name and value given, set cookie
                options = options || {};
                if (value === null) {
                    value = '';
                    options.expires = -1;
                }
                var expires = '';
                if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
                    var date;
                    if (typeof options.expires == 'number') {
                        date = new Date();
                        date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
                    } else {
                        date = options.expires;
                    }
                    expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
                }
                // CAUTION: Needed to parenthesize options.path and options.domain
                // in the following expressions, otherwise they evaluate to undefined
                // in the packed version for some reason...
                var path = options.path ? '; path=' + (options.path) : '';
                var domain = options.domain ? '; domain=' + (options.domain) : '';
                var secure = options.secure ? '; secure' : '';
                document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
            } else { // only name given, get cookie
                var cookieValue = null;
                if (document.cookie && document.cookie != '') {
                    var cookies = document.cookie.split(';');
                    for (var i = 0; i < cookies.length; i++) {
                        var cookie = jQuery.trim(cookies[i]);
                        // Does this cookie string begin with the name we want?
                        if (cookie.substring(0, name.length + 1) == (name + '=')) {
                            cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                            break;
                        }
                    }
                }
                return cookieValue;
            }
        };
    /* lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: end */ /**/
    
    /* lego/blocks-desktop/i-bem/html/i-bem__html.js: begin */ /**/
        /** @requires BEM */
        /** @requires BEM.INTERNAL */
        /** @requires jquery.stringify */
        
        (function(BEM, $, undefined) {
        
        var INTERNAL = BEM.INTERNAL,
            ELEM_DELIM = INTERNAL.ELEM_DELIM,
            SHORT_TAGS = { // хэш для быстрого определения, является ли тэг коротким
                area : 1, base : 1, br : 1, col : 1, command : 1, embed : 1, hr : 1, img : 1,
                input : 1, keygen : 1, link : 1, meta : 1, param : 1, source : 1, wbr : 1 },
            buildClass = INTERNAL.buildClass,
            buildClasses = INTERNAL.buildClasses,
            decls = {};
        
        function addPropToDecl(decl, name, fn) {
        
            (decl[name] || (decl[name] = [])).unshift(fn);
        
        }
        
        function buildDeclFn(fn, desc) {
        
            return desc.modName?
                function(ctx) {
                    (ctx._curBlock.mods || {})[desc.modName] === desc.modVal && fn(ctx);
                } :
                fn;
        
        }
        
        function join(a, b) {
        
            var isArrayB = $.isArray(b),
                res;
        
            $.isArray(a)?
                isArrayB? res = a.concat(b) : (res = a).push(b) :
                isArrayB? (res = b).unshift(a) : res = [a, b];
        
            return res;
        
        }
        
        var attrEscapes = { '\'' : '\\\'', '"': '\'', '&': '&amp;', '<': '&lt;', '>': '&gt;' },
            attrEscapesRE = /['"&<>]/g;
        function escapeAttr(attrVal) {
            return attrVal.replace(attrEscapesRE, function(needToEscape) {
                return attrEscapes[needToEscape];
            });
        }
        
        /**
         * @namespace
         * @name BEM.HTML
         */
        BEM.HTML = {
        
            /**
             * Декларация
             * @protected
             * @param {String|Object} decl имя блока (простой синтаксис) или описание
             * @param {String} decl.block имя блока
             * @param {String} [decl.modName] имя модификатора
             * @param {String} [decl.modVal] значение модификатора
             * @param {Object} props свойства
             */
            decl : function(desc, props) {
        
                typeof desc == 'string' && (desc = { block : desc });
                desc.name && (desc.block = desc.name);
        
                var decl = decls[desc.block] || (decls[desc.block] = {});
        
                props.onBlock && addPropToDecl(decl, '_block', buildDeclFn(props.onBlock, desc));
        
                if(props.onElem) {
                    $.isFunction(props.onElem)?
                        addPropToDecl(decl, '_elem', buildDeclFn(props.onElem, desc)) :
                        $.each(props.onElem, function(elem, fn) {
                            addPropToDecl(decl, '_elem' + (elem === '*'? '' : ELEM_DELIM + elem), buildDeclFn(fn, desc));
                        });
                }
        
            },
        
            /**
             * Строит HTML-представление
             * @param {Object|Array} params JSON-описание
             */
            build : function(params) {
        
                var builder = new this.Ctx(params);
                builder._buildAll();
                return builder._flush();
        
            },
        
            Ctx : $.inherit(/** @lends BEM.HTML.Ctx.prototype */{
                /**
                 * @class Внутренний класс контекста билдера HTML-представления
                 * @constructs
                 * @param {Object|Array|String} params параметры
                 */
                __constructor : function(params) {
        
                    /**
                     * буфер
                     * @private
                     * @type Array
                     */
                    this._buffer = [];
        
                    /**
                     * текущие параметры
                     * @private
                     * @type Object
                     */
                    this._params = params;
        
                    /**
                     * туннелированные параметры
                     * @private
                     * @type Object
                     */
                    this._tParams = null;
        
                    this._tParamsChanges = null;
        
                    /**
                     * имя текущего блока
                     * @private
                     * @type String
                     */
                    this._curBlock = undefined;
        
                },
        
                /**
                 * Возвращает позицию контекста
                 * @returns {Number}
                 */
                pos : function() {
        
                    return this._params._pos;
        
                },
        
                /**
                 * Проверяет, является ли текущий контекст первым
                 * @returns {Boolean}
                 */
                isFirst : function() {
        
                    return this._params._pos === 1;
        
                },
        
                /**
                 * Проверяет, является ли текущий контекст последним
                 * @returns {Boolean}
                 */
                isLast : function() {
        
                    var params = this._params;
                    return params._pos === params._siblingsCount;
        
                },
        
                /**
                 * Возвращает/устанавливает параметры контекста
                 * @param {Object} [params] параметры
                 */
                params : function(params) {
        
                    var _this = this;
                    if(typeof params == 'undefined') return _this._params;
        
                    _this._params = params;
                    return _this;
        
                },
        
                /**
                 * Возвращает/устанавливает один параметр контекста
                 * @param {String} name имя параметра
                 * @param {String} [val] значение параметра
                 * @param {Boolean} [force=false] установить параметр независимо от его наличия в контексте
                 * @param {Boolean} [needExtend=false] расширять параметр
                 */
                param : function(name, val, force, needExtend) {
        
                    var _this = this,
                        params = _this._params;
        
                    if(typeof val == 'undefined') return params[name];
        
                    if(force || !(name in params)) {
                        params[name] = val;
                    } else if(needExtend) {
                        params[name] = $.extend(val, params[name]);
                    }
        
                    return _this;
        
                },
        
                /**
                 * Возвращает/устанавливает html-атрибуты контекста (шорткат к params('attrs', val))
                 * @param {Object} [val] хэш атрибутов
                 * @param {Boolean} [force=false]
                 */
                attrs : function(val, force) {
        
                    return this.param('attrs', val, force, true);
        
                },
        
                /**
                 * Возвращает/устанавливает один html-атрибут контекста
                 * @param {String} name имя атрибута
                 * @param {String} [val] значение атрибута
                 * @param {Boolean} [force=false]
                 */
                attr : function(name, val, force) {
        
                    var _this = this;
                    if(typeof val == 'undefined') return (_this._params.attrs || {})[name];
        
                    var attrs = _this._params.attrs;
                    attrs?
                        (force || !(name in attrs)) && (attrs[name] = val) :
                        (_this._params.attrs = {})[name] = val;
        
                    return _this;
        
                },
        
                /**
                 * Возвращает/устанавливает имя html-тэга контекста (шорткат к params('tag', val))
                 * @param {String} [val] тэг
                 * @param {Boolean} [force=false]
                 */
                tag : function(val, force) {
        
                    return this.param('tag', val, force);
        
                },
        
                /**
                 * Возвращает/устанавливает дополнительные CSS-классы контекста (шорткат к params('cls', val))
                 * @param {String} [val] CSS-класс
                 * @param {Boolean} [force=false]
                 */
                cls : function(val, force) {
        
                    return this.param('cls', val, force);
        
                },
        
                /**
                 * Возвращает/устанавливает модификаторы контекста (шорткат к params('mods', val))
                 * @param {Object} [val] хэш модификаторов
                 * @param {Boolean} [force=false]
                 */
                mods : function(val, force) {
        
                    return this.param('mods', val, force, true);
        
                },
        
                /**
                 * Возвращает/устанавливает один модификатор контекста
                 * @param {String} name имя модификатора
                 * @param {String} [val] значение модификатора
                 * @param {Boolean} [force=false]
                 */
                mod : function(name, val, force) {
        
                    var _this = this;
                    if(typeof val == 'undefined') return (_this._params.mods || {})[name];
        
                    var mods = _this._params.mods;
                    mods?
                        (force || !(name in mods)) && (mods[name] = val) :
                        (_this._params.mods = {})[name] = val;
        
                    return _this;
        
                },
        
                /**
                 * Возвращает/добавляет/устанавливает миксы
                 * @param {Array} [val] миксы
                 * @param {Boolean} [force=false]
                 */
                mix : function(val, force) {
        
                    var _this = this,
                        params = _this._params;
        
                    if(typeof val == 'undefined') return params.mix;
        
                    if(force || !('mix' in params)) {
                        params.mix = val;
                    } else {
                        params.mix = params.mix.concat(val);
                    }
        
                    return _this;
        
                },
        
                /**
                 * Возвращает/устанавливает js-параметры контекста (шорткат к params('js', val))
                 * @param {Boolean|Object} [val] параметры
                 */
                js : function(val) {
        
                    return this.param('js', val);
        
                },
        
                /**
                 * Возвращает/устанавливает контент контекста (шорткат к params('content', val))
                 * @param {String|Object|Array} [val] контент
                 * @param {Boolean} [force=false] установить контент независимо от его наличия
                 */
                content : function(val, force) {
        
                    return this.param('content', val, force);
        
                },
        
                /**
                 * Оборачивает контент контекста (например, другим элементом)
                 * @param {Object} obj
                 */
                wrapContent : function(obj) {
        
                    var _this = this,
                        params = _this._params;
        
                    obj.content = params.content;
                    params.content = obj;
        
                    return _this;
        
                },
        
                /**
                 * Добавляет контент перед контентом контекста (например, еще один элемент)
                 * @param {Object|Array} obj
                 */
                beforeContent : function(obj) {
        
                    var _this = this,
                        params = _this._params;
        
                    params.content = join(obj, params.content);
        
                    return _this;
        
                },
        
                /**
                 * Добавляет контент после контента контекста (например, еще один элемент)
                 * @param {Object|Array} obj
                 */
                afterContent : function(obj) {
        
                    var _this = this,
                        params = _this._params;
        
                    params.content = join(params.content, obj);
        
                    return _this;
        
                },
        
                /**
                 * Оборачивает контекста (например, другим элементом или блоком)
                 * @param {Object} obj
                 */
                wrap : function(obj) {
        
                    var _this = this,
                        params = _this._params;
        
                    obj.block || (obj._curBlock = _this._curBlock);
                    obj.content = params._wrapper? params._wrapper : params;
                    params._wrapper = obj;
        
                    return _this;
        
                },
        
                /**
                 * Возвращает/устанавливает один туннелированный параметр контекста
                 * @param {String} name имя параметра
                 * @param {String} [val] значение параметра
                 */
                tParam : function(name, val) {
        
                    var _this = this,
                        tParams = _this._tParams || (_this._tParams = {});
        
                    if(typeof val == 'undefined') return tParams[name];
        
                    var tParamsChanges = _this._tParamsChanges || (_this._tParamsChanges = {});
        
                    name in tParamsChanges || (tParamsChanges[name] = tParams[name]);
        
                    tParams[name] = val;
        
                    return _this;
        
                },
        
                /**
                 * Генерирует уникальный идентификатор
                 * returns {String}
                 */
                generateId : function() {
        
                    return $.identify();
        
                },
        
                /**
                 * Останавливает применение более базовых шаблонов
                 */
                stop : function() {
        
                    this._params._isStopped = true;
        
                },
        
                /**
                 * Выполняет одну итерацию билда в зависимости от типа контекста
                 * @private
                 */
                _buildAll : function() {
        
                    var _this = this,
                        buffer = _this._buffer,
                        params = _this._params,
                        paramsType = typeof params;
        
                    if(paramsType == 'string' || paramsType == 'number') {
                        buffer.push(params);
                    } else if($.isArray(params)) {
                        var i = 0, len = params.length, currParams, currParamsType;
                        while(i < len) {
                             _this._params = currParams = params[i++];
                            currParamsType = typeof currParams;
                            if(currParamsType == 'string' || currParamsType == 'number') {
                                buffer.push(currParams);
                            } else if(currParams) {
                                currParams._pos = i;
                                currParams._siblingsCount = len;
                                _this._buildByDecl();
                            }
                        }
                    } else if(params) {
                        _this._params._pos = _this._params._siblingsCount = 1;
                        _this._buildByDecl();
                    }
        
                },
        
                /**
                 * Дефолтный билд
                 * @private
                 */
                _build : function() {
        
                    var _this = this,
                        buffer = _this._buffer,
                        params = _this._params,
                        tag = params.tag || 'div',
                        jsParams,
                        isBEM = params.block || params.elem,
                        curBlock = isBEM && (params.block || _this._curBlock.block),
                        addInitingCls = false;
        
                    if(params.js) {
                        (jsParams = {})[buildClass(curBlock, params.elem)] = params.js === true? {} : params.js;
                        addInitingCls = !params.elem;
                    }
        
                    buffer.push('<', tag);
        
                    if(isBEM || params.cls) {
                        buffer.push(' class="');
                        if(isBEM) {
                            buildClasses(curBlock, params.elem, params.mods, buffer);
                            params.mix && $.each(params.mix, function(i, mix) {
                                if(mix) {
                                    buffer.push(' ');
                                    buildClasses(mix.block, mix.elem, mix.mods, buffer);
                                    if(mix.js) {
                                        (jsParams || (jsParams = {}))[buildClass(mix.block, mix.elem)] = mix.js === true? {} : mix.js;
                                        addInitingCls || (addInitingCls = !mix.elem);
                                    }
                                }
                            });
                        }
        
                        params.cls && buffer.push(isBEM? ' ' : '', params.cls);
        
                        addInitingCls && buffer.push(' i-bem');
                        buffer.push('"');
                    }
        
                    jsParams && buffer.push(
                        ' onclick="return ',
                        escapeAttr(JSON.stringify(jsParams)),
                        '"');
        
                    params.attrs && $.each(params.attrs, function(name, val) {
                        typeof val != 'undefined' && val !== null && val !== false && buffer.push(
                            ' ',
                            name,
                            '="',
                            val.toString().replace(/"/g, "&quot;"),
                            '"');
                    });
        
                    if(SHORT_TAGS[tag]) {
                        buffer.push('/>');
                    } else {
                        buffer.push('>');
        
                        if(typeof params.content != 'undefined') {
                            _this._params = params.content;
                            _this._buildAll();
                        }
        
                        buffer.push('</', tag, '>');
                    }
        
                },
        
                /**
                 * Очищает буфер и возвращает его содержимое
                 * @private
                 * @returns {String} содержимое буфера
                 */
                _flush : function() {
        
                    var res = this._buffer.join('');
                    delete this._buffer;
                    return res;
        
                },
        
                _buildByDecl : function() {
        
                    var _this = this,
                        currBlock = _this._curBlock,
                        params = _this._params;
        
                    params._curBlock && (_this._curBlock = params._curBlock);
                    params.block && (_this._curBlock = params);
        
                    if(!params._wrapper) {
                        if(params.block || params.elem) {
                            var decl = decls[_this._curBlock.block];
                            if(decl) {
                                var fns;
                                if(params.elem) {
                                    fns = decl['_elem' + ELEM_DELIM + params.elem];
                                    decl._elem && (fns = (fns? fns.concat(decl._elem) : decl._elem));
                                } else {
                                    fns = decl._block;
                                }
        
                                if(fns) {
                                    var i = 0, fn;
                                    while(fn = fns[i++]) {
                                        fn(_this);
                                        if(params._isStopped) break;
                                    }
                                }
                            }
                        }
        
                        if(params._wrapper) {
                            params._curBlock = _this._curBlock;
                            _this._params = params._wrapper;
                            return _this._buildAll();
                        }
                    }
        
                    var tParamsChanges = _this._tParamsChanges;
                        _this._tParamsChanges = null;
        
                    _this._build();
        
                    _this._curBlock = currBlock;
        
                    if(tParamsChanges) {
                        var tParams = _this._tParams;
                        $.each(tParamsChanges, function(name, val) {
                            typeof val == 'undefined'?
                                delete tParams[name] :
                                tParams[name] = val;
                        });
                    }
        
                }
        
            })
        
        };
        
        })(BEM, jQuery);
    /* lego/blocks-desktop/i-bem/html/i-bem__html.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: begin */ /**/
        (function(undefined) {
        
        if(window.JSON) return;
        
        var _toString = Object.prototype.toString,
            escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
            meta = {
                '\b' : '\\b',
                '\t' : '\\t',
                '\n' : '\\n',
                '\f' : '\\f',
                '\r' : '\\r',
                '"'  : '\\"',
                '\\' : '\\\\'
            },
            stringify;
        
        window.JSON = {
            stringify : stringify = function(val) {
                if(val === null) {
                    return 'null';
                }
                if(typeof val === 'undefined') {
                    return undefined;
                }
                switch(_toString.call(val)) {
                    case '[object String]':
                        return '"' +
                            (escapable.test(val)?
                                val.replace(escapable, function(a) {
                                    var c = meta[a];
                                    return typeof c === 'string'? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                                }) :
                                val) +
                            '"';
                    case '[object Number]':
                    case '[object Boolean]':
                        return '' + val;
                    case '[object Array]':
                        var res = '[', i = 0, len = val.length, strVal;
                        while(i < len) {
                            strVal = stringify(val[i]);
                            res += (i++? ',' : '') + (typeof strVal === 'undefined'? 'null' : strVal);
                        }
                        return res + ']';
                    case '[object Object]':
                        var res = '{', i = 0, strVal;
                        for(var key in val) {
                            if(val.hasOwnProperty(key)) {
                                strVal = stringify(val[key]);
                                typeof strVal !== 'undefined' && (res += (i++? ',' : '') + '"' + key + '":' + strVal);
                            }
                        }
                        return res + '}';
                    default:
                        return undefined;
                }
            }
        };
        })();
    /* lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: begin */ /**/
        /** @requires BEM */
        /** @requires BEM.INTERNAL */
        
        (function(BEM, $, undefined) {
        
        var win = $(window),
            doc = $(document),
        
        /**
         * Хранилище для DOM-элементов по уникальному ключу
         * @private
         * @type Object
         */
            uniqIdToDomElems = {},
        
        /**
         * Хранилище для блоков по уникальному ключу
         * @static
         * @private
         * @type Object
         */
            uniqIdToBlock = {},
        
        /**
         * Хранилище для параметров блоков
         * @private
         * @type Object
         */
            domElemToParams = {},
        
        /**
         * Хранилище для обработчиков liveCtx-событий
         * @private
         * @type Object
         */
            liveEventCtxStorage = {},
        
        /**
         * Хранилище для обработчиков liveClass-событий
         * @private
         * @type Object
         */
            liveClassEventStorage = {},
        
            blocks = BEM.blocks,
        
            INTERNAL = BEM.INTERNAL,
        
            NAME_PATTERN = INTERNAL.NAME_PATTERN,
        
            MOD_DELIM = INTERNAL.MOD_DELIM,
            ELEM_DELIM = INTERNAL.ELEM_DELIM,
        
            buildModPostfix = INTERNAL.buildModPostfix,
            buildClass = INTERNAL.buildClass;
        
        /**
         * Инициализирует блоки на DOM-элементе
         * @private
         * @param {jQuery} domElem DOM-элемент
         * @param {String} uniqInitId идентификатор "волны инициализации"
         */
        function init(domElem, uniqInitId) {
        
            var domNode = domElem[0];
            $.each(getParams(domNode), function(blockName, params) {
                processParams(params, domNode, blockName, uniqInitId);
                var block = uniqIdToBlock[params.uniqId];
                if(block) {
                    if(block.domElem.index(domNode) < 0) {
                        block.domElem = block.domElem.add(domElem);
                        $.extend(block._params, params);
                    }
                } else {
                    initBlock(blockName, domElem, params);
                }
            });
        
        }
        
        /**
         * Инициализирует конкретный блок на DOM-элементе или возвращает существующий блок, если он уже был создан
         * @private
         * @param {String} blockName имя блока
         * @param {jQuery} domElem DOM-элемент
         * @param {Object} [params] параметры инициализации
         * @param {Boolean} [forceLive] форсировать возможность live-инициализации
         * @param {Function} [callback] обработчик, вызываемый после полной инициализации
         */
        function initBlock(blockName, domElem, params, forceLive, callback) {
        
            if(typeof params == 'boolean') {
                callback = forceLive;
                forceLive = params;
                params = undefined;
            }
        
            var domNode = domElem[0];
            params = processParams(params || getParams(domNode)[blockName], domNode, blockName);
        
            var uniqId = params.uniqId;
            if(uniqIdToBlock[uniqId]) {
                return uniqIdToBlock[uniqId]._init();
            }
        
            uniqIdToDomElems[uniqId] = uniqIdToDomElems[uniqId]?
                uniqIdToDomElems[uniqId].add(domElem) :
                domElem;
        
            var parentDomNode = domNode.parentNode;
            if(!parentDomNode || parentDomNode.nodeType === 11) { // jquery doesn't unique disconnected node
                $.unique(uniqIdToDomElems[uniqId]);
            }
        
            var blockClass = blocks[blockName] || DOM.decl(blockName, {}, { live : true });
            if(!(blockClass._liveInitable = !!blockClass._processLive()) || forceLive || params.live === false) {
                var block = new blockClass(uniqIdToDomElems[uniqId], params, !!forceLive);
                delete uniqIdToDomElems[uniqId];
                callback && callback.apply(block, Array.prototype.slice.call(arguments, 4));
                return block;
            }
        
        }
        
        /**
         * Обрабатывает и добавляет необходимые параметры блока
         * @private
         * @param {Object} params параметры инициализации
         * @param {HTMLElement} domNode DOM-нода
         * @param {String} blockName имя блока
         * @param {String} [uniqInitId] идентификатор "волны инициализации"
         */
        function processParams(params, domNode, blockName, uniqInitId) {
        
            (params || (params = {})).uniqId ||
                (params.uniqId = (params.id? blockName + '-id-' + params.id : $.identify()) + (uniqInitId || $.identify()));
        
            var domUniqId = $.identify(domNode),
                domParams = domElemToParams[domUniqId] || (domElemToParams[domUniqId] = {});
        
            domParams[blockName] || (domParams[blockName] = params);
        
            return params;
        
        }
        
        /**
         * Хелпер для поиска DOM-элемента по селектору внутри контекста, включая сам контекст
         * @private
         * @param {jQuery} ctx контекст
         * @param {String} selector CSS-селектор
         * @param {Boolean} [excludeSelf=false] исключить контекст из поиска
         * @returns {jQuery}
         */
        function findDomElem(ctx, selector, excludeSelf) {
        
            var res = ctx.find(selector);
            return excludeSelf?
               res :
               res.add(ctx.filter(selector));
        
        }
        
        /**
         * Возвращает параметры DOM-элемента блока
         * @private
         * @param {HTMLElement} domNode DOM-нода
         * @returns {Object}
         */
        function getParams(domNode) {
        
            var uniqId = $.identify(domNode);
            return domElemToParams[uniqId] ||
                   (domElemToParams[uniqId] = extractParams(domNode));
        
        }
        
        /**
         * Извлекает параметры блока из DOM-элемента
         * @private
         * @param {HTMLElement} domNode DOM-нода
         * @returns {Object}
         */
        function extractParams(domNode) {
        
            var fn = domNode.onclick || domNode.ondblclick;
            if(!fn && domNode.tagName.toLowerCase() == 'body') { // LEGO-2027 в FF onclick не работает на body
                var elem = $(domNode),
                    attr = elem.attr('onclick') || elem.attr('ondblclick');
                attr && (fn = Function(attr));
            }
            return fn? fn() : {};
        
        }
        
        /**
         * Очищает все BEM-хранилища, связанные с DOM-нодой
         * @private
         * @param {HTMLElement} domNode DOM-нода
         */
        function cleanupDomNode(domNode) {
        
            delete domElemToParams[$.identify(domNode)];
        
        }
        
        /**
         * Отцепляет DOM-ноду от блока, если нода последняя -- уничтожает блок
         * @private
         * @param {BEM.DOM} block блок
         * @param {HTMLElement} domNode DOM-нода
         */
        function removeDomNodeFromBlock(block, domNode) {
        
            block.domElem.length === 1?
                block.destruct(true) :
                block.domElem = block.domElem.not(domNode);
        
        }
        
        /**
         * Возвращает DOM-ноду для вычислений размера окна в IE
         * @returns {HTMLElement}
         */
        function getClientNode() {
        
            return doc[0][$.support.boxModel? 'documentElement' : 'body'];
        
        }
        
        /**
         * Возвращает и, при необходимости, инициализирует блок на DOM-элементе
         * @param {String} blockName имя блока
         * @param {Object} params параметры блока
         * @returns {BEM}
         */
        $.fn.bem = function(blockName, params) {
            return initBlock(blockName, this, params, true);
        };
        
        /**
         * @namespace
         * @name BEM.DOM
         */
        var DOM = BEM.DOM = BEM.decl('i-bem__dom',/** @lends BEM.DOM.prototype */{
            /**
             * @class Базовый блок для создания bem-блоков, имеющих DOM-представление
             * @constructs
             * @private
             * @param {jQuery} domElem DOM-элемент, на котором создается блок
             * @param {Object} params параметры блока
             * @param {Boolean} [initImmediately=true]
             */
            __constructor : function(domElem, params, initImmediately) {
        
                var _this = this;
        
                /**
                 * DOM-элементы блока
                 * @protected
                 * @type jQuery
                 */
                _this.domElem = domElem;
        
                /**
                 * кэш для имен событий на DOM-элементах
                 * @private
                 * @type Object
                 */
                _this._eventNameCache = {};
        
                /**
                 * кэш для элементов
                 * @private
                 * @type Object
                 */
                _this._elemCache = {};
        
                /**
                 * уникальный идентификатор блока
                 * @private
                 * @type String
                 */
                uniqIdToBlock[_this._uniqId = params.uniqId || $.identify(_this)] = _this;
        
                /**
                 * флаг необходимости unbind от document и window при уничтожении блока
                 * @private
                 * @type Boolean
                 */
                _this._needSpecialUnbind = false;
        
                _this.__base(null, params, initImmediately);
        
            },
        
            /**
             * Находит блоки внутри (включая контекст) текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM[]}
             */
            findBlocksInside : function(elem, block) {
        
                return this._findBlocks('find', elem, block);
        
            },
        
            /**
             * Находит первый блок внутри (включая контекст) текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM}
             */
            findBlockInside : function(elem, block) {
        
                return this._findBlocks('find', elem, block, true);
        
            },
        
            /**
             * Находит блоки снаружи (включая контекст) текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM[]}
             */
            findBlocksOutside : function(elem, block) {
        
                return this._findBlocks('parents', elem, block);
        
            },
        
            /**
             * Находит первый блок снаружи (включая контекст) текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM}
             */
            findBlockOutside : function(elem, block) {
        
                return this._findBlocks('closest', elem, block)[0] || null;
        
            },
        
            /**
             * Находит блоки на DOM-элементах текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM[]}
             */
            findBlocksOn : function(elem, block) {
        
                return this._findBlocks('', elem, block);
        
            },
        
            /**
             * Находит первый блок на DOM-элементах текущего блока или его элементов
             * @protected
             * @param {String|jQuery} [elem] элемент блока
             * @param {String|Object} block имя или описание (block,modName,modVal) искомого блока
             * @returns {BEM}
             */
            findBlockOn : function(elem, block) {
        
                return this._findBlocks('', elem, block, true);
        
            },
        
            _findBlocks : function(select, elem, block, onlyFirst) {
        
                if(!block) {
                    block = elem;
                    elem = undefined;
                }
        
                var ctxElem = elem?
                        (typeof elem == 'string'? this.findElem(elem) : elem) :
                        this.domElem,
                    isSimpleBlock = typeof block == 'string',
                    blockName = isSimpleBlock? block : (block.block || block.blockName),
                    selector = '.' +
                        (isSimpleBlock?
                            buildClass(blockName) :
                            buildClass(blockName, block.modName, block.modVal)) +
                        (onlyFirst? ':first' : ''),
                    domElems = ctxElem.filter(selector);
        
                select && (domElems = domElems.add(ctxElem[select](selector)));
        
                if(onlyFirst) {
                    return domElems[0]? initBlock(blockName, domElems.eq(0), true) : null;
                }
        
                var res = [],
                    uniqIds = {};
        
                $.each(domElems, function(i, domElem) {
                    var block = initBlock(blockName, $(domElem), true);
                    if(!uniqIds[block._uniqId]) {
                        uniqIds[block._uniqId] = true;
                        res.push(block);
                    }
                });
        
                return res;
        
            },
        
            /**
             * Добавляет обработчик события произвольного DOM-элемента
             * @protected
             * @param {jQuery} domElem DOM-элемент, на котором будет слушаться событие
             * @param {String|Object} event имя события или объект события
             * @param {Function} fn функция-обработчик, будет выполнена в контексте блока
             * @returns {BEM}
             */
            bindToDomElem : function(domElem, event, fn) {
        
                var _this = this;
        
                fn?
                    domElem.bind(
                        _this._buildEventName(event),
                        function(e) {
                            (e.data || (e.data = {})).domElem = $(this);
                            return fn.apply(_this, arguments);
                        }
                    ) :
                    $.each(event, function(event, fn) {
                        _this.bindToDomElem(domElem, event, fn);
                    });
        
                return _this;
        
            },
        
            /**
             * Добавляет обработчик события на document
             * @protected
             * @param {String} event имя события
             * @param {Function} fn функция-обработчик, будет выполнена в контексте блока
             * @returns {BEM}
             */
            bindToDoc : function(event, fn) {
        
                this._needSpecialUnbind = true;
                return this.bindToDomElem(doc, event, fn);
        
            },
        
            /**
             * Добавляет обработчик события на window
             * @protected
             * @param {String} event имя события
             * @param {Function} fn функция-обработчик, будет выполнена в контексте блока
             * @returns {BEM}
             */
            bindToWin : function(event, fn) {
        
                this._needSpecialUnbind = true;
                return this.bindToDomElem(win, event, fn);
        
            },
        
            /**
             * Добавляет обработчик события на основные DOM-элементы блока или его вложенные элементы
             * @protected
             * @param {jQuery|String} [elem] элемент
             * @param {String} event имя события
             * @param {Function} fn функция-обработчик, будет выполнена в контексте блока
             * @returns {BEM}
             */
            bindTo : function(elem, event, fn) {
        
                if(!event || $.isFunction(event)) { // если нет элемента
                    fn = event;
                    event = elem;
                    elem = this.domElem;
                } else if(typeof elem == 'string') {
                    elem = this.elem(elem);
                }
        
                return this.bindToDomElem(elem, event, fn);
        
            },
        
            /**
             * Удаляет обработчики события произвольного DOM-элемента
             * @protected
             * @param {jQuery} domElem DOM-элемент, на котором будет слушаться событие
             * @param {String} event имя события
             * @returns {BEM}
             */
            unbindFromDomElem : function(domElem, event) {
        
                domElem.unbind(this._buildEventName(event));
                return this;
        
            },
        
            /**
             * Удаляет обработчик события у document
             * @protected
             * @param {String} event имя события
             * @returns {BEM}
             */
            unbindFromDoc : function(event) {
        
                return this.unbindFromDomElem(doc, event);
        
            },
        
            /**
             * Удаляет обработчик события у document
             * @protected
             * @param {String} event имя события
             * @returns {BEM}
             */
            unbindFromWin : function(event) {
        
                return this.unbindFromDomElem(win, event);
        
            },
        
            /**
             * Удаляет обработчики события из основных DOM-элементы блока или его вложенных элементов
             * @protected
             * @param {jQuery|String} [elem] вложенный элемент
             * @param {String} event имя события
             * @returns {BEM}
             */
            unbindFrom : function(elem, event) {
        
                if(!event) {
                    event = elem;
                    elem = this.domElem;
                } else if(typeof elem == 'string') {
                    elem = this.elem(elem);
                }
        
                return this.unbindFromDomElem(elem, event);
        
            },
        
            /**
             * Строит полное имя события
             * @private
             * @param {String} event имя события
             * @returns {String}
             */
            _buildEventName : function(event) {
        
                var _this = this;
                return event.indexOf(' ') > 1?
                    event.split(' ').map(function(e) {
                        return _this._buildOneEventName(e);
                    }).join(' ') :
                    _this._buildOneEventName(event);
        
            },
        
            /**
             * Строит полное имя для одного события
             * @private
             * @param {String} event имя события
             * @returns {String}
             */
            _buildOneEventName : function(event) {
        
                var _this = this,
                    eventNameCache = _this._eventNameCache;
        
                if(event in eventNameCache) return eventNameCache[event];
        
                var uniq = '.' + _this._uniqId;
        
                if(event.indexOf('.') < 0) return eventNameCache[event] = event + uniq;
        
                var lego = '.bem_' + _this.__self._name;
        
                return eventNameCache[event] = event.split('.').map(function(e, i) {
                    return i == 0? e + lego : lego + '_' + e;
                }).join('') + uniq;
        
            },
        
            /**
             * Запускает обработчики события у блока и обработчики live-событий
             * @protected
             * @param {String} e имя события
             * @param {Object} [data] дополнительные данные
             * @returns {BEM}
             */
            trigger : function(e, data) {
        
                this
                    .__base(e = this.buildEvent(e), data)
                    .domElem && this._ctxTrigger(e, data);
        
                return this;
        
            },
        
            _ctxTrigger : function(e, data) {
        
                var _this = this,
                    storage = liveEventCtxStorage[_this.__self._buildCtxEventName(e.type)],
                    ctxIds = {};
        
                storage && _this.domElem.each(function() {
                    var ctx = this,
                        counter = storage.counter;
                    while(ctx && counter) {
                        var ctxId = $.identify(ctx, true);
                        if(ctxId) {
                            if(ctxIds[ctxId]) break;
                            var storageCtx = storage.ctxs[ctxId];
                            if(storageCtx) {
                                $.each(storageCtx, function(uniqId, handler) {
                                    handler.fn.call(
                                        handler.ctx || _this,
                                        e,
                                        data);
                                });
                                counter--;
                            }
                            ctxIds[ctxId] = true;
                        }
                        ctx = ctx.parentNode;
                    }
                });
        
            },
        
            /**
             * Устанавливает модификатор у блока/вложенного элемента
             * @protected
             * @param {jQuery} [elem] вложенный элемент
             * @param {String} modName имя модификатора
             * @param {String} modVal значение модификатора
             * @returns {BEM}
             */
            setMod : function(elem, modName, modVal) {
        
                if(elem && typeof modVal != 'undefined' && elem.length > 1) {
                    var _this = this;
                    elem.each(function() {
                        var item = $(this);
                        item.__bemElemName = elem.__bemElemName;
                        _this.setMod(item, modName, modVal);
                    });
                    return _this;
                }
                return this.__base(elem, modName, modVal);
        
            },
        
            /**
             * Извлекает значение модификатора из CSS-класса DOM-ноды
             * @private
             * @param {String} modName имя модификатора
             * @param {jQuery} [elem] вложенный элемент
             * @param {String} [elemName] имя вложенного элемента
             * @returns {String} значение модификатора
             */
            _extractModVal : function(modName, elem, elemName) {
        
                var domNode = (elem || this.domElem)[0],
                    matches;
        
                domNode &&
                    (matches = domNode.className
                        .match(this.__self._buildModValRE(modName, elemName || elem)));
        
                return matches? matches[2] : '';
        
            },
        
            /**
             * Извлекает имя/значение списка модификаторов
             * @private
             * @param {Array} [modNames] имена модификаторов
             * @param {Object} [elem] элемент
             * @returns {Object} хэш значений модификаторов по имени
             */
            _extractMods : function(modNames, elem) {
        
                var res = {},
                    extractAll = !modNames.length,
                    countMatched = 0;
        
                ((elem || this.domElem)[0].className
                    .match(this.__self._buildModValRE(
                        '(' + (extractAll? NAME_PATTERN : modNames.join('|')) + ')',
                        elem,
                        'g')) || []).forEach(function(className) {
                            var iModVal = (className = className.trim()).lastIndexOf(MOD_DELIM),
                                iModName = className.substr(0, iModVal - 1).lastIndexOf(MOD_DELIM);
                            res[className.substr(iModName + 1, iModVal - iModName - 1)] = className.substr(iModVal + 1);
                            ++countMatched;
                        });
        
                // пустые значения модификаторов не отражены в классах, нужно их заполнить пустыми значения
                countMatched < modNames.length && modNames.forEach(function(modName) {
                    modName in res || (res[modName] = '');
                });
        
                return res;
        
            },
        
            /**
             * Уставливает CSS-класс модификатора на DOM-элемент блока или вложенный элемент
             * @private
             * @param {String} modName имя модификатора
             * @param {String} modVal значение модификатора
             * @param {String} oldModVal старое значение модификатора
             * @param {jQuery} [elem] элемент
             * @param {String} [elemName] имя элемента
             */
            _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {
        
                var _self = this.__self,
                    classPrefix = _self._buildModClassPrefix(modName, elemName),
                    classRE = _self._buildModValRE(modName, elemName),
                    needDel = modVal === '';
        
                (elem || this.domElem).each(function() {
                    var className = this.className;
                    className.indexOf(classPrefix) > -1?
                        this.className = className.replace(
                            classRE,
                            (needDel? '' : '$1' + classPrefix + modVal) + '$3') :
                        needDel || $(this).addClass(classPrefix + modVal);
                });
        
                elemName && this
                    .dropElemCache(elemName, modName, oldModVal)
                    .dropElemCache(elemName, modName, modVal);
        
            },
        
            /**
             * Находит вложенные в блок элементы
             * @protected
             * @param {String|jQuery} [ctx=this.domElem] элемент, на котором проходит поиск
             * @param {String} names имя (или через пробел имена) вложенного элемента
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {jQuery} DOM-элементы
             */
            findElem : function(ctx, names, modName, modVal) {
        
                if(arguments.length % 2) { // если кол-во аргументов один или три
                    modVal = modName;
                    modName = names;
                    names = ctx;
                    ctx = this.domElem;
                } else if(typeof ctx == 'string') {
                    ctx = this.findElem(ctx);
                }
        
                var _self = this.__self,
                    selector = '.' +
                        names.split(' ').map(function(name) {
                            return buildClass(_self._name, name, modName, modVal);
                        }).join(',.');
                return findDomElem(ctx, selector);
        
            },
        
            /**
             * Находит вложенные в блок элементы
             * @protected
             * @param {String} name имя вложенного элемента
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {jQuery} DOM-элементы
             */
            _elem : function(name, modName, modVal) {
        
                var key = name + buildModPostfix(modName, modVal),
                    res;
        
                if(!(res = this._elemCache[key])) {
                    res = this._elemCache[key] = this.findElem(name, modName, modVal);
                    res.__bemElemName = name;
                }
        
                return res;
        
            },
        
            /**
             * Ленивый поиск вложенных в блок элементы (результат кэшируется)
             * @protected
             * @param {String} names имя (или через пробел имена) вложенных элементов
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {jQuery} DOM-элементы
             */
            elem : function(names, modName, modVal) {
        
                if(modName && typeof modName != 'string') {
                    modName.__bemElemName = names;
                    return modName;
                }
        
                if(names.indexOf(' ') < 0) {
                    return this._elem(names, modName, modVal);
                }
        
                var res = $([]),
                    _this = this;
                names.split(' ').forEach(function(name) {
                    res = res.add(_this._elem(name, modName, modVal));
                });
                return res;
        
            },
        
            /**
             * Сброс кэша для элементов
             * @protected
             * @param {String} names имя (или через пробел имена) вложенных элементов
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {BEM}
             */
            dropElemCache : function(names, modName, modVal) {
        
                if(names) {
                    var _this = this,
                        modPostfix = buildModPostfix(modName, modVal);
                    names.indexOf(' ') < 0?
                        delete _this._elemCache[names + modPostfix] :
                        names.split(' ').forEach(function(name) {
                            delete _this._elemCache[name + modPostfix];
                        });
                } else {
                    this._elemCache = {};
                }
        
                return this;
        
            },
        
            /**
             * Извлекает параметры элемента блока
             * @param {String|jQuery} elem элемент
             * @returns {Object} параметры
             */
            elemParams : function(elem) {
        
                var elemName;
                if(typeof elem ==  'string') {
                    elemName = elem;
                    elem = this.elem(elem);
                } else {
                    elemName = this.__self._extractElemNameFrom(elem);
                }
        
                return extractParams(elem[0])[buildClass(this.__self.getName(), elemName)] || {};
        
            },
        
            /**
             * Проверяет, находится ли DOM-элемент в блоке
             * @protected
             * @param {jQuery} domElem DOM-элемент
             * @returns {Boolean}
             */
            containsDomElem : function(domElem) {
        
                var res = false;
        
                this.domElem.each(function() {
                    return !(res = domElem.parents().andSelf().index(this) > -1);
                });
        
                return res;
        
            },
        
            /**
             * Строит CSS-селектор, соответствующий блоку/элементу и модификатору
             * @param {String} [elem] имя элемент
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {String}
             */
            buildSelector : function(elem, modName, modVal) {
        
                return this.__self.buildSelector(elem, modName, modVal);
        
            },
        
            /**
             * Удаляет блок
             * @param {Boolean} [keepDOM=false] нужно ли оставлять DOM-ноды блока в документе
             */
            destruct : function(keepDOM) {
        
                var _this = this,
                    _self = _this.__self;
        
                _this._isDestructing = true;
        
                _this._needSpecialUnbind && _self.doc.add(_self.win).unbind('.' + _this._uniqId);
        
                _this.dropElemCache().domElem.each(function(i, domNode) {
                    var params = getParams(domNode);
                    $.each(params, function(blockName, blockParams) {
                        var block = uniqIdToBlock[blockParams.uniqId];
                        if(block) {
                            if(!block._isDestructing) {
                                removeDomNodeFromBlock(block, domNode);
                                delete params[blockName];
                            }
                        }
                        else {
                            delete uniqIdToDomElems[blockParams.uniqId];
                        }
                    });
                    $.isEmptyObject(params) && cleanupDomNode(domNode);
                });
        
                keepDOM || _this.domElem.remove();
        
                delete uniqIdToBlock[_this.un()._uniqId];
                delete _this.domElem;
                delete _this._elemCache;
        
                _this.__base();
        
            }
        
        }, /** @lends BEM.DOM */{
        
            /**
             * Шорткат для документа
             * @protected
             * @type jQuery
             */
            doc : doc,
        
            /**
             * Шорткат для window
             * @protected
             * @type jQuery
             */
            win : win,
        
            /**
             * Осуществляет обработку live-свойств блока
             * @private
             * @param {Boolean} [heedLive=false] нужно ли учитывать то, что блок обрабатывал уже свои live-свойства
             * @returns {Boolean} является ли блок live-блоком
             */
            _processLive : function(heedLive) {
        
                var _this = this,
                    res = _this._liveInitable;
        
                if('live' in _this) {
                    var noLive = typeof res == 'undefined';
        
                    if(noLive ^ heedLive) {
                        if($.isFunction(_this.live)) {
                            res = _this.live() !== false;
                            _this.live = function() {};
                        } else {
                            res = _this.live;
                        }
                    }
                }
        
                return res;
        
            },
        
            /**
             * Инициализирует блоки на фрагменте DOM-дерева
             * @static
             * @protected
             * @param {jQuery} [ctx=document] корневая DOM-нода
             * @returns {jQuery} ctx контекст инициализации
             */
            init : function(ctx, callback, callbackCtx) {
        
                if(!ctx || $.isFunction(ctx)) {
                    callbackCtx = callback;
                    callback = ctx;
                    ctx = doc;
                }
        
                var uniqInitId = $.identify();
                findDomElem(ctx, '.i-bem').each(function() {
                    init($(this), uniqInitId);
                });
        
                callback && this.afterCurrentEvent(
                    function() {
                        callback.call(callbackCtx || this, ctx);
                    });
        
                // чтобы инициализация была полностью синхронной
                this._runAfterCurrentEventFns();
        
                return ctx;
        
            },
        
            /**
             * Уничтожает блоки на фрагменте DOM-дерева
             * @static
             * @protected
             * @param {Boolean} [keepDOM=false] нужно ли оставлять DOM-ноды в документе
             * @param {jQuery} ctx корневая DOM-нода
             * @param {Boolean} [excludeSelf=false] не учитывать контекст
             */
            destruct : function(keepDOM, ctx, excludeSelf) {
        
                if(typeof keepDOM != 'boolean') {
                    excludeSelf = ctx;
                    ctx = keepDOM;
                    keepDOM = undefined;
                }
        
                findDomElem(ctx, '.i-bem', excludeSelf).each(function(i, domNode) {
                    var params = getParams(this);
                    $.each(params, function(blockName, blockParams) {
                        if(blockParams.uniqId) {
                            var block = uniqIdToBlock[blockParams.uniqId];
                            if(block) {
                                removeDomNodeFromBlock(block, domNode);
                                delete params[blockName];
                            }
                            else {
                                delete uniqIdToDomElems[blockParams.uniqId];
                            }
                        }
                    });
                    $.isEmptyObject(params) && cleanupDomNode(this);
                });
                keepDOM || (excludeSelf? ctx.empty() : ctx.remove());
        
            },
        
            /**
             * Заменяет фрагмент DOM-дерева внутри контекста, уничтожая старые блоки и инициализируя новые
             * @static
             * @protected
             * @param {jQuery} ctx корневая DOM-нода
             * @param {jQuery|String} content новый контент
             * @param {Function} [callback] обработчик, вызываемый после инициализации
             * @param {Object} [callbackCtx] контекст обработчика
             */
            update : function(ctx, content, callback, callbackCtx) {
        
                this.destruct(ctx, true);
                this.init(ctx.html(content), callback, callbackCtx);
        
            },
        
            /**
             * Добавляет фрагмент DOM-дерева в конец контекста и инициализирует блоки
             * @param {jQuery} ctx корневая DOM-нода
             * @param {jQuery|String} content добавляемый контент
             */
            append : function(ctx, content) {
        
                this.init($(content).appendTo(ctx));
        
            },
        
            /**
             * Добавляет фрагмент DOM-дерева в начало контекста и инициализирует блоки
             * @param {jQuery} ctx корневая DOM-нода
             * @param {jQuery|String} content добавляемый контент
             */
            prepend : function(ctx, content) {
        
                this.init($(content).prependTo(ctx));
        
            },
        
            /**
             * Добавляет фрагмент DOM-дерева перед контекстом и инициализирует блоки
             * @param {jQuery} ctx контекстная DOM-нода
             * @param {jQuery|String} content добавляемый контент
             */
            before : function(ctx, content) {
        
                this.init($(content).insertBefore(ctx));
        
            },
        
            /**
             * Добавляет фрагмент DOM-дерева после контекстом и инициализирует блоки
             * @param {jQuery} ctx контекстная DOM-нода
             * @param {jQuery|String} content добавляемый контент
             */
            after : function(ctx, content) {
        
                this.init($(content).insertAfter(ctx));
        
            },
        
            /**
             * Строит полное имя live-события
             * @static
             * @private
             * @param {String} e имя события
             * @returns {String}
             */
            _buildCtxEventName : function(e) {
        
                return this._name + ':' + e;
        
            },
        
            _liveClassBind : function(className, e, callback, invokeOnInit) {
        
                var _this = this;
                if(e.indexOf(' ') > -1) {
                    e.split(' ').forEach(function(e) {
                        _this._liveClassBind(className, e, callback, invokeOnInit);
                    });
                }
                else {
                    var storage = liveClassEventStorage[e],
                        uniqId = $.identify(callback);
        
                    if(!storage) {
                        storage = liveClassEventStorage[e] = {};
                        doc.bind(e, _this.changeThis(_this._liveClassTrigger, _this));
                    }
        
                    storage = storage[className] || (storage[className] = { uniqIds : {}, fns : [] });
        
                    if(!(uniqId in storage.uniqIds)) {
                        storage.fns.push({ uniqId : uniqId, fn : _this._buildLiveEventFn(callback, invokeOnInit) });
                        storage.uniqIds[uniqId] = storage.fns.length - 1;
                    }
                }
        
                return this;
        
            },
        
            _liveClassUnbind : function(className, e, callback) {
        
                var storage = liveClassEventStorage[e];
                if(storage) {
                    if(callback) {
                        if(storage = storage[className]) {
                            var uniqId = $.identify(callback);
                            if(uniqId in storage.uniqIds) {
                                var i = storage.uniqIds[uniqId],
                                    len = storage.fns.length - 1;
                                storage.fns.splice(i, 1);
                                while(i < len) storage.uniqIds[storage.fns[i++].uniqId] = i - 1;
                                delete storage.uniqIds[uniqId];
                            }
                        }
                    } else {
                        delete storage[className];
                    }
                }
        
                return this;
        
            },
        
            _liveClassTrigger : function(e) {
        
                var storage = liveClassEventStorage[e.type];
                if(storage) {
                    var node = e.target, classNames = [];
                    for(var className in storage) storage.hasOwnProperty(className) && classNames.push(className);
                    do {
                        var nodeClassName = ' ' + node.className + ' ', i = 0;
                        while(className = classNames[i++]) {
                            if(nodeClassName.indexOf(' ' + className + ' ') > -1) {
                                var j = 0, fns = storage[className].fns, fn;
                                while(fn = fns[j++]) fn.fn.call($(node), e);
                                if(e.isPropagationStopped()) return;
                                classNames.splice(--i, 1);
                            }
                        }
                    } while(classNames.length && (node = node.parentNode));
                }
        
            },
        
            _buildLiveEventFn : function(callback, invokeOnInit) {
        
                var _this = this;
                return function(e) {
                    var args = [
                            _this._name,
                            ((e.data || (e.data = {})).domElem = $(this)).closest(_this.buildSelector()),
                            true ],
                        block = initBlock.apply(null, invokeOnInit? args.concat([callback, e]) : args);
                    block && (invokeOnInit || (callback && callback.apply(block, arguments)));
                };
        
            },
        
            /**
             * Хелпер для live-инициализации по событию на DOM-элементах блока или его элементов
             * @static
             * @protected
             * @param {String} [elemName] имя элемента или элементов (через пробел)
             * @param {String} event имя события
             * @param {Function} [callback] обработчик, вызываемый после успешной инициализации
             */
            liveInitOnEvent : function(elemName, event, callback) {
        
                return this.liveBindTo(elemName, event, callback, true);
        
            },
        
            /**
             * Хелпер для подписки на live-события на DOM-элементах блока или его элементов
             * @static
             * @protected
             * @param {String|Object} [to] описание (объект с modName, modVal, elem) или имя элемента или элементов (через пробел)
             * @param {String} event имя события
             * @param {Function} [callback] обработчик
             */
            liveBindTo : function(to, event, callback, invokeOnInit) {
        
                if(!event || $.isFunction(event)) {
                    callback = event;
                    event = to;
                    to = undefined;
                }
        
                if(!to || typeof to == 'string') {
                    to = { elem : to };
                }
        
                to.elemName && (to.elem = to.elemName);
        
                var _this = this;
        
                if(to.elem && to.elem.indexOf(' ') > 1) {
                    to.elem.split(' ').forEach(function(elem) {
                        _this._liveClassBind(
                            buildClass(_this._name, elem, to.modName, to.modVal),
                            event,
                            callback,
                            invokeOnInit);
                    });
                    return _this;
                }
        
                return _this._liveClassBind(
                    buildClass(_this._name, to.elem, to.modName, to.modVal),
                    event,
                    callback,
                    invokeOnInit);
        
            },
        
            /**
             * Хелпер для отписки от live-событий на DOM-элементах блока или его элементов
             * @static
             * @protected
             * @param {String} [elem] имя элемента или элементов (через пробел)
             * @param {String} event имя события
             * @param {Function} [callback] обработчик
             */
            liveUnbindFrom : function(elem, event, callback) {
        
                var _this = this;
        
                if(elem.indexOf(' ') > 1) {
                    elem.split(' ').forEach(function(elem) {
                        _this._liveClassUnbind(
                            buildClass(_this._name, elem),
                            event,
                            callback);
                    });
                    return _this;
                }
        
                return _this._liveClassUnbind(
                    buildClass(_this._name, elem),
                    event,
                    callback);
        
            },
        
            /**
             * Хелпер для live-инициализации по инициализации другого блока
             * @static
             * @private
             * @param {String} event имя события
             * @param {String} blockName имя блока, на инициализацию которого нужно реагировать
             * @param {Function} callback обработчик, вызываемый после успешной инициализации в контексте нового блока
             * @param {String} findFnName имя метода для поиска
             */
            _liveInitOnBlockEvent : function(event, blockName, callback, findFnName) {
        
                var name = this._name;
                blocks[blockName].on(event, function(e) {
                    var args = arguments,
                        blocks = e.block[findFnName](name);
        
                    callback && blocks.forEach(function(block) {
                        callback.apply(block, args);
                    });
                });
                return this;
        
            },
        
            /**
             * Хелпер для live-инициализации по событию другого блока на DOM-элементе текущего
             * @static
             * @protected
             * @param {String} event имя события
             * @param {String} blockName имя блока, на инициализацию которого нужно реагировать
             * @param {Function} callback обработчик, вызываемый после успешной инициализации в контексте нового блока
             */
            liveInitOnBlockEvent : function(event, blockName, callback) {
        
                return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOn');
        
            },
        
            /**
             * Хелпер для live-инициализации по событию другого блока внутри текущего
             * @static
             * @protected
             * @param {String} event имя события
             * @param {String} blockName имя блока, на инициализацию которого нужно реагировать
             * @param {Function} [callback] обработчик, вызываемый после успешной инициализации в контексте нового блока
             */
            liveInitOnBlockInsideEvent : function(event, blockName, callback) {
        
                return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOutside');
        
            },
        
            /**
             * Хелпер для live-инициализации по инициализации другого блока на DOM-элементе текущего
             * @deprecated использовать liveInitOnBlockEvent
             * @static
             * @protected
             * @param {String} blockName имя блока, на инициализацию которого нужно реагировать
             * @param {Function} callback обработчик, вызываемый после успешной инициализации в контексте нового блока
             */
            liveInitOnBlockInit : function(blockName, callback) {
        
                return this.liveInitOnBlockEvent('init', blockName, callback);
        
            },
        
            /**
             * Хелпер для live-инициализации по инициализации другого блока внутри текущего
             * @deprecated использовать liveInitOnBlockInsideEvent
             * @static
             * @protected
             * @param {String} blockName имя блока, на инициализацию которого нужно реагировать
             * @param {Function} [callback] обработчик, вызываемый после успешной инициализации в контексте нового блока
             */
            liveInitOnBlockInsideInit : function(blockName, callback) {
        
                return this.liveInitOnBlockInsideEvent('init', blockName, callback);
        
            },
        
            /**
             * Добавляет обработчик live-события на блок, с учётом заданного элемента,
             * внутри которого будет слушаться событие
             * @static
             * @protected
             * @param {jQuery} [ctx] элемент, внутри которого будет слушаться событие
             * @param {String} e имя события
             * @param {Object} [data] дополнительные данные, приходящие в обработчик как e.data
             * @param {Function} fn обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            on : function(ctx, e, data, fn, fnCtx) {
        
                return ctx.jquery?
                    this._liveCtxBind(ctx, e, data, fn, fnCtx) :
                    this.__base(ctx, e, data, fn);
        
            },
        
            /**
             * Удаляет обработчик live-события у блока, с учётом заданного элемента,
             * внутри которого слушалось событие
             * @static
             * @protected
             * @param {jQuery} [ctx] элемент, внутри которого слушалось событие
             * @param {String} e имя события
             * @param {Function} [fn] обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            un : function(ctx, e, fn, fnCtx) {
        
                return ctx.jquery?
                    this._liveCtxUnbind(ctx, e, fn, fnCtx) :
                    this.__base(ctx, e, fn);
        
            },
        
            /**
             * Добавляет обработчик live-события на блок, с учётом заданного элемента,
             * внутри которого будет слушаться событие
             * @deprecated использовать on
             * @static
             * @protected
             * @param {jQuery} ctx элемент, внутри которого будет слушаться событие
             * @param {String} e имя события
             * @param {Object} [data] дополнительные данные, приходящие в обработчик как e.data
             * @param {Function} fn обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            liveCtxBind : function(ctx, e, data, fn, fnCtx) {
        
                return this._liveCtxBind(ctx, e, data, fn, fnCtx);
        
            },
        
            /**
             * Добавляет обработчик live-события на блок, с учётом заданного элемента,
             * внутри которого будет слушаться событие
             * @static
             * @private
             * @param {jQuery} ctx элемент, внутри которого будет слушаться событие
             * @param {String} e имя события
             * @param {Object} [data] дополнительные данные, приходящие в обработчик как e.data
             * @param {Function} fn обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            _liveCtxBind : function(ctx, e, data, fn, fnCtx) {
        
                var _this = this;
        
                if(typeof e == 'string') {
                    if($.isFunction(data)) {
                        fnCtx = fn;
                        fn = data;
                        data = undefined;
                    }
        
                    if(e.indexOf(' ') > -1) {
                        e.split(' ').forEach(function(e) {
                            _this._liveCtxBind(ctx, e, data, fn, fnCtx);
                        });
                    } else {
                        var ctxE = _this._buildCtxEventName(e),
                            storage = liveEventCtxStorage[ctxE] ||
                                (liveEventCtxStorage[ctxE] = { counter : 0, ctxs : {} });
        
                        ctx.each(function() {
                            var ctxId = $.identify(this),
                                ctxStorage = storage.ctxs[ctxId];
                            if(!ctxStorage) {
                                ctxStorage = storage.ctxs[ctxId] = {};
                                ++storage.counter;
                            }
                            ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')] = {
                                fn   : fn,
                                data : data,
                                ctx  : fnCtx
                            };
                        });
                    }
                } else {
                    $.each(e, function(e, fn) {
                        _this._liveCtxBind(ctx, e, fn, data);
                    });
                }
        
                return _this;
        
            },
        
            /**
             * Удаляет обработчик live-события у блока, с учётом заданного элемента,
             * внутри которого слушалось событие
             * @deprecated использовать un
             * @static
             * @protected
             * @param {jQuery} ctx элемент, внутри которого слушалось событие
             * @param {String} e имя события
             * @param {Function} [fn] обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            liveCtxUnbind : function(ctx, e, fn, fnCtx) {
        
                return this._liveCtxUnbind(ctx, e, fn, fnCtx);
        
            },
        
            /**
             * Удаляет обработчик live-события у блока, с учётом заданного элемента,
             * внутри которого слушалось событие
             * @static
             * @private
             * @param {jQuery} ctx элемент, внутри которого слушалось событие
             * @param {String} e имя события
             * @param {Function} [fn] обработчик
             * @param {Object} [fnCtx] контекст обработчика
             */
            _liveCtxUnbind : function(ctx, e, fn, fnCtx) {
        
                var _this = this,
                    storage = liveEventCtxStorage[e =_this._buildCtxEventName(e)];
        
                if(storage) {
                    ctx.each(function() {
                        var ctxId = $.identify(this, true),
                            ctxStorage;
                        if(ctxId && (ctxStorage = storage.ctxs[ctxId])) {
                            fn && delete ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')];
                            if(!fn || $.isEmptyObject(ctxStorage)) {
                                storage.counter--;
                                delete storage.ctxs[ctxId];
                            }
                        }
                    });
                    storage.counter || delete liveEventCtxStorage[e];
                }
        
                return _this;
        
            },
        
            /**
             * Извлекает имя вложенного в блок элемента
             * @static
             * @private
             * @param {jQuery} elem вложенный элемент
             * @returns {String|undefined}
             */
            _extractElemNameFrom : function(elem) {
        
                if(elem.__bemElemName) return elem.__bemElemName;
        
                var matches = elem[0].className.match(this._buildElemNameRE());
                return matches? matches[1] : undefined;
        
            },
        
            /**
             * Извлекает параметры блока из DOM-элемента
             * @static
             * @param {HTMLElement} domNode DOM-нода
             * @returns {Object}
             */
            extractParams : extractParams,
        
            /**
             * Строит префикс для CSS-класса DOM-элемента или вложенного элемента блока по имени модификатора
             * @static
             * @private
             * @param {String} modName имя модификатора
             * @param {jQuery|String} [elem] элемент
             * @returns {String}
             */
            _buildModClassPrefix : function(modName, elem) {
        
                return buildClass(this._name) +
                       (elem?
                           ELEM_DELIM + (typeof elem === 'string'? elem : this._extractElemNameFrom(elem)) :
                           '') +
                       MOD_DELIM + modName + MOD_DELIM;
        
            },
        
            /**
             * Строит регулярное выражение для извлечения значения модификатора из DOM-элемента или вложенного элемента блока
             * @static
             * @private
             * @param {String} modName имя модификатора
             * @param {jQuery|String} [elem] элемент
             * @param {String} [quantifiers] квантификаторы регулярного выражения
             * @returns {RegExp}
             */
            _buildModValRE : function(modName, elem, quantifiers) {
        
                return new RegExp('(\\s?)' + this._buildModClassPrefix(modName, elem) + '(' + NAME_PATTERN + ')(\\s|$)', quantifiers);
        
            },
        
            /**
             * Строит регулярное выражение для извлечения имени вложенного в блок элемента
             * @static
             * @private
             * @returns {RegExp}
             */
            _buildElemNameRE : function() {
        
                return new RegExp(this._name + ELEM_DELIM + '(' + NAME_PATTERN + ')(?:\\s|$)');
        
            },
        
            /**
             * Строит CSS-селектор, соответствующий блоку/элементу и модификатору
             * @param {String} [elem] имя элемент
             * @param {String} [modName] имя модификатора
             * @param {String} [modVal] значение модификатора
             * @returns {String}
             */
            buildSelector : function(elem, modName, modVal) {
        
                return '.' + buildClass(this._name, elem, modName, modVal);
        
            },
        
            /**
             * Возвращает инстанс блока по уникальному идентификатору
             * @deprecated
             * @param {String} [uniqId]
             * @returns {BEM.DOM}
             */
            getBlockByUniqId : function(uniqId) {
        
                return uniqIdToBlock[uniqId];
        
            },
        
            /**
             * Возвращает размер текущего окна
             * @returns {Object} объект с полями width, height
             */
            getWindowSize : function() {
        
                return {
                    width  : win.width(),
                    height : win.height()
                };
        
            }
        
        });
        
        })(BEM, jQuery);
    /* lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: begin */ /**/
        (function() {
        
        String.prototype.trim || (String.prototype.trim = function () {
        
            var str = this.replace(/^\s\s*/, ''),
                ws = /\s/,
                i = str.length;
        
            while(ws.test(str.charAt(--i)));
        
            return str.slice(0, i + 1);
        
        });
        
        })();
    /* lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: end */ /**/
    
    /* lego/blocks-common/i-global/i-global.js: begin */ /**/
        
        BEM.DOM.decl('i-global', {
        
            onSetMod : {
        
                'js' : function() {
        
                    // удаляем системные свойства
                    this.del(this.__self._params = $.extend({}, this.params), 'uniqId', 'name');
        
                    var params = this.__self._params;
        
                    params['passport-msg'] || (params['passport-msg'] = params.id);
        
                    params['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];
                    params.locale = params.lang;
        
                    $(function(){
                        params.oframebust && Lego.oframebust(params.oframebust);
                    });
        
                }
        
            },
        
            getDefaultParams : function() {
        
                return {
                    id : '',
                    login : Lego.isSessionValid() ? $.cookie('yandex_login') || '' : '',
                    yandexuid : $.cookie('yandexuid'),
                    lang : 'ru',
                    retpath : window.location.toString(),
                    'passport-host' : 'https://passport.yandex.ru',
                    'pass-host' : '//pass.yandex.ru',
                    'social-host' : '//social.yandex.ru',
                    'lego-path' : '/lego',
                    'show-counters-percent' : 100
                };
        
            }
        
        }, {
        
            param  : function(name) {
        
                return (this._params || {})[name];
        
            }
        
        });
    /* lego/blocks-common/i-global/i-global.js: end */ /**/
    
    /* lego/blocks-common/i-common/i-common.js: begin */ /**/
        (function(Lego){
        if (!Lego) Lego = window.Lego = {};
        
        Lego.messages = Lego.messages || {};
        
        Lego.message = function(id, text) {
            return Lego.params.locale == 'ru' ? text : (Lego.messages[id] || text);
        };
        
        })(window.Lego);
    /* lego/blocks-common/i-common/i-common.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: begin */ /**/
        /* дефолтная инициализация */
        $(function() {
            BEM.DOM.init();
        });
    /* lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: end */ /**/
    
    /* blocks-desktop/i-widget-helper/i-widget-helper.js: begin */ /**/
        (function() {
        
            (function() {
                var map = { '&': '&amp;', '  ': '&nbsp; ', '<': '&lt;', '>': '&gt;', '\n': '<br />', '\r\n': '<br />', '"': '&quot;' };
                var map2 = { '&amp;': '&', '&nbsp;': ' ', '&lt;': '<', '&gt;': '>', '<br />': '\n', '<br/>': '\n', '<br>': '\n', '&quot;': '"' };
                var funcReplace = function(str) { 
                    return map[str]; 
                };
                var funcReplace2 = function(str) { 
                    return map2[str.toLowerCase()]; 
                };
                /**
                 * Escape HTML spec chars
                 */
                String.prototype.toHTML = function() { 
                    return this.replace(/&|  |<|>|\r\n|\n|"|"/g, funcReplace); 
                };
                /**
                 * Unescape HTML spec chars
                 */
                String.prototype.fromHTML = function() { 
                    return this.replace(/&amp;|&nbsp;|&lt;|&gt;|<(br|BR)\s*\/?>|&quot;/g, funcReplace2); 
                };
            })();
            
            Function.empty = function(){};
            
            /**
             * Create callback, what not called until minTimeout timeout.
             * @param {Number} minTimeout minimum timeout, in ms.
             * @return {Function} callback.
             */
            Function.prototype.callbackDelay = function(minTimeout) {
                if (!minTimeout || (minTimeout < 1)) {
                    return this;
                }
                var endTime = (new Date()).valueOf() + minTimeout;
                var func = this;
                return function() {
                    var interval = endTime - (new Date()).valueOf();
                    var args = arguments, self = this;
                    if (interval > 0) {
                        setTimeout(function() {
                            func.apply(self, args);
                        }, interval);
                    } else {
                        func.apply(self, args);
                    }
                }
            };
        
            BEM.decl('i-widget-helper', {}, {
            
                _localStringPrefix: '',
                _initialized: false,
        
                /**
                 * Helper initialization.
                 */
                init: function(platform, localStringPrefix) {
                    if (this._initialized) {
                        return;
                    }
                    this._initialized = true;
                    this._platform = platform;
                    this._localStringPrefix = (localStringPrefix || '');
                    
                    var self = this;
                    this._helperPlatformListener = function(message) {
                        var topic = message.message || message;
                        var data = message.data || null;
                        self.fireEvent(topic, data);
                    };
                    
                    this._platform.onMessage.addListener(this._helperPlatformListener);
                    
                    jQuery.ajaxSetup({
                        crossDomain: false
                    });
                    
                    if (!this._enableContextMenu) {
                        document.oncontextmenu = function(e) { 
                            e = e || window.event;
                            var tag = (e.target || e.srcElement).tagName;
                            return ((tag === 'INPUT') || (tag === 'TEXTAREA'));
                        };
                        window.onerror = function(e, ur, ln) {
                            //=log('ERROR: ' + e + '  (' + ln + '  url=' + ur + ')');
                            return false;
                        };
        			}
                },
                
                branding: function(conf) {
                    if (!conf.current) {
                        conf.current = {};
                        var bran = (conf.branding || {})[this._platform.brandID];
                        $.extend(conf.current, conf.common || {}, bran || {});
                    }
                    return conf.current;
                },
                
                getScript: function(url, callback) {
                    this.ajax({
        	            type: 'GET',
        	            url: url,
        	            success: callback,
        	            dataType: 'script'
                    });
                },
                
                ajax: function(config, attemptsCount) {
                    attemptsCount = attemptsCount || 1;
                    
                    if ((config.dataType == 'script') || (config.dataType == 'jsonp')) {
                        config.crossDomain = true;
                    }
                    
                    function request() {
                        attemptsCount--;
                        $.ajax(config);
                    }
                    
                    if (attemptsCount > 1) {
                        var oldError = config.error || Function.empty;
                        config.error = function() {
                            if (attemptsCount) {
                                request();
                            } else {
                                oldError.apply(this, arguments);
                            }
                        }
                    }
                    
                    request();
                },
        
                /**
                 * Opens widget settings.
                 */
                openSettings: function() {
                    if (!window.closed) {
                        window.close();
                    }
                    this._platform.showSettings();
                },
                
                /**
                for IE (new Date('YYYY-MM-DD hh:mm:ss') not work in IE)
                */
                parseDate: function (str) {
                    if ((typeof str !== 'string') || !str) { 
                        return str;
                    }
                    var i, part = str.match(/\d+/g);
                    for(i = 0; i<part.length; ++i) { 
                        part[i] = parseInt(part[i], 10); 
                    }
                    return new Date(part[0], part[1]-1, part[2], part[3], part[4], part[5]);
                },
        
                /**
                 * Opens |url| in new tab.
                 * @param {String} url URL of page to open.
                 */
                openNewTab: function(url) {
                    this._platform.navigate(url, 'new tab');
                    window.close();
                },
                
                localStr: function(key) {
                    return this._platform.getLocalizedString(this._localStringPrefix + key) || '';
                },
                
                lang: function() {
                    return this._platform.language;
                },
                
                getParam: function(param, url) {
                    return (RegExp('[?&]' + param + '=([^&#]*)', 'i').exec(url || document.location.href)||'')[1]||'';
                },
                
                platformLocalization: function(mainBlock) {
                    if (mainBlock.platform_i18n) {
                        mainBlock.platform_i18n(this);
                    }
                    for(var bl in BEM.blocks) {
                        if (/^b-/.test(bl)) {
                            var blocks = mainBlock.findBlocksInside(bl);
                            if (blocks) {
                                for (var i=0; i<blocks.length; ++i) {
                                    if (blocks[i].platform_i18n) {
                                        blocks[i].platform_i18n(this, i);
                                    }
                                }
                            }
                        }
                    }
                },
                
                
        
                /**
                 * Logs user's actions.
                 * @param {Number} actionCode Any of this.Action.*
                 */
                logAction: function(actionCode) {
                    this._platform.logCustomAction(actionCode);
                },
                
                _helperPlatformListener: null,
                _pltfListeners: {},
                _removePlatformListener: function() {
                    if (this._helperPlatformListener) {
                        this._platform.onMessage.removeListener(this._helperPlatformListener);
                        this._helperPlatformListener = null;
                    }
                },
                
                reloadSlice: function() {
                    this._removePlatformListener();
                    window.location.reload(true);
        		},
                removeListener: function(topic, callback) {
                    if (!this._pltfListeners[topic]) {
                        return;
                    }
                    if (!callback) {
                        this._pltfListeners[topic] = null;
                    } else {
                        var listeners = this._pltfListeners[topic];
                        for (var i=0; i<listeners.length; ++i) {
                            if (listeners[i].func == callback) {
                                listeners.splice(i, 1);
                                --i;
                            }
                        }
                    }
                },
                addListener: function(topic, callback, scope) {
                    this._pltfListeners[topic] = this._pltfListeners[topic] || [];
                    this._pltfListeners[topic].push({func: callback, scope: scope});
                    return this;
                },
                fireEvent: function(topic, data) {
                    var listeners = this._pltfListeners[topic];
                    if (listeners) {
                        for (var i=0; i<listeners.length; ++i) {
                            var ret = listeners[i].func.call(listeners[i].scope || window, topic, data);
                            if (ret === false) {
                                break;
                            }
                        }
                    }
                }
                
            });
        })();
    /* blocks-desktop/i-widget-helper/i-widget-helper.js: end */ /**/
    
    /* blocks-desktop/i-widget-traffic/i-widget-traffic.js: begin */ /**/
        (function($) {
            BEM.decl('i-widget-traffic', {}, {
                _mapConfigFromExport: null,
                _trafficInfo: null,
                _trafficAlert: null,
            
                /**
                 * Widget initialization.
                 */
                init: function() {
                    this._helper = BEM.blocks['i-widget-helper'];
                    this.utils = BEM.blocks['i-widget-traffic__utils'];
                    this.storage = BEM.blocks['i-widget-traffic__storage'];
                    this._configs = BEM.blocks['i-widget-traffic__config'];
                    
                    if (window.parent && window.parent.__debug_Tools_) { window.parent.__debug_Tools_(this, window); }
                    
                    var platform = window.platform;
                    
                    this._platform = platform;
                    this._helper.init(platform, 'slice.traffic.');
                    
                    this.config = this._helper.branding(this._configs);
                    
                    //=log('brid=' + platform.brandID + ',  exp = ' + this.config.EXPORT_URL);
                    
                    this.utils.init(platform, this);
                    this.storage.init(platform, this);
                    
                    var sz = this.config.windowSize;
                    platform.resizeWindowTo(sz[0], sz[1]);
                    
                    
                },
                
                update: function(callback, errback) {
                    var self = this;
                    //=log('update,  url = ' + this.config.EXPORT_URL);
                    $.ajax({
                        url: this.config.EXPORT_URL,
                        data: {
                            region: this._helper.getParam('region'),
                            lang: this._platform.language,
                            brid: this._platform.brandID
                        },
                        dataType: 'xml',
                        success: function(data) {
                            self._updateHandler(data, callback);
                        },
                        error: function() {
                            (errback || Function.empty).apply(window, arguments);
                        }
                    });
                },
                
                _updateHandler: function(xml, callback) {
                    var regionNode = $('info>region', xml),
                        trafficNode = $('info>traffic', xml),
                        levelNode = trafficNode.children('level'),
                        trafficAlert = $('info>traffic-alert', xml);
                        
                    var mconf = this._mapConfigFromExport;
                    
                    if (!mconf) {
                        mconf = {
                            region: {
                                title: regionNode.children('title').text(),
                                id: regionNode.attr('id') || this._helper.getParam('region'),
                                zoom: parseInt(regionNode.attr('zoom'), 10),
                                lat: regionNode.attr('lat'),
                                lon: regionNode.attr('lon')
                            },
                            traffic: null
                        };
                        this._mapConfigFromExport = mconf;
                        mconf.region.center = [parseFloat(mconf.region.lat), parseFloat(mconf.region.lon)];
                        
                        this.storage.setRegion(mconf.region.title);
        
                        if (levelNode.length) {
                            mconf.traffic = {
                                title: trafficNode.children('title').text(),
                                id: trafficNode.attr('region'),
                                zoom: parseInt(trafficNode.attr('zoom'), 10),
                                lat: trafficNode.attr('lat'),
                                lon: trafficNode.attr('lon')
                            };
                            mconf.traffic.center = [parseFloat(mconf.traffic.lat), parseFloat(mconf.traffic.lon)];
                        }
                    }
        
                    if (levelNode.length) {
                        this._trafficInfo = {
                            balls: trafficNode.children('level').text(),
                            ballsText: trafficNode.children('hint[lang="' + platform.language + '"]').text(),
                            icon: trafficNode.children('icon').text(),
                            time: (new Date()).valueOf()
                        };
                        if (mconf.traffic && (mconf.traffic.title != mconf.region.title)) {
                            this._trafficInfo.city = mconf.traffic.title;
                        }
                    } else {
                        this._trafficInfo = {
                            error: 'notraffic'
                        };
                    }
                    
                    if (trafficAlert.length && trafficAlert.attr('text')) {
                        this._trafficAlert = {
                            text: trafficAlert.attr('text'),
                            start: parseInt(trafficAlert.attr('start-time'))*1000,
                            end: parseInt(trafficAlert.attr('end-time'))*1000
                        };
                    } else {
                        this._trafficAlert = null;
                    }
                    
                    this.storage.saveTrafficData(this._trafficInfo);
                    
                    callback();
                },
                
                getMapConfig: function() {
                    return this._mapConfigFromExport;
                },
                getTrafficInfo: function() {
                    return this._trafficInfo;
                },
                getTrafficAlert: function() {
                    if (this._trafficAlert) {
                        if (this._trafficAlert.end >= (new Date()).valueOf()) {
                            return this._trafficAlert.text;
                        }
                    }
                    return '';
                }
            });
        })(jQuery);
    /* blocks-desktop/i-widget-traffic/i-widget-traffic.js: end */ /**/
    
    /* blocks-desktop/i-widget-traffic/__utils/i-widget-traffic__utils.js: begin */ /**/
        (function($) {
            BEM.decl('i-widget-traffic__utils', {}, {
            
                helper: null,
            
                /**
                 * Utils initialization.
                 */
                init: function(platform, widget) {
                    this._platform = platform;
                    this.helper = BEM.blocks['i-widget-helper'];
                    this._widget = widget;
                },
                
                getLang: function(allowLangs) {
                    var lang = this.helper.lang();
                    if (!allowLangs || !allowLangs.length) {
                        return lang;
                    }
                    if (typeof allowLangs == 'string') {
                        allowLangs = [allowLangs];
                    }
                    for (var i=0; i<allowLangs.length; ++i) {
                        if (allowLangs[i] == lang) {
                            return lang;
                        }
                    }
                    return allowLangs[0];
                },
                
                //get
                
                distance: function(a, b, zoom) {
        			var len = Math.sqrt((a[0]-b[0])*(a[0]-b[0]) + (a[1]-b[1])*(a[1]-b[1])*Math.cos(b[0]*Math.PI/180));
        			while (zoom < 10) {
        				len = len/2;
        				zoom++;
        			}
        			while (zoom > 10) {
        				len = len*2;
        				zoom--;
        			}
        			return len;
        		},
        		
        		getJam: function(rTime, jamsTime, routeLength) {
                    var k = 1,
                    route_km = routeLength / 1000;
        
                    if (routeLength < 500) {
                        k = 0.5; 
                    } else if (route_km < 1) {
                        k = 0.75;
                    } else if (route_km >= 15 && route_km < 80) {
                        k = (1/65) * (route_km - 15) + 1;
                    } else if (route_km >= 80) {
                        k = 2;
                    }
        
                    var index = k * (jamsTime / rTime - 1) * 100,
                        c = -1;
        
                    if (index >= 0) { c = 0 };
                    if (index > 10) { c = 1 };
                    if (index > 25) { c = 2 };
                    if (index > 40) { c = 3 };
                    if (index > 60) { c = 4 };
                    if (index > 85) { c = 5 };
                    if (index > 115) { c = 6 };
                    if (index > 155) { c = 7 };
                    if (index > 195) { c = 8 };
                    if (index > 240) { c = 9 };
                    if (index > 290) { c = 10 };
        
                    return c;
                },
        		
        		
        		getLL: function () {
        			var cook = this._platform.getCookie('http://' + this._widget.config.COOKIE_DOMAIN, 'ys', false);
        			if (cook && /gpauto\.(-?\d*_\d*)(%3[Aa]|:)(-?\d*_\d*)[%:]/.test(cook)) {
        				var lat = RegExp.$1, lon = RegExp.$3;
        				lat = lat.replace('_', '.');
        				lon = lon.replace('_', '.');
        				return {latitude: parseFloat(lat), longitude: parseFloat(lon)};
        			}
        			return ymaps.geolocation;
        		},
        		isRouteRevertByTime: function() {
        			var dt = new Date();
        			var h = dt.getHours();
        			return !((h >= 3) && (h < 16));
        		},
        		format: function(key) {
        			var arg = arguments;
        			return this.helper.localStr(key).replace(/\{([1-9])\}/g, function(a,b) { return arg[b]; });
        		},
        		getBallStr: function (ball) {
        			ball = parseInt(ball, 10);
        			if(ball === 1) {
        				return this.helper.localStr('balls1');
        			} else {
        				return this.helper.localStr((ball > 1) && (ball < 5) ? 'balls234' : 'balls');
        			}
        		},
        		getTimeStr: function (sec) {
        			var m = Math.round(sec / 60);
        			var h = Math.floor(m / 60 + 0.001);
        			var hstr = h ? (h + ' ' + this.helper.localStr('time.h') + ' ') : '';
        			m = Math.round(m-h*60);
        			return hstr + (m ? m + ' ' + this.helper.localStr('time.m') : '');
        		},
        		lpad: function (num, len) {
        			num = num.toString();
        			while (num.length < len) {
        				num = '0' + num;
        			}
        			return num;
        		},
        		getTimePointStr: function(time) {
        			var dt = new Date(parseInt(time,10));
        			return this.lpad(dt.getHours()) + ':' + this.lpad(dt.getMinutes());
        		}
            });
        })(jQuery);
    /* blocks-desktop/i-widget-traffic/__utils/i-widget-traffic__utils.js: end */ /**/
    
    /* blocks-desktop/i-widget-traffic/__config/i-widget-traffic__config.js: begin */ /**/
        (function() {
            BEM.decl('i-widget-traffic__config', {}, {
                current: null,
                common: {
                    EXPORT_URL: 'http://export.yandex.ru/bar/reginfo.xml',
                    MAP_API_URL: 'http://api-maps.yandex.ru/2.0/?load=package.full&lang=',
                    SUGGEST_URL: 'http://suggest-maps.yandex.ru/suggest-geo',
                    SUGGEST_LANGS: ['ru', 'uk', 'be'],
                    MAP_URL: 'http://maps.yandex.ru/',
                    COOKIE_DOMAIN: 'yandex.ru',
                    API_LANGS: ['ru', 'uk', 'be'],
                    ENG_YA_SYMBOL: {en: true, tr: true, cs: true},
                    YA_SYMBOL_PATH_RU: 'http://yandex.st/lego/_/7CK9GSbMtRufcc7Wro_z41OvFoI.png',
                    YA_SYMBOL_PATH_EN: 'http://yandex.st/lego/_/0C5hXMbglXhq_iSYkvTTLXa60jM.png',
                    windowSize: [480, 560]
                },
                branding: {
                    tb: {
                        COOKIE_DOMAIN: 'yandex.com.tr',
                        EXPORT_URL: 'http://export.yandex.com.tr/bar/reginfo.xml',
                        MAP_API_URL: 'http://api-maps.yandex.ru/2.0/?load=package.full&lang=',
                        SUGGEST_URL: 'http://suggest-maps.yandex.com.tr/suggest-geo',
                        SUGGEST_LANGS: ['tr', 'en'],
                        MAP_URL: 'http://harita.yandex.com.tr/',
                        API_LANGS: ['tr', 'en']
                    }
                }
            });
        })();
    /* blocks-desktop/i-widget-traffic/__config/i-widget-traffic__config.js: end */ /**/
    
    /* blocks-desktop/i-widget-traffic/__storage/i-widget-traffic__storage.js: begin */ /**/
        (function($) {
            BEM.decl('i-widget-traffic__storage', {}, {
            
                init: function(platform) {
                    this._platform = platform;
                    this._helper = BEM.blocks['i-widget-helper'];
                    this._widget = BEM.blocks['i-widget-traffic'];
                },
                
                setRegion: function(region) {
                    this._region = (region||'').toUpperCase();
                },
            
                loadTrafficData: function () {
                    var str = this._platform.getOption('old-balls') || '';
                    if (!str) {
                        return null;
                    }
                    str = str.split('||');
                    var time = parseInt(str[1], 10), currTime = (new Date()).valueOf();
                    if (currTime - time > 3600000) {
                        return null;
                    }
                    return {
                        balls: str[0],
                        time: time,
                        ballsText: str[2]
                    };
                },
                saveTrafficData: function (data) {
                    var str = (data && !data.error) ? (data.balls + '||' + data.time + '||' + data.ballsText) : '';
                    this._platform.setOption('old-balls', str);
                },
                
                _symb: '^#',
                _getRoutes: function(fromSave) {
                    var noData = {index:0, home: [''], work: ['']};
                
                    var s1 = this._platform.getOption('route-home');
                    if (!s1) { return noData; }
                    var s2 = this._platform.getOption('route-work');
                    if (!s2) { return noData; }
                    
                    var symb = this._symb;
                    var region = this._region;
                    if (s1.indexOf(symb) != 0) {
                        // старый формат, приписываем маршрут к текущему городу
                        s1 = symb + region + '||' + s1;
                        s2 = symb + region + '||' + s2;
                        if (!fromSave) {
                            this._platform.setOption('route-home', s1);
                            this._platform.setOption('route-work', s2);
                        }
                    }
                    
                    s1 = s1.split(symb);
                    s2 = s2.split(symb);
                    
                    var routeIndex = 0;
                    for (var i=1; i<s1.length; ++i) {
                        if (s1[i].substr(0, s1[i].indexOf('||')) == region) {
                            routeIndex = i;
                        }
                    }
                    
                    return {
                        index: routeIndex,
                        home: s1,
                        work: s2
                    };
                },
                loadRouteData: function (bTest) {
                    function numbers(str) {
                        str = str.split('|');
                        if (str[0] != 'N') {
                            str[0] = parseFloat(str[0]);
                            str[1] = parseFloat(str[1]);
                            return str;
                        } else {
                            return null;
                        }
                    }
                    
                    var routes = this._getRoutes(false);
                    
                    if (bTest || !routes.index) {
                        return !!routes.index||null;
                    }
                    
                    var home = routes.home[routes.index],
                        work = routes.work[routes.index];
                    
                    home = home.substr(home.indexOf('||') + 2);
                    work = work.substr(work.indexOf('||') + 2);
                    
                    var fi1 = home.indexOf('||');
                    var fi2 = work.indexOf('||');
                    return {
                        revert: this._widget.utils.isRouteRevertByTime(),
                        home: home.substr(fi1 + 2),
                        work: work.substr(fi2 + 2),
                        homePoint: (fi1 > 0) ? numbers(home.substr(0, fi1)) : null,
                        workPoint: (fi2 > 0) ? numbers(work.substr(0, fi2)) : null
                    };
                },
                saveRouteData: function (data) {
                    var arr = ['N', 'N'];
                    
                    var region = this._region;
                    
                    var routes = this._getRoutes(true);
                    
                    if (routes.index) {
                        routes.home.splice(routes.index, 1);
                        routes.work.splice(routes.index, 1);
                    }
                    
                    if (data) {
                        if (routes.home.length >= 5) {
                            routes.home.splice(1, 1);
                            routes.work.splice(1, 1);
                        }
                        routes.home.push(region + '||' + (data.homePoint||arr).join('|') + '||' + data.home);
                        routes.work.push(region + '||' + (data.workPoint||arr).join('|') + '||' + data.work);
                    }
                    
                    if (routes.index || data) {
                        this._platform.setOption('route-home', routes.home.join(this._symb));
                        this._platform.setOption('route-work', routes.work.join(this._symb));
                    }
                }
            });
        })(jQuery);
    /* blocks-desktop/i-widget-traffic/__storage/i-widget-traffic__storage.js: end */ /**/
    
    /* blocks-desktop/b-traffic/b-traffic.js: begin */ /**/
        (function($) {
            BEM.DOM.decl('b-traffic', {
                onSetMod: {
                    js: function() {
                        if (this._initialized) {
                            return;
                        }
                        this._initialized = true;
                        var self = this;
                        var loadListener = function() {
                            $(window).unbind('load', loadListener);
                            self.__init();
                        };
                        $(window).bind('load', loadListener);
                    }
                },
                
                _updating: false,
                
                __init: function() {
                    this._helper = BEM.blocks['i-widget-helper'];
                    this._widget = BEM.blocks['i-widget-traffic'];
                    
                    this._map = this.findBlockInside('b-traffic-map');
                    this._settings = this.findBlockInside('b-traffic-settings');
                    this._notify = this.findBlockInside('b-traffic-notify');
                    
                    var infoBlocks = this.findBlocksInside('b-traffic-info');
                    this._ballsInfo = infoBlocks[0];
                    this._routeInfo = infoBlocks[1];
                    
                    
                    this._widget.init();
                    
                    
                    
                    this._settings.init(this);
                    
                    this._helper.platformLocalization(this);
                    
                    this._helper.addListener('update', function() {
                        if (this._map.isApiErrorState()) {
                            this._helper.reloadSlice();
                            return;
                        }
                        this.update();
                    }, this);
                    
                    this._helper.addListener('traffic-before-popup', function() {
                        if (this._map.isApiErrorState()) {
                            this._helper.reloadSlice();
                            return false;
                        }
                        var stp = this.getMod('type');
                        if (stp == 'error') {
                            this.update();
                        }
                    }, this);
                    
                    this._helper.addListener('map.apierror', function() {
                        this.setSliceType('map-error');
                    }, this);
                    
                    this._helper.addListener('map.route', function(topic, data) {
                        this._routeInfo.showRouteInfo(data.route, data.revert);
                        this.setSliceType('route-view');
                        if (data.isNewRoute) {
        				    this._widget.storage.saveRouteData(data.data);
                        }
                    }, this);
                    
                    this._helper.addListener('map.create', this.updateSliceType, this);
                    
                    this._helper.addListener('get.zoomCtrlTop', function() {
                        var top = this.elem('topmarker').offset().top - this._map.domElem.offset().top;
                        this._helper.fireEvent('put.zoomCtrlTop', top);
                    }, this);
                    
                    //=log('init');
                    
                    this.update();
                    this._map.init();
                    
                    this._addButtonHandlers();
                },
                
                platform_i18n: function(helper) {
                    var dtdMap = { 'new': 'set.points', 'route': 'my.route', 'bigmap': 'link.map' };
                    var self = this;
                    this.elem('btn').each(function() {
                        var elem = $(this);
                        elem.find('.b-form-button__text').text(helper.localStr(dtdMap[self.getMod(elem, 'type')]));
                    });
                },
                
                _addButtonHandlers: function() {
                    var handlers = {
                        'new': function() {
                            this.setSliceType('form');
        			        this._helper.logAction(2);
                        },
                        'route': function() {
                            this.setSliceType('form');
        			        this._helper.logAction(2);
        			        this._settings.setRouteInfo(this._widget.storage.loadRouteData());
                        },
                        'bigmap': function() {
                            this._helper.logAction(5);
        			        this._helper.openNewTab(this._map.getMapUrl());
                        }
                    };
                    
                    var self = this;
                    this.elem('btn').each(function() {
                        var elem = $(this);
                        var action = handlers[self.getMod(elem, 'type')];
                        elem.children('a:first').click(function(e) {
                            action.call(self);
                            e.preventDefault();
                            return false;
                        });
                    });
                },
                
                update: function() {
                    if (this._updating) {
                        return;
                    }
                    this._updating = true;
                    
                    var stp = this.getMod('type');
                    if (stp == 'error') {
                        this.setSliceType('loading');
                    }
                    
                    var self = this;
                    this._widget.update(
                        function() {
                            self._updating = false;
                            self._updateHandler();
                        },
                        function() {
                            self._updating = false;
                            self.setSliceType('error', 'net');
                        });
                },
                
                _updateHandler: function() {
                    var traff = this._widget.getTrafficInfo();
                    this._ballsInfo.showJamsInfo(traff);
                    this._notify.setText(this._widget.getTrafficAlert());
                    
                    this._map.createMap();
                    this._map.setLoadTimer();
                    this.updateSliceType();
                },
                updateSliceType: function() {
                    var sliceType;
                    if (this._map.isApiErrorState()) {
                        sliceType = 'map-error';
                    } else {
                        if (!this._map.isApiReadyState()) {
                            sliceType = 'map-loading';
                        } else {
                            if (this._map.getRoute()) {
                                sliceType = 'route-view';
                            } else {
                                sliceType = (this._widget.storage.loadRouteData(true) ? 'route' : 'new');
                            }
                        }
                    }
                    this.setSliceType(sliceType);
                },
                
                setSliceType: function(type, opt_error) {
                    var ctype = this.getMod('type');
                    
                    if (type == ctype) {
                        return;
                    }
                    var errMap = (type == 'map-error');
                    if (errMap && (ctype == 'error')) {
                        return;
                    }
                    
                    this.setMod('type', type);
                    
                    if(/error$/.test(type)) {
                        this._map.setErrorText(this._helper.localStr('error.' + (errMap ? 'map' : opt_error)));
                        
                        if (!errMap) {
                            /* last traffic data */
                            var data = this._widget.storage.loadTrafficData();
                            this._ballsInfo.showJamsInfo(data, opt_error);
                        }
                        
                    } else {
                        this._helper.fireEvent('get.zoomCtrlTop');
                        if (type == 'form') {
                            this._settings.onShow();
                            
                        }
                    }
                }
            }, {
            /*
                live: function() {
                    this.liveBindTo('btn', 'leftclick', function(e) {
                        e.preventDefault();
                        alert(this.className);
                       //this._handleClick(e);
                    });
                }
            */
            });
        })(jQuery);
    /* blocks-desktop/b-traffic/b-traffic.js: end */ /**/
    
    /* blocks-desktop/b-traffic-info/b-traffic-info.js: begin */ /**/
        (function($) {
            BEM.DOM.decl('b-traffic-info', {
            
                showJamsInfo: function(data, error) {
                    var helper = BEM.blocks['i-widget-helper'];
                    var widget = BEM.blocks['i-widget-traffic'];
                    
                    if (error) {
                        error = 'error.' + error;
                        //data = null;
                    } else {
                        if (data && data.error) {
                            error = data.error;
                            data = null;
                        }
                    }
                    
                    if (data) {
                        this.setMod(this.elem('icon'), 'type', data.icon);
                        this.elem('ball').text(data.balls + ' ' + widget.utils.getBallStr(data.balls));
                        this.elem('error').text(error ? ' - ' + widget.utils.format('last.resp', widget.utils.getTimePointStr(data.time)) : '');
                        this.elem('city').text(!error && data.city ? ' (' + data.city + ')' : '');
                        this.elem('text').text(data.ballsText);
                    } else {
                        this.delMod(this.elem('icon'), 'type');
                        this.elem('ball').html('&nbsp;');
                        this.elem('error').empty();
                        this.elem('city').empty();
                        this.elem('text').text(helper.localStr(error));
                    }
                    
                },
                
                
                
                showRouteInfo: function(route, revert) {
                    var helper = BEM.blocks['i-widget-helper'];
                    var widget = BEM.blocks['i-widget-traffic'];
                    var utils = widget.utils;
                    
                
                    var time = route.getTime();
                    var jamsTime = route.getJamsTime();
                    var len = route.getLength();
        
                    var minProblemTime = 1200; // sec
                    var minSpeed = 0.28; // 0.28 m/s ~ 1 km/h
        
                    var ball = utils.getJam(time, jamsTime, len);
                    var color = (ball >= 7) ? 'red' : (ball >= 4 ? 'yellow' : 'green');
        
                    this.setMod(this.elem('icon'), 'type', color);
        
                    var routeText = '<b>' + ball + ' ' + utils.getBallStr(ball) + '</b>&nbsp;-&nbsp;';
        
                    if ((jamsTime > minProblemTime) && (jamsTime * minSpeed > len)) {
                        routeText += helper.localStr('error.longroute');
                    } else {
                        routeText += utils.format((revert ? 'to.home' : 'to.work'), '<b>' + utils.getTimeStr(jamsTime) + '</b>')
                    }
        
                    this.elem('text').html(routeText);
                }
            }, {
            });
        })(jQuery);
    /* blocks-desktop/b-traffic-info/b-traffic-info.js: end */ /**/
    
    /* blocks-desktop/b-traffic-notify/b-traffic-notify.js: begin */ /**/
        (function($) {
            BEM.DOM.decl('b-traffic-notify', {
                setText: function(str) {
                    this.elem('text').text(str);
                    this.domElem.css('display', (str ? 'block' : 'none'));
                }
            }, {
            });
        })(jQuery);
    /* blocks-desktop/b-traffic-notify/b-traffic-notify.js: end */ /**/
    
    /* blocks-desktop/b-traffic-settings/b-traffic-settings.js: begin */ /**/
        (function($) {
            BEM.DOM.decl('b-traffic-settings', {
            
                init: function(parent) {
                    this._helper = BEM.blocks['i-widget-helper'];
                    this._widget = BEM.blocks['i-widget-traffic'];
                    this._map = parent._map;
                    this._parent = parent;
                    this._helper.addListener('map.routeerror', function(topic, saveRoute) {
                        if (saveRoute) {
        				    this.showErrorMsg(true);
        			    }
                    }, this);
                    this._helper.addListener('map.route', function(topic, data) {
                        this._btnRemove.setMod('disabled', 'no');
                        if (data.isNewRoute) {
                            this._setText(this._textboxHome, data.data.home);
        		            this._setText(this._textboxWork, data.data.home);
                        }
                    }, this);
                    
                    this.showErrorMsg(false);
                    
                    this._suggestLang = this._widget.utils.getLang(this._widget.config.SUGGEST_LANGS);
                    
                    this._addControlHandlers();
                },
                
                _addControlHandlers: function() {
                    var i, blocks = this.findBlocksInside('b-form-button');
                    for (i=0; i<blocks.length; ++i) {
                        if (blocks[i].getMod('type') == 'create') {
                            this._btnCreate = blocks[i];
                        } else {
                            this._btnRemove = blocks[i];
                        }
                    }
                    blocks = this.findBlocksInside('b-form-input');
                    for (i=0; i<blocks.length; ++i) {
                        if (blocks[i].getMod('type') == 'home') {
                            this._textboxHome = blocks[i];
                            this._textboxHome.elem('input').data('type', 'home');
                        } else {
                            this._textboxWork = blocks[i];
                            this._textboxWork.elem('input').data('type', 'work');
                        }
                    }
                    
                    var self = this;
                    var utils = this._widget.utils;
                    
                    function makeRoute(tp) {
        			    var data = {
        				    home: self._getText(self._textboxHome),
        				    work: self._getText(self._textboxWork),
        				    revert: utils.isRouteRevertByTime()
        			    };
        			    if(!data.home && !data.work) {
        				    return;
        			    }
        			    if(!data.work) {
        				    if (tp == 'homeenter') {
        					    self._textboxWork.elem('input').focus();
        				    }
        				    return;
        			    }
        			    if(!data.home) {
        				    if (tp == 'workenter') {
        					    self._textboxHome.elem('input').focus();
        				    }
        				    return;
        			    }
        			    if(data.home == data.work) {
        				    if (tp == 'homeenter') {
        					    self._textboxWork.elem('input').focus();
        				    }
        				    if (tp == 'workenter') {
        					    self._textboxHome.elem('input').focus();
        				    }
        				    return;
        			    }
        			    if (!tp) {
        			        self._helper.logAction(3);
        			    }
        			    self._map.makeMyRoute(data, true);
        		    }
                    this._btnCreate.domElem.click(function() {
                        makeRoute();
                        return false;
                    });
                    
                    this._btnRemove.domElem.click(function() {
                        if (!self._widget.storage.loadRouteData(true)) {
                            return false;
                        }
                        self._setText(self._textboxHome, '');
        		        self._setText(self._textboxWork, '');
        		        self._btnRemove.setMod('disabled', 'yes');
        		        self._textboxHome.elem('input').focus();
        		        self._widget.storage.saveRouteData(null);
        			    self._map.deleteRoute();
        		        return false;
                    });
                    
                    self._setText(self._textboxHome, '');
        		    self._setText(self._textboxWork, '');
        		    
        		    var routeErrMsg = $('#id_routeErrorMsg');
        		
        		    function edKeyEvent(e) {
        			    e = e || window.event;
        			    if (e.stopPropagation) {
        				    e.stopPropagation();
        			    } else {
        				    e.cancelBubble = true;
        			    }
        			    if ((e.type == 'keydown') && (e.keyCode == 13)) {
        				    $(this).autocomplete("close");
        				    this.blur();
        				    makeRoute(this.id == 'id_home' ? 'homeenter' : 'workenter');
        			    }
        		    }
        		
        		    var lastMDInput = null;
        		    var lastFocused = null;
        		    function sel(inp) {
        			    try {
        				    if (inp.createTextRange) {
        					    var r = inp.createTextRange();
        					    //r.collapse(true);
        					    r.select();
        					    return;
        				    }
        				    if (inp.setSelectionRange) {
        					    inp.setSelectionRange(0, inp.value.length);
        				    }
        			    } catch(ex) {}
        		    }
        		    //*
        		    function tbEvents(textBox) { 
        		    
        		        var elem = textBox.elem('input').bind('focus', function() {
        			        if(textBox.getMod(elem, 'showhint') == 'yes') {
        				        elem.val('');
        				        textBox.delMod(elem, 'showhint');
        			        }
        			        self.showErrorMsg(false);
        			        if (lastMDInput && this.value) {
        				        lastFocused = this;
        			        }
        			        lastMDInput = null;
        			
        			        if (this.value && this.value.length) {
        				        sel(this);
        				        lastFocused = this;
        			        } else {
        				        lastFocused = null;
        			        }
        			
        		        }).bind('blur', function() {
        			        var th = $(this);
        			        if(!elem.val()) {
        			            self._setText(textBox, '');
        			        }
        		        }).bind('keydown', edKeyEvent).bind('keyup', edKeyEvent)
        		        .bind('mousedown', function() {
        			        lastMDInput = this;
        		        })
        		        .bind('mouseup', function() {
        			        lastMDInput = null;
        			        return !lastFocused;
        		        })
        		        .click(function() {
        			        var ret = !lastFocused;
        			        lastFocused = null;
        			        lastMDInput = null;
        			        return ret;
        		        });
        		        self._autocomplete(elem);
        		    }
        		    tbEvents(this._textboxHome);
        		    tbEvents(this._textboxWork);
                },
                
                platform_i18n: function(helper) {
                    this.elem('error').text(helper.localStr('error.route'));
                    this._btnCreate.elem('text').text(helper.localStr('make.route'));
                    this._btnRemove.elem('text').text(helper.localStr('remove.route'));
                    this.elem('title').text(helper.localStr('my.route'));
                    this._textboxHome.elem('label').text(helper.localStr('home'));
                    this._textboxWork.elem('label').text(helper.localStr('work'));
                },
                showErrorMsg: function(show) {
                    this.elem('error').css('display', (show !== false) ? '' : 'none');
                    this._helper.fireEvent('get.zoomCtrlTop');
                },
                onShow: function() {
                    this.showErrorMsg(false);
                    this._textboxHome.elem('input').focus();
                    this._btnRemove.setMod('disabled', this._widget.storage.loadRouteData(true) ? 'no' : 'yes');
                },
                _autocomplete: function (elem) {
        			function itemClick() {
        				elem.val(this.__data);
        				elem.autocomplete("close");
        			}
        			var self = this;
        			elem.autocomplete({
        				minLength: 2,
        				source: function( request, response ) {
        					var cen = self._map.getCenter();
        					self._helper.ajax({
        						url: self._widget.config.SUGGEST_URL,
        						dataType: "jsonp",
        						data: {
        							lang: self._suggestLang,
        							ll: cen[1] + ',' + cen[0],
        							spn: self._map.getSPN(),
        							highlight: 1,
        							fullpath: 1,
        							v: 3,
        							yu: self._widget._platform.getCookie('http://' + self._widget.config.COOKIE_DOMAIN, 'yandexuid', false),
        							search_type: 'tp',
        							part: request.term
        						},
        						success: function( data ) {
        							var data = data[1];
        							var i, j, item, html;
        							for(var i=0; i<data.length; ++i) {
        								item = data[i];
        								html = '<span class="ac-item_content">';
        								for(var j=0; j<item[1].length; ++j) {
        									html += ((typeof item[1][j] === 'string') ? item[1][j] : '<b>' + item[1][j][1] + '</b>');
        								}
        								html += '</span>';
        								data[i] = { label: html, value: (item[2]||'').replace(/\s*\s$/, '') };
        							}
        							response(data);
        						}
        					});
        				}
        			});
        			
        			var oldRI = elem.data( "autocomplete" )._renderItem;
        			elem.data("autocomplete")._renderItem = function( ul, item ) {
        				return oldRI.call(this, ul, item).find('a').html(item.label).end();
        			};
        		},
        		_setText: function(textBox, text) {
        		    var input = textBox.elem('input');
        		    if (text) {
        		        textBox.delMod(input, 'showhint');
        		        input.val(text);
        		    } else {
        		        textBox.setMod(input, 'showhint', 'yes');
        		        input.val(this._helper.localStr('address'));
        		    }
        		},
        		_getText: function(textBox) {
        		    var input = textBox.elem('input');
        		    var hint = textBox.getMod(input, 'showhint');
        		    return (hint == 'yes') ? '' : input.val();
        		},
        		setRouteInfo: function(data) {
        		    data = data || {home: '', work: ''};
        		    this._setText(this._textboxHome, data.home);
        		    this._setText(this._textboxWork, data.work);
        		    this._btnRemove.setMod('disabled', (data.home && data.work) ? 'no' : 'yes');
        		}
            }, {
                live: function() {
                    'use strict';
                    this.liveBindTo('close', 'leftclick', function(e) {
                        e.preventDefault();
                        this._parent.updateSliceType();
                    });
                }
            });
        })(jQuery);
    /* blocks-desktop/b-traffic-settings/b-traffic-settings.js: end */ /**/
    
    /* lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: begin */ /**/
        /**
         * leftClick event plugin
         *
         * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
         * Dual licensed under the MIT and GPL licenses:
         * http://www.opensource.org/licenses/mit-license.php
         * http://www.gnu.org/licenses/gpl.html
         *
         * @version 1.0.0
         */
        
        (function($) {
        
        var leftClick = $.event.special.leftclick = {
        
            setup : function() {
        
                $(this).bind('click', leftClick.handler);
        
            },
        
            teardown : function() {
        
                $(this).unbind('click', leftClick.handler);
        
            },
        
            handler : function(e) {
        
                if(!e.button) {
                    e.type = 'leftclick';
                    $.event.handle.apply(this, arguments);
                    e.type = 'click';
                }
        
            }
        
        };
        
        })(jQuery);
    /* lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: end */ /**/
    
    /* lego/blocks-desktop/b-form-input/b-form-input.js: begin */ /**/
        (function() {
        
        var instances,
            sysChannel,
            update = function () {
                var instance, i = 0;
                while(instance = instances[i++]) instance.val(instance.elem('input').val());
            },
            getActiveElement = function (doc) {
                // В iframe в IE9: "Error: Unspecified error."
                try { return doc.activeElement } catch (e) {}
            };
        
        BEM.DOM.decl('b-form-input', {
        
            onSetMod : {
        
                'js' : function() {
        
                    var _this = this,
                        input = _this.elem('input'),
                        activeElement = getActiveElement(_this.__self.doc[0]),
                        haveToSetAutoFocus =
                            _this.params.autoFocus &&
                            !(activeElement && $(activeElement).is('input, textarea'));
        
                    _this._val = input.val();
        
                    if (activeElement === input[0] || haveToSetAutoFocus) {
                        _this.setMod('focused', 'yes')._focused = true;
                    }
        
                    // факт подписки
                    if(!sysChannel) {
                        instances = [];
                        sysChannel = _this.channel('sys')
                            .on({
                                'tick' : update,
                                'idle' : function() {
                                    sysChannel.un('tick', update);
                                },
                                'wakeup' : function() {
                                    sysChannel.on('tick', update);
                                }});
                    }
        
                    // сохраняем индекс в массиве инстансов чтобы потом быстро из него удалять
                    _this._instanceIndex = instances.push(
                        _this.bindTo(input, {
                            focus : _this._onFocus,
                            blur  : _this._onBlur
                        })
                    ) - 1;
        
                    // шорткат для перехода в инпут - crtl+стрелка вверх
                    _this.params.shortcut && _this.bindToDoc('keydown', function(e) {
                        if(e.ctrlKey && e.keyCode == 38 && !$(e.target).is('input, textarea')) {
                            _this.setMod('focused', 'yes');
                        }
                    });
                },
        
                'disabled' : function(modName, modVal) {
        
                    this.elem('input').attr('disabled', modVal == 'yes');
        
                },
        
                'focused' : function(modName, modVal) {
        
                    if(this.hasMod('disabled', 'yes'))
                        return false;
        
                    var focused = modVal == 'yes';
        
                    focused?
                        this._focused || this._focus() :
                        this._focused && this._blur();
        
                    this.afterCurrentEvent(function() {
                        this.trigger(focused? 'focus' : 'blur');
                    });
        
                }
        
            },
        
            onElemSetMod : {
        
                'message' : {
        
                    'visibility' : function(elem, modName, modVal) {
        
                        var _this = this,
                            type = _this.getMod(elem, 'type');
        
                        if(type) {
                            var needSetMod = true;
                            modVal || _this.elem('message', 'type', type).each(function() {
                                this != elem[0] && _this.hasMod($(this), 'visibility', 'visible') && (needSetMod = false);
                            });
                            needSetMod && _this.toggleMod('message-' + type, 'yes', '', modVal === 'visible');
                        }
        
                    }
        
                }
        
            },
        
            /**
             * Возвращает/устанавливает текущее значение
             * @param {String} [val] значение
             * @param {Object} [data] дополнительные данные
             * @returns {String|BEM} если передан параметр val, то возвращается сам блок, если не передан -- текущее значение
             */
            val : function(val, data) {
        
                if(typeof val == 'undefined') return this._val;
        
                if(this._val != val) {
                    var input = this.elem('input');
                    input.val() != val && input.val(val);
                    this._val = val;
                    this.trigger('change', data);
                }
        
                return this;
        
            },
        
            name : function(name) {
                return this.elem('input').attr('name');
            },
        
            _onFocus : function() {
        
                this._focused = true;
                return this.setMod('focused', 'yes');
        
            },
        
            _onBlur : function() {
        
                this._focused = false;
                return this.delMod('focused');
        
            },
        
            /**
             * Нормализует установку фокуса для IE
             * @private
             */
            _focus : function() {
        
                var input = this.elem('input')[0];
                if(input.createTextRange && !input.selectionStart) {
                    var range = input.createTextRange();
                    range.move('character', input.value.length);
                    range.select();
                } else {
                    input.focus();
                }
        
            },
        
            _blur : function() {
        
                this.elem('input').blur();
        
            },
        
            destruct : function() {
        
                this.__base.apply(this, arguments);
        
                this.params.shortcut && this.unbindFromDoc('keydown');
                instances.splice(this._instanceIndex, 1);
        
                var i = this._instanceIndex,
                    instance;
        
                while(instance = instances[i++]) --instance._instanceIndex;
        
            }
        
        });
        
        BEM.HTML.decl('b-form-input', {
        
            onBlock : function(ctx) {
        
                var id = ctx.param('id') || ctx.generateId();
        
                ctx
                    .tag('span')
                    .tParam('id', id)
                    .tParam('has-clear', ctx.mod('has-clear') === 'yes')
                    .tParam('type', ctx.mod('type') || 'input')
                    .afterContent(
                        {
                            elem : 'box',
                            tag : 'span',
                            content : {
                                elem : 'input',
                                attrs : {
                                    value : ctx.param('value'),
                                    name : ctx.param('name'),
                                    id : id
                                }
                            }
                        })
                    .js(true);
        
            },
        
            onElem : {
        
                'input' : function(ctx) {
        
                    ctx.tag(ctx.tParam('type'));
        
                },
        
                'label' : function(ctx) {
        
                    ctx
                        .tag('label')
                        .attr('for', ctx.tParam('id'));
        
                },
        
                'box': function (ctx) {
        
                    if (ctx.tParam('has-clear')) {
                        ctx.afterContent({elem: 'clear', tag: 'span'});
                    }
        
                },
        
                'hint' : function(ctx) {
        
                    ctx
                        .tag('label')
                        .attr('for', ctx.tParam('id'))
        
                }
        
            }
        
        });
        
        })();
    /* lego/blocks-desktop/b-form-input/b-form-input.js: end */ /**/
    
    /* lego/blocks-desktop/i-system/i-system.js: begin */ /**/
        (function() {
        
        var timer,
            counter = 0,
            isIdle = false,
            idleInterval = 0,
            channel = BEM.channel('sys'),
            TICK_INTERVAL = 50;
        
        BEM.decl('i-system', {}, {
        
            start : function() {
        
                $(document).bind('mousemove keydown', function() {
                    idleInterval = 0;
                    if(isIdle) {
                        isIdle = false;
                        channel.trigger('wakeup');
                    }
                });
        
                this._tick();
        
            },
        
            _tick : function() {
        
                var _this = this;
        
                channel.trigger('tick', { counter : counter++ });
        
                if(!isIdle && (idleInterval += TICK_INTERVAL) > 3000) {
                    isIdle = true;
                    channel.trigger('idle');
                }
        
                timer = setTimeout(function() {
                    _this._tick();
                }, TICK_INTERVAL);
        
            }
        
        }).start();
        
        })();
    /* lego/blocks-desktop/i-system/i-system.js: end */ /**/
    
    /* lego/blocks-desktop/b-form-button/b-form-button.js: begin */ /**/
        BEM.DOM.decl('b-form-button', {
        
            onSetMod : {
        
                'js' : function() {
        
                    var disabled = this.isDisabled();
        
                    (this._href = this.domElem.attr('href')) && disabled &&
                        this.domElem.removeAttr('href');
        
                    this.elem('input').attr('disabled', disabled);
        
                },
        
                'focused' : {
        
                    'yes' : function() {
        
                        if(this.isDisabled())
                            return false;
        
                        var _this = this;
        
                        _this
                            .bindTo('keydown', this._onKeyDown)
                            .elem('input').focus();
        
                        _this._unloadInited ||
                            (_this._unloadInited = $(window).bind('unload', function() {
                                _this.delMod('focused');
                            }));
        
                    },
        
                    '' : function() {
        
                        this
                            .unbindFrom('keydown')
                            .elem('input').blur();
        
                    }
        
                },
        
                'disabled' : function(modName, modVal) {
        
                    var disable = modVal == 'yes';
        
                    this.elem('input').attr('disabled', disable);
        
                    this._href && (disable?
                        this.domElem.removeAttr('href') :
                        this.domElem.attr('href', this._href));
        
                    disable && this.domElem.keyup();
        
                },
        
                'pressed' : function(modName, modVal) {
        
                    this.isDisabled() || this.trigger(modVal == 'yes'? 'press' : 'release');
        
                },
        
                'hovered' : {
        
                    '' : function() {
        
                        this.delMod('pressed');
        
                    }
        
                },
        
                '*' : function(modName) {
        
                    if(this.isDisabled() && 'hovered pressed'.indexOf(modName) > -1)
                        return false;
        
                }
        
            },
        
            /**
             * Шорткат для проверки модификатора disabled_yes
             * @returns {Boolean}
             */
            isDisabled : function() {
        
                return this.hasMod('disabled', 'yes');
        
            },
        
            /**
             * Получение/установка урла (для кнопки-ссылки)
             * @param {String} [val] урл
             */
            url : function(val) {
        
                if(typeof val == 'undefined') {
                    return this._href;
                } else {
                    this._href = val;
                    this.isDisabled() || this.domElem.attr('href', val);
                    return this;
                }
        
            },
        
            _onKeyDown : function(e) {
        
                var keyCode = e.keyCode;
                // имитируем state_pressed по нажатию на enter и space
                if((keyCode == 13 || keyCode == 32) && !this._keyDowned) {
                    this._keyDowned = true;
                    this
                        .setMod('pressed', 'yes')
                        .bindTo('keyup', function() {
                            this
                                .delMod('pressed')
                                .unbindFrom('keyup');
                            delete this._keyDowned;
                            // делаем переход по ссылке по space
                            if(keyCode == 32 && this.domElem.attr('href')) {
                                document.location = this.domElem.attr('href');
                            }
                        });
                }
        
            },
        
            _onClick : function(e) {
        
                this.isDisabled()?
                    e.preventDefault() :
                    this.afterCurrentEvent(function() {
                        this.trigger('click');
                    });
            },
            destruct : function () {
                this.delMod('focused');
                this.__base.apply(this, arguments);
            }
        
        }, {
        
            live : function() {
        
                var eventsToMods = {
                    'mouseover' : { name : 'hovered', val : 'yes' },
                    'mouseout' : { name : 'hovered' },
                    'mousedown' : { name : 'pressed', val : 'yes' },
                    'mouseup' : { name : 'pressed' },
                    'focusin' : { name : 'focused', val : 'yes' },
                    'focusout' : { name : 'focused' }
                };
        
                this
                    .liveBindTo('leftclick', function(e) {
                        this._onClick(e);
                    })
                    .liveBindTo('mouseover mouseout mouseup focusin focusout', function(e) {
                        var mod = eventsToMods[e.type];
                        this.setMod(mod.name, mod.val || '');
                    })
                    .liveBindTo('mousedown', function(e) {
                        var mod = eventsToMods[e.type];
                        e.which == 1 && this.setMod(mod.name, mod.val || '');
                    });
            }
        
        });
        
        BEM.HTML.decl('b-form-button', {
        
            onBlock : function(ctx) {
        
                ctx
                    .tag(ctx.param('url')? 'a' : 'span')
                    .attrs({ href : ctx.param('url'), target : ctx.param('target') })
                    .mods({
                        size : ctx.mod('size'),
                        theme : ctx.mod('theme')
                    })
                    .content(
                        [
                            { elem : 'left', tag : 'i' },
                            {
                                elem : 'content',
                                tag : 'span',
                                content : {
                                    elem : 'text',
                                    tag : 'span',
                                    content : ctx.content()
                                }
                            }
                        ],
                        true)
                    .afterContent(
                        ctx.param('type')?
                            {
                                elem : 'input',
                                attrs : {
                                    value : ctx.param('value') || '',
                                    type : ctx.param('type'),
                                    name : ctx.param('name'),
                                    disabled : ctx.mod('disabled') && 'disabled'
                                }
                            } :
                            { elem : 'click' })
                    .js(true);
        
            },
        
            onElem : {
        
               'input' : function(ctx) {
        
                   ctx.tag('input');
        
               },
        
               'click' : function(ctx) {
        
                   ctx.tag('i');
        
               }
        
            }
        
        });
    /* lego/blocks-desktop/b-form-button/b-form-button.js: end */ /**/
    
    /* blocks-desktop/b-traffic-map/b-traffic-map.js: begin */ /**/
        (function($) {
        
        /*
        events:
        
        map.apierror
        map.route
        map.routeerror
        map.create
        */
        
            BEM.DOM.decl('b-traffic-map', {
                
                _map: {
        		    map: null,
        		    api: {
        			    ready: false,
        			    error: false,
        			    loaded: false,
        			    timer: null,
        			    startLoad: 0,
        			    _callback: Function.empty,
        			    
        			    clearTimer: function() {
        				    if (this.timer) {
        					    clearTimeout(this.timer);
        					    this.timer = null;
        				    }
        			    },
        			    loadTimer: function() {
        				    var mapAPI = this;
        				    if (!mapAPI.loaded && !mapAPI.timer && mapAPI.startLoad) {
        					    mapAPI.timer = setTimeout(function() {
        						    mapAPI.timer = null;
        						    if (!mapAPI.loaded) {
        							    mapAPI.loaded = true;
        							    mapAPI.error = true;
        							    mapAPI._callback(true, true);
        						    }
        					    }, 9000);
        				    }
        			    },
        			    load: function(callback, setTimer) {
        				    if (this.startLoad) {
        				        return;
        				    }
        				    this.startLoad = (new Date()).valueOf();
        				    var mapAPI = this;
        				    this._callback = callback || Function.empty;
        				    var config = BEM.blocks['i-widget-traffic'].config;
        				    var lang = this.utils.getLang(config.API_LANGS);
        				    var apiUrl = config.MAP_API_URL + lang;
        				    
        				    BEM.blocks['i-widget-helper'].getScript(apiUrl, function() {
        					    mapAPI.loaded = true;
        					    if (mapAPI.error) { return; }
        					    if (window.ymaps && window.ymaps.ready) {
        						    ymaps.ready(function() {
        							    if (mapAPI.error) { return; }
        							    mapAPI.clearTimer();
        							    mapAPI.ready = true;
        							    mapAPI.error = false;
        							    mapAPI._callback(false, false);
        						    });
        					    } else {
        						    mapAPI.clearTimer();
        						    mapAPI.error = true;
        						    mapAPI._callback(true, false);
        					    }
        				    });
        				    setTimer && this.loadTimer();
        			    }
        		    },
        		    
        		    init: function(widget) {
        		        this.utils = widget.utils;
        		        this.api.utils = widget.utils;
        		    },
        		
        		    zoomCtrlPos: function(topic, top) {
        			    if (this.map) {
        				    if (!this._szc) {
        					    this.map.controls.add('smallZoomControl', { top: top + 7, left: 7 });
        					    this._szc = this.map.controls.get('smallZoomControl');
        				    } else {
        					    this._szc.options.set('position', {top: top + 7, left: 7});
        				    }
        			    }
        		    },
        		
        		    create: function(params, elem) {
        			    if (this.map || !params || !this.api.ready) {
        				    return false;
        			    }
        			
        			    this.map = new ymaps.Map(elem, {
        				    center: params.center, //[params.lat, params.lon],
        				    zoom: params.zoom,
        				    behaviors: ['drag', 'scrollZoom', 'dblClickZoom']
        			    });
        			    
        			    var helper = BEM.blocks['i-widget-helper'];
        			    helper.addListener('put.zoomCtrlTop', this.zoomCtrlPos, this);
        			    helper.fireEvent('get.zoomCtrlTop');
        			
        			    var trafficControl = new ymaps.control.TrafficControl();
        			    this.map.controls.add(trafficControl, {top: -407, left: 7});
        			    trafficControl.state.set('shown', true); 
        			
        			    var lt = this._szc.getLayout();
        			
        			    if (lt) {
        				    lt.events.add('click', function() { 
        				        BEM.blocks['i-widget-helper'].logAction(6); 
        				    });
        			    }
        			
        			    return true;
        		    },
        		
        		    correct: function(item) {
        			    if ((this.map.getZoom() != item.zoom) || (this.utils.distance(this.map.getCenter(), item.center, item.zoom) > 0.1)) {
        				    this.map.setCenter(item.center, item.zoom);
        			    }
        		    }
        	    },
        	    
        	    _route: {
        		    loading: false,
        		    time: 0,
        		    interval: 20,
        		    route: null,
        		    revert: false,
        		    map: null,
        		    utils: null,
        		    viewHeights: null,
        		    
        		    init: function(widget) {
        		        this.utils = widget.utils;
        		    },
        		
        		    isExpired: function() {
        			    if (!this.route) {
        				    return false;
        			    }
        			    return ((new Date()).valueOf() - this.time > 1000 * 60 * this.interval) || (this.utils.isRouteRevertByTime() != this.revert);
        		    },
        		
        		    setRoute: function(route, rev) {
        			    route = route || null;
        			    if(this.route == route) { return; }
        			
        			    if(this.route) { 
        				    this.map.geoObjects.remove(this.route); 
        				    this.route = null;
        			    }
        			
        			
        			    this.time = (new Date()).valueOf();
        			
        			    if (!route) { return; }
        			
        			    this.route = route;
        			    this.revert = rev;
        			
        			    this.map.geoObjects.add(route);
        			    var boundedBy = route.properties.get('boundedBy');
        			
        			    var mapSizes = this.viewHeights;
        			    var hm = mapSizes.height - mapSizes.paddingTop - mapSizes.paddingBottom;
        			    var hr = boundedBy[1][0] - boundedBy[0][0];
        			
        			    boundedBy[0][0] = boundedBy[0][0] - hr * mapSizes.paddingBottom / hm;
        			    boundedBy[1][0] = boundedBy[1][0] + hr * mapSizes.paddingTop / hm;
        			
        			    var th = this;
        			    this.map.setBounds(boundedBy, {
        				    checkZoomRange: true,
        				    callback: function(err) {
        					    if (err) {
        						     
        					    } else {
        						    th.zoom = th.map.getZoom();
        						    th.center = th.map.getCenter();
        					    }
        				     }
        			    });
        		    }
        	    },
        	
        	    _placemark: {
        		    time: 0,
        		    interval: 20,
        		    obj: null,
        		    map: null,
        		    utils: null,
        		    init: function(widget) {
        		        this.utils = widget.utils;
        		        
        		        var engYa = widget.config.ENG_YA_SYMBOL[this.utils.getLang()];
        		        this.yaImgUrl = widget.config['YA_SYMBOL_PATH_' + (engYa ? 'EN' : 'RU')];
        		    },
        		    create: function() {
        			    var ctm = (new Date()).valueOf();
        			    if (this.map && (ctm - this.time > 1000 * 60 * this.interval)) {
        				    if (this.obj) {
        					    this.map.geoObjects.remove(this.obj); 
        					    this.obj = null;
        				    }
        				
        				    var gloc = this.utils.getLL();
        				    this.obj = new ymaps.Placemark([gloc.latitude, gloc.longitude], {
        					    //balloonContent: 'text'
        				    }, {
        					    iconImageHref: this.yaImgUrl,
        					    iconImageSize: [32, 32],
        					    iconImageOffset: [-20, -20]
        				    });
        				    this.map.geoObjects.add(this.obj)
        				    this.time = ctm;
        			    }
        		    }
        	    },
        	    
        	    
                
                platform_i18n: function(helper, i) {
                    
                },
                
                isApiErrorState: function() {
                    return this._map.api.error;
                },
                isApiReadyState: function() {
                    return this._map.api.ready;
                },
                
                init: function() {
                    this._helper = BEM.blocks['i-widget-helper'];
                    this._widget = BEM.blocks['i-widget-traffic'];
                    
                    this._map.init(this._widget);
                    this._route.init(this._widget);
                    this._placemark.init(this._widget);
                    
                    this._helper.addListener('traffic-before-popup', function() {
                        
                        if (this._map.map) {
                            this._placemark.create();
                            if (this._route.route) {
                                if (this._route.isExpired()) {
                                    this.makeMyRoute(this._widget.storage.loadRouteData());
                                } else {
                                    this._map.correct(this._route);
                                }
                            } else {
                                var savedRouteData = this._widget.storage.loadRouteData();
                                if (savedRouteData) {
                                    this.makeMyRoute(savedRouteData);
                                } else {
                                    this._map.correct(this._widget.getMapConfig().region);
                                }
                            }
                        }
                        
                    }, this);
                    
                    
                    var self = this;
                    this._map.api.load(function(error, fromTimer) {
                        if (error) {
                            self._helper.fireEvent('map.apierror', fromTimer);
                        } else {
                            self.createMap();
                        }
                    });
                },
                
                
                deleteRoute: function() {
                    if (this._route.loading) {
                        this._route.canceled = true;
                    }
                    this._route.setRoute(null);
                },
                
                makeMyRoute: function (data, saveRoute) {
        		    if (this._route.loading || !data || !this._map.map) { return; }
        		    var rev = !!data.revert;
        		    var home = data.homePoint || data.home;
        		    var work = data.workPoint || data.work;
        		    var self = this;
        		    ymaps.route([
        			    rev ? work : home,
        			    rev ? home : work
        		    ], {
        			    boundedBy: this._map.map.getBounds(),
        			    avoidTrafficJams: true
        		    }).then(function (route) {
        		        self._route.loading = false;
        		        if (self._route.canceled) {
        		            self._route.canceled = false;
        		            return;
        		        }
        			    if (route.getLength() < 2) {
        				    return;
        			    }
        			    self._route.setRoute(route, rev);
        			
        			    var points = route.getWayPoints();  
        			    points.options.set('preset', 'twirl#blueStretchyIcon');
        			    points.get(0).properties.set('iconContent', self._helper.localStr('route.begin.title'));
        			    points.get(1).properties.set('iconContent', self._helper.localStr('route.end.title'));
        			
        			    var point0 = points.get(0).geometry.getBounds()[0];
        			    var point1 = points.get(1).geometry.getBounds()[0];
        			
        			    data.homePoint = rev ? [point1[0], point1[1]] : [point0[0], point0[1]];
        			    data.workPoint = rev ? [point0[0], point0[1]] : [point1[0], point1[1]];
        			    
        			    data.home = points.get(rev?1:0).properties.get('balloonContentBody');
        				data.work = points.get(rev?0:1).properties.get('balloonContentBody');
        				
        				self._helper.fireEvent('map.route', {data: data, route: route, revert: rev, isNewRoute: saveRoute});
        		    }, function (error) {
        			    self._route.loading = false;
        			    self._route.canceled = false;
        			    self._helper.fireEvent('map.routeerror', saveRoute);
        		    });
        		    self._route.loading = true;
        	    },
                
                createMap: function() {
                    var mapDataFromExport = this._widget.getMapConfig();
                
                    if (!mapDataFromExport || this._map.map || !this._map.api.ready) {
        			    return false;
        		    }
        		
        		    var savedRouteData = this._widget.storage.loadRouteData();
        		    this._helper.fireEvent('map.create');
        		
        		    this._map.create(mapDataFromExport.region, this.elem('ymap')[0]);
        		
        		    this._route.viewHeights = {
                        height: this.elem('ymap').height(),
        				paddingTop: 34,
        				paddingBottom: 2
                    };
        		    this._route.map = this._map.map;
        		    this._placemark.map = this._map.map;
        		    this._placemark.create();
        		    this.makeMyRoute(savedRouteData);
        		    return true;
                },
                
                setLoadTimer: function() {
                    this._map.api.loadTimer();
                },
                
                getSPN: function (encoding) {
        			if(!this._map.map) {
        				return '';
        			}
        			var bounds = this._map.map.getBounds();
        			return (bounds[1][1] - bounds[0][1]) + (encoding ? '%2C' : ',') + (bounds[1][0] - bounds[0][0]);
        		},
        		getCenter: function() {
        		    return this._map.map.getCenter();
        		},
        		
        		getRoute: function() {
        		    return this._route.route;
        		},
                
                getMapUrl: function () {
        			var domain = this._widget.config.MAP_URL;
        			if(!this._map.map) {
        				return domain;
        			}
        			
        			var cen = this._map.map.getCenter();
        			var params = [
        				"z=" + this._map.map.getZoom(),
        				"ll=" + cen[1] + '%2C' + cen[0],
        				"l=map%2Ctrf",
        				'elmt=traffic'
        			];
        			if (this._route.route) {
        				var points = this._route.route.getWayPoints();
        				var p0 = points.get(0).geometry.getBounds()[0];
        				var p1 = points.get(1).geometry.getBounds()[0];
        				params.push('rt=' + p0[1] + '%2C' + p0[0] + '~' + p1[1] + '%2C' + p1[0]);
        			}
        			return domain + '?' + params.join('&');
        		},
                
                setErrorText: function(text) {
                    this.elem('error').text(text);
                }
            }, {
                live: function() {
                    this.liveBindTo('leftclick', function(e) {
                       //this._handleClick(e);
                    });
                }
            });
        })(jQuery);
    /* blocks-desktop/b-traffic-map/b-traffic-map.js: end */ /**/
    
    /* lego/blocks-common/i-bem/i18n/lib/i18n.js: begin */ /**/
        // XXX: поддержать в `i-bem__i18n` танкерный синтаксис вызова ключей
        // i18n['prj']['keyset']['key'](params);
        var i18n = i18n || {};
        
        (function(bem_, undefined) {
        
        var cache = {},
            // (LEGO-7486) стек кейсетов, нужен для востановления контекста в связанных ключах/кейсетах
            stack = [],
            /** {String} */
            MOD_DELIM = '_',
            /** {String} */
            ELEM_DELIM = '__',
            /** {String} */
            DEFAULT_LANG = 'ru';
        
        function bemName(decl) {
        
            typeof decl === 'string' && (decl = { block: decl });
        
            return decl.block +
                (decl.elem ? (ELEM_DELIM + decl.elem) : '') +
                (decl.modName ? MOD_DELIM + decl.modName + MOD_DELIM + decl.modVal : '');
        
        }
        
        function bemParse(name) {
        
            var bemitem = {};
        
            name.split(ELEM_DELIM).forEach(function(item, i) {
                var keys = [ i ? 'elem' : 'block', 'mod', 'val' ];
        
                item.split(MOD_DELIM).forEach(function(part, j) {
                    bemitem[keys[j]] = part;
                });
            });
        
            return bemitem;
        
        }
        
        function _pushStack(name) {
            if(!name) return false;
        
            var len = stack.length;
            return !(len && stack[len - 1] === name) && stack.push(name);
        }
        
        function _popStack(name) {
            var len = stack.length;
            return len && stack[len - 1] !== name && stack.pop();
        }
        
        /**
         * @constructor
         */
        function _i18n() {
            this._lang = '';
            this._prj = 'lego';
            this._keyset = '';
            this._key = '';
        }
        
        _i18n.prototype = {
        
            lang : function(name) {
                this._lang = name;
                return this;
            },
        
            project : function(name) {
                this._prj = name;
                return this;
            },
        
            keyset : function(name) {
                _pushStack(this._keyset);
        
                this._keyset = bemName(name);
                return this;
            },
        
            key : function(name) {
                this._key = name;
                return this;
            },
        
            /**
             * TODO: вынести поддержку legacy-синтаксиса в отдельный метод
             * @param {Object|Function} v
             */
            decl : function(v) {
                var bemitem = bemParse(this._keyset),
                    // tanker legacy syntax
                    prj = bemitem.block === 'i-tanker' ? 'tanker' : this._prj,
                    keyset = bemitem.elem || this._keyset,
                    key = this._key;
        
                prj = i18n[prj] || (i18n[prj] = {});
                keyset = prj[keyset] || (prj[keyset] = {});
                keyset[key] = typeof v === 'function' ? v : (function(p) { return (v); });
        
                // `BEM.I18N` syntax
                var l = cache[this._lang] || (cache[this._lang] = {}),
                    k = l[this._keyset] || (l[this._keyset] = {});
        
                k[key] = v;
            },
        
            val : function(params, thisCtx) {
                var value = cache[this._lang] && cache[this._lang][this._keyset];
                if(!value) {
                    console && console.log &&
                        console.log("[Error] keyset: " + this._keyset + " key: " + this._key + " (lang: " + this._lang + ")");
                    return '';
                }
        
                value = value[this._key];
                if(!value) return '';
        
                try{
                    return typeof value === 'string' ?
                        value : thisCtx ? value.call(thisCtx, params) : value.call(this, params);
                } catch(e) {
                    throw "[Error] keyset: " + this._keyset + " key: " + this._key + " (lang: " + this._lang + ")";
                }
            },
        
            _c : function() { return cache; }
        
        };
        
        /** {namespace} */
        bem_.I18N = (function(base) {
        
            /**
             * Шоткат для получения значения ключа
             * @param {String|Object} keyset
             * @param {String} key
             * @param {Object} [params]
             * @return {String}
             */
            var klass = function(keyset, key, params) {
                return klass.keyset(keyset).key(key, params);
            };
        
            ['project', 'keyset'].forEach(function(p) {
                klass[p] = function(v) { this._i18n[p](v); return this; };
            });
        
            /**
             * @param {String} name имя ключа
             * @param {Object} params
             * @return {String}
             */
            klass.key = function(name, params) {
                var proto = this._i18n,
                    _keyset, result;
        
                proto.lang(this._currentLang).key(name);
        
                result = proto.val.call(proto, params, klass);
        
                // восстанавливаем значение предыдущего кейсета, если нужно
                _keyset = _popStack(proto._keyset);
                _keyset && proto.keyset(_keyset);
        
                return result;
            };
        
            /**
             * Декларация переводов
             * @param {String|Object} bemitem
             * @param {Object} keysets
             * @param {Object} [declProps] параметры декларации
             */
            klass.decl = function(bemitem, keysets, declProps) {
                var proto = this._i18n, k;
        
                declProps || (declProps = {});
                declProps.lang && proto.lang(declProps.lang);
        
                proto.keyset(bemitem);
        
                for(k in keysets)
                    proto.key(k).decl(keysets[k]);
        
                return this;
            };
        
            /**
             * Устанавливает/возвращает текущий язык
             * @param {String} [lang]
             * @return {String}
             */
            klass.lang = function(lang) {
                typeof lang !== undefined
                    && (this._currentLang = lang);
        
                return this._currentLang;
            };
        
            klass._i18n = base;
        
            klass._currentLang = DEFAULT_LANG;
        
            return klass;
        
        }(new _i18n()));
        
        /** Global */
        BEM = this.BEM = bem_;
        
        }(typeof BEM === 'undefined' ? {} : BEM));
    
    /* lego/blocks-common/i-bem/i18n/lib/i18n.js: end */ /**/
    
    /* pages-desktop/traffic/traffic.i18n/ru.js: begin */ /**/
        /* Это автоматически сгенеренный файл. Не редактируйте его самостоятельно */
        
        BEM.I18N.lang("ru");
    
    /* pages-desktop/traffic/traffic.i18n/ru.js: end */ /**/

/* pages-desktop/traffic/traffic.ru.js: end */ /**/
