
var SliceUtils = (function() {
	
	// ---------- AJAX -----------------------------------------------------------------
	function makeParamMP(n, v) {
		return 'Content-Disposition: form-data; name="'+n+'"\r\n\r\n'+v;
	}
	function makeParam(n, v) {
		return n + '=' + encodeURIComponent(v);
	}
	function makeParamStr(params, mp) {
		if(!params) { return ''; }
		if(typeof params == 'string') { return params; }
		var a1 = [], fnp = (mp ? makeParamMP : makeParam);
		for(var i in params) { 
			if(params.hasOwnProperty(i)) {
				var ps = params[i];
				if(ps.join && ps.sort && ps.push && ps.length) {
					for(var j=0; j<ps.length; ++j) {
						a1.push(fnp(i, ps[j]));
					}
				} else { 
					a1.push(fnp(i, ps)); 
				}
			}
		}
		return (!mp ? a1.join('&') : mp + '\r\n' + a1.join('\r\n' + mp + '\r\n') + '\r\n' + mp + '--\r\n');
	}
	
	function ajax(obj) {
		var txt = null, xhr = null;
		xhr = new XMLHttpRequest();
		
		
		obj.method = (obj.method || 'GET').toUpperCase();
		var bdr = (obj.multipart ? '-----8a7gadg1ahSDCV'+(new Date()).valueOf() : null);
		if(obj.params) {
			obj.params = makeParamStr(obj.params, bdr && ('--'+bdr));
			if(obj.method == 'GET') { 
				obj.url += '?' + obj.params; 
			} else { 
				txt = obj.params; 
			}
		}
		var sync = !obj.callback;
		
		
		
		
		xhr.open(obj.method, obj.url, !sync);
		
		
		if(obj.overrideMimeType) { 
			xhr.overrideMimeType(obj.overrideMimeType);
		}
		if(obj.contentType) { 
			xhr.setRequestHeader('Content-Type', obj.contentType); 
		}
		else { 
			if(obj.method == 'POST') {
				xhr.setRequestHeader('Content-Type', bdr ? 'multipart/form-data; boundary='+bdr : 'application/x-www-form-urlencoded');
			}
		}
		var to1 = null, abortedTO = false;
		if(!sync) {
			xhr.onreadystatechange = function() {
				try {
					if (xhr.readyState == 4) {
						if(abortedTO) { return; }
						if(to1) { to1.cancel(); to1 = null; }
						var st = xhr.status, stt = '';
						if((st >= 200) && (st < 400)) { 
							obj.callback(obj.xml ? xhr.responseXML : xhr.responseText, xhr);
						} else {
							try { stt = xhr.statusText; } catch(exc1) {}
							obj.errback&&obj.errback(st, stt);
						}
						xhr = null;
					}
				} catch(exc) {}
			};
		}
		xhr.send(txt);
		if(sync) {
			return (obj.xml ? xhr.responseXML : xhr.responseText);
		} else { 
			if(obj.timeout) {
				to1 = setTimeout(function() {
					if(to1) {
						abortedTO = true;
						xhr.abort();
						obj.errback&&obj.errback(998, 'timeout');
					}
				}, obj.timeout);
			}
			return xhr;
		}
	}
	
	
	return {
		makeParamStr: makeParamStr,
		multiGET: function(o) {
			if(!o || !o.urls){ return false; }
			function _GET(url, n, arr, bXML, fn) {
				ajax({ url: url, xml: bXML, callback: function(t) { arr[n] = t; fn(); }, errback: fn});
			}
			var cou = 0, arr = [];
			function qq() { cou++; if(cou == o.urls.length) { o.callback(arr); } }
			for(var i=0; i<o.urls.length; ++i) {
				_GET(o.urls[i], i, arr, o.xml, qq);
			}
			return true;
		},
		POST: function(o) {
			o.method = 'POST';
			return ajax(o);
		},
		GET: function(o) {
			o.method = 'GET';
			return ajax(o);
		},
		
		createSpin: function(elem, dy, maxy, dt) {
			elem.style.backgroundPosition = '0 0';
			var cur = 0, timer = 0;
			function step() {
				cur += dy;
				if(cur >= maxy){cur = 0;}
				elem.style.backgroundPosition = '0 -' + cur + 'px';
			}
			return {
				start: function() {
					if (!timer) { timer = setInterval(step, dt); }
				},
				stop: function() {
					if (timer) {
						clearInterval(timer); 
						timer = null;
					}
				}
			}
		}
	};
})();


(function() {
	var adapter = {
		disableContextMenu: true,
		EXPORT_URL: 'http://export.yandex.ru/bar/reginfo.xml',
		EXPORT_URL_TR: 'http://export.yandex.com.tr/bar/reginfo.xml',
		localStr: function (key) {
			return window.platform.getLocalizedString('slice.weather.' + key);
		},
		resizeSliceTo: function (x, y) {
			try {
				platform.resizeWindowTo(x, y);
			} catch (e) {}
		},
		log: function(str) {},
		getCookie: function (url, kn, http) {
			return platform.getCookie(url, kn, http) || '';
		},
		action: function (n) {
			return platform.logCustomAction(n);
		},
		navigate: function(url, target) {
			platform.navigate(url, target);
			window.close();
		},
		reloadSlice: function() {
			platformMsgs.detach();
			location.reload(true);
		}
	};
	var platformMsgs = {
		map: {},
		call: function (str) {
			if (this.map.hasOwnProperty(str)) {
				var i, arr = this.map[str];
				for (i=0; i<arr.length; ++i) {
					arr[i](str);
				}
			}
		},
		add: function(msg, func) {
			if (!msg || !func) {
				return;
			}
			this.map[msg] = this.map[msg] || [];
			this.map[msg].push(func);
			return this;
		},
		_attached: null,
		attach: function() {
			if (this._attached) {
				return;
			}
			var th = this;
			this._attached = function(str) {
				th.call(str);
			};
			platform.onMessage.addListener(this._attached);
		},
		detach: function() {
			if (this._attached) {
				platform.onMessage.removeListener(this._attached);
				this._attached = null;
			}
		}
	};
	
	//----------------------------------------------------------------------
	
	function ExtractData(xml) {
		function nodes(parent, name) { 
			return parent.getElementsByTagName(name); 
		}
		function node(p, name, i) { 
			var arr = nodes(p, name); 
			return arr.length ? arr[i==-1 ? arr.length-1 : (i||0)] : null; 
		}
		function attr(p, name) { 
			return p ? (p.getAttribute(name)||'') : ''; 
		}
		function value(p, name) { 
			var n = name ? node(p, name) : p; 
			return n&&n.firstChild ? (n.firstChild.nodeValue||'') : ''; 
		}
		
		function divColor(c, k) {
			return c.replace(/../g, function(m){var r=Math.round(parseInt(m, 16)/k).toString(16); return (r.length>1?r:'0'+r);});
		}
		function avgColor(c1, c2) {
			var r = '';
			for(var i=0; i<6; i+=2) {
				var c = Math.round((parseInt(c1.substr(i, 2), 16) + parseInt(c2.substr(i, 2), 16))/2).toString(16);
				r += (c.length>1?c:'0'+c)
			}
			return r;
		}
		function avgTemp(t1, t2) {
			return Math.round((parseInt(t1, 10) + parseInt(t2, 10))/2).toString(10).replace(/^([1-9])/, '+$1');
		}
		
		var dpTypes = ['', 'morning', 'day', 'evening', 'night']
		
		var r = {
			title: adapter.localStr('title'),
			main: {
				windN: adapter.localStr('wind'),
				dampnessN: adapter.localStr('dampness'),
				pressureN: adapter.localStr('pressure'),
				url_text: adapter.localStr('url.title')
			},
			details: []
		};
		var j, wh = node(xml, 'weather');
		if(!wh) {
			return 'error';
		}
		var day = node(wh, 'day');
		if(!day) {
			return 'error';
		}
		var dps = nodes(day, 'day_part');
		var dp = dps[0];
		var tem = node(dp, 'temperature');
		
		r.main.url = value(wh, 'url') + '?elmt=pogoda';
		r.main.city = value(day, 'title');

		r.main.temp = value(tem);
		r.main.bgcolor = attr(tem, 'color');
		r.main.color = divColor(r.main.bgcolor, 2);
		
		
		var img48 = '',  
			icons48 = nodes(dp, 'image-v3');
		for(j=0; j<icons48.length; ++j) { 
			if(attr(icons48[j], 'size') == '48x48') { 
				img48 = value(icons48[j]); 
				break; 
			} 
		}
		
		r.main.img = img48;
		r.main.img_text = value(dp, 'weather_type');
		r.main.det = '<span>' + r.main.img_text + '</span>';
		
		r.main.windDir = attr(node(dp, 'wind_direction'), 'id');
		
		r.main.windV = value(dp, 'wind_speed').replace(/(\.|0)0*$/, '') + ' ' + adapter.localStr('wind.ms');
		r.main.dampnessV = value(dp, 'dampness') + '%';
		r.main.pressureV = value(dp, 'pressure') + ' ' + adapter.localStr('pressure.mm');
		
		for(var i = 1; i<dps.length; ++i) {
			var tp = dpTypes[attr(dps[i], 'typeid')];
			var hd = (tp == 'morning') ? adapter.localStr('tomorrow') : ((i == 1) ? adapter.localStr('today') : '');
			var tem1 = node(dps[i], 'temperature_from');
			var tem2 = node(dps[i], 'temperature_to');
			var tem0 = (tem1 && tem2) ? null : node(dps[i], 'temperature');
			
			var img30 = '',  icons30 = nodes(dps[i], 'image-v3');
			for(j=0; j<icons30.length; ++j) { 
				if(attr(icons30[j], 'size') == '30x30') { 
					img30 = value(icons30[j]); 
					break; 
				} 
			}
			
			r.details[i-1] = {
				type: tp,
				typeStr: adapter.localStr('dp.' + tp),
				img: img30,
				hint: '',
				head : hd,
				temp: tem0 ? value(tem0) : avgTemp(value(tem1), value(tem2)),
				bgcolor: tem0 ? attr(tem0, 'color') : avgColor(attr(tem2, 'color'), attr(tem2, 'color'))
			};
			r.details[i-1].color = divColor(r.details[i-1].bgcolor, 2);
		}
		
		return r;
	}
	
	function setBGColor(c) {
		var d = document.getElementById('id_gradient').style;
		var arr = [
			"progid:DXImageTransform.Microsoft.gradient(startColorstr='#" + c + "', endColorstr='#ffffff',GradientType=0)",
			'-webkit-linear-gradient(bottom, #fff, #' + c + ')',
			'-moz-linear-gradient(bottom, #fff, #' + c + ')',
			'-ms-linear-gradient(bottom, #fff, #' + c + ')',
			'-o-linear-gradient(bottom, #fff, #' + c + ')'
		];
		
		var isFF = /Firefox/i.test(navigator.userAgent)?2:0;
		var isO = /Opera/i.test(navigator.userAgent)?4:0;
		var isWebKit = /WebKit/i.test(navigator.userAgent)?1:0;
		var isIE = /MSIE/i.test(navigator.userAgent);
		if(isIE) {
			d.filter = arr[0];
		} else {
			d.background = arr[isFF||isO||isWebKit];
		}
	}
	
	
	var windDirMap = { sw: 5, nw: 21, ne: 37, se: 52, s: 69, w: 85, n: 101, e: 117 };
	function ShowData(data) {
		if(data == 'error') {
			return;
		}
		function ShowDataId(i, data) {
			if(/(text|color)$/i.test(i) || !data.hasOwnProperty(i)) {return;}
			var el = document.getElementById('id_' + i);
			if(!el){return;}
			if(/ico/.test(el.className)) {
				el.style.backgroundImage = 'url("' + data[i] + '")';
				if(data[i + '_text']) { el.title = data[i + '_text']; }
				return;
			}
			if(el.tagName == 'A') {
				el.href = data[i];
				if(data[i + '_text']) { el.innerHTML = data[i + '_text']; }
				return;
			}
			el.innerHTML = data[i];
		}
		function ShowDI(parent, data) {
			if(!data){
				parent.style.display = 'none';
				return;
			}
			parent.className = 'b-weather-details__item b-weather-details__item_time_' + data.type;
			parent = parent.firstChild;
			var divs = parent.getElementsByTagName('p');
			divs[0].innerHTML = data.head;
			divs[1].innerHTML = data.typeStr;
			divs[2].style.backgroundImage = 'url("' + data.img + '")';
			if(data.hint) { divs[2].title = data.hint; }
			divs[3].innerHTML = data.temp;
			
			parent.style.backgroundColor = '#' + data.bgcolor;
			divs[1].style.color = '#' + data.color;
		}

		document.title = data.title;
		
		var c, i, main = data.main, arr = data.details;
		for(i in main) { ShowDataId(i, main); }
		
		document.getElementById('id_windV').style.backgroundPosition = '5px '+(11-(windDirMap[data.main.windDir]||5))+'px';
		
		document.getElementById('id_city').style.color = '#'+main.color;
		setBGColor(main.bgcolor);
		
		var di = document.getElementById('id_details').rows[0].cells;
		for(i=0; i<di.length; ++i) {
			ShowDI(di[i], arr[i]);
		}
		document.getElementById('id_details').className = 'b-weather-details__table b-weather-details__table_tbd_' + arr.length;
		
		
	}
	
	//-------------------------------------------------------------------------------------
	var spin = null;
	var sliceWidth = 300;
	
	window.applyExportData = function(data, error) {
		var td = data || window.__applyExportData1,
			div = document.getElementById('id_widget');
		spin.stop();
		if(td === 'error') {
			document.getElementById('id_error').innerHTML = adapter.localStr('error.' + error).replace(/##/g, '<br />');
			div.className = 'b-weather-widget b-weather-widget_type_error';
		} else {
			div.className = 'b-weather-widget';
			ShowData(td);
		}
		
		var sheig = div.offsetHeight+5;
		if (sheig < 285) {
			sheig = 295;
		}
		adapter.resizeSliceTo(sliceWidth, sheig);
	};
	
	var sliceParams = {
		region: /\bregion=(\d+)/.test(location.href) ? RegExp.$1 : ''
	};
	
	window.onload = function() {
		if (window.__debug_Tools_) { window.__debug_Tools_(adapter); }
		
		if (platform.brandID == 'tb') {
			adapter.EXPORT_URL = adapter.EXPORT_URL_TR;
		}
		
		spin = SliceUtils.createSpin(document.getElementById('id_spin'), 45, 1620, 70);
		spin.start();
		
		adapter.resizeSliceTo(sliceWidth, 295);
		
		var updating = false;
		
		platformMsgs.add('update', function(str) {
			if (!updating) {
				try {
					updating = true;
					SliceUtils.GET({
						url: adapter.EXPORT_URL + '?region=' + sliceParams.region + '&lang=' + platform.language + '&brid=' + platform.brandID,
						xml: true,
						callback: function(xml) {
							updating = false;
							applyExportData(ExtractData(xml));
						},
						errback: function(st) {
							updating = false;
							applyExportData('error', (st > 499 ? 'server' : 'net'));
						}
					});
				} catch(exc) {
					updating = false;
					applyExportData('error', 'net');
				}
			}
		});
		
		platformMsgs.attach();
		
		platformMsgs.call('update');
		
		document.body.className = 'b-body-loaded';
		
		document.getElementById('id_opts_text').onclick = function() { 
			platform.showSettings();
		};
		document.getElementById('id_opts_text').title = adapter.localStr('settings');
		
		document.getElementById('id_url').onclick = function() {
			adapter.action(11);
			adapter.navigate(this.href, 'new tab');
			return false;
		};
		
		if (adapter.disableContextMenu) {
			function evtRetFalse() {
				return false;
			}
			document.oncontextmenu = evtRetFalse;
			document.onkeydown = evtRetFalse;
			document.onkeyup = evtRetFalse;
		}
	}
})();