const EXPORTED_SYMBOLS = ["module"];

var XMLHttpRequest = function () {
	return Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"].createInstance(Components.interfaces.nsIXMLHttpRequest);
}

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

var OAuthWindowFeatures = [
	"centerscreen",
	"resizable",
	"width=640",
	"height=480"
].join(",");

var OAuthPermissions = [
	  ""
//	  "ads_management"
//	, "create_event"
//	, "email"
//	, "friends_about_me" 
//	, "friends_activities" 
//	, "friends_birthday"
//	, "friends_checkins"
//	, "friends_education_history"
//	, "friends_events"
//	, "friends_groups"
//	, "friends_hometown"
//	, "friends_interests"
//	, "friends_likes"
//	, "friends_location"
//	, "friends_notes"
//	, "friends_online_presence"
//	, "friends_photos"
//	, "friends_photo_video_tags"
//	, "friends_relationships"
//	, "friends_relationship_details"
//	, "friends_religion_politics"
//	, "friends_status"
//	, "friends_videos"
//	, "friends_website"
//	, "friends_work_history"
//	, "manage_friendlists"
	, "manage_notifications"
	, "offline_access"
//	, "publish_checkins"
//	, "publish_stream"
//	, "read_friendlists"
	, "read_insights"
	, "read_mailbox"
	, "read_requests"
	, "read_stream"
//	, "rsvp_event" 
//	, "sms"
//	, "user_about_me"
	, "user_activities"
//	, "user_address"
//	, "user_birthday"
//	, "user_checkins"
//	, "user_education_history"
//	, "user_events"
//	, "user_groups"
//	, "user_hometown"
//	, "user_interests"
//	, "user_likes"
//	, "user_location"
//	, "user_mobile_phone" 
//	, "user_notes"
//	, "user_online_presence"
//	, "user_photos"
//	, "user_photo_video_tags"
//	, "user_relationships"
//	, "user_relationship_details"
//	, "user_religion_politics"
	, "user_status"
//	, "user_videos"
//	, "user_website"
//	, "user_work_history"
//	, "xmpp_login"
].join(",");

var OAuthRedirectURI = "https://www.facebook.com/connect/login_success.html";
var OAuthRedirectURITest = /facebook\.com\/connect\/login_success\.html/i;

var module = function (application) {
	var brandOptions = application.branding.getOptions();
	var client_id = null;
	var redirect_uri = null;
	var cookieLoginProcess = 0;
	
	if (brandOptions.hasOwnProperty("client_id")) {
		client_id = brandOptions.client_id;
	}

	if (brandOptions.hasOwnProperty("redirect_uri")) {
		redirect_uri = brandOptions.redirect_uri;
	}
	
	if (!client_id) {
		throw "No client_id found";
	}

	if (!redirect_uri) {
		throw "No redirect_uri found";
	}
	
	var log = function (text) {
		application.log("API: " + text);
	};
	
	var FBdomain = {
		api: 'https://api.facebook.com/',
		api_read: 'https://api-read.facebook.com/',
		cdn: 'http://static.ak.fbcdn.net/',
		https_cdn: 'https://s-static.ak.fbcdn.net/',
		graph: 'https://graph.facebook.com/',
		staticfb: 'http://static.ak.facebook.com/',
		https_staticfb: 'https://s-static.ak.facebook.com/',
		www: 'http://www.facebook.com/',
		https_www: 'https://www.facebook.com/'
	};
	
	var FacebookConsumer = function (client_id, credentials) {
		var $ = this;
		$._client_id = client_id;
	};
	
	FacebookConsumer.prototype = {
		getRedirectURI: function () {
			return redirect_uri;
		},
		
		getPostPageUrl: function () {
			var params = {
				app_id: client_id,
				redirect_uri: this.getRedirectURI()
			};
			
			return FBdomain.www + "dialog/feed?" + application.utils.obj2UrlParams(params);
		},
		
		getSharePageUrl: function (shared_url) {
			var url = shared_url;
			var urlTester = /^https?|^s?ftp/;
			if (!urlTester.test(url)) {
				url = "";
			}
			
			var params = {
				app_id: client_id,
				u: url
			};
			
			return FBdomain.www + "sharer.php?" + application.utils.obj2UrlParams(params);
		},
		
		hasUserCookie: function() {
			return !!(application.utils.getCookie('.facebook.com', 'c_user') && application.utils.getCookie('.facebook.com', 'xs'));
		},
		deleteUserCookie: function() {
			application.utils.deleteCookie('.facebook.com', 'c_user');
		},
		
		loginByCookie: function(callback, errback) {
			errback = errback || function(){};
		
			var dt = (new Date()).valueOf();
			if (dt - cookieLoginProcess < 10000) {
				return errback('loading');
			}
			cookieLoginProcess = dt;
			
			var oauthParams = {
				"client_id": this._client_id, 
				"redirect_uri": OAuthRedirectURI, 
				"type": "user_agent",
				"display" : "popup",
				"scope": OAuthPermissions
			};
			
			var $ = this;
			
			application.utils.ajax({
				url: "https://graph.facebook.com/oauth/authorize?" + application.utils.obj2UrlParams(oauthParams),
				callback: function (st, xhr) {
					cookieLoginProcess = 0;
					var url = xhr.channel.URI.spec;
					var query = url.substr(url.indexOf('#')+1);
					var param = application.utils.urlParams2obj(query);
								
					if ("error" in param) {
						return errback();
					}
					if ("access_token" in param) {
						$._setCredentials(param);
						return callback(param);
					}
					return errback();
				},
				errback: function() {
					cookieLoginProcess = 0;
				}
			});
		},
		
		connected: function () {
			return !!this._credentials.access_token;
		},
		
		connect: function (callbacks) {
			var $ = this;
			var OAuthWindow = null;
			
			var oauthLocationListener = application.utils.createLocationListener(
				function (callbacks, aWebprogress, aRequest, aLocation) {
					var spec = aLocation.spec;

					log(spec);
					
					try {
						var url = aLocation.QueryInterface(Components.interfaces.nsIURL);
					} catch (e) {
						return;
					}
					
					if (OAuthRedirectURITest.test(spec)) {
						var param = application.utils.urlParams2obj(url.query);
						
						if ("error" in param) {
							return callbacks.error(param); // TODO something
						}
						
						var ref = application.utils.urlParams2obj(url.ref);
						
						if ("access_token" in ref) {
							return callbacks.success(ref);
						}
						
						callbacks.error("PARSE_ERROR");
					}
				}
			);
			
			var authCB = new application.utils.CallbackObject(
				function (credentials) {
					OAuthWindow.close();
					$._setCredentials(credentials);
					callbacks.success();
				},
				
				function (e) {
					OAuthWindow.close();
					callbacks.error(e);
				}
			);
			
			var oauthParams = {
				"client_id": this._client_id, 
				"redirect_uri": OAuthRedirectURI, 
				"type": "user_agent",
				"display" : "popup",
				"scope": OAuthPermissions
			};
			
			OAuthWindowArguments = {
				url: "https://graph.facebook.com/oauth/authorize?" + application.utils.obj2UrlParams(oauthParams),
				progressListener: new oauthLocationListener(authCB),
				notifyMask: Components.interfaces.nsIWebProgress.NOTIFY_LOCATION,				
				onclose: function () {
					callbacks.error("CANCELLED");
				}
			};
			
			OAuthWindow = application.ui.openMicrobrowser(OAuthWindowFeatures, OAuthWindowArguments);
		},
		
		_createSignedRequest: function (httpMethod, url) {
			var request = new XMLHttpRequest;

			request.open(httpMethod, url, true);
			
			var headers = {
				"Authorization": "OAuth " + this._credentials.access_token,
				"Accept-Charset": null,
				"Accept-Language": null,
				"Accept": null,
				"Connection": null,
				"Keep-Alive": null,
				"Content-Type": "application/x-www-form-urlencoded; charset=UTF-8"
			};
			
			for (var i in headers) request.setRequestHeader(i, headers[i]);
			
			request.channel.loadFlags |= Components.interfaces.nsIRequest.LOAD_ANONYMOUS;
			
			return request;
		},
		
		_setCredentials: function (credentials) {
			this._credentials = credentials || {};
		},
		
		execFQL: function (callbacks, query) {
			
			var method = "fql.query",
				queryField = "query";

			if (typeof query == "object") {
				method = "fql.multiquery";
				query = JSON.stringify(query);
				queryField = "queries";
			}
			
			log("execFQL, query = " + query);			
			
			var $ = this;
			
			var params = {};
			params[queryField] = query;
			
			var url = FBdomain.api + "method/" + method + "?format=json";
			log("url = " + url);
			var req = $._createSignedRequest("POST", url);
			req.onreadystatechange = function (e) {
				var readyState = req.readyState;
				if (readyState == 4) {
					var responseText = req.responseText;
					
					try {
						var response = JSON.parse(responseText);
					} catch (e) {
						return callbacks.error("PARSE_ERROR");
					}
					
					callbacks.success(response);
				}
			}
			
			req.send(application.utils.obj2UrlParams(params));
			
			return new application.utils.CallbackWatcher(function () {
				req.abort();
			});
		},
		
		requestGraph: function (callbacks, id, postData) {
			var $ = this,
				method = "GET";
			
			if (postData) {
				method = "POST";
			}
			
			var req = $._createSignedRequest(method, FBdomain.graph + id);
			req.onreadystatechange = function (e) {
				var readyState = req.readyState;
				if (readyState == 4) {
					var responseText = req.responseText;
					
					try {
						var response = JSON.parse(responseText);
					} catch (e) {
						return callbacks.error("PARSE_ERROR");
					}
					
					callbacks.success(response);
				}
			}
			
			if (typeof postData !== "string") {
				postData = application.utils.obj2UrlParams(postData);
			}
			
			req.send(postData);
		}
	}
	
	application.FB = new FacebookConsumer(client_id);
}