EXPORTED_SYMBOLS = ["core", "resources"];

const DEBUG = false;//"${config.debug}" == "true" ? true : false;

function Application() {
	var $ = this;

	$.xbCore = {
		init: function (api) {
			$.init(api);
		},
		
		finalize: function () {
			$.finalize();
		},
		
		buildWidget: function (WIID, toolbarItem) {
			toolbarItem.application = $;
			toolbarItem.setAttribute("xb-native-widget-name", $.widget_name);
		},
	
		destroyWidget: function (WIID, toolbarItem) {
			toolbarItem.destroy();
			toolbarItem.removeAttribute("xb-native-widget-name");
			toolbarItem.application = null;
		}
	};
	
	$.init = function (api) {
		$.barAPI = api;
		
		var Branding = $.importModule("branding");
		
		$.branding = new Branding("facebook");
		
		$.branding.onbrandingchange = function () {
			$.log("branding changed");
		};
		
		$.importModule("facebook.settings");
		$.importModule("facebook.utils");
		$.importModule("facebook.notify");
		$.importModule("facebook.ui");
		$.importModule("facebook.api");
		$.importModule("facebook.counters");
		$.importModule("facebook.navigate");
		
		try {
			$.importModule("tests");
		} catch (e) {
		}
		$.start();
	};
	
	
	$.finalize = function () {
		$.saveCredentials();
		$.notify("finalize");
	};
	
	$.start = function () {
		var urlRx = /^https?:\/\/([a-z-]+\.)?facebook\.com/i;
		var timeStart = (new Date()).valueOf();
		
		this.pageLoadHandler = {
			observe: function(x, y, url) {
				var ts = (new Date()).valueOf();
				if (ts < timeStart + 4000) {
					return;
				}
			
				url = url.url;
				url = url.spec || url;
				if (urlRx.test(url)) {
					var cook = $.FB.hasUserCookie();
					var cr = !!($.FB._credentials && $.FB._credentials.access_token);
					
					if (cook != cr) {
						if (cr) {
							$.forgetToken();
						} else {
							$.FB.loginByCookie(function(p) {
								$.saveCredentials();
								$.counters.start();
							});
						}
					}
				}
			}
		};
	
		var cook = $.FB.hasUserCookie();
		
		
		if ($.loadCredentials()) {
			if (!cook) {
				$.forgetToken();
			} else {
				$.counters.start();
			}
		} else {
			if (cook) {
				$.FB.loginByCookie(function(p) {
					$.saveCredentials();
					$.counters.start();
				});
			}
		}
	};
	
	$.connect = function () {
		var connectCB = new application.utils.CallbackObject(
			function () {
				$.saveCredentials();
				$.counters.start();
				$.openFacebookPage("main");
			},
			function (error) {
				$.log("not connected");
			}
		);
		
		$.FB.connect(connectCB);
	};
	
	$.saveCredentials = function () {
		$.log("save credentials");
		var StorableObject = $.importModule("StorableObject");
		var credentials = new StorableObject("credentials.json");
		credentials.user1 = $.FB._credentials;
		credentials.__save__("credentials.json");
	};
	
	$.loadCredentials = function () {
		$.log("load credentials");
		var StorableObject = $.importModule("StorableObject");
		var credentials = new StorableObject("credentials.json");
		var user1 = credentials.user1;
		if (user1 && user1.access_token) {
			$.log("user1 = " + user1);
			$.FB._setCredentials(user1);
			return true;
		}
		return false;
	};
	
	$.forgetToken = function () {
		var StorableObject = $.importModule("StorableObject");
		var credentials = new StorableObject("credentials.json");
		$.FB._setCredentials(undefined);
		$.saveCredentials();
		$.setCounterData({
			loggedIn: false
		});
		$.FB.deleteUserCookie();
	};
	
	$.counterData = {
		loggedIn: false
	}
};

Application.prototype = {
	widget_name: "ru.yandex.bar.facebook",
	settings_file: "settings.json",

	importModule: function (module) {
		var path = this.barAPI.Package.resolvePath("/modules/" + module + ".jsm"),
			scope = {};
		this.log("import " + module);
		Components.utils.import(path, scope);
		return scope.module(this);
	},
	
	log: function (f) {
		var cs = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService),
			log = function (text) { return cs.logStringMessage("facebook: " + text) },
			empty = function () {};
		return f ? log : empty;
	}(DEBUG), //XXX {true, false}
	
	toString: function () {
		return "[Application " + this.widget_name + "]";
	}
}

var application = new Application();
var core = application.xbCore;
var resources = {
	browser: {
		styles: ["/content/global-styles.css"]
	}
};