EXPORTED_SYMBOLS = ["module"];

var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var module = function (application) {
	var log = function (text) {
		application.log("navigate: " + text);
	};
	
	var pages = {
		main: "http://www.facebook.com/home.php",
		profile: "http://www.facebook.com/profile.php?id=",
		news: "http://www.facebook.com/home.php?sk=nf",
		wall: "http://www.facebook.com/profile.php?id=${uid}&sk=wall",
		friends: "http://www.facebook.com/friends/",
		friendRequests: "http://www.facebook.com/friends/edit/?sk=requests",
		friend_request: "http://www.facebook.com/friends/edit/?sk=requests",
		messages: "http://www.facebook.com/messages/",
//		message_thread: "http://www.facebook.com/messages/?action=read&tid=${thread_id}", // see thread_id unified_messages
		message_thread: "http://www.facebook.com/messages/",
//		messages_modern: "http://www.facebook.com/home.php?sk=inbox",
//		message_thread_modern: "http://www.facebook.com/home.php?sk=inbox",
		notifications: "http://www.facebook.com/notifications.php",
		notification: "http://www.facebook.com/notifications.php",
		photos: "http://www.facebook.com/home.php?sk=media",
		videos: "http://www.facebook.com/home.php?sk=video",
		media: "http://www.facebook.com/home.php?sk=media",
		notes: "http://www.facebook.com/notes/",
		groups: "http://www.facebook.com/groups/",
		events: "http://www.facebook.com/events/"
	};
	
	application.openFacebookPage = function (page, data, tabBehavior /** undefined, "current tab", "new tab", "new window", "new popup"*/) {

//		if (page == "messages" && application.barAPI.Settings.getValue("use-modern-messaging")) {
//			page = "messages_modern";
//		}
//		if (page == "message_thread" && application.barAPI.Settings.getValue("use-modern-messaging")) {
//			page = "message_thread_modern";
//		}
		
		var url = pages[page];
		
		
		var defaults = {};
		try {
			defaults.uid = application.counterData.user.uid;
		} catch(e) {
			
		}
		
		url = url.replace(/\$\{(.*?)\}/, function () {
			var key = arguments[1];
			var res;
			if (data && data[key]) {
				res = data[key];
			} else {
				res = defaults[key];
			}
			
			return res || "";
		});
		
		if (url) {
			log(["Open Facebook page =", page].join(" "));
			application.barAPI.Controls.navigateBrowser({
				url: url,
				target: tabBehavior
			});
		} else {
			log(["Page", page, "is not registered"].join(" "));
		}
	}
	
	// default open-page listener
	var navigateObserver = {
		observe: function (subj, topic, message) {
			if (topic == "facebook-open-page") {
				application.openFacebookPage(message);
			}
		}
	}
	
	observerService.addObserver(navigateObserver, "facebook-open-page", false);
}