EXPORTED_SYMBOLS = ["module"];

var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var module = function (application) {
	application.notify = function (data) {
		observerService.notifyObservers(application, "facebook", data);
	};
	
	var topics = ["facebook", "settings-changed", "facebook-open-page"];

	var defaultObserver = {
		QueryInterface: function () { return this; },
		observe: function (subject, topic, data) {
			application.log("observe: " + topic + ", " + data);
			if (data == "finalize") {
				detachDefaultObserver();
			}
		}
	};

	function attachDefaultObserver () {
		for each (var topic in topics) {
			observerService.addObserver(defaultObserver, topic, false);
		}
	}
	
	function detachDefaultObserver () {
		for each (var topic in topics) {
			observerService.removeObserver(defaultObserver, topic);
		}
	}
	
	attachDefaultObserver();
}