EXPORTED_SYMBOLS = ["module"];

var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var module = function (application) {
	var settings_api = application.barAPI.Settings;
	var log = function (text) {
		return application.log("[settings] " + text);
	};
	
	var settingsListener = {
		onSettingChange: function (name, value) {
			var data = {};
			data[name] = value;
			observerService.notifyObservers(application, "settings-changed", JSON.stringify(data));
		}
	};
	
	settings_api.observeChanges(settingsListener);
	
}