EXPORTED_SYMBOLS = ["module"];

var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
var WW = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(Components.interfaces.nsIWindowWatcher);

var module = function (application) {
	var log = function (text) {
		return application.log("ui: " + text);
	};
	
	application.ui = {
		MICROBROWSER_PATH: application.barAPI.Package.resolvePath("/content/microbrowser/microbrowser.xul"),
		MICROBROWSER_WINDOW_NAME: "facebook:browser",
		
		openMicrobrowser: function (features, arguments) {
			var window = application.ui.getTopBrowserWindow(),
				browserWindow,
				inject = function () {
					window.close = function () {
						var evt = document.createEvent("Event");
						evt.initEvent("CloseMicrobrowser", true, false);
						document.documentElement.dispatchEvent(evt);
					}
				},
				
				defaultArguments = {
					inject: function (document) {
						var location = document.location;
						if (location.toString().indexOf("http") !== 0) return;
						var script = document.createElement("script");
						script.innerHTML = inject.toSource() + "()";
						document.addEventListener("CloseMicrobrowser", function () {
							browserWindow.close();
						}, false, true);
						document.documentElement.appendChild(script);
					}
				};
			
			application.utils.mix(arguments, defaultArguments);
			browserWindow = window.openDialog(application.ui.MICROBROWSER_PATH, application.ui.MICROBROWSER_WINDOW_NAME, features, arguments);
			return browserWindow;
		},
		
		openHiddenMicrobrowser: function (features) {
			return function (arguments) {
				return application.ui.openMicrobrowser(features, arguments);
			}
		}("titlebar=no,width=0,height=0,left=10,top=-20"), 
		
		getTopBrowserWindow: function () {
			return application.ui.getTopWindowOfType("navigator:browser");
		},
		
		getTopWindowOfType: function (windowType) {
			return WM.getMostRecentWindow(windowType);
		},
		
		showThrobblerForMenuItem: function (item) {
			while (item) {
				if (/\b(:?xul:)?toolbarbutton\b/.test(item.tagName)) {
					break;
				}
				item = item.parentNode;
			}
			
			if (item) {
				application.notify('throbber-' + item.getAttribute('anonid'));
			//	item.setAttribute("fbUpdating", "true");
			}
		},
		
		showSharePage: function () {
			try {
				var currentUrl = application.ui.getTopBrowserWindow().gBrowser.contentDocument.defaultView.location;
			} catch (e) {
				return;
			}
			var url = application.FB.getSharePageUrl(currentUrl);
			var postPageFeatures = "centerscreen,resizable,width=810,height=610";
			var browserWindow;
			browserWindow = application.ui.openMicrobrowser(postPageFeatures, {
				url: url,
				title: "&facebook.dialog.share.title;"
			})
		},
		
		showPostPage: function () {
			var url = application.FB.getPostPageUrl();
			var redirectUrl = application.FB.getRedirectURI();
			var postPageFeatures = "centerscreen,resizable,width=1000,height=420";
			var browserWindow;
			var listener = application.utils.createLocationListener(
				function (callbacks, webProgress, status, location) {
					var spec = location.spec;
					if (spec.indexOf(redirectUrl) == 0) {
						browserWindow.close();
					}
				}
			);
			
			browserWindow = application.ui.openMicrobrowser(postPageFeatures, {
				url: url,
				title: "&facebook.dialog.post.title;",
				progressListener: new listener(),
				notifyMask: Components.interfaces.nsIWebProgress.NOTIFY_LOCATION
			});
		}
	};
}