"use strict";

var EXPORTED_SYMBOLS = ["module"];

var MAILRU_CLIENT_ID = "642290";
var MAILRU_PRIVATE_KEY = "675bf0e42caef0d1b1a7b8f903c40be2";
var MAILRU_SECRET_KEY = "337f8e24312e12f3c381e5dad1a4a562";

var APP_NAME = "ru.yandex.bar.mailru-widget";

var instances = [];

function module (proxy) {
	proxy.onmoduleunload = function () {
		proxy.logger.info("Finalizing MailruWidget instances");
		
		for (var i = 0,l = instances.length; i < l; ++i) {
			try {
				instances[i].finalize();
				delete instances[i];
			} catch (e) {
				var msg = "Error finalizing MailruWidget instance %i".replace("%i", i);
				proxy.logger.trace(msg);
				proxy.logger.error(e);
			}
		}
		
	};
	
	var Storage = proxy.module("utils.Storage");
	var utils = proxy.module("utils.common");
	var mailru_ns = proxy.module("API.mailru");
	var MailruActions = proxy.module("app.MailruActions");
	var CommandReceiver = proxy.module("utils.CommandReceiver");
	var WidgetManager = proxy.module("UI.WidgetManager");
	var Registry = proxy.module("sklib.Registry");
	var T = proxy.module("sklib.Template");
	
	/**
	 * @constructor
	 * @class MailruWidget
	 * @param {String} env
	 */
	var MailruWidget = function (env) {
		this._env = env || "production";
		this.name = APP_NAME;
		this.id = utils.generateRandomString(8);
		
		this.notifyTopic = this.name + "-" + this.id;
		
		proxy.api.logger.info(T("Creating application $name id $id, environment is $_env", this));
		
		
		this.state = this._initState("state.json");
		
		var appCredentials = {
			client_id: MAILRU_CLIENT_ID,
			private_key: MAILRU_PRIVATE_KEY,
			secret_key: MAILRU_SECRET_KEY
		};
		
		this.apiClient = new mailru_ns.APIClient(appCredentials, this.state.userCredentials);
		var mailruActions = new MailruActions(this.apiClient, this.state.data);
		this.ui = new WidgetManager(this, mailruActions);

		if (this.apiClient.connected) {
			//proxy.api.logger.debug('mailru mailruActions.update();');
			mailruActions.update();
		} else {
			if (utils.getCookie('Mpop', '.mail.ru')) {
				//proxy.api.logger.debug('mailru try auth by cookie');
				mailruActions.authByCookie();
			}
		}
		
		var apiClient = this.apiClient;

        // observe site authorization
        this._logoutObserver.init(
            mailru_ns.APIClient.LOGOUT_URL_REGEX,
			mailru_ns.APIClient.LOGIN_URL_REGEX,
            function (isLogin) {
				if (isLogin) {
					// +++++++++++
					
					
					var nsTimer = Components.classes['@mozilla.org/timer;1'];
					var nsITimer = Components.interfaces.nsITimer;
					var timer = nsTimer.createInstance(nsITimer);
					
					proxy.api.logger.debug('qqqq mailru AUTH timer.initWithCallback');
					
					timer.initWithCallback(function () {
						
							proxy.api.logger.debug('qqqq mailru AUTH!!!!!');
							mailruActions.authByCookie();
						
					}, 1400, nsITimer.TYPE_ONE_SHOT);
					
					
				} else {
					mailruActions.logout(true);
				}
            }
        );
        this._observerService.addObserver(this._logoutObserver, 'http-on-modify-request', false);
	};
	
	MailruWidget.prototype = {
		_initState: function (filename) {
			var state = new Storage(filename);
			
			if (!state.data) {
				state.data = {};
			}
		
			if (!state.userCredentials) {
				state.userCredentials = {};
			}
			
			return state;
		},
		

        _logoutObserver: {
            _logoutUrl: null,
			_loginUrl: null,
            _callback: function () {},

            init: function (urlRegexOut, urlRegexIn, callback) {
                this._logoutUrl = urlRegexOut;
				this._loginUrl = urlRegexIn;
                this._callback = callback;
            },

            observe: function(subject, topic, data) {
                if('http-on-modify-request' !== topic) {
                    return;
                }
                subject.QueryInterface(Components.interfaces.nsIHttpChannel);
                let url = subject.URI.spec;
                if (this._logoutUrl.test(url)) {
                    this._callback(false);
                } else {
					if (this._loginUrl.test(url)) {
						this._callback(true);
					}
				}
            }
        },

        __observerService: null,
        get _observerService() {
            return this.__observerService
                ? this.__observerService
                : this.__observerService = Components.classes["@mozilla.org/observer-service;1"]
                      .getService(Components.interfaces.nsIObserverService);
        },
		
		finalize: function () {
            // stop observing site authorization
            this._observerService.removeObserver(this._logoutObserver, 'http-on-modify-request');

            this.apiClient.finalize();
        }
	};
	
	return MailruWidget;
}
