"use strict";

var EXPORTED_SYMBOLS = ["module"];
var BROWSER_XUL = "/content/microbrowser/microbrowser.xul";
var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);

var empty = function () {};

var instances = [];

function module (proxy) {
	var package_api = proxy.api.Package;
	var utils = proxy.module("utils.common");
	
	proxy.onmoduleunload = function () {
		for (var i = 0, l = instances.length; i < l; ++i) {
			instances[i].close();
		}
	};
	
	var OAuthBrowser = function () {
		this.window = null;
		this.instanceIndex = instances.length;
		instances.push(this);
	};
	
	OAuthBrowser.prototype = {
		open: function (features, args) {
			proxy.logger.trace("Open OAuthBrowser");
			
			var _this = this;
			var window = WM.getMostRecentWindow("navigator:browser"),
				inject = function () {
					window.close = function () {
						var evt = document.createEvent("Event");
						evt.initEvent("CloseMicrobrowser", true, false);
						document.documentElement.dispatchEvent(evt);
					}
				};
			
			var progressListener = {
				QueryInterface: function (aIID) {
					if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
						aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
						aIID.equals(Components.interfaces.nsISupports)) {
							return this;
					} else {
						throw Components.results.NS_NOINTERFACE;
					}
				},
				
				onStateChange: function () {
					if (_this.onstatechange) {
						return _this.onstatechange.apply(_this, arguments);
					}
				},
				
				onLocationChange: empty,
				onProgressChange: empty,
				onSecurityChange: empty,
				onStatusChange: empty
			};
			
			var defaultArguments = {
					inject: function (document) {
						var location = document.location;
						if (location.toString().indexOf("http") !== 0) return;
						var script = document.createElement("script");
						script.innerHTML = inject.toSource() + "()";
						document.addEventListener("CloseMicrobrowser", function () {
							browserWindow.close();
						}, false, true);
						document.documentElement.appendChild(script);
					},
					
					notifyMask: Components.interfaces.nsIWebProgress.NOTIFY_ALL,
					progressListener: progressListener,
					
					onclose: function () {
						if (_this.onclose) {
							return _this.onclose.apply(_this, arguments);
						}
					}
				};
			
			args = utils.mix(args, defaultArguments);
			this.window = window.openDialog(package_api.resolvePath(BROWSER_XUL), "microbrowser", features, args); // "microbrowser"
			return this.window;
		},
		
		close: function () {
			proxy.logger.trace("Closing OAuthBrowser");
			
			this.window && this.window.close();
		}
	};
	
	return OAuthBrowser;
}