"use strict";

var EXPORTED_SYMBOLS = ["module"];

var OS = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
var nsTimer = Components.classes["@mozilla.org/timer;1"];
var nsITimer = Components.interfaces.nsITimer;

function module (proxy) {
	var settings = proxy.module("bar.settings");
	var T = proxy.module("sklib.Template");
	
	var WidgetManager = function (application, actionExecutor) {
		var _this = this;
		
		this._application = application;
		this._executor = actionExecutor;
		this.wiid = null;
		this._executor.setUIManager(this);
		this.displayData = {};
		
		this.uiSettingsKeys = ["show-compose-button", "show-main-button-title", "show-compose-button-title"];
		
		settings.addListener(function (topic, name, value) {
			if (_this.uiSettingsKeys.indexOf(name) !== -1) {
				_this.display();
			}
		});
		
		this.syncSettingsData();
	};
	
	WidgetManager.APPLICATION_NAME_ATTRIBUTE = "yb-native-widget-application-name"; // used for binding 
	WidgetManager.APPLICATION_TOPIC_ATTRIBUTE = "yb-native-widget-application-topic";
	
	WidgetManager.prototype = {
		constructor: WidgetManager,
		
		executeUIAction: function (command) {
			this._executor.execute(command);
		},
		
		executeUIActionAsync: function (command) {
			var _this = this;
			var timer = nsTimer.createInstance(nsITimer);
			var args = arguments;
			
			timer.initWithCallback(function () {
				_this.executeUIAction.apply(_this, args);
			}, 0, nsITimer.TYPE_ONE_SHOT);
		},
		
		display: function (data) {
			if (data) {
				this.displayData = data;
			}
			
			proxy.logger.trace(T("Display data = $0", [JSON.stringify(this.displayData)]));
			
			this.syncSettingsData();
			OS.notifyObservers(null, this._application.notifyTopic, "display");
		},
		
		showThrobber: function () {
			proxy.logger.trace("showThrobber");
			OS.notifyObservers(null, this._application.notifyTopic, "throbber");
		},
		
		syncSettingsData: function () {
			this.settingsData = this.getUISettings();
		},
		
		getUISettings: function () {
			var settingsObj = {};
			
			for each (var key in this.uiSettingsKeys) {
				settingsObj[key] = settings.getValue(key);
			}
			
			return settingsObj;
		},
		
		buildWidget: function (WIID, toolbaritem) {
			proxy.logger.trace(T("Build widget $0", [WIID]));
			
			this.wiid = WIID;
			toolbaritem.widgetManager = this;
			toolbaritem.proxy = proxy;
			
			toolbaritem.setAttribute(WidgetManager.APPLICATION_TOPIC_ATTRIBUTE, this._application.notifyTopic);
			toolbaritem.setAttribute(WidgetManager.APPLICATION_NAME_ATTRIBUTE, this._application.name); // init binding
		},
		
		destroyWidget: function (WIID, toolbaritem) {
			proxy.logger.trace(T("Destroy widget $0", [WIID]));
			
			if (typeof toolbaritem.destroyWidget !== "undefined") {
				toolbaritem.destroyWidget();
			}

			toolbaritem.removeAttribute(WidgetManager.APPLICATION_NAME_ATTRIBUTE); // rollback binding
			toolbaritem.removeAttribute(WidgetManager.APPLICATION_TOPIC_ATTRIBUTE);
			
			delete toolbaritem.proxy;
			delete toolbaritem.widgetManager;
			
			proxy.logger.trace(T("Destroy widget $0 done", [WIID]));
		}
	};
	
	return WidgetManager;
}