"use strict";

var EXPORTED_SYMBOLS = ["core", "resources"];
var APP_MODULE = "MailruWidget";
var ENVIRONMENT = "${config.environment}";
var MODULES_PATH = "/js";
var MODULE_NAME_SUFFIX = ".js";
var MODULE_ENCODING = "UTF-8";
var MODULES_CAN_UNLOAD = typeof Components.utils.unload !== "undefined";
var scriptLoader = Components.classes["@mozilla.org/moz/jssubscript-loader;1"].getService(Components.interfaces.mozIJSSubScriptLoader);

var modules = {};

function createModuleImporter (api) {
	var logger = api.logger;
	var module;

	function callUnloadHandler (name) {
		var moduleWrapper =  modules[name];
		try {
			logger.trace("Execute unload handler in module " + name);
			moduleWrapper.proxy.onmoduleunload();
		} catch (e) {
			var messageTemplate = "Error executing unload handler in module \"%s\". See next message for details:";
			logger.trace(messageTemplate.replace("%s", name));
			logger.error(e);
		}
	}
	
	function unloadModule (name) {
		logger.trace("Unloading module " + name);
		if (MODULES_CAN_UNLOAD) {
			Components.utils.unload(modules[name].path);
		}
		
		delete modules[name];
	}
	
	function unloadAllModules() {
		for (var moduleInstance in modules) {
			if (modules.hasOwnProperty(moduleInstance)) {
				callUnloadHandler(moduleInstance);
			}
		}
		for (var moduleInstance in modules) {
			if (modules.hasOwnProperty(moduleInstance)) {
				unloadModule(moduleInstance);
			}
		}
		
		logger.trace("Garbage collect");
		
		if (typeof Components.utils.schedulePreciseGC !== "undefined") {
			Components.utils.schedulePreciseGC(function () {
				logger.trace("Garbage collect done");
			});
		} else {
			Components.utils.forceGC();
			logger.trace("Garbage collect done");
		}
	}

	function getModuleWrapper (name) {
		var pathDelimiter = "/";
		var classDelimiter = /\./g;
		var packagePath = [MODULES_PATH, name.replace(classDelimiter, pathDelimiter) + MODULE_NAME_SUFFIX].join(pathDelimiter);
		var xbPath = api.Package.resolvePath(packagePath);
		var scope = {};
		
		try {
			scriptLoader.loadSubScript(xbPath, scope, MODULE_ENCODING);
		} catch (e) {
			var messageTemplate = "Error loading module \"%s\". See next message for details:"
			
			api.logger.trace(messageTemplate.replace("%s", name));
			api.logger.error(e);
		}
		
		return {
			path: xbPath,
			module: scope.module
		}
	}

	var ModuleProxy = function (name) {
		this._moduleName = name;
	};
	
	ModuleProxy.prototype = {
		constructor: ModuleProxy,
		onmoduleunload: function () {},
		logger: logger,
		api: api
	};
	
	
	module = function (name) {
		if (!modules.hasOwnProperty(name)) {
			logger.trace("Loading module " + name);
			
			var wrapper = getModuleWrapper(name);
			var proxy = new ModuleProxy(name);
			
			try {
				var moduleBody = wrapper.module.call({}, proxy);
	
				modules[name] = {
					path: wrapper.path,
					module: moduleBody,
					proxy: proxy
				};
			} catch (e) {
				var logMsg = "Error loading module \"%name\". See next message for details:".replace("%name", name);
				logger.trace(logMsg);
				logger.error(e);
			}
		} else {
			// logger.trace("Module %name already loaded".replace("%name", name));
		}
		
		return modules[name].module;
	}
	
	ModuleProxy.prototype.module = module;
	
	module.unloadAll = unloadAllModules;
	return module;
}

var application; 
var module;
var api;

var core = {
	init: function (barApi) {
		api = barApi;
		
		try {
			module = createModuleImporter(api);
			var Application = module(APP_MODULE);
			application = new Application(ENVIRONMENT);
		} catch (e) {
			var message = "Error creating application \"%s\". See next message for details:";
			api.logger.trace(message.replace("%s", APP_MODULE));
			api.logger.error(e);
		}
	},
	
	buildWidget: function (WIID, toolbaritem) {
		application.ui.buildWidget(WIID, toolbaritem);
	},
	
	destroyWidget: function (WIID, toolbaritem) {
		application.ui.destroyWidget(WIID, toolbaritem);
	},
	
	finalize: function () {
		module.unloadAll();
	}
};

var resources = {
	browser: {
		styles: ["/content/global-styles.css"]
	}
};