"use strict";

var EXPORTED_SYMBOLS = ["module"];

var keyPrefix = "key:";
var storage = {};

function module(proxy) {
	var RegistryWrapper = function () {
		var storage = {};
		
		var Registry = function () {
			this.setItem = function (key, value) {
				var trueKey = keyPrefix + key;
				if (typeof value == "undefined") {
					delete storage[trueKey];
				} else {
					storage[trueKey] = value;
				}
				return this;
			};
			
			this.getItem = function (key) {
				var trueKey = keyPrefix + key;
				return storage[trueKey];
			};
		};
		
		return new Registry();
	};
	
	RegistryWrapper.setItem = function (key, value) {
		var trueKey = keyPrefix + key;
		if (typeof value == "undefined") {
			delete storage[trueKey];
		} else {
			storage[trueKey] = value;
		}
		return this;
	};
	
	RegistryWrapper.getItem = function (key) {
		var trueKey = keyPrefix + key;
		if (storage.hasOwnProperty(trueKey)) {
			return storage[trueKey];
		} else {
			return;
		}
	};
	
	return RegistryWrapper;
}