"use strict";

var EXPORTED_SYMBOLS = ["module"];
var OS = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var instances = {};

function module(proxy) {
	proxy.onmoduleunload = function () {
		for (var instance in instances) {
			if (instances.hasOwnProperty(instance)) {
				instances[instance].disconnect();
			}
		}
	};
	
	var CommandReceiver = function (channel) {
		if (instances.hasOwnProperty(channel)) {
			return instances[channel];
		};
		
		instances[channel] = this;
		
		var _this = this;
		this._topic = channel;
		this._connected = false;
		this._handlers = {};
		this._observer = {
			observe: function (s, t, d) {
				var message;
				
				try {
					message = JSON.parse(d);
				} catch (e) {
					proxy.logger.trace("Failed to parse " + _this.topic +" data");
					proxy.logger.error(e);
				}
				
				if (message) {
					_this.executeHandlers(message);
				}
			}
		};
		
		this.connect();
	};
	
	CommandReceiver.prototype = {
		addHandler: function (topic, handler) {
			if (!this._handlers.hasOwnProperty(topic)) {
				this._handlers[topic] = [];
			}
			
			var handlers = this._handlers[topic];
			
			if (handlers.indexOf(handler) == -1) {
				handlers.push(handler);
			}
			
			return this;
		},
		
		removeHandler: function (topic, handler) {
			var handlers = this._handlers[topic];
			var index = handlers.indexOf(handler);
			
			if (index !== -1) {
				handlers.splice(index);
			}
			
			return this;
		},
		
		executeHandlers: function (message) {
			for (var topic in message) {
				if (message.hasOwnProperty(topic)) {
					this.executeHandlersByTopic(topic, message[topic]);
				}
			}
		},
		
		executeHandlersByTopic: function (topic, data) {
			var handlers = this._handlers[topic];
			
			if (handlers) {
				for (var i = 0, l = handlers.length; i < l; ++i) {
					try {
						handlers[i].call({}, data);
					} catch (e) {
						proxy.logger.trace("Error executing handler " + i + " from " + topic + " topic");
						proxy.logger.error(e);
					}
				}
			}
		},
		
		connect: function () {
			if (!this._connected) {
				proxy.logger.trace("Connect CommandReceiver with topic " + this._topic);
				
				this._connected = true;
				OS.addObserver(this._observer, this._topic, false);
			}
		},
		
		disconnect: function () {
			if (this._connected) {
				proxy.logger.trace("Disconnect CommandReceiver with topic " + this._topic);
				
				this._connected = false;
				OS.removeObserver(this._observer, this._topic);
			}
		}
	};
	
	return CommandReceiver;
}