"use strict";

var EXPORTED_SYMBOLS = ["module"];
var OS = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var instances = {};

function module (proxy) {
	proxy.onmoduleunload = function () {
		for (var channel in instances) {
			if (instances.hasOwnProperty(channel)) {
				delete instances[channel];
			}
		}
	};
	
	var CommandTransmitter = function (channel) {
		if (instances[channel]) {
			return instances[channel];
		}
		
		this._topic = channel;
		instances[channel] = this;
	};
	
	CommandTransmitter.prototype = {
		execCommand: function (topic, data) {
			var message = {};
			message[topic] = data;
			OS.notifyObservers({}, this._topic, JSON.stringify(message));
		}
	};
	
	return CommandTransmitter;
}