"use strict";

var EXPORTED_SYMBOLS = ["module"];

var instances = {};

function module (proxy) {
	var file_api = proxy.api.Files;
	
	proxy.onmoduleunload = function () {
		proxy.logger.trace("Saving all storage instances");
		
		for (var instance in instances) {
			instances[instance].__save__();
			delete instances[instance];
		}
	};
	
	var StorageWrapper = function (filename) {
		if (!instances[filename]) {
			var Storage = new Function;
			
			Storage.prototype = {
				constructor: Storage,
				__save__: function () {
					var storage = file_api.getWidgetStorage(true),
						storageData = JSON.stringify(this);
					
					storage.append(filename);
					file_api.writeTextFile(storage, storageData);
					
					return this;
				},
				__load__: function () {
					var storage = file_api.getWidgetStorage(true);
					storage.append(filename);
					try {
						var storageText = file_api.readTextFile(storage),
							storageObj = JSON.parse(storageText);
						for (var key in storageObj) {
							if (storageObj.hasOwnProperty(key)) {
								this[key] = storageObj[key];
							}
						}
					} catch (e) {
						//proxy.logger.trace('Failed loading storage data from "' + filename + '".');
					}
					
					return this;
				}
			};
			
			var instance = (new Storage()).__load__();
			
			instances[filename] = instance;
		}
		
		return instances[filename];
	};
	
	StorageWrapper.prototype = {
		constructor: StorageWrapper
	};
	
	return StorageWrapper;
}