"use strict";

var EXPORTED_SYMBOLS = ["module"];

var nsScriptableUnicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"];
var nsIScriptableUnicodeConverter = Components.interfaces.nsIScriptableUnicodeConverter;

var nsHash = Components.classes["@mozilla.org/security/hash;1"];
var nsICryptoHash = Components.interfaces.nsICryptoHash;

var	commonUtils = {};

/**
 * Генерация случайной строки
 * @param {Number} length
 * @return {String}
 */
commonUtils.generateRandomString = function (length) {
	var code,
		result = Array(length);
	
	for (var i = 0; i < length; ++i) {
		code = 48 + Math.floor(Math.random() * 62);
		if (code > 0x39) code += 7;
		if (code > 0x5A) code += 6;
		result[i] = String.fromCharCode(code);
	}
	
	return result.join("");
};

/**
 * Очистка URL от протокола и параметров
 * @param {} url
 */
commonUtils.sanitizeURL = function (url) {
	var empty = "",
	    protocol = /.*?:\/\//,
	    params = /\?.*$/,
	    hash = /#.*$/;
	
	return url.replace(protocol, empty).replace(params, empty).replace(hash, empty);
}

/**
 * Сравнение URL без параметров и протокола
 */
commonUtils.callbacksMatch = function (base, callback) {
	return commonUtils.sanitizeURL(callback).indexOf(commonUtils.sanitizeURL(base)) == 0;
};

commonUtils.duplicate = function (x) { // he-he-he, dirty
	return JSON.parse(JSON.stringify(x));
};
		
commonUtils.mix = function mix(a, b) {
	var r = commonUtils.duplicate(a);
	
	for (var i in b) {
		if (!b.hasOwnProperty(i)) {
			continue;
		}
		
		var data = b[i],
			mixin;
		
		if (i in a) {
			switch (typeof data) {
				case "object":
					mixin = mix(a[i], data);
					break;
			
				default: 
					mixin = b[i];
			}
			
			r[i] = mixin;
		} else {
			r[i] = data;
		}
	}
	
	if (arguments.length > 2) {
		var argsArr = Array.prototype.slice.call(arguments, 2);
		argsArr.unshift(r);
		r = mix.apply(this, argsArr);
	}
	
	return r;
};

commonUtils.obj2UrlParams = function (obj, encode) {
	var value = "",
		keyText,
		res = [],
		noencode = (encode === false),
		keys = [];
	
	for (var key in obj) {
		if (obj.hasOwnProperty(key)) {
			keys.push(key);
		}
	}

	keys.sort();
	
	for (var key, i = 0, l = keys.length; i < l; ++i) {
		key = keys[i];
		value = noencode ? obj[key] : commonUtils.encodeURIComponent(obj[key]);
		keyText = noencode ? key : commonUtils.encodeURIComponent(key);
		res.push(keyText + "=" + value);
	}
	
	return res.join("&");
};
		
commonUtils.obj2HeaderParams = function (obj) {
	var res = [], key, value, d1="", d2 = ", ";
	
	for (key in obj) {
		if (!obj.hasOwnProperty(key)) continue;
		value = commonUtils.encodeURIComponent(obj[key]);
		res.push([commonUtils.encodeURIComponent(key), "=\"", value, "\""].join(d1));
	}
	return res.join(d2);
};
		
commonUtils.urlParams2Obj = function (urlParams, decode) {
	var res = {},
		nodecode = (decode === false);
	
	if (!urlParams || urlParams.length == 0) {
		return res;
	}
	
	var params = urlParams.split("&");
	for (var i = 0, l = params.length; i < l; ++i) {
		var kv = params[i].split("=");
		var key = kv[0], value = kv[1];
		
		key = nodecode ? key : commonUtils.decodeURIComponent(key);
		res[key] = nodecode ? value : commonUtils.decodeURIComponent(value);
	}
	return res;
};

commonUtils.encodeURIComponent = function (str) {
	return encodeURIComponent(str).replace(/[!'\(\)\*]/g, function (x) {
		return "%" + ("0" + x.charCodeAt(0).toString(16)).slice(-2).toUpperCase();
	});
};
		
commonUtils.decodeURIComponent = function (str) {
	str = str || "";
	return decodeURIComponent(str.replace(/\+/g, '%20'));
};

commonUtils.digest = function (algo, str) {
	function toHexString(charCode) {
		return ("0" + charCode.toString(16)).slice(-2);
	}
	var converter = nsScriptableUnicodeConverter.createInstance(nsIScriptableUnicodeConverter);
	converter.charset = "UTF-8";
	var t = {};
	var data = converter.convertToByteArray(str, t);
	var ch = nsHash.createInstance(nsICryptoHash);
	var init;
	switch (algo) {
		case "md5":
			init = ch.MD5;
			break;
		case "sha1": 
			init = ch.SHA1;
			break;
	}
	ch.init(init);
	ch.update(data, data.length);
	var hash = ch.finish(false);
	var s = [];
	for (var i = 0, l = hash.length; i < l; ++i) {
		s.push(toHexString(hash.charCodeAt(i)));
	}
	
	return s.join("");			
};

commonUtils.getCookie = function (name, host){
	var cookieMgr = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
	for (var e = cookieMgr.enumerator; e.hasMoreElements();) {
		var cookie = e.getNext().QueryInterface(Components.interfaces.nsICookie);
		if(cookie.name == name && cookie.host == host) { return cookie.value || ''; }
	}
	return '';
};

function module(proxy) {
	return commonUtils;
}

/*
const EXPORTED_SYMBOLS = ["module"];

var HTTPRequest = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"];

var module = function (application) {
	function log(text) {
		return application.log("utils: " + text);
	}
	
			
	var CallChain = function () {
		var nodes = [];
		var results = [];
		var currentNode = 0;
		var currentWatcher = null;
		var executing = false;
		var aborted = false;
		
		this.addNode = function (fn) {
			nodes.push(fn);
			return this;
		};
		
		this.removeNode = function (fn) {
			for (var i = 0, l = nodes.length; i < l; ++i) {
				if (nodes[i] === fn) {
					delete nodes[i];
					nodes.splice(i, 1);
					break;
				}
			}
			return this;
		};
		
		this.getResults = function () {
			return results;
		};
		
		this.execute = function (finalCallbacks) {
			currentNode = 0;
			aborted = false;
			results = [];
			executing = true;
			
			var watcher = {
				abort: function () {
					log("abort chain");
					aborted = true;
					currentWatcher && currentWatcher.abort && currentWatcher.abort();
				}
			}
			
			var executor = function executor(result) {
				var node = nodes[currentNode];
				results[currentNode] = result;
				
				if (aborted) {
					return;
				}

				if (node) {
					currentNode++;
					currentWatcher = node.call({}, new CallbackObject(executor, finalCallbacks.error));
				} else {
					currentNode = 0;
					executing = false;
					finalCallbacks.success.apply({}, arguments);
				}
			}
			
			executor();
			return watcher;
		}
	};

	application.utils = {
		createLocationListener: function (changeListener) {
			var progressListener = function (callbacks) {
				var $ = this, empty = function (){};
			
				$.QueryInterface = function (aIID) {
					if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
						aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
						aIID.equals(Components.interfaces.nsISupports)) {
							return this;
					} else {
						throw Components.results.NS_NOINTERFACE;
					}
				}	
				
				$.onLocationChange = function (aWebProgress, aRequest, aLocation) {
					return changeListener.call(this, callbacks, aWebProgress, aRequest, aLocation);
				}
				$.onProgressChange = empty;
				$.onSecurityChange = empty;
				$.onStateChange = empty;
				$.onStatusChange = empty;
			};
			return progressListener;
		},

		createStateListener: function (listener) {
			var progressListener = function (callbacks) {
				var $ = this, empty = function (){};
			
				$.QueryInterface = function (aIID) {
					if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
						aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
						aIID.equals(Components.interfaces.nsISupports)) {
							return this;
					} else {
						throw Components.results.NS_NOINTERFACE;
					}
				}	
				
				$.onLocationChange = empty;
				$.onProgressChange = empty;
				$.onSecurityChange = empty;
				$.onStateChange = function (a, b, c, d) {
					return listener.call(this, callbacks, a, b, c, d);
				};
				$.onStatusChange = empty;
			};
			return progressListener;
		},
		
		
		escapeXML: function (text) {
			if (typeof text !== "string") {
				return text;
			}
			
			return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
		},

		CallbackObject: CallbackObject,
		CallChain: CallChain,
		
	}
}
*/