const EXPORTED_SYMBOLS = ["core", "resources"];

const {
	classes: Cc,
	interfaces: Ci,
	results: Cr,
	utils: Cu
} = Components;

const resources = {
	browser: {
		styles: ["mcstyles.css"],
		urlBarItems: {button : 10100}
	}
};

function MCCore() {

	var $ = this;

	$.xbCore = {
		init: function xbCore_init(api) {
			this.api = api;
			$.init(api);
		},

		finalize: function xbCore_finalize() {
			$.finalize();
		},

		initURLBarItem: function xbCore_initURLBarItem(itemElement, itemClass) {
			$.urlBarItem = new $.URLBarItem(itemElement, itemClass, $);
			return $.urlBarItem;
		}
	};
	
	$.URLBarItem = function MCCore_URLBarItem(itemElement, itemClass, module) {
		itemElement.module = module;
		itemElement.setAttribute("native-widget-name", module.widget_name);
		this.itemElement = itemElement;
	};

	$.URLBarItem.prototype = {
		finalize: function URLBarItem_finalize() {
			this.itemElement.wdgtxDestructor();
			delete this.itemElement;
		} 
	}; 

	$.init = function MCCore_init(api) {
		$.api = api;
	};

	$.finalize = function MCCore_finalize() {
		$._saveConfig();
		$._saveWhitelist();
		$.__config = null;
		$.__whitelist = null;
	};

	$._copyDefaultConfig = function MCCore__copyDefaultConfig(fromFile, toFile) {
		$.api.Files.writeStreamToFile($.api.Package.getFileInputChannel(fromFile).contentStream, toFile);
	};

	$._loadConfigHelper = function MCCore__loadConfigHelper(fileName) {
		let packageFile = "data/" + fileName;
		let configFile = $.api.Files.getWidgetStorage(true);
		configFile.append(fileName);
		if (!configFile.exists()) {
			$._copyDefaultConfig(packageFile, configFile);
		}
		return $.api.XMLUtils.xmlDocFromFile(configFile);
	}

	$._loadConfig = function MCCore__loadConfig() {
		return $._loadConfigHelper("config.xml");
	};

	$.getConfig = function MCCore_getConfig() {
		if ($.__config == null)
			$.__config = $._loadConfig();
		return $.__config;
	};

	$._loadWhitelist = function MCCore__loadWhitelist() {
		return $._loadConfigHelper("whitelist.xml");
	}

	$.getWhitelist = function MCCore_getWhitelist() {
		if ($.__whitelist == null)
			$.__whitelist = $._loadWhitelist();
		return $.__whitelist;
	};

	$.getLocalizedString = function MCCore_getLocalizedStrings(name) {
		if ($.__bundle == null) {
			$.__bundle = Cc["@mozilla.org/intl/stringbundle;1"]
							.getService(Ci.nsIStringBundleService)
							.createBundle($.api.Package.resolvePath("strings.properties"));
		} 
		return $.__bundle.GetStringFromName(name);
	};
	
	$.getNavigateLink = function MCCore_getNavigateLink(from) {
		let xml = $.getConfig();
		let subjectResult = $.api.XMLUtils.queryXMLDoc("string(/config/rules/rule[@id='" + encodeURIComponent(from) + "']/@value)", xml);
		if (subjectResult == null || subjectResult == "")
			return null;
		return decodeURIComponent(subjectResult);
	};

	$._saveConfig = function MCCore__saveConfig() {
		let configFile = $.api.Files.getWidgetStorage(true);
		configFile.append("config.xml");
		$._saveXMLToFile($.getConfig(), configFile);
	};

	$._saveWhitelist = function MCCore__saveWhitelist() {
		let whitelistFile = $.api.Files.getWidgetStorage(true);
		whitelistFile.append("whitelist.xml");
		$._saveXMLToFile($.getWhitelist(), whitelistFile);
	};

	$._normalizeHostnameHelper = function MCCore__normalizeHostnameHelper(host) {
		if ((host != null ) && (host.indexOf("http://") == 0))
			return host.substr(7, host.length);
		return host;
	}

	$.appendRule = function MCCore_appendRule(from, to) {
		$.clearWhitelist(from);

		from = $._normalizeHostnameHelper(from);
		let rules = $.api.XMLUtils.queryXMLDoc("/config/rules[@id='user-rules']", $.getConfig())[0];
		let newRule = $.getConfig().createElement("rule");
		newRule.setAttribute("id", encodeURIComponent(from));
		newRule.setAttribute("value", encodeURIComponent(to));
		rules.appendChild(newRule);
		if ($.api.Statistics != null)
			$.api.Statistics.logShortAction(5310);
	};

	$.removeRule = function MCCore_removeRule(from) {
		let rules = $.api.XMLUtils.queryXMLDoc("/config/rules[@id='user-rules']", $.getConfig())[0];
		let subjectResult = $.api.XMLUtils.queryXMLDoc("/config/rules/rule[@id='" + encodeURIComponent(from) + "']", $.getConfig())[0];		
		rules.removeChild(subjectResult);
		if ($.api.Statistics != null)
			$.api.Statistics.logShortAction(5330);
	};

	$.incrementWhitelist = function MCCore_incrementWhitelist(from) {
		from = $._normalizeHostnameHelper(from);
		let hosts = $.api.XMLUtils.queryXMLDoc("/whitelist/hosts[@id='user-whitelist']", $.getWhitelist())[0];
		let existingHost = $.api.XMLUtils.queryXMLDoc("/whitelist/hosts/host[@id='" + encodeURIComponent(from) + "']", $.getWhitelist())[0];
		if (existingHost != null) {
			let value = parseInt(existingHost.getAttribute("value"));
			existingHost.setAttribute("value", value + 1);
			return;
		}

		let newHost = $.getWhitelist().createElement("host");
		newHost.setAttribute("id", encodeURIComponent(from));
		newHost.setAttribute("value", 1);
		hosts.appendChild(newHost);
	}

	$.clearWhitelist = function MCCore_clearWhitelist(from) {
		from = $._normalizeHostnameHelper(from);
		let hosts = $.api.XMLUtils.queryXMLDoc("/whitelist/hosts[@id='user-whitelist']", $.getWhitelist())[0];
		let existingHost = $.api.XMLUtils.queryXMLDoc("/whitelist/hosts/host[@id='" + encodeURIComponent(from) + "']", $.getWhitelist())[0];
		if (existingHost != null) {
			hosts.removeChild(existingHost);
		}
	}

	$.getWhitelistValue = function MCCore_getWhitelistValue(from) {
		from = $._normalizeHostnameHelper(from);
		let value = $.api.XMLUtils.queryXMLDoc("string(/whitelist/hosts/host[@id='" + encodeURIComponent(from) + "']/@value)", $.getWhitelist());
		if (value == null) {
			return 0;
		}
		return parseInt(value);
	};

	$._saveXMLToFile = function MCCore__saveXMLToFile(xmldoc, file) {
		let serializer = Cc["@mozilla.org/xmlextras/xmlserializer;1"].createInstance(Ci.nsIDOMSerializer);
		let foStream = Cc["@mozilla.org/network/file-output-stream;1"].createInstance(Ci.nsIFileOutputStream);
		foStream.init(file, 0x02 | 0x08 | 0x20, parseInt("0644", 8), 0);
		serializer.serializeToStream(xmldoc, foStream, "");
		foStream.close();
	};	
	
}

MCCore.prototype = {

	widget_name: "ru.yandex.bar.mistype-corrector",

	log: function (text) {
		this.api.logger.error(text);
	}
	
};

var mcCore = new MCCore();
var core = mcCore.xbCore;


