EXPORTED_SYMBOLS = ["module"];

var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var module = function(application) {
    application.notify = function(topic, data) {
        application.api.logger.debug("notify:"+topic);
        observerService.notifyObservers(application, topic, data);
    };
    
    var topics = [];
    
    application.setNotifyTopics = function(_topics) {
        topics = _topics;
    }

    var defaultObserver = {
        QueryInterface: function() { return this; },
        observe: function (subject, topic, data) {
            application.api.logger.debug("observe: " + topic + ", " + data);
            if (data == "finalize") {
                detachDefaultObserver();
            }
        }
    };

    function attachDefaultObserver() {
        for each (var topic in topics) {
            observerService.addObserver(defaultObserver, topic, false);
        }
    }
    
    function detachDefaultObserver() {
        for each (var topic in topics) {
            observerService.removeObserver(defaultObserver, topic);
        }
    }
    
    attachDefaultObserver();
}