EXPORTED_SYMBOLS = ["module"];

var module = function (application) {
	function log(text) {
		API.logger.debug("[ui] " + text);
	};
	
	var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var WW = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(Components.interfaces.nsIWindowWatcher);	
	var overlayAutohideTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
	
	var mainWindow = null;
	
	application.ui = {
		MICROBROWSER_PATH: application.api.Package.resolvePath("/content/authform.xul"),
		MICROBROWSER_WINDOW_NAME: "authform:browser",
		
		openMicrobrowser: function (features, arguments) {
			var window = application.ui.getTopBrowserWindow();
			return window.openDialog(application.ui.MICROBROWSER_PATH, application.ui.MICROBROWSER_WINDOW_NAME, features, arguments);
		},
		
		openHiddenMicrobrowser: function (features) {
			return function (arguments) {
				return application.ui.openMicrobrowser(features, arguments);
			}
		}("titlebar=no,width=0,height=0,left=10,top=-20"), //("titlebar=yes,width=400,height=400,centerscreen,resizable") 
		
		getMainWindow: function () {
			return mainWindow;
		},
		
		getMainDialog: function () {
			if (!mainWindow) return null;
			
			var document = mainWindow.document;
			
			if (!document) return null; 
			
			var dialog = document.querySelector("dialog");
			return dialog;
		},
		
		openWindow: function (parameters) {
			var window;
			
			if ("name" in parameters && parameters.name) {
				if ((window = WM.getMostRecentWindow(parameters.name))) {
					window.focus();
					return window;
				}
			}
			
			var parent;
			var features = parameters.features || "";
			
			if (features.indexOf("__popup__") != -1) {
				// Если есть спецфлаг, то убираем его и строим хэш по переданным параметрам.
				var featuresHash = { __proto__: null };
				
				features.replace(/(^|,)__popup__($|,)/, "").split(",")
				.forEach(function(aFeatureString) {
					if (aFeatureString) {
						let [name, value] = aFeatureString.split("=");
						if (name)
							featuresHash[name] = value;
					}
				});
				
				// Функция добавления "ключ=значение" в хэш при условии отсутствия такого ключа.
				function addFeature(aFeatureString) {
					let [name, value] = aFeatureString.split("=");
					if (!(name in featuresHash))
						featuresHash[name] = value;
				}
				
				addFeature("chrome");
				addFeature("dependent=yes");
				
				if (!Components.interfaces.nsIDOMGeoPositionAddress) // !isGreaterThenFx35 (иначе - "моргания" в fx36+)
					addFeature("titlebar=no");
				
				if (application.api.Environment.os.name != "windows")
					addFeature("popup=yes");
				
				// Формирование нового значения features на основе хэша.
				var featuresMod = [];
				for (let [name, value] in Iterator(featuresHash))
					featuresMod.push(name + (value ? "=" + value : ""));
				
				features = featuresMod.join(",");
				
				// Если в параметрах не задано родительское окно, то берём топовое.
				// Если и такого не будет, то не критично (просто не будет псевдомодальности).
				if (!("parent" in parameters))
					parent = application.ui.getTopBrowserWindow();
			}
			
			parent = parent || parameters.parent || null;
			
			window = WW.openWindow(
				parent,
				parameters.url,
				parameters.name || "_blank",
				features,
				parameters.arguments
			);
			
			window.parameters = parameters;
			
			let infoOSName = application.api.Environment.os.name;
			let infoBrowserVersion = application.api.Environment.browser.version;
			
			parameters.application = {
			    core: {
			        Lib: {
			            Log4Moz: {
			                repository: {
			                    getLogger: function() {
			                        return { __noSuchMethod__: function(){} }
			                    }
			                }
			            },
			            sysutils: {
    			            platformInfo: {
    			                os: {
    			                    name: infoOSName
    			                },
    			                browser: {
    			                    name: "firefox",
                                    version: {
                                        toString: function ver_toString() infoBrowserVersion,
                                        isLessThan: function ver_isLessThan(v) comparator.compare(this, v) < 0,
                                        isGreaterThan: function ver_isGreaterThan(v) comparator.compare(this, v) > 0,
                                        isEqual: function ver_isEqual(v) comparator.compare(this, v) == 0
                                    }
    			                }
    			            }
    			        }
			        }
			    }
			};
			
			return window;
		},
		
		openMainWindow: function () {
			var url = application.api.Package.resolvePath('/content/authform.xul'),
				frame = frame || "postMessage";
			
			var args = {application: application};
			args.wrappedJSObject = args;
			
			mainWindow = application.ui.openWindow({
				url: url,
				name: "yasearch-authform",
				features: "__popup__",
				arguments: args
			});
			
			return mainWindow;
		},
		
		closeMainWindow: function () {
			if (mainWindow) {
				mainWindow.close && mainWindow.close();
			}
		},
		
		// if window loaded only!
		setMainWindowView: function (view, accountType) {
			var dialog = this.getMainDialog();
			if (dialog) {
				dialog.setView(view, accountType);
			}
		},

		getTopBrowserWindow: function misc_getTopBrowserWindow() {
			return application.ui.getTopWindowOfType("navigator:browser");
		},
		
		getTopWindowOfType: function misc_getTopWindowOfType(windowType) {
			return WM.getMostRecentWindow(windowType);
		},
		
		showPostOverlay: function (type, msg, autohideDelay) {
			var dialog = application.ui.getMainDialog();
			if (!dialog) {
				return;
			}
			
			overlayAutohideTimer.cancel();
			dialog.showPostOverlay(type, msg);
			
			
			if (autohideDelay) {
				overlayAutohideTimer.initWithCallback(function () {
					application.ui.hidePostOverlay();
				}, autohideDelay, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
			}
		},
		
		hidePostOverlay: function () {
			var dialog = application.ui.getMainDialog();
			if (!dialog) {
				return;
			}
			
			dialog.hidePostOverlay();
		},
		
		showPostMessage: function (msg, autohideTimeout) {
			application.ui.showPostOverlay("message", msg, autohideTimeout);
		},
		
		showPostError: function (msg, autohideTimeout) {
			application.ui.showPostOverlay("error", msg, autohideTimeout);
		}
	};
}