EXPORTED_SYMBOLS = ["module"];

var HTTPRequest = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"];
var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);



var module = function (application) {
    application.utils = {
    
		setTimeout: function(func, ms) {
			var tmr = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
			tmr.initWithCallback(func, ms, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
			return tmr;
		},

        Request: function(url, method, callbacks) {
            try {
                var req = HTTPRequest.createInstance();
                req.onreadystatechange = OnStatus;
                req.open(method, url, true);
            } catch(e) {
                return null;
            }
            
            function OnStatus() {
                if (this.readyState == 4) {
                    if (this.status >= 200 && this.status < 400) {
                        callbacks.onLoad(this.responseText, this);
                    } else {
                        callbacks.onError(this.responseText, this);
                    }
                }
            }
            return req;
        },

        md5: function(str) {
            var cryptoHash = Components.classes["@mozilla.org/security/hash;1"].createInstance(Components.interfaces.nsICryptoHash);
            var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
            
            function toHexString(charCode) {
                return ("0" + charCode.toString(16)).slice(-2);
            };
            
            converter.charset = 'UTF-8';
            var result = {};
            var data = converter.convertToByteArray(str, result);

            cryptoHash.init(cryptoHash.MD5);
            cryptoHash.update(data, data.length);
            var hash = cryptoHash.finish(false);
            var hexString = [toHexString(hash.charCodeAt(i)) for (i in hash)].join("");

            return hexString;
        },
        
        ParseRequestString: function(str) {
            try {
                var obj = {};
                var pairs = str.split('&');
                var item;
                for(var i in pairs) {
                    if(pairs[i].indexOf('=') == -1) {
                        continue;
                    }
                    
                    item = pairs[i].split('=');
                    //application.log(item);
                    if(item[0] && item[1])
                        obj[item[0]] = item[1];
                }
                
                return obj;
            } catch(e) {
                //application.log('Error while parse: '+str);
                return null;
            }
        },
        
        getUrlParams: function (obj, encode) {
            var value = "", res = [];
            
            function fixedEncodeURIComponent (str) {
                return encodeURIComponent(str).replace(/!/g, '%21').replace(/'/g, '%27').replace(/\(/g, '%28').replace(/\)/g, '%29').replace(/\*/g, '%2A');
            }
            
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    value = encode ? fixedEncodeURIComponent(obj[key]) : obj[key];
                    res.push(key + "=" + value);
                }
            }
            res.sort();
            return res.join("&");
        },
        
        createLocationListener: function (changeListener) {
            var progressListener = function (callbacks) {
                var $ = this, empty = function (){};
            
                $.QueryInterface = function (aIID) {
                    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
                        aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
                        aIID.equals(Components.interfaces.nsISupports)) {
                            return this;
                    } else {
                        throw Components.results.NS_NOINTERFACE;
                    }
                }   
                
                $.onLocationChange = function (aWebProgress, aRequest, aLocation) {
                    return changeListener.call(this, callbacks, aWebProgress, aRequest, aLocation);
                }
                $.onProgressChange = empty;
                $.onSecurityChange = empty;
                $.onStateChange = empty;
                $.onStatusChange = empty;
            };
            return progressListener;
        },
        
        CallbackObject: function (success, error) {
            var $ = this,
                empty = function () {};
            
            $.success = function () {
                try {
                    return success.apply($, arguments);
                } catch(e) {
                    //application.log("callback exception\n" + e.stack);
                    $.error();
                }
            }
            $.error = error || empty;
        },
                        
        get gBrowser() {
            return WM.getMostRecentWindow("navigator:browser").gBrowser;
        }
    };
}