EXPORTED_SYMBOLS = ["module"];

var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

var module = function(application) {

	var host = '.odnoklassniki.ru';
	
	function getCookie(name){
		var cookieMgr = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
		for (var e = cookieMgr.enumerator; e.hasMoreElements();) {
			var cookie = e.getNext().QueryInterface(Components.interfaces.nsICookie);
			if(cookie.name == name && cookie.host == host) { return cookie.value || ''; }
		}
		return '';
	}
	
	var inited = false;
	var defaultObserver = {
        QueryInterface: function() { return this; },
        observe: function (subject, topic, data) {
            if (topic == "finalize") {
				//application.api.logger.debug("qqqq cookie:"+topic);
				deinit();
				return;
            }
			if (topic == 'cookie-changed') {
				if (!r.onlogout) { return; }
				
				var logout = false;
				var deletedCookie, changedCookie;
				
				
				
				var nsICookie2 = Components.interfaces.nsICookie2;
				switch (data) {
					case "cleared":
						logout = true;
						break;
					
					case "batch-deleted":
					case "reload":
						// Our cookie (possibly) was deleted. Find another one.
						logout = true;
						break;
					
					case "deleted": 
						deletedCookie = subject.QueryInterface(nsICookie2);
						if (deletedCookie && (deletedCookie.host == host) && (deletedCookie.name == 'JSESSIONID' || deletedCookie.name == 'AUTHCODE')) {
							logout = true;
						}
						break;
					
					
					case "changed": 
						changedCookie = subject.QueryInterface(nsICookie2);
						if (changedCookie && (changedCookie.host == host) && (changedCookie.name == 'JSESSIONID' || changedCookie.name == 'AUTHCODE')) {
							logout = true;
						}
						break;
					
					
					default:
						return;
				}
				
				if (logout && !r.isAuth()) {
					r.onlogout();
				}
			}
        }
    };
	
	function deinit() {
		if (inited) {
			observerService.removeObserver(defaultObserver, 'cookie-changed');
			observerService.removeObserver(defaultObserver, 'finalize');
			inited = false;
		}
	}
	
	var r = {
		init: function() {
			if (inited) {
				return;
			}
			//application.api.logger.debug("qqqq cookie: init");
			observerService.addObserver(defaultObserver, 'cookie-changed', false);
			observerService.addObserver(defaultObserver, 'finalize', false);
			inited = true;
		},
		
		
		removeCookies: function() {
			var cookieMgr = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager2);
			if (getCookie('AUTHCODE')) {
				//cookieMgr.remove(host, 'AUTHCODE', '/', true);
				cookieMgr.add(host, '/', 'AUTHCODE', '0', false, true, false, -1000);
			}
			if (getCookie('JSESSIONID')) {
				//cookieMgr.remove(host, 'JSESSIONID', '/', true);
				cookieMgr.add(host, '/', 'JSESSIONID', '0', false, false, false, -1000);
			}
		},
		deinit: deinit,
		isAuth: function() {
			var sid = getCookie('JSESSIONID'),
				aut = getCookie('AUTHCODE');
			//application.api.logger.debug("qqqq cookie: sid="+sid + ', aut='+aut);
			return !!(sid || aut);
		},
		onlogout: null
	};
	
	return r;
};