EXPORTED_SYMBOLS = ["core", "resources"];

const DEBUG = true;

function Application() {
    var $ = this;

    $.xbCore = {
        init: function(api) {
            $.init(api);
        },
        
        finalize: function() {
            $.finalize();
        },
        
        buildWidget: function(WIID, toolbarItem) {
            //toolbarItem.setAttribute("WIID", WIID);//для виджетов unique="false"
            $.WIID = WIID;//для виджетов unique="true"
            toolbarItem.app = $;
            toolbarItem.setAttribute("xb-native-widget-name", $.widget_name);
            $.initWidget();
        },
    
        destroyWidget: function(WIID, toolbarItem) {
            try {
                toolbarItem.ExDestructor();
            } catch(e) {}
            toolbarItem.removeAttribute("xb-native-widget-name");
            toolbarItem.application = undefined;
        }
    };

    $.init = function(api) {
        $.api = api;
        
        (function initSettings() {
            try {
                var StorableObject = $.importModule("StorableObject.jsm");
                $.settings = new StorableObject($.settings_file);
            } catch(e) {}
        })();
        
        $.importModule("application.utils.jsm");
        $.importModule("application.ui.jsm");
        $.importModule("application.notify.jsm");
        $.setNotifyTopics(["odnoklassniki-counters-updated",
                           "odnoklassniki-conversations-updated",
                           "odnoklassniki-bd-updated"]);
        $.start();
    };
    
    $.initWidget = function() {
        if($.odnoklassniki) {
            $.odnoklassniki.InitWidget();
        }
    }
    
    $.finalize = function() {
        $.odnoklassniki.DeInitModule();
        application.notify("finalize");
    };
    
    $.start = function() {
        var Odnoklassniki = $.importModule("odnoklassniki.jsm");
        $.odnoklassniki = new Odnoklassniki();
        $.api.logger.debug("Odnoklassniki.auth:"+$.odnoklassniki.isAuth);
        $.odnoklassniki.InitModule();
        $.api.logger.debug("Odnoklassniki.auth:"+$.odnoklassniki.isAuth);
    };
    
    $.SaveStorage = function() {
        $.settings.__save__($.settings_file);
    }
    $.ClearStorage = function() {
        $.settings.__clear__($.settings_file);
    }
};

Application.prototype = {
    widget_name: "ru.yandex.bar.odnoklassniki",
    settings_file: "odnoklassniki.settings.json",

    importModule: function(module) {
        var $ = this;
        var path = $.api.Package.resolvePath("modules/" + module);
        var scope = {};
        Components.utils.import(path, scope);
        return scope.module($);
    },
    
    toString: function() {
        return "[Application " + this.widget_name + "]";
    }
}

var application = new Application();
var core = application.xbCore;
var resources = {
    browser: {
        styles: [
            "/content/bindings.css",
            "/styles/style.css"
        ]
    }
};