"use strict";

const EXPORTED_SYMBOLS = ["module"];

var HTTPRequest = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"];

var module = function(application) {
    application.utils = {
        Request: function(url, method, callbacks) {
            try {
                var req = HTTPRequest.createInstance();
                req.onreadystatechange = OnStatus;
                req.open(method, url, true);
            } catch(e) {
                return null;
            }
            
            function OnStatus() {
                if (this.readyState == 4) {
                    if (this.status >= 200 && this.status < 400) {
                        callbacks.onLoad(this.responseText);
                    } else {
                        callbacks.onError(this.responseText);
                    }
                }
            }
            return req;
        },
        
        Timer: function(sec, callback) {
            var tmr = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
            tmr.initWithCallback(callback, sec * 1000, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
            return tmr;
        }
    };
}
