"use strict";

const EXPORTED_SYMBOLS = ["core", "resources"];

const DEBUG = true;
const UConverter = Components.classes['@mozilla.org/intl/scriptableunicodeconverter'].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
UConverter.charset = 'UTF-8';
/*const page_path = "http://yandex.st/bar/1.23/swf/player.html";*/
const known_brands = 'cb.tb';

function Application() {
    var $ = this;

    $.xbCore = {
        init: function(api) {
            $.init(api);
        },
        
        finalize: function() {
            $.finalize();
        },
        
        buildWidget: function(WIID, toolbarItem) {
            $.WIID = WIID;
            toolbarItem.application = $;
            toolbarItem.setAttribute("xb-native-widget-name", $.widget_name);
        },
    
        destroyWidget: function(WIID, toolbarItem) {
			if (toolbarItem) {
				toolbarItem.removeAttribute("xb-native-widget-name");
				toolbarItem.application = undefined;
			}
            try {
                $.player.DeInit();
            } catch(e) {}
        }
    };
    
    $.log = function(text) {
        if ($.api) {
            $.api.logger.debug(text);
        }
    };
    
    $.init = function(api) {
        $.api = api;
        $.settings_file = $.getSettingFile();
        $.initStorage();
        $.start();
    };
    
    $.initStorage = function(force) {
        var storage = $.api.Files.getWidgetStorage(true);
        storage.append($.settings_file);
        var fileExists = storage.exists() && storage.isFile();
        
        if (!fileExists || force) {
                storage = $.api.Files.getWidgetStorage(true);
                var channel = $.api.Package.getFileInputChannel($.settings_file);
                storage.append($.settings_file);
                $.api.Files.writeStreamToFile(channel.contentStream, storage, parseInt("0666", 8), 0x04 | 0x08 | 0x20);
        }
        
        var StorableObject = $.importModule("StorableObject.jsm");
        var s = $.storage = new StorableObject($.settings_file);
    };

    $.finalize = function() {
        $.SaveStorage();
        $.api.Browser.removeHiddenFrame($.player._window);
    };
    
    $.start = function() {
        $.importModule("application.utils.jsm");
        var BarPlayer = $.importModule("player.jsm");
        $.player = new BarPlayer();
        $.player._window = $.player.openMainWindow();
        $.log('start. settings: '+JSON.stringify($.storage.settings));
        $.player.checkUpdates();
    };
    
    $.SaveStorage = function() {
        $.log('SaveStorage ['+$.settings_file+'] '+JSON.stringify($.storage.settings));
        $.storage.__save__($.settings_file);
    }
    
    $.serviceListener = {
        observeServiceEvent: function(providerID, serviceName, topic, data) {
            if (serviceName == "package" && topic == "package updated" && $.packageService) {
                var brandID = $.barndingService.getBrandID();
                var idx = known_brands.indexOf(brandID);
                if (idx != -1) {
                    return known_brands.substr(idx, 2) + '-' + filename;
                }
            }
        }
    }
    
    $.packageService = null;
    
    $.getSettingFile = function() {
    
        var filename = "barplayer.settings.json";
        try {
            var service = $.api.Services.obtainService("ru.yandex.custombar.branding", "package", $.serviceListener);
            $.barndingService = service;
            if (service) {
                $.packageService = service;
            
                var brandID = service.getBrandID();
                var idx = known_brands.indexOf(brandID);
                $.brid = brandID == 'yandex' ? 'ru' : brandID;
                if (idx != -1) {
                    return known_brands.substr(idx, 2) + '-' + filename;
                }
            }
        } catch(e) {
            return filename;
        }
        return filename;
    };
    
};

Application.prototype = {
    widget_name: "ru.yandex.bar.player",
    /*page_path: page_path,*/
    brid: null,
    //page_hash: page_hash,
    barndingService: null,

    importModule: function(module) {
        var $ = this;
        var path = $.api.Package.resolvePath("modules/" + module);
        var scope = {};
        $.log("Application.importModule " + module);
        Components.utils.import(path, scope);
        $.log(module + " loaded");
        return scope.module($);
    },
    
    toString: function() {
        return "[Application " + this.widget_name + "]";
    }
}

var application = new Application();
var core = application.xbCore;
var resources = {
    browser: {
        styles: [
            "/content/bindings.css"
        ]
    }
};
