"use strict";

const EXPORTED_SYMBOLS = ["module"];

var module = function(application) {
    var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
    var WW = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(Components.interfaces.nsIWindowWatcher);
    var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
    const updateUrl = "http://export.yandex.ru/bar/radio.xml?brid=";
    
    var settingsAPI = application.api.Settings;
    const defFailCount = 8;
    var wrapper_window = application.api.Package.resolvePath('/content/wrapper_window.xul')

    var BarPlayer = function() {
        application.log('BarPlayer constructor');
        this._window = null; // player window
    };
        
    var default_features = "chrome,centerscreen,resizable=no,dependent=yes";
    var currentOS = application.api.Environment.os.name;
    application.log('application.api.Environment.os.name: '+application.api.Environment.os.name);
    var isWindows = currentOS && currentOS.toLowerCase().indexOf('windows') != -1;
    if (isWindows) {
        default_features = "__popup__," + default_features;
    }
    
    BarPlayer.prototype = new (function() {
        var $ = this;
    
        this.isPlay = false;
        this.isError = false;
        this.isThrobber = false;
        this.initialized = false;
        this.initFailCount = defFailCount;
        this.initTimer = null;
        this.throbberTimer = null;
        this.throbberTimerOn = false;
        this.updateTimer = null;
        
        var defaultObserver = {
            QueryInterface: function() { return this; },
            observe: function(subject, topic, data) {
                if (topic == 'barplayer-instance-closed') {
                    if (application.player._window || application.player._window.closed) {
                       application.player.instances--;
                       if (application.player.instances > 0 && data == 1) {
                           $.ResetPlayer();
                       }
                    }
                }
            }
        };
        
        observerService.addObserver(defaultObserver, 'barplayer-instance-closed', false);
        
        this.settingsListener = {
            onSettingChange: function(name, value) {
                observerService.notifyObservers(application, 'barplayer-on-settings-change', null);
            }
        };
        
        this.getFlashPlayer = function getFlashPlayer() {
            application.api.Controls.navigateBrowser({url: 'http://www.adobe.com/go/getflashplayer', target: 'new tab'});
        };

        this.checkUpdates = function checkUpdates() {
            var updateCallback = {
                notify: function() {
                    $.checkUpdates();
                }
            }
        
            this.updateTimer = application.utils.Timer(60*60*24, updateCallback);
            var url = updateUrl + application.brid;
            var callbacks = {
                onLoad: function(response) {
                    var obj;
                    try {
                        obj = JSON.parse(response);
                    } catch(e) {
                    }
                    if (obj) {
                        // add & update
                        for (var i in obj.stations) {
                            var st = obj.stations[i];
                            var found = false;
                            for (var j in application.storage.settings.stations) {
                                var station = application.storage.settings.stations[j];
                                if (station.id == st.id) {
                                    found = true;
                                    if (!station.stUserUrl && station.url != st.url) {
                                        application.storage.settings.stations[j].name = st.name;
                                        application.storage.settings.stations[j].url = st.url;
                                    }
                                }
                            }
                            if (!found) {
                                st.n = application.storage.settings.autocount;
                                application.storage.settings.autocount++;
                                application.storage.settings.stations.push(st);
                            }
                        }
                        // delete
                        if (obj.deadStations && obj.deadStations.length>0) {
                            for (var i in obj.deadStations) {
                                var id = obj.deadStations[i];
                                for (var j = 0; j < application.storage.settings.stations.length; j++) {
                                    var station = application.storage.settings.stations[j];
                                    if (id == station.id) {
                                        application.storage.settings.stations.splice(j, 1);
                                    }
                                }
                            }
                        }
                        application.SaveStorage();
                    }
                },
                onError: function(error) {
                    application.log('radio update error: ' + url);
                }
            }
            var req = application.utils.Request(url, 'GET', callbacks);
            req.send();
        }
        
        this.simpleFlashDetect = function simpleFlashDetect() {
            var pluginFound = false;
            var plugins = ['Shockwave','Flash'];
            var w = this.getTopBrowserWindow();
            if (w.navigator.plugins && w.navigator.plugins.length > 0) {
                var npl = w.navigator.plugins.length;
                for (let pCount = 0; pCount < npl; pCount++) {
                    var numFound = 0;
                        for (let nCount = 0; nCount < plugins.length; nCount++) {
                            if ((w.navigator.plugins[pCount].name.indexOf(plugins[nCount]) >= 0) || (w.navigator.plugins[pCount].description.indexOf(plugins[nCount]) >= 0) ) {
                                numFound++;
                            }   
                        }
                        if (numFound == plugins.length) {
                            pluginFound = true;
                            break;
                        }
                    }
                }
            return pluginFound;
        }
        
        this.DeInit = function DeInit() {
            // this.isPlay = false;
            this.initialized = false;
            try {
                this._window.close();
            } catch(e) {}
        }
        
        this.ResetPlayer = function ResetPlayer() {
            application.log('ResetPlayer ['+this.initFailCount+']');
            var wtmr = false;
            if (!this._window || this._window.closed) { // no window - reopen
                this._window = this.openMainWindow();
                wtmr = true;
            } else {
                var flash = this.GetFlash();
                wtmr = !flash;
                if (flash) {
                    this.initTimer.cancel();
                    this.initFailCount = defFailCount;
                }
            }
            if (wtmr) {
                var event = {
                    notify: function(t) {
                        application.player.Play();
                    }
                }
                this.initTimer = application.utils.Timer(1, event);
                this.isThrobber = true;
                this.isError = false;
            }
            this.initFailCount--;
            if (this.initFailCount <= 0) {
                this.initTimer.cancel();
                this.initFailCount = defFailCount;
                this.isError = true;
                this.isThrobber = false;
                this.isPlay = false;
                this.UpdateInstances();
            }
        };
        
        this.GetPlayList = function GetPlayList(b) {
            var $ = this;
            this.playlist = null;
            var url = this.GetCurrentUrl();
            var tmr;
            var req;
            
            var callbacks = {
                onLoad: function(response) {
                    var arr = response.toLowerCase().split('\n');
                    var valid = [];
                    for (var i in arr) {
                        var st = arr[i];
                        var sti = st.indexOf('http://');
                        if (st.indexOf('file') == 0 && st.indexOf('=') == 5) {
                            valid.push(st.substr(st.indexOf('=')+1));
                        } else if (sti == 0) {
                            if (st.substr(st.length-5).indexOf('.m3u') == -1) {
                                valid.push(st.substr(sti));
                            }
                        }
                    }
                    
                    if (valid.length>0) {
                        $.playlist = valid;
                        $.playlist_count = 0;
                        $.Play();
                    }
                    this.abort();
                },
                onError: function(msg) {
                    if (b) {
                        this.abort();
                        $.GetPlayList(false);
                    }
                },
                notify: function() {
                    this.abort();
                },
                abort: function() {
                    req.abort();
                    tmr.cancel();
                }
            }
            tmr = application.utils.Timer(1, callbacks);
            req = application.utils.Request(url, 'GET', callbacks);
            req.send();
        };
        
        this.Play = function Play() {
            try {
                if (this.GetFlash()) {
                    application.player.isPlay = true;
                    application.player.isError = false;
                    if (!this.playlist) {
                        application.player.GetPlayList(true);
                        var url = this.GetCurrentUrl();
                        application.player.GetFlash().SetStation(url, false);
                    } else {
                        application.player.GetFlash().SetStation(this.playlist[this.playlist_count], false);
                    }
                    application.player.GetFlash().PlayStream();
                    observerService.notifyObservers(application, 'barplayer-play', null);
                    application.player.UpdateInstances();
                } else {
                    application.player.ResetPlayer();
                }
            } catch(e) {
                application.player.ResetPlayer();
            }
        };
        
        this.Pause = function Pause() {
            application.log('PAUSE');
            try {
                this.throbberTimer.cancel();
            } catch(e) {}
            var flash = this.GetFlash();
            if (!flash)
                return;
            
            flash.StopStream();
            observerService.notifyObservers(application, 'barplayer-pause', null);
            this.isPlay = false;
            this.UpdateInstances();
        };
        
        this.SetStation = function(name) {
            application.log('SetStation: '+name);
            application.storage.settings.selected = name;
            application.SaveStorage();
            this.playlist = null;
            this.UpdateInstances();
            
            var flash = this.GetFlash();
            if (!flash)
                return;
            application.log('select st: '+name);
            flash.SetStation(this.GetCurrentUrl(), true);
            application.player.isPlay = true;
        };
        
        this.OnFlashEvent = function(event) {
            var type = event.type;
            application.log('OnFlashEvent type: '+type);
        
            if (!application.player.isPlay) {
                return;
            }
            if (type == 'SoundError') {
                if (this.playlist) {
                    application.log('Switch to next: '+this.playlist[this.playlist_count]);
                    this.playlist_count++;
                    this.Play();
                } else {
                    
                }
            }
            if (type == 'SoundFail') {
                application.player.isError = true;
            } else if (type == 'ShowThrobber') {
                application.player.isError = false;
                
                var callback = {
                    notify: function(tmr) {
                        application.player.isThrobber = true;
                        application.player.UpdateInstances();
                        if (tmr) {
                            application.player.throbberTimerOn = false;
                            tmr.cancel();
                        }
                    }
                }
                
                if (!application.player.throbberTimerOn) {
                    application.player.throbberTimerOn = true;
                    application.player.throbberTimer = application.utils.Timer(2, callback);
                }
            } else if (type == 'HideThrobber') {
                application.player.isThrobber = false;
                try {
                    application.player.throbberTimer.cancel();
                    application.player.throbberTimerOn = false;
                } catch(e) {}
            }
            application.player.UpdateInstances();
        };
        
        this.GetFlash = function() {
            if (this._window) {
                var flash;
                var htmlDoc;
                try {
                    htmlDoc = this._window.document.getElementById('yb-radio-player').contentDocument;
                    flash = htmlDoc.getElementById('player');
                    
                    // Fx16+
                    if (typeof flash.SetStation != "function") {
                        XPCNativeWrapper.unwrap(flash);
                        flash = flash.wrappedJSObject;
                    }
                } catch(e) {}
                
                if (!flash) {
                    this.initialized = false;
                } else if (!this.initialized){
                    htmlDoc.addEventListener('ShowThrobber', this.OnFlashEvent, true);
                    htmlDoc.addEventListener('HideThrobber', this.OnFlashEvent, true);
                    htmlDoc.addEventListener('SoundFail', this.OnFlashEvent, true);
                    htmlDoc.addEventListener('SoundError', this.OnFlashEvent, true);
                    this.initialized = true;
                } else {
                    this.initialized = false;
                }
            } else {
                this.initialized = false;
            }
            return flash;
        };
        
        this.ChangeStation = function(name, url, autoplay) {
            this.isError = false;
            if (!this.station_lastname)
                return;
                
            application.log('ChangeStation: from name:"'+this.station_lastname+'" to "'+name+'" and url:'+url);
            var station;
            for (var i in application.storage.settings.stations) {
                if (application.storage.settings.stations[i].name == this.station_lastname) {
                    station = application.storage.settings.stations[i];
                    break;
                }
            }
            if (station) {
                station.name = name;
                if (station.url != url) {
                    station.stUserUrl = true;
                }
                station.url = url;
                
                if (this.station_lastname == application.storage.settings.selected || autoplay) {
                    application.storage.settings.selected = name;
                    this.playlist = null;
                    this.Play();
                }
            }
            
            application.SaveStorage();
            this.UpdateInstances();
            this.station_lastname = null;
            // try to update settings window
            this.UpdateSettingsWindow();
        };
        
        this.MoveStation = function(name, offset) {
            var station;
            var n;
            for (var i=0; i<application.storage.settings.stations.length; i++) {
                station = application.storage.settings.stations[i];
                if (station.name == name) {
                    var station_to_change = application.storage.settings.stations[i+offset];
                    if (station_to_change && station_to_change != undefined) {
                        var n1 = station.n;
                        var n2 = station_to_change.n;
                        application.log('station.n: '+n1);
                        application.log('station_to_change.n: '+n2);
                        station.n = n2;
                        station_to_change.n = n1;
                    }
                    application.storage.settings.stations.sort(function(a,b) {return a.n - b.n;});
                    break;
                }
            }
            this.UpdateInstances();
            // try to update settings window
            this.UpdateSettingsWindow();
        };
                
        this.AddStation = function(name, url, autoplay) {
            application.log('AddStation: name:'+name+' url:'+url);
            var station = {'n':this.GetStationCount(),'name':name, 'url':url, 'stUserUrl':true, 'stUserName': true}
			
			
            var rExists = false;
			for(var i=0; i<application.storage.settings.stations.length; i++) {
                var station1 = application.storage.settings.stations[i];
                if(station1.name == name) {
                    station1.isDeleted = false;
					station1.url = url;
					rExists = true;
                    break;
                }
            }
			if (!rExists) {
				application.storage.settings.stations.push(station);
				application.storage.settings.autocount++;
			}
			
			
            if (autoplay) {
                application.storage.settings.selected = name;
                application.player.playlist = null;
                application.player.Play();
            }
            application.SaveStorage();
            this.UpdateInstances();
            // try to update settings window
            this.UpdateSettingsWindow();
        }
        
        this.RemoveStation = function(name) {
            application.log('RemoveStation: name:'+name);
            var station;
            for (var i=0; i<application.storage.settings.stations.length; i++) {
                station = application.storage.settings.stations[i];
                if (station.name == name) {
                    if (name == application.storage.settings.selected) {
                        application.player.Pause();
                    }
					application.storage.settings.stations[i].isDeleted = true;
                    //application.storage.settings.stations.splice(i, 1);
                    if (name == application.storage.settings.selected) {
						var selected = '';
						for(var j=0; j<application.storage.settings.stations.length; j++) {
							var stj = application.storage.settings.stations[j];
							if (!stj.isDeleted) {
								selected = stj.name;
								break;
							}
						}
                        application.storage.settings.selected = selected;
                    }
                    break;
                }
            }
            application.SaveStorage();
            this.UpdateInstances();
            // try to update settings window
            this.UpdateSettingsWindow();
        }
        
        this.UpdateInstances = function() {
            if (!this.instances) {
                return;
            }
            observerService.notifyObservers(application, 'barplayer-update', null);
        }
        
        this.UpdateSettingsWindow = function() {
            if (this.settingsDialog && !this.settingsDialog.closed) {
                var event = this.settingsDialog.document.createEvent("Event");
                event.initEvent('updatelist', true, true, this.settingsDialog);
                this.settingsDialog.dispatchEvent(event);
            }
        };
        
        this.GetStationCount = function() {
            if (application.storage.settings.autocount == 0) {
                application.storage.settings.autocount = application.storage.settings.stations.length;
            }
            return application.storage.settings.autocount;
        }
        
        this.GetStationsCount = function() {
            return application.storage.settings.stations.length;
        }
        
        this.isStationExist = function(_name) {
            return this.GetStationByName(_name) ? true : false;
        }
        
        this.GetStationByName = function(_name) {
            var st = application.storage.settings.stations;
            for (var i in st) {
                if (st[i].name == _name) {
                    return st[i];
                }
            }
            return null;
        }
        
        this.GetCurrentUrl = function() {
            var st = application.storage.settings.stations;
            for (var i in st) {
                if (st[i].name == application.storage.settings.selected) {
                    return st[i].url;
                }
            }
        }
    
        this.openMainWindow = function() {
            var mainWindow = application.api.Browser.getHiddenFrame();
            mainWindow.contentWindow.location.href = wrapper_window;
            /*mainWindow.contentWindow.application = application;*/
            mainWindow.contentWindow.externalInterface = {};
            return mainWindow.contentWindow;
        };
        
        this.openAddStationDialog = function() {
            if (this.addDialog && !this.addDialog.closed)
                return;
                
            var url = application.api.Package.resolvePath('content/addstation.xul');
            application.log('openAddStationDialog url: '+url);
            var frame = frame || "postMessage";
            
            var args = {'application': application};
            args.wrappedJSObject = args;
                    
            var _window = this.openWindow({
                url: url,
                name: "yasearch-barplayer-addstation",
                features: (default_features+",innerWidth=500,innerHeight=220"),
                arguments: args
            });
            this.addDialog = _window;
            return _window;
        };
        
        this.openDeleteQuestion = function() {
                
            var url = application.api.Package.resolvePath('content/questdel.xul');
            var result = this.settingsDialog.showModalDialog(url);
            return result;
        }
        
        this.openChangeStationDialog = function(name) {
            if (this.changeDialog && !this.changeDialog.closed)
                return;
                
            var url = application.api.Package.resolvePath('content/changestation.xul');
            application.log('openChangeStationDialog url: '+url);
            var frame = frame || "postMessage";
            
            var station;
            application.log('openChangeStationDialog. name: '+name);
            for (var i in application.storage.settings.stations) {
                if (application.storage.settings.stations[i].name == name) {
                    station = application.storage.settings.stations[i];
                }
            }
            if (!station)
                return;
                
            var args = {'application': application, 'station':station};
            args.wrappedJSObject = args;
            
            var _window = this.openWindow({
                url: url,
                name: "yasearch-barplayer-addstation",
                features: (default_features+",innerWidth=500,innerHeight=185"),
                arguments: args
            });
            this.changeDialog = _window;
            return _window;
        };
        
        this.openSettingsDialog = function() {
            if (this.settingsDialog && !this.settingsDialog.closed)
                return;
        
            var url = application.api.Package.resolvePath('content/settings.xul');
            application.log('openSettingsDialog url: '+url);
            var frame = frame || "postMessage";
            
            var args = {'application': application};
            args.wrappedJSObject = args;
            
            var _window = this.openWindow({
                url: url,
                name: "yasearch-barplayer-settings",
                features: (default_features+",innerWidth=566,innerHeight=250"),
                arguments: args
            });
            this.settingsDialog = _window;
            return _window;
        }
        
        this.openWindow = function(parameters) {
            var window;
            
            if ("name" in parameters && parameters.name) {
                if ((window = WM.getMostRecentWindow(parameters.name))) {
                    window.focus();
                    return window;
                }
            }
            
            var parent;
            var features = parameters.features || "";
            
            if (features.indexOf("__popup__") != -1) {
                // Если есть спецфлаг, то убираем его и строим хэш по переданным параметрам.
                var featuresHash = { __proto__: null };
                
                features.replace(/(^|,)__popup__($|,)/, "").split(",")
                .forEach(function(aFeatureString) {
                    if (aFeatureString) {
                        let [name, value] = aFeatureString.split("=");
                        if (name)
                            featuresHash[name] = value;
                    }
                });
                
                // Функция добавления "ключ=значение" в хэш при условии отсутствия такого ключа.
                let addFeature = function addFeature(aFeatureString) {
                    let [name, value] = aFeatureString.split("=");
                    if (!(name in featuresHash))
                        featuresHash[name] = value;
                }
                
                addFeature("chrome");
                addFeature("dependent=yes");
                
                if (!Components.interfaces.nsIDOMGeoPositionAddress) // !isGreaterThenFx35 (иначе - "моргания" в fx36+)
                    addFeature("titlebar=no");
                
                if (application.api.Environment.os.name != "windows")
                    addFeature("popup=yes");
                
                // Формирование нового значения features на основе хэша.
                var featuresMod = [];
                for (let [name, value] in Iterator(featuresHash))
                    featuresMod.push(name + (value ? "=" + value : ""));
                
                features = featuresMod.join(",");
                
                // Если в параметрах не задано родительское окно, то берём топовое.
                // Если и такого не будет, то не критично (просто не будет псевдомодальности).
                if (!("parent" in parameters))
                    parent = this.getTopBrowserWindow();
            }
            
            parent = parent || parameters.parent || null;
            
            window = WW.openWindow(
                parent,
                parameters.url,
                parameters.name || "_blank",
                features,
                parameters.arguments
            );
            
            window.parameters = parameters;
            parameters.application = application;
            parameters.module = application.barCore;
            return window;
        };
        
        this.getTopBrowserWindow = function misc_getTopBrowserWindow() {
            return this.getTopWindowOfType("navigator:browser");
        };
        
        this.getTopWindowOfType = function misc_getTopWindowOfType(windowType) {
            return WM.getMostRecentWindow(windowType);
        };
        
        this.noflash = !(this.simpleFlashDetect());
        application.log('noflash: '+this.noflash);
        
        application.api.Settings.observeChanges(this.settingsListener, application.WIID);
    });
    return BarPlayer;
}
