EXPORTED_SYMBOLS = ["core_helper"];

var core_helper = function(widgetPath, commonPath, appObj) {
	widgetPath = widgetPath || '/';
	if (widgetPath && (widgetPath.charAt(widgetPath.length-1) != '/')) {
		widgetPath = widgetPath + '/';
	}
	commonPath = commonPath || '/-common/';
	if (commonPath && (commonPath.charAt(commonPath.length-1) != '/')) {
		commonPath = commonPath + '/';
	}
	var COMMON_MODULE_PATH = commonPath + 'modules/';
	
	var app = null;
	var appConfigSrc = null;
	var common = null;
	var loadedModules = null;
	var loadedModulesArr = null;
	var rxFinModType = /object|function/;
	
	function importModule(moduleName) {
		//common.logr('importModule(' + moduleName + ') ' + JSON.stringify(loadedModules, '', 3));
		var m = loadedModules[moduleName];
		if (m) {
			return m.loadRet;
		}
		try {
			var modulePath = common.api.Package.resolvePath(moduleName + (/\.jsm?$/i.test(moduleName) ? '' : '.jsm')), scopeObj = {};
			Components.utils.import(modulePath, scopeObj);
			m = {loadRet: (scopeObj.module ? scopeObj.module.call(scopeObj, app, common) : null)};
			loadedModules[moduleName] = m;
			if (m.loadRet && rxFinModType.test(typeof m.loadRet)) {
				loadedModulesArr.push(m.loadRet);
			}
			return m.loadRet;
		} catch (exc) {
			common.logr('importModule: error module ' + moduleName + '\n' + exc, 'error');
			return null;
		}
	}

	function Application() {}
	Application.prototype = {
		constructor: Application,
		importModule: function (module) {
			return importModule(widgetPath + 'modules/' + module);
		},
		commonModule: function (module) {
			return importModule(widgetPath + 'modules/common/' + module + '/module');
		},
		logr: function (text, method) {
			if(this.api && this.api.logger) { 
				this.api.logger[method||'debug'](text);
			}
			else {
				var cs = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);
				cs.logStringMessage((this.config ? this.config.name : 'barwidget') + ": " + text);
			}
		},
		log: function (text, method) {
			if (this.DEBUG) { this.logr(text, method); }
		},
		logObj: function(obj, prefix, method) {
			if (this.DEBUG) { this.logr((prefix||'') + (obj && (typeof obj == 'object') ? ('\n' + JSON.stringify(obj, '', 3)) : obj), method); }
		},
		navigateBrowser: function(obj) {
			if (this.config.navigateUrl) {
				var url = this.config.navigateUrl[obj.url];
				if (url) { 
					obj.url = ((typeof url == 'string') ? url : (url.url || obj.url)); 
				}
			}
			this.api.Controls.navigateBrowser(obj);
		}
	};
	
	function loadConfig(first) {
		if (first) {
			appConfigSrc = (app.config && (typeof app.config == 'object')) ? app.config : null;
		}
		var conf = appConfigSrc;
		if (!conf) {
			common.log('load app.config');
			var text = common.utils.readFile(widgetPath + 'app.config', 'text', true);
			if (text) {
				try {
					conf = eval('(' + text + ')');
				} catch (exc) {
					app.logr('app.config parse error');
				}
			}
		}
		app.config = common.branding.brandingObject(conf);
	}
	function changeBrid(brid, old) {
		loadConfig(false);
		common.observerService.notify('branding', {brid: brid, oldBrid: old});
	}
	
	function createApp(api, src) {
		src = src || 'app';
		var type = (typeof src);
		if (type == 'string') {
			app = new Application();
			app.api = api;
			app.importModule(src);
		} else {
			if (type == 'function') {
				src = new src(common);
			}
			app = src;
			var ob = Application.prototype;
			for (var i in ob) {
				if ((i != 'constructor') && ob.hasOwnProperty(i)) {
					app[i] = ob[i];
				}
			}
			app.api = api;
		}
	}
	
	return {
		init: function (api) {
			common = { 
				api: api, 
				_commonUrl: api.Package.resolvePath(commonPath),
				_appUrl: api.Package.resolvePath(widgetPath),
				log: Application.prototype.log,
				logObj: Application.prototype.logObj,
				logr: Application.prototype.logr
			};
			loadedModules = {};
			loadedModulesArr = [];
			
			//common.logr('load system modules');
			
			importModule(COMMON_MODULE_PATH + "utils"); // utils, strUtils
			common.timers = importModule(COMMON_MODULE_PATH + "timers");
			common.http = importModule(COMMON_MODULE_PATH + "http");
			common.observerService = importModule(COMMON_MODULE_PATH + "observerService");
			common.storage = importModule(COMMON_MODULE_PATH + "storage");
			common.branding = importModule(COMMON_MODULE_PATH + "branding");
			common.ui = importModule(COMMON_MODULE_PATH + "ui");
			
			common.branding.init(changeBrid);
			try {
				createApp(api, appObj);
				common.DEBUG = app.DEBUG;
				loadConfig(true);
				if(app.init) { app.init(common); }
			} catch (exc) {
				Components.utils.reportError(exc);
			}
			return this;
		},
		
		finalize: function () {
			//common.logr('finalize');
			if (typeof app.finalize == 'function') { app.finalize(); }
			for (var i=loadedModulesArr.length-1; i>=0; --i) {
				if (typeof loadedModulesArr[i].finalize == 'function') {
					loadedModulesArr[i].finalize();
				}
			}
			app.config = appConfigSrc;
			loadedModules = null;
			loadedModulesArr = null;
			app = null;
			common = null;
			appConfigSrc = null;
		},
		
		buildWidget: function (WIID, toolbarItem) {
			//app.log('*** buildWidget, WIID=' + WIID);
			toolbarItem.application = app;
			toolbarItem.common = common;
			if (app.config.uniqueWidget !== false) {
				app.WIID = WIID; //for unique="true"
			} else {
				toolbarItem.WIID = WIID;
			}
			toolbarItem.setAttribute("ybar-native-widget-name", app.config.name);
		},
	
		destroyWidget: function (WIID, toolbarItem) {
			//app.log('*** destroyWidget, WIID=' + WIID);
			if(toolbarItem.__removeObservers) { toolbarItem.__removeObservers(); }
			if(toolbarItem.finalize) { toolbarItem.finalize(); }
			toolbarItem.application = null;
			toolbarItem.common = null;
			toolbarItem.__XBID__ = null;
			toolbarItem.WIID = null;
			toolbarItem.removeAttribute("ybar-native-widget-name");
		}
	};
};