EXPORTED_SYMBOLS = ["module"];

var module = function (app, common) {
	
	var log = function(str, method) {
		common.log('_common.observerService: ' + str, method);
	}
	
	var prefix = 'ybwgt_' + Math.random() + '_';
	var service = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
	
	return {
		addObserver: function(topic, handler, scope, displayTopic) {
			displayTopic = displayTopic || topic;
			if (typeof handler !== 'function') {
				if (!handler.observe) { return null; }
				scope = handler;
				handler = handler.observe;
			}
			
			var obj = {
				innerTopic: topic,
				topic: displayTopic,
				observe: function(subj, topic, data) {
					return handler.call(scope, displayTopic, data, subj);
				}
			};
			
			service.addObserver(obj, topic, false);
			return obj;
		},
		addAppObserver: function(topic, handler, scope) {
			return this.addObserver(prefix + topic, handler, scope, topic);
		},
		removeObserver: function(observer) {
			if (observer.observe) {
				service.removeObserver(observer, observer.innerTopic);
				observer.observe = null;
			}
		},
		notify: function(topic, data) {
			service.notifyObservers({}, prefix + topic, data||null);
		},
		finalize: function() {
			log('finalize');
		}
	};
}