EXPORTED_SYMBOLS = ["module"];

var module = function (app, common) {
	var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var WW = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(Components.interfaces.nsIWindowWatcher);
	
	var log = function(str, method) {
		common.log('_common.ui: ' + str, method);
	}

	//-------------------------------------------------------------------------------------------------------------------
	var UI = {
		getCurrentWindows: function() {
			var w = WM.getMostRecentWindow("navigator:browser");
			return {
				mrw: w,
				browser: w.gBrowser,
				selBrowser: w.gBrowser.selectedBrowser,
				selTab: w.gBrowser.selectedTab
			};
		},
		getCurrentWindow: function() {
			return WM.getMostRecentWindow("navigator:browser").gBrowser.selectedTab;
		},
		gBrowser: function() {
			return WM.getMostRecentWindow("navigator:browser").gBrowser;
		},
		getTopBrowserWindow: function() {
			return UI.getTopWindowOfType("navigator:browser");
		},
		getTopWindowOfType: function(windowType) {
			return WM.getMostRecentWindow(windowType);
		},
			
		getCurrentURL: function () {
			return common.api.Browser.getWindowListener(UI.getTopBrowserWindow()).windowLocation;
		},
		finalize: function() {
			log('finalize');
		}
	};
	
	return UI;
};