EXPORTED_SYMBOLS = ["core", "resources"];

var core = (function() {
	var coreHelper = null;
	function loadHelper(api, widgetPath, commonPath, appObj) {
		var modulePath = api.Package.resolvePath("-common/modules/corehelper.jsm"), scopeObj = {};
		Components.utils.import(modulePath, scopeObj);
		coreHelper = scopeObj.core_helper(widgetPath, commonPath, appObj);
	}
	
	return {
		init: function (api) {
			loadHelper(api, '', '', null);
			coreHelper.init(api);
		},
		
		finalize: function () {
			coreHelper.finalize();
			coreHelper = null;
		},
		
		buildWidget: function (WIID, toolbarItem) {
			coreHelper.buildWidget(WIID, toolbarItem);
		},
	
		destroyWidget: function (WIID, toolbarItem) {
			coreHelper.destroyWidget(WIID, toolbarItem);
		}
	};
})();

var resources = {
	browser: {
		styles: [
			"/content/bindings.css"
		]
	}
};