Y.UI.Search = (function () {
	
	function Constructor (container) {
		var _this = this;
		var OS = Y.ObserverService.getInstance();
		
		this.container = container;
		this.input = Y.DOM.getElementsByClassName(container, "searchbox-input")[0];
		this.mag = Y.DOM.getElementsByClassName(container, "search-icon")[0];

		OS.attachObserver("twitter:last-search", function (t, d) {
			_this.input.value = d;
		});

		OS.attachObserver("twitlink:search", function (t, d) {
			OS.notifyObservers("tab:set-active-tab", "search");
			_this.input.value = d;
			_this.search();
		});
		
		
		this.input.attachEvent("onkeydown", function (event) {
			var keyCode = event.keyCode;
			
			if (keyCode == 13) {
				_this.search();
			}

			if (keyCode == 27) {
				_this.input.value = "";
				
				event.cancelBubble = true;
				if (event.stopPropagation) {
					event.stopPropagation();
				}
				return false;
			}
		});


		this.mag.attachEvent("onclick", function (event) {
			_this.search();
		});
	};
	
	Constructor.prototype = {
		constructor: Constructor,
		
		search: function () {
			var _this = this;
			var text = this.input.value;
			
			if (text.length > 0) {
				Y.sendMessage("twitter:search", text);
			}
			
			var errorElement = document.getElementById("message-list-error-message");
			if (errorElement) {
				errorElement.style.display = "none";
			}
			
			// IE крадет фокус с поля ввода 
			setTimeout(function () {
				_this.input.focus();
			}, 100);
		}
	};
	
	return Constructor;
})();