var EXPORTED_SYMBOLS = ["module"];

var nsIXMLHttpRequest = Components.interfaces.nsIXMLHttpRequest;
var nsCXMLHttpRequest = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"];

/**
 * @constructor
 */
var ClickerClient = function () {};

ClickerClient.API_URL = "http://clck.ru/--?url=";

ClickerClient.prototype = {
	constructor: ClickerClient,
	
	shortenAsync: function (callbacks, url) {
		var request = nsCXMLHttpRequest.createInstance(nsIXMLHttpRequest);
		request.open("GET", ClickerClient.API_URL + encodeURIComponent(url));
		request.overrideMimeType("text/plain");
		request.setRequestHeader("Accept", null);
		request.setRequestHeader("Accept-Charset", null);
		request.setRequestHeader("Accept-Encoding", null);
		request.setRequestHeader("Accept-Language", null);
		
		request.onreadystatechange = function (event) {
			var target = event.target;
			var state = target.readyState;
			
			switch (state) {
				case 4:
					var status = target.status;
					var response = target.responseText;
					
					switch (status) {
						case 200:
							return callbacks.success(response);
							break;
						default:
							return callbacks.error(response);
					}
					break;
			}
		};
		
		request.send();
		
		return {
			abort: function () {
				request.abort();
			}
		};
	}
};

var module = function (application) {
	application.clickerClient = new ClickerClient();
};