var EXPORTED_SYMBOLS = ["module"];
var ObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

function module(application) {
	function log(text) {
		application.log("slice-adapter: " + text);
	}
	
	var sliceObserver = null;
	var loaded = false;
	var delayedMessages = {};
	
	application.sliceAdapter = {
		
		//region external
		YB_attachObserver: function (observer) {
			sliceObserver = observer;
		},
		
		YB_sendMessage: function (topic, data) {
			application.sliceAdapter.receiveMessage(topic, data);
		},
		//endregion external
		
		onbeforeload: function () {
			application.sliceAdapter.callObserver("twitter:entities", application.sliceEntities);
			application.sliceAdapter.callObserver("data:current-url", application.ui.getCurrentURL());			
		},
		
		onload: function () {
			application.sliceAdapter.callObserver("data:hidden-messages", JSON.stringify(application.removedMessages.getAll()), true);			
			application.sliceAdapter.callObserver("twitter:x-params", JSON.stringify({
				screen_name: application.twitterAccount.credentials.screen_name
			}));
			var msgs = delayedMessages[application.twitterAccount.credentials.screen_name];
			var keys = [];
			for (var topic in msgs) {
				if (msgs.hasOwnProperty(topic)) {
					keys.push(topic);
				}
			}
			
			keys.sort();
			
			var needResearch = false;
			for (var topicName in keys) {
				var topic = keys[topicName];
				switch (topic) {
					case "render:search":
						if (msgs[topic].indexOf("<networkerror") == 0) {
							needResearch = true;
							break;
						}
					default:
						application.sliceAdapter.callObserver(topic, msgs[topic]);
				}
			}
			
			if (needResearch) {
				var lastSearch = msgs["twitter:last-search"];
				if (lastSearch) {
					ObserverService.notifyObservers(null, application.slice_name + ":twitter:search", lastSearch);
				}
			}
		},
		
		receiveMessage: function (topic, data) {
			log("<- " + topic + ", " + data);
			
			if (topic == "load") {
				loaded = true;
				this.onload();
			}
			
			if (topic == "beforeload") {
				this.onbeforeload();
			}
			
			ObserverService.notifyObservers({}, application.slice_name + ":" + topic, data || "");
		},
		
		sendMessage: function (topic, data, offline) {
			if (loaded) {
				application.sliceAdapter.callObserver(topic, data);
			}
			
			if (offline) {
				this.pushDelayed(topic, data);
			}
		},
		
		callObserver: function (topic, data) {
			log("-> " + topic + ", " + (data || "").substring(0, 100).replace(/\n|\s+/g, " "));
			
			try {
				sliceObserver.call({}, topic, data);
			} catch (e) {
				Components.utils.reportError(e);
			}
			
		},
		
		pushDelayed: function (topic, data) {
			var currentScreenName = application.twitterAccount.credentials.screen_name;
			var msgs = delayedMessages[currentScreenName];
			if (!msgs) {
				delayedMessages[currentScreenName] = {};
			}
			
			delayedMessages[currentScreenName][topic] = data;
		},
		
		remove: function () {
			loaded = false;
			sliceObserver = null;
		}
	};
};
