var EXPORTED_SYMBOLS = ["module"];

function module(application, common) {

var log = function(str, method) {
	application.log('twitter-api: ' + str, method);
}


var CallChain = application.utils.CallChain;
var CallbackObject = application.utils.CallbackObject;

var CONFIG = application.config.appCredential;

var DEFAULT_TWEET_COUNT = 20;

var twitterUrl = {
		requestToken: "https://api.twitter.com/oauth/request_token",
		accessToken: "https://api.twitter.com/oauth/access_token",
		auth: "https://api.twitter.com/oauth/authorize"
	};

var compareCallbacks = function (alien, own) {
	var url1 = alien.replace(/^https?:\/\//, "");
	var url2 = own.replace(/^https?:\/\//, "");
	return url1.indexOf(url2) == 0; // начинается ли alien с own
};

var TwitterAPIConstructor = function (observer) {
	this.type = "twitter";
	this.active = false;
	
	this.credentials = {};
	this.observer = observer;
};

TwitterAPIConstructor.prototype = {
	constructor: TwitterAPIConstructor,
	displayName: "twitter account",
	maxMessageLength: 140,
	
	setSavedCredentials: function(savedAccountData) {
		if (savedAccountData) {
			log('savedAccountData!!!');
			this.type = savedAccountData.type;
			this.credentials = savedAccountData.credentials;
			this.displayName = savedAccountData.displayName;
			this.active = savedAccountData.active;
			
			this.observer.onLogin();
		}
	},
	
	_getAuthorizationHeader: function (method, url, postParams) {
		var t = url.split("?");
		var baseUrl = t[0];
		var urlParams = t[1];
		
		var paramsObj;
		
		var oAuthParams = {
			oauth_consumer_key: CONFIG.consumer_key,
			oauth_nonce: common.strUtils.getRandomString(8),
			oauth_signature_method: "HMAC-SHA1",
			oauth_timestamp: String(parseInt(new Date / 1000)),
			oauth_version: "1.0"
		};
		
		if ("oauth_verifier" in this.credentials) {
			oAuthParams.oauth_verifier = this.credentials.oauth_verifier;
		}

		if ("oauth_token" in this.credentials) {
			oAuthParams.oauth_token = this.credentials.oauth_token;
		}
		
		if (method.toUpperCase() === "GET") {
			paramsObj = application.utils.mix(common.utils.urlParams2Obj(urlParams), oAuthParams);
		} else {
			paramsObj = application.utils.mix(common.utils.urlParams2Obj(urlParams), postParams, oAuthParams);
		}
		var base = [method, baseUrl, common.utils.obj2UrlParams(paramsObj)].map(common.utils.encodeURIComponent).join("\x26");
		var key = [CONFIG.consumer_secret, this.credentials.oauth_token_secret || ""].join("\x26");
		oAuthParams.oauth_signature = application.OAuth.SignRaw(key, base);
		return ["OAuth", application.utils.obj2HeaderParams(oAuthParams)].join("\x20");
	},
	
	sendSignedRequest: function (method, url, readystateListener, postDataObject) {
		var request = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"].createInstance();
		
		if ((method.toLowerCase() == "get") && postDataObject) {
			var additionalGetParams = common.utils.obj2UrlParams(postDataObject);
			var delimiter = "&";
			
			if (url.indexOf("?") === -1) {
				delimiter = "?";
			}
			
			url = [url, additionalGetParams].join(delimiter);
		}
		
		var headers = {
			"Accept": null,
			"Accept-Charset": null,
			"Accept-Language": null,
			"Content-Type": "application/x-www-form-urlencoded; encoding=UTF-8", 
			"Authorization": this._getAuthorizationHeader(method, url, postDataObject)
		};
		
		log("signed request: " + method + " " + url);
		request.open(method, url);

		for (var i in headers) {
			request.setRequestHeader(i, headers[i]);
		}
		
		request.onreadystatechange = readystateListener;
		request.send((method.toLowerCase() != "get") && postDataObject ? common.utils.obj2UrlParams(postDataObject) : null);
		
		return {
			abort: function () {
				log("abort signed request");
				request.abort();
			}
		};
	},
	
	_getAccessToken: function (callbacks) {
		var me = this;
		var asyncWatcher = me.sendSignedRequest("GET", twitterUrl.accessToken, function (event) {
			var target = event.target;
			if (target.readyState === 4) {
				var responseText = target.responseText;
				if (responseText) {
					var response = common.utils.urlParams2Obj(responseText);
					me.credentials.uid = response.user_id;
					me.credentials.oauth_token = response.oauth_token;
					me.credentials.oauth_token_secret = response.oauth_token_secret;
					me.credentials.screen_name = response.screen_name;
					me.active = true;
					me.displayName = response.screen_name;
					callbacks.success(response);
				} else {
					callbacks.error();
				}
			}
		});
		
		return asyncWatcher;
	},

	_authorizeUser: function (callbacks) {
		log('_authorizeUser');
		var me = this,
			mbFeatures = "centerscreen,width=600,height=720,resizable",
			tokenObj = {
				oauth_token: me.credentials.oauth_token
			},
			_authBrowserWindow;
		
		var twitterAuthLL = application.utils.createStateListener(function (callbacks, progress, request, stateFlags, status) {
			var spec = request.name;
			if (compareCallbacks(spec, CONFIG.callback_url)) {
				try {
					var t = spec.split("?");
					var domain = t[0], paramsStr = t[1]; 
					var params = common.utils.urlParams2Obj(paramsStr);
				} catch (e) {
					_authBrowserWindow.close();
					return callbacks.error();
				}
				
				if (!_authBrowserWindow.closed) {
					_authBrowserWindow.close();
					request.cancel(1);
					callbacks.success(params);
				}
			}
		});
		
		var mbArguments = {
			url: twitterUrl.auth + "/?" + common.utils.obj2UrlParams(tokenObj),
			progressListener: new twitterAuthLL(new application.utils.CallbackObject(
				function (params) {
					log('_authorizeUser callback: params.oauth_token='+params.oauth_token + ', params.oauth_verifier' + params.oauth_verifier);
					me.credentials.oauth_token = params.oauth_token;
					me.credentials.oauth_verifier = params.oauth_verifier;
					callbacks.success();
				},
				callbacks.error
			)),
			notifyMask: Components.interfaces.nsIWebProgress.NOTIFY_ALL,
			onclose: function () {
				callbacks.error("CANCELLED");
			}
		};
		
		_authBrowserWindow = application.ui.openMicrobrowser(mbFeatures, mbArguments);
	},
	
	_resetAuth: function () {
		if (!this.active) {
			return;
		}
		this.active = false;
		this.credentials = {};
		delete this.displayName;
		this.observer.onLogout();
	},
	
	_getRequestToken: function (callbacks) {
		log("getRequestToken");
		var me = this;
		
		var timer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);

		var readyState1Listener = function (event) {
			var target = event.target;
			if (target.readyState === 4) {
				log("readyStateListener state 4");
				timer.cancel();
				var responseText = target.responseText;
				log("readyStateListener text = " + responseText);
				if (responseText) {
					var response = common.utils.urlParams2Obj(responseText);
					if ("oauth_token" in response && "oauth_token_secret" in response) {
						me.credentials.oauth_token = response.oauth_token;
						me.credentials.oauth_token_secret = response.oauth_token_secret;
						log('_getRequestToken success, response.oauth_token=' + response.oauth_token);
						callbacks.success();
						return;
					} else {
						callbacks.error("SERVER_ERROR"); // bad response
					}
				} else {
					callbacks.error("SERVER_ERROR"); // no response
				}
			}
		};
		
		var asyncWatcher = this.sendSignedRequest("GET", twitterUrl.requestToken, readyState1Listener, {
			oauth_callback: CONFIG.callback_url
		});
		
		timer.initWithCallback(function () {
			log("timer abort!");
			asyncWatcher.abort();
			callbacks.error("TIMEOUT");
		}, 5000, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
		
		return asyncWatcher;
	},
	
	connect: function () {
		var me = this;
		
		var callbacks = new application.utils.CallbackObject(
			function () {
				me.observer.onLogin();
			},
			function (error) {
				me.credentials = {};
				application.destroySlice();
				me.observer.onLoginError(error);
			}
		);
		
		log("connect");

		var mbFeatures = "centerscreen,width=600,height=720,resizable";
		
		var mbArguments = {
			url: application.api.Package.resolvePath("/content/slice/throbber.html"),
			onclose: function () {
				callbacks.error("CANCELLED");
			}
		};
		
		this._resetAuth();
		
		var _authBrowserWindow = application.ui.openMicrobrowser(mbFeatures, mbArguments);
		
		var handshake = new application.utils.CallChain;
		
		handshake.addNode(function (callbacks) {
			var c1 = new application.utils.CallbackObject(
				callbacks.success,
				function (error) {
					if (error == "TIMEOUT" || error == "SERVER_ERROR") {
						var mbFeatures1 = "centerscreen,width=600,height=600,resizable";
					   
						var mbArguments1 = {
							url: application.api.Package.resolvePath("/content/slice/network-error.html"),
							onclose: function () {
								callbacks.error("CANCELLED");
							}
						};
						
						_authBrowserWindow = application.ui.openMicrobrowser(mbFeatures1, mbArguments1);
					} else {
						_authBrowserWindow.close();
					}
					callbacks.error.apply(arguments);
				}
			);
			me._getRequestToken(c1);
		}).addNode(function (callbacks) {
			me._authorizeUser(callbacks);
		}).addNode(function (callbacks) {
			me._getAccessToken(callbacks);
		});
		
		log('handshake.execute(callbacks);')
		handshake.execute(callbacks);
	},
	
	reconnect: function (callbacks) {
		log("reconnect");
		return this.connect(callbacks);
	},
	
	disconnect: function () {
		this._resetAuth();
	}
};
	
return TwitterAPIConstructor;
}
