var EXPORTED_SYMBOLS = ["module"];
var WM = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
var WW = Components.classes["@mozilla.org/embedcomp/window-watcher;1"].getService(Components.interfaces.nsIWindowWatcher);	
var OS = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
var timerFactory = Components.classes["@mozilla.org/timer;1"];
var nsITimer = Components.interfaces.nsITimer;

var DEBUG = true;

function module(application, common) {
	var log = function(str, method) {
		application.log('ui: ' + str, method);
	}

	var sliceWindow = null;
	var just_blured = false;
	var opening_forbidden = false;
	var afterBlurTimer = timerFactory.createInstance(nsITimer);
	var afterMouseUpTimer = timerFactory.createInstance(nsITimer);
	var last_target = null;
	var last_event = null;
	
	
	application.ui = {
		MICROBROWSER_PATH: application.URI + "content/microbrowser/microbrowser.xul",
		MICROBROWSER_WINDOW_NAME: application.config.name + ":microbrowser",
		
		openMicrobrowser: function (features, args) {
			log('openMicrobrowser ***');
			var window = application.ui.getTopBrowserWindow(),
				browserWindow,
				inject = function () {
					window.close = function () {
						var evt = document.createEvent("Event");
						evt.initEvent("CloseMicrobrowser", true, false);
						document.documentElement.dispatchEvent(evt);
					};
				},
				
				defaultArguments = {
					inject: function (document) {
						application.log("inject function " + document);
						var location = document.location;
						application.log(location);
						if (location.toString().indexOf("http") !== 0) return;
						var script = document.createElement("script");
						script.innerHTML = inject.toSource() + "()";
						document.addEventListener("CloseMicrobrowser", function () {
							browserWindow.close();
						}, false, true);
						document.documentElement.appendChild(script);
					}
				};
			
			application.utils.mix(args, defaultArguments);
			browserWindow = window.openDialog(application.ui.MICROBROWSER_PATH, application.ui.MICROBROWSER_WINDOW_NAME, features, args);
			return browserWindow;
		},
		
		openSliceWindow: function (event) {
			if (sliceWindow && !sliceWindow.closed) {
				sliceWindow.focus();
			} else {
				this.openNewSliceWindow(event);
			}
			
			last_target.checked = true;
		},
		
		openNewSliceWindow: function (event) {
			if (event) {
				last_event = event;
			}
			
			if (!last_event) {
				return;
			}
			

			last_target = last_event.target.xTwitterButton || last_event.target.parentNode.xTwitterButton;
			
			var targetElement = last_event.target;
			var parentWindow = targetElement.ownerDocument.defaultView;
			var bo = targetElement.boxObject;
			
			var minGap = 10;
			
			var anchorPoint = {
				x: parseInt(bo.screenX + bo.width / 2),
				y: bo.screenY + bo.height
			};

			var anchorOffset = {
				x: -430,
				y: -2
			};
			
			var slicePoint = {
				x: anchorPoint.x + anchorOffset.x,
				y: anchorPoint.y + anchorOffset.y
			};
			
			var sliceWidth = 539,
				sliceHeight = 580; // 580
				
		
			var features = "chrome, titlebar=no, width=0, height=0, left=" + anchorPoint.x + ", top=" + anchorPoint.y;
			
			if (application.barAPI.Environment.os.name == "windows") {
				features += ", popup";
			}
			
			sliceWindow = WW.openWindow(parentWindow, application.sliceURI, "_blank", features, null);
			var screen = sliceWindow.screen;
			
			var minX = screen.availLeft + minGap;
			var maxX = screen.availLeft + screen.availWidth - sliceWidth - minGap;
			
			if (slicePoint.x > maxX) {
				slicePoint.x = maxX;
			}
			
			if (slicePoint.x < minX) {
				slicePoint.x = minX;
			}
			
			sliceWindow.moveTo(slicePoint.x, slicePoint.y);
			sliceWindow.resizeTo(sliceWidth, sliceHeight);
			
			sliceWindow.externalInterface = application.sliceAdapter;
			
			if (!DEBUG) {
				sliceWindow.addEventListener("blur", function (event) {
					just_blured = true;
					
					afterBlurTimer.initWithCallback(function () {
						just_blured = false;
					}, 20, nsITimer.TYPE_ONE_SHOT);
					
					application.ui.closeSliceWindow();
				}, false);
	
				sliceWindow.addEventListener("deactivate", function (event) {
					just_blured = true;
					
					afterBlurTimer.initWithCallback(function () {
						just_blured = false;
					}, 20, nsITimer.TYPE_ONE_SHOT);
					
					application.ui.closeSliceWindow();
				}, false);
			}
			sliceWindow.addEventListener("load", function () {
				sliceWindow.focus();
			}, false);
			
			sliceWindow.document.documentElement.setAttribute("tooltip", "aHTMLTooltip");
		},
		
		closeSliceWindow: function () {
			application.sliceAdapter.remove();
			if (sliceWindow && !sliceWindow.closed) {
				sliceWindow.close();
				sliceWindow = null;
				application.counters.updateIfLocalChanged();
			}
			
			if (last_target) {
				last_target.checked = false;
			}
		},
		
		buttonCommandEventHandler: function (event) {
			switch (event.type) {
				case "command":
					application.barAPI.Statistics.logButtonClick();
				break;
				case "mousedown":
					if (just_blured) {
						opening_forbidden = true;
					}
					return;
				break;
				case "mouseup":
					if (opening_forbidden) {
						afterMouseUpTimer.initWithCallback(function () {
							opening_forbidden = false;
						}, 20, nsITimer.TYPE_ONE_SHOT);
					}
					return;
				break;
			}
			
			if (opening_forbidden) {
				event.target.checked = false;
				return;
			}
			
			if (!application.twitterAccount.active) {
				application.twitterAccount.connect(new application.utils.CallbackObject(
					function () {
						application.saveCredentials();
						application.counters.start(true);
						application.ui.openSliceWindow(event);
					},
					function (error) {
						if (error == "TIMEOUT") {
							
						} else {
							application.ui.closeSliceWindow();
						}
					}
				));
			} else {
				if (sliceWindow && !sliceWindow.closed) {
					application.ui.closeSliceWindow();
				} else {
					application.ui.openSliceWindow(event);
				}
			}
		},

		getTopBrowserWindow: function () {
			return application.ui.getTopWindowOfType("navigator:browser");
		},
		
		getTopWindowOfType: function (windowType) {
			return WM.getMostRecentWindow(windowType);
		},
		
		getCurrentURL: function () {
			return application.barAPI.Browser.getWindowListener(this.getTopBrowserWindow()).windowLocation;
		}
	};
}
