var EXPORTED_SYMBOLS = ["module"];

var module = function (application, common) {
	function log(text) {
		return application.log("utils: " + text);
	}
	
	var CallbackObject = function (success, error) {
		var $ = this,
			empty = function () {};
		
		$.success = function () {
			try {
				return success.apply($, arguments);
			} catch(e) {
				Components.utils.reportError(e);
				$.error();
			}
		};
		
		$.error = error || empty;
	};
			
	var CallChain = function () {
		var nodes = [];
		var results = [];
		var currentNode = 0;
		var currentWatcher = null;
		var executing = false;
		var aborted = false;
		
		this.addNode = function (fn) {
			nodes.push(fn);
			return this;
		};
		
		this.removeNode = function (fn) {
			for (var i = 0, l = nodes.length; i < l; ++i) {
				if (nodes[i] === fn) {
					delete nodes[i];
					nodes.splice(i, 1);
					break;
				}
			}
			return this;
		};
		
		this.getResults = function () {
			return results;
		};
		
		this.execute = function (finalCallbacks) {
			currentNode = 0;
			aborted = false;
			results = [];
			executing = true;
			
			var watcher = {
				abort: function () {
					log("abort chain");
					aborted = true;
					currentWatcher && currentWatcher.abort && currentWatcher.abort();
				}
			};
			
			var executor = function executor(result) {
				var node = nodes[currentNode];
				results[currentNode] = result;
				
				if (aborted) {
					return;
				}

				if (node) {
					currentNode++;
					currentWatcher = node.call({}, new CallbackObject(executor, finalCallbacks.error));
				} else {
					currentNode = 0;
					executing = false;
					finalCallbacks.success.apply({}, arguments);
				}
			};
			
			executor();
			return watcher;
		};
	};

	var utils = {
		createLocationListener: function (changeListener) {
			var progressListener = function (callbacks) {
				var $ = this, empty = function (){};
			
				$.QueryInterface = function (aIID) {
					if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
						aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
						aIID.equals(Components.interfaces.nsISupports)) {
							return this;
					} else {
						throw Components.results.NS_NOINTERFACE;
					}
				};
				
				$.onLocationChange = function (aWebProgress, aRequest, aLocation) {
					return changeListener.call(this, callbacks, aWebProgress, aRequest, aLocation);
				};
				
				$.onProgressChange = empty;
				$.onSecurityChange = empty;
				$.onStateChange = empty;
				$.onStatusChange = empty;
			};
			return progressListener;
		},

		createStateListener: function (listener) {
			var progressListener = function (callbacks) {
				var $ = this, empty = function (){};
			
				$.QueryInterface = function (aIID) {
					if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
						aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
						aIID.equals(Components.interfaces.nsISupports)) {
							return this;
					} else {
						throw Components.results.NS_NOINTERFACE;
					}
				};
				
				$.onLocationChange = empty;
				$.onProgressChange = empty;
				$.onSecurityChange = empty;
				$.onStateChange = function (a, b, c, d) {
					return listener.call(this, callbacks, a, b, c, d);
				};
				$.onStatusChange = empty;
			};
			return progressListener;
		},
		
		
		escapeXML: function (text) {
			if (typeof text !== "string") {
				return text;
			}
			
			return text.replace("&", "&amp;", "g").replace("<", "&lt;", "g").replace(">", "&gt;", "g").replace("\"", "&quot;", "g");
		},

		digest: function (algo, str) {
			function toHexString(charCode) {
				return ("0" + charCode.toString(16)).slice(-2);
			}
			var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
			converter.charset = "UTF-8";
			var t = {};
			var data = converter.convertToByteArray(str, t);
			var ch = Components.classes["@mozilla.org/security/hash;1"].createInstance(Components.interfaces.nsICryptoHash);
			var init;
			switch (algo) {
				case "md5":
					init = ch.MD5;
					break;
				case "sha1": 
					init = ch.SHA1;
					break;
			}
			ch.init(init);
			ch.update(data, data.length);
			var hash = ch.finish(false);
			var s = [];
			for (var i = 0, l = hash.length; i < l; ++i) {
				s.push(toHexString(hash.charCodeAt(i)));
			}
			
			return s.join("");			
		},
		
		CallbackObject: CallbackObject,
		CallChain: CallChain,
		
		obj2HeaderParams: function (obj) {
			var res = [], key, value, d1="", d2 = ", ";
			
			for (key in obj) {
				if (!obj.hasOwnProperty(key)) continue;
				value = common.utils.encodeURIComponent(obj[key]);
				res.push([common.utils.encodeURIComponent(key), "=\"", value, "\""].join(d1));
			}
			return res.join(d2);
		},
		
		duplicate: function (x) { // he-he-he, dirty
			return JSON.parse(JSON.stringify(x));
		},
		
		mix: function mix(a, b) {
			var r = application.utils.duplicate(a);
			
			for (var i in b) {
				if (!b.hasOwnProperty(i)) {
					continue;
				}
				
				var data = b[i],
					mixin;
				
				if (i in a) {
					switch (typeof data) {
						case "object":
							mixin = mix(a[i], data);
							break;
					
						default: 
							mixin = b[i];
					}
					
					r[i] = mixin;
				} else {
					r[i] = data;
				}
			}
			
			if (arguments.length > 2) {
				var argsArr = Array.prototype.slice.call(arguments, 2);
				argsArr.unshift(r);
				r = mix.apply(this, argsArr);
			}
			
			return r;
		}
	};
	
	application.utils = utils;
};