(function (global, main, modules, modules_options) {
    var initialized_modules = {},
        global_eval = function (code) {
            return global.Function('return ' + code)();
        },
        
        
        
        
        local_undefined,
        /**
         * @param {String} moduleName module name or path to file
         * @param {*}      module module content
         *
         * @returns {*}
         */
        register_module = function (moduleName, module) {
            lmd_trigger('lmd-register:before-register', moduleName, module);
            // Predefine in case of recursive require
            var output = {exports: {}};
            initialized_modules[moduleName] = 1;
            modules[moduleName] = output.exports;

            if (!module) {
                // if undefined - try to pick up module from globals (like jQuery)
                // or load modules from nodejs/worker environment
                module = lmd_trigger('js:request-environment-module', moduleName, module)[1] || global[moduleName];
            } else if (typeof module === "function") {
                // Ex-Lazy LMD module or unpacked module ("pack": false)
                var module_require = lmd_trigger('lmd-register:decorate-require', moduleName, require)[1];

                // Make sure that sandboxed modules cant require
                if (modules_options[moduleName] &&
                    modules_options[moduleName].sandbox &&
                    typeof module_require === "function") {

                    module_require = local_undefined;
                }

                module = module(module_require, output.exports, output) || output.exports;
            }

            module = lmd_trigger('lmd-register:after-register', moduleName, module)[1];
            return modules[moduleName] = module;
        },
        /**
         * List of All lmd Events
         *
         * @important Do not rename it!
         */
        lmd_events = {},
        /**
         * LMD event trigger function
         *
         * @important Do not rename it!
         */
        lmd_trigger = function (event, data, data2, data3) {
            var list = lmd_events[event],
                result;

            if (list) {
                for (var i = 0, c = list.length; i < c; i++) {
                    result = list[i](data, data2, data3) || result;
                    if (result) {
                        // enable decoration
                        data = result[0] || data;
                        data2 = result[1] || data2;
                        data3 = result[2] || data3;
                    }
                }
            }
            return result || [data, data2, data3];
        },
        /**
         * LMD event register function
         *
         * @important Do not rename it!
         */
        lmd_on = function (event, callback) {
            if (!lmd_events[event]) {
                lmd_events[event] = [];
            }
            lmd_events[event].push(callback);
        },
        /**
         * @param {String} moduleName module name or path to file
         *
         * @returns {*}
         */
        require = function (moduleName) {
            var module = modules[moduleName];

            lmd_trigger('lmd-require:before-check', moduleName, module);
            // Already inited - return as is
            if (initialized_modules[moduleName] && module) {
                return module;
            }
            var replacement = lmd_trigger('*:rewrite-shortcut', moduleName, module);
            if (replacement) {
                moduleName = replacement[0];
                module = replacement[1];
            }

            lmd_trigger('*:before-init', moduleName, module);

            // Lazy LMD module not a string
            if (typeof module === "string" && module.indexOf('(function(') === 0) {
                module = global_eval(module);
            }

            return register_module(moduleName, module);
        },
        output = {exports: {}},

        /**
         * Sandbox object for plugins
         *
         * @important Do not rename it!
         */
        sandbox = {
            global: global,
            modules: modules,
            modules_options: modules_options,

            eval: global_eval,
            register: register_module,
            require: require,
            initialized: initialized_modules,

            
            
            
            
            
            

            on: lmd_on,
            trigger: lmd_trigger,
            undefined: local_undefined
        };

    for (var moduleName in modules) {
        // reset module init flag in case of overwriting
        initialized_modules[moduleName] = 0;
    }

/**
 * @name sandbox
 */
(function (sb) {

// Simple JSON stringify
function stringify(object) {
    var properties = [];
    for (var key in object) {
        if (object.hasOwnProperty(key)) {
            properties.push(quote(key) + ':' + getValue(object[key]));
        }
    }
    return "{" + properties.join(",") + "}";
}

function getValue(value) {
    if (typeof value === "string") {
        return quote(value);
    } else if (typeof value === "boolean") {
        return "" + value;
    } else if (value.join) {
        if (value.length == 0) {
            return "[]";
        } else {
            var flat = [];
            for (var i = 0, len = value.length; i < len; i += 1) {
                flat.push(getValue(value[i]));
            }
            return '[' + flat.join(",") + ']';
        }
    } else if (typeof value === "number") {
        return value;
    } else {
        return stringify(value);
    }
}

function pad(s) {
    return '0000'.substr(s.length) + s;
}

function replacer(c) {
    switch (c) {
        case '\b': return '\\b';
        case '\f': return '\\f';
        case '\n': return '\\n';
        case '\r': return '\\r';
        case '\t': return '\\t';
        case '"': return '\\"';
        case '\\': return '\\\\';
        default: return '\\u' + pad(c.charCodeAt(0).toString(16));
    }
}

function quote(s) {
    return '"' + s.replace(/[\u0000-\u001f"\\\u007f-\uffff]/g, replacer) + '"';
}

function indexOf(item) {
    for (var i = this.length; i --> 0;) {
        if (this[i] === item) {
            return i;
        }
    }
    return -1;
}

    /**
     * @event *:request-json requests JSON polifill with only stringify function!
     *
     * @param {Object|undefined} JSON default JSON value
     *
     * @retuns yes
     */
sb.on('*:request-json', function (JSON) {
    if (typeof JSON === "object") {
        return [JSON];
    }

    return [{stringify: stringify}];
});

    /**
     * @event *:request-indexof requests indexOf polifill
     *
     * @param {Function|undefined} arrayIndexOf default indexOf value
     *
     * @retuns yes
     */
sb.on('*:request-indexof', function (arrayIndexOf) {
    if (typeof arrayIndexOf === "function") {
        return [arrayIndexOf];
    }

    return [indexOf];
});

}(sandbox));



    main(lmd_trigger('lmd-register:decorate-require', "main", require)[1], output.exports, output);
})/*DO NOT ADD ; !*/(this,(function main(require) {
    // Инициируем блоки страницы
    require('bem').BEM.DOM.init();
}),{
"lib": (function (require) { /* wrapped by builder */
var Lib = {
    _THUMB_SIZE_BIG: 200,
    _THUMB_SIZE_NORMAL: 150,
    _THUMB_SIZE_SMALL: 100,

    _CONTENT_SIZE_BIG: 1522,
    _CONTENT_SIZE_NORMAL: 1082,
    _CONTENT_SIZE_SMALL: 860,

    _HISTORY_SUGGEST_MAX_LENGTH: 50,

    getThumbSize: function(x, y, width, height) {
        var size;
        if (width >= this._CONTENT_SIZE_BIG) {
            if (x <= 7 && y <= 5) {
                size = this._THUMB_SIZE_BIG;
            } else {
                size = this._THUMB_SIZE_NORMAL;
            }
        } else if (width >= this._CONTENT_SIZE_NORMAL) {
            if (x <= 5 && y <= 5) {
                size = this._THUMB_SIZE_BIG;
            } else if (x <= 7 && y <= 5) {
                size = this._THUMB_SIZE_NORMAL;
            } else {
                size = this._THUMB_SIZE_SMALL;
            }
        } else {
            if (x <= 4 && y <= 4) {
                size = this._THUMB_SIZE_BIG;
            } else if (x <= 5 && y <=5) {
                size = this._THUMB_SIZE_NORMAL;
            } else {
                size = this._THUMB_SIZE_SMALL;
            }
        }
        return size;
    },

    getThumbSizeMod: function(size) {
        var modSize;
        switch (size) {
            case this._THUMB_SIZE_BIG:
                modSize = 'big';
                break;
            case this._THUMB_SIZE_NORMAL:
                modSize = 'normal';
                break;
            case this._THUMB_SIZE_SMALL:
                modSize = 'small';
                break;
        }
        return modSize;
    },

    getThumbTitleMaxLength: function(size) {
        var len;
        switch (size) {
            case this._THUMB_SIZE_BIG:
                len = 40;
                break;
            case this._THUMB_SIZE_NORMAL:
                len = 30;
                break;
            case this._THUMB_SIZE_SMALL:
                len = 15;
                break;
        }
        return len;
    },

    getThumbSubTitleMaxLength: function(size) {
        var len;
        switch (size) {
            case this._THUMB_SIZE_BIG:
                len = 20;
                break;
            case this._THUMB_SIZE_NORMAL:
                len = 15;
                break;
            case this._THUMB_SIZE_SMALL:
                len = 7;
                break;
        }
        return len;
    },

    getContentSize: function(width, height) {
        var size = this._CONTENT_SIZE_SMALL,
            sizes = [this._CONTENT_SIZE_BIG, this._CONTENT_SIZE_NORMAL, this._CONTENT_SIZE_SMALL];

        for (var i = 0, len = sizes.length; i < len; i++) {
            if (width > sizes[i]) {
                size = sizes[i];
                break;
            }
        }
        return size;
    },

    getContentSizeMod: function(width, height) {
        var modSize,
            size = this.getContentSize.apply(this, arguments);

        switch (size) {
            case this._CONTENT_SIZE_BIG:
                modSize = 'big';
                break;
            case this._CONTENT_SIZE_NORMAL:
                modSize = 'normal';
                break;
            case this._CONTENT_SIZE_SMALL:
                modSize = 'small';
                break;
        }
        return modSize;
    },

    getHistorySuggestMaxLength: function() {
        return this._HISTORY_SUGGEST_MAX_LENGTH;
    }
};

/* added by builder */
return Lib;
}),
"$": (function (require) { /* wrapped by builder */
/*!
 * jQuery JavaScript Library v1.8.3
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2012 jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: Tue Nov 13 2012 08:20:33 GMT-0500 (Eastern Standard Time)
 */
(function( window, undefined ) {
var
	// A central reference to the root jQuery(document)
	rootjQuery,

	// The deferred used on DOM ready
	readyList,

	// Use the correct document accordingly with window argument (sandbox)
	document = window.document,
	location = window.location,
	navigator = window.navigator,

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$,

	// Save a reference to some core methods
	core_push = Array.prototype.push,
	core_slice = Array.prototype.slice,
	core_indexOf = Array.prototype.indexOf,
	core_toString = Object.prototype.toString,
	core_hasOwn = Object.prototype.hasOwnProperty,
	core_trim = String.prototype.trim,

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {
		// The jQuery object is actually just the init constructor 'enhanced'
		return new jQuery.fn.init( selector, context, rootjQuery );
	},

	// Used for matching numbers
	core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

	// Used for detecting and trimming whitespace
	core_rnotwhite = /\S/,
	core_rspace = /\s+/,

	// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

	// Match a standalone tag
	rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

	// JSON RegExp
	rvalidchars = /^[\],:{}\s]*$/,
	rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
	rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
	rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return ( letter + "" ).toUpperCase();
	},

	// The ready event handler and self cleanup method
	DOMContentLoaded = function() {
		if ( document.addEventListener ) {
			document.removeEventListener( "DOMContentLoaded", DOMContentLoaded, false );
			jQuery.ready();
		} else if ( document.readyState === "complete" ) {
			// we're here because readyState === "complete" in oldIE
			// which is good enough for us to call the dom ready!
			document.detachEvent( "onreadystatechange", DOMContentLoaded );
			jQuery.ready();
		}
	},

	// [[Class]] -> type pairs
	class2type = {};

jQuery.fn = jQuery.prototype = {
	constructor: jQuery,
	init: function( selector, context, rootjQuery ) {
		var match, elem, ret, doc;

		// Handle $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Handle $(DOMElement)
		if ( selector.nodeType ) {
			this.context = this[0] = selector;
			this.length = 1;
			return this;
		}

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector.charAt(0) === "<" && selector.charAt( selector.length - 1 ) === ">" && selector.length >= 3 ) {
				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && (match[1] || !context) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[1] ) {
					context = context instanceof jQuery ? context[0] : context;
					doc = ( context && context.nodeType ? context.ownerDocument || context : document );

					// scripts is true for back-compat
					selector = jQuery.parseHTML( match[1], doc, true );
					if ( rsingleTag.test( match[1] ) && jQuery.isPlainObject( context ) ) {
						this.attr.call( selector, context, true );
					}

					return jQuery.merge( this, selector );

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[2] );

					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE and Opera return items
						// by name instead of ID
						if ( elem.id !== match[2] ) {
							return rootjQuery.find( selector );
						}

						// Otherwise, we inject the element directly into the jQuery object
						this.length = 1;
						this[0] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || rootjQuery ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return rootjQuery.ready( selector );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	},

	// Start with an empty selector
	selector: "",

	// The current version of jQuery being used
	jquery: "1.8.3",

	// The default length of a jQuery object is 0
	length: 0,

	// The number of elements contained in the matched element set
	size: function() {
		return this.length;
	},

	toArray: function() {
		return core_slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num == null ?

			// Return a 'clean' array
			this.toArray() :

			// Return just the object
			( num < 0 ? this[ this.length + num ] : this[ num ] );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems, name, selector ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		ret.context = this.context;

		if ( name === "find" ) {
			ret.selector = this.selector + ( this.selector ? " " : "" ) + selector;
		} else if ( name ) {
			ret.selector = this.selector + "." + name + "(" + selector + ")";
		}

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	// (You can seed the arguments with an array of args, but this is
	// only used internally.)
	each: function( callback, args ) {
		return jQuery.each( this, callback, args );
	},

	ready: function( fn ) {
		// Add the callback
		jQuery.ready.promise().done( fn );

		return this;
	},

	eq: function( i ) {
		i = +i;
		return i === -1 ?
			this.slice( i ) :
			this.slice( i, i + 1 );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	slice: function() {
		return this.pushStack( core_slice.apply( this, arguments ),
			"slice", core_slice.call(arguments).join(",") );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map(this, function( elem, i ) {
			return callback.call( elem, i, elem );
		}));
	},

	end: function() {
		return this.prevObject || this.constructor(null);
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: core_push,
	sort: [].sort,
	splice: [].splice
};

// Give the init function the jQuery prototype for later instantiation
jQuery.fn.init.prototype = jQuery.fn;

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction(target) ) {
		target = {};
	}

	// extend jQuery itself if only one argument is passed
	if ( length === i ) {
		target = this;
		--i;
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray(src) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend({
	noConflict: function( deep ) {
		if ( window.$ === jQuery ) {
			window.$ = _$;
		}

		if ( deep && window.jQuery === jQuery ) {
			window.jQuery = _jQuery;
		}

		return jQuery;
	},

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
		if ( !document.body ) {
			return setTimeout( jQuery.ready, 1 );
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.trigger ) {
			jQuery( document ).trigger("ready").off("ready");
		}
	},

	// See test/unit/core.js for details concerning isFunction.
	// Since version 1.3, DOM methods and functions like alert
	// aren't supported. They return false on IE (#2968).
	isFunction: function( obj ) {
		return jQuery.type(obj) === "function";
	},

	isArray: Array.isArray || function( obj ) {
		return jQuery.type(obj) === "array";
	},

	isWindow: function( obj ) {
		return obj != null && obj == obj.window;
	},

	isNumeric: function( obj ) {
		return !isNaN( parseFloat(obj) ) && isFinite( obj );
	},

	type: function( obj ) {
		return obj == null ?
			String( obj ) :
			class2type[ core_toString.call(obj) ] || "object";
	},

	isPlainObject: function( obj ) {
		// Must be an Object.
		// Because of IE, we also have to check the presence of the constructor property.
		// Make sure that DOM nodes and window objects don't pass through, as well
		if ( !obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		try {
			// Not own constructor property must be Object
			if ( obj.constructor &&
				!core_hasOwn.call(obj, "constructor") &&
				!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf") ) {
				return false;
			}
		} catch ( e ) {
			// IE8,9 Will throw exceptions on certain host objects #9897
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own.

		var key;
		for ( key in obj ) {}

		return key === undefined || core_hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	error: function( msg ) {
		throw new Error( msg );
	},

	// data: string of html
	// context (optional): If specified, the fragment will be created in this context, defaults to document
	// scripts (optional): If true, will include scripts passed in the html string
	parseHTML: function( data, context, scripts ) {
		var parsed;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		if ( typeof context === "boolean" ) {
			scripts = context;
			context = 0;
		}
		context = context || document;

		// Single tag
		if ( (parsed = rsingleTag.exec( data )) ) {
			return [ context.createElement( parsed[1] ) ];
		}

		parsed = jQuery.buildFragment( [ data ], context, scripts ? null : [] );
		return jQuery.merge( [],
			(parsed.cacheable ? jQuery.clone( parsed.fragment ) : parsed.fragment).childNodes );
	},

	parseJSON: function( data ) {
		if ( !data || typeof data !== "string") {
			return null;
		}

		// Make sure leading/trailing whitespace is removed (IE can't handle it)
		data = jQuery.trim( data );

		// Attempt to parse using the native JSON parser first
		if ( window.JSON && window.JSON.parse ) {
			return window.JSON.parse( data );
		}

		// Make sure the incoming data is actual JSON
		// Logic borrowed from http://json.org/json2.js
		if ( rvalidchars.test( data.replace( rvalidescape, "@" )
			.replace( rvalidtokens, "]" )
			.replace( rvalidbraces, "")) ) {

			return ( new Function( "return " + data ) )();

		}
		jQuery.error( "Invalid JSON: " + data );
	},

	// Cross-browser xml parsing
	parseXML: function( data ) {
		var xml, tmp;
		if ( !data || typeof data !== "string" ) {
			return null;
		}
		try {
			if ( window.DOMParser ) { // Standard
				tmp = new DOMParser();
				xml = tmp.parseFromString( data , "text/xml" );
			} else { // IE
				xml = new ActiveXObject( "Microsoft.XMLDOM" );
				xml.async = "false";
				xml.loadXML( data );
			}
		} catch( e ) {
			xml = undefined;
		}
		if ( !xml || !xml.documentElement || xml.getElementsByTagName( "parsererror" ).length ) {
			jQuery.error( "Invalid XML: " + data );
		}
		return xml;
	},

	noop: function() {},

	// Evaluates a script in a global context
	// Workarounds based on findings by Jim Driscoll
	// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
	globalEval: function( data ) {
		if ( data && core_rnotwhite.test( data ) ) {
			// We use execScript on Internet Explorer
			// We use an anonymous function so that context is window
			// rather than jQuery in Firefox
			( window.execScript || function( data ) {
				window[ "eval" ].call( window, data );
			} )( data );
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	// args is for internal usage only
	each: function( obj, callback, args ) {
		var name,
			i = 0,
			length = obj.length,
			isObj = length === undefined || jQuery.isFunction( obj );

		if ( args ) {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.apply( obj[ name ], args ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.apply( obj[ i++ ], args ) === false ) {
						break;
					}
				}
			}

		// A special, fast, case for the most common use of each
		} else {
			if ( isObj ) {
				for ( name in obj ) {
					if ( callback.call( obj[ name ], name, obj[ name ] ) === false ) {
						break;
					}
				}
			} else {
				for ( ; i < length; ) {
					if ( callback.call( obj[ i ], i, obj[ i++ ] ) === false ) {
						break;
					}
				}
			}
		}

		return obj;
	},

	// Use native String.trim function wherever possible
	trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
		function( text ) {
			return text == null ?
				"" :
				core_trim.call( text );
		} :

		// Otherwise use our own trimming functionality
		function( text ) {
			return text == null ?
				"" :
				( text + "" ).replace( rtrim, "" );
		},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var type,
			ret = results || [];

		if ( arr != null ) {
			// The window, strings (and functions) also have 'length'
			// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
			type = jQuery.type( arr );

			if ( arr.length == null || type === "string" || type === "function" || type === "regexp" || jQuery.isWindow( arr ) ) {
				core_push.call( ret, arr );
			} else {
				jQuery.merge( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		var len;

		if ( arr ) {
			if ( core_indexOf ) {
				return core_indexOf.call( arr, elem, i );
			}

			len = arr.length;
			i = i ? i < 0 ? Math.max( 0, len + i ) : i : 0;

			for ( ; i < len; i++ ) {
				// Skip accessing in sparse arrays
				if ( i in arr && arr[ i ] === elem ) {
					return i;
				}
			}
		}

		return -1;
	},

	merge: function( first, second ) {
		var l = second.length,
			i = first.length,
			j = 0;

		if ( typeof l === "number" ) {
			for ( ; j < l; j++ ) {
				first[ i++ ] = second[ j ];
			}

		} else {
			while ( second[j] !== undefined ) {
				first[ i++ ] = second[ j++ ];
			}
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, inv ) {
		var retVal,
			ret = [],
			i = 0,
			length = elems.length;
		inv = !!inv;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			retVal = !!callback( elems[ i ], i );
			if ( inv !== retVal ) {
				ret.push( elems[ i ] );
			}
		}

		return ret;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var value, key,
			ret = [],
			i = 0,
			length = elems.length,
			// jquery objects are treated as arrays
			isArray = elems instanceof jQuery || length !== undefined && typeof length === "number" && ( ( length > 0 && elems[ 0 ] && elems[ length -1 ] ) || length === 0 || jQuery.isArray( elems ) ) ;

		// Go through the array, translating each of the items to their
		if ( isArray ) {
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}

		// Go through every key on the object,
		} else {
			for ( key in elems ) {
				value = callback( elems[ key ], key, arg );

				if ( value != null ) {
					ret[ ret.length ] = value;
				}
			}
		}

		// Flatten any nested arrays
		return ret.concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = core_slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context, args.concat( core_slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	// Multifunctional method to get and set values of a collection
	// The value/s can optionally be executed if it's a function
	access: function( elems, fn, key, value, chainable, emptyGet, pass ) {
		var exec,
			bulk = key == null,
			i = 0,
			length = elems.length;

		// Sets many values
		if ( key && typeof key === "object" ) {
			for ( i in key ) {
				jQuery.access( elems, fn, i, key[i], 1, emptyGet, value );
			}
			chainable = 1;

		// Sets one value
		} else if ( value !== undefined ) {
			// Optionally, function values get executed if exec is true
			exec = pass === undefined && jQuery.isFunction( value );

			if ( bulk ) {
				// Bulk operations only iterate when executing function values
				if ( exec ) {
					exec = fn;
					fn = function( elem, key, value ) {
						return exec.call( jQuery( elem ), value );
					};

				// Otherwise they run against the entire set
				} else {
					fn.call( elems, value );
					fn = null;
				}
			}

			if ( fn ) {
				for (; i < length; i++ ) {
					fn( elems[i], key, exec ? value.call( elems[i], i, fn( elems[i], key ) ) : value, pass );
				}
			}

			chainable = 1;
		}

		return chainable ?
			elems :

			// Gets
			bulk ?
				fn.call( elems ) :
				length ? fn( elems[0], key ) : emptyGet;
	},

	now: function() {
		return ( new Date() ).getTime();
	}
});

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called after the browser event has already occurred.
		// we once tried to use readyState "interactive" here, but it caused issues like the one
		// discovered by ChrisS here: http://bugs.jquery.com/ticket/12282#comment:15
		if ( document.readyState === "complete" ) {
			// Handle it asynchronously to allow scripts the opportunity to delay ready
			setTimeout( jQuery.ready, 1 );

		// Standards-based browsers support DOMContentLoaded
		} else if ( document.addEventListener ) {
			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", DOMContentLoaded, false );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", jQuery.ready, false );

		// If IE event model is used
		} else {
			// Ensure firing before onload, maybe late but safe also for iframes
			document.attachEvent( "onreadystatechange", DOMContentLoaded );

			// A fallback to window.onload, that will always work
			window.attachEvent( "onload", jQuery.ready );

			// If IE and not a frame
			// continually check to see if the document is ready
			var top = false;

			try {
				top = window.frameElement == null && document.documentElement;
			} catch(e) {}

			if ( top && top.doScroll ) {
				(function doScrollCheck() {
					if ( !jQuery.isReady ) {

						try {
							// Use the trick by Diego Perini
							// http://javascript.nwbox.com/IEContentLoaded/
							top.doScroll("left");
						} catch(e) {
							return setTimeout( doScrollCheck, 50 );
						}

						// and execute any waiting functions
						jQuery.ready();
					}
				})();
			}
		}
	}
	return readyList.promise( obj );
};

// Populate the class2type map
jQuery.each("Boolean Number String Function Array Date RegExp Object".split(" "), function(i, name) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
});

// All jQuery objects should point back to these
rootjQuery = jQuery(document);
// String to Object options format cache
var optionsCache = {};

// Convert String-formatted options into Object-formatted ones and store in cache
function createOptions( options ) {
	var object = optionsCache[ options ] = {};
	jQuery.each( options.split( core_rspace ), function( _, flag ) {
		object[ flag ] = true;
	});
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		( optionsCache[ options ] || createOptions( options ) ) :
		jQuery.extend( {}, options );

	var // Last fire value (for non-forgettable lists)
		memory,
		// Flag to know if list was already fired
		fired,
		// Flag to know if list is currently firing
		firing,
		// First callback to fire (used internally by add and fireWith)
		firingStart,
		// End of the loop when firing
		firingLength,
		// Index of currently firing callback (modified by remove if needed)
		firingIndex,
		// Actual callback list
		list = [],
		// Stack of fire calls for repeatable lists
		stack = !options.once && [],
		// Fire callbacks
		fire = function( data ) {
			memory = options.memory && data;
			fired = true;
			firingIndex = firingStart || 0;
			firingStart = 0;
			firingLength = list.length;
			firing = true;
			for ( ; list && firingIndex < firingLength; firingIndex++ ) {
				if ( list[ firingIndex ].apply( data[ 0 ], data[ 1 ] ) === false && options.stopOnFalse ) {
					memory = false; // To prevent further calls using add
					break;
				}
			}
			firing = false;
			if ( list ) {
				if ( stack ) {
					if ( stack.length ) {
						fire( stack.shift() );
					}
				} else if ( memory ) {
					list = [];
				} else {
					self.disable();
				}
			}
		},
		// Actual Callbacks object
		self = {
			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {
					// First, we save the current length
					var start = list.length;
					(function add( args ) {
						jQuery.each( args, function( _, arg ) {
							var type = jQuery.type( arg );
							if ( type === "function" ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && type !== "string" ) {
								// Inspect recursively
								add( arg );
							}
						});
					})( arguments );
					// Do we need to add the callbacks to the
					// current firing batch?
					if ( firing ) {
						firingLength = list.length;
					// With memory, if we're not firing then
					// we should call right away
					} else if ( memory ) {
						firingStart = start;
						fire( memory );
					}
				}
				return this;
			},
			// Remove a callback from the list
			remove: function() {
				if ( list ) {
					jQuery.each( arguments, function( _, arg ) {
						var index;
						while( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
							list.splice( index, 1 );
							// Handle firing indexes
							if ( firing ) {
								if ( index <= firingLength ) {
									firingLength--;
								}
								if ( index <= firingIndex ) {
									firingIndex--;
								}
							}
						}
					});
				}
				return this;
			},
			// Control if a given callback is in the list
			has: function( fn ) {
				return jQuery.inArray( fn, list ) > -1;
			},
			// Remove all callbacks from the list
			empty: function() {
				list = [];
				return this;
			},
			// Have the list do nothing anymore
			disable: function() {
				list = stack = memory = undefined;
				return this;
			},
			// Is it disabled?
			disabled: function() {
				return !list;
			},
			// Lock the list in its current state
			lock: function() {
				stack = undefined;
				if ( !memory ) {
					self.disable();
				}
				return this;
			},
			// Is it locked?
			locked: function() {
				return !stack;
			},
			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				args = args || [];
				args = [ context, args.slice ? args.slice() : args ];
				if ( list && ( !fired || stack ) ) {
					if ( firing ) {
						stack.push( args );
					} else {
						fire( args );
					}
				}
				return this;
			},
			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},
			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};
jQuery.extend({

	Deferred: function( func ) {
		var tuples = [
				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks("memory") ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred(function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var action = tuple[ 0 ],
								fn = fns[ i ];
							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[1] ]( jQuery.isFunction( fn ) ?
								function() {
									var returned = fn.apply( this, arguments );
									if ( returned && jQuery.isFunction( returned.promise ) ) {
										returned.promise()
											.done( newDefer.resolve )
											.fail( newDefer.reject )
											.progress( newDefer.notify );
									} else {
										newDefer[ action + "With" ]( this === deferred ? newDefer : this, [ returned ] );
									}
								} :
								newDefer[ action ]
							);
						});
						fns = null;
					}).promise();
				},
				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[1] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add(function() {
					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ] = list.fire
			deferred[ tuple[0] ] = list.fire;
			deferred[ tuple[0] + "With" ] = list.fireWith;
		});

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( subordinate /* , ..., subordinateN */ ) {
		var i = 0,
			resolveValues = core_slice.call( arguments ),
			length = resolveValues.length,

			// the count of uncompleted subordinates
			remaining = length !== 1 || ( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,

			// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),

			// Update function for both resolve and progress values
			updateFunc = function( i, contexts, values ) {
				return function( value ) {
					contexts[ i ] = this;
					values[ i ] = arguments.length > 1 ? core_slice.call( arguments ) : value;
					if( values === progressValues ) {
						deferred.notifyWith( contexts, values );
					} else if ( !( --remaining ) ) {
						deferred.resolveWith( contexts, values );
					}
				};
			},

			progressValues, progressContexts, resolveContexts;

		// add listeners to Deferred subordinates; treat others as resolved
		if ( length > 1 ) {
			progressValues = new Array( length );
			progressContexts = new Array( length );
			resolveContexts = new Array( length );
			for ( ; i < length; i++ ) {
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {
					resolveValues[ i ].promise()
						.done( updateFunc( i, resolveContexts, resolveValues ) )
						.fail( deferred.reject )
						.progress( updateFunc( i, progressContexts, progressValues ) );
				} else {
					--remaining;
				}
			}
		}

		// if we're not waiting on anything, resolve the master
		if ( !remaining ) {
			deferred.resolveWith( resolveContexts, resolveValues );
		}

		return deferred.promise();
	}
});
jQuery.support = (function() {

	var support,
		all,
		a,
		select,
		opt,
		input,
		fragment,
		eventName,
		i,
		isSupported,
		clickFn,
		div = document.createElement("div");

	// Setup
	div.setAttribute( "className", "t" );
	div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

	// Support tests won't run in some limited or non-browser environments
	all = div.getElementsByTagName("*");
	a = div.getElementsByTagName("a")[ 0 ];
	if ( !all || !a || !all.length ) {
		return {};
	}

	// First batch of tests
	select = document.createElement("select");
	opt = select.appendChild( document.createElement("option") );
	input = div.getElementsByTagName("input")[ 0 ];

	a.style.cssText = "top:1px;float:left;opacity:.5";
	support = {
		// IE strips leading whitespace when .innerHTML is used
		leadingWhitespace: ( div.firstChild.nodeType === 3 ),

		// Make sure that tbody elements aren't automatically inserted
		// IE will insert them into empty tables
		tbody: !div.getElementsByTagName("tbody").length,

		// Make sure that link elements get serialized correctly by innerHTML
		// This requires a wrapper element in IE
		htmlSerialize: !!div.getElementsByTagName("link").length,

		// Get the style information from getAttribute
		// (IE uses .cssText instead)
		style: /top/.test( a.getAttribute("style") ),

		// Make sure that URLs aren't manipulated
		// (IE normalizes it by default)
		hrefNormalized: ( a.getAttribute("href") === "/a" ),

		// Make sure that element opacity exists
		// (IE uses filter instead)
		// Use a regex to work around a WebKit issue. See #5145
		opacity: /^0.5/.test( a.style.opacity ),

		// Verify style float existence
		// (IE uses styleFloat instead of cssFloat)
		cssFloat: !!a.style.cssFloat,

		// Make sure that if no value is specified for a checkbox
		// that it defaults to "on".
		// (WebKit defaults to "" instead)
		checkOn: ( input.value === "on" ),

		// Make sure that a selected-by-default option has a working selected property.
		// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
		optSelected: opt.selected,

		// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
		getSetAttribute: div.className !== "t",

		// Tests for enctype support on a form (#6743)
		enctype: !!document.createElement("form").enctype,

		// Makes sure cloning an html5 element does not cause problems
		// Where outerHTML is undefined, this still works
		html5Clone: document.createElement("nav").cloneNode( true ).outerHTML !== "<:nav></:nav>",

		// jQuery.support.boxModel DEPRECATED in 1.8 since we don't support Quirks Mode
		boxModel: ( document.compatMode === "CSS1Compat" ),

		// Will be defined later
		submitBubbles: true,
		changeBubbles: true,
		focusinBubbles: false,
		deleteExpando: true,
		noCloneEvent: true,
		inlineBlockNeedsLayout: false,
		shrinkWrapBlocks: false,
		reliableMarginRight: true,
		boxSizingReliable: true,
		pixelPosition: false
	};

	// Make sure checked status is properly cloned
	input.checked = true;
	support.noCloneChecked = input.cloneNode( true ).checked;

	// Make sure that the options inside disabled selects aren't marked as disabled
	// (WebKit marks them as disabled)
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Test to see if it's possible to delete an expando from an element
	// Fails in Internet Explorer
	try {
		delete div.test;
	} catch( e ) {
		support.deleteExpando = false;
	}

	if ( !div.addEventListener && div.attachEvent && div.fireEvent ) {
		div.attachEvent( "onclick", clickFn = function() {
			// Cloning a node shouldn't copy over any
			// bound event handlers (IE does this)
			support.noCloneEvent = false;
		});
		div.cloneNode( true ).fireEvent("onclick");
		div.detachEvent( "onclick", clickFn );
	}

	// Check if a radio maintains its value
	// after being appended to the DOM
	input = document.createElement("input");
	input.value = "t";
	input.setAttribute( "type", "radio" );
	support.radioValue = input.value === "t";

	input.setAttribute( "checked", "checked" );

	// #11217 - WebKit loses check when the name is after the checked attribute
	input.setAttribute( "name", "t" );

	div.appendChild( input );
	fragment = document.createDocumentFragment();
	fragment.appendChild( div.lastChild );

	// WebKit doesn't clone checked state correctly in fragments
	support.checkClone = fragment.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Check if a disconnected checkbox will retain its checked
	// value of true after appended to the DOM (IE6/7)
	support.appendChecked = input.checked;

	fragment.removeChild( input );
	fragment.appendChild( div );

	// Technique from Juriy Zaytsev
	// http://perfectionkills.com/detecting-event-support-without-browser-sniffing/
	// We only care about the case where non-standard event systems
	// are used, namely in IE. Short-circuiting here helps us to
	// avoid an eval call (in setAttribute) which can cause CSP
	// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
	if ( div.attachEvent ) {
		for ( i in {
			submit: true,
			change: true,
			focusin: true
		}) {
			eventName = "on" + i;
			isSupported = ( eventName in div );
			if ( !isSupported ) {
				div.setAttribute( eventName, "return;" );
				isSupported = ( typeof div[ eventName ] === "function" );
			}
			support[ i + "Bubbles" ] = isSupported;
		}
	}

	// Run tests that need a body at doc ready
	jQuery(function() {
		var container, div, tds, marginDiv,
			divReset = "padding:0;margin:0;border:0;display:block;overflow:hidden;",
			body = document.getElementsByTagName("body")[0];

		if ( !body ) {
			// Return for frameset docs that don't have a body
			return;
		}

		container = document.createElement("div");
		container.style.cssText = "visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px";
		body.insertBefore( container, body.firstChild );

		// Construct the test element
		div = document.createElement("div");
		container.appendChild( div );

		// Check if table cells still have offsetWidth/Height when they are set
		// to display:none and there are still other visible table cells in a
		// table row; if so, offsetWidth/Height are not reliable for use when
		// determining if an element has been hidden directly using
		// display:none (it is still safe to use offsets if a parent element is
		// hidden; don safety goggles and see bug #4512 for more information).
		// (only IE 8 fails this test)
		div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
		tds = div.getElementsByTagName("td");
		tds[ 0 ].style.cssText = "padding:0;margin:0;border:0;display:none";
		isSupported = ( tds[ 0 ].offsetHeight === 0 );

		tds[ 0 ].style.display = "";
		tds[ 1 ].style.display = "none";

		// Check if empty table cells still have offsetWidth/Height
		// (IE <= 8 fail this test)
		support.reliableHiddenOffsets = isSupported && ( tds[ 0 ].offsetHeight === 0 );

		// Check box-sizing and margin behavior
		div.innerHTML = "";
		div.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;";
		support.boxSizing = ( div.offsetWidth === 4 );
		support.doesNotIncludeMarginInBodyOffset = ( body.offsetTop !== 1 );

		// NOTE: To any future maintainer, we've window.getComputedStyle
		// because jsdom on node.js will break without it.
		if ( window.getComputedStyle ) {
			support.pixelPosition = ( window.getComputedStyle( div, null ) || {} ).top !== "1%";
			support.boxSizingReliable = ( window.getComputedStyle( div, null ) || { width: "4px" } ).width === "4px";

			// Check if div with explicit width and no margin-right incorrectly
			// gets computed margin-right based on width of container. For more
			// info see bug #3333
			// Fails in WebKit before Feb 2011 nightlies
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
			marginDiv = document.createElement("div");
			marginDiv.style.cssText = div.style.cssText = divReset;
			marginDiv.style.marginRight = marginDiv.style.width = "0";
			div.style.width = "1px";
			div.appendChild( marginDiv );
			support.reliableMarginRight =
				!parseFloat( ( window.getComputedStyle( marginDiv, null ) || {} ).marginRight );
		}

		if ( typeof div.style.zoom !== "undefined" ) {
			// Check if natively block-level elements act like inline-block
			// elements when setting their display to 'inline' and giving
			// them layout
			// (IE < 8 does this)
			div.innerHTML = "";
			div.style.cssText = divReset + "width:1px;padding:1px;display:inline;zoom:1";
			support.inlineBlockNeedsLayout = ( div.offsetWidth === 3 );

			// Check if elements with layout shrink-wrap their children
			// (IE 6 does this)
			div.style.display = "block";
			div.style.overflow = "visible";
			div.innerHTML = "<div></div>";
			div.firstChild.style.width = "5px";
			support.shrinkWrapBlocks = ( div.offsetWidth !== 3 );

			container.style.zoom = 1;
		}

		// Null elements to avoid leaks in IE
		body.removeChild( container );
		container = div = tds = marginDiv = null;
	});

	// Null elements to avoid leaks in IE
	fragment.removeChild( div );
	all = a = select = opt = input = fragment = div = null;

	return support;
})();
var rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
	rmultiDash = /([A-Z])/g;

jQuery.extend({
	cache: {},

	deletedIds: [],

	// Remove at next major release (1.9/2.0)
	uuid: 0,

	// Unique for each copy of jQuery on the page
	// Non-digits removed to match rinlinejQuery
	expando: "jQuery" + ( jQuery.fn.jquery + Math.random() ).replace( /\D/g, "" ),

	// The following elements throw uncatchable exceptions if you
	// attempt to add expando properties to them.
	noData: {
		"embed": true,
		// Ban all objects except for Flash (which handle expandos)
		"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
		"applet": true
	},

	hasData: function( elem ) {
		elem = elem.nodeType ? jQuery.cache[ elem[jQuery.expando] ] : elem[ jQuery.expando ];
		return !!elem && !isEmptyDataObject( elem );
	},

	data: function( elem, name, data, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache, ret,
			internalKey = jQuery.expando,
			getByName = typeof name === "string",

			// We have to handle DOM nodes and JS objects differently because IE6-7
			// can't GC object references properly across the DOM-JS boundary
			isNode = elem.nodeType,

			// Only DOM nodes need the global jQuery cache; JS object data is
			// attached directly to the object so GC can occur automatically
			cache = isNode ? jQuery.cache : elem,

			// Only defining an ID for JS objects if its cache already exists allows
			// the code to shortcut on the same path as a DOM node with no cache
			id = isNode ? elem[ internalKey ] : elem[ internalKey ] && internalKey;

		// Avoid doing any more work than we need to when trying to get data on an
		// object that has no data at all
		if ( (!id || !cache[id] || (!pvt && !cache[id].data)) && getByName && data === undefined ) {
			return;
		}

		if ( !id ) {
			// Only DOM nodes need a new unique ID for each element since their data
			// ends up in the global cache
			if ( isNode ) {
				elem[ internalKey ] = id = jQuery.deletedIds.pop() || jQuery.guid++;
			} else {
				id = internalKey;
			}
		}

		if ( !cache[ id ] ) {
			cache[ id ] = {};

			// Avoids exposing jQuery metadata on plain JS objects when the object
			// is serialized using JSON.stringify
			if ( !isNode ) {
				cache[ id ].toJSON = jQuery.noop;
			}
		}

		// An object can be passed to jQuery.data instead of a key/value pair; this gets
		// shallow copied over onto the existing cache
		if ( typeof name === "object" || typeof name === "function" ) {
			if ( pvt ) {
				cache[ id ] = jQuery.extend( cache[ id ], name );
			} else {
				cache[ id ].data = jQuery.extend( cache[ id ].data, name );
			}
		}

		thisCache = cache[ id ];

		// jQuery data() is stored in a separate object inside the object's internal data
		// cache in order to avoid key collisions between internal data and user-defined
		// data.
		if ( !pvt ) {
			if ( !thisCache.data ) {
				thisCache.data = {};
			}

			thisCache = thisCache.data;
		}

		if ( data !== undefined ) {
			thisCache[ jQuery.camelCase( name ) ] = data;
		}

		// Check for both converted-to-camel and non-converted data property names
		// If a data property was specified
		if ( getByName ) {

			// First Try to find as-is property data
			ret = thisCache[ name ];

			// Test for null|undefined property data
			if ( ret == null ) {

				// Try to find the camelCased property
				ret = thisCache[ jQuery.camelCase( name ) ];
			}
		} else {
			ret = thisCache;
		}

		return ret;
	},

	removeData: function( elem, name, pvt /* Internal Use Only */ ) {
		if ( !jQuery.acceptData( elem ) ) {
			return;
		}

		var thisCache, i, l,

			isNode = elem.nodeType,

			// See jQuery.data for more information
			cache = isNode ? jQuery.cache : elem,
			id = isNode ? elem[ jQuery.expando ] : jQuery.expando;

		// If there is already no cache entry for this object, there is no
		// purpose in continuing
		if ( !cache[ id ] ) {
			return;
		}

		if ( name ) {

			thisCache = pvt ? cache[ id ] : cache[ id ].data;

			if ( thisCache ) {

				// Support array or space separated string names for data keys
				if ( !jQuery.isArray( name ) ) {

					// try the string as a key before any manipulation
					if ( name in thisCache ) {
						name = [ name ];
					} else {

						// split the camel cased version by spaces unless a key with the spaces exists
						name = jQuery.camelCase( name );
						if ( name in thisCache ) {
							name = [ name ];
						} else {
							name = name.split(" ");
						}
					}
				}

				for ( i = 0, l = name.length; i < l; i++ ) {
					delete thisCache[ name[i] ];
				}

				// If there is no data left in the cache, we want to continue
				// and let the cache object itself get destroyed
				if ( !( pvt ? isEmptyDataObject : jQuery.isEmptyObject )( thisCache ) ) {
					return;
				}
			}
		}

		// See jQuery.data for more information
		if ( !pvt ) {
			delete cache[ id ].data;

			// Don't destroy the parent cache unless the internal data object
			// had been the only thing left in it
			if ( !isEmptyDataObject( cache[ id ] ) ) {
				return;
			}
		}

		// Destroy the cache
		if ( isNode ) {
			jQuery.cleanData( [ elem ], true );

		// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
		} else if ( jQuery.support.deleteExpando || cache != cache.window ) {
			delete cache[ id ];

		// When all else fails, null
		} else {
			cache[ id ] = null;
		}
	},

	// For internal use only.
	_data: function( elem, name, data ) {
		return jQuery.data( elem, name, data, true );
	},

	// A method for determining if a DOM node can handle the data expando
	acceptData: function( elem ) {
		var noData = elem.nodeName && jQuery.noData[ elem.nodeName.toLowerCase() ];

		// nodes accept data unless otherwise specified; rejection can be conditional
		return !noData || noData !== true && elem.getAttribute("classid") === noData;
	}
});

jQuery.fn.extend({
	data: function( key, value ) {
		var parts, part, attr, name, l,
			elem = this[0],
			i = 0,
			data = null;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = jQuery.data( elem );

				if ( elem.nodeType === 1 && !jQuery._data( elem, "parsedAttrs" ) ) {
					attr = elem.attributes;
					for ( l = attr.length; i < l; i++ ) {
						name = attr[i].name;

						if ( !name.indexOf( "data-" ) ) {
							name = jQuery.camelCase( name.substring(5) );

							dataAttr( elem, name, data[ name ] );
						}
					}
					jQuery._data( elem, "parsedAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each(function() {
				jQuery.data( this, key );
			});
		}

		parts = key.split( ".", 2 );
		parts[1] = parts[1] ? "." + parts[1] : "";
		part = parts[1] + "!";

		return jQuery.access( this, function( value ) {

			if ( value === undefined ) {
				data = this.triggerHandler( "getData" + part, [ parts[0] ] );

				// Try to fetch any internally stored data first
				if ( data === undefined && elem ) {
					data = jQuery.data( elem, key );
					data = dataAttr( elem, key, data );
				}

				return data === undefined && parts[1] ?
					this.data( parts[0] ) :
					data;
			}

			parts[1] = value;
			this.each(function() {
				var self = jQuery( this );

				self.triggerHandler( "setData" + part, parts );
				jQuery.data( this, key, value );
				self.triggerHandler( "changeData" + part, parts );
			});
		}, null, value, arguments.length > 1, null, false );
	},

	removeData: function( key ) {
		return this.each(function() {
			jQuery.removeData( this, key );
		});
	}
});

function dataAttr( elem, key, data ) {
	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {

		var name = "data-" + key.replace( rmultiDash, "-$1" ).toLowerCase();

		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
				data === "false" ? false :
				data === "null" ? null :
				// Only convert to a number if it doesn't change the string
				+data + "" === data ? +data :
				rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch( e ) {}

			// Make sure we set the data so it isn't changed later
			jQuery.data( elem, key, data );

		} else {
			data = undefined;
		}
	}

	return data;
}

// checks a cache object for emptiness
function isEmptyDataObject( obj ) {
	var name;
	for ( name in obj ) {

		// if the public data object is empty, the private is still empty
		if ( name === "data" && jQuery.isEmptyObject( obj[name] ) ) {
			continue;
		}
		if ( name !== "toJSON" ) {
			return false;
		}
	}

	return true;
}
jQuery.extend({
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = jQuery._data( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || jQuery.isArray(data) ) {
					queue = jQuery._data( elem, type, jQuery.makeArray(data) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// not intended for public consumption - generates a queueHooks object, or returns the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return jQuery._data( elem, key ) || jQuery._data( elem, key, {
			empty: jQuery.Callbacks("once memory").add(function() {
				jQuery.removeData( elem, type + "queue", true );
				jQuery.removeData( elem, key, true );
			})
		});
	}
});

jQuery.fn.extend({
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[0], type );
		}

		return data === undefined ?
			this :
			this.each(function() {
				var queue = jQuery.queue( this, type, data );

				// ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[0] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			});
	},
	dequeue: function( type ) {
		return this.each(function() {
			jQuery.dequeue( this, type );
		});
	},
	// Based off of the plugin by Clint Helfers, with permission.
	// http://blindsignals.com/index.php/2009/07/jquery-delay/
	delay: function( time, type ) {
		time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
		type = type || "fx";

		return this.queue( type, function( next, hooks ) {
			var timeout = setTimeout( next, time );
			hooks.stop = function() {
				clearTimeout( timeout );
			};
		});
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},
	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while( i-- ) {
			tmp = jQuery._data( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
});
var nodeHook, boolHook, fixSpecified,
	rclass = /[\t\r\n]/g,
	rreturn = /\r/g,
	rtype = /^(?:button|input)$/i,
	rfocusable = /^(?:button|input|object|select|textarea)$/i,
	rclickable = /^a(?:rea|)$/i,
	rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
	getSetAttribute = jQuery.support.getSetAttribute;

jQuery.fn.extend({
	attr: function( name, value ) {
		return jQuery.access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each(function() {
			jQuery.removeAttr( this, name );
		});
	},

	prop: function( name, value ) {
		return jQuery.access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		name = jQuery.propFix[ name ] || name;
		return this.each(function() {
			// try/catch handles cases where IE balks (such as removing a property on window)
			try {
				this[ name ] = undefined;
				delete this[ name ];
			} catch( e ) {}
		});
	},

	addClass: function( value ) {
		var classNames, i, l, elem,
			setClass, c, cl;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).addClass( value.call(this, j, this.className) );
			});
		}

		if ( value && typeof value === "string" ) {
			classNames = value.split( core_rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];

				if ( elem.nodeType === 1 ) {
					if ( !elem.className && classNames.length === 1 ) {
						elem.className = value;

					} else {
						setClass = " " + elem.className + " ";

						for ( c = 0, cl = classNames.length; c < cl; c++ ) {
							if ( setClass.indexOf( " " + classNames[ c ] + " " ) < 0 ) {
								setClass += classNames[ c ] + " ";
							}
						}
						elem.className = jQuery.trim( setClass );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var removes, className, elem, c, cl, i, l;

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( j ) {
				jQuery( this ).removeClass( value.call(this, j, this.className) );
			});
		}
		if ( (value && typeof value === "string") || value === undefined ) {
			removes = ( value || "" ).split( core_rspace );

			for ( i = 0, l = this.length; i < l; i++ ) {
				elem = this[ i ];
				if ( elem.nodeType === 1 && elem.className ) {

					className = (" " + elem.className + " ").replace( rclass, " " );

					// loop over each item in the removal list
					for ( c = 0, cl = removes.length; c < cl; c++ ) {
						// Remove until there is nothing to remove,
						while ( className.indexOf(" " + removes[ c ] + " ") >= 0 ) {
							className = className.replace( " " + removes[ c ] + " " , " " );
						}
					}
					elem.className = value ? jQuery.trim( className ) : "";
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value,
			isBool = typeof stateVal === "boolean";

		if ( jQuery.isFunction( value ) ) {
			return this.each(function( i ) {
				jQuery( this ).toggleClass( value.call(this, i, this.className, stateVal), stateVal );
			});
		}

		return this.each(function() {
			if ( type === "string" ) {
				// toggle individual class names
				var className,
					i = 0,
					self = jQuery( this ),
					state = stateVal,
					classNames = value.split( core_rspace );

				while ( (className = classNames[ i++ ]) ) {
					// check each className given, space separated list
					state = isBool ? state : !self.hasClass( className );
					self[ state ? "addClass" : "removeClass" ]( className );
				}

			} else if ( type === "undefined" || type === "boolean" ) {
				if ( this.className ) {
					// store className if set
					jQuery._data( this, "__className__", this.className );
				}

				// toggle whole className
				this.className = this.className || value === false ? "" : jQuery._data( this, "__className__" ) || "";
			}
		});
	},

	hasClass: function( selector ) {
		var className = " " + selector + " ",
			i = 0,
			l = this.length;
		for ( ; i < l; i++ ) {
			if ( this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf( className ) >= 0 ) {
				return true;
			}
		}

		return false;
	},

	val: function( value ) {
		var hooks, ret, isFunction,
			elem = this[0];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] || jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks && "get" in hooks && (ret = hooks.get( elem, "value" )) !== undefined ) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ?
					// handle most common string cases
					ret.replace(rreturn, "") :
					// handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return;
		}

		isFunction = jQuery.isFunction( value );

		return this.each(function( i ) {
			var val,
				self = jQuery(this);

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, self.val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";
			} else if ( typeof val === "number" ) {
				val += "";
			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map(val, function ( value ) {
					return value == null ? "" : value + "";
				});
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !("set" in hooks) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		});
	}
});

jQuery.extend({
	valHooks: {
		option: {
			get: function( elem ) {
				// attributes.value is undefined in Blackberry 4.7 but
				// uses .value. See #6932
				var val = elem.attributes.value;
				return !val || val.specified ? elem.value : elem.text;
			}
		},
		select: {
			get: function( elem ) {
				var value, option,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one" || index < 0,
					values = one ? null : [],
					max = one ? index + 1 : options.length,
					i = index < 0 ?
						max :
						one ? index : 0;

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// oldIE doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&
							// Don't return options that are disabled or in a disabled optgroup
							( jQuery.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null ) &&
							( !option.parentNode.disabled || !jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var values = jQuery.makeArray( value );

				jQuery(elem).find("option").each(function() {
					this.selected = jQuery.inArray( jQuery(this).val(), values ) >= 0;
				});

				if ( !values.length ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	},

	// Unused in 1.8, left in so attrFn-stabbers won't die; remove in 1.9
	attrFn: {},

	attr: function( elem, name, value, pass ) {
		var ret, hooks, notxml,
			nType = elem.nodeType;

		// don't get/set attributes on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( pass && jQuery.isFunction( jQuery.fn[ name ] ) ) {
			return jQuery( elem )[ name ]( value );
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		// All attributes are lowercase
		// Grab necessary hook if one is defined
		if ( notxml ) {
			name = name.toLowerCase();
			hooks = jQuery.attrHooks[ name ] || ( rboolean.test( name ) ? boolHook : nodeHook );
		}

		if ( value !== undefined ) {

			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;

			} else if ( hooks && "set" in hooks && notxml && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				elem.setAttribute( name, value + "" );
				return value;
			}

		} else if ( hooks && "get" in hooks && notxml && (ret = hooks.get( elem, name )) !== null ) {
			return ret;

		} else {

			ret = elem.getAttribute( name );

			// Non-existent attributes return null, we normalize to undefined
			return ret === null ?
				undefined :
				ret;
		}
	},

	removeAttr: function( elem, value ) {
		var propName, attrNames, name, isBool,
			i = 0;

		if ( value && elem.nodeType === 1 ) {

			attrNames = value.split( core_rspace );

			for ( ; i < attrNames.length; i++ ) {
				name = attrNames[ i ];

				if ( name ) {
					propName = jQuery.propFix[ name ] || name;
					isBool = rboolean.test( name );

					// See #9699 for explanation of this approach (setting first, then removal)
					// Do not do this for boolean attributes (see #10870)
					if ( !isBool ) {
						jQuery.attr( elem, name, "" );
					}
					elem.removeAttribute( getSetAttribute ? name : propName );

					// Set corresponding property to false for boolean attributes
					if ( isBool && propName in elem ) {
						elem[ propName ] = false;
					}
				}
			}
		}
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				// We can't allow the type property to be changed (since it causes problems in IE)
				if ( rtype.test( elem.nodeName ) && elem.parentNode ) {
					jQuery.error( "type property can't be changed" );
				} else if ( !jQuery.support.radioValue && value === "radio" && jQuery.nodeName(elem, "input") ) {
					// Setting the type on a radio button after the value resets the value in IE6-9
					// Reset value to it's default in case type is set after value
					// This is for element creation
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		},
		// Use the value property for back compat
		// Use the nodeHook for button elements in IE6/7 (#1954)
		value: {
			get: function( elem, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.get( elem, name );
				}
				return name in elem ?
					elem.value :
					null;
			},
			set: function( elem, value, name ) {
				if ( nodeHook && jQuery.nodeName( elem, "button" ) ) {
					return nodeHook.set( elem, value, name );
				}
				// Does not return so that setAttribute is also used
				elem.value = value;
			}
		}
	},

	propFix: {
		tabindex: "tabIndex",
		readonly: "readOnly",
		"for": "htmlFor",
		"class": "className",
		maxlength: "maxLength",
		cellspacing: "cellSpacing",
		cellpadding: "cellPadding",
		rowspan: "rowSpan",
		colspan: "colSpan",
		usemap: "useMap",
		frameborder: "frameBorder",
		contenteditable: "contentEditable"
	},

	prop: function( elem, name, value ) {
		var ret, hooks, notxml,
			nType = elem.nodeType;

		// don't get/set properties on text, comment and attribute nodes
		if ( !elem || nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		notxml = nType !== 1 || !jQuery.isXMLDoc( elem );

		if ( notxml ) {
			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks && (ret = hooks.set( elem, value, name )) !== undefined ) {
				return ret;

			} else {
				return ( elem[ name ] = value );
			}

		} else {
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, name )) !== null ) {
				return ret;

			} else {
				return elem[ name ];
			}
		}
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {
				// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				var attributeNode = elem.getAttributeNode("tabindex");

				return attributeNode && attributeNode.specified ?
					parseInt( attributeNode.value, 10 ) :
					rfocusable.test( elem.nodeName ) || rclickable.test( elem.nodeName ) && elem.href ?
						0 :
						undefined;
			}
		}
	}
});

// Hook for boolean attributes
boolHook = {
	get: function( elem, name ) {
		// Align boolean attributes with corresponding properties
		// Fall back to attribute presence where some booleans are not supported
		var attrNode,
			property = jQuery.prop( elem, name );
		return property === true || typeof property !== "boolean" && ( attrNode = elem.getAttributeNode(name) ) && attrNode.nodeValue !== false ?
			name.toLowerCase() :
			undefined;
	},
	set: function( elem, value, name ) {
		var propName;
		if ( value === false ) {
			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			// value is true since we know at this point it's type boolean and not false
			// Set boolean attributes to the same name and set the DOM property
			propName = jQuery.propFix[ name ] || name;
			if ( propName in elem ) {
				// Only set the IDL specifically if it already exists on the element
				elem[ propName ] = true;
			}

			elem.setAttribute( name, name.toLowerCase() );
		}
		return name;
	}
};

// IE6/7 do not support getting/setting some attributes with get/setAttribute
if ( !getSetAttribute ) {

	fixSpecified = {
		name: true,
		id: true,
		coords: true
	};

	// Use this for any attribute in IE6/7
	// This fixes almost every IE6/7 issue
	nodeHook = jQuery.valHooks.button = {
		get: function( elem, name ) {
			var ret;
			ret = elem.getAttributeNode( name );
			return ret && ( fixSpecified[ name ] ? ret.value !== "" : ret.specified ) ?
				ret.value :
				undefined;
		},
		set: function( elem, value, name ) {
			// Set the existing or create a new attribute node
			var ret = elem.getAttributeNode( name );
			if ( !ret ) {
				ret = document.createAttribute( name );
				elem.setAttributeNode( ret );
			}
			return ( ret.value = value + "" );
		}
	};

	// Set width and height to auto instead of 0 on empty string( Bug #8150 )
	// This is for removals
	jQuery.each([ "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			set: function( elem, value ) {
				if ( value === "" ) {
					elem.setAttribute( name, "auto" );
					return value;
				}
			}
		});
	});

	// Set contenteditable to false on removals(#10429)
	// Setting to empty string throws an error as an invalid value
	jQuery.attrHooks.contenteditable = {
		get: nodeHook.get,
		set: function( elem, value, name ) {
			if ( value === "" ) {
				value = "false";
			}
			nodeHook.set( elem, value, name );
		}
	};
}


// Some attributes require a special call on IE
if ( !jQuery.support.hrefNormalized ) {
	jQuery.each([ "href", "src", "width", "height" ], function( i, name ) {
		jQuery.attrHooks[ name ] = jQuery.extend( jQuery.attrHooks[ name ], {
			get: function( elem ) {
				var ret = elem.getAttribute( name, 2 );
				return ret === null ? undefined : ret;
			}
		});
	});
}

if ( !jQuery.support.style ) {
	jQuery.attrHooks.style = {
		get: function( elem ) {
			// Return undefined in the case of empty string
			// Normalize to lowercase since IE uppercases css property names
			return elem.style.cssText.toLowerCase() || undefined;
		},
		set: function( elem, value ) {
			return ( elem.style.cssText = value + "" );
		}
	};
}

// Safari mis-reports the default selected property of an option
// Accessing the parent's selectedIndex property fixes it
if ( !jQuery.support.optSelected ) {
	jQuery.propHooks.selected = jQuery.extend( jQuery.propHooks.selected, {
		get: function( elem ) {
			var parent = elem.parentNode;

			if ( parent ) {
				parent.selectedIndex;

				// Make sure that it also works with optgroups, see #5701
				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
			return null;
		}
	});
}

// IE6/7 call enctype encoding
if ( !jQuery.support.enctype ) {
	jQuery.propFix.enctype = "encoding";
}

// Radios and checkboxes getter/setter
if ( !jQuery.support.checkOn ) {
	jQuery.each([ "radio", "checkbox" ], function() {
		jQuery.valHooks[ this ] = {
			get: function( elem ) {
				// Handle the case where in Webkit "" is returned instead of "on" if a value isn't specified
				return elem.getAttribute("value") === null ? "on" : elem.value;
			}
		};
	});
}
jQuery.each([ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = jQuery.extend( jQuery.valHooks[ this ], {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery(elem).val(), value ) >= 0 );
			}
		}
	});
});
var rformElems = /^(?:textarea|input|select)$/i,
	rtypenamespace = /^([^\.]*|)(?:\.(.+)|)$/,
	rhoverHack = /(?:^|\s)hover(\.\S+|)\b/,
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|contextmenu)|click/,
	rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
	hoverHack = function( events ) {
		return jQuery.event.special.hover ? events : events.replace( rhoverHack, "mouseenter$1 mouseleave$1" );
	};

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	add: function( elem, types, handler, data, selector ) {

		var elemData, eventHandle, events,
			t, tns, type, namespaces, handleObj,
			handleObjIn, handlers, special;

		// Don't attach events to noData or text/comment nodes (allow plain objects tho)
		if ( elem.nodeType === 3 || elem.nodeType === 8 || !types || !handler || !(elemData = jQuery._data( elem )) ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		events = elemData.events;
		if ( !events ) {
			elemData.events = events = {};
		}
		eventHandle = elemData.handle;
		if ( !eventHandle ) {
			elemData.handle = eventHandle = function( e ) {
				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && (!e || jQuery.event.triggered !== e.type) ?
					jQuery.event.dispatch.apply( eventHandle.elem, arguments ) :
					undefined;
			};
			// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
			eventHandle.elem = elem;
		}

		// Handle multiple events separated by a space
		// jQuery(...).bind("mouseover mouseout", fn);
		types = jQuery.trim( hoverHack(types) ).split( " " );
		for ( t = 0; t < types.length; t++ ) {

			tns = rtypenamespace.exec( types[t] ) || [];
			type = tns[1];
			namespaces = ( tns[2] || "" ).split( "." ).sort();

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend({
				type: type,
				origType: tns[1],
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join(".")
			}, handleObjIn );

			// Init the event handler queue if we're the first
			handlers = events[ type ];
			if ( !handlers ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener/attachEvent if the special events handler returns false
				if ( !special.setup || special.setup.call( elem, data, namespaces, eventHandle ) === false ) {
					// Bind the global event handler to the element
					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle, false );

					} else if ( elem.attachEvent ) {
						elem.attachEvent( "on" + type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

		// Nullify elem to prevent memory leaks in IE
		elem = null;
	},

	global: {},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var t, tns, type, origType, namespaces, origCount,
			j, events, special, eventType, handleObj,
			elemData = jQuery.hasData( elem ) && jQuery._data( elem );

		if ( !elemData || !(events = elemData.events) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = jQuery.trim( hoverHack( types || "" ) ).split(" ");
		for ( t = 0; t < types.length; t++ ) {
			tns = rtypenamespace.exec( types[t] ) || [];
			type = origType = tns[1];
			namespaces = tns[2];

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector? special.delegateType : special.bindType ) || type;
			eventType = events[ type ] || [];
			origCount = eventType.length;
			namespaces = namespaces ? new RegExp("(^|\\.)" + namespaces.split(".").sort().join("\\.(?:.*\\.|)") + "(\\.|$)") : null;

			// Remove matching events
			for ( j = 0; j < eventType.length; j++ ) {
				handleObj = eventType[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					 ( !handler || handler.guid === handleObj.guid ) &&
					 ( !namespaces || namespaces.test( handleObj.namespace ) ) &&
					 ( !selector || selector === handleObj.selector || selector === "**" && handleObj.selector ) ) {
					eventType.splice( j--, 1 );

					if ( handleObj.selector ) {
						eventType.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( eventType.length === 0 && origCount !== eventType.length ) {
				if ( !special.teardown || special.teardown.call( elem, namespaces, elemData.handle ) === false ) {
					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			delete elemData.handle;

			// removeData also checks for emptiness and clears the expando if empty
			// so use it instead of delete
			jQuery.removeData( elem, "events", true );
		}
	},

	// Events that are safe to short-circuit if no handlers are attached.
	// Native DOM events should not be added, they may have inline handlers.
	customEvent: {
		"getData": true,
		"setData": true,
		"changeData": true
	},

	trigger: function( event, data, elem, onlyHandlers ) {
		// Don't do events on text and comment nodes
		if ( elem && (elem.nodeType === 3 || elem.nodeType === 8) ) {
			return;
		}

		// Event object or event type
		var cache, exclusive, i, cur, old, ontype, special, handle, eventPath, bubbleType,
			type = event.type || event,
			namespaces = [];

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "!" ) >= 0 ) {
			// Exclusive events trigger only for the exact event (no namespaces)
			type = type.slice(0, -1);
			exclusive = true;
		}

		if ( type.indexOf( "." ) >= 0 ) {
			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split(".");
			type = namespaces.shift();
			namespaces.sort();
		}

		if ( (!elem || jQuery.event.customEvent[ type ]) && !jQuery.event.global[ type ] ) {
			// No jQuery handlers for this event type, and it can't have inline handlers
			return;
		}

		// Caller can pass in an Event, Object, or just an event type string
		event = typeof event === "object" ?
			// jQuery.Event object
			event[ jQuery.expando ] ? event :
			// Object literal
			new jQuery.Event( type, event ) :
			// Just the event type (string)
			new jQuery.Event( type );

		event.type = type;
		event.isTrigger = true;
		event.exclusive = exclusive;
		event.namespace = namespaces.join( "." );
		event.namespace_re = event.namespace? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
		ontype = type.indexOf( ":" ) < 0 ? "on" + type : "";

		// Handle a global trigger
		if ( !elem ) {

			// TODO: Stop taunting the data cache; remove global events and always attach to document
			cache = jQuery.cache;
			for ( i in cache ) {
				if ( cache[ i ].events && cache[ i ].events[ type ] ) {
					jQuery.event.trigger( event, data, cache[ i ].handle.elem, true );
				}
			}
			return;
		}

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data != null ? jQuery.makeArray( data ) : [];
		data.unshift( event );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		eventPath = [[ elem, special.bindType || type ]];
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			cur = rfocusMorph.test( bubbleType + type ) ? elem : elem.parentNode;
			for ( old = elem; cur; cur = cur.parentNode ) {
				eventPath.push([ cur, bubbleType ]);
				old = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( old === (elem.ownerDocument || document) ) {
				eventPath.push([ old.defaultView || old.parentWindow || window, bubbleType ]);
			}
		}

		// Fire handlers on the event path
		for ( i = 0; i < eventPath.length && !event.isPropagationStopped(); i++ ) {

			cur = eventPath[i][0];
			event.type = eventPath[i][1];

			handle = ( jQuery._data( cur, "events" ) || {} )[ event.type ] && jQuery._data( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}
			// Note that this is a bare JS function and not a jQuery handler
			handle = ontype && cur[ ontype ];
			if ( handle && jQuery.acceptData( cur ) && handle.apply && handle.apply( cur, data ) === false ) {
				event.preventDefault();
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( (!special._default || special._default.apply( elem.ownerDocument, data ) === false) &&
				!(type === "click" && jQuery.nodeName( elem, "a" )) && jQuery.acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Can't use an .isFunction() check here because IE6/7 fails that test.
				// Don't do default actions on window, that's where global variables be (#6170)
				// IE<9 dies on focus/blur to hidden element (#1486)
				if ( ontype && elem[ type ] && ((type !== "focus" && type !== "blur") || event.target.offsetWidth !== 0) && !jQuery.isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					old = elem[ ontype ];

					if ( old ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;
					elem[ type ]();
					jQuery.event.triggered = undefined;

					if ( old ) {
						elem[ ontype ] = old;
					}
				}
			}
		}

		return event.result;
	},

	dispatch: function( event ) {

		// Make a writable jQuery.Event from the native event object
		event = jQuery.event.fix( event || window.event );

		var i, j, cur, ret, selMatch, matched, matches, handleObj, sel, related,
			handlers = ( (jQuery._data( this, "events" ) || {} )[ event.type ] || []),
			delegateCount = handlers.delegateCount,
			args = core_slice.call( arguments ),
			run_all = !event.exclusive && !event.namespace,
			special = jQuery.event.special[ event.type ] || {},
			handlerQueue = [];

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[0] = event;
		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers that should run if there are delegated events
		// Avoid non-left-click bubbling in Firefox (#3861)
		if ( delegateCount && !(event.button && event.type === "click") ) {

			for ( cur = event.target; cur != this; cur = cur.parentNode || this ) {

				// Don't process clicks (ONLY) on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.disabled !== true || event.type !== "click" ) {
					selMatch = {};
					matches = [];
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];
						sel = handleObj.selector;

						if ( selMatch[ sel ] === undefined ) {
							selMatch[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) >= 0 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( selMatch[ sel ] ) {
							matches.push( handleObj );
						}
					}
					if ( matches.length ) {
						handlerQueue.push({ elem: cur, matches: matches });
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		if ( handlers.length > delegateCount ) {
			handlerQueue.push({ elem: this, matches: handlers.slice( delegateCount ) });
		}

		// Run delegates first; they may want to stop propagation beneath us
		for ( i = 0; i < handlerQueue.length && !event.isPropagationStopped(); i++ ) {
			matched = handlerQueue[ i ];
			event.currentTarget = matched.elem;

			for ( j = 0; j < matched.matches.length && !event.isImmediatePropagationStopped(); j++ ) {
				handleObj = matched.matches[ j ];

				// Triggered event must either 1) be non-exclusive and have no namespace, or
				// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
				if ( run_all || (!event.namespace && !handleObj.namespace) || event.namespace_re && event.namespace_re.test( handleObj.namespace ) ) {

					event.data = handleObj.data;
					event.handleObj = handleObj;

					ret = ( (jQuery.event.special[ handleObj.origType ] || {}).handle || handleObj.handler )
							.apply( matched.elem, args );

					if ( ret !== undefined ) {
						event.result = ret;
						if ( ret === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	// Includes some event props shared by KeyEvent and MouseEvent
	// *** attrChange attrName relatedNode srcElement  are not normalized, non-W3C, deprecated, will be removed in 1.8 ***
	props: "attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

	fixHooks: {},

	keyHooks: {
		props: "char charCode key keyCode".split(" "),
		filter: function( event, original ) {

			// Add which for key events
			if ( event.which == null ) {
				event.which = original.charCode != null ? original.charCode : original.keyCode;
			}

			return event;
		}
	},

	mouseHooks: {
		props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
		filter: function( event, original ) {
			var eventDoc, doc, body,
				button = original.button,
				fromElement = original.fromElement;

			// Calculate pageX/Y if missing and clientX/Y available
			if ( event.pageX == null && original.clientX != null ) {
				eventDoc = event.target.ownerDocument || document;
				doc = eventDoc.documentElement;
				body = eventDoc.body;

				event.pageX = original.clientX + ( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) - ( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY + ( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) - ( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}

			// Add relatedTarget, if necessary
			if ( !event.relatedTarget && fromElement ) {
				event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
			}

			// Add which for click: 1 === left; 2 === middle; 3 === right
			// Note: button is not normalized, so don't use it
			if ( !event.which && button !== undefined ) {
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
			}

			return event;
		}
	},

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// Create a writable copy of the event object and normalize some properties
		var i, prop,
			originalEvent = event,
			fixHook = jQuery.event.fixHooks[ event.type ] || {},
			copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;

		event = jQuery.Event( originalEvent );

		for ( i = copy.length; i; ) {
			prop = copy[ --i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Fix target property, if necessary (#1925, IE 6/7/8 & Safari2)
		if ( !event.target ) {
			event.target = originalEvent.srcElement || document;
		}

		// Target should not be a text node (#504, Safari)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		// For mouse/key events, metaKey==false if it's undefined (#3368, #11328; IE6/7/8)
		event.metaKey = !!event.metaKey;

		return fixHook.filter? fixHook.filter( event, originalEvent ) : event;
	},

	special: {
		load: {
			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},

		focus: {
			delegateType: "focusin"
		},
		blur: {
			delegateType: "focusout"
		},

		beforeunload: {
			setup: function( data, namespaces, eventHandle ) {
				// We only want to do this special case on windows
				if ( jQuery.isWindow( this ) ) {
					this.onbeforeunload = eventHandle;
				}
			},

			teardown: function( namespaces, eventHandle ) {
				if ( this.onbeforeunload === eventHandle ) {
					this.onbeforeunload = null;
				}
			}
		}
	},

	simulate: function( type, elem, event, bubble ) {
		// Piggyback on a donor event to simulate a different one.
		// Fake originalEvent to avoid donor's stopPropagation, but if the
		// simulated event prevents default then we do the same on the donor.
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{ type: type,
				isSimulated: true,
				originalEvent: {}
			}
		);
		if ( bubble ) {
			jQuery.event.trigger( e, null, elem );
		} else {
			jQuery.event.dispatch.call( elem, e );
		}
		if ( e.isDefaultPrevented() ) {
			event.preventDefault();
		}
	}
};

// Some plugins are using, but it's undocumented/deprecated and will be removed.
// The 1.7 special event interface should provide all the hooks needed now.
jQuery.event.handle = jQuery.event.dispatch;

jQuery.removeEvent = document.removeEventListener ?
	function( elem, type, handle ) {
		if ( elem.removeEventListener ) {
			elem.removeEventListener( type, handle, false );
		}
	} :
	function( elem, type, handle ) {
		var name = "on" + type;

		if ( elem.detachEvent ) {

			// #8545, #7054, preventing memory leaks for custom events in IE6-8
			// detachEvent needed property on element, by name of that event, to properly expose it to GC
			if ( typeof elem[ name ] === "undefined" ) {
				elem[ name ] = null;
			}

			elem.detachEvent( name, handle );
		}
	};

jQuery.Event = function( src, props ) {
	// Allow instantiation without the 'new' keyword
	if ( !(this instanceof jQuery.Event) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = ( src.defaultPrevented || src.returnValue === false ||
			src.getPreventDefault && src.getPreventDefault() ) ? returnTrue : returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

function returnFalse() {
	return false;
}
function returnTrue() {
	return true;
}

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	preventDefault: function() {
		this.isDefaultPrevented = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}

		// if preventDefault exists run it on the original event
		if ( e.preventDefault ) {
			e.preventDefault();

		// otherwise set the returnValue property of the original event to false (IE)
		} else {
			e.returnValue = false;
		}
	},
	stopPropagation: function() {
		this.isPropagationStopped = returnTrue;

		var e = this.originalEvent;
		if ( !e ) {
			return;
		}
		// if stopPropagation exists run it on the original event
		if ( e.stopPropagation ) {
			e.stopPropagation();
		}
		// otherwise set the cancelBubble property of the original event to true (IE)
		e.cancelBubble = true;
	},
	stopImmediatePropagation: function() {
		this.isImmediatePropagationStopped = returnTrue;
		this.stopPropagation();
	},
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse
};

// Create mouseenter/leave events using mouseover/out and event-time checks
jQuery.each({
	mouseenter: "mouseover",
	mouseleave: "mouseout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj,
				selector = handleObj.selector;

			// For mousenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || (related !== target && !jQuery.contains( target, related )) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
});

// IE submit delegation
if ( !jQuery.support.submitBubbles ) {

	jQuery.event.special.submit = {
		setup: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Lazy-add a submit handler when a descendant form may potentially be submitted
			jQuery.event.add( this, "click._submit keypress._submit", function( e ) {
				// Node name check avoids a VML-related crash in IE (#9807)
				var elem = e.target,
					form = jQuery.nodeName( elem, "input" ) || jQuery.nodeName( elem, "button" ) ? elem.form : undefined;
				if ( form && !jQuery._data( form, "_submit_attached" ) ) {
					jQuery.event.add( form, "submit._submit", function( event ) {
						event._submit_bubble = true;
					});
					jQuery._data( form, "_submit_attached", true );
				}
			});
			// return undefined since we don't need an event listener
		},

		postDispatch: function( event ) {
			// If form was submitted by the user, bubble the event up the tree
			if ( event._submit_bubble ) {
				delete event._submit_bubble;
				if ( this.parentNode && !event.isTrigger ) {
					jQuery.event.simulate( "submit", this.parentNode, event, true );
				}
			}
		},

		teardown: function() {
			// Only need this for delegated form submit events
			if ( jQuery.nodeName( this, "form" ) ) {
				return false;
			}

			// Remove delegated handlers; cleanData eventually reaps submit handlers attached above
			jQuery.event.remove( this, "._submit" );
		}
	};
}

// IE change delegation and checkbox/radio fix
if ( !jQuery.support.changeBubbles ) {

	jQuery.event.special.change = {

		setup: function() {

			if ( rformElems.test( this.nodeName ) ) {
				// IE doesn't fire change on a check/radio until blur; trigger it on click
				// after a propertychange. Eat the blur-change in special.change.handle.
				// This still fires onchange a second time for check/radio after blur.
				if ( this.type === "checkbox" || this.type === "radio" ) {
					jQuery.event.add( this, "propertychange._change", function( event ) {
						if ( event.originalEvent.propertyName === "checked" ) {
							this._just_changed = true;
						}
					});
					jQuery.event.add( this, "click._change", function( event ) {
						if ( this._just_changed && !event.isTrigger ) {
							this._just_changed = false;
						}
						// Allow triggered, simulated change events (#11500)
						jQuery.event.simulate( "change", this, event, true );
					});
				}
				return false;
			}
			// Delegated event; lazy-add a change handler on descendant inputs
			jQuery.event.add( this, "beforeactivate._change", function( e ) {
				var elem = e.target;

				if ( rformElems.test( elem.nodeName ) && !jQuery._data( elem, "_change_attached" ) ) {
					jQuery.event.add( elem, "change._change", function( event ) {
						if ( this.parentNode && !event.isSimulated && !event.isTrigger ) {
							jQuery.event.simulate( "change", this.parentNode, event, true );
						}
					});
					jQuery._data( elem, "_change_attached", true );
				}
			});
		},

		handle: function( event ) {
			var elem = event.target;

			// Swallow native change events from checkbox/radio, we already triggered them above
			if ( this !== elem || event.isSimulated || event.isTrigger || (elem.type !== "radio" && elem.type !== "checkbox") ) {
				return event.handleObj.handler.apply( this, arguments );
			}
		},

		teardown: function() {
			jQuery.event.remove( this, "._change" );

			return !rformElems.test( this.nodeName );
		}
	};
}

// Create "bubbling" focus and blur events
if ( !jQuery.support.focusinBubbles ) {
	jQuery.each({ focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler while someone wants focusin/focusout
		var attaches = 0,
			handler = function( event ) {
				jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ), true );
			};

		jQuery.event.special[ fix ] = {
			setup: function() {
				if ( attaches++ === 0 ) {
					document.addEventListener( orig, handler, true );
				}
			},
			teardown: function() {
				if ( --attaches === 0 ) {
					document.removeEventListener( orig, handler, true );
				}
			}
		};
	});
}

jQuery.fn.extend({

	on: function( types, selector, data, fn, /*INTERNAL*/ one ) {
		var origFn, type;

		// Types can be a map of types/handlers
		if ( typeof types === "object" ) {
			// ( types-Object, selector, data )
			if ( typeof selector !== "string" ) { // && selector != null
				// ( types-Object, data )
				data = data || selector;
				selector = undefined;
			}
			for ( type in types ) {
				this.on( type, selector, data, types[ type ], one );
			}
			return this;
		}

		if ( data == null && fn == null ) {
			// ( types, fn )
			fn = selector;
			data = selector = undefined;
		} else if ( fn == null ) {
			if ( typeof selector === "string" ) {
				// ( types, selector, fn )
				fn = data;
				data = undefined;
			} else {
				// ( types, data, fn )
				fn = data;
				data = selector;
				selector = undefined;
			}
		}
		if ( fn === false ) {
			fn = returnFalse;
		} else if ( !fn ) {
			return this;
		}

		if ( one === 1 ) {
			origFn = fn;
			fn = function( event ) {
				// Can use an empty set, since event contains the info
				jQuery().off( event );
				return origFn.apply( this, arguments );
			};
			// Use same guid so caller can remove using origFn
			fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
		}
		return this.each( function() {
			jQuery.event.add( this, types, fn, data, selector );
		});
	},
	one: function( types, selector, data, fn ) {
		return this.on( types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {
			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {
			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {
			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each(function() {
			jQuery.event.remove( this, types, fn, selector );
		});
	},

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	live: function( types, data, fn ) {
		jQuery( this.context ).on( types, this.selector, data, fn );
		return this;
	},
	die: function( types, fn ) {
		jQuery( this.context ).off( types, this.selector || "**", fn );
		return this;
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {
		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ? this.off( selector, "**" ) : this.off( types, selector || "**", fn );
	},

	trigger: function( type, data ) {
		return this.each(function() {
			jQuery.event.trigger( type, data, this );
		});
	},
	triggerHandler: function( type, data ) {
		if ( this[0] ) {
			return jQuery.event.trigger( type, data, this[0], true );
		}
	},

	toggle: function( fn ) {
		// Save reference to arguments for access in closure
		var args = arguments,
			guid = fn.guid || jQuery.guid++,
			i = 0,
			toggler = function( event ) {
				// Figure out which function to execute
				var lastToggle = ( jQuery._data( this, "lastToggle" + fn.guid ) || 0 ) % i;
				jQuery._data( this, "lastToggle" + fn.guid, lastToggle + 1 );

				// Make sure that clicks stop
				event.preventDefault();

				// and execute the function
				return args[ lastToggle ].apply( this, arguments ) || false;
			};

		// link all the functions, so any of them can unbind this click handler
		toggler.guid = guid;
		while ( i < args.length ) {
			args[ i++ ].guid = guid;
		}

		return this.click( toggler );
	},

	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
});

jQuery.each( ("blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error contextmenu").split(" "), function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		if ( fn == null ) {
			fn = data;
			data = null;
		}

		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};

	if ( rkeyEvent.test( name ) ) {
		jQuery.event.fixHooks[ name ] = jQuery.event.keyHooks;
	}

	if ( rmouseEvent.test( name ) ) {
		jQuery.event.fixHooks[ name ] = jQuery.event.mouseHooks;
	}
});
/*!
 * Sizzle CSS Selector Engine
 * Copyright 2012 jQuery Foundation and other contributors
 * Released under the MIT license
 * http://sizzlejs.com/
 */
(function( window, undefined ) {

var cachedruns,
	assertGetIdNotName,
	Expr,
	getText,
	isXML,
	contains,
	compile,
	sortOrder,
	hasDuplicate,
	outermostContext,

	baseHasDuplicate = true,
	strundefined = "undefined",

	expando = ( "sizcache" + Math.random() ).replace( ".", "" ),

	Token = String,
	document = window.document,
	docElem = document.documentElement,
	dirruns = 0,
	done = 0,
	pop = [].pop,
	push = [].push,
	slice = [].slice,
	// Use a stripped-down indexOf if a native one is unavailable
	indexOf = [].indexOf || function( elem ) {
		var i = 0,
			len = this.length;
		for ( ; i < len; i++ ) {
			if ( this[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	// Augment a function for special use by Sizzle
	markFunction = function( fn, value ) {
		fn[ expando ] = value == null || value;
		return fn;
	},

	createCache = function() {
		var cache = {},
			keys = [];

		return markFunction(function( key, value ) {
			// Only keep the most recent entries
			if ( keys.push( key ) > Expr.cacheLength ) {
				delete cache[ keys.shift() ];
			}

			// Retrieve with (key + " ") to avoid collision with native Object.prototype properties (see Issue #157)
			return (cache[ key + " " ] = value);
		}, cache );
	},

	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),

	// Regex

	// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",
	// http://www.w3.org/TR/css3-syntax/#characters
	characterEncoding = "(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

	// Loosely modeled on CSS identifier characters
	// An unquoted value should be a CSS identifier (http://www.w3.org/TR/css3-selectors/#attribute-selectors)
	// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = characterEncoding.replace( "w", "w#" ),

	// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
	operators = "([*^$|!~]?=)",
	attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
		"*(?:" + operators + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

	// Prefer arguments not in parens/brackets,
	//   then attribute selectors and non-pseudos (denoted by :),
	//   then anything else
	// These preferences are here to reduce the number of selectors
	//   needing tokenize in the PSEUDO preFilter
	pseudos = ":(" + characterEncoding + ")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" + attributes + ")|[^:]|\\\\.)*|.*))\\)|)",

	// For matchExpr.POS and matchExpr.needsContext
	pos = ":(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
		"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([\\x20\\t\\r\\n\\f>+~])" + whitespace + "*" ),
	rpseudo = new RegExp( pseudos ),

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

	rnot = /^:not/,
	rsibling = /[\x20\t\r\n\f]*[+~]/,
	rendsWithNot = /:not\($/,

	rheader = /h\d/i,
	rinputs = /input|select|textarea|button/i,

	rbackslash = /\\(?!\\)/g,

	matchExpr = {
		"ID": new RegExp( "^#(" + characterEncoding + ")" ),
		"CLASS": new RegExp( "^\\.(" + characterEncoding + ")" ),
		"NAME": new RegExp( "^\\[name=['\"]?(" + characterEncoding + ")['\"]?\\]" ),
		"TAG": new RegExp( "^(" + characterEncoding.replace( "w", "w*" ) + ")" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"POS": new RegExp( pos, "i" ),
		"CHILD": new RegExp( "^:(only|nth|first|last)-child(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		// For use in libraries implementing .is()
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|" + pos, "i" )
	},

	// Support

	// Used for testing something on an element
	assert = function( fn ) {
		var div = document.createElement("div");

		try {
			return fn( div );
		} catch (e) {
			return false;
		} finally {
			// release memory in IE
			div = null;
		}
	},

	// Check if getElementsByTagName("*") returns only elements
	assertTagNameNoComments = assert(function( div ) {
		div.appendChild( document.createComment("") );
		return !div.getElementsByTagName("*").length;
	}),

	// Check if getAttribute returns normalized href attributes
	assertHrefNotNormalized = assert(function( div ) {
		div.innerHTML = "<a href='#'></a>";
		return div.firstChild && typeof div.firstChild.getAttribute !== strundefined &&
			div.firstChild.getAttribute("href") === "#";
	}),

	// Check if attributes should be retrieved by attribute nodes
	assertAttributes = assert(function( div ) {
		div.innerHTML = "<select></select>";
		var type = typeof div.lastChild.getAttribute("multiple");
		// IE8 returns a string for some attributes even when not present
		return type !== "boolean" && type !== "string";
	}),

	// Check if getElementsByClassName can be trusted
	assertUsableClassName = assert(function( div ) {
		// Opera can't find a second classname (in 9.6)
		div.innerHTML = "<div class='hidden e'></div><div class='hidden'></div>";
		if ( !div.getElementsByClassName || !div.getElementsByClassName("e").length ) {
			return false;
		}

		// Safari 3.2 caches class attributes and doesn't catch changes
		div.lastChild.className = "e";
		return div.getElementsByClassName("e").length === 2;
	}),

	// Check if getElementById returns elements by name
	// Check if getElementsByName privileges form controls or returns elements by ID
	assertUsableName = assert(function( div ) {
		// Inject content
		div.id = expando + 0;
		div.innerHTML = "<a name='" + expando + "'></a><div name='" + expando + "'></div>";
		docElem.insertBefore( div, docElem.firstChild );

		// Test
		var pass = document.getElementsByName &&
			// buggy browsers will return fewer than the correct 2
			document.getElementsByName( expando ).length === 2 +
			// buggy browsers will return more than the correct 0
			document.getElementsByName( expando + 0 ).length;
		assertGetIdNotName = !document.getElementById( expando );

		// Cleanup
		docElem.removeChild( div );

		return pass;
	});

// If slice is not available, provide a backup
try {
	slice.call( docElem.childNodes, 0 )[0].nodeType;
} catch ( e ) {
	slice = function( i ) {
		var elem,
			results = [];
		for ( ; (elem = this[i]); i++ ) {
			results.push( elem );
		}
		return results;
	};
}

function Sizzle( selector, context, results, seed ) {
	results = results || [];
	context = context || document;
	var match, elem, xml, m,
		nodeType = context.nodeType;

	if ( !selector || typeof selector !== "string" ) {
		return results;
	}

	if ( nodeType !== 1 && nodeType !== 9 ) {
		return [];
	}

	xml = isXML( context );

	if ( !xml && !seed ) {
		if ( (match = rquickExpr.exec( selector )) ) {
			// Speed-up: Sizzle("#ID")
			if ( (m = match[1]) ) {
				if ( nodeType === 9 ) {
					elem = context.getElementById( m );
					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					if ( elem && elem.parentNode ) {
						// Handle the case where IE, Opera, and Webkit return items
						// by name instead of ID
						if ( elem.id === m ) {
							results.push( elem );
							return results;
						}
					} else {
						return results;
					}
				} else {
					// Context is not a document
					if ( context.ownerDocument && (elem = context.ownerDocument.getElementById( m )) &&
						contains( context, elem ) && elem.id === m ) {
						results.push( elem );
						return results;
					}
				}

			// Speed-up: Sizzle("TAG")
			} else if ( match[2] ) {
				push.apply( results, slice.call(context.getElementsByTagName( selector ), 0) );
				return results;

			// Speed-up: Sizzle(".CLASS")
			} else if ( (m = match[3]) && assertUsableClassName && context.getElementsByClassName ) {
				push.apply( results, slice.call(context.getElementsByClassName( m ), 0) );
				return results;
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed, xml );
}

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	return Sizzle( expr, null, null, [ elem ] ).length > 0;
};

// Returns a function to use in pseudos for input types
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

// Returns a function to use in pseudos for buttons
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

// Returns a function to use in pseudos for positionals
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( nodeType ) {
		if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
			// Use textContent for elements
			// innerText usage removed for consistency of new lines (see #11153)
			if ( typeof elem.textContent === "string" ) {
				return elem.textContent;
			} else {
				// Traverse its children
				for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
					ret += getText( elem );
				}
			}
		} else if ( nodeType === 3 || nodeType === 4 ) {
			return elem.nodeValue;
		}
		// Do not include comment or processing instruction nodes
	} else {

		// If no nodeType, this is expected to be an array
		for ( ; (node = elem[i]); i++ ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	}
	return ret;
};

isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

// Element contains another
contains = Sizzle.contains = docElem.contains ?
	function( a, b ) {
		var adown = a.nodeType === 9 ? a.documentElement : a,
			bup = b && b.parentNode;
		return a === bup || !!( bup && bup.nodeType === 1 && adown.contains && adown.contains(bup) );
	} :
	docElem.compareDocumentPosition ?
	function( a, b ) {
		return b && !!( a.compareDocumentPosition( b ) & 16 );
	} :
	function( a, b ) {
		while ( (b = b.parentNode) ) {
			if ( b === a ) {
				return true;
			}
		}
		return false;
	};

Sizzle.attr = function( elem, name ) {
	var val,
		xml = isXML( elem );

	if ( !xml ) {
		name = name.toLowerCase();
	}
	if ( (val = Expr.attrHandle[ name ]) ) {
		return val( elem );
	}
	if ( xml || assertAttributes ) {
		return elem.getAttribute( name );
	}
	val = elem.getAttributeNode( name );
	return val ?
		typeof elem[ name ] === "boolean" ?
			elem[ name ] ? name : null :
			val.specified ? val.value : null :
		null;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	// IE6/7 return a modified href
	attrHandle: assertHrefNotNormalized ?
		{} :
		{
			"href": function( elem ) {
				return elem.getAttribute( "href", 2 );
			},
			"type": function( elem ) {
				return elem.getAttribute("type");
			}
		},

	find: {
		"ID": assertGetIdNotName ?
			function( id, context, xml ) {
				if ( typeof context.getElementById !== strundefined && !xml ) {
					var m = context.getElementById( id );
					// Check parentNode to catch when Blackberry 4.6 returns
					// nodes that are no longer in the document #6963
					return m && m.parentNode ? [m] : [];
				}
			} :
			function( id, context, xml ) {
				if ( typeof context.getElementById !== strundefined && !xml ) {
					var m = context.getElementById( id );

					return m ?
						m.id === id || typeof m.getAttributeNode !== strundefined && m.getAttributeNode("id").value === id ?
							[m] :
							undefined :
						[];
				}
			},

		"TAG": assertTagNameNoComments ?
			function( tag, context ) {
				if ( typeof context.getElementsByTagName !== strundefined ) {
					return context.getElementsByTagName( tag );
				}
			} :
			function( tag, context ) {
				var results = context.getElementsByTagName( tag );

				// Filter out possible comments
				if ( tag === "*" ) {
					var elem,
						tmp = [],
						i = 0;

					for ( ; (elem = results[i]); i++ ) {
						if ( elem.nodeType === 1 ) {
							tmp.push( elem );
						}
					}

					return tmp;
				}
				return results;
			},

		"NAME": assertUsableName && function( tag, context ) {
			if ( typeof context.getElementsByName !== strundefined ) {
				return context.getElementsByName( name );
			}
		},

		"CLASS": assertUsableClassName && function( className, context, xml ) {
			if ( typeof context.getElementsByClassName !== strundefined && !xml ) {
				return context.getElementsByClassName( className );
			}
		}
	},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( rbackslash, "" );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[4] || match[5] || "" ).replace( rbackslash, "" );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				3 xn-component of xn+y argument ([+-]?\d*n|)
				4 sign of xn-component
				5 x of xn-component
				6 sign of y-component
				7 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1] === "nth" ) {
				// nth-child requires argument
				if ( !match[2] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[3] = +( match[3] ? match[4] + (match[5] || 1) : 2 * ( match[2] === "even" || match[2] === "odd" ) );
				match[4] = +( ( match[6] + match[7] ) || match[2] === "odd" );

			// other types prohibit arguments
			} else if ( match[2] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var unquoted, excess;
			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			if ( match[3] ) {
				match[2] = match[3];
			} else if ( (unquoted = match[4]) ) {
				// Only check arguments that contain a pseudo
				if ( rpseudo.test(unquoted) &&
					// Get excess from tokenize (recursively)
					(excess = tokenize( unquoted, true )) &&
					// advance to the next closing parenthesis
					(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

					// excess is a negative index
					unquoted = unquoted.slice( 0, excess );
					match[0] = match[0].slice( 0, excess );
				}
				match[2] = unquoted;
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {
		"ID": assertGetIdNotName ?
			function( id ) {
				id = id.replace( rbackslash, "" );
				return function( elem ) {
					return elem.getAttribute("id") === id;
				};
			} :
			function( id ) {
				id = id.replace( rbackslash, "" );
				return function( elem ) {
					var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
					return node && node.value === id;
				};
			},

		"TAG": function( nodeName ) {
			if ( nodeName === "*" ) {
				return function() { return true; };
			}
			nodeName = nodeName.replace( rbackslash, "" ).toLowerCase();

			return function( elem ) {
				return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
			};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ expando ][ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( elem.className || (typeof elem.getAttribute !== strundefined && elem.getAttribute("class")) || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem, context ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.substr( result.length - check.length ) === check :
					operator === "~=" ? ( " " + result + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.substr( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, argument, first, last ) {

			if ( type === "nth" ) {
				return function( elem ) {
					var node, diff,
						parent = elem.parentNode;

					if ( first === 1 && last === 0 ) {
						return true;
					}

					if ( parent ) {
						diff = 0;
						for ( node = parent.firstChild; node; node = node.nextSibling ) {
							if ( node.nodeType === 1 ) {
								diff++;
								if ( elem === node ) {
									break;
								}
							}
						}
					}

					// Incorporate the offset (or cast to NaN), then check against cycle size
					diff -= last;
					return diff === first || ( diff % first === 0 && diff / first >= 0 );
				};
			}

			return function( elem ) {
				var node = elem;

				switch ( type ) {
					case "only":
					case "first":
						while ( (node = node.previousSibling) ) {
							if ( node.nodeType === 1 ) {
								return false;
							}
						}

						if ( type === "first" ) {
							return true;
						}

						node = elem;

						/* falls through */
					case "last":
						while ( (node = node.nextSibling) ) {
							if ( node.nodeType === 1 ) {
								return false;
							}
						}

						return true;
				}
			};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf.call( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		"enabled": function( elem ) {
			return elem.disabled === false;
		},

		"disabled": function( elem ) {
			return elem.disabled === true;
		},

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is only affected by element nodes and content nodes(including text(3), cdata(4)),
			//   not comment, processing instructions, or others
			// Thanks to Diego Perini for the nodeName shortcut
			//   Greater than "@" means alpha characters (specifically not starting with "#" or "?")
			var nodeType;
			elem = elem.firstChild;
			while ( elem ) {
				if ( elem.nodeName > "@" || (nodeType = elem.nodeType) === 3 || nodeType === 4 ) {
					return false;
				}
				elem = elem.nextSibling;
			}
			return true;
		},

		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"text": function( elem ) {
			var type, attr;
			// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc)
			// use getAttribute instead to test this case
			return elem.nodeName.toLowerCase() === "input" &&
				(type = elem.type) === "text" &&
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === type );
		},

		// Input types
		"radio": createInputPseudo("radio"),
		"checkbox": createInputPseudo("checkbox"),
		"file": createInputPseudo("file"),
		"password": createInputPseudo("password"),
		"image": createInputPseudo("image"),

		"submit": createButtonPseudo("submit"),
		"reset": createButtonPseudo("reset"),

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"focus": function( elem ) {
			var doc = elem.ownerDocument;
			return elem === doc.activeElement && (!doc.hasFocus || doc.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		"active": function( elem ) {
			return elem === elem.ownerDocument.activeElement;
		},

		// Positional types
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			for ( var i = 0; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			for ( var i = 1; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = argument < 0 ? argument + length : argument; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			for ( var i = argument < 0 ? argument + length : argument; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

function siblingCheck( a, b, ret ) {
	if ( a === b ) {
		return ret;
	}

	var cur = a.nextSibling;

	while ( cur ) {
		if ( cur === b ) {
			return -1;
		}

		cur = cur.nextSibling;
	}

	return 1;
}

sortOrder = docElem.compareDocumentPosition ?
	function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		return ( !a.compareDocumentPosition || !b.compareDocumentPosition ?
			a.compareDocumentPosition :
			a.compareDocumentPosition(b) & 4
		) ? -1 : 1;
	} :
	function( a, b ) {
		// The nodes are identical, we can exit early
		if ( a === b ) {
			hasDuplicate = true;
			return 0;

		// Fallback to using sourceIndex (in IE) if it's available on both nodes
		} else if ( a.sourceIndex && b.sourceIndex ) {
			return a.sourceIndex - b.sourceIndex;
		}

		var al, bl,
			ap = [],
			bp = [],
			aup = a.parentNode,
			bup = b.parentNode,
			cur = aup;

		// If the nodes are siblings (or identical) we can do a quick check
		if ( aup === bup ) {
			return siblingCheck( a, b );

		// If no parents were found then the nodes are disconnected
		} else if ( !aup ) {
			return -1;

		} else if ( !bup ) {
			return 1;
		}

		// Otherwise they're somewhere else in the tree so we need
		// to build up a full list of the parentNodes for comparison
		while ( cur ) {
			ap.unshift( cur );
			cur = cur.parentNode;
		}

		cur = bup;

		while ( cur ) {
			bp.unshift( cur );
			cur = cur.parentNode;
		}

		al = ap.length;
		bl = bp.length;

		// Start walking down the tree looking for a discrepancy
		for ( var i = 0; i < al && i < bl; i++ ) {
			if ( ap[i] !== bp[i] ) {
				return siblingCheck( ap[i], bp[i] );
			}
		}

		// We ended someplace up the tree so do a sibling check
		return i === al ?
			siblingCheck( a, bp[i], -1 ) :
			siblingCheck( ap[i], b, 1 );
	};

// Always assume the presence of duplicates if sort doesn't
// pass them to our comparison function (as in Google Chrome).
[0, 0].sort( sortOrder );
baseHasDuplicate = !hasDuplicate;

// Document sorting and removing duplicates
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		i = 1,
		j = 0;

	hasDuplicate = baseHasDuplicate;
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		for ( ; (elem = results[i]); i++ ) {
			if ( elem === results[ i - 1 ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	return results;
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

function tokenize( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ expando ][ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( tokens = [] );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			tokens.push( matched = new Token( match.shift() ) );
			soFar = soFar.slice( matched.length );

			// Cast descendant combinators to space
			matched.type = match[0].replace( rtrim, " " );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {

				tokens.push( matched = new Token( match.shift() ) );
				soFar = soFar.slice( matched.length );
				matched.type = type;
				matched.matches = match;
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		checkNonElements = base && combinator.dir === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( checkNonElements || elem.nodeType === 1  ) {
					return matcher( elem, context, xml );
				}
			}
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
			if ( !xml ) {
				var cache,
					dirkey = dirruns + " " + doneName + " ",
					cachedkey = dirkey + cachedruns;
				while ( (elem = elem[ dir ]) ) {
					if ( checkNonElements || elem.nodeType === 1 ) {
						if ( (cache = elem[ expando ]) === cachedkey ) {
							return elem.sizset;
						} else if ( typeof cache === "string" && cache.indexOf(dirkey) === 0 ) {
							if ( elem.sizset ) {
								return elem;
							}
						} else {
							elem[ expando ] = cachedkey;
							if ( matcher( elem, context, xml ) ) {
								elem.sizset = true;
								return elem;
							}
							elem.sizset = false;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( checkNonElements || elem.nodeType === 1 ) {
						if ( matcher( elem, context, xml ) ) {
							return elem;
						}
					}
				}
			}
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf.call( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf.call( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			return ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && tokens.slice( 0, i - 1 ).join("").replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && tokens.join("")
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, expandContext ) {
			var elem, j, matcher,
				setMatched = [],
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				outermost = expandContext != null,
				contextBackup = outermostContext,
				// We must always have either seed elements or context
				elems = seed || byElement && Expr.find["TAG"]( "*", expandContext && context.parentNode || context ),
				// Nested matchers should use non-integer dirruns
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.E);

			if ( outermost ) {
				outermostContext = context !== document && context;
				cachedruns = superMatcher.el;
			}

			// Add elements passing elementMatchers directly to results
			for ( ; (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					for ( j = 0; (matcher = elementMatchers[j]); j++ ) {
						if ( matcher( elem, context, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
						cachedruns = ++superMatcher.el;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// Apply set filters to unmatched elements
			matchedCount += i;
			if ( bySet && i !== matchedCount ) {
				for ( j = 0; (matcher = setMatchers[j]); j++ ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	superMatcher.el = 0;
	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, group /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ expando ][ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !group ) {
			group = tokenize( selector );
		}
		i = group.length;
		while ( i-- ) {
			cached = matcherFromTokens( group[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );
	}
	return cached;
};

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function select( selector, context, results, seed, xml ) {
	var i, tokens, token, type, find,
		match = tokenize( selector ),
		j = match.length;

	if ( !seed ) {
		// Try to minimize operations if there is only one group
		if ( match.length === 1 ) {

			// Take a shortcut and set the context if the root selector is an ID
			tokens = match[0] = match[0].slice( 0 );
			if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
					context.nodeType === 9 && !xml &&
					Expr.relative[ tokens[1].type ] ) {

				context = Expr.find["ID"]( token.matches[0].replace( rbackslash, "" ), context, xml )[0];
				if ( !context ) {
					return results;
				}

				selector = selector.slice( tokens.shift().length );
			}

			// Fetch a seed set for right-to-left matching
			for ( i = matchExpr["POS"].test( selector ) ? -1 : tokens.length - 1; i >= 0; i-- ) {
				token = tokens[i];

				// Abort if we hit a combinator
				if ( Expr.relative[ (type = token.type) ] ) {
					break;
				}
				if ( (find = Expr.find[ type ]) ) {
					// Search, expanding context for leading sibling combinators
					if ( (seed = find(
						token.matches[0].replace( rbackslash, "" ),
						rsibling.test( tokens[0].type ) && context.parentNode || context,
						xml
					)) ) {

						// If seed is empty or no tokens remain, we can return early
						tokens.splice( i, 1 );
						selector = seed.length && tokens.join("");
						if ( !selector ) {
							push.apply( results, slice.call( seed, 0 ) );
							return results;
						}

						break;
					}
				}
			}
		}
	}

	// Compile and execute a filtering function
	// Provide `match` to avoid retokenization if we modified the selector above
	compile( selector, match )(
		seed,
		context,
		xml,
		results,
		rsibling.test( selector )
	);
	return results;
}

if ( document.querySelectorAll ) {
	(function() {
		var disconnectedMatch,
			oldSelect = select,
			rescape = /'|\\/g,
			rattributeQuotes = /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

			// qSa(:focus) reports false when true (Chrome 21), no need to also add to buggyMatches since matches checks buggyQSA
			// A support test would require too much code (would include document ready)
			rbuggyQSA = [ ":focus" ],

			// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
			// A support test would require too much code (would include document ready)
			// just skip matchesSelector for :active
			rbuggyMatches = [ ":active" ],
			matches = docElem.matchesSelector ||
				docElem.mozMatchesSelector ||
				docElem.webkitMatchesSelector ||
				docElem.oMatchesSelector ||
				docElem.msMatchesSelector;

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( div ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explictly
			// setting a boolean content attribute,
			// since its presence should be enough
			// http://bugs.jquery.com/ticket/12359
			div.innerHTML = "<select><option selected=''></option></select>";

			// IE8 - Some boolean attributes are not treated correctly
			if ( !div.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:checked|disabled|ismap|multiple|readonly|selected|value)" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here (do not put tests after this one)
			if ( !div.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}
		});

		assert(function( div ) {

			// Opera 10-12/IE9 - ^= $= *= and empty values
			// Should not select anything
			div.innerHTML = "<p test=''></p>";
			if ( div.querySelectorAll("[test^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:\"\"|'')" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here (do not put tests after this one)
			div.innerHTML = "<input type='hidden'/>";
			if ( !div.querySelectorAll(":enabled").length ) {
				rbuggyQSA.push(":enabled", ":disabled");
			}
		});

		// rbuggyQSA always contains :focus, so no need for a length check
		rbuggyQSA = /* rbuggyQSA.length && */ new RegExp( rbuggyQSA.join("|") );

		select = function( selector, context, results, seed, xml ) {
			// Only use querySelectorAll when not filtering,
			// when this is not xml,
			// and when no QSA bugs apply
			if ( !seed && !xml && !rbuggyQSA.test( selector ) ) {
				var groups, i,
					old = true,
					nid = expando,
					newContext = context,
					newSelector = context.nodeType === 9 && selector;

				// qSA works strangely on Element-rooted queries
				// We can work around this by specifying an extra ID on the root
				// and working up from there (Thanks to Andrew Dupont for the technique)
				// IE 8 doesn't work on object elements
				if ( context.nodeType === 1 && context.nodeName.toLowerCase() !== "object" ) {
					groups = tokenize( selector );

					if ( (old = context.getAttribute("id")) ) {
						nid = old.replace( rescape, "\\$&" );
					} else {
						context.setAttribute( "id", nid );
					}
					nid = "[id='" + nid + "'] ";

					i = groups.length;
					while ( i-- ) {
						groups[i] = nid + groups[i].join("");
					}
					newContext = rsibling.test( selector ) && context.parentNode || context;
					newSelector = groups.join(",");
				}

				if ( newSelector ) {
					try {
						push.apply( results, slice.call( newContext.querySelectorAll(
							newSelector
						), 0 ) );
						return results;
					} catch(qsaError) {
					} finally {
						if ( !old ) {
							context.removeAttribute("id");
						}
					}
				}
			}

			return oldSelect( selector, context, results, seed, xml );
		};

		if ( matches ) {
			assert(function( div ) {
				// Check to see if it's possible to do matchesSelector
				// on a disconnected node (IE 9)
				disconnectedMatch = matches.call( div, "div" );

				// This should fail with an exception
				// Gecko does not error, returns false instead
				try {
					matches.call( div, "[test!='']:sizzle" );
					rbuggyMatches.push( "!=", pseudos );
				} catch ( e ) {}
			});

			// rbuggyMatches always contains :active and :focus, so no need for a length check
			rbuggyMatches = /* rbuggyMatches.length && */ new RegExp( rbuggyMatches.join("|") );

			Sizzle.matchesSelector = function( elem, expr ) {
				// Make sure that attribute selectors are quoted
				expr = expr.replace( rattributeQuotes, "='$1']" );

				// rbuggyMatches always contains :active, so no need for an existence check
				if ( !isXML( elem ) && !rbuggyMatches.test( expr ) && !rbuggyQSA.test( expr ) ) {
					try {
						var ret = matches.call( elem, expr );

						// IE 9's matchesSelector returns false on disconnected nodes
						if ( ret || disconnectedMatch ||
								// As well, disconnected nodes are said to be in a document
								// fragment in IE 9
								elem.document && elem.document.nodeType !== 11 ) {
							return ret;
						}
					} catch(e) {}
				}

				return Sizzle( expr, null, null, [ elem ] ).length > 0;
			};
		}
	})();
}

// Deprecated
Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Back-compat
function setFilters() {}
Expr.filters = setFilters.prototype = Expr.pseudos;
Expr.setFilters = new setFilters();

// Override sizzle attribute retrieval
Sizzle.attr = jQuery.attr;
jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[":"] = jQuery.expr.pseudos;
jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;


})( window );
var runtil = /Until$/,
	rparentsprev = /^(?:parents|prev(?:Until|All))/,
	isSimple = /^.[^:#\[\.,]*$/,
	rneedsContext = jQuery.expr.match.needsContext,
	// methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend({
	find: function( selector ) {
		var i, l, length, n, r, ret,
			self = this;

		if ( typeof selector !== "string" ) {
			return jQuery( selector ).filter(function() {
				for ( i = 0, l = self.length; i < l; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			});
		}

		ret = this.pushStack( "", "find", selector );

		for ( i = 0, l = this.length; i < l; i++ ) {
			length = ret.length;
			jQuery.find( selector, this[i], ret );

			if ( i > 0 ) {
				// Make sure that the results are unique
				for ( n = length; n < ret.length; n++ ) {
					for ( r = 0; r < length; r++ ) {
						if ( ret[r] === ret[n] ) {
							ret.splice(n--, 1);
							break;
						}
					}
				}
			}
		}

		return ret;
	},

	has: function( target ) {
		var i,
			targets = jQuery( target, this ),
			len = targets.length;

		return this.filter(function() {
			for ( i = 0; i < len; i++ ) {
				if ( jQuery.contains( this, targets[i] ) ) {
					return true;
				}
			}
		});
	},

	not: function( selector ) {
		return this.pushStack( winnow(this, selector, false), "not", selector);
	},

	filter: function( selector ) {
		return this.pushStack( winnow(this, selector, true), "filter", selector );
	},

	is: function( selector ) {
		return !!selector && (
			typeof selector === "string" ?
				// If this is a positional/relative selector, check membership in the returned set
				// so $("p:first").is("p:last") won't return true for a doc with two "p".
				rneedsContext.test( selector ) ?
					jQuery( selector, this.context ).index( this[0] ) >= 0 :
					jQuery.filter( selector, this ).length > 0 :
				this.filter( selector ).length > 0 );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			ret = [],
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( ; i < l; i++ ) {
			cur = this[i];

			while ( cur && cur.ownerDocument && cur !== context && cur.nodeType !== 11 ) {
				if ( pos ? pos.index(cur) > -1 : jQuery.find.matchesSelector(cur, selectors) ) {
					ret.push( cur );
					break;
				}
				cur = cur.parentNode;
			}
		}

		ret = ret.length > 1 ? jQuery.unique( ret ) : ret;

		return this.pushStack( ret, "closest", selectors );
	},

	// Determine the position of an element within
	// the matched set of elements
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[0] && this[0].parentNode ) ? this.prevAll().length : -1;
		}

		// index in selector
		if ( typeof elem === "string" ) {
			return jQuery.inArray( this[0], jQuery( elem ) );
		}

		// Locate the position of the desired element
		return jQuery.inArray(
			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[0] : elem, this );
	},

	add: function( selector, context ) {
		var set = typeof selector === "string" ?
				jQuery( selector, context ) :
				jQuery.makeArray( selector && selector.nodeType ? [ selector ] : selector ),
			all = jQuery.merge( this.get(), set );

		return this.pushStack( isDisconnected( set[0] ) || isDisconnected( all[0] ) ?
			all :
			jQuery.unique( all ) );
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter(selector)
		);
	}
});

jQuery.fn.andSelf = jQuery.fn.addBack;

// A painfully simple check to see if an element is disconnected
// from a document (should be improved, where feasible).
function isDisconnected( node ) {
	return !node || !node.parentNode || node.parentNode.nodeType === 11;
}

function sibling( cur, dir ) {
	do {
		cur = cur[ dir ];
	} while ( cur && cur.nodeType !== 1 );

	return cur;
}

jQuery.each({
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return jQuery.dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return jQuery.dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return jQuery.dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return jQuery.dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return jQuery.sibling( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return jQuery.sibling( elem.firstChild );
	},
	contents: function( elem ) {
		return jQuery.nodeName( elem, "iframe" ) ?
			elem.contentDocument || elem.contentWindow.document :
			jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var ret = jQuery.map( this, fn, until );

		if ( !runtil.test( name ) ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			ret = jQuery.filter( selector, ret );
		}

		ret = this.length > 1 && !guaranteedUnique[ name ] ? jQuery.unique( ret ) : ret;

		if ( this.length > 1 && rparentsprev.test( name ) ) {
			ret = ret.reverse();
		}

		return this.pushStack( ret, name, core_slice.call( arguments ).join(",") );
	};
});

jQuery.extend({
	filter: function( expr, elems, not ) {
		if ( not ) {
			expr = ":not(" + expr + ")";
		}

		return elems.length === 1 ?
			jQuery.find.matchesSelector(elems[0], expr) ? [ elems[0] ] : [] :
			jQuery.find.matches(expr, elems);
	},

	dir: function( elem, dir, until ) {
		var matched = [],
			cur = elem[ dir ];

		while ( cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery( cur ).is( until )) ) {
			if ( cur.nodeType === 1 ) {
				matched.push( cur );
			}
			cur = cur[dir];
		}
		return matched;
	},

	sibling: function( n, elem ) {
		var r = [];

		for ( ; n; n = n.nextSibling ) {
			if ( n.nodeType === 1 && n !== elem ) {
				r.push( n );
			}
		}

		return r;
	}
});

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, keep ) {

	// Can't pass null or undefined to indexOf in Firefox 4
	// Set to 0 to skip string check
	qualifier = qualifier || 0;

	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep(elements, function( elem, i ) {
			var retVal = !!qualifier.call( elem, i, elem );
			return retVal === keep;
		});

	} else if ( qualifier.nodeType ) {
		return jQuery.grep(elements, function( elem, i ) {
			return ( elem === qualifier ) === keep;
		});

	} else if ( typeof qualifier === "string" ) {
		var filtered = jQuery.grep(elements, function( elem ) {
			return elem.nodeType === 1;
		});

		if ( isSimple.test( qualifier ) ) {
			return jQuery.filter(qualifier, filtered, !keep);
		} else {
			qualifier = jQuery.filter( qualifier, filtered );
		}
	}

	return jQuery.grep(elements, function( elem, i ) {
		return ( jQuery.inArray( elem, qualifier ) >= 0 ) === keep;
	});
}
function createSafeFragment( document ) {
	var list = nodeNames.split( "|" ),
	safeFrag = document.createDocumentFragment();

	if ( safeFrag.createElement ) {
		while ( list.length ) {
			safeFrag.createElement(
				list.pop()
			);
		}
	}
	return safeFrag;
}

var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
		"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
	rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g,
	rleadingWhitespace = /^\s+/,
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
	rtagName = /<([\w:]+)/,
	rtbody = /<tbody/i,
	rhtml = /<|&#?\w+;/,
	rnoInnerhtml = /<(?:script|style|link)/i,
	rnocache = /<(?:script|object|embed|option|style)/i,
	rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
	rcheckableType = /^(?:checkbox|radio)$/,
	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptType = /\/(java|ecma)script/i,
	rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
	wrapMap = {
		option: [ 1, "<select multiple='multiple'>", "</select>" ],
		legend: [ 1, "<fieldset>", "</fieldset>" ],
		thead: [ 1, "<table>", "</table>" ],
		tr: [ 2, "<table><tbody>", "</tbody></table>" ],
		td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
		col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
		area: [ 1, "<map>", "</map>" ],
		_default: [ 0, "", "" ]
	},
	safeFragment = createSafeFragment( document ),
	fragmentDiv = safeFragment.appendChild( document.createElement("div") );

wrapMap.optgroup = wrapMap.option;
wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;

// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
// unless wrapped in a div with non-breaking characters in front of it.
if ( !jQuery.support.htmlSerialize ) {
	wrapMap._default = [ 1, "X<div>", "</div>" ];
}

jQuery.fn.extend({
	text: function( value ) {
		return jQuery.access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().append( ( this[0] && this[0].ownerDocument || document ).createTextNode( value ) );
		}, null, value, arguments.length );
	},

	wrapAll: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapAll( html.call(this, i) );
			});
		}

		if ( this[0] ) {
			// The elements to wrap the target around
			var wrap = jQuery( html, this[0].ownerDocument ).eq(0).clone(true);

			if ( this[0].parentNode ) {
				wrap.insertBefore( this[0] );
			}

			wrap.map(function() {
				var elem = this;

				while ( elem.firstChild && elem.firstChild.nodeType === 1 ) {
					elem = elem.firstChild;
				}

				return elem;
			}).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each(function(i) {
				jQuery(this).wrapInner( html.call(this, i) );
			});
		}

		return this.each(function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		});
	},

	wrap: function( html ) {
		var isFunction = jQuery.isFunction( html );

		return this.each(function(i) {
			jQuery( this ).wrapAll( isFunction ? html.call(this, i) : html );
		});
	},

	unwrap: function() {
		return this.parent().each(function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		}).end();
	},

	append: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 ) {
				this.appendChild( elem );
			}
		});
	},

	prepend: function() {
		return this.domManip(arguments, true, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 ) {
				this.insertBefore( elem, this.firstChild );
			}
		});
	},

	before: function() {
		if ( !isDisconnected( this[0] ) ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this );
			});
		}

		if ( arguments.length ) {
			var set = jQuery.clean( arguments );
			return this.pushStack( jQuery.merge( set, this ), "before", this.selector );
		}
	},

	after: function() {
		if ( !isDisconnected( this[0] ) ) {
			return this.domManip(arguments, false, function( elem ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			});
		}

		if ( arguments.length ) {
			var set = jQuery.clean( arguments );
			return this.pushStack( jQuery.merge( this, set ), "after", this.selector );
		}
	},

	// keepData is for internal use only--do not document
	remove: function( selector, keepData ) {
		var elem,
			i = 0;

		for ( ; (elem = this[i]) != null; i++ ) {
			if ( !selector || jQuery.filter( selector, [ elem ] ).length ) {
				if ( !keepData && elem.nodeType === 1 ) {
					jQuery.cleanData( elem.getElementsByTagName("*") );
					jQuery.cleanData( [ elem ] );
				}

				if ( elem.parentNode ) {
					elem.parentNode.removeChild( elem );
				}
			}
		}

		return this;
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; (elem = this[i]) != null; i++ ) {
			// Remove element nodes and prevent memory leaks
			if ( elem.nodeType === 1 ) {
				jQuery.cleanData( elem.getElementsByTagName("*") );
			}

			// Remove any remaining nodes
			while ( elem.firstChild ) {
				elem.removeChild( elem.firstChild );
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function () {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		});
	},

	html: function( value ) {
		return jQuery.access( this, function( value ) {
			var elem = this[0] || {},
				i = 0,
				l = this.length;

			if ( value === undefined ) {
				return elem.nodeType === 1 ?
					elem.innerHTML.replace( rinlinejQuery, "" ) :
					undefined;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				( jQuery.support.htmlSerialize || !rnoshimcache.test( value )  ) &&
				( jQuery.support.leadingWhitespace || !rleadingWhitespace.test( value ) ) &&
				!wrapMap[ ( rtagName.exec( value ) || ["", ""] )[1].toLowerCase() ] ) {

				value = value.replace( rxhtmlTag, "<$1></$2>" );

				try {
					for (; i < l; i++ ) {
						// Remove element nodes and prevent memory leaks
						elem = this[i] || {};
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( elem.getElementsByTagName( "*" ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch(e) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function( value ) {
		if ( !isDisconnected( this[0] ) ) {
			// Make sure that the elements are removed from the DOM before they are inserted
			// this can help fix replacing a parent with child elements
			if ( jQuery.isFunction( value ) ) {
				return this.each(function(i) {
					var self = jQuery(this), old = self.html();
					self.replaceWith( value.call( this, i, old ) );
				});
			}

			if ( typeof value !== "string" ) {
				value = jQuery( value ).detach();
			}

			return this.each(function() {
				var next = this.nextSibling,
					parent = this.parentNode;

				jQuery( this ).remove();

				if ( next ) {
					jQuery(next).before( value );
				} else {
					jQuery(parent).append( value );
				}
			});
		}

		return this.length ?
			this.pushStack( jQuery(jQuery.isFunction(value) ? value() : value), "replaceWith", value ) :
			this;
	},

	detach: function( selector ) {
		return this.remove( selector, true );
	},

	domManip: function( args, table, callback ) {

		// Flatten any nested arrays
		args = [].concat.apply( [], args );

		var results, first, fragment, iNoClone,
			i = 0,
			value = args[0],
			scripts = [],
			l = this.length;

		// We can't cloneNode fragments that contain checked, in WebKit
		if ( !jQuery.support.checkClone && l > 1 && typeof value === "string" && rchecked.test( value ) ) {
			return this.each(function() {
				jQuery(this).domManip( args, table, callback );
			});
		}

		if ( jQuery.isFunction(value) ) {
			return this.each(function(i) {
				var self = jQuery(this);
				args[0] = value.call( this, i, table ? self.html() : undefined );
				self.domManip( args, table, callback );
			});
		}

		if ( this[0] ) {
			results = jQuery.buildFragment( args, this, scripts );
			fragment = results.fragment;
			first = fragment.firstChild;

			if ( fragment.childNodes.length === 1 ) {
				fragment = first;
			}

			if ( first ) {
				table = table && jQuery.nodeName( first, "tr" );

				// Use the original fragment for the last item instead of the first because it can end up
				// being emptied incorrectly in certain situations (#8070).
				// Fragments from the fragment cache must always be cloned and never used in place.
				for ( iNoClone = results.cacheable || l - 1; i < l; i++ ) {
					callback.call(
						table && jQuery.nodeName( this[i], "table" ) ?
							findOrAppend( this[i], "tbody" ) :
							this[i],
						i === iNoClone ?
							fragment :
							jQuery.clone( fragment, true, true )
					);
				}
			}

			// Fix #11809: Avoid leaking memory
			fragment = first = null;

			if ( scripts.length ) {
				jQuery.each( scripts, function( i, elem ) {
					if ( elem.src ) {
						if ( jQuery.ajax ) {
							jQuery.ajax({
								url: elem.src,
								type: "GET",
								dataType: "script",
								async: false,
								global: false,
								"throws": true
							});
						} else {
							jQuery.error("no ajax");
						}
					} else {
						jQuery.globalEval( ( elem.text || elem.textContent || elem.innerHTML || "" ).replace( rcleanScript, "" ) );
					}

					if ( elem.parentNode ) {
						elem.parentNode.removeChild( elem );
					}
				});
			}
		}

		return this;
	}
});

function findOrAppend( elem, tag ) {
	return elem.getElementsByTagName( tag )[0] || elem.appendChild( elem.ownerDocument.createElement( tag ) );
}

function cloneCopyEvent( src, dest ) {

	if ( dest.nodeType !== 1 || !jQuery.hasData( src ) ) {
		return;
	}

	var type, i, l,
		oldData = jQuery._data( src ),
		curData = jQuery._data( dest, oldData ),
		events = oldData.events;

	if ( events ) {
		delete curData.handle;
		curData.events = {};

		for ( type in events ) {
			for ( i = 0, l = events[ type ].length; i < l; i++ ) {
				jQuery.event.add( dest, type, events[ type ][ i ] );
			}
		}
	}

	// make the cloned public data object a copy from the original
	if ( curData.data ) {
		curData.data = jQuery.extend( {}, curData.data );
	}
}

function cloneFixAttributes( src, dest ) {
	var nodeName;

	// We do not need to do anything for non-Elements
	if ( dest.nodeType !== 1 ) {
		return;
	}

	// clearAttributes removes the attributes, which we don't want,
	// but also removes the attachEvent events, which we *do* want
	if ( dest.clearAttributes ) {
		dest.clearAttributes();
	}

	// mergeAttributes, in contrast, only merges back on the
	// original attributes, not the events
	if ( dest.mergeAttributes ) {
		dest.mergeAttributes( src );
	}

	nodeName = dest.nodeName.toLowerCase();

	if ( nodeName === "object" ) {
		// IE6-10 improperly clones children of object elements using classid.
		// IE10 throws NoModificationAllowedError if parent is null, #12132.
		if ( dest.parentNode ) {
			dest.outerHTML = src.outerHTML;
		}

		// This path appears unavoidable for IE9. When cloning an object
		// element in IE9, the outerHTML strategy above is not sufficient.
		// If the src has innerHTML and the destination does not,
		// copy the src.innerHTML into the dest.innerHTML. #10324
		if ( jQuery.support.html5Clone && (src.innerHTML && !jQuery.trim(dest.innerHTML)) ) {
			dest.innerHTML = src.innerHTML;
		}

	} else if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		// IE6-8 fails to persist the checked state of a cloned checkbox
		// or radio button. Worse, IE6-7 fail to give the cloned element
		// a checked appearance if the defaultChecked value isn't also set

		dest.defaultChecked = dest.checked = src.checked;

		// IE6-7 get confused and end up setting the value of a cloned
		// checkbox/radio button to an empty string instead of "on"
		if ( dest.value !== src.value ) {
			dest.value = src.value;
		}

	// IE6-8 fails to return the selected option to the default selected
	// state when cloning options
	} else if ( nodeName === "option" ) {
		dest.selected = src.defaultSelected;

	// IE6-8 fails to set the defaultValue to the correct value when
	// cloning other types of input fields
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;

	// IE blanks contents when cloning scripts
	} else if ( nodeName === "script" && dest.text !== src.text ) {
		dest.text = src.text;
	}

	// Event data gets referenced instead of copied if the expando
	// gets copied too
	dest.removeAttribute( jQuery.expando );
}

jQuery.buildFragment = function( args, context, scripts ) {
	var fragment, cacheable, cachehit,
		first = args[ 0 ];

	// Set context from what may come in as undefined or a jQuery collection or a node
	// Updated to fix #12266 where accessing context[0] could throw an exception in IE9/10 &
	// also doubles as fix for #8950 where plain objects caused createDocumentFragment exception
	context = context || document;
	context = !context.nodeType && context[0] || context;
	context = context.ownerDocument || context;

	// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
	// Cloning options loses the selected state, so don't cache them
	// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
	// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
	// Lastly, IE6,7,8 will not correctly reuse cached fragments that were created from unknown elems #10501
	if ( args.length === 1 && typeof first === "string" && first.length < 512 && context === document &&
		first.charAt(0) === "<" && !rnocache.test( first ) &&
		(jQuery.support.checkClone || !rchecked.test( first )) &&
		(jQuery.support.html5Clone || !rnoshimcache.test( first )) ) {

		// Mark cacheable and look for a hit
		cacheable = true;
		fragment = jQuery.fragments[ first ];
		cachehit = fragment !== undefined;
	}

	if ( !fragment ) {
		fragment = context.createDocumentFragment();
		jQuery.clean( args, context, fragment, scripts );

		// Update the cache, but only store false
		// unless this is a second parsing of the same content
		if ( cacheable ) {
			jQuery.fragments[ first ] = cachehit && fragment;
		}
	}

	return { fragment: fragment, cacheable: cacheable };
};

jQuery.fragments = {};

jQuery.each({
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			i = 0,
			ret = [],
			insert = jQuery( selector ),
			l = insert.length,
			parent = this.length === 1 && this[0].parentNode;

		if ( (parent == null || parent && parent.nodeType === 11 && parent.childNodes.length === 1) && l === 1 ) {
			insert[ original ]( this[0] );
			return this;
		} else {
			for ( ; i < l; i++ ) {
				elems = ( i > 0 ? this.clone(true) : this ).get();
				jQuery( insert[i] )[ original ]( elems );
				ret = ret.concat( elems );
			}

			return this.pushStack( ret, name, insert.selector );
		}
	};
});

function getAll( elem ) {
	if ( typeof elem.getElementsByTagName !== "undefined" ) {
		return elem.getElementsByTagName( "*" );

	} else if ( typeof elem.querySelectorAll !== "undefined" ) {
		return elem.querySelectorAll( "*" );

	} else {
		return [];
	}
}

// Used in clean, fixes the defaultChecked property
function fixDefaultChecked( elem ) {
	if ( rcheckableType.test( elem.type ) ) {
		elem.defaultChecked = elem.checked;
	}
}

jQuery.extend({
	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var srcElements,
			destElements,
			i,
			clone;

		if ( jQuery.support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test( "<" + elem.nodeName + ">" ) ) {
			clone = elem.cloneNode( true );

		// IE<=8 does not properly clone detached, unknown element nodes
		} else {
			fragmentDiv.innerHTML = elem.outerHTML;
			fragmentDiv.removeChild( clone = fragmentDiv.firstChild );
		}

		if ( (!jQuery.support.noCloneEvent || !jQuery.support.noCloneChecked) &&
				(elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem) ) {
			// IE copies events bound via attachEvent when using cloneNode.
			// Calling detachEvent on the clone will also remove the events
			// from the original. In order to get around this, we use some
			// proprietary methods to clear the events. Thanks to MooTools
			// guys for this hotness.

			cloneFixAttributes( elem, clone );

			// Using Sizzle here is crazy slow, so we use getElementsByTagName instead
			srcElements = getAll( elem );
			destElements = getAll( clone );

			// Weird iteration because IE will replace the length property
			// with an element if you are cloning the body and one of the
			// elements on the page has a name or id of "length"
			for ( i = 0; srcElements[i]; ++i ) {
				// Ensure that the destination node is not null; Fixes #9587
				if ( destElements[i] ) {
					cloneFixAttributes( srcElements[i], destElements[i] );
				}
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			cloneCopyEvent( elem, clone );

			if ( deepDataAndEvents ) {
				srcElements = getAll( elem );
				destElements = getAll( clone );

				for ( i = 0; srcElements[i]; ++i ) {
					cloneCopyEvent( srcElements[i], destElements[i] );
				}
			}
		}

		srcElements = destElements = null;

		// Return the cloned set
		return clone;
	},

	clean: function( elems, context, fragment, scripts ) {
		var i, j, elem, tag, wrap, depth, div, hasBody, tbody, len, handleScript, jsTags,
			safe = context === document && safeFragment,
			ret = [];

		// Ensure that context is a document
		if ( !context || typeof context.createDocumentFragment === "undefined" ) {
			context = document;
		}

		// Use the already-created safe fragment if context permits
		for ( i = 0; (elem = elems[i]) != null; i++ ) {
			if ( typeof elem === "number" ) {
				elem += "";
			}

			if ( !elem ) {
				continue;
			}

			// Convert html string into DOM nodes
			if ( typeof elem === "string" ) {
				if ( !rhtml.test( elem ) ) {
					elem = context.createTextNode( elem );
				} else {
					// Ensure a safe container in which to render the html
					safe = safe || createSafeFragment( context );
					div = context.createElement("div");
					safe.appendChild( div );

					// Fix "XHTML"-style tags in all browsers
					elem = elem.replace(rxhtmlTag, "<$1></$2>");

					// Go to html and back, then peel off extra wrappers
					tag = ( rtagName.exec( elem ) || ["", ""] )[1].toLowerCase();
					wrap = wrapMap[ tag ] || wrapMap._default;
					depth = wrap[0];
					div.innerHTML = wrap[1] + elem + wrap[2];

					// Move to the right depth
					while ( depth-- ) {
						div = div.lastChild;
					}

					// Remove IE's autoinserted <tbody> from table fragments
					if ( !jQuery.support.tbody ) {

						// String was a <table>, *may* have spurious <tbody>
						hasBody = rtbody.test(elem);
							tbody = tag === "table" && !hasBody ?
								div.firstChild && div.firstChild.childNodes :

								// String was a bare <thead> or <tfoot>
								wrap[1] === "<table>" && !hasBody ?
									div.childNodes :
									[];

						for ( j = tbody.length - 1; j >= 0 ; --j ) {
							if ( jQuery.nodeName( tbody[ j ], "tbody" ) && !tbody[ j ].childNodes.length ) {
								tbody[ j ].parentNode.removeChild( tbody[ j ] );
							}
						}
					}

					// IE completely kills leading whitespace when innerHTML is used
					if ( !jQuery.support.leadingWhitespace && rleadingWhitespace.test( elem ) ) {
						div.insertBefore( context.createTextNode( rleadingWhitespace.exec(elem)[0] ), div.firstChild );
					}

					elem = div.childNodes;

					// Take out of fragment container (we need a fresh div each time)
					div.parentNode.removeChild( div );
				}
			}

			if ( elem.nodeType ) {
				ret.push( elem );
			} else {
				jQuery.merge( ret, elem );
			}
		}

		// Fix #11356: Clear elements from safeFragment
		if ( div ) {
			elem = div = safe = null;
		}

		// Reset defaultChecked for any radios and checkboxes
		// about to be appended to the DOM in IE 6/7 (#8060)
		if ( !jQuery.support.appendChecked ) {
			for ( i = 0; (elem = ret[i]) != null; i++ ) {
				if ( jQuery.nodeName( elem, "input" ) ) {
					fixDefaultChecked( elem );
				} else if ( typeof elem.getElementsByTagName !== "undefined" ) {
					jQuery.grep( elem.getElementsByTagName("input"), fixDefaultChecked );
				}
			}
		}

		// Append elements to a provided document fragment
		if ( fragment ) {
			// Special handling of each script element
			handleScript = function( elem ) {
				// Check if we consider it executable
				if ( !elem.type || rscriptType.test( elem.type ) ) {
					// Detach the script and store it in the scripts array (if provided) or the fragment
					// Return truthy to indicate that it has been handled
					return scripts ?
						scripts.push( elem.parentNode ? elem.parentNode.removeChild( elem ) : elem ) :
						fragment.appendChild( elem );
				}
			};

			for ( i = 0; (elem = ret[i]) != null; i++ ) {
				// Check if we're done after handling an executable script
				if ( !( jQuery.nodeName( elem, "script" ) && handleScript( elem ) ) ) {
					// Append to fragment and handle embedded scripts
					fragment.appendChild( elem );
					if ( typeof elem.getElementsByTagName !== "undefined" ) {
						// handleScript alters the DOM, so use jQuery.merge to ensure snapshot iteration
						jsTags = jQuery.grep( jQuery.merge( [], elem.getElementsByTagName("script") ), handleScript );

						// Splice the scripts into ret after their former ancestor and advance our index beyond them
						ret.splice.apply( ret, [i + 1, 0].concat( jsTags ) );
						i += jsTags.length;
					}
				}
			}
		}

		return ret;
	},

	cleanData: function( elems, /* internal */ acceptData ) {
		var data, id, elem, type,
			i = 0,
			internalKey = jQuery.expando,
			cache = jQuery.cache,
			deleteExpando = jQuery.support.deleteExpando,
			special = jQuery.event.special;

		for ( ; (elem = elems[i]) != null; i++ ) {

			if ( acceptData || jQuery.acceptData( elem ) ) {

				id = elem[ internalKey ];
				data = id && cache[ id ];

				if ( data ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Remove cache only if it was not already removed by jQuery.event.remove
					if ( cache[ id ] ) {

						delete cache[ id ];

						// IE does not allow us to delete expando properties from nodes,
						// nor does it have a removeAttribute function on Document nodes;
						// we must handle all of these cases
						if ( deleteExpando ) {
							delete elem[ internalKey ];

						} else if ( elem.removeAttribute ) {
							elem.removeAttribute( internalKey );

						} else {
							elem[ internalKey ] = null;
						}

						jQuery.deletedIds.push( id );
					}
				}
			}
		}
	}
});
// Limit scope pollution from any deprecated API
(function() {

var matched, browser;

// Use of jQuery.browser is frowned upon.
// More details: http://api.jquery.com/jQuery.browser
// jQuery.uaMatch maintained for back-compat
jQuery.uaMatch = function( ua ) {
	ua = ua.toLowerCase();

	var match = /(chrome)[ \/]([\w.]+)/.exec( ua ) ||
		/(webkit)[ \/]([\w.]+)/.exec( ua ) ||
		/(opera)(?:.*version|)[ \/]([\w.]+)/.exec( ua ) ||
		/(msie) ([\w.]+)/.exec( ua ) ||
		ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( ua ) ||
		[];

	return {
		browser: match[ 1 ] || "",
		version: match[ 2 ] || "0"
	};
};

matched = jQuery.uaMatch( navigator.userAgent );
browser = {};

if ( matched.browser ) {
	browser[ matched.browser ] = true;
	browser.version = matched.version;
}

// Chrome is Webkit, but Webkit is also Safari.
if ( browser.chrome ) {
	browser.webkit = true;
} else if ( browser.webkit ) {
	browser.safari = true;
}

jQuery.browser = browser;

jQuery.sub = function() {
	function jQuerySub( selector, context ) {
		return new jQuerySub.fn.init( selector, context );
	}
	jQuery.extend( true, jQuerySub, this );
	jQuerySub.superclass = this;
	jQuerySub.fn = jQuerySub.prototype = this();
	jQuerySub.fn.constructor = jQuerySub;
	jQuerySub.sub = this.sub;
	jQuerySub.fn.init = function init( selector, context ) {
		if ( context && context instanceof jQuery && !(context instanceof jQuerySub) ) {
			context = jQuerySub( context );
		}

		return jQuery.fn.init.call( this, selector, context, rootjQuerySub );
	};
	jQuerySub.fn.init.prototype = jQuerySub.fn;
	var rootjQuerySub = jQuerySub(document);
	return jQuerySub;
};

})();
var curCSS, iframe, iframeDoc,
	ralpha = /alpha\([^)]*\)/i,
	ropacity = /opacity=([^)]*)/,
	rposition = /^(top|right|bottom|left)$/,
	// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
	// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,
	rmargin = /^margin/,
	rnumsplit = new RegExp( "^(" + core_pnum + ")(.*)$", "i" ),
	rnumnonpx = new RegExp( "^(" + core_pnum + ")(?!px)[a-z%]+$", "i" ),
	rrelNum = new RegExp( "^([-+])=(" + core_pnum + ")", "i" ),
	elemdisplay = { BODY: "block" },

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: 0,
		fontWeight: 400
	},

	cssExpand = [ "Top", "Right", "Bottom", "Left" ],
	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ],

	eventsToggle = jQuery.fn.toggle;

// return a css property mapped to a potentially vendor prefixed property
function vendorPropName( style, name ) {

	// shortcut for names that are not vendor prefixed
	if ( name in style ) {
		return name;
	}

	// check for vendor prefixed names
	var capName = name.charAt(0).toUpperCase() + name.slice(1),
		origName = name,
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in style ) {
			return name;
		}
	}

	return origName;
}

function isHidden( elem, el ) {
	elem = el || elem;
	return jQuery.css( elem, "display" ) === "none" || !jQuery.contains( elem.ownerDocument, elem );
}

function showHide( elements, show ) {
	var elem, display,
		values = [],
		index = 0,
		length = elements.length;

	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		values[ index ] = jQuery._data( elem, "olddisplay" );
		if ( show ) {
			// Reset the inline display of this element to learn if it is
			// being hidden by cascaded rules or not
			if ( !values[ index ] && elem.style.display === "none" ) {
				elem.style.display = "";
			}

			// Set elements which have been overridden with display: none
			// in a stylesheet to whatever the default browser style is
			// for such an element
			if ( elem.style.display === "" && isHidden( elem ) ) {
				values[ index ] = jQuery._data( elem, "olddisplay", css_defaultDisplay(elem.nodeName) );
			}
		} else {
			display = curCSS( elem, "display" );

			if ( !values[ index ] && display !== "none" ) {
				jQuery._data( elem, "olddisplay", display );
			}
		}
	}

	// Set the display of most of the elements in a second loop
	// to avoid the constant reflow
	for ( index = 0; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {
			elem.style.display = show ? values[ index ] || "" : "none";
		}
	}

	return elements;
}

jQuery.fn.extend({
	css: function( name, value ) {
		return jQuery.access( this, function( elem, name, value ) {
			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	},
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state, fn2 ) {
		var bool = typeof state === "boolean";

		if ( jQuery.isFunction( state ) && jQuery.isFunction( fn2 ) ) {
			return eventsToggle.apply( this, arguments );
		}

		return this.each(function() {
			if ( bool ? state : isHidden( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		});
	}
});

jQuery.extend({
	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {
					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;

				}
			}
		}
	},

	// Exclude the following css properties to add px
	cssNumber: {
		"fillOpacity": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		// normalize float css property
		"float": jQuery.support.cssFloat ? "cssFloat" : "styleFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {
		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = jQuery.camelCase( name ),
			style = elem.style;

		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// convert relative number strings (+= or -=) to relative numbers. #7345
			if ( type === "string" && (ret = rrelNum.exec( value )) ) {
				value = ( ret[1] + 1 ) * ret[2] + parseFloat( jQuery.css( elem, name ) );
				// Fixes bug #9237
				type = "number";
			}

			// Make sure that NaN and null values aren't set. See: #7116
			if ( value == null || type === "number" && isNaN( value ) ) {
				return;
			}

			// If a number was passed in, add 'px' to the (except for certain CSS properties)
			if ( type === "number" && !jQuery.cssNumber[ origName ] ) {
				value += "px";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !("set" in hooks) || (value = hooks.set( elem, value, extra )) !== undefined ) {
				// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
				// Fixes bug #5509
				try {
					style[ name ] = value;
				} catch(e) {}
			}

		} else {
			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks && (ret = hooks.get( elem, false, extra )) !== undefined ) {
				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, numeric, extra ) {
		var val, num, hooks,
			origName = jQuery.camelCase( name );

		// Make sure that we're working with the right name
		name = jQuery.cssProps[ origName ] || ( jQuery.cssProps[ origName ] = vendorPropName( elem.style, origName ) );

		// gets hook for the prefixed version
		// followed by the unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name );
		}

		//convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Return, converting to number if forced or a qualifier was provided and val looks numeric
		if ( numeric || extra !== undefined ) {
			num = parseFloat( val );
			return numeric || jQuery.isNumeric( num ) ? num || 0 : val;
		}
		return val;
	},

	// A method for quickly swapping in/out CSS properties to get correct calculations
	swap: function( elem, options, callback ) {
		var ret, name,
			old = {};

		// Remember the old values, and insert the new ones
		for ( name in options ) {
			old[ name ] = elem.style[ name ];
			elem.style[ name ] = options[ name ];
		}

		ret = callback.call( elem );

		// Revert the old values
		for ( name in options ) {
			elem.style[ name ] = old[ name ];
		}

		return ret;
	}
});

// NOTE: To any future maintainer, we've window.getComputedStyle
// because jsdom on node.js will break without it.
if ( window.getComputedStyle ) {
	curCSS = function( elem, name ) {
		var ret, width, minWidth, maxWidth,
			computed = window.getComputedStyle( elem, null ),
			style = elem.style;

		if ( computed ) {

			// getPropertyValue is only needed for .css('filter') in IE9, see #12537
			ret = computed.getPropertyValue( name ) || computed[ name ];

			if ( ret === "" && !jQuery.contains( elem.ownerDocument, elem ) ) {
				ret = jQuery.style( elem, name );
			}

			// A tribute to the "awesome hack by Dean Edwards"
			// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
			// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
			// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
			if ( rnumnonpx.test( ret ) && rmargin.test( name ) ) {
				width = style.width;
				minWidth = style.minWidth;
				maxWidth = style.maxWidth;

				style.minWidth = style.maxWidth = style.width = ret;
				ret = computed.width;

				style.width = width;
				style.minWidth = minWidth;
				style.maxWidth = maxWidth;
			}
		}

		return ret;
	};
} else if ( document.documentElement.currentStyle ) {
	curCSS = function( elem, name ) {
		var left, rsLeft,
			ret = elem.currentStyle && elem.currentStyle[ name ],
			style = elem.style;

		// Avoid setting ret to empty string here
		// so we don't default to auto
		if ( ret == null && style && style[ name ] ) {
			ret = style[ name ];
		}

		// From the awesome hack by Dean Edwards
		// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

		// If we're not dealing with a regular pixel number
		// but a number that has a weird ending, we need to convert it to pixels
		// but not position css attributes, as those are proportional to the parent element instead
		// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
		if ( rnumnonpx.test( ret ) && !rposition.test( name ) ) {

			// Remember the original values
			left = style.left;
			rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;

			// Put in the new values to get a computed value out
			if ( rsLeft ) {
				elem.runtimeStyle.left = elem.currentStyle.left;
			}
			style.left = name === "fontSize" ? "1em" : ret;
			ret = style.pixelLeft + "px";

			// Revert the changed values
			style.left = left;
			if ( rsLeft ) {
				elem.runtimeStyle.left = rsLeft;
			}
		}

		return ret === "" ? "auto" : ret;
	};
}

function setPositiveNumber( elem, value, subtract ) {
	var matches = rnumsplit.exec( value );
	return matches ?
			Math.max( 0, matches[ 1 ] - ( subtract || 0 ) ) + ( matches[ 2 ] || "px" ) :
			value;
}

function augmentWidthOrHeight( elem, name, extra, isBorderBox ) {
	var i = extra === ( isBorderBox ? "border" : "content" ) ?
		// If we already have the right measurement, avoid augmentation
		4 :
		// Otherwise initialize for horizontal or vertical properties
		name === "width" ? 1 : 0,

		val = 0;

	for ( ; i < 4; i += 2 ) {
		// both box models exclude margin, so add it if we want it
		if ( extra === "margin" ) {
			// we use jQuery.css instead of curCSS here
			// because of the reliableMarginRight CSS hook!
			val += jQuery.css( elem, extra + cssExpand[ i ], true );
		}

		// From this point on we use curCSS for maximum performance (relevant in animations)
		if ( isBorderBox ) {
			// border-box includes padding, so remove it if we want content
			if ( extra === "content" ) {
				val -= parseFloat( curCSS( elem, "padding" + cssExpand[ i ] ) ) || 0;
			}

			// at this point, extra isn't border nor margin, so remove border
			if ( extra !== "margin" ) {
				val -= parseFloat( curCSS( elem, "border" + cssExpand[ i ] + "Width" ) ) || 0;
			}
		} else {
			// at this point, extra isn't content, so add padding
			val += parseFloat( curCSS( elem, "padding" + cssExpand[ i ] ) ) || 0;

			// at this point, extra isn't content nor padding, so add border
			if ( extra !== "padding" ) {
				val += parseFloat( curCSS( elem, "border" + cssExpand[ i ] + "Width" ) ) || 0;
			}
		}
	}

	return val;
}

function getWidthOrHeight( elem, name, extra ) {

	// Start with offset property, which is equivalent to the border-box value
	var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		valueIsBorderBox = true,
		isBorderBox = jQuery.support.boxSizing && jQuery.css( elem, "boxSizing" ) === "border-box";

	// some non-html elements return undefined for offsetWidth, so check for null/undefined
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
	if ( val <= 0 || val == null ) {
		// Fall back to computed then uncomputed css if necessary
		val = curCSS( elem, name );
		if ( val < 0 || val == null ) {
			val = elem.style[ name ];
		}

		// Computed unit is not pixels. Stop here and return.
		if ( rnumnonpx.test(val) ) {
			return val;
		}

		// we need the check for style in case a browser which returns unreliable values
		// for getComputedStyle silently falls back to the reliable elem.style
		valueIsBorderBox = isBorderBox && ( jQuery.support.boxSizingReliable || val === elem.style[ name ] );

		// Normalize "", auto, and prepare for extra
		val = parseFloat( val ) || 0;
	}

	// use the active box-sizing model to add/subtract irrelevant styles
	return ( val +
		augmentWidthOrHeight(
			elem,
			name,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox
		)
	) + "px";
}


// Try to determine the default display value of an element
function css_defaultDisplay( nodeName ) {
	if ( elemdisplay[ nodeName ] ) {
		return elemdisplay[ nodeName ];
	}

	var elem = jQuery( "<" + nodeName + ">" ).appendTo( document.body ),
		display = elem.css("display");
	elem.remove();

	// If the simple way fails,
	// get element's real default display by attaching it to a temp iframe
	if ( display === "none" || display === "" ) {
		// Use the already-created iframe if possible
		iframe = document.body.appendChild(
			iframe || jQuery.extend( document.createElement("iframe"), {
				frameBorder: 0,
				width: 0,
				height: 0
			})
		);

		// Create a cacheable copy of the iframe document on first call.
		// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
		// document to it; WebKit & Firefox won't allow reusing the iframe document.
		if ( !iframeDoc || !iframe.createElement ) {
			iframeDoc = ( iframe.contentWindow || iframe.contentDocument ).document;
			iframeDoc.write("<!doctype html><html><body>");
			iframeDoc.close();
		}

		elem = iframeDoc.body.appendChild( iframeDoc.createElement(nodeName) );

		display = curCSS( elem, "display" );
		document.body.removeChild( iframe );
	}

	// Store the correct default display
	elemdisplay[ nodeName ] = display;

	return display;
}

jQuery.each([ "height", "width" ], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {
				// certain elements can have dimension info if we invisibly show them
				// however, it must have a current display style that would benefit from this
				if ( elem.offsetWidth === 0 && rdisplayswap.test( curCSS( elem, "display" ) ) ) {
					return jQuery.swap( elem, cssShow, function() {
						return getWidthOrHeight( elem, name, extra );
					});
				} else {
					return getWidthOrHeight( elem, name, extra );
				}
			}
		},

		set: function( elem, value, extra ) {
			return setPositiveNumber( elem, value, extra ?
				augmentWidthOrHeight(
					elem,
					name,
					extra,
					jQuery.support.boxSizing && jQuery.css( elem, "boxSizing" ) === "border-box"
				) : 0
			);
		}
	};
});

if ( !jQuery.support.opacity ) {
	jQuery.cssHooks.opacity = {
		get: function( elem, computed ) {
			// IE uses filters for opacity
			return ropacity.test( (computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "" ) ?
				( 0.01 * parseFloat( RegExp.$1 ) ) + "" :
				computed ? "1" : "";
		},

		set: function( elem, value ) {
			var style = elem.style,
				currentStyle = elem.currentStyle,
				opacity = jQuery.isNumeric( value ) ? "alpha(opacity=" + value * 100 + ")" : "",
				filter = currentStyle && currentStyle.filter || style.filter || "";

			// IE has trouble with opacity if it does not have layout
			// Force it by setting the zoom level
			style.zoom = 1;

			// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
			if ( value >= 1 && jQuery.trim( filter.replace( ralpha, "" ) ) === "" &&
				style.removeAttribute ) {

				// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
				// if "filter:" is present at all, clearType is disabled, we want to avoid this
				// style.removeAttribute is IE Only, but so apparently is this code path...
				style.removeAttribute( "filter" );

				// if there there is no filter style applied in a css rule, we are done
				if ( currentStyle && !currentStyle.filter ) {
					return;
				}
			}

			// otherwise, set new filter values
			style.filter = ralpha.test( filter ) ?
				filter.replace( ralpha, opacity ) :
				filter + " " + opacity;
		}
	};
}

// These hooks cannot be added until DOM ready because the support test
// for it is not run until after DOM ready
jQuery(function() {
	if ( !jQuery.support.reliableMarginRight ) {
		jQuery.cssHooks.marginRight = {
			get: function( elem, computed ) {
				// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
				// Work around by temporarily setting element display to inline-block
				return jQuery.swap( elem, { "display": "inline-block" }, function() {
					if ( computed ) {
						return curCSS( elem, "marginRight" );
					}
				});
			}
		};
	}

	// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
	// getComputedStyle returns percent when specified for top/left/bottom/right
	// rather than make the css module depend on the offset module, we just check for it here
	if ( !jQuery.support.pixelPosition && jQuery.fn.position ) {
		jQuery.each( [ "top", "left" ], function( i, prop ) {
			jQuery.cssHooks[ prop ] = {
				get: function( elem, computed ) {
					if ( computed ) {
						var ret = curCSS( elem, prop );
						// if curCSS returns percentage, fallback to offset
						return rnumnonpx.test( ret ) ? jQuery( elem ).position()[ prop ] + "px" : ret;
					}
				}
			};
		});
	}

});

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.hidden = function( elem ) {
		return ( elem.offsetWidth === 0 && elem.offsetHeight === 0 ) || (!jQuery.support.reliableHiddenOffsets && ((elem.style && elem.style.display) || curCSS( elem, "display" )) === "none");
	};

	jQuery.expr.filters.visible = function( elem ) {
		return !jQuery.expr.filters.hidden( elem );
	};
}

// These hooks are used by animate to expand properties
jQuery.each({
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i,

				// assumes a single number if not a string
				parts = typeof value === "string" ? value.split(" ") : [ value ],
				expanded = {};

			for ( i = 0; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( !rmargin.test( prefix ) ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
});
var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
	rselectTextarea = /^(?:select|textarea)/i;

jQuery.fn.extend({
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map(function(){
			return this.elements ? jQuery.makeArray( this.elements ) : this;
		})
		.filter(function(){
			return this.name && !this.disabled &&
				( this.checked || rselectTextarea.test( this.nodeName ) ||
					rinput.test( this.type ) );
		})
		.map(function( i, elem ){
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val, i ){
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					}) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		}).get();
	}
});

//Serialize an array of form elements or a set of
//key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, value ) {
			// If value is a function, invoke it and return its value
			value = jQuery.isFunction( value ) ? value() : ( value == null ? "" : value );
			s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
		};

	// Set traditional to true for jQuery <= 1.3.2 behavior.
	if ( traditional === undefined ) {
		traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {
		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		});

	} else {
		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" ).replace( r20, "+" );
};

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( jQuery.isArray( obj ) ) {
		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {
				// Treat each array item as a scalar.
				add( prefix, v );

			} else {
				// If array item is non-scalar (array or object), encode its
				// numeric index to resolve deserialization ambiguity issues.
				// Note that rack (as of 1.0.0) can't currently deserialize
				// nested arrays properly, and attempting to do so may cause
				// a server error. Possible fixes are to modify rack's
				// deserialization algorithm or to provide an option or flag
				// to force array serialization to be shallow.
				buildParams( prefix + "[" + ( typeof v === "object" ? i : "" ) + "]", v, traditional, add );
			}
		});

	} else if ( !traditional && jQuery.type( obj ) === "object" ) {
		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {
		// Serialize scalar item.
		add( prefix, obj );
	}
}
var
	// Document location
	ajaxLocParts,
	ajaxLocation,

	rhash = /#.*$/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/mg, // IE leaves an \r character at EOL
	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,
	rquery = /\?/,
	rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
	rts = /([?&])_=[^&]*/,
	rurl = /^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,

	// Keep a copy of the old load method
	_load = jQuery.fn.load,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = ["*/"] + ["*"];

// #8138, IE may throw an exception when accessing
// a field from window.location if document.domain has been set
try {
	ajaxLocation = location.href;
} catch( e ) {
	// Use the href attribute of an A element
	// since IE will modify it given document.location
	ajaxLocation = document.createElement( "a" );
	ajaxLocation.href = "";
	ajaxLocation = ajaxLocation.href;
}

// Segment location into parts
ajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType, list, placeBefore,
			dataTypes = dataTypeExpression.toLowerCase().split( core_rspace ),
			i = 0,
			length = dataTypes.length;

		if ( jQuery.isFunction( func ) ) {
			// For each dataType in the dataTypeExpression
			for ( ; i < length; i++ ) {
				dataType = dataTypes[ i ];
				// We control if we're asked to add before
				// any existing element
				placeBefore = /^\+/.test( dataType );
				if ( placeBefore ) {
					dataType = dataType.substr( 1 ) || "*";
				}
				list = structure[ dataType ] = structure[ dataType ] || [];
				// then we add to the structure accordingly
				list[ placeBefore ? "unshift" : "push" ]( func );
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR,
		dataType /* internal */, inspected /* internal */ ) {

	dataType = dataType || options.dataTypes[ 0 ];
	inspected = inspected || {};

	inspected[ dataType ] = true;

	var selection,
		list = structure[ dataType ],
		i = 0,
		length = list ? list.length : 0,
		executeOnly = ( structure === prefilters );

	for ( ; i < length && ( executeOnly || !selection ); i++ ) {
		selection = list[ i ]( options, originalOptions, jqXHR );
		// If we got redirected to another dataType
		// we try there if executing only and not done already
		if ( typeof selection === "string" ) {
			if ( !executeOnly || inspected[ selection ] ) {
				selection = undefined;
			} else {
				options.dataTypes.unshift( selection );
				selection = inspectPrefiltersOrTransports(
						structure, options, originalOptions, jqXHR, selection, inspected );
			}
		}
	}
	// If we're only executing or nothing was selected
	// we try the catchall dataType if not done already
	if ( ( executeOnly || !selection ) && !inspected[ "*" ] ) {
		selection = inspectPrefiltersOrTransports(
				structure, options, originalOptions, jqXHR, "*", inspected );
	}
	// unnecessary when only executing (prefilters)
	// but it'll be ignored by the caller in that case
	return selection;
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};
	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}
}

jQuery.fn.load = function( url, params, callback ) {
	if ( typeof url !== "string" && _load ) {
		return _load.apply( this, arguments );
	}

	// Don't do a request if no elements are being requested
	if ( !this.length ) {
		return this;
	}

	var selector, type, response,
		self = this,
		off = url.indexOf(" ");

	if ( off >= 0 ) {
		selector = url.slice( off, url.length );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( jQuery.isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// Request the remote document
	jQuery.ajax({
		url: url,

		// if "type" variable is undefined, then "GET" method will be used
		type: type,
		dataType: "html",
		data: params,
		complete: function( jqXHR, status ) {
			if ( callback ) {
				self.each( callback, response || [ jqXHR.responseText, status, jqXHR ] );
			}
		}
	}).done(function( responseText ) {

		// Save response for use in complete callback
		response = arguments;

		// See if a selector was specified
		self.html( selector ?

			// Create a dummy div to hold the results
			jQuery("<div>")

				// inject the contents of the document in, removing the scripts
				// to avoid any 'Permission Denied' errors in IE
				.append( responseText.replace( rscript, "" ) )

				// Locate the specified elements
				.find( selector ) :

			// If not, just inject the full result
			responseText );

	});

	return this;
};

// Attach a bunch of functions for handling common AJAX events
jQuery.each( "ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split( " " ), function( i, o ){
	jQuery.fn[ o ] = function( f ){
		return this.on( o, f );
	};
});

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {
		// shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		return jQuery.ajax({
			type: method,
			url: url,
			data: data,
			success: callback,
			dataType: type
		});
	};
});

jQuery.extend({

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		if ( settings ) {
			// Building a settings object
			ajaxExtend( target, jQuery.ajaxSettings );
		} else {
			// Extending ajaxSettings
			settings = target;
			target = jQuery.ajaxSettings;
		}
		ajaxExtend( target, settings );
		return target;
	},

	ajaxSettings: {
		url: ajaxLocation,
		isLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),
		global: true,
		type: "GET",
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",
		processData: true,
		async: true,
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			xml: "application/xml, text/xml",
			html: "text/html",
			text: "text/plain",
			json: "application/json, text/javascript",
			"*": allTypes
		},

		contents: {
			xml: /xml/,
			html: /html/,
			json: /json/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText"
		},

		// List of data converters
		// 1) key format is "source_type destination_type" (a single space in-between)
		// 2) the catchall symbol "*" can be used for source_type
		converters: {

			// Convert anything to text
			"* text": window.String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			context: true,
			url: true
		}
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var // ifModified key
			ifModifiedKey,
			// Response headers
			responseHeadersString,
			responseHeaders,
			// transport
			transport,
			// timeout handle
			timeoutTimer,
			// Cross-domain detection vars
			parts,
			// To know if global events are to be dispatched
			fireGlobals,
			// Loop variable
			i,
			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),
			// Callbacks context
			callbackContext = s.context || s,
			// Context for global events
			// It's the callbackContext if one was provided in the options
			// and if it's a DOM node or a jQuery collection
			globalEventContext = callbackContext !== s &&
				( callbackContext.nodeType || callbackContext instanceof jQuery ) ?
						jQuery( callbackContext ) : jQuery.event,
			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),
			// Status-dependent callbacks
			statusCode = s.statusCode || {},
			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},
			// The jqXHR state
			state = 0,
			// Default abort message
			strAbort = "canceled",
			// Fake xhr
			jqXHR = {

				readyState: 0,

				// Caches the header
				setRequestHeader: function( name, value ) {
					if ( !state ) {
						var lname = name.toLowerCase();
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[1].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match === undefined ? null : match;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					statusText = statusText || strAbort;
					if ( transport ) {
						transport.abort( statusText );
					}
					done( 0, statusText );
					return this;
				}
			};

		// Callback for when everything is done
		// It is defined here because jslint complains if it is declared
		// at the end of the function (which would be more logical and readable)
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// If successful, handle type chaining
			if ( status >= 200 && status < 300 || status === 304 ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {

					modified = jqXHR.getResponseHeader("Last-Modified");
					if ( modified ) {
						jQuery.lastModified[ ifModifiedKey ] = modified;
					}
					modified = jqXHR.getResponseHeader("Etag");
					if ( modified ) {
						jQuery.etag[ ifModifiedKey ] = modified;
					}
				}

				// If not modified
				if ( status === 304 ) {

					statusText = "notmodified";
					isSuccess = true;

				// If we have data
				} else {

					isSuccess = ajaxConvert( s, response );
					statusText = isSuccess.state;
					success = isSuccess.data;
					error = isSuccess.error;
					isSuccess = !error;
				}
			} else {
				// We extract error from statusText
				// then normalize statusText and status for non-aborts
				error = statusText;
				if ( !statusText || status ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajax" + ( isSuccess ? "Success" : "Error" ),
						[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );
				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		// Attach deferreds
		deferred.promise( jqXHR );
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;
		jqXHR.complete = completeDeferred.add;

		// Status-dependent callbacks
		jqXHR.statusCode = function( map ) {
			if ( map ) {
				var tmp;
				if ( state < 2 ) {
					for ( tmp in map ) {
						statusCode[ tmp ] = [ statusCode[tmp], map[tmp] ];
					}
				} else {
					tmp = map[ jqXHR.status ];
					jqXHR.always( tmp );
				}
			}
			return this;
		};

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (#5866: IE7 issue with protocol-less urls)
		// We also use the url parameter if available
		s.url = ( ( url || s.url ) + "" ).replace( rhash, "" ).replace( rprotocol, ajaxLocParts[ 1 ] + "//" );

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().split( core_rspace );

		// A cross-domain request is in order when we have a protocol:host:port mismatch
		if ( s.crossDomain == null ) {
			parts = rurl.exec( s.url.toLowerCase() );
			s.crossDomain = !!( parts &&
				( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||
					( parts[ 3 ] || ( parts[ 1 ] === "http:" ? 80 : 443 ) ) !=
						( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === "http:" ? 80 : 443 ) ) )
			);
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( state === 2 ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		fireGlobals = s.global;

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.data;
				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Get ifModifiedKey before adding the anti-cache parameter
			ifModifiedKey = s.url;

			// Add anti-cache in url if needed
			if ( s.cache === false ) {

				var ts = jQuery.now(),
					// try replacing _= if it is there
					ret = s.url.replace( rts, "$1_=" + ts );

				// if nothing was replaced, add timestamp to the end
				s.url = ret + ( ( ret === s.url ) ? ( rquery.test( s.url ) ? "&" : "?" ) + "_=" + ts : "" );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			ifModifiedKey = ifModifiedKey || s.url;
			if ( jQuery.lastModified[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ ifModifiedKey ] );
			}
			if ( jQuery.etag[ ifModifiedKey ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ ifModifiedKey ] );
			}
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[0] ] ?
				s.accepts[ s.dataTypes[0] ] + ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {
				// Abort if not done already and return
				return jqXHR.abort();

		}

		// aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;
			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}
			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = setTimeout( function(){
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch (e) {
				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );
				// Simply rethrow otherwise
				} else {
					throw e;
				}
			}
		}

		return jqXHR;
	},

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {}

});

/* Handles responses to an ajax request:
 * - sets all responseXXX fields accordingly
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes,
		responseFields = s.responseFields;

	// Fill responseXXX fields
	for ( type in responseFields ) {
		if ( type in responses ) {
			jqXHR[ responseFields[type] ] = responses[ type ];
		}
	}

	// Remove auto dataType and get content-type in the process
	while( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "content-type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {
		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[0] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}
		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

// Chain conversions given the request and the original response
function ajaxConvert( s, response ) {

	var conv, conv2, current, tmp,
		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice(),
		prev = dataTypes[ 0 ],
		converters = {},
		i = 0;

	// Apply the dataFilter if provided
	if ( s.dataFilter ) {
		response = s.dataFilter( response, s.dataType );
	}

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	// Convert to each sequential dataType, tolerating list modification
	for ( ; (current = dataTypes[++i]); ) {

		// There's only work to do if current dataType is non-auto
		if ( current !== "*" ) {

			// Convert response if prev dataType is non-auto and differs from current
			if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split(" ");
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {
								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.splice( i--, 0, current );
								}

								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s["throws"] ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return { state: "parsererror", error: conv ? e : "No conversion from " + prev + " to " + current };
						}
					}
				}
			}

			// Update prev for next iteration
			prev = current;
		}
	}

	return { state: "success", data: response };
}
var oldCallbacks = [],
	rquestion = /\?/,
	rjsonp = /(=)\?(?=&|$)|\?\?/,
	nonce = jQuery.now();

// Default jsonp settings
jQuery.ajaxSetup({
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
});

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		data = s.data,
		url = s.url,
		hasCallback = s.jsonp !== false,
		replaceInUrl = hasCallback && rjsonp.test( url ),
		replaceInData = hasCallback && !replaceInUrl && typeof data === "string" &&
			!( s.contentType || "" ).indexOf("application/x-www-form-urlencoded") &&
			rjsonp.test( data );

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( s.dataTypes[ 0 ] === "jsonp" || replaceInUrl || replaceInData ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;
		overwritten = window[ callbackName ];

		// Insert callback into url or form data
		if ( replaceInUrl ) {
			s.url = url.replace( rjsonp, "$1" + callbackName );
		} else if ( replaceInData ) {
			s.data = data.replace( rjsonp, "$1" + callbackName );
		} else if ( hasCallback ) {
			s.url += ( rquestion.test( url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters["script json"] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always(function() {
			// Restore preexisting value
			window[ callbackName ] = overwritten;

			// Save back as free
			if ( s[ callbackName ] ) {
				// make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		});

		// Delegate to script
		return "script";
	}
});
// Install script dataType
jQuery.ajaxSetup({
	accepts: {
		script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /javascript|ecmascript/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
});

// Handle cache's special case and global
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
		s.global = false;
	}
});

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function(s) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {

		var script,
			head = document.head || document.getElementsByTagName( "head" )[0] || document.documentElement;

		return {

			send: function( _, callback ) {

				script = document.createElement( "script" );

				script.async = "async";

				if ( s.scriptCharset ) {
					script.charset = s.scriptCharset;
				}

				script.src = s.url;

				// Attach handlers for all browsers
				script.onload = script.onreadystatechange = function( _, isAbort ) {

					if ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {

						// Handle memory leak in IE
						script.onload = script.onreadystatechange = null;

						// Remove the script
						if ( head && script.parentNode ) {
							head.removeChild( script );
						}

						// Dereference the script
						script = undefined;

						// Callback if not abort
						if ( !isAbort ) {
							callback( 200, "success" );
						}
					}
				};
				// Use insertBefore instead of appendChild  to circumvent an IE6 bug.
				// This arises when a base node is used (#2709 and #4378).
				head.insertBefore( script, head.firstChild );
			},

			abort: function() {
				if ( script ) {
					script.onload( 0, 1 );
				}
			}
		};
	}
});
var xhrCallbacks,
	// #5280: Internet Explorer will keep connections alive if we don't abort on unload
	xhrOnUnloadAbort = window.ActiveXObject ? function() {
		// Abort all pending requests
		for ( var key in xhrCallbacks ) {
			xhrCallbacks[ key ]( 0, 1 );
		}
	} : false,
	xhrId = 0;

// Functions to create xhrs
function createStandardXHR() {
	try {
		return new window.XMLHttpRequest();
	} catch( e ) {}
}

function createActiveXHR() {
	try {
		return new window.ActiveXObject( "Microsoft.XMLHTTP" );
	} catch( e ) {}
}

// Create the request object
// (This is still attached to ajaxSettings for backward compatibility)
jQuery.ajaxSettings.xhr = window.ActiveXObject ?
	/* Microsoft failed to properly
	 * implement the XMLHttpRequest in IE7 (can't request local files),
	 * so we use the ActiveXObject when it is available
	 * Additionally XMLHttpRequest can be disabled in IE7/IE8 so
	 * we need a fallback.
	 */
	function() {
		return !this.isLocal && createStandardXHR() || createActiveXHR();
	} :
	// For all other browsers, use the standard XMLHttpRequest object
	createStandardXHR;

// Determine support properties
(function( xhr ) {
	jQuery.extend( jQuery.support, {
		ajax: !!xhr,
		cors: !!xhr && ( "withCredentials" in xhr )
	});
})( jQuery.ajaxSettings.xhr() );

// Create transport if the browser can provide an xhr
if ( jQuery.support.ajax ) {

	jQuery.ajaxTransport(function( s ) {
		// Cross domain only allowed if supported through XMLHttpRequest
		if ( !s.crossDomain || jQuery.support.cors ) {

			var callback;

			return {
				send: function( headers, complete ) {

					// Get a new xhr
					var handle, i,
						xhr = s.xhr();

					// Open the socket
					// Passing null username, generates a login popup on Opera (#2865)
					if ( s.username ) {
						xhr.open( s.type, s.url, s.async, s.username, s.password );
					} else {
						xhr.open( s.type, s.url, s.async );
					}

					// Apply custom fields if provided
					if ( s.xhrFields ) {
						for ( i in s.xhrFields ) {
							xhr[ i ] = s.xhrFields[ i ];
						}
					}

					// Override mime type if needed
					if ( s.mimeType && xhr.overrideMimeType ) {
						xhr.overrideMimeType( s.mimeType );
					}

					// X-Requested-With header
					// For cross-domain requests, seeing as conditions for a preflight are
					// akin to a jigsaw puzzle, we simply never set it to be sure.
					// (it can always be set on a per-request basis or even using ajaxSetup)
					// For same-domain requests, won't change header if already provided.
					if ( !s.crossDomain && !headers["X-Requested-With"] ) {
						headers[ "X-Requested-With" ] = "XMLHttpRequest";
					}

					// Need an extra try/catch for cross domain requests in Firefox 3
					try {
						for ( i in headers ) {
							xhr.setRequestHeader( i, headers[ i ] );
						}
					} catch( _ ) {}

					// Do send the request
					// This may raise an exception which is actually
					// handled in jQuery.ajax (so no try/catch here)
					xhr.send( ( s.hasContent && s.data ) || null );

					// Listener
					callback = function( _, isAbort ) {

						var status,
							statusText,
							responseHeaders,
							responses,
							xml;

						// Firefox throws exceptions when accessing properties
						// of an xhr when a network error occurred
						// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
						try {

							// Was never called and is aborted or complete
							if ( callback && ( isAbort || xhr.readyState === 4 ) ) {

								// Only called once
								callback = undefined;

								// Do not keep as active anymore
								if ( handle ) {
									xhr.onreadystatechange = jQuery.noop;
									if ( xhrOnUnloadAbort ) {
										delete xhrCallbacks[ handle ];
									}
								}

								// If it's an abort
								if ( isAbort ) {
									// Abort it manually if needed
									if ( xhr.readyState !== 4 ) {
										xhr.abort();
									}
								} else {
									status = xhr.status;
									responseHeaders = xhr.getAllResponseHeaders();
									responses = {};
									xml = xhr.responseXML;

									// Construct response list
									if ( xml && xml.documentElement /* #4958 */ ) {
										responses.xml = xml;
									}

									// When requesting binary data, IE6-9 will throw an exception
									// on any attempt to access responseText (#11426)
									try {
										responses.text = xhr.responseText;
									} catch( e ) {
									}

									// Firefox throws an exception when accessing
									// statusText for faulty cross-domain requests
									try {
										statusText = xhr.statusText;
									} catch( e ) {
										// We normalize with Webkit giving an empty statusText
										statusText = "";
									}

									// Filter status for non standard behaviors

									// If the request is local and we have data: assume a success
									// (success with no data won't get notified, that's the best we
									// can do given current implementations)
									if ( !status && s.isLocal && !s.crossDomain ) {
										status = responses.text ? 200 : 404;
									// IE - #1450: sometimes returns 1223 when it should be 204
									} else if ( status === 1223 ) {
										status = 204;
									}
								}
							}
						} catch( firefoxAccessException ) {
							if ( !isAbort ) {
								complete( -1, firefoxAccessException );
							}
						}

						// Call complete if needed
						if ( responses ) {
							complete( status, statusText, responses, responseHeaders );
						}
					};

					if ( !s.async ) {
						// if we're in sync mode we fire the callback
						callback();
					} else if ( xhr.readyState === 4 ) {
						// (IE6 & IE7) if it's in cache and has been
						// retrieved directly we need to fire the callback
						setTimeout( callback, 0 );
					} else {
						handle = ++xhrId;
						if ( xhrOnUnloadAbort ) {
							// Create the active xhrs callbacks list if needed
							// and attach the unload handler
							if ( !xhrCallbacks ) {
								xhrCallbacks = {};
								jQuery( window ).unload( xhrOnUnloadAbort );
							}
							// Add to list of active xhrs callbacks
							xhrCallbacks[ handle ] = callback;
						}
						xhr.onreadystatechange = callback;
					}
				},

				abort: function() {
					if ( callback ) {
						callback(0,1);
					}
				}
			};
		}
	});
}
var fxNow, timerId,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rfxnum = new RegExp( "^(?:([-+])=|)(" + core_pnum + ")([a-z%]*)$", "i" ),
	rrun = /queueHooks$/,
	animationPrefilters = [ defaultPrefilter ],
	tweeners = {
		"*": [function( prop, value ) {
			var end, unit,
				tween = this.createTween( prop, value ),
				parts = rfxnum.exec( value ),
				target = tween.cur(),
				start = +target || 0,
				scale = 1,
				maxIterations = 20;

			if ( parts ) {
				end = +parts[2];
				unit = parts[3] || ( jQuery.cssNumber[ prop ] ? "" : "px" );

				// We need to compute starting value
				if ( unit !== "px" && start ) {
					// Iteratively approximate from a nonzero starting point
					// Prefer the current property, because this process will be trivial if it uses the same units
					// Fallback to end or a simple constant
					start = jQuery.css( tween.elem, prop, true ) || end || 1;

					do {
						// If previous iteration zeroed out, double until we get *something*
						// Use a string for doubling factor so we don't accidentally see scale as unchanged below
						scale = scale || ".5";

						// Adjust and apply
						start = start / scale;
						jQuery.style( tween.elem, prop, start + unit );

					// Update scale, tolerating zero or NaN from tween.cur()
					// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
					} while ( scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations );
				}

				tween.unit = unit;
				tween.start = start;
				// If a +=/-= token was provided, we're doing a relative animation
				tween.end = parts[1] ? start + ( parts[1] + 1 ) * end : end;
			}
			return tween;
		}]
	};

// Animations created synchronously will run synchronously
function createFxNow() {
	setTimeout(function() {
		fxNow = undefined;
	}, 0 );
	return ( fxNow = jQuery.now() );
}

function createTweens( animation, props ) {
	jQuery.each( props, function( prop, value ) {
		var collection = ( tweeners[ prop ] || [] ).concat( tweeners[ "*" ] ),
			index = 0,
			length = collection.length;
		for ( ; index < length; index++ ) {
			if ( collection[ index ].call( animation, prop, value ) ) {

				// we're done with this property
				return;
			}
		}
	});
}

function Animation( elem, properties, options ) {
	var result,
		index = 0,
		tweenerIndex = 0,
		length = animationPrefilters.length,
		deferred = jQuery.Deferred().always( function() {
			// don't match elem in the :animated selector
			delete tick.elem;
		}),
		tick = function() {
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),
				// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length ; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ]);

			if ( percent < 1 && length ) {
				return remaining;
			} else {
				deferred.resolveWith( elem, [ animation ] );
				return false;
			}
		},
		animation = deferred.promise({
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, { specialEasing: {} }, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end, easing ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,
					// if we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;

				for ( ; index < length ; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// resolve when we played the last frame
				// otherwise, reject
				if ( gotoEnd ) {
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		}),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length ; index++ ) {
		result = animationPrefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			return result;
		}
	}

	createTweens( animation, props );

	if ( jQuery.isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	jQuery.fx.timer(
		jQuery.extend( tick, {
			anim: animation,
			queue: animation.opts.queue,
			elem: elem
		})
	);

	// attach callbacks from options
	return animation.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = jQuery.camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( jQuery.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// not quite $.extend, this wont overwrite keys already present.
			// also - reusing 'index' from above because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

jQuery.Animation = jQuery.extend( Animation, {

	tweener: function( props, callback ) {
		if ( jQuery.isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.split(" ");
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length ; index++ ) {
			prop = props[ index ];
			tweeners[ prop ] = tweeners[ prop ] || [];
			tweeners[ prop ].unshift( callback );
		}
	},

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			animationPrefilters.unshift( callback );
		} else {
			animationPrefilters.push( callback );
		}
	}
});

function defaultPrefilter( elem, props, opts ) {
	var index, prop, value, length, dataShow, toggle, tween, hooks, oldfire,
		anim = this,
		style = elem.style,
		orig = {},
		handled = [],
		hidden = elem.nodeType && isHidden( elem );

	// handle queue: false promises
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always(function() {
			// doing this makes sure that the complete handler will be called
			// before this completes
			anim.always(function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			});
		});
	}

	// height/width overflow pass
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {
		// Make sure that nothing sneaks out
		// Record all 3 overflow attributes because IE does not
		// change the overflow attribute when overflowX and
		// overflowY are set to the same value
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Set display property to inline-block for height/width
		// animations on inline elements that are having width/height animated
		if ( jQuery.css( elem, "display" ) === "inline" &&
				jQuery.css( elem, "float" ) === "none" ) {

			// inline-level elements accept inline-block;
			// block-level elements need to be inline with layout
			if ( !jQuery.support.inlineBlockNeedsLayout || css_defaultDisplay( elem.nodeName ) === "inline" ) {
				style.display = "inline-block";

			} else {
				style.zoom = 1;
			}
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		if ( !jQuery.support.shrinkWrapBlocks ) {
			anim.done(function() {
				style.overflow = opts.overflow[ 0 ];
				style.overflowX = opts.overflow[ 1 ];
				style.overflowY = opts.overflow[ 2 ];
			});
		}
	}


	// show/hide pass
	for ( index in props ) {
		value = props[ index ];
		if ( rfxtypes.exec( value ) ) {
			delete props[ index ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {
				continue;
			}
			handled.push( index );
		}
	}

	length = handled.length;
	if ( length ) {
		dataShow = jQuery._data( elem, "fxshow" ) || jQuery._data( elem, "fxshow", {} );
		if ( "hidden" in dataShow ) {
			hidden = dataShow.hidden;
		}

		// store state if its toggle - enables .stop().toggle() to "reverse"
		if ( toggle ) {
			dataShow.hidden = !hidden;
		}
		if ( hidden ) {
			jQuery( elem ).show();
		} else {
			anim.done(function() {
				jQuery( elem ).hide();
			});
		}
		anim.done(function() {
			var prop;
			jQuery.removeData( elem, "fxshow", true );
			for ( prop in orig ) {
				jQuery.style( elem, prop, orig[ prop ] );
			}
		});
		for ( index = 0 ; index < length ; index++ ) {
			prop = handled[ index ];
			tween = anim.createTween( prop, hidden ? dataShow[ prop ] : 0 );
			orig[ prop ] = dataShow[ prop ] || jQuery.style( elem, prop );

			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = tween.start;
				if ( hidden ) {
					tween.end = tween.start;
					tween.start = prop === "width" || prop === "height" ? 1 : 0;
				}
			}
		}
	}
}

function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || "swing";
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			if ( tween.elem[ tween.prop ] != null &&
				(!tween.elem.style || tween.elem.style[ tween.prop ] == null) ) {
				return tween.elem[ tween.prop ];
			}

			// passing any value as a 4th parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails
			// so, simple values such as "10px" are parsed to Float.
			// complex values such as "rotate(1rad)" are returned as is.
			result = jQuery.css( tween.elem, tween.prop, false, "" );
			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {
			// use step hook for back compat - use cssHook if its there - use .style if its
			// available and use plain properties where available
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.style && ( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null || jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Remove in 2.0 - this supports IE8's panic based approach
// to setting things on disconnected nodes

Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.each([ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ||
			// special check for .toggle( handler, handler, ... )
			( !i && jQuery.isFunction( speed ) && jQuery.isFunction( easing ) ) ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
});

jQuery.fn.extend({
	fadeTo: function( speed, to, easing, callback ) {

		// show any hidden elements after setting opacity to 0
		return this.filter( isHidden ).css( "opacity", 0 ).show()

			// animate to the value specified
			.end().animate({ opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {
				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations resolve immediately
				if ( empty ) {
					anim.stop( true );
				}
			};

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each(function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = jQuery._data( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && (type == null || timers[ index ].queue === type) ) {
					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// start the next in the queue if the last step wasn't forced
			// timers currently will call their complete callbacks, which will dequeue
			// but only if they were gotoEnd
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		});
	}
});

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		attrs = { height: type },
		i = 0;

	// if we include width, step value is 1 to do all cssExpand values,
	// if we don't include width, step value is 2 to skip over Left and Right
	includeWidth = includeWidth? 1 : 0;
	for( ; i < 4 ; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

// Generate shortcuts for custom animations
jQuery.each({
	slideDown: genFx("show"),
	slideUp: genFx("hide"),
	slideToggle: genFx("toggle"),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
});

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			jQuery.isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
	};

	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
		opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;

	// normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( jQuery.isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p*Math.PI ) / 2;
	}
};

jQuery.timers = [];
jQuery.fx = Tween.prototype.init;
jQuery.fx.tick = function() {
	var timer,
		timers = jQuery.timers,
		i = 0;

	fxNow = jQuery.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];
		// Checks the timer has not already been removed
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	if ( timer() && jQuery.timers.push( timer ) && !timerId ) {
		timerId = setInterval( jQuery.fx.tick, jQuery.fx.interval );
	}
};

jQuery.fx.interval = 13;

jQuery.fx.stop = function() {
	clearInterval( timerId );
	timerId = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,
	// Default speed
	_default: 400
};

// Back Compat <1.8 extension point
jQuery.fx.step = {};

if ( jQuery.expr && jQuery.expr.filters ) {
	jQuery.expr.filters.animated = function( elem ) {
		return jQuery.grep(jQuery.timers, function( fn ) {
			return elem === fn.elem;
		}).length;
	};
}
var rroot = /^(?:body|html)$/i;

jQuery.fn.offset = function( options ) {
	if ( arguments.length ) {
		return options === undefined ?
			this :
			this.each(function( i ) {
				jQuery.offset.setOffset( this, options, i );
			});
	}

	var docElem, body, win, clientTop, clientLeft, scrollTop, scrollLeft,
		box = { top: 0, left: 0 },
		elem = this[ 0 ],
		doc = elem && elem.ownerDocument;

	if ( !doc ) {
		return;
	}

	if ( (body = doc.body) === elem ) {
		return jQuery.offset.bodyOffset( elem );
	}

	docElem = doc.documentElement;

	// Make sure it's not a disconnected DOM node
	if ( !jQuery.contains( docElem, elem ) ) {
		return box;
	}

	// If we don't have gBCR, just use 0,0 rather than error
	// BlackBerry 5, iOS 3 (original iPhone)
	if ( typeof elem.getBoundingClientRect !== "undefined" ) {
		box = elem.getBoundingClientRect();
	}
	win = getWindow( doc );
	clientTop  = docElem.clientTop  || body.clientTop  || 0;
	clientLeft = docElem.clientLeft || body.clientLeft || 0;
	scrollTop  = win.pageYOffset || docElem.scrollTop;
	scrollLeft = win.pageXOffset || docElem.scrollLeft;
	return {
		top: box.top  + scrollTop  - clientTop,
		left: box.left + scrollLeft - clientLeft
	};
};

jQuery.offset = {

	bodyOffset: function( body ) {
		var top = body.offsetTop,
			left = body.offsetLeft;

		if ( jQuery.support.doesNotIncludeMarginInBodyOffset ) {
			top  += parseFloat( jQuery.css(body, "marginTop") ) || 0;
			left += parseFloat( jQuery.css(body, "marginLeft") ) || 0;
		}

		return { top: top, left: left };
	},

	setOffset: function( elem, options, i ) {
		var position = jQuery.css( elem, "position" );

		// set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		var curElem = jQuery( elem ),
			curOffset = curElem.offset(),
			curCSSTop = jQuery.css( elem, "top" ),
			curCSSLeft = jQuery.css( elem, "left" ),
			calculatePosition = ( position === "absolute" || position === "fixed" ) && jQuery.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
			props = {}, curPosition = {}, curTop, curLeft;

		// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;
		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {
			options = options.call( elem, i, curOffset );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );
		} else {
			curElem.css( props );
		}
	}
};


jQuery.fn.extend({

	position: function() {
		if ( !this[0] ) {
			return;
		}

		var elem = this[0],

		// Get *real* offsetParent
		offsetParent = this.offsetParent(),

		// Get correct offsets
		offset       = this.offset(),
		parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

		// Subtract element margins
		// note: when an element has margin: auto the offsetLeft and marginLeft
		// are the same in Safari causing offset.left to incorrectly be 0
		offset.top  -= parseFloat( jQuery.css(elem, "marginTop") ) || 0;
		offset.left -= parseFloat( jQuery.css(elem, "marginLeft") ) || 0;

		// Add offsetParent borders
		parentOffset.top  += parseFloat( jQuery.css(offsetParent[0], "borderTopWidth") ) || 0;
		parentOffset.left += parseFloat( jQuery.css(offsetParent[0], "borderLeftWidth") ) || 0;

		// Subtract the two offsets
		return {
			top:  offset.top  - parentOffset.top,
			left: offset.left - parentOffset.left
		};
	},

	offsetParent: function() {
		return this.map(function() {
			var offsetParent = this.offsetParent || document.body;
			while ( offsetParent && (!rroot.test(offsetParent.nodeName) && jQuery.css(offsetParent, "position") === "static") ) {
				offsetParent = offsetParent.offsetParent;
			}
			return offsetParent || document.body;
		});
	}
});


// Create scrollLeft and scrollTop methods
jQuery.each( {scrollLeft: "pageXOffset", scrollTop: "pageYOffset"}, function( method, prop ) {
	var top = /Y/.test( prop );

	jQuery.fn[ method ] = function( val ) {
		return jQuery.access( this, function( elem, method, val ) {
			var win = getWindow( elem );

			if ( val === undefined ) {
				return win ? (prop in win) ? win[ prop ] :
					win.document.documentElement[ method ] :
					elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : jQuery( win ).scrollLeft(),
					 top ? val : jQuery( win ).scrollTop()
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length, null );
	};
});

function getWindow( elem ) {
	return jQuery.isWindow( elem ) ?
		elem :
		elem.nodeType === 9 ?
			elem.defaultView || elem.parentWindow :
			false;
}
// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name }, function( defaultExtra, funcName ) {
		// margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return jQuery.access( this, function( elem, type, value ) {
				var doc;

				if ( jQuery.isWindow( elem ) ) {
					// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
					// isn't a whole lot we can do. See pull request at this URL for discussion:
					// https://github.com/jquery/jquery/pull/764
					return elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
					// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?
					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, value, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable, null );
		};
	});
});
// Expose jQuery to the global object
window.jQuery = window.$ = jQuery;

// Expose jQuery as an AMD module, but only for AMD loaders that
// understand the issues with loading multiple versions of jQuery
// in a page that all might call define(). The loader will indicate
// they have special allowances for multiple jQuery versions by
// specifying define.amd.jQuery = true. Register as a named module,
// since jQuery can be concatenated with other files that may use define,
// but not use a proper concatenation script that understands anonymous
// AMD modules. A named AMD is safest and most robust way to register.
// Lowercase jquery is used because AMD module names are derived from
// file names, and jQuery is normally delivered in a lowercase file name.
// Do this after creating the global so that if an AMD module wants to call
// noConflict to hide this version of jQuery, it will work.
if ( typeof define === "function" && define.amd && define.amd.jQuery ) {
	define( "jquery", [], function () { return jQuery; } );
}

})( window );


/* added by builder */
return jQuery;
}),
"bemhtml": (function (require) { /* wrapped by builder */
var BEMHTML = (function(exports) {
    var apply = exports.apply = function dispatch(callback) {
        if (typeof callback !== "function") {
            var reqq = dispatch.reqq, resq = dispatch.resq, result;
            delete dispatch.reqq;
            delete dispatch.resq;
            applySync.call(this, function(err, r) {
                if (err) throw err;
                result = r;
            });
            dispatch.reqq = reqq;
            dispatch.resq = resq;
            return result;
        }
        var reqq = dispatch.reqq || [], resq = dispatch.resq || [];
        reqq.push({
            self: this,
            res: null,
            callback: callback
        });
        if (dispatch.reqq && dispatch.resq) return;
        dispatch.reqq = reqq;
        dispatch.resq = resq;
        while (reqq.length !== 0 || resq.length !== 0) {
            if (reqq.length !== 0) {
                var item = reqq.pop();
                (function(item) {
                    applySync.call(item.self, function(err, r) {
                        if (err) throw err;
                        item.res = r;
                        resq.push(item);
                    });
                })(item);
            }
            if (resq.length !== 0) {
                var item = resq.shift();
                item.callback.call(item.self, null, item.res);
            }
        }
        delete dispatch.reqq;
        delete dispatch.resq;
        return null;
    };
    function applySync(__$callback) {
        if (this.block === "b-vb-foot") {
            var __t = this._mode;
            if (__t === "content") {
                if (!!this.elem === false) {
                    return $5.call(this, __$callback);
                } else {
                    return $15.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $10.call(this, __$callback);
                } else {
                    return $15.call(this, __$callback);
                }
            } else {
                return $15.call(this, __$callback);
            }
        } else {
            return $15.call(this, __$callback);
        }
    }
    function $5(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "wrapper",
            content: this.ctx.content
        });
    }
    function $10(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "div");
    }
    function $15(__$callback) {
        if (!this._ === false) {
            if (!!this._.cleverSubstring === false) {
                return $18.call(this, __$callback);
            } else {
                return $21.call(this, __$callback);
            }
        } else {
            return $21.call(this, __$callback);
        }
    }
    function $18(__$callback) {
        var __$r7;
        function __$fn7(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r7 = __$r;
            }
            __r154.cleverSubstring = __r155;
            "";
            return __$callback.call(this, null);
        }
        var __r154, __r155;
        "enable spoon";
        "";
        __r154 = this._;
        __r155 = __r154.cleverSubstring;
        __r154.cleverSubstring = function(str, maxLength, maxLengthRelative) {
            var __$i47;
            if (str.length > maxLength + maxLengthRelative) {
                __$i47 = str.substring(0, maxLength - 1) + "…";
            } else {
                __$i47 = str;
            }
            return __$i47;
        };
        return this.apply(__$fn7);
    }
    function $21(__$callback) {
        var __t = this.block;
        if (__t === "b-search") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "intro") {
                    return $25.call(this, __$callback);
                } else if (__t === "button") {
                    return $27.call(this, __$callback);
                } else if (__t === "input") {
                    return $29.call(this, __$callback);
                } else if (__t === "under") {
                    return $31.call(this, __$callback);
                } else if (__t === "col") {
                    return $33.call(this, __$callback);
                } else if (__t === "row") {
                    return $35.call(this, __$callback);
                } else if (__t === "table") {
                    return $37.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $40.call(this, __$callback);
                    } else {
                        var __t = this.elem;
                        if (__t === "button") {
                            return $43.call(this, __$callback);
                        } else if (__t === "input") {
                            return $45.call(this, __$callback);
                        } else {
                            if (!!this.elem === false) {
                                return $48.call(this, __$callback);
                            } else {
                                return $658.call(this, __$callback);
                            }
                        }
                    }
                }
            } else if (__t === "cls") {
                if (this.elem === "sample") {
                    return $53.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (this.elem === "sample") {
                    return $58.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (this.elem === "sample") {
                    if (!this.ctx.text === false) {
                        return $64.call(this, __$callback);
                    } else {
                        return $67.call(this, __$callback);
                    }
                } else {
                    return $67.call(this, __$callback);
                }
            } else if (__t === "attrs") {
                var __t = this.elem;
                if (__t === "button") {
                    return $86.call(this, __$callback);
                } else if (__t === "input") {
                    return $88.call(this, __$callback);
                } else if (__t === "under") {
                    return $90.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $93.call(this, __$callback);
                    } else {
                        var __t = this.elem;
                        if (__t === "button") {
                            return $96.call(this, __$callback);
                        } else if (__t === "input") {
                            return $98.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    }
                }
            } else if (__t === "bem") {
                if (this.elem === "row") {
                    return $103.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "lego-input") {
                return $107.call(this, __$callback);
            } else if (__t === "lego-label") {
                return $109.call(this, __$callback);
            } else if (__t === "lego-under") {
                return $111.call(this, __$callback);
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-link") {
            var __t = this._mode;
            if (__t === "content") {
                if (!(this.mods && this.mods.pseudo) === false) {
                    if (!!this.ctx._wrap === false) {
                        if (!!this.elem === false) {
                            if (!!this.mods.inner === false) {
                                return $264.call(this, __$callback);
                            } else {
                                return $658.call(this, __$callback);
                            }
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "attrs") {
                if (!(this.mods && this.mods.pseudo) === false) {
                    if (!!this.elem === false) {
                        if (!!this.ctx.url === false) {
                            return $277.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!(this.mods && this.mods.pseudo) === false) {
                    if (!!this.elem === false) {
                        return $287.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!(this.mods && this.mods.pseudo) === false) {
                    if (!!this.elem === false) {
                        return $295.call(this, __$callback);
                    } else {
                        return $298.call(this, __$callback);
                    }
                } else {
                    return $298.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-menu-horiz") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "layout-unit") {
                    if (!this.mods === false) {
                        if (this.mods.layout === "normal") {
                            return $310.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else if (__t === "layout") {
                    if (!this.mods === false) {
                        if (this.mods.layout === "normal") {
                            return $318.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else if (__t === "title") {
                    return $324.call(this, __$callback);
                } else if (__t === "item-selector") {
                    if (!this.mods === false) {
                        return $327.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (!this.mods === false) {
                    if (this.mods.layout === "normal") {
                        if (!!this.elem === false) {
                            return $336.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (this.elem === "layout-unit") {
                    if (!this.mods === false) {
                        return $346.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "item") {
                    if (!this.mods === false) {
                        if (!!this.ctx._wrap === false) {
                            return $355.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!(this.ctx.js === undefined) === false) {
                    if (!this.mods === false) {
                        if (!!this.elem === false) {
                            return $366.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-dropdowna") {
            var __t = this._mode;
            if (__t === "tag") {
                if (this.elem === "switcher") {
                    return $378.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (!!this.ctx._init === false) {
                    return $383.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!!this.elem === false) {
                    return $388.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $393.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-menu-vert") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "submenu") {
                    return $227.call(this, __$callback);
                } else if (__t === "item-selector") {
                    return $229.call(this, __$callback);
                } else if (__t === "layout-unit") {
                    return $231.call(this, __$callback);
                } else if (__t === "layout") {
                    return $233.call(this, __$callback);
                } else if (__t === "title") {
                    return $235.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (this.elem === "layout-unit") {
                    return $240.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "item") {
                    if (!!this.ctx._wrap === false) {
                        return $246.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (!!this.elem === false) {
                    return $253.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-spin") {
            var __t = this._mode;
            if (__t === "content") {
                if (!!this.elem === false) {
                    return $409.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!!this.elem === false) {
                    return $414.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $419.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-tumb-lib") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "glow") {
                    return $427.call(this, __$callback);
                } else if (__t === "content") {
                    if (!(this.elemMods && this.elemMods.type) === false) {
                        if (!this.elem === false) {
                            return $431.call(this, __$callback);
                        } else {
                            return $435.call(this, __$callback);
                        }
                    } else {
                        return $435.call(this, __$callback);
                    }
                } else {
                    if (!!this.elem === false) {
                        return $438.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "content") {
                if (this.elem === "content") {
                    if (!(this.elemMods && this.elemMods.type) === false) {
                        if (!this.elem === false) {
                            return $445.call(this, __$callback);
                        } else {
                            return $449.call(this, __$callback);
                        }
                    } else {
                        return $449.call(this, __$callback);
                    }
                } else {
                    if (!!this.elem === false) {
                        return $452.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $457.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $462.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-form-input") {
            var __t = this._mode;
            if (__t === "default") {
                var __t = this.elem;
                if (__t === "hint") {
                    if (!!this.ctx._wrap === false) {
                        return $471.call(this, __$callback);
                    } else {
                        return $479.call(this, __$callback);
                    }
                } else if (__t === "input") {
                    if (!!this.ctx._wrap === false) {
                        return $476.call(this, __$callback);
                    } else {
                        return $479.call(this, __$callback);
                    }
                } else {
                    return $479.call(this, __$callback);
                }
            } else if (__t === "attrs") {
                var __t = this.elem;
                if (__t === "hint") {
                    return $489.call(this, __$callback);
                } else if (__t === "input") {
                    return $491.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "hint") {
                    return $496.call(this, __$callback);
                } else if (__t === "input") {
                    return $498.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $501.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $506.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-button-hide") {
            if (this._mode === "content") {
                if (!!this.elem === false) {
                    return $514.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-setting") {
            var __t = this._mode;
            if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $522.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $527.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-vb") {
            var __t = this._mode;
            if (__t === "content") {
                var __t = this.elem;
                if (__t === "head") {
                    return $199.call(this, __$callback);
                } else if (__t === "content") {
                    return $201.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $204.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "head") {
                    return $209.call(this, __$callback);
                } else if (__t === "content") {
                    return $211.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $214.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $219.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-copyright") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "text") {
                    return $535.call(this, __$callback);
                } else if (__t === "link") {
                    return $537.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (this.elem === "link") {
                    return $542.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $545.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (this.elem === "link") {
                    return $550.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-head-logo") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "text") {
                    return $156.call(this, __$callback);
                } else if (__t === "img") {
                    return $158.call(this, __$callback);
                } else if (__t === "link") {
                    return $160.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "attrs-src") {
                if (this.elem === "img") {
                    if (!~[ "en", "tr" ].indexOf(this["i-global"].lang) === false) {
                        return $166.call(this, __$callback);
                    } else {
                        return $168.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "attrs-alt") {
                if (this.elem === "img") {
                    return $173.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "attrs") {
                var __t = this.elem;
                if (__t === "img") {
                    return $178.call(this, __$callback);
                } else if (__t === "link") {
                    return $180.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $183.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "content") {
                if (!!this.ctx.content === false) {
                    if (!!this.elem === false) {
                        return $189.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-foot") {
            var __t = this._mode;
            if (__t === "attrs") {
                if (this.elem === "link") {
                    return $558.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $561.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "link") {
                    return $566.call(this, __$callback);
                } else if (__t === "layout-column") {
                    return $568.call(this, __$callback);
                } else if (__t === "layout-gap-i") {
                    return $570.call(this, __$callback);
                } else if (__t === "layout-gap") {
                    return $572.call(this, __$callback);
                } else if (__t === "row") {
                    return $574.call(this, __$callback);
                } else if (__t === "layout") {
                    return $576.call(this, __$callback);
                } else if (__t === "version") {
                    return $578.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                var __t = this.elem;
                if (__t === "layout-gap") {
                    return $583.call(this, __$callback);
                } else if (__t === "layout") {
                    return $585.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "links") {
                    return $590.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-head-search") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "arr-i") {
                    return $136.call(this, __$callback);
                } else if (__t === "arr") {
                    return $138.call(this, __$callback);
                } else if (__t === "extra") {
                    return $140.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (this.elem === "arr") {
                    return $145.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $148.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-menu") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "item") {
                    if (!this.mods === false) {
                        if (this.mods.layout === "horiz-simple") {
                            if (!this.elemMods === false) {
                                if (this.elemMods.state === "current") {
                                    return $602.call(this, __$callback);
                                } else {
                                    return $619.call(this, __$callback);
                                }
                            } else {
                                return $619.call(this, __$callback);
                            }
                        } else {
                            return $619.call(this, __$callback);
                        }
                    } else {
                        return $619.call(this, __$callback);
                    }
                } else if (__t === "title") {
                    if (!this.mods === false) {
                        if (this.mods.layout === "horiz-simple") {
                            return $614.call(this, __$callback);
                        } else {
                            return $618.call(this, __$callback);
                        }
                    } else {
                        return $618.call(this, __$callback);
                    }
                } else {
                    return $619.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (!this.mods === false) {
                    if (this.mods.layout === "horiz-simple") {
                        if (this.elem === "item") {
                            return $628.call(this, __$callback);
                        } else {
                            if (!!this.elem === false) {
                                return $631.call(this, __$callback);
                            } else {
                                return $658.call(this, __$callback);
                            }
                        }
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "link") {
                    if (!this._inFooter === false) {
                        return $641.call(this, __$callback);
                    } else {
                        return $658.call(this, __$callback);
                    }
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "b-layout-table") {
            var __t = this._mode;
            if (__t === "attrs") {
                if (!(this.elem === "cell" || this.elem === "gap") === false) {
                    return $117.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!(this.elem === "cell" || this.elem === "gap") === false) {
                    return $122.call(this, __$callback);
                } else {
                    if (this.elem === "row") {
                        return $125.call(this, __$callback);
                    } else {
                        if (!!this.elem === false) {
                            return $128.call(this, __$callback);
                        } else {
                            return $658.call(this, __$callback);
                        }
                    }
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else if (__t === "i-services") {
            var __t = this.elem;
            if (__t === "url") {
                return $650.call(this, __$callback);
            } else if (__t === "name") {
                return $652.call(this, __$callback);
            } else {
                if (!this.elem === false) {
                    return $655.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            }
        } else if (__t === "b-popupa") {
            if (this._mode === "tag") {
                if (this.elem === "tail") {
                    return $401.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        } else {
            return $658.call(this, __$callback);
        }
    }
    function $25(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $27(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $29(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $31(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $33(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $35(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "tr");
    }
    function $37(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "table");
    }
    function $40(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "form");
    }
    function $43(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "input");
    }
    function $45(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "input");
    }
    function $48(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "form");
    }
    function $53(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i-bem");
    }
    function $58(__$callback) {
        var __$i19;
        "enable spoon";
        if (this.ctx.name) {
            __$i19 = {
                "for": this.ctx.name
            };
        } else {
            __$i19 = true;
        }
        return __$callback.call(this, null, __$i19);
    }
    function $64(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            elem: "intro",
            content: [ BEM.I18N("b-search", "for-example"), "," ]
        }, "&#160;", {
            block: "b-link",
            mods: {
                pseudo: "yes"
            },
            content: this.ctx.text
        } ]);
    }
    function $67(__$callback) {
        if (!!this.ctx.content === false) {
            if (!!this.elem === false) {
                return $70.call(this, __$callback);
            } else {
                return $73.call(this, __$callback);
            }
        } else {
            return $73.call(this, __$callback);
        }
    }
    function $70(__$callback) {
        var __$i239;
        var __$i218;
        var __$i204;
        var __$i162;
        var __$i144;
        var __$i54;
        var __$i55;
        var __$i56;
        var __$i100;
        var __$i31;
        var __$r28;
        function __$fn28(__$e, __$r) {
            var __$r30;
            function __$fn30(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r30 = __$r;
                }
                __r153 = __$r30;
                this._mode = __r151;
                this.ctx = __r152;
                "";
                item = __r153;
                __$i204 = item;
                if (__$i204) {
                    __$i218 = row.content.push({
                        elem: "row",
                        content: item
                    });
                } else {
                    __$i218 = __$i204;
                }
                if (this.ctx.hidden) {
                    __$i239 = row = [ row, this.ctx.hidden ];
                } else {
                    __$i239 = "";
                }
                return __$callback.call(this, null, row);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r28 = __$r;
            }
            while (true) {
                if (!(i < len)) {
                    break;
                } else {
                    item = input[i++];
                    __$i54 = [].push;
                    __$i55 = "apply";
                    __$i56 = row;
                    "";
                    __r144 = this._mode;
                    this._mode = "lego-label";
                    __r145 = this.ctx;
                    this.ctx = item;
                    __r146 = this.position;
                    this.position = i;
                    return apply.call(__this, __$fn27);
                }
            }
            undefined;
            __$i144 = this.ctx.button;
            if (__$i144) {
                __$i162 = row.push({
                    elem: "button",
                    content: this.ctx.button.content
                });
            } else {
                __$i162 = __$i144;
            }
            row = {
                elem: "table",
                content: [ {
                    elem: "row",
                    content: row
                } ]
            };
            "";
            __r151 = this._mode;
            this._mode = "lego-under";
            __r152 = this.ctx;
            this.ctx = input;
            return apply.call(__this, __$fn30);
        }
        var __$r27;
        function __$fn27(__$e, __$r) {
            var __$r29;
            function __$fn29(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r29 = __$r;
                }
                __r150 = __$r29;
                this._mode = __r148;
                this.ctx = __r149;
                "";
                __$i54[__$i55](__$i56, [ __$i100, __r150 ]);
                return __$fn28.call(this);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r27 = __$r;
            }
            __r147 = __$r27;
            this._mode = __r144;
            this.ctx = __r145;
            this.position = __r146;
            "";
            __$i100 = __r147;
            "";
            __r148 = this._mode;
            this._mode = "lego-input";
            __r149 = this.ctx;
            this.ctx = item;
            return apply.call(__this, __$fn29);
        }
        var input, len, row, i, item;
        var __r144, __r145, __r146, __r147, __r148, __r149, __r150, __r151, __r152, __r153;
        var __this;
        __this = this;
        "enable spoon";
        input = this.ctx.input;
        if (this._.isArray(input)) {
            __$i31 = input.length;
        } else {
            input = [ input ];
            __$i31 = 1;
        }
        len = __$i31;
        row = [];
        i = 0;
        return __$fn28.call(this);
    }
    function $73(__$callback) {
        if (!!this.elem === false) {
            return $75.call(this, __$callback);
        } else {
            if (!this.ctx.button === false) {
                if (!this.ctx.input === false) {
                    return $79.call(this, __$callback);
                } else {
                    return $658.call(this, __$callback);
                }
            } else {
                return $658.call(this, __$callback);
            }
        }
    }
    function $75(__$callback) {
        var __$i25;
        var __$i8;
        "enable spoon";
        __$i8 = {
            elem: "table",
            content: this.ctx.content
        };
        if (this.ctx.hidden) {
            __$i25 = this.ctx.hidden;
        } else {
            __$i25 = "";
        }
        return __$callback.call(this, null, [ __$i8, __$i25 ]);
    }
    function $79(__$callback) {
        var __$i82;
        var __$i56;
        var c;
        "enable spoon";
        this.ctx.input.block = "b-search";
        this.ctx.button.block = "b-search";
        c = {
            block: "b-layout-table",
            mix: [ {
                block: "b-search",
                elem: "layout"
            } ],
            content: [ {
                elem: "row",
                content: [ {
                    elem: "cell",
                    mix: [ {
                        block: "b-search",
                        elem: "layout-input"
                    } ],
                    content: this.ctx.input
                }, {
                    elem: "cell",
                    mix: [ {
                        block: "b-search",
                        elem: "layout-button"
                    } ],
                    content: this.ctx.button
                } ]
            } ]
        };
        __$i56 = this.ctx.under;
        if (__$i56) {
            __$i82 = c.content.push({
                elem: "row",
                content: [ {
                    elem: "cell",
                    mix: [ {
                        block: "b-search",
                        elem: "layout-under"
                    } ],
                    colspan: 2,
                    content: this.ctx.under
                } ]
            });
        } else {
            __$i82 = __$i56;
        }
        return __$callback.call(this, null, c);
    }
    function $86(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $88(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $90(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            colspan: 2
        });
    }
    function $93(__$callback) {
        var __$i13;
        var __$i6;
        "enable spoon";
        __$i6 = this.ctx.action;
        if (__$i6) {
            __$i13 = __$i6;
        } else {
            __$i13 = "/";
        }
        return __$callback.call(this, null, {
            action: __$i13
        });
    }
    function $96(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            type: "submit",
            value: "Search"
        });
    }
    function $98(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            name: "text"
        });
    }
    function $103(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $107(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "input",
            content: this.ctx.content
        });
    }
    function $109(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $111(__$callback) {
        var __$i93;
        var __$i81;
        var __$i77;
        var __$i65;
        var __$i61;
        var __$i49;
        var __$i45;
        var __$i33;
        var inputs, len, i, c, input, under;
        "enable spoon";
        inputs = this.ctx;
        len = inputs.length;
        i = 0;
        c = [];
        while (true) {
            if (!(i < len)) {
                break;
            } else {
                input = inputs[i++];
                under = [];
                __$i33 = input.advanced;
                if (__$i33) {
                    __$i45 = under.push(input.advanced);
                } else {
                    __$i45 = __$i33;
                }
                __$i49 = input.precise;
                if (__$i49) {
                    __$i61 = under.push(input.precise);
                } else {
                    __$i61 = __$i49;
                }
                __$i65 = input.sample;
                if (__$i65) {
                    __$i77 = under.push(input.sample);
                } else {
                    __$i77 = __$i65;
                }
                __$i81 = under.length;
                if (__$i81) {
                    __$i93 = c.push({
                        elem: "under",
                        content: under
                    });
                } else {
                    __$i93 = __$i81;
                }
            }
        }
        undefined;
        return __$callback.call(this, null, c);
    }
    function $117(__$callback) {
        var __$i37;
        var __$i25;
        var ctx, a, props, p;
        "enable spoon";
        ctx = this.ctx;
        a = {};
        props = [ "colspan", "rowspan" ];
        while (true) {
            if (!(p = props.shift())) {
                break;
            } else {
                __$i25 = ctx[p];
                if (__$i25) {
                    __$i37 = a[p] = ctx[p];
                } else {
                    __$i37 = __$i25;
                }
            }
        }
        undefined;
        return __$callback.call(this, null, a);
    }
    function $122(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $125(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "tr");
    }
    function $128(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "table");
    }
    function $136(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $138(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $140(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $145(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "arr-i"
        });
    }
    function $148(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "wrap",
            mix: [ {
                elem: "arrow"
            } ],
            content: [ {
                elem: "arr"
            }, this.ctx.content ]
        });
    }
    function $156(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "strong");
    }
    function $158(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "img");
    }
    function $160(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "a");
    }
    function $166(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//yandex.st/lego/_/w3fZdbIEslxR_9CQRR-ezRNUZ_Q.png");
    }
    function $168(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//yandex.st/lego/_/X31pO5JJJKEifJ7sfvuf3mGeD_8.png");
    }
    function $173(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, BEM.I18N("b-head-logo", "yandex"));
    }
    function $178(__$callback) {
        var __$i77;
        var __$i47;
        var __$i48;
        var __$i51;
        var __$i44;
        var __$i14;
        var __$i15;
        var __$i18;
        var __$r11;
        function __$fn11(__$e, __$r) {
            var __$r13;
            function __$fn13(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r13 = __$r;
                }
                __$i47[__$i48] = __$i77;
                return __$callback.call(this, null, a);
            }
            var __$r12;
            function __$fn12(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r12 = __$r;
                }
                __r143 = __$r12;
                this._mode = __r142;
                "";
                __$i77 = __r143;
                return __$fn13.call(this);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r11 = __$r;
            }
            __$i14[__$i15] = __$i44;
            __$i47 = a;
            __$i48 = "alt";
            __$i51 = ctx.alt;
            if (__$i51) {
                __$i77 = __$i51;
                return __$fn13.call(this);
            } else {
                "";
                __r142 = this._mode;
                this._mode = "attrs-alt";
                return apply.call(__this, __$fn12);
            }
        }
        var __$r10;
        function __$fn10(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r10 = __$r;
            }
            __r141 = __$r10;
            this._mode = __r140;
            "";
            __$i44 = __r141;
            return __$fn11.call(this);
        }
        var a, ctx;
        var __r140, __r141, __r142, __r143;
        var __this;
        __this = this;
        "enable spoon";
        a = {
            style: "border: 0"
        };
        ctx = this.ctx;
        __$i14 = a;
        __$i15 = "src";
        __$i18 = ctx.url;
        if (__$i18) {
            __$i44 = __$i18;
            return __$fn11.call(this);
        } else {
            "";
            __r140 = this._mode;
            this._mode = "attrs-src";
            return apply.call(__this, __$fn10);
        }
    }
    function $180(__$callback) {
        var __$i18;
        var __$i6;
        "enable spoon";
        __$i6 = this.ctx.url;
        if (__$i6) {
            __$i18 = __$i6;
        } else {
            __$i18 = this["i-services"].serviceUrl("www");
        }
        return __$callback.call(this, null, {
            href: __$i18
        });
    }
    function $183(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            role: "header"
        });
    }
    function $189(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "logo",
            content: {
                elem: "link",
                content: {
                    elem: "img"
                }
            }
        });
    }
    function $199(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "td",
            tag: "td",
            content: this.ctx.content
        });
    }
    function $201(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "td",
            tag: "td",
            content: this.ctx.content
        });
    }
    function $204(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, this.ctx.content);
    }
    function $209(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "tr");
    }
    function $211(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "tr");
    }
    function $214(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "table");
    }
    function $219(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            cellpadding: 0,
            cellspacing: 0
        });
    }
    function $227(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ul");
    }
    function $229(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $231(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "li");
    }
    function $233(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ul");
    }
    function $235(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "h3");
    }
    function $240(__$callback) {
        var __$i35;
        var __$i23;
        var __$i19;
        var __$i7;
        var mix;
        "enable spoon";
        mix = [];
        __$i7 = this.isFirst();
        if (__$i7) {
            __$i19 = mix.push({
                elemMods: {
                    position: "first"
                }
            });
        } else {
            __$i19 = __$i7;
        }
        __$i23 = this.isLast();
        if (__$i23) {
            __$i35 = mix.push({
                elemMods: {
                    position: "last"
                }
            });
        } else {
            __$i35 = __$i23;
        }
        return __$callback.call(this, null, mix);
    }
    function $246(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r135;
            __r136._wrap = __r137;
            this.position = __r138;
            this.ctx = __r139;
            "";
            return __$callback.call(this, null);
        }
        var __r139;
        var __r138;
        var __r136, __r137;
        var __r135;
        "enable spoon";
        "";
        __r135 = this._mode;
        this._mode = "";
        __r136 = this.ctx;
        __r137 = __r136._wrap;
        __r136._wrap = true;
        __r138 = this.position;
        this.position = this.position - 1;
        __r139 = this.ctx;
        this.ctx = {
            elem: "layout-unit",
            content: [ this.ctx, this.ctx["item-content"] ]
        };
        return this.apply(__$fn2);
    }
    function $253(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.title, {
            elem: "layout",
            content: this.ctx.content
        } ]);
    }
    function $264(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r133;
            this.ctx = __r134;
            "";
            undefined;
            undefined;
            undefined;
            return __$callback.call(this, null);
        }
        var __r134;
        var __r133;
        var __this;
        __this = this;
        "enable spoon";
        "";
        __r133 = this._mode;
        this._mode = "";
        __r134 = this.ctx;
        this.ctx = {
            elem: "inner",
            content: this.ctx.content,
            _wrap: true
        };
        return apply.call(__this, __$fn2);
    }
    function $277(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {});
    }
    function $287(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $295(__$callback) {
        var __$i14;
        "enable spoon";
        if (this.ctx.url) {
            __$i14 = "a";
        } else {
            __$i14 = "span";
        }
        return __$callback.call(this, null, __$i14);
    }
    function $298(__$callback) {
        if (this.elem === "inner") {
            return $300.call(this, __$callback);
        } else {
            return $658.call(this, __$callback);
        }
    }
    function $300(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $310(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "li");
    }
    function $318(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ul");
    }
    function $324(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "h3");
    }
    function $327(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $336(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.title, {
            elem: "layout",
            content: this.ctx.content
        } ]);
    }
    function $346(__$callback) {
        var __$i35;
        var __$i23;
        var __$i19;
        var __$i7;
        var mix;
        "enable spoon";
        mix = [];
        __$i7 = this.isFirst();
        if (__$i7) {
            __$i19 = mix.push({
                elemMods: {
                    position: "first"
                }
            });
        } else {
            __$i19 = __$i7;
        }
        __$i23 = this.isLast();
        if (__$i23) {
            __$i35 = mix.push({
                elemMods: {
                    position: "last"
                }
            });
        } else {
            __$i35 = __$i23;
        }
        return __$callback.call(this, null, mix);
    }
    function $355(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r128;
            __r129._wrap = __r130;
            this.position = __r131;
            this.ctx = __r132;
            "";
            return __$callback.call(this, null);
        }
        var __r132;
        var __r131;
        var __r129, __r130;
        var __r128;
        "enable spoon";
        "";
        __r128 = this._mode;
        this._mode = "";
        __r129 = this.ctx;
        __r130 = __r129._wrap;
        __r129._wrap = true;
        __r131 = this.position;
        this.position = this.position - 1;
        __r132 = this.ctx;
        this.ctx = {
            elem: "layout-unit",
            content: this.ctx
        };
        return this.apply(__$fn2);
    }
    function $366(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $378(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $383(__$callback) {
        var __$i52;
        var __$i39;
        var __$i40;
        var __$i45;
        var __$r6;
        function __$fn6(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r6 = __$r;
            }
            this._mode = __r123;
            __r124._init = __r125;
            this._inBDropdowna = __r126;
            this._dropdownaColor = __r127;
            "";
            return __$callback.call(this, null);
        }
        var __r127;
        var __r126;
        var __r124, __r125;
        var __r123;
        "enable spoon";
        "";
        __r123 = this._mode;
        this._mode = "";
        __r124 = this.ctx;
        __r125 = __r124._init;
        __r124._init = true;
        __r126 = this._inBDropdowna;
        this._inBDropdowna = true;
        __r127 = this._dropdownaColor;
        __$i39 = this;
        __$i40 = "_dropdownaColor";
        __$i45 = this.mods.color;
        if (__$i45) {
            __$i52 = __$i45;
        } else {
            __$i52 = false;
        }
        __$i39[__$i40] = __$i52;
        return this.apply(__$fn6);
    }
    function $388(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            mods: {
                "is-bem": "yes"
            }
        } ]);
    }
    function $393(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $401(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $409(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            block: "b-icon",
            mix: [ {
                block: "b-spin",
                elem: "icon"
            } ]
        });
    }
    function $414(__$callback) {
        var __$i45;
        var __$i35;
        var __$i22;
        var __$i12;
        var m, mods;
        "enable spoon";
        m = {};
        mods = this.ctx.mods;
        __$i12 = !mods;
        if (__$i12) {
            __$i22 = __$i12;
        } else {
            __$i22 = !mods.size;
        }
        if (__$i22) {
            m.size = "27";
        } else {
            undefined;
        }
        undefined;
        __$i35 = !mods;
        if (__$i35) {
            __$i45 = __$i35;
        } else {
            __$i45 = !mods.theme;
        }
        if (__$i45) {
            m.theme = "grey-27";
        } else {
            undefined;
        }
        undefined;
        return __$callback.call(this, null, [ {
            mods: m
        } ]);
    }
    function $419(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $427(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $431(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $435(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $438(__$callback) {
        var __$i14;
        "enable spoon";
        if (this.ctx.url) {
            __$i14 = "a";
        } else {
            __$i14 = "div";
        }
        return __$callback.call(this, null, __$i14);
    }
    function $445(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            elem: "text",
            tag: "span",
            content: this.ctx.content
        }, {
            elem: "helper",
            tag: "span"
        } ]);
    }
    function $449(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.content, {
            elem: "helper",
            tag: "span"
        } ]);
    }
    function $452(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.content, {
            elem: "click",
            tag: "i"
        } ]);
    }
    function $457(__$callback) {
        var __$i57;
        var __$i45;
        var ctx, a, props, p;
        "enable spoon";
        ctx = this.ctx;
        a = {
            style: "background-color: " + ctx.bg
        };
        props = [ "title", "target" ];
        if (ctx.url) {
            a.href = ctx.url;
        } else {
            undefined;
        }
        undefined;
        while (true) {
            if (!(p = props.pop())) {
                break;
            } else {
                __$i45 = ctx[p];
                if (__$i45) {
                    __$i57 = a[p] = ctx[p];
                } else {
                    __$i57 = __$i45;
                }
            }
        }
        undefined;
        return __$callback.call(this, null, a);
    }
    function $462(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $471(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r119;
            __r120._wrap = __r121;
            this.ctx = __r122;
            "";
            return __$callback.call(this, null);
        }
        var __r122;
        var __r120, __r121;
        var __r119;
        "enable spoon";
        "";
        __r119 = this._mode;
        this._mode = "";
        __r120 = this.ctx;
        __r121 = __r120._wrap;
        __r120._wrap = true;
        __r122 = this.ctx;
        this.ctx = {
            elem: "hint-wrap",
            tag: "span",
            content: this.ctx
        };
        return this.apply(__$fn2);
    }
    function $476(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r115;
            __r116._wrap = __r117;
            this.ctx = __r118;
            "";
            return __$callback.call(this, null);
        }
        var __r118;
        var __r116, __r117;
        var __r115;
        "enable spoon";
        "";
        __r115 = this._mode;
        this._mode = "";
        __r116 = this.ctx;
        __r117 = __r116._wrap;
        __r116._wrap = true;
        __r118 = this.ctx;
        this.ctx = {
            elem: "box",
            tag: "span",
            content: [ this.ctx, this.ctx.clear ]
        };
        return this.apply(__$fn2);
    }
    function $479(__$callback) {
        if (!!this._inputId === false) {
            if (!!this.elem === false) {
                return $482.call(this, __$callback);
            } else {
                return $658.call(this, __$callback);
            }
        } else {
            return $658.call(this, __$callback);
        }
    }
    function $482(__$callback) {
        var __$i65;
        var __$i52;
        var __$i53;
        var __$i58;
        var __$i44;
        var __$i31;
        var __$i32;
        var __$i37;
        var __$i23;
        var __$i8;
        var __$i9;
        var __$i14;
        var __$r14;
        function __$fn14(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r14 = __$r;
            }
            this._inputId = __r112;
            this._name = __r113;
            this._value = __r114;
            "";
            return __$callback.call(this, null);
        }
        var __r114;
        var __r113;
        var __r112;
        "enable spoon";
        "";
        __r112 = this._inputId;
        __$i8 = this;
        __$i9 = "_inputId";
        __$i14 = this.ctx.id;
        if (__$i14) {
            __$i23 = __$i14;
        } else {
            __$i23 = this.generateId();
        }
        __$i8[__$i9] = __$i23;
        __r113 = this._name;
        __$i31 = this;
        __$i32 = "_name";
        __$i37 = this.ctx.name;
        if (__$i37) {
            __$i44 = __$i37;
        } else {
            __$i44 = "";
        }
        __$i31[__$i32] = __$i44;
        __r114 = this._value;
        __$i52 = this;
        __$i53 = "_value";
        __$i58 = this.ctx.value;
        if (__$i58) {
            __$i65 = __$i58;
        } else {
            __$i65 = "";
        }
        __$i52[__$i53] = __$i65;
        return this.apply(__$fn14);
    }
    function $489(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            "for": this._inputId
        });
    }
    function $491(__$callback) {
        var __$i41;
        var __$i31;
        var __$i25;
        var __$i13;
        var a;
        "enable spoon";
        a = {
            id: this._inputId,
            name: this._name
        };
        __$i13 = this._value;
        if (__$i13) {
            __$i25 = a.value = this._value;
        } else {
            __$i25 = __$i13;
        }
        __$i31 = this.mods.disabled;
        if (__$i31) {
            __$i41 = a.disabled = "disabled";
        } else {
            __$i41 = __$i31;
        }
        return __$callback.call(this, null, a);
    }
    function $496(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "label");
    }
    function $498(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "input");
    }
    function $501(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $506(__$callback) {
        var __$i18;
        "enable spoon";
        if (this.mods.popup == "gradient") {
            __$i18 = {
                popupMods: {
                    gradient: "yes"
                }
            };
        } else {
            __$i18 = true;
        }
        return __$callback.call(this, null, __$i18);
    }
    function $514(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ "<span>", {
            elem: "input",
            tag: "input",
            attrs: {
                type: "submit",
                value: " "
            }
        }, "</span>" ]);
    }
    function $522(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            action: "",
            method: "post"
        });
    }
    function $527(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "form");
    }
    function $535(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "");
    }
    function $537(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "a");
    }
    function $542(__$callback) {
        var __$i17;
        var __$i6;
        "enable spoon";
        __$i6 = this.ctx.content;
        if (__$i6) {
            __$i17 = __$i6;
        } else {
            __$i17 = BEM.I18N("b-copyright", "yandex");
        }
        return __$callback.call(this, null, __$i17);
    }
    function $545(__$callback) {
        var __$i73;
        var __$i47;
        var __$i43;
        var __$i33;
        var __$i24;
        var currentYear, startYear, content;
        "enable spoon";
        currentYear = (new Date).getFullYear();
        if (this.ctx.start) {
            __$i24 = this.ctx.start;
        } else {
            __$i24 = currentYear;
        }
        startYear = __$i24;
        content = "©&#160;" + startYear;
        __$i33 = currentYear === startYear;
        if (__$i33) {
            __$i43 = __$i33;
        } else {
            __$i43 = content += "&#8211;" + currentYear;
        }
        content += "&#160;&#160;";
        __$i47 = content;
        if (this.ctx.content) {
            __$i73 = this.ctx.content;
        } else {
            __$i73 = {
                block: "i-bem",
                elem: "i18n",
                keyset: "b-copyright",
                key: "link",
                content: {
                    block: this.block,
                    elem: "link"
                }
            };
        }
        return __$callback.call(this, null, [ __$i47, __$i73 ]);
    }
    function $550(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            href: this["i-services"].serviceUrl("www")
        });
    }
    function $558(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            href: this.ctx.url
        });
    }
    function $561(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            role: "contentinfo"
        });
    }
    function $566(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "a");
    }
    function $568(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $570(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $572(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $574(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "tr");
    }
    function $576(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "table");
    }
    function $578(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $583(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "layout-gap-i"
        });
    }
    function $585(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            bem: false,
            elem: "row",
            content: [ {
                elem: "layout-gap",
                content: {
                    elem: "layout-gap-i"
                }
            }, this.ctx.content, {
                elem: "layout-gap",
                content: {
                    elem: "layout-gap-i"
                }
            } ]
        });
    }
    function $590(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r93;
            __r94.block = __r95;
            __r96.mods = __r97;
            __r98.elem = __r99;
            this._inFooter = __r100;
            "";
            return __$callback.call(this, null);
        }
        var __r100;
        var __r98, __r99;
        var __r96, __r97;
        var __r94, __r95;
        var __r93;
        "enable spoon";
        "";
        __r93 = this._mode;
        this._mode = "";
        __r94 = this.ctx;
        __r95 = __r94.block;
        __r94.block = "b-menu";
        __r96 = this.ctx;
        __r97 = __r96.mods;
        __r96.mods = {
            layout: "horiz-simple"
        };
        __r98 = this.ctx;
        __r99 = __r98.elem;
        __r98.elem = undefined;
        __r100 = this._inFooter;
        this._inFooter = true;
        return this.apply(__$fn2);
    }
    function $602(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $614(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "h2");
    }
    function $618(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "h2");
    }
    function $619(__$callback) {
        if (!!this.elem === false) {
            return $621.call(this, __$callback);
        } else {
            return $658.call(this, __$callback);
        }
    }
    function $621(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "div");
    }
    function $628(__$callback) {
        "enable spoon";
        if (this.isLast()) {
            return __$callback.call(this, null, this.ctx.content);
        } else {
            return __$callback.call(this, null, [ this.ctx.content, "&nbsp;· " ]);
        }
    }
    function $631(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.title, this.ctx.content ]);
    }
    function $641(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r105;
            __r106.block = __r107;
            __r108.elem = __r109;
            __r110.mix = __r111;
            "";
            return __$callback.call(this, null);
        }
        var __r110, __r111;
        var __r108, __r109;
        var __r106, __r107;
        var __r105;
        "enable spoon";
        "";
        __r105 = this._mode;
        this._mode = "";
        __r106 = this.ctx;
        __r107 = __r106.block;
        __r106.block = "b-link";
        __r108 = this.ctx;
        __r109 = __r108.elem;
        __r108.elem = undefined;
        __r110 = this.ctx;
        __r111 = __r110.mix;
        __r110.mix = [ {
            block: "b-foot",
            elem: "link"
        } ];
        return this.apply(__$fn2);
    }
    function $650(__$callback) {
        "enable spoon";
        this._buf.push(this["i-services"].serviceUrl(this.ctx.id, this.ctx.region));
        return __$callback.call(this, null);
    }
    function $652(__$callback) {
        "enable spoon";
        this._buf.push(this["i-services"].serviceName(this.ctx.id));
        return __$callback.call(this, null);
    }
    function $655(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "");
    }
    function $658(__$callback) {
        if (!this._start === false) {
            if (!this["i-global"] === false) {
                if (!!this["i-services"] === false) {
                    return $662.call(this, __$callback);
                } else {
                    return $667.call(this, __$callback);
                }
            } else {
                return $667.call(this, __$callback);
            }
        } else {
            return $667.call(this, __$callback);
        }
    }
    function $662(__$callback) {
        var __$i16;
        var __$i17;
        var __$r16;
        function __$fn16(__$e, __$r) {
            var __$r17;
            function __$fn17(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r17 = __$r;
                }
                return __$callback.call(this, null);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r16 = __$r;
            }
            __r92 = __$r16;
            this.block = __r90;
            this._mode = __r91;
            "";
            __$i16[__$i17] = __r92;
            _ctx.serviceName = function(id) {
                var __$i75;
                var __$i63;
                var __$i64;
                var __$i65;
                var __$i66;
                __$i63 = BEM;
                __$i64 = "I18N";
                __$i65 = "i-services";
                __$i66 = id;
                if (__$i66) {
                    __$i75 = __$i66;
                } else {
                    __$i75 = params.id;
                }
                return __$i63[__$i64](__$i65, __$i75);
            };
            _ctx.serviceUrl = function(id, region) {
                var __$i104;
                var __$i93;
                var __$i94;
                var __$i95;
                var __$i89;
                var __$i79;
                __$i79 = id;
                if (__$i79) {
                    __$i89 = __$i79;
                } else {
                    __$i89 = id = params.id;
                }
                __$i93 = _ctx._data;
                __$i94 = id;
                __$i95 = region;
                if (__$i95) {
                    __$i104 = __$i95;
                } else {
                    __$i104 = params["content-region"];
                }
                return __$i93[__$i94](__$i104);
            };
            return this.apply(__$fn17);
        }
        var _ctx, params;
        var __r90, __r91, __r92;
        var __this;
        __this = this;
        "enable spoon";
        _ctx = this["i-services"] = {};
        params = this["i-global"];
        __$i16 = _ctx;
        __$i17 = "_data";
        "";
        __r90 = this.block;
        this.block = "i-services";
        __r91 = this._mode;
        this._mode = "service-url";
        return apply.call(__this, __$fn16);
    }
    function $667(__$callback) {
        var __t = this.block;
        if (__t === "i-services") {
            if (this._mode === "service-url") {
                return $670.call(this, __$callback);
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-page-title") {
            if (this._mode === "tag") {
                if (!!this.elem === false) {
                    return $755.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-form-checkbox") {
            var __t = this._mode;
            if (__t === "attrs") {
                var __t = this.elem;
                if (__t === "tick") {
                    return $763.call(this, __$callback);
                } else if (__t === "checkbox") {
                    return $765.call(this, __$callback);
                } else if (__t === "label") {
                    return $767.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "tick") {
                    return $772.call(this, __$callback);
                } else if (__t === "bg") {
                    return $774.call(this, __$callback);
                } else if (__t === "checkbox") {
                    return $776.call(this, __$callback);
                } else if (__t === "label") {
                    return $778.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $781.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "content") {
                if (this.elem === "bg") {
                    return $786.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $789.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "mix") {
                if (!!this.elem === false) {
                    return $794.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $799.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (!!this._checkboxAttrs === false) {
                    return $804.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-form-button") {
            var __t = this._mode;
            if (__t === "content") {
                var __t = this.elem;
                if (__t === "content") {
                    if (!this._formSelect === false) {
                        return $813.call(this, __$callback);
                    } else {
                        return $818.call(this, __$callback);
                    }
                } else if (__t === "text") {
                    return $817.call(this, __$callback);
                } else {
                    return $818.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!this._formSelect === false) {
                    if (!!this.elem === false) {
                        return $826.call(this, __$callback);
                    } else {
                        return $829.call(this, __$callback);
                    }
                } else {
                    return $829.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (!this._formSelect === false) {
                    if (!!this.ctx._theme === false) {
                        if (!!this.elem === false) {
                            return $838.call(this, __$callback);
                        } else {
                            return $843.call(this, __$callback);
                        }
                    } else {
                        return $843.call(this, __$callback);
                    }
                } else {
                    return $843.call(this, __$callback);
                }
            } else if (__t === "attrs") {
                if (this.elem === "input") {
                    return $850.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $853.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "input") {
                    return $858.call(this, __$callback);
                } else if (__t === "click") {
                    if (!this.ctx.url === false) {
                        return $861.call(this, __$callback);
                    } else {
                        return $863.call(this, __$callback);
                    }
                } else if (__t === "text") {
                    return $865.call(this, __$callback);
                } else if (__t === "left") {
                    return $867.call(this, __$callback);
                } else {
                    if (!this.ctx === false) {
                        if (!this.ctx.url === false) {
                            return $871.call(this, __$callback);
                        } else {
                            return $874.call(this, __$callback);
                        }
                    } else {
                        return $874.call(this, __$callback);
                    }
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $881.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-icon") {
            var __t = this._mode;
            if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $742.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $747.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-debug") {
            if (this._mode === "tag") {
                if (!!this.elem === false) {
                    return $940.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-link") {
            var __t = this._mode;
            if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $948.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $953.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-vb-droptop") {
            var __t = this._mode;
            if (__t === "content") {
                if (!!this.elem === false) {
                    return $961.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $966.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $971.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-popupa") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "wrap-cell") {
                    return $979.call(this, __$callback);
                } else if (__t === "wrap") {
                    return $981.call(this, __$callback);
                } else if (__t === "shadow") {
                    return $983.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "content") {
                if (this.elem === "wrap") {
                    return $988.call(this, __$callback);
                } else {
                    if (!this.mods === false) {
                        if (this.mods["has-close"] === "yes") {
                            if (!!this.elem === false) {
                                return $993.call(this, __$callback);
                            } else {
                                return $1138.call(this, __$callback);
                            }
                        } else {
                            return $1138.call(this, __$callback);
                        }
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (this.elem === "wrap") {
                    return $1002.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "content") {
                    if (!!this.ctx._wrap === false) {
                        return $1008.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!!this.ctx._mix === false) {
                    if (!!this.elem === false) {
                        return $1016.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $1023.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-background") {
            if (this._mode === "tag") {
                if (!this.mods === false) {
                    if (this.mods.ff === "yes") {
                        if (!!this.elem === false) {
                            return $1033.call(this, __$callback);
                        } else {
                            return $1138.call(this, __$callback);
                        }
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-form-attach") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "text") {
                    return $727.call(this, __$callback);
                } else if (__t === "holder") {
                    return $729.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $734.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-page") {
            var __t = this._mode;
            if (__t === "attrs") {
                var __t = this.elem;
                if (__t === "js") {
                    if (!this.ctx.url === false) {
                        return $1046.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else if (__t === "css") {
                    if (!this.ctx.url === false) {
                        return $1051.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else if (__t === "favicon") {
                    return $1055.call(this, __$callback);
                } else if (__t === "meta") {
                    return $1057.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "tag") {
                var __t = this.elem;
                if (__t === "js") {
                    return $1062.call(this, __$callback);
                } else if (__t === "css") {
                    if (!this.ctx.url === false) {
                        return $1065.call(this, __$callback);
                    } else {
                        return $1067.call(this, __$callback);
                    }
                } else if (__t === "favicon") {
                    return $1069.call(this, __$callback);
                } else if (__t === "meta") {
                    return $1071.call(this, __$callback);
                } else if (__t === "head") {
                    return $1073.call(this, __$callback);
                } else if (__t === "root") {
                    return $1075.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $1078.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "bem") {
                var __t = this.elem;
                if (__t === "js") {
                    return $1083.call(this, __$callback);
                } else if (__t === "css") {
                    return $1085.call(this, __$callback);
                } else if (__t === "favicon") {
                    return $1087.call(this, __$callback);
                } else if (__t === "meta") {
                    return $1089.call(this, __$callback);
                } else if (__t === "head") {
                    return $1091.call(this, __$callback);
                } else if (__t === "root") {
                    return $1093.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (this.elem === "css") {
                    if (!this.ctx.hasOwnProperty("ie") === false) {
                        if (!!this.ctx._ieCommented === false) {
                            return $1100.call(this, __$callback);
                        } else {
                            return $1105.call(this, __$callback);
                        }
                    } else {
                        return $1105.call(this, __$callback);
                    }
                } else {
                    return $1105.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!!this.ctx._iGlobal === false) {
                    return $1115.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $1118.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "cls") {
                if (this.elem === "root") {
                    return $1123.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "doctype") {
                return $1127.call(this, __$callback);
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-tumb") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "control-text") {
                    return $676.call(this, __$callback);
                } else if (__t === "glow") {
                    return $678.call(this, __$callback);
                } else if (__t === "desc") {
                    return $680.call(this, __$callback);
                } else if (__t === "content") {
                    if (!(this.elemMods && this.elemMods.type) === false) {
                        if (!this.elem === false) {
                            return $684.call(this, __$callback);
                        } else {
                            return $688.call(this, __$callback);
                        }
                    } else {
                        return $688.call(this, __$callback);
                    }
                } else if (__t === "control") {
                    return $690.call(this, __$callback);
                } else if (__t === "control-item") {
                    return $692.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $695.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "content") {
                if (this.elem === "content") {
                    if (!(this.elemMods && this.elemMods.type) === false) {
                        if (!this.elem === false) {
                            return $702.call(this, __$callback);
                        } else {
                            return $706.call(this, __$callback);
                        }
                    } else {
                        return $706.call(this, __$callback);
                    }
                } else {
                    if (!!this.elem === false) {
                        return $709.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (!!this.elem === false) {
                    return $714.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!!this.elem === false) {
                    return $719.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "i-bem") {
            if (this._mode === "default") {
                if (this.elem === "i18n") {
                    return $1133.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else if (__t === "b-form-select") {
            var __t = this._mode;
            if (__t === "tag") {
                var __t = this.elem;
                if (__t === "arrow") {
                    return $889.call(this, __$callback);
                } else if (__t === "text") {
                    return $891.call(this, __$callback);
                } else if (__t === "option-group") {
                    return $893.call(this, __$callback);
                } else if (__t === "option") {
                    return $895.call(this, __$callback);
                } else if (__t === "select") {
                    return $897.call(this, __$callback);
                } else {
                    if (!!this.elem === false) {
                        return $900.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                }
            } else if (__t === "attrs") {
                if (this.elem === "select") {
                    return $905.call(this, __$callback);
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "js") {
                if (!this.mods.theme === false) {
                    if (!!this.elem === false) {
                        return $911.call(this, __$callback);
                    } else {
                        return $914.call(this, __$callback);
                    }
                } else {
                    return $914.call(this, __$callback);
                }
            } else if (__t === "mix") {
                if (!!this.elem === false) {
                    if (!!this.mods.layout === false) {
                        return $922.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else {
                    return $1138.call(this, __$callback);
                }
            } else if (__t === "default") {
                if (!!this._inputAttrs === false) {
                    if (!!this.elem === false) {
                        return $930.call(this, __$callback);
                    } else {
                        return $1138.call(this, __$callback);
                    }
                } else {
                    return $1138.call(this, __$callback);
                }
            } else {
                return $1138.call(this, __$callback);
            }
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $670(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            mail: function(reg) {
                if (reg === "ru") {
                    return "http://mail.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://mail.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://mail.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://mail.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "com") {
                                    return "http://mail.yandex.com";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://mail.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://mail.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            pdd: function(reg) {
                if (reg === "ru") {
                    return "http://pdd.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://pdd.yandex.ru";
                }
            },
            zakladki: function(reg) {
                if (reg === "ru") {
                    return "http://zakladki.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://zakladki.yandex.ru";
                }
            },
            narod: function(reg) {
                if (reg === "ru") {
                    return "http://narod.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://narod.yandex.ru";
                }
            },
            fotki: function(reg) {
                if (reg === "ru") {
                    return "http://fotki.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://fotki.yandex.ru";
                }
            },
            cards: function(reg) {
                if (reg === "ru") {
                    return "http://cards.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://cards.yandex.ru";
                }
            },
            moikrug: function(reg) {
                if (reg === "ru") {
                    return "http://moikrug.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://moikrug.ru";
                }
            },
            direct: function(reg) {
                if (reg === "ru") {
                    return "http://direct.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://direct.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://direct.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://direct.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "com") {
                                    return "http://direct.yandex.com";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://direct.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            money: function(reg) {
                if (reg === "ru") {
                    return "https://money.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "https://money.yandex.ru";
                }
            },
            lenta: function(reg) {
                if (reg === "ru") {
                    return "http://lenta.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://lenta.yandex.ru";
                }
            },
            market: function(reg) {
                if (reg === "ru") {
                    return "http://market.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://market.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://market.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://market.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://market.yandex.ru";
                            }
                        }
                    }
                }
            },
            "market.advertising": function(reg) {
                if (reg === "ru") {
                    return "http://welcome.advertising.yandex.ru/market/";
                } else {
                    undefined;
                    undefined;
                    return "http://welcome.advertising.yandex.ru/market/";
                }
            },
            wow: function(reg) {
                if (reg === "ru") {
                    return "http://my.ya.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://my.ya.ru";
                }
            },
            tv: function(reg) {
                if (reg === "ru") {
                    return "http://tv.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://tv.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://tv.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://tv.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://tv.yandex.ru";
                            }
                        }
                    }
                }
            },
            afisha: function(reg) {
                if (reg === "ru") {
                    return "http://afisha.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://afisha.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://afisha.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://afisha.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://afis.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://afisha.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            calendar: function(reg) {
                if (reg === "ru") {
                    return "http://calendar.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://calendar.yandex.ru";
                }
            },
            nahodki: function(reg) {
                if (reg === "ru") {
                    return "http://nahodki.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://nahodki.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "kz") {
                            return "http://nahodki.yandex.kz";
                        } else {
                            undefined;
                            undefined;
                            return "http://nahodki.yandex.ru";
                        }
                    }
                }
            },
            weather: function(reg) {
                if (reg === "ru") {
                    return "http://pogoda.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://pogoda.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://pogoda.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://pogoda.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://pogoda.yandex.ru";
                            }
                        }
                    }
                }
            },
            kuda: function(reg) {
                if (reg === "ru") {
                    return "http://kuda.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://kuda.yandex.ru";
                }
            },
            video: function(reg) {
                if (reg === "ru") {
                    return "http://video.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://video.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://video.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://video.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "com") {
                                    return "http://video.yandex.com";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://video.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            "video-com": function(reg) {
                if (reg === "ru") {
                    return "http://video.yandex.com";
                } else {
                    undefined;
                    undefined;
                    return "http://video.yandex.com";
                }
            },
            music: function(reg) {
                if (reg === "ru") {
                    return "http://music.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://music.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://music.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://music.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://music.yandex.ru";
                            }
                        }
                    }
                }
            },
            "music-partner": function(reg) {
                if (reg === "ru") {
                    return "http://music-partner.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://music-partner.yandex.ru";
                }
            },
            www: function(reg) {
                if (reg === "ru") {
                    return "http://www.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://www.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://www.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://www.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://www.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://www.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://www.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            search: function(reg) {
                if (reg === "ru") {
                    return "http://yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            news: function(reg) {
                if (reg === "ru") {
                    return "http://news.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://news.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://news.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://news.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://haber.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://news.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            "news-com": function(reg) {
                if (reg === "ru") {
                    return "http://news.yandex.com";
                } else {
                    undefined;
                    undefined;
                    return "http://news.yandex.com";
                }
            },
            maps: function(reg) {
                if (reg === "ru") {
                    return "http://maps.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://maps.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://harita.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://maps.yandex.ru";
                        }
                    }
                }
            },
            "maps-com": function(reg) {
                if (reg === "ru") {
                    return "http://maps.yandex.com";
                } else {
                    undefined;
                    undefined;
                    return "http://maps.yandex.com";
                }
            },
            probki: function(reg) {
                if (reg === "ru") {
                    return "http://probki.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://probki.yandex.ru";
                }
            },
            slovari: function(reg) {
                if (reg === "ru") {
                    return "http://slovari.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://slovari.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://slovari.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://slovari.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://slovari.yandex.ru";
                            }
                        }
                    }
                }
            },
            images: function(reg) {
                if (reg === "ru") {
                    return "http://images.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://images.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://images.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://images.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "com") {
                                    return "http://images.yandex.com";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://gorsel.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://images.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            "images-com": function(reg) {
                if (reg === "ru") {
                    return "http://images.yandex.com";
                } else {
                    undefined;
                    undefined;
                    return "http://images.yandex.com";
                }
            },
            blogs: function(reg) {
                if (reg === "ru") {
                    return "http://blogs.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://blogs.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://blogs.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://blogs.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://blogs.yandex.ru";
                            }
                        }
                    }
                }
            },
            auto: function(reg) {
                if (reg === "ru") {
                    return "http://auto.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://auto.yandex.ru";
                }
            },
            adresa: function(reg) {
                if (reg === "ru") {
                    return "http://adresa.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://adresa.yandex.ru";
                }
            },
            games: function(reg) {
                if (reg === "ru") {
                    return "http://games.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://games.yandex.ru";
                }
            },
            yaca: function(reg) {
                if (reg === "ru") {
                    return "http://yaca.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://yaca.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://yaca.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            return "http://yaca.yandex.ru";
                        }
                    }
                }
            },
            rasp: function(reg) {
                if (reg === "ru") {
                    return "http://rasp.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://rasp.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://rasp.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://rasp.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://rasp.yandex.ru";
                            }
                        }
                    }
                }
            },
            pvo: function(reg) {
                if (reg === "ru") {
                    return "http://ask.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://ask.yandex.ru";
                }
            },
            online: function(reg) {
                if (reg === "ru") {
                    return "http://online.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://online.yandex.ru";
                }
            },
            books: function(reg) {
                if (reg === "ru") {
                    return "http://books.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://books.yandex.ru";
                }
            },
            site: function(reg) {
                if (reg === "ru") {
                    return "http://site.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://site.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://ozel.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://site.yandex.ru";
                        }
                    }
                }
            },
            bar: function(reg) {
                if (reg === "ru") {
                    return "http://bar.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://bar.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://bar.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://bar.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://bar.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://bar.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            widgets: function(reg) {
                if (reg === "ru") {
                    return "http://widgets.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://widgets.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://widgets.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://widgets.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://widgets.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://widgets.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            wdgt: function(reg) {
                if (reg === "ru") {
                    return "http://wdgt.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://wdgt.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://wdgt.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://wdgt.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://wdgt.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://wdgt.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            interests: function(reg) {
                if (reg === "ru") {
                    return "http://interests.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://interests.yandex.ru";
                }
            },
            kraski: function(reg) {
                if (reg === "ru") {
                    return "http://kraski.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://kraski.yandex.ru";
                }
            },
            local: function(reg) {
                if (reg === "ru") {
                    return "http://local.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://local.yandex.ru";
                }
            },
            museums: function(reg) {
                if (reg === "ru") {
                    return "http://18.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://18.yandex.ru";
                }
            },
            collection: function(reg) {
                if (reg === "ru") {
                    return "http://collection.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://collection.yandex.ru";
                }
            },
            company: function(reg) {
                if (reg === "ru") {
                    return "http://company.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://company.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://company.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://company.yandex.ru";
                        }
                    }
                }
            },
            tests: function(reg) {
                if (reg === "ru") {
                    return "http://tests.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://tests.yandex.ru";
                }
            },
            referats: function(reg) {
                if (reg === "ru") {
                    return "http://referats.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://referats.yandex.ru";
                }
            },
            terms: function(reg) {
                if (reg === "ru") {
                    return "http://terms.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://terms.yandex.ru";
                }
            },
            tune: function(reg) {
                if (reg === "ru") {
                    return "http://tune.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://tune.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://tune.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://tune.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://tune.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://tune.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://tune.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            api: function(reg) {
                if (reg === "ru") {
                    return "http://api.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://api.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        return "http://api.yandex.ru";
                    }
                }
            },
            punto: function(reg) {
                if (reg === "ru") {
                    return "http://punto.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://punto.yandex.ru";
                }
            },
            opinion: function(reg) {
                if (reg === "ru") {
                    return "http://opinion.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://opinion.yandex.ru";
                }
            },
            perevod: function(reg) {
                if (reg === "ru") {
                    return "http://perevod.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://perevod.yandex.ru";
                }
            },
            rabota: function(reg) {
                if (reg === "ru") {
                    return "http://rabota.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://rabota.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://rabota.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://rabota.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://rabota.yandex.ru";
                            }
                        }
                    }
                }
            },
            sprav: function(reg) {
                if (reg === "ru") {
                    return "http://sprav.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://sprav.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://sprav.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://sprav.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://rehber.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://sprav.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            realty: function(reg) {
                if (reg === "ru") {
                    return "http://realty.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://realty.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://realty.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://realty.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                return "http://realty.yandex.ru";
                            }
                        }
                    }
                }
            },
            advertising: function(reg) {
                if (reg === "ru") {
                    return "http://advertising.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://advertising.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://advertising.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://advertising.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://advertising.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://advertising.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            expert: function(reg) {
                if (reg === "ru") {
                    return "http://expert.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://expert.yandex.ru";
                }
            },
            "direct.market": function(reg) {
                if (reg === "ru") {
                    return "http://partner.market.yandex.ru/yandex.market/";
                } else {
                    undefined;
                    undefined;
                    return "http://partner.market.yandex.ru/yandex.market/";
                }
            },
            ba: function(reg) {
                if (reg === "ru") {
                    return "http://ba.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://ba.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://ba.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://ba.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://ba.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://ba.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            bayan: function(reg) {
                if (reg === "ru") {
                    return "http://bayan.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://bayan.yandex.ru";
                }
            },
            partners: function(reg) {
                if (reg === "ru") {
                    return "http://partner.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://partner.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://partner.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://partner.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://partner.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://partner.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            metrika: function(reg) {
                if (reg === "ru") {
                    return "http://metrika.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://metrika.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://metrica.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://metrika.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://metrika.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://metrica.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://metrika.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            balance: function(reg) {
                if (reg === "ru") {
                    return "http://balance.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://balance.yandex.ru";
                }
            },
            wordstat: function(reg) {
                if (reg === "ru") {
                    return "http://wordstat.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://wordstat.yandex.ru";
                }
            },
            webmaster: function(reg) {
                if (reg === "ru") {
                    return "http://webmaster.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://webmaster.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://webmaster.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "tr") {
                                return "http://webmaster.yandex.com.tr";
                            } else {
                                undefined;
                                undefined;
                                return "http://webmaster.yandex.ru";
                            }
                        }
                    }
                }
            },
            server: function(reg) {
                if (reg === "ru") {
                    return "http://company.yandex.ru/technology/server/";
                } else {
                    undefined;
                    undefined;
                    return "http://company.yandex.ru/technology/server/";
                }
            },
            stat: function(reg) {
                if (reg === "ru") {
                    return "http://stat.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://stat.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://stat.yandex.by";
                        } else {
                            undefined;
                            undefined;
                            return "http://stat.yandex.ru";
                        }
                    }
                }
            },
            mobile: function(reg) {
                if (reg === "ru") {
                    return "http://mobile.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://mobile.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://mobil.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://mobile.yandex.ru";
                        }
                    }
                }
            },
            help: function(reg) {
                if (reg === "ru") {
                    return "http://help.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://help.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://help.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "tr") {
                                return "http://yardim.yandex.com.tr";
                            } else {
                                undefined;
                                undefined;
                                return "http://help.yandex.ru";
                            }
                        }
                    }
                }
            },
            feedback: function(reg) {
                if (reg === "ru") {
                    return "http://feedback.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://feedback.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://feedback.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://feedback.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://feedback.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://contact.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://feedback.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            start: function(reg) {
                if (reg === "ru") {
                    return "http://help.yandex.ru/start/";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://help.yandex.ua/start/";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://help.yandex.com/start/";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "tr") {
                                return "http://yardim.yandex.com.tr/start";
                            } else {
                                undefined;
                                undefined;
                                return "http://help.yandex.ru/start/";
                            }
                        }
                    }
                }
            },
            cityday: function(reg) {
                if (reg === "ru") {
                    return "http://cityday.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://cityday.yandex.ru";
                }
            },
            openid: function(reg) {
                if (reg === "ru") {
                    return "http://openid.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://openid.yandex.ru";
                }
            },
            oauth: function(reg) {
                if (reg === "ru") {
                    return "http://oauth.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://oauth.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        return "http://oauth.yandex.ru";
                    }
                }
            },
            nano: function(reg) {
                if (reg === "ru") {
                    return "http://nano.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://nano.yandex.ru";
                }
            },
            partnersearch: function(reg) {
                if (reg === "ru") {
                    return "http://yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://yandex.ru";
                }
            },
            city: function(reg) {
                if (reg === "ru") {
                    return "http://city.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://city.yandex.ru";
                }
            },
            goroda: function(reg) {
                if (reg === "ru") {
                    return "http://goroda.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://goroda.yandex.ru";
                }
            },
            toster: function(reg) {
                if (reg === "ru") {
                    return "http://toster.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://toster.yandex.ru";
                }
            },
            love: function(reg) {
                if (reg === "ru") {
                    return "http://love.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://love.yandex.ru";
                }
            },
            rk: function(reg) {
                if (reg === "ru") {
                    return "http://rk.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://rk.yandex.ru";
                }
            },
            lost: function(reg) {
                if (reg === "ru") {
                    return "http://lost.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://lost.yandex.ru";
                }
            },
            soft: function(reg) {
                if (reg === "ru") {
                    return "http://soft.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "tr") {
                        return "http://soft.yandex.com.tr";
                    } else {
                        undefined;
                        undefined;
                        return "http://soft.yandex.ru";
                    }
                }
            },
            passport: function(reg) {
                if (reg === "ru") {
                    return "https://passport.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://passport.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://passport.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "https://passport.yandex.ru";
                        }
                    }
                }
            },
            404: function(reg) {
                if (reg === "ru") {
                    return "http://404.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://404.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://404.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://404.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://404.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://404.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://404.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            i: function(reg) {
                if (reg === "ru") {
                    return "http://i.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://i.yandex.ru";
                }
            },
            desktop: function(reg) {
                if (reg === "ru") {
                    return "http://desktop.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://desktop.yandex.ru";
                }
            },
            ff: function(reg) {
                if (reg === "ru") {
                    return "http://ff.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://ff.yandex.ru";
                }
            },
            fx: function(reg) {
                if (reg === "ru") {
                    return "http://fx.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://fx.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://fx.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://fx.yandex.ru";
                        }
                    }
                }
            },
            ie: function(reg) {
                if (reg === "ru") {
                    return "http://ie.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://ie.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://ie.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://ie.yandex.ru";
                        }
                    }
                }
            },
            "bar-ie": function(reg) {
                if (reg === "ru") {
                    return "http://bar.yandex.ru/ie";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://bar.yandex.ua/ie";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://bar.yandex.com/ie";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://bar.yandex.by/ie";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://bar.yandex.kz/ie";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://bar.yandex.com.tr/ie";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://bar.yandex.ru/ie";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            "bar-ie9": function(reg) {
                if (reg === "ru") {
                    return "http://bar.yandex.ru/ie";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://bar.yandex.ua/ie";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://bar.yandex.com/ie";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://bar.yandex.by/ie";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://bar.yandex.kz/ie";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://bar.yandex.com.tr/ie";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://bar.yandex.ru/ie";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            internet: function(reg) {
                if (reg === "ru") {
                    return "http://internet.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://internet.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://internet.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://internet.yandex.ru";
                        }
                    }
                }
            },
            keyboard: function(reg) {
                if (reg === "ru") {
                    return "http://www.yandex.ru/index_engl_qwerty.html";
                } else {
                    undefined;
                    undefined;
                    return "http://www.yandex.ru/index_engl_qwerty.html";
                }
            },
            metro: function(reg) {
                if (reg === "ru") {
                    return "http://metro.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://metro.yandex.ru";
                }
            },
            pulse: function(reg) {
                if (reg === "ru") {
                    return "http://blogs.yandex.ru/pulse";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://blogs.yandex.ua/pulse";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "by") {
                            return "http://blogs.yandex.by/pulse";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://blogs.yandex.kz/pulse";
                            } else {
                                undefined;
                                undefined;
                                return "http://blogs.yandex.ru/pulse";
                            }
                        }
                    }
                }
            },
            school: function(reg) {
                if (reg === "ru") {
                    return "http://school.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://school.yandex.ru";
                }
            },
            so: function(reg) {
                if (reg === "ru") {
                    return "http://so.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://so.yandex.ru";
                }
            },
            time: function(reg) {
                if (reg === "ru") {
                    return "http://time.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://time.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://time.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://time.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://time.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://time.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://time.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            xmlsearch: function(reg) {
                if (reg === "ru") {
                    return "http://xml.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://xml.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://xml.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://xml.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://xml.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://xml.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://xml.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            catalogwdgt: function(reg) {
                if (reg === "ru") {
                    return "http://www.yandex.ru/catalog";
                } else {
                    undefined;
                    undefined;
                    return "http://www.yandex.ru/catalog";
                }
            },
            opera: function(reg) {
                if (reg === "ru") {
                    return "http://opera.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "tr") {
                        return "http://opera.yandex.com.tr";
                    } else {
                        undefined;
                        undefined;
                        return "http://opera.yandex.ru";
                    }
                }
            },
            uslugi: function(reg) {
                if (reg === "ru") {
                    return "http://uslugi.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://uslugi.yandex.ru";
                }
            },
            backapv: function(reg) {
                if (reg === "ru") {
                    return "http://backapv.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://backapv.yandex.ru";
                }
            },
            chrome: function(reg) {
                if (reg === "ru") {
                    return "http://chrome.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://chrome.yandex.ru";
                }
            },
            browser: function(reg) {
                if (reg === "ru") {
                    return "http://browser.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://browser.yandex.ru";
                }
            },
            aziada: function(reg) {
                if (reg === "ru") {
                    return "http://aziada2011.yandex.kz";
                } else {
                    undefined;
                    undefined;
                    return "http://aziada2011.yandex.kz";
                }
            },
            translate: function(reg) {
                if (reg === "ru") {
                    return "http://translate.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://translate.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://translate.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://translate.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://translate.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://ceviri.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://translate.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            subs: function(reg) {
                if (reg === "ru") {
                    return "http://subs.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://subs.yandex.ru";
                }
            },
            all: function(reg) {
                if (reg === "ru") {
                    return "http://www.yandex.ru/all";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://www.yandex.ua/all";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://www.yandex.com/all";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "http://www.yandex.by/all";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "http://www.yandex.kz/all";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "http://www.yandex.com.tr/all";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "http://www.yandex.ru/all";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            large: function(reg) {
                if (reg === "ru") {
                    return "http://large.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://large.yandex.ru";
                }
            },
            geocontext: function(reg) {
                if (reg === "ru") {
                    return "http://geocontext.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://geocontext.yandex.ru";
                }
            },
            root: function(reg) {
                if (reg === "ru") {
                    return "http://root.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://root.yandex.ru";
                }
            },
            yamb: function(reg) {
                if (reg === "ru") {
                    return "https://yamb.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "https://yamb.yandex.ru";
                }
            },
            legal: function(reg) {
                if (reg === "ru") {
                    return "http://legal.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "http://legal.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "http://legal.yandex.com";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "tr") {
                                return "http://legal.yandex.com.tr";
                            } else {
                                undefined;
                                undefined;
                                return "http://legal.yandex.ru";
                            }
                        }
                    }
                }
            },
            taxi: function(reg) {
                if (reg === "ru") {
                    return "https://taxi.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "https://taxi.yandex.ru";
                }
            },
            social: function(reg) {
                if (reg === "ru") {
                    return "https://social.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "ua") {
                        return "https://social.yandex.ua";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "com") {
                            return "https://social.yandex.ru";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "by") {
                                return "https://social.yandex.by";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "kz") {
                                    return "https://social.yandex.kz";
                                } else {
                                    undefined;
                                    undefined;
                                    if (reg === "tr") {
                                        return "https://social.yandex.com.tr";
                                    } else {
                                        undefined;
                                        undefined;
                                        return "https://social.yandex.ru";
                                    }
                                }
                            }
                        }
                    }
                }
            },
            contest: function(reg) {
                if (reg === "ru") {
                    return "http://contest.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://contest.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        return "http://contest.yandex.ru";
                    }
                }
            },
            peoplesearch: function(reg) {
                if (reg === "ru") {
                    return "http://people.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://people.yandex.ru";
                }
            },
            disk: function(reg) {
                if (reg === "ru") {
                    return "http://disk.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "com") {
                        return "http://disk.yandex.com";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "tr") {
                            return "http://disk.yandex.com.tr";
                        } else {
                            undefined;
                            undefined;
                            return "http://disk.yandex.ru";
                        }
                    }
                }
            },
            sport: function(reg) {
                if (reg === "ru") {
                    return "http://sport.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    if (reg === "by") {
                        return "http://sport.yandex.by";
                    } else {
                        undefined;
                        undefined;
                        if (reg === "ua") {
                            return "http://sport.yandex.ua";
                        } else {
                            undefined;
                            undefined;
                            if (reg === "kz") {
                                return "http://sport.yandex.kz";
                            } else {
                                undefined;
                                undefined;
                                if (reg === "tr") {
                                    return "http://spor.yandex.com.tr";
                                } else {
                                    undefined;
                                    undefined;
                                    return "http://sport.yandex.ru";
                                }
                            }
                        }
                    }
                }
            },
            literacy: function(reg) {
                if (reg === "ru") {
                    return "http://literacy.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "http://literacy.yandex.ru";
                }
            },
            appsearch: function(reg) {
                if (reg === "ru") {
                    return "//appsearch.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "//appsearch.yandex.ru";
                }
            },
            ege: function(reg) {
                if (reg === "ru") {
                    return "//ege.yandex.ru";
                } else {
                    undefined;
                    undefined;
                    return "//ege.yandex.ru";
                }
            }
        });
    }
    function $676(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $678(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $680(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $684(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $688(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $690(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $692(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $695(__$callback) {
        var __$i14;
        "enable spoon";
        if (this.ctx.url) {
            __$i14 = "a";
        } else {
            __$i14 = "div";
        }
        return __$callback.call(this, null, __$i14);
    }
    function $702(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            elem: "text",
            tag: "span",
            content: this.ctx.content
        }, {
            elem: "helper",
            tag: "span"
        } ]);
    }
    function $706(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.content, {
            elem: "helper",
            tag: "span"
        } ]);
    }
    function $709(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.content, {
            elem: "click",
            tag: "i"
        } ]);
    }
    function $714(__$callback) {
        var __$i69;
        var __$i57;
        var ctx, props, p, a;
        "enable spoon";
        ctx = this.ctx;
        props = [ "title", "target" ];
        a = {};
        if (ctx.url) {
            a.href = ctx.url;
        } else {
            undefined;
        }
        undefined;
        if (ctx.bg) {
            a.style = "background-color: " + ctx.bg;
        } else {
            undefined;
        }
        undefined;
        while (true) {
            if (!(p = props.pop())) {
                break;
            } else {
                __$i57 = ctx[p];
                if (__$i57) {
                    __$i69 = a[p] = ctx[p];
                } else {
                    __$i69 = __$i57;
                }
            }
        }
        undefined;
        return __$callback.call(this, null, a);
    }
    function $719(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $727(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $729(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $734(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $742(__$callback) {
        var __$i56;
        var __$i44;
        var __$i30;
        var __$i18;
        var ctx, a, props, p;
        "enable spoon";
        ctx = this.ctx;
        a = {
            src: "fd://res/layout/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif",
            alt: ""
        };
        props = [ "alt", "width", "height" ];
        __$i18 = ctx.url;
        if (__$i18) {
            __$i30 = a.src = ctx.url;
        } else {
            __$i30 = __$i18;
        }
        while (true) {
            if (!(p = props.shift())) {
                break;
            } else {
                __$i44 = ctx[p];
                if (__$i44) {
                    __$i56 = a[p] = ctx[p];
                } else {
                    __$i56 = __$i44;
                }
            }
        }
        undefined;
        return __$callback.call(this, null, a);
    }
    function $747(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "img");
    }
    function $755(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "h1");
    }
    function $763(__$callback) {
        var __$i15;
        var __$i2;
        "enable spoon";
        __$i2 = "//yandex.st/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif";
        if (this.mods.checked) {
            __$i15 = " v";
        } else {
            __$i15 = "";
        }
        return __$callback.call(this, null, {
            src: __$i2,
            alt: __$i15,
            title: ""
        });
    }
    function $765(__$callback) {
        var __$i64;
        var __$i54;
        var __$i48;
        var __$i38;
        var __$i19;
        var a;
        "enable spoon";
        if (this.ctx.attrs) {
            __$i19 = this.ctx.attrs;
        } else {
            __$i19 = {};
        }
        a = __$i19;
        a.id = this._checkboxAttrs.id;
        a.type = "checkbox";
        __$i38 = this.mods.disabled;
        if (__$i38) {
            __$i48 = a.disabled = "disabled";
        } else {
            __$i48 = __$i38;
        }
        __$i54 = this.mods.checked;
        if (__$i54) {
            __$i64 = a.checked = "checked";
        } else {
            __$i64 = __$i54;
        }
        return __$callback.call(this, null, a);
    }
    function $767(__$callback) {
        var __$i19;
        var a;
        "enable spoon";
        if (this.ctx.attrs) {
            __$i19 = this.ctx.attrs;
        } else {
            __$i19 = {};
        }
        a = __$i19;
        a["for"] = this._checkboxAttrs.id;
        return __$callback.call(this, null, a);
    }
    function $772(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "img");
    }
    function $774(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $776(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "input");
    }
    function $778(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "label");
    }
    function $781(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $786(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "tick"
        });
    }
    function $789(__$callback) {
        var __$i16;
        var __$i2;
        var __$i3;
        var __$i4;
        var __$i9;
        "enable spoon";
        __$i2 = "inner";
        __$i3 = "span";
        __$i4 = "checkbox";
        __$i9 = this.ctx.checkboxAttrs;
        if (__$i9) {
            __$i16 = __$i9;
        } else {
            __$i16 = {};
        }
        return __$callback.call(this, null, [ {
            elem: __$i2,
            tag: __$i3,
            content: [ {
                elem: __$i4,
                attrs: __$i16
            }, {
                elem: "bg"
            } ]
        }, this.ctx.content ]);
    }
    function $794(__$callback) {
        var __$i18;
        "enable spoon";
        if (!this.mods.size) {
            __$i18 = [ {
                mods: {
                    size: "m"
                }
            } ];
        } else {
            __$i18 = "";
        }
        return __$callback.call(this, null, __$i18);
    }
    function $799(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $804(__$callback) {
        var __$i41;
        var __$i21;
        var __$i8;
        var __$i9;
        var __$i14;
        var __$r10;
        function __$fn10(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r10 = __$r;
            }
            this._checkboxAttrs = __r89;
            "";
            return __$callback.call(this, null);
        }
        var __r89;
        "enable spoon";
        "";
        __r89 = this._checkboxAttrs;
        __$i8 = this;
        __$i9 = "_checkboxAttrs";
        __$i14 = this.ctx.checkboxAttrs;
        if (__$i14) {
            __$i21 = __$i14;
        } else {
            __$i21 = {};
        }
        if (__$i21.id) {
            __$i41 = this.ctx.checkboxAttrs;
        } else {
            __$i41 = {
                id: "id" + Math.random()
            };
        }
        __$i8[__$i9] = __$i41;
        return this.apply(__$fn10);
    }
    function $813(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ this.ctx.content, {
            block: this._formSelect.block,
            elem: "arrow",
            content: "&#9660;"
        } ]);
    }
    function $817(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, this.ctx.content);
    }
    function $818(__$callback) {
        if (!!this.elem === false) {
            return $820.call(this, __$callback);
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $820(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            elem: "left"
        }, {
            elem: "content",
            tag: "span",
            content: {
                elem: "text",
                content: this.ctx.content
            }
        }, {
            elem: "click"
        }, this._input ]);
    }
    function $826(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            block: this._formSelect.block,
            elem: "button"
        } ]);
    }
    function $829(__$callback) {
        if (!!this.elem === false) {
            return $831.call(this, __$callback);
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $831(__$callback) {
        var __$i45;
        var __$i35;
        var __$i22;
        var __$i12;
        var m, mods;
        "enable spoon";
        m = {};
        mods = this.ctx.mods;
        __$i12 = !mods;
        if (__$i12) {
            __$i22 = __$i12;
        } else {
            __$i22 = !mods.size;
        }
        if (__$i22) {
            m.size = "s";
        } else {
            undefined;
        }
        undefined;
        __$i35 = !mods;
        if (__$i35) {
            __$i45 = __$i35;
        } else {
            __$i45 = !mods.theme;
        }
        if (__$i45) {
            m.theme = "grey-s";
        } else {
            undefined;
        }
        undefined;
        return __$callback.call(this, null, [ {
            mods: m
        } ]);
    }
    function $838(__$callback) {
        var __$i70;
        var __$i60;
        var __$i54;
        var __$i42;
        var __$i38;
        var __$i20;
        var __$r14;
        function __$fn14(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r14 = __$r;
            }
            this._mode = __r86;
            __r87._theme = __r88;
            "";
            undefined;
            undefined;
            undefined;
            return __$callback.call(this, null);
        }
        var __r87, __r88;
        var __r86;
        var ctx, selectMods, m;
        var __this;
        __this = this;
        "enable spoon";
        ctx = this.ctx;
        selectMods = this._formSelect.mods;
        m = {};
        __$i20 = selectMods.theme;
        if (__$i20) {
            __$i38 = m.theme = selectMods.theme + "-" + selectMods.size;
        } else {
            __$i38 = __$i20;
        }
        __$i42 = selectMods.size;
        if (__$i42) {
            __$i54 = m.size = selectMods.size;
        } else {
            __$i54 = __$i42;
        }
        __$i60 = selectMods.disabled === "yes";
        if (__$i60) {
            __$i70 = m.disabled = "yes";
        } else {
            __$i70 = __$i60;
        }
        ctx.mods = this._.extend(ctx.mods, m);
        "";
        __r86 = this._mode;
        this._mode = "";
        __r87 = this.ctx;
        __r88 = __r87._theme;
        __r87._theme = true;
        return apply.call(__this, __$fn14);
    }
    function $843(__$callback) {
        if (!!this.ctx._inputClick === false) {
            return $845.call(this, __$callback);
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $845(__$callback) {
        var __$i61;
        var __$i21;
        var __$i22;
        var __$r6;
        function __$fn6(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r6 = __$r;
            }
            __r81._inputClick = __r82;
            this._input = __r83;
            "";
            return __$callback.call(this, null);
        }
        var __r83;
        var __r81, __r82;
        "enable spoon";
        "";
        __r81 = this.ctx;
        __r82 = __r81._inputClick;
        __r81._inputClick = true;
        __r83 = this._input;
        __$i21 = this;
        __$i22 = "_input";
        if (this.ctx.type) {
            __$i61 = {
                elem: "input",
                type: this.ctx.type,
                tabindex: this.ctx.tabindex,
                disabled: this.mods.disabled,
                name: this.ctx.name,
                value: this.ctx.value
            };
        } else {
            __$i61 = "";
        }
        __$i21[__$i22] = __$i61;
        return this.apply(__$fn6);
    }
    function $850(__$callback) {
        var __$i64;
        var __$i54;
        var __$i45;
        var __$i33;
        var props, p;
        var a, ctx;
        "enable spoon";
        a = {
            type: this.ctx.type,
            value: ""
        };
        ctx = this.ctx;
        props = [ "tabindex", "name", "value" ];
        while (true) {
            if (!(p = props.shift())) {
                break;
            } else {
                __$i33 = ctx[p];
                if (__$i33) {
                    __$i45 = a[p] = ctx[p];
                } else {
                    __$i45 = __$i33;
                }
            }
        }
        undefined;
        __$i54 = ctx.disabled;
        if (__$i54) {
            __$i64 = a.disabled = "disabled";
        } else {
            __$i64 = __$i54;
        }
        return __$callback.call(this, null, a);
    }
    function $853(__$callback) {
        var __$i80;
        var __$i70;
        var __$i64;
        var __$i50;
        var __$i44;
        var __$i30;
        var __$i24;
        var __$i10;
        var a;
        "enable spoon";
        a = {
            role: "button"
        };
        __$i10 = this.ctx.url;
        if (__$i10) {
            __$i24 = a.href = this.ctx.url;
        } else {
            __$i24 = __$i10;
        }
        __$i30 = this.ctx.target;
        if (__$i30) {
            __$i44 = a.target = this.ctx.target;
        } else {
            __$i44 = __$i30;
        }
        __$i50 = this.ctx.counter;
        if (__$i50) {
            __$i64 = a.onmousedown = this.ctx.counter;
        } else {
            __$i64 = __$i50;
        }
        __$i70 = this.mods.disabled;
        if (__$i70) {
            __$i80 = a["aria-disabled"] = true;
        } else {
            __$i80 = __$i70;
        }
        return __$callback.call(this, null, a);
    }
    function $858(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "input");
    }
    function $861(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $863(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "");
    }
    function $865(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $867(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $871(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "a");
    }
    function $874(__$callback) {
        if (!!this.elem === false) {
            return $876.call(this, __$callback);
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $876(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $881(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $889(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $891(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $893(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "optgroup");
    }
    function $895(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "option");
    }
    function $897(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "select");
    }
    function $900(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "span");
    }
    function $905(__$callback) {
        var __$i65;
        var __$i55;
        var __$i37;
        var __$i23;
        var attrs, prop, p;
        "enable spoon";
        attrs = [ "id", "name" ];
        prop = {};
        while (true) {
            if (!(p = attrs.pop())) {
                break;
            } else {
                __$i23 = this._inputAttrs[p];
                if (__$i23) {
                    __$i37 = prop[p] = this._inputAttrs[p];
                } else {
                    __$i37 = __$i23;
                }
            }
        }
        undefined;
        prop.tabindex = -1;
        __$i55 = this.mods.disabled === "yes";
        if (__$i55) {
            __$i65 = prop.disabled = "disabled";
        } else {
            __$i65 = __$i55;
        }
        return __$callback.call(this, null, prop);
    }
    function $911(__$callback) {
        var __$i70;
        var __$i63;
        var __$i45;
        var __$i33;
        var __$i15;
        var __$i16;
        var __$fi16;
        var t;
        var theme, bpopupaThemesMap;
        "enable spoon";
        theme = this.mods.theme;
        bpopupaThemesMap = {
            grey: "ffffff",
            black: "black"
        };
        t;
        __$i15 = bpopupaThemesMap;
        __$i16 = typeof __$i15 === "object" && __$i15 !== null ? Object.keys(__$i15) : {};
        __$fi16 = 0;
        while (__$fi16 < __$i16.length) {
            t = __$i16[__$fi16];
            __$i33 = bpopupaThemesMap.hasOwnProperty(t);
            if (__$i33) {
                __$i45 = theme.indexOf(t) === 0;
            } else {
                __$i45 = __$i33;
            }
            if (__$i45) {
                theme = t;
                break;
            } else {
                undefined;
                __$fi16++;
            }
        }
        undefined;
        __$i63 = bpopupaThemesMap[theme];
        if (__$i63) {
            __$i70 = __$i63;
        } else {
            __$i70 = theme;
        }
        return __$callback.call(this, null, {
            popupMods: {
                theme: __$i70
            }
        });
    }
    function $914(__$callback) {
        if (!!this.elem === false) {
            return $916.call(this, __$callback);
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $916(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $922(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            mods: {
                layout: "auto"
            }
        } ]);
    }
    function $930(__$callback) {
        var __$i42;
        var __$i30;
        var __$i31;
        var __$i32;
        var __$i35;
        var __$i21;
        var __$i12;
        var __$r10;
        function __$fn10(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r10 = __$r;
            }
            this._inputAttrs = __r84;
            this._formSelect = __r85;
            "";
            undefined;
            undefined;
            undefined;
            return __$callback.call(this, null);
        }
        var __r85;
        var __r84;
        var ctx, id;
        var __this;
        __this = this;
        "enable spoon";
        ctx = this.ctx;
        __$i12 = ctx.id;
        if (__$i12) {
            __$i21 = __$i12;
        } else {
            __$i21 = this.generateId();
        }
        id = __$i21;
        "";
        __r84 = this._inputAttrs;
        __$i30 = this;
        __$i31 = "_inputAttrs";
        __$i32 = id;
        __$i35 = ctx.name;
        if (__$i35) {
            __$i42 = __$i35;
        } else {
            __$i42 = id;
        }
        __$i30[__$i31] = {
            id: __$i32,
            name: __$i42,
            tabindex: ctx.tabindex
        };
        __r85 = this._formSelect;
        this._formSelect = {
            block: this.block,
            mods: this.mods
        };
        return apply.call(__this, __$fn10);
    }
    function $940(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ol");
    }
    function $948(__$callback) {
        var __$i121;
        var __$i109;
        var __$i93;
        var __$i31;
        var __$i22;
        var __$r24;
        function __$fn24(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r24 = __$r;
            }
            a = {
                href: __$i93
            };
            while (true) {
                if (!(p = props.pop())) {
                    break;
                } else {
                    __$i109 = ctx[p];
                    if (__$i109) {
                        __$i121 = a[p] = ctx[p];
                    } else {
                        __$i121 = __$i109;
                    }
                }
            }
            undefined;
            return __$callback.call(this, null, a);
        }
        var __$r23;
        function __$fn23(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r23 = __$r;
            }
            __r80 = __$r23;
            this._buf = __r77;
            this._mode = __r78;
            this.ctx = __r79;
            "";
            __r80;
            __$i93 = p.join("");
            return __$fn24.call(this);
        }
        var ctx, props, p, a;
        var __r77, __r78, __r79, __r80;
        var __this;
        __this = this;
        "enable spoon";
        ctx = this.ctx;
        props = [ "title", "target" ];
        p = typeof ctx.url;
        __$i22 = p === "undefined";
        if (__$i22) {
            __$i31 = __$i22;
        } else {
            __$i31 = p === "string";
        }
        if (__$i31) {
            __$i93 = ctx.url;
            return __$fn24.call(this);
        } else {
            p = [];
            "";
            __r77 = this._buf;
            this._buf = p;
            __r78 = this._mode;
            this._mode = "";
            __r79 = this.ctx;
            this.ctx = ctx.url;
            return apply.call(__this, __$fn23);
        }
    }
    function $953(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "a");
    }
    function $961(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            elem: "wrapper",
            content: this.ctx.content
        });
    }
    function $966(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $971(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "div");
    }
    function $979(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "td");
    }
    function $981(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "table");
    }
    function $983(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i");
    }
    function $988(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            tag: "tr",
            content: {
                elem: "wrap-cell",
                content: this.ctx.content
            }
        });
    }
    function $993(__$callback) {
        "enable spoon";
        this.ctx.content.push({
            elem: "close"
        });
        return __$callback.call(this, null, this.ctx.content);
    }
    function $1002(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            cellpadding: 0,
            cellspacing: 0
        });
    }
    function $1008(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            this._mode = __r73;
            __r74._wrap = __r75;
            this.ctx = __r76;
            "";
            return __$callback.call(this, null);
        }
        var __r76;
        var __r74, __r75;
        var __r73;
        "enable spoon";
        "";
        __r73 = this._mode;
        this._mode = "";
        __r74 = this.ctx;
        __r75 = __r74._wrap;
        __r74._wrap = true;
        __r76 = this.ctx;
        this.ctx = [ {
            elem: "shadow"
        }, {
            elem: "wrap",
            content: this.ctx
        } ];
        return this.apply(__$fn2);
    }
    function $1016(__$callback) {
        var __$i123;
        var __$i71;
        var __$i55;
        var __$i56;
        var __$i57;
        var __$i58;
        var __$i61;
        var __$i45;
        var __$i35;
        var __$i31;
        var __$i21;
        var __$i16;
        var __$i9;
        var __$r26;
        function __$fn26(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r26 = __$r;
            }
            mix = __$r26;
            __r71._mix = __r72;
            "";
            undefined;
            if (mix) {
                __$i123 = mix.concat(m);
            } else {
                __$i123 = m;
            }
            return __$callback.call(this, null, __$i123);
        }
        var __r71, __r72;
        var m, mods, mix;
        "enable spoon";
        m = {};
        __$i9 = this.ctx.mods;
        if (__$i9) {
            __$i16 = __$i9;
        } else {
            __$i16 = {};
        }
        mods = __$i16;
        __$i21 = mods.theme;
        if (__$i21) {
            __$i31 = __$i21;
        } else {
            __$i31 = m.theme = "ffffff";
        }
        __$i35 = mods.direction;
        if (__$i35) {
            __$i45 = __$i35;
        } else {
            __$i45 = m.direction = "down";
        }
        m = [ {
            mods: m
        } ];
        if (this._inBDropdowna) {
            __$i55 = m;
            __$i56 = "push";
            __$i57 = "b-dropdowna";
            __$i58 = "popup";
            __$i61 = this._dropdownaColor;
            if (__$i61) {
                __$i71 = {
                    color: this._dropdownaColor
                };
            } else {
                __$i71 = __$i61;
            }
            __$i55[__$i56]({
                block: __$i57,
                elem: __$i58,
                elemMods: __$i71
            });
            this._dropdownaColor = false;
            this._inBDropdowna = false;
        } else {
            undefined;
        }
        undefined;
        "";
        __r71 = this.ctx;
        __r72 = __r71._mix;
        __r71._mix = true;
        return this.apply(__$fn26);
    }
    function $1023(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, true);
    }
    function $1033(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "div");
    }
    function $1046(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            src: this.ctx.url
        });
    }
    function $1051(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            rel: "stylesheet",
            href: this.ctx.url
        });
    }
    function $1055(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {
            rel: "shortcut icon",
            href: this.ctx.url
        });
    }
    function $1057(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, this.ctx.attrs);
    }
    function $1062(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "script");
    }
    function $1065(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "link");
    }
    function $1067(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "style");
    }
    function $1069(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "link");
    }
    function $1071(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "meta");
    }
    function $1073(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "head");
    }
    function $1075(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "html");
    }
    function $1078(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "body");
    }
    function $1083(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1085(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1087(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1089(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1091(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1093(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1100(__$callback) {
        var __$i90;
        var __$i86;
        var __$r17;
        function __$fn17(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r17 = __$r;
            }
            this._mode = __r67;
            __r68._ieCommented = __r69;
            this.ctx = __r70;
            "";
            undefined;
            undefined;
            undefined;
            return __$fn16.call(this);
        }
        var __$r16;
        function __$fn16(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r16 = __$r;
            }
            return __$callback.call(this, null);
        }
        var __$r15;
        function __$fn15(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r15 = __$r;
            }
            this._mode = __r65;
            this.ctx = __r66;
            "";
            undefined;
            undefined;
            undefined;
            return __$fn16.call(this);
        }
        var __r70;
        var __r68, __r69;
        var __r67;
        var hideRule;
        var __r66;
        var __r65;
        var ie;
        var __this;
        __this = this;
        "enable spoon";
        ie = this.ctx.ie;
        if (ie === true) {
            "";
            __r65 = this._mode;
            this._mode = "";
            __r66 = this.ctx;
            this.ctx = [ 6, 7, 8, 9 ].map(function(v) {
                return {
                    elem: "css",
                    url: this.ctx.url + ".ie" + v + ".css",
                    ie: "IE " + v
                };
            }, this);
            return apply.call(__this, __$fn15);
        } else {
            if (!ie) {
                __$i90 = [ "gt IE 9", "<!-->", "<!--" ];
            } else {
                if (ie === "!IE") {
                    __$i86 = [ ie, "<!-->", "<!--" ];
                } else {
                    __$i86 = [ ie, "", "" ];
                }
                __$i90 = __$i86;
            }
            hideRule = __$i90;
            "";
            __r67 = this._mode;
            this._mode = "";
            __r68 = this.ctx;
            __r69 = __r68._ieCommented;
            __r68._ieCommented = true;
            __r70 = this.ctx;
            this.ctx = [ "<!--[if " + hideRule[0] + "]>", hideRule[1], this.ctx, hideRule[2], "<![endif]-->" ];
            return apply.call(__this, __$fn17);
        }
    }
    function $1105(__$callback) {
        if (!!this.ctx._wrapped === false) {
            if (!!this.elem === false) {
                return $1108.call(this, __$callback);
            } else {
                return $1138.call(this, __$callback);
            }
        } else {
            return $1138.call(this, __$callback);
        }
    }
    function $1108(__$callback) {
        var __$i63;
        var __$i32;
        var __$i33;
        var __$i34;
        var __$i38;
        var __$i43;
        var __$i48;
        var __$r6;
        function __$fn6(__$e, __$r) {
            var __$r7;
            function __$fn7(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r7 = __$r;
                }
                this._mode = __r52;
                __r53._wrapped = __r54;
                this.ctx = __r55;
                "";
                undefined;
                undefined;
                undefined;
                return __$callback.call(this, null);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r6 = __$r;
            }
            __r51 = __$r6;
            this._mode = __r50;
            "";
            dtype = __r51;
            __$i32 = dtype;
            __$i33 = "root";
            __$i34 = "head";
            __$i38 = {
                tag: "meta",
                attrs: {
                    charset: "utf-8"
                }
            };
            __$i43 = {
                tag: "meta",
                attrs: {
                    "http-equiv": "X-UA-Compatible",
                    content: "IE=EmulateIE7, IE=edge"
                }
            };
            __$i48 = {
                tag: "title",
                content: ctx.title
            };
            if (ctx.favicon) {
                __$i63 = {
                    elem: "favicon",
                    url: ctx.favicon
                };
            } else {
                __$i63 = "";
            }
            buf = [ __$i32, {
                elem: __$i33,
                content: [ {
                    elem: __$i34,
                    content: [ __$i38, __$i43, __$i48, __$i63, ctx.meta, {
                        block: "i-ua"
                    }, ctx.head ]
                }, ctx ]
            } ];
            "";
            __r52 = this._mode;
            this._mode = "";
            __r53 = this.ctx;
            __r54 = __r53._wrapped;
            __r53._wrapped = true;
            __r55 = this.ctx;
            this.ctx = buf;
            return apply.call(__this, __$fn7);
        }
        var __r55;
        var __r53, __r54;
        var __r52;
        var ctx, dtype, buf;
        var __r50, __r51;
        var __this;
        __this = this;
        "enable spoon";
        ctx = this.ctx;
        "";
        __r50 = this._mode;
        this._mode = "doctype";
        return apply.call(__this, __$fn6);
    }
    function $1115(__$callback) {
        var __$i150;
        var __$i82;
        var __$i108;
        var __$i64;
        var __$i65;
        var __$r20;
        function __$fn20(__$e, __$r) {
            var __$r23;
            function __$fn23(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r23 = __$r;
                }
                while (__$fi65 < __$i65.length) {
                    e = __$i65[__$fi65];
                    __$i82 = _this.hasOwnProperty(e);
                    if (__$i82) {
                        "";
                        __r61 = this.elem;
                        this.elem = e;
                        return apply.call(__this, __$fn21);
                    } else {
                        __$i108 = __$i82;
                        return __$fn22.call(this);
                    }
                }
                this._mode = __r59;
                this.block = __r60;
                "";
                undefined;
                undefined;
                if (mix) {
                    __$i150 = mix.push(block);
                } else {
                    __$i150 = mix = [ block ];
                }
                return __$callback.call(this, null, mix);
            }
            var __$r22;
            function __$fn22(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r22 = __$r;
                }
                if (__$i108) {
                    js[e] = _this[e];
                } else {
                    undefined;
                }
                __$fi65++;
                return __$fn23.call(this);
            }
            var __$r21;
            function __$fn21(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r21 = __$r;
                }
                __r62 = __$r21;
                this.elem = __r61;
                "";
                __$i108 = __r62;
                return __$fn22.call(this);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r20 = __$r;
            }
            __r58 = __$r20;
            __r56._iGlobal = __r57;
            "";
            mix = __r58;
            js = {};
            block = {
                block: "i-global",
                js: js
            };
            "";
            __r59 = this._mode;
            this._mode = "public-params";
            __r60 = this.block;
            this.block = "i-global";
            e = undefined;
            e;
            __$i64 = _this;
            __$i65 = typeof __$i64 === "object" && __$i64 !== null ? Object.keys(__$i64) : {};
            __$fi65 = 0;
            return __$fn23.call(this);
        }
        var __$fi65;
        var __r60;
        var __r59;
        var _this, mix, js, block, e;
        var __r56, __r57, __r58, __r61, __r62;
        var __this;
        __this = this;
        "enable spoon";
        _this = this["i-global"];
        "";
        __r56 = this.ctx;
        __r57 = __r56._iGlobal;
        __r56._iGlobal = true;
        return apply.call(__this, __$fn20);
    }
    function $1118(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ {
            elem: "body"
        } ]);
    }
    function $1123(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "i-ua_js_no i-ua_css_standard");
    }
    function $1127(__$callback) {
        var __$i13;
        var __$i6;
        "enable spoon";
        __$i6 = this.ctx.doctype;
        if (__$i6) {
            __$i13 = __$i6;
        } else {
            __$i13 = "<!DOCTYPE html>";
        }
        return __$callback.call(this, null, __$i13);
    }
    function $1133(__$callback) {
        var __$i64;
        var __$i65;
        var __$i49;
        var __$i42;
        var __$i39;
        var __$i32;
        var __$r23;
        function __$fn23(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r23 = __$r;
            }
            undefined;
            this._buf.push(BEM.I18N(keyset, key, params));
            return __$callback.call(this, null);
        }
        var __$r22;
        function __$fn22(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r22 = __$r;
            }
            __r49 = __$r22;
            this._buf = __r46;
            this._mode = __r47;
            this.ctx = __r48;
            "";
            __r49;
            __$i64[__$i65] = cnt.join("");
            return __$fn23.call(this);
        }
        var cnt;
        var ctx, keyset, key, params;
        var __r46, __r47, __r48, __r49;
        var __this;
        __this = this;
        "enable spoon";
        if (!this.ctx) {
            return __$callback.call(this, null, "");
        } else {
            undefined;
            undefined;
            ctx = this.ctx;
            keyset = ctx.keyset;
            key = ctx.key;
            __$i32 = ctx.params;
            if (__$i32) {
                __$i39 = __$i32;
            } else {
                __$i39 = {};
            }
            params = __$i39;
            __$i42 = keyset;
            if (__$i42) {
                __$i49 = __$i42;
            } else {
                __$i49 = key;
            }
            if (!__$i49) {
                return __$callback.call(this, null, "");
            } else {
                undefined;
                undefined;
                if (ctx.content) {
                    __$i64 = params;
                    __$i65 = "content";
                    cnt = [];
                    "";
                    __r46 = this._buf;
                    this._buf = cnt;
                    __r47 = this._mode;
                    this._mode = "";
                    __r48 = this.ctx;
                    this.ctx = ctx.content;
                    return apply.call(__this, __$fn22);
                } else {
                    undefined;
                    return __$fn23.call(this);
                }
            }
        }
    }
    function $1138(__$callback) {
        if (!(typeof BEM === "undefined" || !BEM.I18N) === false) {
            if (!!this._start === false) {
                return $1141.call(this, __$callback);
            } else {
                return $1144.call(this, __$callback);
            }
        } else {
            return $1144.call(this, __$callback);
        }
    }
    function $1141(__$callback) {
        var __$i14;
        var __$i2;
        var __$r8;
        function __$fn8(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r8 = __$r;
            }
            return __$callback.call(this, null, __$r8);
        }
        "enable spoon";
        __$i2 = function(bem_) {
            this.BEM = bem_;
            this.BEM.I18N = function(keyset, key) {
                return key;
            };
        };
        if (typeof BEM === "undefined") {
            __$i14 = {};
        } else {
            __$i14 = BEM;
        }
        __$i2(__$i14);
        return apply.call(this, __$fn8);
    }
    function $1144(__$callback) {
        if (this.block === "i-bem") {
            if (this._mode === "default") {
                if (this.elem === "i18n") {
                    return $1148.call(this, __$callback);
                } else {
                    return $1153.call(this, __$callback);
                }
            } else {
                return $1153.call(this, __$callback);
            }
        } else {
            return $1153.call(this, __$callback);
        }
    }
    function $1148(__$callback) {
        var __$i64;
        var __$i65;
        var __$i49;
        var __$i42;
        var __$i39;
        var __$i32;
        var __$r23;
        function __$fn23(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r23 = __$r;
            }
            undefined;
            this._buf.push(BEM.I18N(keyset, key, params));
            return __$callback.call(this, null);
        }
        var __$r22;
        function __$fn22(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r22 = __$r;
            }
            __r45 = __$r22;
            this._buf = __r42;
            this._mode = __r43;
            this.ctx = __r44;
            "";
            __r45;
            __$i64[__$i65] = cnt.join("");
            return __$fn23.call(this);
        }
        var cnt;
        var ctx, keyset, key, params;
        var __r42, __r43, __r44, __r45;
        var __this;
        __this = this;
        "enable spoon";
        if (!this.ctx) {
            return __$callback.call(this, null, "");
        } else {
            undefined;
            undefined;
            ctx = this.ctx;
            keyset = ctx.keyset;
            key = ctx.key;
            __$i32 = ctx.params;
            if (__$i32) {
                __$i39 = __$i32;
            } else {
                __$i39 = {};
            }
            params = __$i39;
            __$i42 = keyset;
            if (__$i42) {
                __$i49 = __$i42;
            } else {
                __$i49 = key;
            }
            if (!__$i49) {
                return __$callback.call(this, null, "");
            } else {
                undefined;
                undefined;
                if (ctx.content) {
                    __$i64 = params;
                    __$i65 = "content";
                    cnt = [];
                    "";
                    __r42 = this._buf;
                    this._buf = cnt;
                    __r43 = this._mode;
                    this._mode = "";
                    __r44 = this.ctx;
                    this.ctx = ctx.content;
                    return apply.call(__this, __$fn22);
                } else {
                    undefined;
                    return __$fn23.call(this);
                }
            }
        }
    }
    function $1153(__$callback) {
        if (!(typeof BEM === "undefined" || !BEM.I18N) === false) {
            if (!!this._start === false) {
                return $1156.call(this, __$callback);
            } else {
                return $1159.call(this, __$callback);
            }
        } else {
            return $1159.call(this, __$callback);
        }
    }
    function $1156(__$callback) {
        var __$i14;
        var __$i2;
        var __$r8;
        function __$fn8(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r8 = __$r;
            }
            return __$callback.call(this, null, __$r8);
        }
        "enable spoon";
        __$i2 = function(bem_) {
            this.BEM = bem_;
            this.BEM.I18N = function(keyset, key) {
                return key;
            };
        };
        if (typeof BEM === "undefined") {
            __$i14 = {};
        } else {
            __$i14 = BEM;
        }
        __$i2(__$i14);
        return apply.call(this, __$fn8);
    }
    function $1159(__$callback) {
        var __t = this.block;
        if (__t === "i-jquery") {
            if (this._mode === "default") {
                if (this.elem === "core") {
                    return $1163.call(this, __$callback);
                } else {
                    return $1224.call(this, __$callback);
                }
            } else {
                return $1224.call(this, __$callback);
            }
        } else if (__t === "i-ua") {
            var __t = this._mode;
            if (__t === "content") {
                if (!!this.elem === false) {
                    return $1171.call(this, __$callback);
                } else {
                    return $1224.call(this, __$callback);
                }
            } else if (__t === "bem") {
                if (!!this.elem === false) {
                    return $1176.call(this, __$callback);
                } else {
                    return $1224.call(this, __$callback);
                }
            } else if (__t === "tag") {
                if (!!this.elem === false) {
                    return $1181.call(this, __$callback);
                } else {
                    return $1224.call(this, __$callback);
                }
            } else {
                return $1224.call(this, __$callback);
            }
        } else if (__t === "i-global") {
            if (this._mode === "public-params") {
                if (!this.elem === false) {
                    return $1189.call(this, __$callback);
                } else {
                    return $1192.call(this, __$callback);
                }
            } else {
                return $1192.call(this, __$callback);
            }
        } else {
            return $1224.call(this, __$callback);
        }
    }
    function $1163(__$callback) {
        var __$r2;
        function __$fn2(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r2 = __$r;
            }
            __r41 = __$r2;
            this._mode = __r39;
            this.ctx = __r40;
            "";
            return __$callback.call(this, null, __r41);
        }
        var __r39, __r40, __r41;
        var __this;
        __this = this;
        "enable spoon";
        "";
        __r39 = this._mode;
        this._mode = "";
        __r40 = this.ctx;
        this.ctx = {
            block: "b-page",
            elem: "js",
            url: "//yandex.st/jquery/1.7.2/jquery.min.js"
        };
        return apply.call(__this, __$fn2);
    }
    function $1171(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, [ ";(function(d,e,c,r){", "e=d.documentElement;", 'c="className";', 'r="replace";', 'e[c]=e[c][r]("i-ua_js_no","i-ua_js_yes");', 'if(d.compatMode!="CSS1Compat")', 'e[c]=e[c][r]("i-ua_css_standart","i-ua_css_quirks")', "})(document);" ].join(""));
    }
    function $1176(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, false);
    }
    function $1181(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "script");
    }
    function $1189(__$callback) {
        var __$i34;
        var __$i27;
        "enable spoon";
        __$i27 = {
            id: 1,
            lang: 1,
            "content-region": 1,
            "user-region": 1,
            login: 1,
            displayName: 1,
            index: 1,
            yandexuid: 1,
            "passport-host": 1,
            "pass-host": 1,
            "passport-msg": 1,
            "static-host": 1,
            "lego-static-host": 1,
            "social-host": 1,
            "click-host": 1,
            "export-host": 1,
            "i-host": 1,
            "social-retpath": 1,
            "lego-path": 1,
            sid: 1,
            retpath: 1
        }[this.elem];
        if (__$i27) {
            __$i34 = __$i27;
        } else {
            __$i34 = false;
        }
        return __$callback.call(this, null, __$i34);
    }
    function $1192(__$callback) {
        var __t = this.elem;
        if (__t === "lego-static-host") {
            return $1194.call(this, __$callback);
        } else if (__t === "export-host") {
            return $1196.call(this, __$callback);
        } else if (__t === "social-host") {
            return $1198.call(this, __$callback);
        } else if (__t === "pass-host") {
            return $1200.call(this, __$callback);
        } else if (__t === "passport-host") {
            return $1202.call(this, __$callback);
        } else if (__t === "click-host") {
            return $1204.call(this, __$callback);
        } else if (__t === "content-region") {
            return $1206.call(this, __$callback);
        } else if (__t === "tld") {
            return $1208.call(this, __$callback);
        } else if (__t === "lang") {
            return $1210.call(this, __$callback);
        } else {
            if (!this.elem === false) {
                return $1213.call(this, __$callback);
            } else {
                var __t = this._mode;
                if (__t === "default") {
                    if (!!this.elem === false) {
                        return $1217.call(this, __$callback);
                    } else {
                        return $1224.call(this, __$callback);
                    }
                } else if (__t === "env") {
                    return $1221.call(this, __$callback);
                } else {
                    return $1224.call(this, __$callback);
                }
            }
        }
    }
    function $1194(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//yandex.st/lego/2.10-57");
    }
    function $1196(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//export.yandex.ru");
    }
    function $1198(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//social.yandex.ru");
    }
    function $1200(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//pass.yandex.ru");
    }
    function $1202(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "https://passport.yandex.ru");
    }
    function $1204(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "//clck.yandex.ru");
    }
    function $1206(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ru");
    }
    function $1208(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ru");
    }
    function $1210(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "ru");
    }
    function $1213(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, "");
    }
    function $1217(__$callback) {
        var __$i121;
        var __$i122;
        var __$i77;
        var __$i57;
        var __$i36;
        var __$i23;
        var __$i14;
        var __$i7;
        var __$fi122;
        var p;
        var params, iGlobal, isTldChanged, tld, xYaDomain, yaDomain;
        "enable spoon";
        __$i7 = this.ctx.params;
        if (__$i7) {
            __$i14 = __$i7;
        } else {
            __$i14 = {};
        }
        params = __$i14;
        iGlobal = this["i-global"];
        __$i23 = params.tld;
        if (__$i23) {
            __$i36 = params.tld !== iGlobal.tld;
        } else {
            __$i36 = __$i23;
        }
        isTldChanged = __$i36;
        if (isTldChanged) {
            tld = params.tld;
            if (tld === "tr") {
                __$i57 = "yandex.com.tr";
            } else {
                __$i57 = "yandex." + tld;
            }
            xYaDomain = __$i57;
            if ([ "ua", "by", "kz" ].indexOf(tld) != -1) {
                __$i77 = "yandex.ru";
            } else {
                __$i77 = xYaDomain;
            }
            yaDomain = __$i77;
            iGlobal["content-region"] = tld;
            iGlobal["click-host"] = "//clck." + yaDomain;
            iGlobal["passport-host"] = "https://passport." + yaDomain;
            iGlobal["pass-host"] = "//pass." + xYaDomain;
            iGlobal["social-host"] = "//social." + xYaDomain;
            iGlobal["export-host"] = "//export." + xYaDomain;
        } else {
            undefined;
        }
        undefined;
        p;
        __$i121 = params;
        __$i122 = typeof __$i121 === "object" && __$i121 !== null ? Object.keys(__$i121) : {};
        __$fi122 = 0;
        while (__$fi122 < __$i122.length) {
            p = __$i122[__$fi122];
            iGlobal[p] = params[p];
            __$fi122++;
        }
        return __$callback.call(this, null);
    }
    function $1221(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, {});
    }
    function $1224(__$callback) {
        if (!this._start === false) {
            if (!!this["i-global"] === false) {
                return $1227.call(this, __$callback);
            } else {
                return $1230.call(this, __$callback);
            }
        } else {
            return $1230.call(this, __$callback);
        }
    }
    function $1227(__$callback) {
        var __$i86;
        var __$i87;
        var __$i90;
        var __$i91;
        var __$i92;
        var __$i60;
        var __$i61;
        var __$r12;
        function __$fn12(__$e, __$r) {
            var __$r13;
            function __$fn13(__$e, __$r) {
                var __$r14;
                function __$fn14(__$e, __$r) {
                    if (__$e) {
                        return __$callback.call(this, __$e);
                    } else {
                        __$r14 = __$r;
                    }
                    return __$callback.call(this, null);
                }
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r13 = __$r;
                }
                __r38 = __$r13;
                this._mode = __r36;
                this.block = __r37;
                "";
                __$i86[__$i87] = __$i90[__$i91](__$i92, __r38);
                return this.apply(__$fn14);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r12 = __$r;
            }
            while (true) {
                if (!(e = es.shift())) {
                    break;
                } else {
                    "";
                    __r35 = this.elem;
                    this.elem = e;
                    __$i60 = ps;
                    __$i61 = e;
                    return this.apply(__$fn11);
                }
            }
            this._mode = __r33;
            this.block = __r34;
            "";
            undefined;
            undefined;
            __$i86 = this;
            __$i87 = "i-global";
            __$i90 = this._;
            __$i91 = "extend";
            __$i92 = ps;
            "";
            __r36 = this._mode;
            this._mode = "env";
            __r37 = this.block;
            this.block = "i-global";
            return apply.call(__this, __$fn13);
        }
        var __$r11;
        function __$fn11(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r11 = __$r;
            }
            __$i60[__$i61] = __$r11;
            this.elem = __r35;
            "";
            return __$fn12.call(this);
        }
        var __r35;
        var __r34;
        var __r33;
        var ps, es, e;
        var __r36, __r37, __r38;
        var __this;
        __this = this;
        "enable spoon";
        ps = {};
        es = [ "lang", "tld", "content-region", "click-host", "passport-host", "pass-host", "social-host", "export-host", "login", "lego-static-host" ];
        "";
        __r33 = this._mode;
        this._mode = "default";
        __r34 = this.block;
        this.block = "i-global";
        return __$fn12.call(this);
    }
    function $1230(__$callback) {
        if (!!this._start === false) {
            return $1232.call(this, __$callback);
        } else {
            var __t = this._mode;
            if (__t === "content") {
                return $1235.call(this, __$callback);
            } else if (__t === "mix") {
                return $1237.call(this, __$callback);
            } else if (__t === "bem") {
                return $1239.call(this, __$callback);
            } else if (__t === "jsAttr") {
                return $1241.call(this, __$callback);
            } else if (__t === "js") {
                return $1243.call(this, __$callback);
            } else if (__t === "cls") {
                return $1245.call(this, __$callback);
            } else if (__t === "attrs") {
                return $1247.call(this, __$callback);
            } else if (__t === "tag") {
                return $1249.call(this, __$callback);
            } else if (__t === "default") {
                return $1251.call(this, __$callback);
            } else {
                if (!this._.isSimple(this.ctx) === false) {
                    if (!!this._mode === false) {
                        return $1255.call(this, __$callback);
                    } else {
                        return $1258.call(this, __$callback);
                    }
                } else {
                    return $1258.call(this, __$callback);
                }
            }
        }
    }
    function $1232(__$callback) {
        var buildEscape, ctx;
        var BEM_, toString, SHORT_TAGS;
        "enable spoon";
        BEM_ = {};
        toString = Object.prototype.toString;
        SHORT_TAGS = {
            area: 1,
            base: 1,
            br: 1,
            col: 1,
            command: 1,
            embed: 1,
            hr: 1,
            img: 1,
            input: 1,
            keygen: 1,
            link: 1,
            meta: 1,
            param: 1,
            source: 1,
            wbr: 1
        };
        (function(BEM, undefined) {
            var MOD_DELIM, ELEM_DELIM, NAME_PATTERN;
            MOD_DELIM = "_";
            ELEM_DELIM = "__";
            NAME_PATTERN = "[a-zA-Z0-9-]+";
            function buildModPostfix(modName, modVal, buffer) {
                buffer.push(MOD_DELIM, modName, MOD_DELIM, modVal);
            }
            function buildBlockClass(name, modName, modVal, buffer) {
                var __$i312;
                var __$i301;
                buffer.push(name);
                __$i301 = modVal;
                if (__$i301) {
                    __$i312 = buildModPostfix(modName, modVal, buffer);
                } else {
                    __$i312 = __$i301;
                }
            }
            function buildElemClass(block, name, modName, modVal, buffer) {
                var __$i337;
                var __$i326;
                buildBlockClass(block, undefined, undefined, buffer);
                buffer.push(ELEM_DELIM, name);
                __$i326 = modVal;
                if (__$i326) {
                    __$i337 = buildModPostfix(modName, modVal, buffer);
                } else {
                    __$i337 = __$i326;
                }
            }
            BEM.INTERNAL = {
                NAME_PATTERN: NAME_PATTERN,
                MOD_DELIM: MOD_DELIM,
                ELEM_DELIM: ELEM_DELIM,
                buildModPostfix: function(modName, modVal, buffer) {
                    var __$i367;
                    var __$i348;
                    var __$i341;
                    var res;
                    __$i341 = buffer;
                    if (__$i341) {
                        __$i348 = __$i341;
                    } else {
                        __$i348 = [];
                    }
                    res = __$i348;
                    buildModPostfix(modName, modVal, res);
                    if (buffer) {
                        __$i367 = res;
                    } else {
                        __$i367 = res.join("");
                    }
                    return __$i367;
                },
                buildClass: function(block, elem, modName, modVal, buffer) {
                    var __$i499;
                    var __$i486;
                    var __$i464;
                    var __$i457;
                    var __$i446;
                    var __$i438;
                    var __$i431;
                    var __$i415;
                    var __$i405;
                    var res;
                    var typeOf;
                    typeOf = typeof modName;
                    if (typeOf == "string") {
                        if (typeof modVal != "string") {
                            buffer = modVal;
                            modVal = modName;
                            modName = elem;
                            elem = undefined;
                        } else {
                            undefined;
                        }
                    } else {
                        if (typeOf != "undefined") {
                            buffer = modName;
                            modName = undefined;
                        } else {
                            __$i405 = elem;
                            if (__$i405) {
                                __$i415 = typeof elem != "string";
                            } else {
                                __$i415 = __$i405;
                            }
                            if (__$i415) {
                                buffer = elem;
                                elem = undefined;
                            } else {
                                undefined;
                            }
                        }
                    }
                    undefined;
                    __$i431 = elem;
                    if (__$i431) {
                        __$i438 = __$i431;
                    } else {
                        __$i438 = modName;
                    }
                    if (__$i438) {
                        __$i446 = __$i438;
                    } else {
                        __$i446 = buffer;
                    }
                    if (!__$i446) {
                        return block;
                    } else {
                        undefined;
                        undefined;
                        __$i457 = buffer;
                        if (__$i457) {
                            __$i464 = __$i457;
                        } else {
                            __$i464 = [];
                        }
                        res = __$i464;
                        if (elem) {
                            __$i486 = buildElemClass(block, elem, modName, modVal, res);
                        } else {
                            __$i486 = buildBlockClass(block, modName, modVal, res);
                        }
                        if (buffer) {
                            __$i499 = res;
                        } else {
                            __$i499 = res.join("");
                        }
                        return __$i499;
                    }
                },
                buildModsClasses: function(block, elem, mods, buffer) {
                    var __$i625;
                    var __$i519;
                    var __$i520;
                    var __$i510;
                    var __$i503;
                    var modVal;
                    var __$fi520;
                    var modName;
                    var res;
                    __$i503 = buffer;
                    if (__$i503) {
                        __$i510 = __$i503;
                    } else {
                        __$i510 = [];
                    }
                    res = __$i510;
                    if (mods) {
                        modName = undefined;
                        modName;
                        __$i519 = mods;
                        __$i520 = typeof __$i519 === "object" && __$i519 !== null ? Object.keys(__$i519) : {};
                        __$fi520 = 0;
                        while (__$fi520 < __$i520.length) {
                            modName = __$i520[__$fi520];
                            if (!mods.hasOwnProperty(modName)) {
                                __$fi520++;
                                continue;
                            } else {
                                undefined;
                                undefined;
                                modVal = mods[modName];
                                if (modVal == null) {
                                    __$fi520++;
                                    continue;
                                } else {
                                    undefined;
                                    undefined;
                                    modVal = mods[modName] + "";
                                    if (!modVal) {
                                        __$fi520++;
                                        continue;
                                    } else {
                                        undefined;
                                        undefined;
                                        res.push(" ");
                                        if (elem) {
                                            buildElemClass(block, elem, modName, modVal, res);
                                        } else {
                                            buildBlockClass(block, modName, modVal, res);
                                        }
                                        __$fi520++;
                                    }
                                }
                            }
                        }
                    } else {
                        undefined;
                    }
                    undefined;
                    if (buffer) {
                        __$i625 = res;
                    } else {
                        __$i625 = res.join("");
                    }
                    return __$i625;
                },
                buildClasses: function(block, elem, mods, buffer) {
                    var __$i678;
                    var __$i658;
                    var __$i636;
                    var __$i629;
                    var res;
                    __$i629 = buffer;
                    if (__$i629) {
                        __$i636 = __$i629;
                    } else {
                        __$i636 = [];
                    }
                    res = __$i636;
                    if (elem) {
                        __$i658 = buildElemClass(block, elem, undefined, undefined, res);
                    } else {
                        __$i658 = buildBlockClass(block, undefined, undefined, res);
                    }
                    this.buildModsClasses(block, elem, mods, buffer);
                    if (buffer) {
                        __$i678 = res;
                    } else {
                        __$i678 = res.join("");
                    }
                    return __$i678;
                }
            };
        })(BEM_);
        buildEscape = function() {
            var ts, f;
            ts = {
                '"': "&quot;",
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;"
            };
            f = function(t) {
                var __$i690;
                var __$i683;
                __$i683 = ts[t];
                if (__$i683) {
                    __$i690 = __$i683;
                } else {
                    __$i690 = t;
                }
                return __$i690;
            };
            return function(r) {
                r = new RegExp(r, "g");
                return function(s) {
                    return ("" + s).replace(r, f);
                };
            };
        }();
        ctx = {
            ctx: this,
            _start: true,
            apply: apply,
            _buf: [],
            _: {
                isArray: function(obj) {
                    return toString.call(obj) === "[object Array]";
                },
                isSimple: function(obj) {
                    var __$i133;
                    var __$i123;
                    var __$i114;
                    var t;
                    t = typeof obj;
                    __$i114 = t === "string";
                    if (__$i114) {
                        __$i123 = __$i114;
                    } else {
                        __$i123 = t === "number";
                    }
                    if (__$i123) {
                        __$i133 = __$i123;
                    } else {
                        __$i133 = t === "boolean";
                    }
                    return __$i133;
                },
                isShortTag: function(t) {
                    return SHORT_TAGS.hasOwnProperty(t);
                },
                extend: function(o1, o2) {
                    var __$i244;
                    var __$i232;
                    var __$i214;
                    var __$i215;
                    var __$i203;
                    var __$i191;
                    var __$i173;
                    var __$i174;
                    var __$i160;
                    var __$i153;
                    var __$i150;
                    var __$i142;
                    var __$fi215;
                    var __$fi174;
                    var res, n;
                    __$i142 = !o1;
                    if (__$i142) {
                        __$i150 = __$i142;
                    } else {
                        __$i150 = !o2;
                    }
                    if (__$i150) {
                        __$i153 = o1;
                        if (__$i153) {
                            __$i160 = __$i153;
                        } else {
                            __$i160 = o2;
                        }
                        return __$i160;
                    } else {
                        undefined;
                        undefined;
                        res = {};
                        n = undefined;
                        n;
                        __$i173 = o1;
                        __$i174 = typeof __$i173 === "object" && __$i173 !== null ? Object.keys(__$i173) : {};
                        __$fi174 = 0;
                        while (__$fi174 < __$i174.length) {
                            n = __$i174[__$fi174];
                            __$i191 = o1.hasOwnProperty(n);
                            if (__$i191) {
                                __$i203 = res[n] = o1[n];
                            } else {
                                __$i203 = __$i191;
                            }
                            __$fi174++;
                        }
                        undefined;
                        n = undefined;
                        n;
                        __$i214 = o2;
                        __$i215 = typeof __$i214 === "object" && __$i214 !== null ? Object.keys(__$i214) : {};
                        __$fi215 = 0;
                        while (__$fi215 < __$i215.length) {
                            n = __$i215[__$fi215];
                            __$i232 = o2.hasOwnProperty(n);
                            if (__$i232) {
                                __$i244 = res[n] = o2[n];
                            } else {
                                __$i244 = __$i232;
                            }
                            __$fi215++;
                        }
                        undefined;
                        return res;
                    }
                },
                identify: function() {
                    var cnt, expando, get;
                    cnt = 0;
                    expando = "__" + +(new Date);
                    get = function() {
                        return "uniq" + ++cnt;
                    };
                    return function(obj, onlyGet) {
                        var __$i724;
                        var __$i715;
                        if (!obj) {
                            return get();
                        } else {
                            undefined;
                            undefined;
                            __$i715 = onlyGet;
                            if (__$i715) {
                                __$i724 = __$i715;
                            } else {
                                __$i724 = obj[expando];
                            }
                            if (__$i724) {
                                return obj[expando];
                            } else {
                                return obj[expando] = get();
                            }
                        }
                    };
                }(),
                xmlEscape: buildEscape("[&<>]"),
                attrEscape: buildEscape('["&<>]')
            },
            BEM: BEM_,
            isFirst: function() {
                return this.position === 1;
            },
            isLast: function() {
                return this.position === this._listLength;
            },
            generateId: function() {
                return this._.identify(this.ctx);
            }
        };
        ctx.apply();
        return __$callback.call(this, null, ctx._buf.join(""));
    }
    function $1235(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, this.ctx.content);
    }
    function $1237(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1239(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1241(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1243(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1245(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1247(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1249(__$callback) {
        "enable spoon";
        return __$callback.call(this, null, undefined);
    }
    function $1251(__$callback) {
        var __$i717;
        var __$i718;
        var __$i660;
        var __$i650;
        var __$i651;
        var __$i652;
        var __$i653;
        var __$i615;
        var __$i605;
        var __$i603;
        var __$i595;
        var __$i585;
        var __$i586;
        var __$i583;
        var __$i564;
        var __$i559;
        var __$i549;
        var __$i545;
        var __$i542;
        var __$i527;
        var __$i517;
        var __$i509;
        var __$i501;
        var __$i492;
        var __$i488;
        var __$i484;
        var __$i465;
        var __$i468;
        var __$i463;
        var __$i454;
        var __$i450;
        var __$i440;
        var __$i437;
        var __$i428;
        var __$i423;
        var __$i414;
        var __$i387;
        var __$i380;
        var __$i363;
        var __$i947;
        var __$i935;
        var __$i335;
        var __$i316;
        var __$i317;
        var __$i320;
        var __$i323;
        var __$i326;
        var __$i305;
        var __$i298;
        var __$i295;
        var __$i288;
        var __$i283;
        var __$i273;
        var __$i881;
        var __$i869;
        var __$i870;
        var __$i861;
        var __$i849;
        var __$i850;
        var __$i831;
        var __$i822;
        var __$i816;
        var __$i807;
        var __$i249;
        var __$i244;
        var __$i240;
        var __$i231;
        var __$i213;
        var __$i783;
        var __$i773;
        var __$i176;
        var __$i155;
        var __$i152;
        var __$i148;
        var __$i129;
        var __$i114;
        var __$i115;
        var __$i118;
        var __$i86;
        var __$i75;
        var __$i68;
        var __$i60;
        var __$i55;
        var __$i45;
        var __$r205;
        function __$fn205(__$e, __$r) {
            var __$r208;
            function __$fn208(__$e, __$r) {
                var __$r218;
                function __$fn218(__$e, __$r) {
                    if (__$e) {
                        return __$callback.call(this, __$e);
                    } else {
                        __$r218 = __$r;
                    }
                    return __$callback.call(this, null);
                }
                var __$r217;
                function __$fn217(__$e, __$r) {
                    var __$r220;
                    function __$fn220(__$e, __$r) {
                        if (__$e) {
                            return __$callback.call(this, __$e);
                        } else {
                            __$r220 = __$r;
                        }
                        undefined;
                        __$i935 = tag;
                        if (__$i935) {
                            __$i947 = buf.push("</", tag, ">");
                        } else {
                            __$i947 = __$i935;
                        }
                        return __$fn218.call(this);
                    }
                    var __$r219;
                    function __$fn219(__$e, __$r) {
                        if (__$e) {
                            return __$callback.call(this, __$e);
                        } else {
                            __$r219 = __$r;
                        }
                        this._notNewList = __r28;
                        this.position = __r29;
                        this._listLength = __r30;
                        this.ctx = __r31;
                        this._mode = __r32;
                        "";
                        undefined;
                        undefined;
                        undefined;
                        return __$fn220.call(this);
                    }
                    if (__$e) {
                        return __$callback.call(this, __$e);
                    } else {
                        __$r217 = __$r;
                    }
                    __r27 = __$r217;
                    this._mode = __r26;
                    "";
                    content = __r27;
                    __$i807 = content;
                    if (__$i807) {
                        __$i816 = __$i807;
                    } else {
                        __$i816 = content === 0;
                    }
                    if (__$i816) {
                        __$i822 = this.block;
                        if (__$i822) {
                            __$i831 = __$i822;
                        } else {
                            __$i831 = this.elem;
                        }
                        isBEM = __$i831;
                        "";
                        __r28 = this._notNewList;
                        this._notNewList = false;
                        __r29 = this.position;
                        __$i849 = this;
                        __$i850 = "position";
                        if (isBEM) {
                            __$i861 = 1;
                        } else {
                            __$i861 = this.position;
                        }
                        __$i849[__$i850] = __$i861;
                        __r30 = this._listLength;
                        __$i869 = this;
                        __$i870 = "_listLength";
                        if (isBEM) {
                            __$i881 = 1;
                        } else {
                            __$i881 = this._listLength;
                        }
                        __$i869[__$i870] = __$i881;
                        __r31 = this.ctx;
                        this.ctx = content;
                        __r32 = this._mode;
                        this._mode = "";
                        return apply.call(__this, __$fn219);
                    } else {
                        undefined;
                        return __$fn220.call(this);
                    }
                }
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r208 = __$r;
                }
                undefined;
                if (this._.isShortTag(tag)) {
                    buf.push("/>");
                    return __$fn218.call(this);
                } else {
                    __$i773 = tag;
                    if (__$i773) {
                        __$i783 = buf.push(">");
                    } else {
                        __$i783 = __$i773;
                    }
                    "";
                    __r26 = this._mode;
                    this._mode = "content";
                    return apply.call(__this, __$fn217);
                }
            }
            var __$r207;
            function __$fn207(__$e, __$r) {
                var __$r209;
                function __$fn209(__$e, __$r) {
                    var __$r210;
                    function __$fn210(__$e, __$r) {
                        var __$r213;
                        function __$fn213(__$e, __$r) {
                            var __$r215;
                            function __$fn215(__$e, __$r) {
                                var __$r216;
                                function __$fn216(__$e, __$r) {
                                    if (__$e) {
                                        return __$callback.call(this, __$e);
                                    } else {
                                        __$r216 = __$r;
                                    }
                                    __r25 = __$r216;
                                    this._mode = __r24;
                                    "";
                                    attrs = __r25;
                                    attrs = this._.extend(attrs, v.attrs);
                                    if (attrs) {
                                        name = undefined;
                                        name;
                                        __$i717 = attrs;
                                        __$i718 = typeof __$i717 === "object" && __$i717 !== null ? Object.keys(__$i717) : {};
                                        __$fi718 = 0;
                                        while (__$fi718 < __$i718.length) {
                                            name = __$i718[__$fi718];
                                            buf.push(" ", name, '="', this._.attrEscape(attrs[name]), '"');
                                            __$fi718++;
                                        }
                                    } else {
                                        undefined;
                                    }
                                    return __$fn208.call(this);
                                }
                                if (__$e) {
                                    return __$callback.call(this, __$e);
                                } else {
                                    __$r215 = __$r;
                                }
                                undefined;
                                "";
                                __r24 = this._mode;
                                this._mode = "attrs";
                                return apply.call(__this, __$fn216);
                            }
                            var __$r214;
                            function __$fn214(__$e, __$r) {
                                if (__$e) {
                                    return __$callback.call(this, __$e);
                                } else {
                                    __$r214 = __$r;
                                }
                                __r23 = __$r214;
                                this._mode = __r22;
                                "";
                                jsAttr = __r23;
                                __$i650 = buf;
                                __$i651 = "push";
                                __$i652 = " ";
                                __$i653 = jsAttr;
                                if (__$i653) {
                                    __$i660 = __$i653;
                                } else {
                                    __$i660 = "onclick";
                                }
                                __$i650[__$i651](__$i652, __$i660, '="return ', this._.attrEscape(JSON.stringify(jsParams)), '"');
                                return __$fn215.call(this);
                            }
                            if (__$e) {
                                return __$callback.call(this, __$e);
                            } else {
                                __$r213 = __$r;
                            }
                            undefined;
                            if (jsParams) {
                                "";
                                __r22 = this._mode;
                                this._mode = "jsAttr";
                                return apply.call(__this, __$fn214);
                            } else {
                                undefined;
                                return __$fn215.call(this);
                            }
                        }
                        var __$r212;
                        function __$fn212(__$e, __$r) {
                            if (__$e) {
                                return __$callback.call(this, __$e);
                            } else {
                                __$r212 = __$r;
                            }
                            undefined;
                            __$i583 = cls;
                            if (__$i583) {
                                __$i585 = buf;
                                __$i586 = "push";
                                if (isBEM) {
                                    __$i595 = " ";
                                } else {
                                    __$i595 = "";
                                }
                                __$i603 = __$i585[__$i586](__$i595, cls);
                            } else {
                                __$i603 = __$i583;
                            }
                            __$i605 = addJSInitClass;
                            if (__$i605) {
                                __$i615 = buf.push(" i-bem");
                            } else {
                                __$i615 = __$i605;
                            }
                            buf.push('"');
                            return __$fn213.call(this);
                        }
                        var __$r211;
                        function __$fn211(__$e, __$r) {
                            if (__$e) {
                                return __$callback.call(this, __$e);
                            } else {
                                __$r211 = __$r;
                            }
                            __r19 = __$r211;
                            this._mode = __r18;
                            "";
                            mix = __r19;
                            __$i363 = v.mix;
                            if (__$i363) {
                                if (mix) {
                                    __$i380 = mix.concat(v.mix);
                                } else {
                                    __$i380 = v.mix;
                                }
                                __$i387 = mix = __$i380;
                            } else {
                                __$i387 = __$i363;
                            }
                            if (mix) {
                                i = 0;
                                l = mix.length;
                                while (true) {
                                    if (!(i < l)) {
                                        break;
                                    } else {
                                        mixItem = mix[i++];
                                        __$i414 = mixItem.block;
                                        if (__$i414) {
                                            __$i423 = __$i414;
                                        } else {
                                            __$i423 = mixItem.elem;
                                        }
                                        hasItem = __$i423;
                                        __$i428 = mixItem.block;
                                        if (__$i428) {
                                            __$i437 = __$i428;
                                        } else {
                                            __$i437 = _this.block;
                                        }
                                        block = __$i437;
                                        __$i440 = hasItem;
                                        if (__$i440) {
                                            __$i450 = buf.push(" ");
                                        } else {
                                            __$i450 = __$i440;
                                        }
                                        __$i454 = BEM_.INTERNAL;
                                        if (hasItem) {
                                            __$i463 = "buildClasses";
                                        } else {
                                            __$i463 = "buildModsClasses";
                                        }
                                        __$i465 = block;
                                        __$i468 = mixItem.elem;
                                        if (__$i468) {
                                            __$i488 = __$i468;
                                        } else {
                                            if (mixItem.block) {
                                                __$i484 = undefined;
                                            } else {
                                                __$i484 = _this.elem;
                                            }
                                            __$i488 = __$i484;
                                        }
                                        __$i492 = mixItem.elemMods;
                                        if (__$i492) {
                                            __$i501 = __$i492;
                                        } else {
                                            __$i501 = mixItem.mods;
                                        }
                                        __$i454[__$i463](__$i465, __$i488, __$i501, buf);
                                        if (mixItem.js) {
                                            __$i509 = jsParams;
                                            if (__$i509) {
                                                __$i517 = __$i509;
                                            } else {
                                                __$i517 = jsParams = {};
                                            }
                                            __$i527 = BEM_.INTERNAL.buildClass(block, mixItem.elem);
                                            if (mixItem.js === true) {
                                                __$i542 = {};
                                            } else {
                                                __$i542 = mixItem.js;
                                            }
                                            __$i517[__$i527] = __$i542;
                                            __$i545 = addJSInitClass;
                                            if (__$i545) {
                                                __$i564 = __$i545;
                                            } else {
                                                __$i549 = block;
                                                if (__$i549) {
                                                    __$i559 = !mixItem.elem;
                                                } else {
                                                    __$i559 = __$i549;
                                                }
                                                __$i564 = addJSInitClass = __$i559;
                                            }
                                        } else {
                                            undefined;
                                        }
                                    }
                                }
                            } else {
                                undefined;
                            }
                            return __$fn212.call(this);
                        }
                        if (__$e) {
                            return __$callback.call(this, __$e);
                        } else {
                            __$r210 = __$r;
                        }
                        __r17 = __$r210;
                        this._mode = __r16;
                        "";
                        cls = __r17;
                        __$i273 = cls;
                        if (__$i273) {
                            __$i283 = __$i273;
                        } else {
                            __$i283 = cls = v.cls;
                        }
                        __$i288 = v.block;
                        if (__$i288) {
                            __$i295 = jsParams;
                        } else {
                            __$i295 = __$i288;
                        }
                        addJSInitClass = __$i295;
                        __$i298 = isBEM;
                        if (__$i298) {
                            __$i305 = __$i298;
                        } else {
                            __$i305 = cls;
                        }
                        if (__$i305) {
                            buf.push(' class="');
                            if (isBEM) {
                                __$i316 = BEM_.INTERNAL;
                                __$i317 = "buildClasses";
                                __$i320 = this.block;
                                __$i323 = v.elem;
                                __$i326 = v.elemMods;
                                if (__$i326) {
                                    __$i335 = __$i326;
                                } else {
                                    __$i335 = v.mods;
                                }
                                __$i316[__$i317](__$i320, __$i323, __$i335, buf);
                                "";
                                __r18 = this._mode;
                                this._mode = "mix";
                                return apply.call(__this, __$fn211);
                            } else {
                                undefined;
                                return __$fn212.call(this);
                            }
                        } else {
                            undefined;
                            return __$fn213.call(this);
                        }
                    }
                    if (__$e) {
                        return __$callback.call(this, __$e);
                    } else {
                        __$r209 = __$r;
                    }
                    __r15 = __$r209;
                    this._mode = __r14;
                    "";
                    isBEM = __r15;
                    __$i213 = typeof isBEM != "undefined";
                    if (__$i213) {
                        __$i249 = __$i213;
                    } else {
                        if (typeof v.bem != "undefined") {
                            __$i244 = v.bem;
                        } else {
                            __$i231 = v.block;
                            if (__$i231) {
                                __$i240 = __$i231;
                            } else {
                                __$i240 = v.elem;
                            }
                            __$i244 = __$i240;
                        }
                        __$i249 = isBEM = __$i244;
                    }
                    "";
                    __r16 = this._mode;
                    this._mode = "cls";
                    return apply.call(__this, __$fn210);
                }
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r207 = __$r;
                }
                undefined;
                buf.push("<", tag);
                "";
                __r14 = this._mode;
                this._mode = "bem";
                return apply.call(__this, __$fn209);
            }
            var __$r206;
            function __$fn206(__$e, __$r) {
                if (__$e) {
                    return __$callback.call(this, __$e);
                } else {
                    __$r206 = __$r;
                }
                __r13 = __$r206;
                this._mode = __r12;
                "";
                js = __r13;
                if (js) {
                    __$i114 = this._;
                    __$i115 = "extend";
                    __$i118 = v.js;
                    if (js === true) {
                        __$i129 = {};
                    } else {
                        __$i129 = js;
                    }
                    __$i152 = __$i114[__$i115](__$i118, __$i129);
                } else {
                    if (v.js === true) {
                        __$i148 = {};
                    } else {
                        __$i148 = v.js;
                    }
                    __$i152 = __$i148;
                }
                js = __$i152;
                __$i155 = js;
                if (__$i155) {
                    __$i176 = (jsParams = {})[BEM_.INTERNAL.buildClass(this.block, v.elem)] = js;
                } else {
                    __$i176 = __$i155;
                }
                return __$fn207.call(this);
            }
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r205 = __$r;
            }
            __r9 = __$r205;
            this._mode = __r8;
            "";
            tag = __r9;
            __$i45 = typeof tag != "undefined";
            if (__$i45) {
                __$i55 = __$i45;
            } else {
                __$i55 = tag = v.tag;
            }
            __$i60 = typeof tag != "undefined";
            if (__$i60) {
                __$i68 = __$i60;
            } else {
                __$i68 = tag = "div";
            }
            if (tag) {
                __$i75 = this.block;
                if (__$i75) {
                    __$i86 = v.js !== false;
                } else {
                    __$i86 = __$i75;
                }
                if (__$i86) {
                    "";
                    __r12 = this._mode;
                    this._mode = "js";
                    return apply.call(__this, __$fn206);
                } else {
                    undefined;
                    return __$fn207.call(this);
                }
            } else {
                undefined;
                return __$fn208.call(this);
            }
        }
        var __r32;
        var __r31;
        var __r30;
        var __r29;
        var __r28;
        var isBEM;
        var content;
        var __$fi718;
        var name;
        var attrs;
        var jsAttr;
        var i, l, mixItem, hasItem, block;
        var mix;
        var addJSInitClass;
        var cls;
        var isBEM;
        var jsParams, js;
        var _this, BEM_, v, buf, tag;
        var __r18, __r8, __r12, __r13, __r14, __r15, __r16, __r17, __r9, __r19, __r22, __r23, __r24, __r25, __r26, __r27;
        var __this;
        __this = this;
        "enable spoon";
        _this = this;
        BEM_ = _this.BEM;
        v = this.ctx;
        buf = this._buf;
        "";
        __r8 = this._mode;
        this._mode = "tag";
        return apply.call(__this, __$fn205);
    }
    function $1255(__$callback) {
        var __$i43;
        var __$i30;
        var __$i20;
        var __$i11;
        var ctx;
        "enable spoon";
        this._listLength--;
        ctx = this.ctx;
        __$i11 = ctx;
        if (__$i11) {
            __$i20 = ctx !== true;
        } else {
            __$i20 = __$i11;
        }
        if (__$i20) {
            __$i30 = __$i20;
        } else {
            __$i30 = ctx === 0;
        }
        if (__$i30) {
            __$i43 = this._buf.push(ctx);
        } else {
            __$i43 = __$i30;
        }
        return __$callback.call(this, null);
    }
    function $1258(__$callback) {
        if (!!this._mode === false) {
            if (!!this.ctx === false) {
                return $1261.call(this, __$callback);
            } else {
                return $1264.call(this, __$callback);
            }
        } else {
            return $1264.call(this, __$callback);
        }
    }
    function $1261(__$callback) {
        "enable spoon";
        this._listLength--;
        return __$callback.call(this, null);
    }
    function $1264(__$callback) {
        if (!this._.isArray(this.ctx) === false) {
            if (!!this._mode === false) {
                return $1267.call(this, __$callback);
            } else {
                return $1270.call(this, __$callback);
            }
        } else {
            return $1270.call(this, __$callback);
        }
    }
    function $1267(__$callback) {
        var __$i96;
        var __$i86;
        var __$r20;
        function __$fn20(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r20 = __$r;
            }
            while (true) {
                if (!(i < l)) {
                    break;
                } else {
                    "";
                    __r7 = this.ctx;
                    this.ctx = v[i++];
                    return apply.call(__this, __$fn19);
                }
            }
            undefined;
            undefined;
            __$i86 = prevNotNewList;
            if (__$i86) {
                __$i96 = __$i86;
            } else {
                __$i96 = this.position = prevPos;
            }
            return __$callback.call(this, null);
        }
        var __$r19;
        function __$fn19(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r19 = __$r;
            }
            this.ctx = __r7;
            "";
            undefined;
            return __$fn20.call(this);
        }
        var __r7;
        var v, l, i, prevPos, prevNotNewList;
        var __this;
        __this = this;
        "enable spoon";
        v = this.ctx;
        l = v.length;
        i = 0;
        prevPos = this.position;
        prevNotNewList = this._notNewList;
        if (prevNotNewList) {
            this._listLength += l - 1;
        } else {
            this.position = 0;
            this._listLength = l;
        }
        undefined;
        this._notNewList = true;
        return __$fn20.call(this);
    }
    function $1270(__$callback) {
        if (!true === false) {
            if (!!this._mode === false) {
                return $1273.call(this, __$callback);
            } else {
                return $e.call(this, __$callback);
            }
        } else {
            return $e.call(this, __$callback);
        }
    }
    function $1273(__$callback) {
        var __$i212;
        var __$i199;
        var __$i188;
        var __$i189;
        var __$i192;
        var __$i185;
        var __$i176;
        var __$i171;
        var __$i158;
        var __$i159;
        var __$i164;
        var __$i150;
        var __$i142;
        var __$i126;
        var __$i127;
        var __$i105;
        var __$i96;
        var __$i87;
        var __$i88;
        var __$i89;
        var __$i79;
        var __$i75;
        var __$i61;
        var __$i62;
        var __$i63;
        var __$i44;
        var __$i34;
        var __$i29;
        var __$i20;
        var __$r50;
        function __$fn50(__$e, __$r) {
            if (__$e) {
                return __$callback.call(this, __$e);
            } else {
                __$r50 = __$r;
            }
            undefined;
            undefined;
            this._mode = __r0;
            this.block = __r1;
            this._currBlock = __r2;
            this.elem = __r3;
            this.mods = __r4;
            this.elemMods = __r5;
            "";
            undefined;
            return __$callback.call(this, null);
        }
        var __r5;
        var __r4;
        var __r3;
        var __r2;
        var __r1;
        var __r0;
        var vBlock, vElem, block;
        var __this;
        __this = this;
        "enable spoon";
        vBlock = this.ctx.block;
        vElem = this.ctx.elem;
        __$i20 = this._currBlock;
        if (__$i20) {
            __$i29 = __$i20;
        } else {
            __$i29 = this.block;
        }
        block = __$i29;
        __$i34 = this.ctx;
        if (__$i34) {
            __$i44 = __$i34;
        } else {
            __$i44 = this.ctx = {};
        }
        "";
        __r0 = this._mode;
        this._mode = "default";
        __r1 = this.block;
        __$i61 = this;
        __$i62 = "block";
        __$i63 = vBlock;
        if (__$i63) {
            __$i79 = __$i63;
        } else {
            if (vElem) {
                __$i75 = block;
            } else {
                __$i75 = undefined;
            }
            __$i79 = __$i75;
        }
        __$i61[__$i62] = __$i79;
        __r2 = this._currBlock;
        __$i87 = this;
        __$i88 = "_currBlock";
        __$i89 = vBlock;
        if (__$i89) {
            __$i96 = __$i89;
        } else {
            __$i96 = vElem;
        }
        if (__$i96) {
            __$i105 = undefined;
        } else {
            __$i105 = block;
        }
        __$i87[__$i88] = __$i105;
        __r3 = this.elem;
        this.elem = this.ctx.elem;
        __r4 = this.mods;
        __$i126 = this;
        __$i127 = "mods";
        if (vBlock) {
            __$i142 = this.ctx.mods;
        } else {
            __$i142 = this.mods;
        }
        if (__$i142) {
            __$i150 = __$i142;
        } else {
            __$i150 = {};
        }
        __$i126[__$i127] = __$i150;
        __r5 = this.elemMods;
        __$i158 = this;
        __$i159 = "elemMods";
        __$i164 = this.ctx.elemMods;
        if (__$i164) {
            __$i171 = __$i164;
        } else {
            __$i171 = {};
        }
        __$i158[__$i159] = __$i171;
        __$i176 = this.block;
        if (__$i176) {
            __$i185 = __$i176;
        } else {
            __$i185 = this.elem;
        }
        if (__$i185) {
            __$i188 = this;
            __$i189 = "position";
            __$i192 = this.position;
            if (__$i192) {
                __$i199 = __$i192;
            } else {
                __$i199 = 0;
            }
            __$i212 = __$i188[__$i189] = __$i199 + 1;
        } else {
            __$i212 = this._listLength--;
        }
        return apply.call(__this, __$fn50);
    }
    function $e(__$callback) {
        "enable spoon";
        throw new Error;
    }
    return exports;
})(typeof exports === "undefined" ? {} : exports);
BEMHTML = (function(xjst) { return function() { return xjst.apply.call([this]); }; }(BEMHTML));
typeof exports === "undefined" || (exports.BEMHTML = BEMHTML);

/* added by builder */
return BEMHTML;
}),
"bem": (function (require) { /* wrapped by builder */
/* added by builder */
var jQuery = require("$"),
    $ = require("$");

/* ../../lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: begin */ /**/
/**
 * Inheritance plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (dfilatov@yandex-team.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.3.3
 */

(function($) {

var hasIntrospection = (function(){_}).toString().indexOf('_') > -1,
    needCheckProps = $.browser.msie, // fucking ie hasn't toString, valueOf in for
    specProps = needCheckProps? ['toString', 'valueOf'] : null,
    emptyBase = function() {};

function override(base, result, add) {

    var hasSpecProps = false;
    if(needCheckProps) {
        var addList = [];
        $.each(specProps, function() {
            add.hasOwnProperty(this) && (hasSpecProps = true) && addList.push({
                name : this,
                val  : add[this]
            });
        });
        if(hasSpecProps) {
            $.each(add, function(name) {
                addList.push({
                    name : name,
                    val  : this
                });
            });
            add = addList;
        }
    }

    $.each(add, function(name, prop) {
        if(hasSpecProps) {
            name = prop.name;
            prop = prop.val;
        }
        if($.isFunction(prop) &&
           (!hasIntrospection || prop.toString().indexOf('.__base') > -1)) {

            var baseMethod = base[name] || function() {};
            result[name] = function() {
                var baseSaved = this.__base;
                this.__base = baseMethod;
                var result = prop.apply(this, arguments);
                this.__base = baseSaved;
                return result;
            };

        }
        else {
            result[name] = prop;
        }

    });

}

$.inherit = function() {

    var args = arguments,
        hasBase = $.isFunction(args[0]),
        base = hasBase? args[0] : emptyBase,
        props = args[hasBase? 1 : 0] || {},
        staticProps = args[hasBase? 2 : 1],
        result = props.__constructor || (hasBase && base.prototype.__constructor)?
            function() {
                return this.__constructor.apply(this, arguments);
            } : function() {};

    if(!hasBase) {
        result.prototype = props;
        result.prototype.__self = result.prototype.constructor = result;
        return $.extend(result, staticProps);
    }

    $.extend(result, base);

    var inheritance = function() {},
        basePtp = inheritance.prototype = base.prototype,
        resultPtp = result.prototype = new inheritance();

    resultPtp.__self = resultPtp.constructor = result;

    override(basePtp, resultPtp, props);
    staticProps && override(base, result, staticProps);

    return result;

};

$.inheritSelf = function(base, props, staticProps) {

    var basePtp = base.prototype;

    override(basePtp, basePtp, props);
    staticProps && override(base, base, staticProps);

    return base;

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__inherit/i-jquery__inherit.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: begin */ /**/
/**
 * Identify plugin
 *
 * @version 1.0.0
 */

(function($) {

var counter = 0,
    expando = '__' + (+new Date),
    get = function() {
        return 'uniq' + ++counter;
    };

/**
 * Makes unique ID
 * @param {Object} [obj] Object that needs to be identified
 * @param {Boolean} [onlyGet=false] Return a unique value only if it had already been assigned before
 * @returns {String} ID
 */
$.identify = function(obj, onlyGet) {

    if(!obj) return get();

    var key = 'uniqueID' in obj? 'uniqueID' : expando; // Use when possible. native uniqueID for elements in IE

    return onlyGet || key in obj?
        obj[key] :
        obj[key] = get();

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__identify/i-jquery__identify.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: begin */ /**/
(function($) {

$.isEmptyObject || ($.isEmptyObject = function(obj) {
        for(var i in obj) return false;
        return true;
    });

})(jQuery);
;
/* ../../lego/bem-bl/blocks-common/i-jquery/__is-empty-object/i-jquery__is-empty-object.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: begin */ /**/
/**
 * Debounce and throttle function's decorator plugin 1.0.6
 *
 * Copyright (c) 2009 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

(function($) {

$.extend({

    debounce : function(fn, timeout, invokeAsap, ctx) {

        if(arguments.length == 3 && typeof invokeAsap != 'boolean') {
            ctx = invokeAsap;
            invokeAsap = false;
        }

        var timer;

        return function() {

            var args = arguments;
            ctx = ctx || this;

            invokeAsap && !timer && fn.apply(ctx, args);

            clearTimeout(timer);

            timer = setTimeout(function() {
                invokeAsap || fn.apply(ctx, args);
                timer = null;
            }, timeout);

        };

    },

    throttle : function(fn, timeout, ctx) {

        var timer, args, needInvoke;

        return function() {

            args = arguments;
            needInvoke = true;
            ctx = ctx || this;

            timer || (function() {
                if(needInvoke) {
                    fn.apply(ctx, args);
                    needInvoke = false;
                    timer = setTimeout(arguments.callee, timeout);
                }
                else {
                    timer = null;
                }
            })();

        };

    }

});

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__debounce/i-jquery__debounce.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: begin */ /**/
/**
 * Observable plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.0.0
 * @requires $.identify
 * @requires $.inherit
 */

(function($) {

var storageExpando = '__' + +new Date + 'storage',
    getFnId = function(fn, ctx) {
        return $.identify(fn) + (ctx? $.identify(ctx) : '');
    },
    Observable = /** @lends $.observable.prototype */{

        /**
         * Builds full event name
         * @protected
         * @param {String} e Event type
         * @returns {String}
         */
        buildEventName : function(e) {

            return e;

        },

        /**
         * Adding event handler
         * @param {String} e Event type
         * @param {Object} [data] Additional data that the handler gets as e.data
         * @param {Function} fn Handler
         * @param {Object} [ctx] Handler context
         * @returns {$.observable}
         */
        on : function(e, data, fn, ctx, _special) {

            if(typeof e == 'string') {
                if($.isFunction(data)) {
                    ctx = fn;
                    fn = data;
                    data = undefined;
                }

                var id = getFnId(fn, ctx),
                    storage = this[storageExpando] || (this[storageExpando] = {}),
                    eList = e.split(' '),
                    i = 0,
                    eStorage;

                while(e = eList[i++]) {
                    e = this.buildEventName(e);
                    eStorage = storage[e] || (storage[e] = { ids : {}, list : {} });

                    if(!(id in eStorage.ids)) {
                        var list = eStorage.list,
                            item = { fn : fn, data : data, ctx : ctx, special : _special };
                        if(list.last) {
                            list.last.next = item;
                            item.prev = list.last;
                        } else {
                            list.first = item;
                        }

                        eStorage.ids[id] = list.last = item;
                    }
                }
            } else {
                var _this = this;
                $.each(e, function(e, fn) {
                    _this.on(e, fn, data, _special);
                });
            }

            return this;

        },

        onFirst : function(e, data, fn, ctx) {

            return this.on(e, data, fn, ctx, { one : true });

        },

        /**
         * Removing event handler(s)
         * @param {String} [e] Event type
         * @param {Function} [fn] Handler
         * @param {Object} [ctx] Handler context
         * @returns {$.observable}
         */
        un : function(e, fn, ctx) {

            if(typeof e == 'string' || typeof e == 'undefined') {
                var storage = this[storageExpando];
                if(storage) {
                    if(e) { // if event type was passed
                        var eList = e.split(' '),
                            i = 0,
                            eStorage;
                        while(e = eList[i++]) {
                            e = this.buildEventName(e);
                            if(eStorage = storage[e]) {
                                if(fn) {  // if specific handler was passed
                                    var id = getFnId(fn, ctx),
                                        ids = eStorage.ids;
                                    if(id in ids) {
                                        var list = eStorage.list,
                                            item = ids[id],
                                            prev = item.prev,
                                            next = item.next;

                                        if(prev) {
                                            prev.next = next;
                                        }
                                        else if(item === list.first) {
                                            list.first = next;
                                        }

                                        if(next) {
                                            next.prev = prev;
                                        }
                                        else if(item === list.last) {
                                            list.last = prev;
                                        }

                                        delete ids[id];
                                    }
                                } else {
                                    delete this[storageExpando][e];
                                }
                            }
                        }
                    } else {
                        delete this[storageExpando];
                    }
                }
            } else {
                var _this = this;
                $.each(e, function(e, fn) {
                    _this.un(e, fn, ctx);
                });
            }

            return this;

        },

        /**
         * Fires event handlers
         * @param {String|$.Event} e Event
         * @param {Object} [data] Additional data
         * @returns {$.observable}
         */
        trigger : function(e, data) {

            var _this = this,
                storage = _this[storageExpando],
                rawType;

            typeof e === 'string'?
                e = $.Event(_this.buildEventName(rawType = e)) :
                e.type = _this.buildEventName(rawType = e.type);

            e.target || (e.target = _this);

            if(storage && (storage = storage[e.type])) {
                var item = storage.list.first,
                    ret;
                while(item) {
                    e.data = item.data;
                    ret = item.fn.call(item.ctx || _this, e, data);
                    if(typeof ret !== 'undefined') {
                        e.result = ret;
                        if(ret === false) {
                            e.preventDefault();
                            e.stopPropagation();
                        }
                    }

                    item.special && item.special.one &&
                        _this.un(rawType, item.fn, item.ctx);
                    item = item.next;
                }
            }

            return this;

        }

    };

$.observable = $.inherit(Observable, Observable);

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__observable/i-jquery__observable.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/i-bem.js: begin */ /**/
/** @requires jquery.inherit */
/** @requires jquery.isEmptyObject */
/** @requires jquery.identify */
/** @requires jquery.observable */

(function($, undefined) {

/**
 * Storage for deferred functions
 * @private
 * @type Array
 */
var afterCurrentEventFns = [],

/**
 * Storage for block declarations (hash by block name)
 * @private
 * @type Object
 */
    blocks = {},

/**
 * Communication channels
 * @static
 * @private
 * @type Object
 */
    channels = {};

/**
 * Builds the name of the handler method for setting a modifier
 * @static
 * @private
 * @param {String} elemName Element name
 * @param {String} modName Modifier name
 * @param {String} modVal Modifier value
 * @returns {String}
 */
function buildModFnName(elemName, modName, modVal) {

    return (elemName? '__elem_' + elemName : '') +
           '__mod' +
           (modName? '_' + modName : '') +
           (modVal? '_' + modVal : '');

}

/**
 * Transforms a hash of modifier handlers to methods
 * @static
 * @private
 * @param {Object} modFns
 * @param {Object} props
 * @param {String} [elemName]
 */
function modFnsToProps(modFns, props, elemName) {

    $.isFunction(modFns)?
        (props[buildModFnName(elemName, '*', '*')] = modFns) :
        $.each(modFns, function(modName, modFn) {
            $.isFunction(modFn)?
                (props[buildModFnName(elemName, modName, '*')] = modFn) :
                $.each(modFn, function(modVal, modFn) {
                    props[buildModFnName(elemName, modName, modVal)] = modFn;
                });
        });

}

function buildCheckMod(modName, modVal) {

    return modVal?
        Array.isArray(modVal)?
            function(block) {
                var i = 0, len = modVal.length;
                while(i < len)
                    if(block.hasMod(modName, modVal[i++]))
                        return true;
                return false;
            } :
            function(block) {
                return block.hasMod(modName, modVal);
            } :
        function(block) {
            return block.hasMod(modName);
        };

}

/** @namespace */
this.BEM = $.inherit($.observable, /** @lends BEM.prototype */ {

    /**
     * @class Base block for creating BEM blocks
     * @constructs
     * @private
     * @param {Object} mods Block modifiers
     * @param {Object} params Block parameters
     * @param {Boolean} [initImmediately=true]
     */
    __constructor : function(mods, params, initImmediately) {

        var _this = this;

        /**
         * Cache of block modifiers
         * @private
         * @type Object
         */
        _this._modCache = mods || {};

        /**
         * Current modifiers in the stack
         * @private
         * @type Object
         */
        _this._processingMods = {};

        /**
         * The block's parameters, taking into account the defaults
         * @protected
         * @type Object
         */
        _this._params = params; // это нужно для правильной сборки параметров у блока из нескольких нод
        _this.params = null;

        initImmediately !== false?
            _this._init() :
            _this.afterCurrentEvent(function() {
                _this._init();
            });

    },

    /**
     * Initializes the block
     * @private
     */
    _init : function() {

        if(!this._initing && !this.hasMod('js', 'inited')) {
            this._initing = true;

            if(!this.params) {
                this.params = $.extend(this.getDefaultParams(), this._params);
                delete this._params;
            }

            this.setMod('js', 'inited');
            delete this._initing;
            this.hasMod('js', 'inited') && this.trigger('init');
        }

        return this;

    },

    /**
     * Changes the context of the function being passed
     * @protected
     * @param {Function} fn
     * @param {Object} [ctx=this] Context
     * @returns {Function} Function with a modified context
     */
    changeThis : function(fn, ctx) {

        return fn.bind(ctx || this);

    },

    /**
     * Executes the function in the context of the block, after the "current event"
     * @protected
     * @param {Function} fn
     * @param {Object} [ctx] Context
     */
    afterCurrentEvent : function(fn, ctx) {

        this.__self.afterCurrentEvent(this.changeThis(fn, ctx));

    },

    /**
     * Executes the block's event handlers and live event handlers
     * @protected
     * @param {String} e Event name
     * @param {Object} [data] Additional information
     * @returns {BEM}
     */
    trigger : function(e, data) {

        this
            .__base(e = this.buildEvent(e), data)
            .__self.trigger(e, data);

        return this;

    },

    buildEvent : function(e) {

        typeof e == 'string' && (e = $.Event(e));
        e.block = this;

        return e;

    },

    /**
     * Checks whether a block or nested element has a modifier
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {Boolean}
     */
    hasMod : function(elem, modName, modVal) {

        var len = arguments.length,
            invert = false;

        if(len == 1) {
            modVal = '';
            modName = elem;
            elem = undefined;
            invert = true;
        }
        else if(len == 2) {
            if(typeof elem == 'string') {
                modVal = modName;
                modName = elem;
                elem = undefined;
            }
            else {
                modVal = '';
                invert = true;
            }
        }

        var res = this.getMod(elem, modName) === modVal;
        return invert? !res : res;

    },

    /**
     * Returns the value of the modifier of the block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @returns {String} Modifier value
     */
    getMod : function(elem, modName) {

        var type = typeof elem;
        if(type === 'string' || type === 'undefined') { // elem either omitted or undefined
            modName = elem || modName;
            var modCache = this._modCache;
            return modName in modCache?
                modCache[modName] :
                modCache[modName] = this._extractModVal(modName);
        }

        return this._getElemMod(modName, elem);

    },

    /**
     * Returns the value of the modifier of the nested element
     * @private
     * @param {String} modName Modifier name
     * @param {Object} elem Nested element
     * @param {Object} [elem] Nested element name
     * @returns {String} Modifier value
     */
    _getElemMod : function(modName, elem, elemName) {

        return this._extractModVal(modName, elem, elemName);

    },

    /**
     * Returns values of modifiers of the block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} [modName1, ..., modNameN] Modifier names
     * @returns {Object} Hash of modifier values
     */
    getMods : function(elem) {

        var hasElem = elem && typeof elem != 'string',
            _this = this,
            modNames = [].slice.call(arguments, hasElem? 1 : 0),
            res = _this._extractMods(modNames, hasElem? elem : undefined);

        if(!hasElem) { // caching
            modNames.length?
                modNames.forEach(function(name) {
                    _this._modCache[name] = res[name];
                }):
                _this._modCache = res;
        }

        return res;

    },

    /**
     * Sets the modifier for a block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @returns {BEM}
     */
    setMod : function(elem, modName, modVal) {

        if(typeof modVal == 'undefined') {
            modVal = modName;
            modName = elem;
            elem = undefined;
        }

        var _this = this;

        if(!elem || elem[0]) {

            var modId = (elem && elem[0]? $.identify(elem[0]) : '') + '_' + modName;

            if(this._processingMods[modId]) return _this;

            var elemName,
                curModVal = elem?
                    _this._getElemMod(modName, elem, elemName = _this.__self._extractElemNameFrom(elem)) :
                    _this.getMod(modName);

            if(curModVal === modVal) return _this;

            this._processingMods[modId] = true;

            var needSetMod = true,
                modFnParams = [modName, modVal, curModVal];

            elem && modFnParams.unshift(elem);

            [['*', '*'], [modName, '*'], [modName, modVal]].forEach(function(mod) {
                needSetMod = _this._callModFn(elemName, mod[0], mod[1], modFnParams) !== false && needSetMod;
            });

            !elem && needSetMod && (_this._modCache[modName] = modVal);

            needSetMod && _this._afterSetMod(modName, modVal, curModVal, elem, elemName);

            delete this._processingMods[modId];
        }

        return _this;

    },

    /**
     * Function after successfully changing the modifier of the block/nested element
     * @protected
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {String} oldModVal Old modifier value
     * @param {Object} [elem] Nested element
     * @param {String} [elemName] Element name
     */
    _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {},

    /**
     * Sets a modifier for a block/nested element, depending on conditions.
     * If the condition parameter is passed: when true, modVal1 is set; when false, modVal2 is set.
     * If the condition parameter is not passed: modVal1 is set if modVal2 was set, or vice versa.
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal1 First modifier value
     * @param {String} [modVal2] Second modifier value
     * @param {Boolean} [condition] Condition
     * @returns {BEM}
     */
    toggleMod : function(elem, modName, modVal1, modVal2, condition) {

        if(typeof elem == 'string') { // if this is a block
            condition = modVal2;
            modVal2 = modVal1;
            modVal1 = modName;
            modName = elem;
            elem = undefined;
        }
        if(typeof modVal2 == 'undefined') {
            modVal2 = '';
        } else if(typeof modVal2 == 'boolean') {
            condition = modVal2;
            modVal2 = '';
        }

        var modVal = this.getMod(elem, modName);
        (modVal == modVal1 || modVal == modVal2) &&
            this.setMod(
                elem,
                modName,
                typeof condition === 'boolean'?
                    (condition? modVal1 : modVal2) :
                    this.hasMod(elem, modName, modVal1)? modVal2 : modVal1);

        return this;

    },

    /**
     * Removes a modifier from a block/nested element
     * @protected
     * @param {Object} [elem] Nested element
     * @param {String} modName Modifier name
     * @returns {BEM}
     */
    delMod : function(elem, modName) {

        if(!modName) {
            modName = elem;
            elem = undefined;
        }

        return this.setMod(elem, modName, '');

    },

    /**
     * Executes handlers for setting modifiers
     * @private
     * @param {String} elemName Element name
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {Array} modFnParams Handler parameters
     */
    _callModFn : function(elemName, modName, modVal, modFnParams) {

        var modFnName = buildModFnName(elemName, modName, modVal);
        return this[modFnName]?
           this[modFnName].apply(this, modFnParams) :
           undefined;

    },

    /**
     * Retrieves the value of the modifier
     * @private
     * @param {String} modName Modifier name
     * @param {Object} [elem] Element
     * @returns {String} Modifier value
     */
    _extractModVal : function(modName, elem) {

        return '';

    },

    /**
     * Retrieves name/value for a list of modifiers
     * @private
     * @param {Array} modNames Names of modifiers
     * @param {Object} [elem] Element
     * @returns {Object} Hash of modifier values by name
     */
    _extractMods : function(modNames, elem) {

        return {};

    },

    /**
     * Returns a named communication channel
     * @param {String} [id='default'] Channel ID
     * @param {Boolean} [drop=false] Destroy the channel
     * @returns {$.observable|undefined} Communication channel
     */
    channel : function(id, drop) {

        return this.__self.channel(id, drop);

    },

    /**
     * Returns a block's default parameters
     * @returns {Object}
     */
    getDefaultParams : function() {

        return {};

    },

    /**
     * Helper for cleaning up block properties
     * @param {Object} [obj=this]
     */
    del : function(obj) {

        var args = [].slice.call(arguments);
        typeof obj == 'string' && args.unshift(this);
        this.__self.del.apply(this.__self, args);
        return this;

	},

    /**
     * Deletes a block
     */
    destruct : function() {}

}, /** @lends BEM */{

    _name : 'i-bem',

    /**
     * Storage for block declarations (hash by block name)
     * @static
     * @protected
     * @type Object
     */
    blocks : blocks,

    /**
     * Declares blocks and creates a block class
     * @static
     * @protected
     * @param {String|Object} decl Block name (simple syntax) or description
     * @param {String} decl.block|decl.name Block name
     * @param {String} [decl.baseBlock] Name of the parent block
     * @param {String} [decl.modName] Modifier name
     * @param {String} [decl.modVal] Modifier value
     * @param {Object} [props] Methods
     * @param {Object} [staticProps] Static methods
     */
    decl : function(decl, props, staticProps) {

        if(typeof decl == 'string')
            decl = { block : decl };
        else if(decl.name) {
            decl.block = decl.name;
        }

        if(decl.baseBlock && !blocks[decl.baseBlock])
            throw('baseBlock "' + decl.baseBlock + '" for "' + decl.block + '" is undefined');

        props || (props = {});

        if(props.onSetMod) {
            modFnsToProps(props.onSetMod, props);
            delete props.onSetMod;
        }

        if(props.onElemSetMod) {
            $.each(props.onElemSetMod, function(elemName, modFns) {
                modFnsToProps(modFns, props, elemName);
            });
            delete props.onElemSetMod;
        }

        var baseBlock = blocks[decl.baseBlock || decl.block] || this;

        if(decl.modName) {
            var checkMod = buildCheckMod(decl.modName, decl.modVal);
            $.each(props, function(name, prop) {
                $.isFunction(prop) &&
                    (props[name] = function() {
                        var method;
                        if(checkMod(this)) {
                            method = prop;
                        } else {
                            var baseMethod = baseBlock.prototype[name];
                            baseMethod && baseMethod !== props[name] &&
                                (method = this.__base);
                        }
                        return method?
                            method.apply(this, arguments) :
                            undefined;
                    });
            });
        }

        var block;
        decl.block == baseBlock._name?
            // makes a new "live" if the old one was already executed
            (block = $.inheritSelf(baseBlock, props, staticProps))._processLive(true) :
            (block = blocks[decl.block] = $.inherit(baseBlock, props, staticProps))._name = decl.block;

        return block;

    },

    /**
     * Processes a block's live properties
     * @private
     * @param {Boolean} [heedLive=false] Whether to take into account that the block already processed its live properties
     * @returns {Boolean} Whether the block is a live block
     */
    _processLive : function(heedLive) {

        return false;

    },

    /**
     * Factory method for creating an instance of the block named
     * @static
     * @param {String|Object} block Block name or description
     * @param {Object} [params] Block parameters
     * @returns {BEM}
     */
    create : function(block, params) {

        typeof block == 'string' && (block = { block : block });

        return new blocks[block.block](block.mods, params);

    },

    /**
     * Returns the name of the current block
     * @static
     * @protected
     * @returns {String}
     */
    getName : function() {

        return this._name;

    },

    /**
     * Retrieves the name of an element nested in a block
     * @static
     * @private
     * @param {Object} elem Nested element
     * @returns {String|undefined}
     */
    _extractElemNameFrom : function(elem) {},

    /**
     * Adds a function to the queue for executing after the "current event"
     * @static
     * @protected
     * @param {Function} fn
     * @param {Object} ctx
     */
    afterCurrentEvent : function(fn, ctx) {

        afterCurrentEventFns.push({ fn : fn, ctx : ctx }) == 1 &&
            setTimeout(this._runAfterCurrentEventFns, 0);

    },

    /**
     * Executes the queue
     * @private
     */
    _runAfterCurrentEventFns : function() {

        var fnsLen = afterCurrentEventFns.length;
        if(fnsLen) {
            var fnObj,
                fnsCopy = afterCurrentEventFns.splice(0, fnsLen);

            while(fnObj = fnsCopy.shift()) fnObj.fn.call(fnObj.ctx || this);
        }

    },

    /**
     * Changes the context of the function being passed
     * @protected
     * @param {Function} fn
     * @param {Object} ctx Context
     * @returns {Function} Function with a modified context
     */
    changeThis : function(fn, ctx) {

        return fn.bind(ctx || this);

    },

    /**
     * Helper for cleaning out properties
     * @param {Object} [obj=this]
     */
    del : function(obj) {

        var delInThis = typeof obj == 'string',
            i = delInThis? 0 : 1,
            len = arguments.length;
        delInThis && (obj = this);

        while(i < len) delete obj[arguments[i++]];

        return this;

	},

    /**
     * Returns/destroys a named communication channel
     * @param {String} [id='default'] Channel ID
     * @param {Boolean} [drop=false] Destroy the channel
     * @returns {$.observable|undefined} Communication channel
     */
    channel : function(id, drop) {

        if(typeof id == 'boolean') {
            drop = id;
            id = undefined;
        }

        id || (id = 'default');

        if(drop) {
            if(channels[id]) {
                channels[id].un();
                delete channels[id];
            }
            return;
        }

        return channels[id] || (channels[id] = new $.observable());

    }

});

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-bem/i-bem.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: begin */ /**/
(function() {

/**
 * Возвращает массив свойств объекта
 * @param {Object} obj объект
 * @returns {Array}
 */
Object.keys || (Object.keys = function(obj) {
    var res = [];

    for(var i in obj) obj.hasOwnProperty(i) &&
        res.push(i);

    return res;
});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__object/i-ecma__object.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: begin */ /**/
(function() {

var ptp = Array.prototype,
    toStr = Object.prototype.toString,
    methods = {

        /**
         * Finds the index of an element in an array
         * @param {Object} item
         * @param {Number} [fromIdx] Starting from index (length - 1 - fromIdx, if fromIdx < 0)
         * @returns {Number} Element index or -1, if not found
         */
        indexOf : function(item, fromIdx) {

            fromIdx = +(fromIdx || 0);

            var t = this, len = t.length;

            if(len > 0 && fromIdx < len) {
                fromIdx = fromIdx < 0? Math.ceil(fromIdx) : Math.floor(fromIdx);
                fromIdx < -len && (fromIdx = 0);
                fromIdx < 0 && (fromIdx = fromIdx + len);

                while(fromIdx < len) {
                    if(fromIdx in t && t[fromIdx] === item)
                        return fromIdx;
                    ++fromIdx;
                }
            }

            return -1;

        },

        /**
         * Calls the callback for each element
         * @param {Function} callback Called for each element
         * @param {Object} [ctx=null] Callback context
         */
        forEach : function(callback, ctx) {

            var i = -1, t = this, len = t.length;
            while(++i < len) i in t &&
                (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));

        },

        /**
         * Creates array B from array A so that B[i] = callback(A[i])
         * @param {Function} callback Called for each element
         * @param {Object} [ctx=null] Callback context
         * @returns {Array}
         */
        map : function(callback, ctx) {

            var i = -1, t = this, len = t.length,
                res = new Array(len);

            while(++i < len) i in t &&
                (res[i] = ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t));

            return res;

        },

        /**
         * Creates an array containing only the elements from the source array that the callback returns true for. 
         * @param {Function} callback Called for each element
         * @param {Object} [ctx] Callback context
         * @returns {Array}
         */
        filter : function(callback, ctx) {

            var i = -1, t = this, len = t.length,
                res = [];

            while(++i < len) i in t &&
                (ctx? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)) && res.push(t[i]);

            return res;

        },

        /**
         * Wraps the array using an accumulator
         * @param {Function} callback Called for each element
         * @param {Object} [initialVal] Initial value of the accumulator
         * @returns {Object} Accumulator
         */
        reduce : function(callback, initialVal) {

            var i = -1, t = this, len = t.length,
                res;

            if(arguments.length < 2) {
                while(++i < len) {
                    if(i in t) {
                        res = t[i];
                        break;
                    }
                }
            }
            else {
                res = initialVal;
            }

            while(++i < len) i in t &&
                (res = callback(res, t[i], i, t));

            return res;

        },

        /**
         * Checks whether at least one element in the array meets the condition in the callback
         * @param {Function} callback
         * @param {Object} [ctx=this] Callback context
         * @returns {Boolean}
         */
        some : function(callback, ctx) {

            var i = -1, t = this, len = t.length;

            while(++i < len)
                if(i in t && (ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                    return true;

            return false;

        },

        /**
         * Checks whether every element in the array meets the condition in the callback
         * @param {Function} callback
         * @param {Object} [ctx=this] Context of the callback call
         * @returns {Boolean}
         */
        every : function(callback, ctx) {

            var i = -1, t = this, len = t.length;

            while(++i < len)
                if(i in t && !(ctx ? callback.call(ctx, t[i], i, t) : callback(t[i], i, t)))
                    return false;

            return true;

        }

    };

for(var name in methods)
    ptp[name] || (ptp[name] = methods[name]);

Array.isArray || (Array.isArray = function(obj) {
    return toStr.call(obj) === '[object Array]';
});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__array/i-ecma__array.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: begin */ /**/
(function() {

var slice = Array.prototype.slice;

Function.prototype.bind || (Function.prototype.bind = function(ctx) {

    var fn = this,
        args = slice.call(arguments, 1);

    return function () {
        return fn.apply(ctx, args.concat(slice.call(arguments)));
    }

});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__function/i-ecma__function.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: begin */ /**/
/** @fileOverview Module for internal BEM helpers */
/** @requires BEM */

(function(BEM, $, undefined) {

/**
 * Separator for modifiers and their values
 * @const
 * @type String
 */
var MOD_DELIM = '_',

/**
 * Separator between names of a block and a nested element
 * @const
 * @type String
 */
    ELEM_DELIM = '__',

/**
 * Pattern for acceptable element and modifier names
 * @const
 * @type String
 */
    NAME_PATTERN = '[a-zA-Z0-9-]+';

function buildModPostfix(modName, modVal, buffer) {

    buffer.push(MOD_DELIM, modName, MOD_DELIM, modVal);

}

function buildBlockClass(name, modName, modVal, buffer) {

    buffer.push(name);
    modVal && buildModPostfix(modName, modVal, buffer);

}

function buildElemClass(block, name, modName, modVal, buffer) {

    buildBlockClass(block, undefined, undefined, buffer);
    buffer.push(ELEM_DELIM, name);
    modVal && buildModPostfix(modName, modVal, buffer);

}

BEM.INTERNAL = {

    NAME_PATTERN : NAME_PATTERN,

    MOD_DELIM : MOD_DELIM,
    ELEM_DELIM : ELEM_DELIM,

    buildModPostfix : function(modName, modVal, buffer) {

        var res = buffer || [];
        buildModPostfix(modName, modVal, res);
        return buffer? res : res.join('');

    },

    /**
     * Builds the class of a block or element with a modifier
     * @private
     * @param {String} block Block name
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @param {Array} [buffer] Buffer
     * @returns {String|Array} Class or buffer string (depending on whether the buffer parameter is present)
     */
    buildClass : function(block, elem, modName, modVal, buffer) {

        var typeOf = typeof modName;
        if(typeOf == 'string') {
            if(typeof modVal != 'string') {
                buffer = modVal;
                modVal = modName;
                modName = elem;
                elem = undefined;
            }
        } else if(typeOf != 'undefined') {
            buffer = modName;
            modName = undefined;
        } else if(elem && typeof elem != 'string') {
            buffer = elem;
            elem = undefined;
        }

        if(!(elem || modName || buffer)) { // оптимизация для самого простого случая
            return block;
        }

        var res = buffer || [];

        elem?
            buildElemClass(block, elem, modName, modVal, res) :
            buildBlockClass(block, modName, modVal, res);

        return buffer? res : res.join('');

    },

    /**
     * Builds full classes for a buffer or element with modifiers
     * @private
     * @param {String} block Block name
     * @param {String} [elem] Element name
     * @param {Object} [mods] Modifiers
     * @param {Array} [buffer] Buffer
     * @returns {String|Array} Class or buffer string (depending on whether the buffer parameter is present)
     */
    buildClasses : function(block, elem, mods, buffer) {

        if(elem && typeof elem != 'string') {
            buffer = mods;
            mods = elem;
            elem = undefined;
        }

        var res = buffer || [];

        elem?
            buildElemClass(block, elem, undefined, undefined, res) :
            buildBlockClass(block, undefined, undefined, res);

        mods && $.each(mods, function(modName, modVal) {
            if(modVal) {
                res.push(' ');
                elem?
                    buildElemClass(block, elem, modName, modVal, res) :
                    buildBlockClass(block, modName, modVal, res);
            }
        });

        return buffer? res : res.join('');

        /*var typeOf = typeof elem;
        if(typeOf != 'string' && typeOf != 'undefined') {
            buffer = mods;
            mods = elem;
            elem = undefined;
        }
        if($.isArray(mods)) {
            buffer = mods;
            mods = undefined;
        }

        var res = buffer || [];
        buildClasses(block, elem, mods, res);
        return buffer? res : res.join('');*/

    }

}

})(BEM, jQuery);;
/* ../../lego/bem-bl/blocks-common/i-bem/__internal/i-bem__internal.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: begin */ /**/
/**
 * Cookie plugin
 *
 * Copyright (c) 2006 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

/**
 * Create a cookie with the given name and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String name The name of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given name.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String name The name of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};;
/* ../../lego/bem-bl/blocks-common/i-jquery/__cookie/i-jquery__cookie.js: end */ /**/

/* ../../lego/blocks-desktop/i-bem/html/i-bem__html.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.INTERNAL */
/** @requires jquery.stringify */

(function(BEM, $, undefined) {

var INTERNAL = BEM.INTERNAL,
    ELEM_DELIM = INTERNAL.ELEM_DELIM,
    SHORT_TAGS = { // хэш для быстрого определения, является ли тэг коротким
        area : 1, base : 1, br : 1, col : 1, command : 1, embed : 1, hr : 1, img : 1,
        input : 1, keygen : 1, link : 1, meta : 1, param : 1, source : 1, wbr : 1 },
    buildClass = INTERNAL.buildClass,
    buildClasses = INTERNAL.buildClasses,
    decls = {};

function addPropToDecl(decl, name, fn) {

    (decl[name] || (decl[name] = [])).unshift(fn);

}

function buildDeclFn(fn, desc) {

    return desc.modName?
        function(ctx) {
            (ctx._curBlock.mods || {})[desc.modName] === desc.modVal && fn(ctx);
        } :
        fn;

}

function join(a, b) {

    var isArrayB = $.isArray(b),
        res;

    $.isArray(a)?
        isArrayB? res = a.concat(b) : (res = a).push(b) :
        isArrayB? (res = b).unshift(a) : res = [a, b];

    return res;

}

var attrEscapes = { '"': '&quot;', '&': '&amp;', '<': '&lt;', '>': '&gt;' },
    attrEscapesRE = /["&<>]/g;
function escapeAttr(attrVal) {
    return attrVal.replace(attrEscapesRE, function(needToEscape) {
        return attrEscapes[needToEscape];
    });
}

/**
 * @namespace
 * @name BEM.HTML
 */
BEM.HTML = {

    /**
     * Декларация
     * @protected
     * @param {String|Object} decl имя блока (простой синтаксис) или описание
     * @param {String} decl.block имя блока
     * @param {String} [decl.modName] имя модификатора
     * @param {String} [decl.modVal] значение модификатора
     * @param {Object} props свойства
     */
    decl : function(desc, props) {

        typeof desc == 'string' && (desc = { block : desc });
        desc.name && (desc.block = desc.name);

        var decl = decls[desc.block] || (decls[desc.block] = {});

        props.onBlock && addPropToDecl(decl, '_block', buildDeclFn(props.onBlock, desc));

        if(props.onElem) {
            $.isFunction(props.onElem)?
                addPropToDecl(decl, '_elem', buildDeclFn(props.onElem, desc)) :
                $.each(props.onElem, function(elem, fn) {
                    addPropToDecl(decl, '_elem' + (elem === '*'? '' : ELEM_DELIM + elem), buildDeclFn(fn, desc));
                });
        }

    },

    /**
     * Строит HTML-представление
     * @param {Object|Array} params JSON-описание
     */
    build : function(params) {

        var builder = new this.Ctx(params);
        builder._buildAll();
        return builder._flush();

    },

    Ctx : $.inherit(/** @lends BEM.HTML.Ctx.prototype */{
        /**
         * @class Внутренний класс контекста билдера HTML-представления
         * @constructs
         * @param {Object|Array|String} params параметры
         */
        __constructor : function(params) {

            /**
             * буфер
             * @private
             * @type Array
             */
            this._buffer = [];

            /**
             * текущие параметры
             * @private
             * @type Object
             */
            this._params = params;

            /**
             * туннелированные параметры
             * @private
             * @type Object
             */
            this._tParams = null;

            this._tParamsChanges = null;

            /**
             * имя текущего блока
             * @private
             * @type String
             */
            this._curBlock = undefined;

        },

        /**
         * Возвращает позицию контекста
         * @returns {Number}
         */
        pos : function() {

            return this._params._pos;

        },

        /**
         * Проверяет, является ли текущий контекст первым
         * @returns {Boolean}
         */
        isFirst : function() {

            return this._params._pos === 1;

        },

        /**
         * Проверяет, является ли текущий контекст последним
         * @returns {Boolean}
         */
        isLast : function() {

            var params = this._params;
            return params._pos === params._siblingsCount;

        },

        /**
         * Возвращает/устанавливает параметры контекста
         * @param {Object} [params] параметры
         */
        params : function(params) {

            var _this = this;
            if(typeof params == 'undefined') return _this._params;

            _this._params = params;
            return _this;

        },

        /**
         * Возвращает/устанавливает один параметр контекста
         * @param {String} name имя параметра
         * @param {String} [val] значение параметра
         * @param {Boolean} [force=false] установить параметр независимо от его наличия в контексте
         * @param {Boolean} [needExtend=false] расширять параметр
         */
        param : function(name, val, force, needExtend) {

            var _this = this,
                params = _this._params;

            if(typeof val == 'undefined') return params[name];

            if(force || !(name in params)) {
                params[name] = val;
            } else if(needExtend) {
                params[name] = $.extend(val, params[name]);
            }

            return _this;

        },

        /**
         * Возвращает/устанавливает html-атрибуты контекста (шорткат к params('attrs', val))
         * @param {Object} [val] хэш атрибутов
         * @param {Boolean} [force=false]
         */
        attrs : function(val, force) {

            return this.param('attrs', val, force, true);

        },

        /**
         * Возвращает/устанавливает один html-атрибут контекста
         * @param {String} name имя атрибута
         * @param {String} [val] значение атрибута
         * @param {Boolean} [force=false]
         */
        attr : function(name, val, force) {

            var _this = this;
            if(typeof val == 'undefined') return (_this._params.attrs || {})[name];

            var attrs = _this._params.attrs;
            attrs?
                (force || !(name in attrs)) && (attrs[name] = val) :
                (_this._params.attrs = {})[name] = val;

            return _this;

        },

        /**
         * Возвращает/устанавливает имя html-тэга контекста (шорткат к params('tag', val))
         * @param {String} [val] тэг
         * @param {Boolean} [force=false]
         */
        tag : function(val, force) {

            return this.param('tag', val, force);

        },

        /**
         * Возвращает/устанавливает дополнительные CSS-классы контекста (шорткат к params('cls', val))
         * @param {String} [val] CSS-класс
         * @param {Boolean} [force=false]
         */
        cls : function(val, force) {

            return this.param('cls', val, force);

        },

        /**
         * Возвращает/устанавливает модификаторы контекста (шорткат к params('mods', val))
         * @param {Object} [val] хэш модификаторов
         * @param {Boolean} [force=false]
         */
        mods : function(val, force) {

            return this.param('mods', val, force, true);

        },

        /**
         * Возвращает/устанавливает один модификатор контекста
         * @param {String} name имя модификатора
         * @param {String} [val] значение модификатора
         * @param {Boolean} [force=false]
         */
        mod : function(name, val, force) {

            var _this = this;
            if(typeof val == 'undefined') return (_this._params.mods || {})[name];

            var mods = _this._params.mods;
            mods?
                (force || !(name in mods)) && (mods[name] = val) :
                (_this._params.mods = {})[name] = val;

            return _this;

        },

        /**
         * Возвращает/добавляет/устанавливает миксы
         * @param {Array} [val] миксы
         * @param {Boolean} [force=false]
         */
        mix : function(val, force) {

            var _this = this,
                params = _this._params;

            if(typeof val == 'undefined') return params.mix;

            if(force || !('mix' in params)) {
                params.mix = val;
            } else {
                params.mix = params.mix.concat(val);
            }

            return _this;

        },

        /**
         * Возвращает/устанавливает js-параметры контекста (шорткат к params('js', val))
         * @param {Boolean|Object} [val] параметры
         */
        js : function(val) {

            return this.param('js', val);

        },

        /**
         * Возвращает/устанавливает контент контекста (шорткат к params('content', val))
         * @param {String|Object|Array} [val] контент
         * @param {Boolean} [force=false] установить контент независимо от его наличия
         */
        content : function(val, force) {

            return this.param('content', val, force);

        },

        /**
         * Оборачивает контент контекста (например, другим элементом)
         * @param {Object} obj
         */
        wrapContent : function(obj) {

            var _this = this,
                params = _this._params;

            obj.content = params.content;
            params.content = obj;

            return _this;

        },

        /**
         * Добавляет контент перед контентом контекста (например, еще один элемент)
         * @param {Object|Array} obj
         */
        beforeContent : function(obj) {

            var _this = this,
                params = _this._params;

            params.content = join(obj, params.content);

            return _this;

        },

        /**
         * Добавляет контент после контента контекста (например, еще один элемент)
         * @param {Object|Array} obj
         */
        afterContent : function(obj) {

            var _this = this,
                params = _this._params;

            params.content = join(params.content, obj);

            return _this;

        },

        /**
         * Оборачивает контекста (например, другим элементом или блоком)
         * @param {Object} obj
         */
        wrap : function(obj) {

            var _this = this,
                params = _this._params;

            obj.block || (obj._curBlock = _this._curBlock);
            obj.content = params._wrapper? params._wrapper : params;
            params._wrapper = obj;

            return _this;

        },

        /**
         * Возвращает/устанавливает один туннелированный параметр контекста
         * @param {String} name имя параметра
         * @param {String} [val] значение параметра
         */
        tParam : function(name, val) {

            var _this = this,
                tParams = _this._tParams || (_this._tParams = {});

            if(typeof val == 'undefined') return tParams[name];

            var tParamsChanges = _this._tParamsChanges || (_this._tParamsChanges = {});

            name in tParamsChanges || (tParamsChanges[name] = tParams[name]);

            tParams[name] = val;

            return _this;

        },

        /**
         * Генерирует уникальный идентификатор
         * returns {String}
         */
        generateId : function() {

            return $.identify();

        },

        /**
         * Останавливает применение более базовых шаблонов
         */
        stop : function() {

            this._params._isStopped = true;

        },

        /**
         * Выполняет одну итерацию билда в зависимости от типа контекста
         * @private
         */
        _buildAll : function() {

            var _this = this,
                buffer = _this._buffer,
                params = _this._params,
                paramsType = typeof params;

            if(paramsType == 'string' || paramsType == 'number') {
                buffer.push(params);
            } else if($.isArray(params)) {
                var i = 0, len = params.length, currParams, currParamsType;
                while(i < len) {
                     _this._params = currParams = params[i++];
                    currParamsType = typeof currParams;
                    if(currParamsType == 'string' || currParamsType == 'number') {
                        buffer.push(currParams);
                    } else if(currParams) {
                        currParams._pos = i;
                        currParams._siblingsCount = len;
                        _this._buildByDecl();
                    }
                }
            } else if(params) {
                _this._params._pos = _this._params._siblingsCount = 1;
                _this._buildByDecl();
            }

        },

        /**
         * Дефолтный билд
         * @private
         */
        _build : function() {

            var _this = this,
                buffer = _this._buffer,
                params = _this._params,
                tag = params.tag || 'div',
                jsParams,
                isBEM = params.block || params.elem,
                curBlock = isBEM && (params.block || _this._curBlock.block),
                addInitingCls = false;

            if(params.js) {
                (jsParams = {})[buildClass(curBlock, params.elem)] = params.js === true? {} : params.js;
                addInitingCls = !params.elem;
            }

            buffer.push('<', tag);

            if(isBEM || params.cls) {
                buffer.push(' class="');
                if(isBEM) {
                    buildClasses(curBlock, params.elem, params.mods, buffer);
                    params.mix && $.each(params.mix, function(i, mix) {
                        if(mix) {
                            buffer.push(' ');
                            buildClasses(mix.block, mix.elem, mix.mods, buffer);
                            if(mix.js) {
                                (jsParams || (jsParams = {}))[buildClass(mix.block, mix.elem)] = mix.js === true? {} : mix.js;
                                addInitingCls || (addInitingCls = !mix.elem);
                            }
                        }
                    });
                }

                params.cls && buffer.push(isBEM? ' ' : '', params.cls);

                addInitingCls && buffer.push(' i-bem');
                buffer.push('"');
            }

            jsParams && buffer.push(
                ' onclick="return ',
                escapeAttr(JSON.stringify(jsParams)),
                '"');

            params.attrs && $.each(params.attrs, function(name, val) {
                typeof val != 'undefined' && val !== null && val !== false && buffer.push(
                    ' ',
                    name,
                    '="',
                    val.toString().replace(/"/g, "&quot;"),
                    '"');
            });

            if(SHORT_TAGS[tag]) {
                buffer.push('/>');
            } else {
                buffer.push('>');

                if(typeof params.content != 'undefined') {
                    _this._params = params.content;
                    _this._buildAll();
                }

                buffer.push('</', tag, '>');
            }

        },

        /**
         * Очищает буфер и возвращает его содержимое
         * @private
         * @returns {String} содержимое буфера
         */
        _flush : function() {

            var res = this._buffer.join('');
            delete this._buffer;
            return res;

        },

        _buildByDecl : function() {

            var _this = this,
                currBlock = _this._curBlock,
                params = _this._params;

            params._curBlock && (_this._curBlock = params._curBlock);
            params.block && (_this._curBlock = params);

            if(!params._wrapper) {
                if(params.block || params.elem) {
                    var decl = decls[_this._curBlock.block];
                    if(decl) {
                        var fns;
                        if(params.elem) {
                            fns = decl['_elem' + ELEM_DELIM + params.elem];
                            decl._elem && (fns = (fns? fns.concat(decl._elem) : decl._elem));
                        } else {
                            fns = decl._block;
                        }

                        if(fns) {
                            var i = 0, fn;
                            while(fn = fns[i++]) {
                                fn(_this);
                                if(params._isStopped) break;
                            }
                        }
                    }
                }

                if(params._wrapper) {
                    params._curBlock = _this._curBlock;
                    _this._params = params._wrapper;
                    return _this._buildAll();
                }
            }

            var tParamsChanges = _this._tParamsChanges;
                _this._tParamsChanges = null;

            _this._build();

            _this._curBlock = currBlock;

            if(tParamsChanges) {
                var tParams = _this._tParams;
                $.each(tParamsChanges, function(name, val) {
                    typeof val == 'undefined'?
                        delete tParams[name] :
                        tParams[name] = val;
                });
            }

        }

    })

};

})(BEM, jQuery);
;
/* ../../lego/blocks-desktop/i-bem/html/i-bem__html.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: begin */ /**/
(function(undefined) {

if(window.JSON) return;

var _toString = Object.prototype.toString,
    escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
    meta = {
        '\b' : '\\b',
        '\t' : '\\t',
        '\n' : '\\n',
        '\f' : '\\f',
        '\r' : '\\r',
        '"'  : '\\"',
        '\\' : '\\\\'
    },
    stringify;

window.JSON = {
    stringify : stringify = function(val) {
        if(val === null) {
            return 'null';
        }
        if(typeof val === 'undefined') {
            return undefined;
        }
        switch(_toString.call(val)) {
            case '[object String]':
                return '"' +
                    (escapable.test(val)?
                        val.replace(escapable, function(a) {
                            var c = meta[a];
                            return typeof c === 'string'? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                        }) :
                        val) +
                    '"';
            case '[object Number]':
            case '[object Boolean]':
                return '' + val;
            case '[object Array]':
                var res = '[', i = 0, len = val.length, strVal;
                while(i < len) {
                    strVal = stringify(val[i]);
                    res += (i++? ',' : '') + (typeof strVal === 'undefined'? 'null' : strVal);
                }
                return res + ']';
            case '[object Object]':
                var res = '{', i = 0, strVal;
                for(var key in val) {
                    if(val.hasOwnProperty(key)) {
                        strVal = stringify(val[key]);
                        typeof strVal !== 'undefined' && (res += (i++? ',' : '') + '"' + key + '":' + strVal);
                    }
                }
                return res + '}';
            default:
                return undefined;
        }
    }
};
})();
;
/* ../../lego/bem-bl/blocks-common/i-ecma/__json/i-ecma__json.js: end */ /**/

/* ../../blocks-desktop/i-ecma/__json/i-ecma__json.js: begin */ /**/
(function(undefined) {

if(window.JSON) return;

var _toString = Object.prototype.toString,
    escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
    meta = {
        '\b' : '\\b',
        '\t' : '\\t',
        '\n' : '\\n',
        '\f' : '\\f',
        '\r' : '\\r',
        '"'  : '\\"',
        '\\' : '\\\\'
    },
    stringify;

window.JSON = {
    stringify : stringify = function(val) {
        if(val === null) {
            return 'null';
        }
        if(typeof val === 'undefined') {
            return undefined;
        }
        switch(_toString.call(val)) {
            case '[object String]':
                escapable.lastIndex = 0;
                return '"' +
                    (escapable.test(val)?
                        val.replace(escapable, function(a) {
                            var c = meta[a];
                            return typeof c === 'string'? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                        }) :
                        val) +
                    '"';
            case '[object Number]':
            case '[object Boolean]':
                return '' + val;
            case '[object Array]':
                var res = '[', i = 0, len = val.length, strVal;
                while(i < len) {
                    strVal = stringify(val[i]);
                    res += (i++? ',' : '') + (typeof strVal === 'undefined'? 'null' : strVal);
                }
                return res + ']';
            case '[object Object]':
                var res = '{', i = 0, strVal;
                for(var key in val) {
                    if(val.hasOwnProperty(key)) {
                        strVal = stringify(val[key]);
                        typeof strVal !== 'undefined' && (res += (i++? ',' : '') + '"' + key + '":' + strVal);
                    }
                }
                return res + '}';
            default:
                return undefined;
        }
    }
};
})();
;
/* ../../blocks-desktop/i-ecma/__json/i-ecma__json.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.INTERNAL */

(function(BEM, $, undefined) {

var win = $(window),
    doc = $(document),

/**
 * Storage for DOM elements by unique key
 * @private
 * @type Object
 */
    uniqIdToDomElems = {},

/**
 * Storage for blocks by unique key
 * @static
 * @private
 * @type Object
 */
    uniqIdToBlock = {},

/**
 * Storage for block parameters
 * @private
 * @type Object
 */
    domElemToParams = {},

/**
 * Storage for liveCtx event handlers 
 * @private
 * @type Object
 */
    liveEventCtxStorage = {},

/**
 * Storage for liveClass event handlers
 * @private
 * @type Object
 */
    liveClassEventStorage = {},

    blocks = BEM.blocks,

    INTERNAL = BEM.INTERNAL,

    NAME_PATTERN = INTERNAL.NAME_PATTERN,

    MOD_DELIM = INTERNAL.MOD_DELIM,
    ELEM_DELIM = INTERNAL.ELEM_DELIM,

    buildModPostfix = INTERNAL.buildModPostfix,
    buildClass = INTERNAL.buildClass;

/**
 * Initializes blocks on a DOM element
 * @private
 * @param {jQuery} domElem DOM element
 * @param {String} uniqInitId ID of the "initialization wave"
 */
function init(domElem, uniqInitId) {

    var domNode = domElem[0];
    $.each(getParams(domNode), function(blockName, params) {
        processParams(params, domNode, blockName, uniqInitId);
        var block = uniqIdToBlock[params.uniqId];
        if(block) {
            if(block.domElem.index(domNode) < 0) {
                block.domElem = block.domElem.add(domElem);
                $.extend(block._params, params);
            }
        } else {
            initBlock(blockName, domElem, params);
        }
    });

}

/**
 * Initializes a specific block on a DOM element, or returns the existing block if it was already created
 * @private
 * @param {String} blockName Block name
 * @param {jQuery} domElem DOM element
 * @param {Object} [params] Initialization parameters
 * @param {Boolean} [forceLive] Force live initialization
 * @param {Function} [callback] Handler to call after complete initialization
 */
function initBlock(blockName, domElem, params, forceLive, callback) {

    if(typeof params == 'boolean') {
        callback = forceLive;
        forceLive = params;
        params = undefined;
    }

    var domNode = domElem[0];
    params = processParams(params || getParams(domNode)[blockName], domNode, blockName);

    var uniqId = params.uniqId;
    if(uniqIdToBlock[uniqId]) {
        return uniqIdToBlock[uniqId]._init();
    }

    uniqIdToDomElems[uniqId] = uniqIdToDomElems[uniqId]?
        uniqIdToDomElems[uniqId].add(domElem) :
        domElem;

    var parentDomNode = domNode.parentNode;
    if(!parentDomNode || parentDomNode.nodeType === 11) { // jquery doesn't unique disconnected node
        $.unique(uniqIdToDomElems[uniqId]);
    }

    var blockClass = blocks[blockName] || DOM.decl(blockName, {}, { live : true });
    if(!(blockClass._liveInitable = !!blockClass._processLive()) || forceLive || params.live === false) {
        var block = new blockClass(uniqIdToDomElems[uniqId], params, !!forceLive);
        delete uniqIdToDomElems[uniqId];
        callback && callback.apply(block, Array.prototype.slice.call(arguments, 4));
        return block;
    }

}

/**
 * Processes and adds necessary block parameters
 * @private
 * @param {Object} params Initialization parameters
 * @param {HTMLElement} domNode DOM node
 * @param {String} blockName Block name
 * @param {String} [uniqInitId] ID of the "initialization wave"
 */
function processParams(params, domNode, blockName, uniqInitId) {

    (params || (params = {})).uniqId ||
        (params.uniqId = (params.id? blockName + '-id-' + params.id : $.identify()) + (uniqInitId || $.identify()));

    var domUniqId = $.identify(domNode),
        domParams = domElemToParams[domUniqId] || (domElemToParams[domUniqId] = {});

    domParams[blockName] || (domParams[blockName] = params);

    return params;

}

/**
 * Helper for searching for a DOM element using a selector inside the context, including the context itself
 * @private
 * @param {jQuery} ctx Context
 * @param {String} selector CSS selector
 * @param {Boolean} [excludeSelf=false] Exclude context from search
 * @returns {jQuery}
 */
function findDomElem(ctx, selector, excludeSelf) {

    var res = ctx.find(selector);
    return excludeSelf?
       res :
       res.add(ctx.filter(selector));

}

/**
 * Returns parameters of a block's DOM element
 * @private
 * @param {HTMLElement} domNode DOM node
 * @returns {Object}
 */
function getParams(domNode) {

    var uniqId = $.identify(domNode);
    return domElemToParams[uniqId] ||
           (domElemToParams[uniqId] = extractParams(domNode));

}

/**
 * Retrieves block parameters from a DOM element
 * @private
 * @param {HTMLElement} domNode DOM node
 * @returns {Object}
 */
function extractParams(domNode) {

    var fn = domNode.onclick || domNode.ondblclick;
    if(!fn && domNode.tagName.toLowerCase() == 'body') { // LEGO-2027 in FF onclick doesn't work on body
        var elem = $(domNode),
            attr = elem.attr('onclick') || elem.attr('ondblclick');
        attr && (fn = Function(attr));
    }
    return fn? fn() : {};

}

/**
 * Cleans up all the BEM storages associated with a DOM node
 * @private
 * @param {HTMLElement} domNode DOM node
 */
function cleanupDomNode(domNode) {

    delete domElemToParams[$.identify(domNode)];

}

/**
 * Uncople DOM node from the block. If this is the last node, then destroys the block.
 * @private
 * @param {BEM.DOM} block block
 * @param {HTMLElement} domNode DOM node
 */
function removeDomNodeFromBlock(block, domNode) {

    block.domElem.length === 1?
        block.destruct(true) :
        block.domElem = block.domElem.not(domNode);

}

/**
 * Returns a DOM node for calculating the window size in IE
 * @returns {HTMLElement}
 */
function getClientNode() {

    return doc[0][$.support.boxModel? 'documentElement' : 'body'];

}

/**
 * Returns a block on a DOM element and initializes it if necessary 
 * @param {String} blockName Block name
 * @param {Object} params Block parameters
 * @returns {BEM}
 */
$.fn.bem = function(blockName, params) {
    return initBlock(blockName, this, params, true);
};

/**
 * @namespace
 * @name BEM.DOM
 */
var DOM = BEM.DOM = BEM.decl('i-bem__dom',/** @lends BEM.DOM.prototype */{
    /**
     * @class Base block for creating BEM blocks that have DOM representation 
     * @constructs
     * @private
     * @param {jQuery} domElem DOM element that the block is created on
     * @param {Object} params Block parameters
     * @param {Boolean} [initImmediately=true]
     */
    __constructor : function(domElem, params, initImmediately) {

        var _this = this;

        /**
         * Block's DOM elements
         * @protected
         * @type jQuery
         */
        _this.domElem = domElem;

        /**
         * Cache for names of events on DOM elements
         * @private
         * @type Object
         */
        _this._eventNameCache = {};

        /**
         * Cache for elements
         * @private
         * @type Object
         */
        _this._elemCache = {};

        /**
         * Unique block ID
         * @private
         * @type String
         */
        uniqIdToBlock[_this._uniqId = params.uniqId || $.identify(_this)] = _this;

        /**
         * Flag for whether it's necessary to unbind from the document and window when destroying the block
         * @private
         * @type Boolean
         */
        _this._needSpecialUnbind = false;

        _this.__base(null, params, initImmediately);

    },

    /**
     * Finds blocks inside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksInside : function(elem, block) {

        return this._findBlocks('find', elem, block);

    },

    /**
     * Finds the first block inside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockInside : function(elem, block) {

        return this._findBlocks('find', elem, block, true);

    },

    /**
     * Finds blocks outside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksOutside : function(elem, block) {

        return this._findBlocks('parents', elem, block);

    },

    /**
     * Finds the first block outside the current block or its elements (including context)
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockOutside : function(elem, block) {

        return this._findBlocks('closest', elem, block)[0] || null;

    },

    /**
     * Finds blocks on DOM elements of the current block or its elements
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM[]}
     */
    findBlocksOn : function(elem, block) {

        return this._findBlocks('', elem, block);

    },

    /**
     * Finds the first block on DOM elements of the current block or its elements
     * @protected
     * @param {String|jQuery} [elem] Block element
     * @param {String|Object} block Name or description (block,modName,modVal) of the block to find
     * @returns {BEM}
     */
    findBlockOn : function(elem, block) {

        return this._findBlocks('', elem, block, true);

    },

    _findBlocks : function(select, elem, block, onlyFirst) {

        if(!block) {
            block = elem;
            elem = undefined;
        }

        var ctxElem = elem?
                (typeof elem == 'string'? this.findElem(elem) : elem) :
                this.domElem,
            isSimpleBlock = typeof block == 'string',
            blockName = isSimpleBlock? block : (block.block || block.blockName),
            selector = '.' +
                (isSimpleBlock?
                    buildClass(blockName) :
                    buildClass(blockName, block.modName, block.modVal)) +
                (onlyFirst? ':first' : ''),
            domElems = ctxElem.filter(selector);

        select && (domElems = domElems.add(ctxElem[select](selector)));

        if(onlyFirst) {
            return domElems[0]? initBlock(blockName, domElems.eq(0), true) : null;
        }

        var res = [],
            uniqIds = {};

        $.each(domElems, function(i, domElem) {
            var block = initBlock(blockName, $(domElem), true);
            if(!uniqIds[block._uniqId]) {
                uniqIds[block._uniqId] = true;
                res.push(block);
            }
        });

        return res;

    },

    /**
     * Adds an event handler for any DOM element
     * @protected
     * @param {jQuery} domElem DOM element where the event will be listened for
     * @param {String|Object} event Event name or event object
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToDomElem : function(domElem, event, fn) {

        var _this = this;

        fn?
            domElem.bind(
                _this._buildEventName(event),
                function(e) {
                    (e.data || (e.data = {})).domElem = $(this);
                    return fn.apply(_this, arguments);
                }
            ) :
            $.each(event, function(event, fn) {
                _this.bindToDomElem(domElem, event, fn);
            });

        return _this;

    },

    /**
     * Adds an event handler to the document
     * @protected
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToDoc : function(event, fn) {

        this._needSpecialUnbind = true;
        return this.bindToDomElem(doc, event, fn);

    },

    /**
     * Adds an event handler to the window
     * @protected
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindToWin : function(event, fn) {

        this._needSpecialUnbind = true;
        return this.bindToDomElem(win, event, fn);

    },

    /**
     * Adds an event handler to the block's main DOM elements or its nested elements
     * @protected
     * @param {jQuery|String} [elem] Element
     * @param {String} event Event name
     * @param {Function} fn Handler function, which will be executed in the block's context
     * @returns {BEM}
     */
    bindTo : function(elem, event, fn) {

        if(!event || $.isFunction(event)) { // if there is no element
            fn = event;
            event = elem;
            elem = this.domElem;
        } else if(typeof elem == 'string') {
            elem = this.elem(elem);
        }

        return this.bindToDomElem(elem, event, fn);

    },

    /**
     * Removes event handlers from any DOM element
     * @protected
     * @param {jQuery} domElem DOM element where the event was being listened for
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromDomElem : function(domElem, event) {

        domElem.unbind(this._buildEventName(event));
        return this;

    },

    /**
     * Removes event handler from document
     * @protected
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromDoc : function(event) {

        return this.unbindFromDomElem(doc, event);

    },

    /**
     * Removes event handler from window
     * @protected
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFromWin : function(event) {

        return this.unbindFromDomElem(win, event);

    },

    /**
     * Removes event handlers from the block's main DOM elements or its nested elements
     * @protected
     * @param {jQuery|String} [elem] Nested element
     * @param {String} event Event name
     * @returns {BEM}
     */
    unbindFrom : function(elem, event) {

        if(!event) {
            event = elem;
            elem = this.domElem;
        } else if(typeof elem == 'string') {
            elem = this.elem(elem);
        }

        return this.unbindFromDomElem(elem, event);

    },

    /**
     * Builds a full name for an event
     * @private
     * @param {String} event Event name
     * @returns {String}
     */
    _buildEventName : function(event) {

        var _this = this;
        return event.indexOf(' ') > 1?
            event.split(' ').map(function(e) {
                return _this._buildOneEventName(e);
            }).join(' ') :
            _this._buildOneEventName(event);

    },

    /**
     * Builds a full name for a single event
     * @private
     * @param {String} event Event name
     * @returns {String}
     */
    _buildOneEventName : function(event) {

        var _this = this,
            eventNameCache = _this._eventNameCache;

        if(event in eventNameCache) return eventNameCache[event];

        var uniq = '.' + _this._uniqId;

        if(event.indexOf('.') < 0) return eventNameCache[event] = event + uniq;

        var lego = '.bem_' + _this.__self._name;

        return eventNameCache[event] = event.split('.').map(function(e, i) {
            return i == 0? e + lego : lego + '_' + e;
        }).join('') + uniq;

    },

    /**
     * Triggers block event handlers and live event handlers
     * @protected
     * @param {String} e Event name
     * @param {Object} [data] Additional information
     * @returns {BEM}
     */
    trigger : function(e, data) {

        this
            .__base(e = this.buildEvent(e), data)
            .domElem && this._ctxTrigger(e, data);

        return this;

    },

    _ctxTrigger : function(e, data) {

        var _this = this,
            storage = liveEventCtxStorage[_this.__self._buildCtxEventName(e.type)],
            ctxIds = {};

        storage && _this.domElem.each(function() {
            var ctx = this,
                counter = storage.counter;
            while(ctx && counter) {
                var ctxId = $.identify(ctx, true);
                if(ctxId) {
                    if(ctxIds[ctxId]) break;
                    var storageCtx = storage.ctxs[ctxId];
                    if(storageCtx) {
                        $.each(storageCtx, function(uniqId, handler) {
                            handler.fn.call(
                                handler.ctx || _this,
                                e,
                                data);
                        });
                        counter--;
                    }
                    ctxIds[ctxId] = true;
                }
                ctx = ctx.parentNode;
            }
        });

    },

    /**
     * Sets a modifier for a block/nested element
     * @protected
     * @param {jQuery} [elem] Nested element
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @returns {BEM}
     */
    setMod : function(elem, modName, modVal) {

        if(elem && typeof modVal != 'undefined' && elem.length > 1) {
            var _this = this;
            elem.each(function() {
                var item = $(this);
                item.__bemElemName = elem.__bemElemName;
                _this.setMod(item, modName, modVal);
            });
            return _this;
        }
        return this.__base(elem, modName, modVal);

    },

    /**
     * Retrieves modifier value from the DOM node's CSS class
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery} [elem] Nested element
     * @param {String} [elemName] Name of the nested element
     * @returns {String} Modifier value
     */
    _extractModVal : function(modName, elem, elemName) {

        var domNode = (elem || this.domElem)[0],
            matches;

        domNode &&
            (matches = domNode.className
                .match(this.__self._buildModValRE(modName, elemName || elem)));

        return matches? matches[2] : '';

    },

    /**
     * Retrieves a name/value list of modifiers
     * @private
     * @param {Array} [modNames] Names of modifiers
     * @param {Object} [elem] Element
     * @returns {Object} Hash of modifier values by names
     */
    _extractMods : function(modNames, elem) {

        var res = {},
            extractAll = !modNames.length,
            countMatched = 0;

        ((elem || this.domElem)[0].className
            .match(this.__self._buildModValRE(
                '(' + (extractAll? NAME_PATTERN : modNames.join('|')) + ')',
                elem,
                'g')) || []).forEach(function(className) {
                    var iModVal = (className = className.trim()).lastIndexOf(MOD_DELIM),
                        iModName = className.substr(0, iModVal - 1).lastIndexOf(MOD_DELIM);
                    res[className.substr(iModName + 1, iModVal - iModName - 1)] = className.substr(iModVal + 1);
                    ++countMatched;
                });

        // empty modifier values are not reflected in classes; they must be filled with empty values
        countMatched < modNames.length && modNames.forEach(function(modName) {
            modName in res || (res[modName] = '');
        });

        return res;

    },

    /**
     * Sets a modifier's CSS class for a block's DOM element or nested element
     * @private
     * @param {String} modName Modifier name
     * @param {String} modVal Modifier value
     * @param {String} oldModVal Old modifier value
     * @param {jQuery} [elem] Element
     * @param {String} [elemName] Element name
     */
    _afterSetMod : function(modName, modVal, oldModVal, elem, elemName) {

        var _self = this.__self,
            classPrefix = _self._buildModClassPrefix(modName, elemName),
            classRE = _self._buildModValRE(modName, elemName),
            needDel = modVal === '';

        (elem || this.domElem).each(function() {
            var className = this.className;
            className.indexOf(classPrefix) > -1?
                this.className = className.replace(
                    classRE,
                    (needDel? '' : '$1' + classPrefix + modVal) + '$3') :
                needDel || $(this).addClass(classPrefix + modVal);
        });

        elemName && this
            .dropElemCache(elemName, modName, oldModVal)
            .dropElemCache(elemName, modName, modVal);

    },

    /**
     * Finds elements nested in a block
     * @protected
     * @param {String|jQuery} [ctx=this.domElem] Element where search is being performed
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    findElem : function(ctx, names, modName, modVal) {

        if(arguments.length % 2) { // if the number of arguments is one or three
            modVal = modName;
            modName = names;
            names = ctx;
            ctx = this.domElem;
        } else if(typeof ctx == 'string') {
            ctx = this.findElem(ctx);
        }

        var _self = this.__self,
            selector = '.' +
                names.split(' ').map(function(name) {
                    return buildClass(_self._name, name, modName, modVal);
                }).join(',.');
        return findDomElem(ctx, selector);

    },

    /**
     * Finds elements nested in a block
     * @protected
     * @param {String} name Nested element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    _elem : function(name, modName, modVal) {

        var key = name + buildModPostfix(modName, modVal),
            res;

        if(!(res = this._elemCache[key])) {
            res = this._elemCache[key] = this.findElem(name, modName, modVal);
            res.__bemElemName = name;
        }

        return res;

    },

    /**
     * Lazy search for elements nested in a block (caches results)
     * @protected
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {jQuery} DOM elements
     */
    elem : function(names, modName, modVal) {

        if(modName && typeof modName != 'string') {
            modName.__bemElemName = names;
            return modName;
        }

        if(names.indexOf(' ') < 0) {
            return this._elem(names, modName, modVal);
        }

        var res = $([]),
            _this = this;
        names.split(' ').forEach(function(name) {
            res = res.add(_this._elem(name, modName, modVal));
        });
        return res;

    },

    /**
     * Clearing the cache for elements
     * @protected
     * @param {String} names Nested element name (or names separated by spaces)
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {BEM}
     */
    dropElemCache : function(names, modName, modVal) {

        if(names) {
            var _this = this,
                modPostfix = buildModPostfix(modName, modVal);
            names.indexOf(' ') < 0?
                delete _this._elemCache[names + modPostfix] :
                names.split(' ').forEach(function(name) {
                    delete _this._elemCache[name + modPostfix];
                });
        } else {
            this._elemCache = {};
        }

        return this;

    },

    /**
     * Retrieves parameters of a block element
     * @param {String|jQuery} elem Element
     * @returns {Object} Parameters
     */
    elemParams : function(elem) {

        var elemName;
        if(typeof elem ==  'string') {
            elemName = elem;
            elem = this.elem(elem);
        } else {
            elemName = this.__self._extractElemNameFrom(elem);
        }

        return extractParams(elem[0])[buildClass(this.__self.getName(), elemName)] || {};

    },

    /**
     * Checks whether a DOM element is in a block
     * @protected
     * @param {jQuery} domElem DOM element
     * @returns {Boolean}
     */
    containsDomElem : function(domElem) {

        var res = false;

        this.domElem.each(function() {
            return !(res = domElem.parents().andSelf().index(this) > -1);
        });

        return res;

    },

    /**
     * Builds a CSS selector corresponding to a block/element and modifier
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {String}
     */
    buildSelector : function(elem, modName, modVal) {

        return this.__self.buildSelector(elem, modName, modVal);

    },

    /**
     * Deletes a block
     * @param {Boolean} [keepDOM=false] Whether to keep the block's DOM nodes in the document
     */
    destruct : function(keepDOM) {

        var _this = this,
            _self = _this.__self;

        _this._isDestructing = true;

        _this._needSpecialUnbind && _self.doc.add(_self.win).unbind('.' + _this._uniqId);

        _this.dropElemCache().domElem.each(function(i, domNode) {
            var params = getParams(domNode);
            $.each(params, function(blockName, blockParams) {
                var block = uniqIdToBlock[blockParams.uniqId];
                if(block) {
                    if(!block._isDestructing) {
                        removeDomNodeFromBlock(block, domNode);
                        delete params[blockName];
                    }
                }
                else {
                    delete uniqIdToDomElems[blockParams.uniqId];
                }
            });
            $.isEmptyObject(params) && cleanupDomNode(domNode);
        });

        keepDOM || _this.domElem.remove();

        delete uniqIdToBlock[_this.un()._uniqId];
        delete _this.domElem;
        delete _this._elemCache;

        _this.__base();

    }

}, /** @lends BEM.DOM */{

    /**
     * Document shortcut
     * @protected
     * @type jQuery
     */
    doc : doc,

    /**
     * Window shortcut
     * @protected
     * @type jQuery
     */
    win : win,

    /**
     * Processes a block's live properties
     * @private
     * @param {Boolean} [heedLive=false] Whether to take into account that the block already processed its live properties
     * @returns {Boolean} Whether the block is a live block
     */
    _processLive : function(heedLive) {

        var _this = this,
            res = _this._liveInitable;

        if('live' in _this) {
            var noLive = typeof res == 'undefined';

            if(noLive ^ heedLive) {
                if($.isFunction(_this.live)) {
                    res = _this.live() !== false;
                    _this.live = function() {};
                } else {
                    res = _this.live;
                }
            }
        }

        return res;

    },

    /**
     * Initializes blocks on a fragment of the DOM tree
     * @static
     * @protected
     * @param {jQuery} [ctx=document] Root DOM node
     * @returns {jQuery} ctx Initialization context
     */
    init : function(ctx, callback, callbackCtx) {

        if(!ctx || $.isFunction(ctx)) {
            callbackCtx = callback;
            callback = ctx;
            ctx = doc;
        }

        var uniqInitId = $.identify();
        findDomElem(ctx, '.i-bem').each(function() {
            init($(this), uniqInitId);
        });

        callback && this.afterCurrentEvent(
            function() {
                callback.call(callbackCtx || this, ctx);
            });

        // makes initialization completely synchronous
        this._runAfterCurrentEventFns();

        return ctx;

    },

    /**
     * Destroys blocks on a fragment of the DOM tree
     * @static
     * @protected
     * @param {Boolean} [keepDOM=false] Whether to keep DOM nodes in the document
     * @param {jQuery} ctx Root DOM node
     * @param {Boolean} [excludeSelf=false] Exclude the context
     */
    destruct : function(keepDOM, ctx, excludeSelf) {

        if(typeof keepDOM != 'boolean') {
            excludeSelf = ctx;
            ctx = keepDOM;
            keepDOM = undefined;
        }

        findDomElem(ctx, '.i-bem', excludeSelf).each(function(i, domNode) {
            var params = getParams(this);
            $.each(params, function(blockName, blockParams) {
                if(blockParams.uniqId) {
                    var block = uniqIdToBlock[blockParams.uniqId];
                    if(block) {
                        removeDomNodeFromBlock(block, domNode);
                        delete params[blockName];
                    }
                    else {
                        delete uniqIdToDomElems[blockParams.uniqId];
                    }
                }
            });
            $.isEmptyObject(params) && cleanupDomNode(this);
        });
        keepDOM || (excludeSelf? ctx.empty() : ctx.remove());

    },

    /**
     * Replaces a fragment of the DOM tree inside the context, destroying old blocks and intializing new ones
     * @static
     * @protected
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content New content
     * @param {Function} [callback] Handler to be called after initialization
     * @param {Object} [callbackCtx] Handler's context
     */
    update : function(ctx, content, callback, callbackCtx) {

        this.destruct(ctx, true);
        this.init(ctx.html(content), callback, callbackCtx);

    },

    /**
     * Adds a fragment of the DOM tree at the end of the context and initializes blocks
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content Content to be added
     */
    append : function(ctx, content) {

        this.init($(content).appendTo(ctx));

    },

    /**
     * Adds a fragment of the DOM tree at the beginning of the context and initializes blocks
     * @param {jQuery} ctx Root DOM node
     * @param {jQuery|String} content Content to be added
     */
    prepend : function(ctx, content) {

        this.init($(content).prependTo(ctx));

    },

    /**
     * Adds a fragment of the DOM tree before the context and initializes blocks
     * @param {jQuery} ctx Contextual DOM node
     * @param {jQuery|String} content Content to be added
     */
    before : function(ctx, content) {

        this.init($(content).insertBefore(ctx));

    },

    /**
     * Adds a fragment of the DOM tree after the context and initializes blocks
     * @param {jQuery} ctx Contextual DOM node
     * @param {jQuery|String} content Content to be added
     */
    after : function(ctx, content) {

        this.init($(content).insertAfter(ctx));

    },

    /**
     * Builds a full name for a live event
     * @static
     * @private
     * @param {String} e Event name
     * @returns {String}
     */
    _buildCtxEventName : function(e) {

        return this._name + ':' + e;

    },

    _liveClassBind : function(className, e, callback, invokeOnInit) {

        var _this = this;
        if(e.indexOf(' ') > -1) {
            e.split(' ').forEach(function(e) {
                _this._liveClassBind(className, e, callback, invokeOnInit);
            });
        }
        else {
            var storage = liveClassEventStorage[e],
                uniqId = $.identify(callback);

            if(!storage) {
                storage = liveClassEventStorage[e] = {};
                doc.bind(e, _this.changeThis(_this._liveClassTrigger, _this));
            }

            storage = storage[className] || (storage[className] = { uniqIds : {}, fns : [] });

            if(!(uniqId in storage.uniqIds)) {
                storage.fns.push({ uniqId : uniqId, fn : _this._buildLiveEventFn(callback, invokeOnInit) });
                storage.uniqIds[uniqId] = storage.fns.length - 1;
            }
        }

        return this;

    },

    _liveClassUnbind : function(className, e, callback) {

        var storage = liveClassEventStorage[e];
        if(storage) {
            if(callback) {
                if(storage = storage[className]) {
                    var uniqId = $.identify(callback);
                    if(uniqId in storage.uniqIds) {
                        var i = storage.uniqIds[uniqId],
                            len = storage.fns.length - 1;
                        storage.fns.splice(i, 1);
                        while(i < len) storage.uniqIds[storage.fns[i++].uniqId] = i - 1;
                        delete storage.uniqIds[uniqId];
                    }
                }
            } else {
                delete storage[className];
            }
        }

        return this;

    },

    _liveClassTrigger : function(e) {

        var storage = liveClassEventStorage[e.type];
        if(storage) {
            var node = e.target, classNames = [];
            for(var className in storage) storage.hasOwnProperty(className) && classNames.push(className);
            do {
                var nodeClassName = ' ' + node.className + ' ', i = 0;
                while(className = classNames[i++]) {
                    if(nodeClassName.indexOf(' ' + className + ' ') > -1) {
                        var j = 0, fns = storage[className].fns, fn;
                        while(fn = fns[j++]) fn.fn.call($(node), e);
                        if(e.isPropagationStopped()) return;
                        classNames.splice(--i, 1);
                    }
                }
            } while(classNames.length && (node = node.parentNode));
        }

    },

    _buildLiveEventFn : function(callback, invokeOnInit) {

        var _this = this;
        return function(e) {
            var args = [
                    _this._name,
                    ((e.data || (e.data = {})).domElem = $(this)).closest(_this.buildSelector()),
                    true ],
                block = initBlock.apply(null, invokeOnInit? args.concat([callback, e]) : args);
            block && (invokeOnInit || (callback && callback.apply(block, arguments)));
        };

    },

    /**
     * Helper for live initialization for an event on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String} [elemName] Element name or names (separated by spaces)
     * @param {String} event Event name
     * @param {Function} [callback] Handler to call after successful initialization
     */
    liveInitOnEvent : function(elemName, event, callback) {

        return this.liveBindTo(elemName, event, callback, true);

    },

    /**
     * Helper for subscribing to live events on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String|Object} [to] Description (object with modName, modVal, elem) or name of the element or elements (space-separated)
     * @param {String} event Event name
     * @param {Function} [callback] Handler
     */
    liveBindTo : function(to, event, callback, invokeOnInit) {

        if(!event || $.isFunction(event)) {
            callback = event;
            event = to;
            to = undefined;
        }

        if(!to || typeof to == 'string') {
            to = { elem : to };
        }

        to.elemName && (to.elem = to.elemName);

        var _this = this;

        if(to.elem && to.elem.indexOf(' ') > 1) {
            to.elem.split(' ').forEach(function(elem) {
                _this._liveClassBind(
                    buildClass(_this._name, elem, to.modName, to.modVal),
                    event,
                    callback,
                    invokeOnInit);
            });
            return _this;
        }

        return _this._liveClassBind(
            buildClass(_this._name, to.elem, to.modName, to.modVal),
            event,
            callback,
            invokeOnInit);

    },

    /**
     * Helper for unsubscribing from live events on DOM elements of a block or its elements
     * @static
     * @protected
     * @param {String} [elem] Name of the element or elements (space-separated)
     * @param {String} event Event name
     * @param {Function} [callback] Handler
     */
    liveUnbindFrom : function(elem, event, callback) {

        var _this = this;

        if(elem.indexOf(' ') > 1) {
            elem.split(' ').forEach(function(elem) {
                _this._liveClassUnbind(
                    buildClass(_this._name, elem),
                    event,
                    callback);
            });
            return _this;
        }

        return _this._liveClassUnbind(
            buildClass(_this._name, elem),
            event,
            callback);

    },

    /**
     * Helper for live initialization when a different block is initialized
     * @static
     * @private
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     * @param {String} findFnName Name of the method for searching
     */
    _liveInitOnBlockEvent : function(event, blockName, callback, findFnName) {

        var name = this._name;
        blocks[blockName].on(event, function(e) {
            var args = arguments,
                blocks = e.block[findFnName](name);

            callback && blocks.forEach(function(block) {
                callback.apply(block, args);
            });
        });
        return this;

    },

    /**
     * Helper for live initialization for a different block's event on the current block's DOM element
     * @static
     * @protected
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockEvent : function(event, blockName, callback) {

        return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOn');

    },

    /**
     * Helper for live initialization for a different block's event inside the current block
     * @static
     * @protected
     * @param {String} event Event name
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} [callback] Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInsideEvent : function(event, blockName, callback) {

        return this._liveInitOnBlockEvent(event, blockName, callback, 'findBlocksOutside');

    },

    /**
     * Helper for live initialization when a different block is initialized on a DOM element of the current block
     * @deprecated - use liveInitOnBlockEvent
     * @static
     * @protected
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} callback Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInit : function(blockName, callback) {

        return this.liveInitOnBlockEvent('init', blockName, callback);

    },

    /**
     * Helper for live initialization when a different block is initialized inside the current block
     * @deprecated - use liveInitOnBlockInsideEvent
     * @static
     * @protected
     * @param {String} blockName Name of the block that should trigger a reaction when initialized
     * @param {Function} [callback] Handler to be called after successful initialization in the new block's context
     */
    liveInitOnBlockInsideInit : function(blockName, callback) {

        return this.liveInitOnBlockInsideEvent('init', blockName, callback);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @static
     * @protected
     * @param {jQuery} [ctx] The element in which the event will be listened for
     * @param {String} e Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler's context
     */
    on : function(ctx, e, data, fn, fnCtx) {

        return ctx.jquery?
            this._liveCtxBind(ctx, e, data, fn, fnCtx) :
            this.__base(ctx, e, data, fn);

    },

    /**
     * Removes the live event handler from a block, based on a specified element where the event was being listened for 
     * @static
     * @protected
     * @param {jQuery} [ctx] The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    un : function(ctx, e, fn, fnCtx) {

        return ctx.jquery?
            this._liveCtxUnbind(ctx, e, fn, fnCtx) :
            this.__base(ctx, e, fn);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @deprecated Use on
     * @static
     * @protected
     * @param {jQuery} ctx The element in which the event will be listened for
     * @param {String} e Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler context
     */
    liveCtxBind : function(ctx, e, data, fn, fnCtx) {

        return this._liveCtxBind(ctx, e, data, fn, fnCtx);

    },

    /**
     * Adds a live event handler to a block, based on a specified element where the event will be listened for
     * @static
     * @private
     * @param {jQuery} ctx The element in which the event will be listened for
     * @param {String} e  Event name
     * @param {Object} [data] Additional information that the handler gets as e.data
     * @param {Function} fn Handler
     * @param {Object} [fnCtx] Handler context
     */
    _liveCtxBind : function(ctx, e, data, fn, fnCtx) {

        var _this = this;

        if(typeof e == 'string') {
            if($.isFunction(data)) {
                fnCtx = fn;
                fn = data;
                data = undefined;
            }

            if(e.indexOf(' ') > -1) {
                e.split(' ').forEach(function(e) {
                    _this._liveCtxBind(ctx, e, data, fn, fnCtx);
                });
            } else {
                var ctxE = _this._buildCtxEventName(e),
                    storage = liveEventCtxStorage[ctxE] ||
                        (liveEventCtxStorage[ctxE] = { counter : 0, ctxs : {} });

                ctx.each(function() {
                    var ctxId = $.identify(this),
                        ctxStorage = storage.ctxs[ctxId];
                    if(!ctxStorage) {
                        ctxStorage = storage.ctxs[ctxId] = {};
                        ++storage.counter;
                    }
                    ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')] = {
                        fn   : fn,
                        data : data,
                        ctx  : fnCtx
                    };
                });
            }
        } else {
            $.each(e, function(e, fn) {
                _this._liveCtxBind(ctx, e, fn, data);
            });
        }

        return _this;

    },

    /**
     * Removes a live event handler from a block, based on a specified element where the event was being listened for
     * @deprecated Use on
     * @static
     * @protected
     * @param {jQuery} ctx The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    liveCtxUnbind : function(ctx, e, fn, fnCtx) {

        return this._liveCtxUnbind(ctx, e, fn, fnCtx);

    },

    /**
     * Removes a live event handler from a block, based on a specified element where the event was being listened for
     * @static
     * @private
     * @param {jQuery} ctx The element in which the event was being listened for
     * @param {String} e Event name
     * @param {Function} [fn] Handler
     * @param {Object} [fnCtx] Handler context
     */
    _liveCtxUnbind : function(ctx, e, fn, fnCtx) {

        var _this = this,
            storage = liveEventCtxStorage[e =_this._buildCtxEventName(e)];

        if(storage) {
            ctx.each(function() {
                var ctxId = $.identify(this, true),
                    ctxStorage;
                if(ctxId && (ctxStorage = storage.ctxs[ctxId])) {
                    fn && delete ctxStorage[$.identify(fn) + (fnCtx? $.identify(fnCtx) : '')];
                    if(!fn || $.isEmptyObject(ctxStorage)) {
                        storage.counter--;
                        delete storage.ctxs[ctxId];
                    }
                }
            });
            storage.counter || delete liveEventCtxStorage[e];
        }

        return _this;

    },

    /**
     * Retrieves the name of an element nested in a block
     * @static
     * @private
     * @param {jQuery} elem Nested element
     * @returns {String|undefined}
     */
    _extractElemNameFrom : function(elem) {

        if(elem.__bemElemName) return elem.__bemElemName;

        var matches = elem[0].className.match(this._buildElemNameRE());
        return matches? matches[1] : undefined;

    },

    /**
     * Retrieves block parameters from a DOM element
     * @static
     * @param {HTMLElement} domNode DOM node
     * @returns {Object}
     */
    extractParams : extractParams,

    /**
     * Builds a prefix for the CSS class of a DOM element or nested element of the block, based on modifier name
     * @static
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery|String} [elem] Element
     * @returns {String}
     */
    _buildModClassPrefix : function(modName, elem) {

        return buildClass(this._name) +
               (elem?
                   ELEM_DELIM + (typeof elem === 'string'? elem : this._extractElemNameFrom(elem)) :
                   '') +
               MOD_DELIM + modName + MOD_DELIM;

    },

    /**
     * Builds a regular expression for extracting modifier values from a DOM element or nested element of a block
     * @static
     * @private
     * @param {String} modName Modifier name
     * @param {jQuery|String} [elem] Element
     * @param {String} [quantifiers] Regular expression quantifiers
     * @returns {RegExp}
     */
    _buildModValRE : function(modName, elem, quantifiers) {

        return new RegExp('(\\s?)' + this._buildModClassPrefix(modName, elem) + '(' + NAME_PATTERN + ')(\\s|$)', quantifiers);

    },

    /**
     * Builds a regular expression for extracting names of elements nested in a block
     * @static
     * @private
     * @returns {RegExp}
     */
    _buildElemNameRE : function() {

        return new RegExp(this._name + ELEM_DELIM + '(' + NAME_PATTERN + ')(?:\\s|$)');

    },

    /**
     * Builds a CSS selector corresponding to the block/element and modifier
     * @param {String} [elem] Element name
     * @param {String} [modName] Modifier name
     * @param {String} [modVal] Modifier value
     * @returns {String}
     */
    buildSelector : function(elem, modName, modVal) {

        return '.' + buildClass(this._name, elem, modName, modVal);

    },

    /**
     * Returns a block instance by unique ID
     * @deprecated
     * @param {String} [uniqId]
     * @returns {BEM.DOM}
     */
    getBlockByUniqId : function(uniqId) {

        return uniqIdToBlock[uniqId];

    },

    /**
     * Returns the size of the current window
     * @returns {Object} Object with width and height fields
     */
    getWindowSize : function() {

        return {
            width  : win.width(),
            height : win.height()
        };

    }

});

})(BEM, jQuery);
;
/* ../../lego/bem-bl/blocks-common/i-bem/__dom/i-bem__dom.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: begin */ /**/
(function() {

String.prototype.trim || (String.prototype.trim = function () {

    var str = this.replace(/^\s\s*/, ''),
        ws = /\s/,
        i = str.length;

    while(ws.test(str.charAt(--i)));

    return str.slice(0, i + 1);

});

})();;
/* ../../lego/bem-bl/blocks-common/i-ecma/__string/i-ecma__string.js: end */ /**/

/* ../../blocks-desktop/i-ecma/__string/i-ecma__string.js: begin */ /**/
(function() {

    String.prototype.capitalize || (String.prototype.capitalize = function () {

        return this.substring(0, 1).toUpperCase() + this.substring(1);

    });

})();;
/* ../../blocks-desktop/i-ecma/__string/i-ecma__string.js: end */ /**/

/* ../../lego/blocks-common/i-common/check-session/i-common__check-session.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};
/**
 * Проверяет жива ли сессия пользователя (наличие куки yandex_login).
 *
 * @return  true, если сессия пользователя живая.
 */
Lego.isSessionValid = function() {
    return !!Lego.getCookie('yandex_login');
}
})(window.Lego);
;
/* ../../lego/blocks-common/i-common/check-session/i-common__check-session.js: end */ /**/

/* ../../lego/blocks-common/i-global/i-global.js: begin */ /**/

BEM.DOM.decl('i-global', {

    onSetMod : {

        'js' : function() {

            // удаляем системные свойства
            this.del(this.__self._params = $.extend({}, this.params), 'uniqId', 'name');

            var params = this.__self._params;

            params['passport-msg'] || (params['passport-msg'] = params.id);

            if(params['show-counters'] === undefined) {
                params['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];
            }
            params.locale = params.lang;

            $(function(){
                params.oframebust && Lego.oframebust(params.oframebust);
            });

        }

    },

    getDefaultParams : function() {

        return {
            id : '',
            login : Lego.isSessionValid() ? $.cookie('yandex_login') || '' : '',
            yandexuid : $.cookie('yandexuid'),
            lang : 'ru',
            retpath : window.location.toString(),
            'passport-host' : 'https://passport.yandex.ru',
            'pass-host' : '//pass.yandex.ru',
            'social-host' : '//social.yandex.ru',
            'lego-path' : '/lego',
            'show-counters-percent' : 100
        };

    }

}, {

    param  : function(name) {

        return (this._params || {})[name];

    }

});
;
/* ../../lego/blocks-common/i-global/i-global.js: end */ /**/

/* ../../lego/blocks-common/i-counter/i-counter.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

!Lego.params && (Lego.params = {});


/**
 * Хелпер удаляющий протокол из переданного хоста, для приведения
 * к каноническому виду.
 *
 * @param h {String}
 * @returns {String}
 */
function preparseHost(h) {
    return h.replace(/^(?:https?:)?\/\//, '');
}

/**
 * Счётчик клика на ссылку или просто показа.
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт скрипт с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onmousedown="Lego.c('stred/pid=7/cid=433',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">Lego.c('stred/pid=7/cid=433')< /script>
 *
 * @param w     параметры счётчика
 * @param a     (optional) ссылка, клик на которую надо учитывать
 * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
 */ /**/
Lego.c = function(w, a, opts) {
/*
    new Image().src = location.protocol + '//clck.yandex.ru/click/dtype=' + w +
        '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
        '/*' + (a ? (a.href || location.href) : '');
*/

    var host = preparseHost((opts && opts.host) || BEM.blocks['i-global'].param('click-host') || 'clck.yandex.ru'),
        url = function(w, h, t, a) {

            h = h.replace("'", "%27"); //см. LEGO-6428

            return h.indexOf('/dtype=') > -1?
                h :
                location.protocol + '//' + host + '/' + t + '/dtype=' + w +
                    '/rnd=' + ((new Date()).getTime() + Math.round(Math.random()*100)) +
                    (a?
                        '/*' + (h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)) :
                        '/*data=' + encodeURIComponent('url='+ encodeURIComponent((h.match(/^http/) ? h : location.protocol + '//' + location.host + (h.match('^/') ? h : '/' + h)))));
        },
        click = function() {
            var head = document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0];
            var script = document.createElement('script');
            script.setAttribute('src', url(w, location.href, 'jclck'));
            head.insertBefore(script, head.firstChild);
        };

    if (a) {
        // для псевдоссылки и ссылки mailto просто считаем click, создавая iframe и в него грузим счётчик
        if (a.className.match(/b-link_pseudo_yes/) || (a.href && a.href.match(/^mailto:/)) || (opts && opts.noRedirect === true)) {
            click();
        } else if (a.href) { // клик на ссылку, подменяем href на redir'овский, потом по таймауту обратно
            var h = a.href;
            a.href = url(w, h, "redir");
            setTimeout(function() { a.href = h }, 500);
        } else if (a.form) { // клик на элемент формы
            if (a.type.match(/submit|button|image/)) { // клик на кнопку, подменяем action на redir'овский, потом по таймауту обратно
                var h = a.form.action;
                a.form.action = url(w, h, "redir", true);
                setTimeout(function() { a.form.action = h }, 500);
            } else { // просто считаем click, создавая iframe и в него грузим счётчик
                click();
            }
        } else if (a.action) { //случай сабмита формы - подменяем его action на redir'овский, назад нам его менять не нужно
            a.action = url(w, a.action, "redir", true);
        } else {
            throw "counter.js: not link and not form!";
        }
    } else { // ссылки нет, просто учёт показа, создаём iframe и в него грузим счётчик
        click();
    }
}

})(window.Lego);

(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Параметризованный счётчик клика на ссылку или просто показа.
 * Перевызывает Lego.c(w, a) из counter.js
 *
 * В случае клика подменяет href на redir'овский, потом по таймауту возвращает его обратно.
 *
 * В случае учёта показа динамически создаёт iframe с URL системы учёта.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onclick="Lego.cp(0,1917,'weather.tabs.fotki',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">Lego.cp(0,1917,'weather.tabs.fotki')< /script>
 *
 * @param pi    номер проекта (pid)
 * @param ci    номер счётчика (cid)
 * @param p     (optional) parameter
 * @param a     (optional) ссылка, клик на которую надо учитывать
 * @param opts  (optional) opts.noRedirect = true обрабатывает клик по обычной ссылке, как по b-link_pseudo_yes
 */
Lego.cp = function(pi, ci, p, a, opts) {
    Lego.c('stred/pid=' + pi + '/cid=' + ci + (p ? '/path=' + p : ''), a, opts);
}

})(window.Lego);

(function(Lego){
if (!Lego) Lego = window.Lego = {};

/**
 * Параметризованный счётчик клика на ссылку в шапке. Перевызывает cp(w, a) из counter-cp.js
 * Используется для уменьшения веса страницы.
 *
 * Пример использования:
 *
 * <a href="http://meteoinfo.ru" onclick="ch('weather.tabs.fotki',this)">Гидрометцентр</a>
 *
 * или
 *
 * < script type="text/javascript">ch('weather')< /script>
 *
 * @param p     parameter
 * @param a     (optional) ссылка, клик на которую надо учитывать
 */
Lego.ch = function(p, a) {
    BEM.blocks['i-global'].param('show-counters') && Lego.cp(0, 2219, p, a);
}

})(window.Lego);
;
/* ../../lego/blocks-common/i-counter/i-counter.js: end */ /**/

/* ../../lego/blocks-common/i-common/cookie/i-common__cookie.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

Lego.getCookie = function(n) {
    var c = document.cookie;
    if (c.length < 1) return false;

    var b = c.indexOf(n + '=');
    if (b == -1) return false;

    b += (n.length + 1);
    var e = c.indexOf(';', b);

    return decodeURIComponent((e == -1) ? c.substring(b) : c.substring(b, e));
}

})(window.Lego);
;
/* ../../lego/blocks-common/i-common/cookie/i-common__cookie.js: end */ /**/

/* ../../lego/blocks-common/i-common/init/i-common__init.js: begin */ /**/
(function($, Lego){
if (!Lego) Lego = window.Lego = {};
// Использует cookie.js и check-session.js. Без них не работает.

/**
 * Инициализирует Лего некоторыми параметрами (для вариативности в пределах разных страниц).
 *
 * @param params объект Лего-параметров, необходимые параметры инициализируются умолчательными значениями
 *        params.login логин текущего пользователя ('' для неавторизованного)
 *        params.locale двухбуквенный код локали в нижнем регистре
 *        params.id идентификатор сервиса
 *        params['show-counters-percent'] процент срабатывания счётчиков Lego.ch() (по умолчанию 100)
 *
 * @return возвращает установленные параметры с учетом умолчательных значений
 */
Lego.init || (Lego.init = function(params) {
    (params = Lego.params = $.extend(
        {
            id : '',
            login : Lego.isSessionValid() ? Lego.getCookie('yandex_login') || '' : '',
            yandexuid : Lego.getCookie('yandexuid'),
            locale : 'ru',
            retpath : window.location.toString(),
            'passport-host' : '//passport.yandex.ru',
            'pass-host' : '//pass.yandex.ru',
            'passport-msg' : params.id,
            'social-host' : '//social.yandex.ru',
            'lego-path' : '/lego',
            'show-counters-percent' : 100
        },
        params,
        Lego.params))
        ['show-counters'] = Math.round(Math.random() * 100) <= params['show-counters-percent'];

    BEM.blocks['i-global']._params || $.extend(BEM.blocks['i-global']._params = {}, params);

    $(function(){
        params.oframebust && Lego.oframebust(params.oframebust);
    });

    return params;
});

Lego.block || (Lego.block = {});

Lego.blockInit || (Lego.blockInit = function(context, blockSelector) {
    context = context || document;
    blockSelector = blockSelector || '.g-js';
    $(context).find(blockSelector).each(function(){
        var block = $(this),
            params = this.onclick ? this.onclick() : {},
            name = params.name || '',
            init = Lego.block[name];
        if (init && !block.data(name)) {
            init.call(block, params);
            block
                .data(name, true)
                .addClass(name + '_js_inited');
        }
    });
});

Lego.blockInitBinded || (Lego.blockInitBinded = !!$(document).ready(function(){ Lego.blockInit() }));

})(jQuery, window.Lego);
;
/* ../../lego/blocks-common/i-common/init/i-common__init.js: end */ /**/

/* ../../lego/blocks-common/i-common/i-common.js: begin */ /**/
(function(Lego){
if (!Lego) Lego = window.Lego = {};

Lego.messages = Lego.messages || {};

Lego.message = function(id, text) {
    return Lego.params.locale == 'ru' ? text : (Lego.messages[id] || text);
};

})(window.Lego);;
/* ../../lego/blocks-common/i-common/i-common.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: begin */ /**/
/* дефолтная инициализация */
$(function() {
    BEM.DOM.init();
});;
/* ../../lego/bem-bl/blocks-common/i-bem/__dom/_init/i-bem__dom_init_auto.js: end */ /**/

/* ../../blocks-desktop/b-page/b-page.js: begin */ /**/
var blocks = {};

blocks['b-page'] = function(data, page, width, height) {
    var blocks = require('bem').blocks;
    return blocks['b-page_page_' + page](data, width, height);
};

blocks['b-page_page_index'] = function(data, width, height) {
    var blocks = require('bem').blocks;
    return [
        blocks['b-background'](data),
        blocks['b-decor'](data),
        blocks['b-bookmarks'](data, width, height),
        blocks['b-vb'](data, width, height),
        blocks['b-vb-foot'](data),
        data.debug && blocks['b-debug'](data)
    ];
};

blocks['b-page_page_config'] = function(data, width, height) {
    var blocks = require('bem').blocks;
    return [
        blocks['b-vb-config'](data, width, height),
        blocks['b-setting'](data),
        blocks['b-paranja'](data),
        blocks['b-vb-config__confirm'](data),
        data.debug && blocks['b-debug'](data)
    ];
};

/**
 * @requires BEM
 * @requires BEM.DOM
 */

(function($, BEM, undefined) {

/**
 * @namespace
 * @name Block
 */
BEM.DOM.decl('b-page', /** @lends Block.prototype */ {
    _timer: null,
    _winResizeTimerId: null,
    _windowWidth: 0,
    _windowHeight: 0,
    _scrollbarWidth: 17,
    _scrollbarHeight: 17,
    _minWindowWidth: 860,
    onSetMod: {
        js: function() {
            var self = this;

            // Страница полностью загрузилась
            self.bindToWin('load', self._onLoad);

            // Ресайзим страницу
            self.bindToWin('resize', self._onWinResize);

            // Пишем об ошибках
            self.__self.win[0].onerror = function(err, file, num) {
                var data = BEM.blocks["i-cache"].cache('settings');
                data.debug && require('debug')(err + ' at file: ' + file + ' at line: ' + num);
            };

//            self.bindTo('dragend', function(/* Event */ $e) {
//                console.log('b-page::onSetMod::js::dragend');
//                this.trigger('outside-dragend');
//            });
        },

        page: {
            index: function() {
                var self = this,
                    vb = require('vb'),
                    $ = require('$'),
                    Lib = require('lib'),
                    winSize = self.__self.getWindowSize(),
                    BEMHTML = require('bemhtml'),
                    blocks = require('bem').blocks,
                    BEM = require('bem').BEM,
                    init = false,
                    document = require('document'),
                    $de = $(document.documentElement);

                // В jQuery 1.7.2 и 1.8.2 иногда в качестве window.width()
                // приходит 0 в IE7-8 для этого случая выставляется значение
                // минимальной ширины контент зоны 860px
                if (!winSize.width) {
                    winSize.width = self._minWindowWidth;
                }

                // Выставляем класс на тег <html/>
                $de.removeClass('page_config')
                   .addClass('page_index');

                // IE10
                if (window.matchMedia && window.matchMedia("screen and (-ms-high-contrast: active), (-ms-high-contrast: none)").matches) {
                    $de.addClass('ie10');
                    self.setMod('ie', '10');
                }
                
                var settings = BEM.blocks['i-cache'].cache('settings');
                var BEMJSON = blocks['b-page'](settings, 'index', winSize.width, winSize.height);

                // VB-314
                self.setMod('bookmarks', !settings.showBookmarks && 'no' || '');

                // VB-331
                self.setMod('width', Lib.getContentSizeMod(winSize.width, winSize.height));

                // VB-711
                self.setMod('os', vb.osName);

                var html = BEMHTML.apply(BEMJSON);
                BEM.DOM.destruct(false, self.domElem, true);
                self.domElem.html(html);

                // Запускаем инициализацию блоков в отдельном потоке
                setTimeout(function() {
                    BEM.DOM.init(self._afterInit, self);
                }, 0);
            },

            config: function() {
                var self = this,
                    vb = require('vb'),
                    $ = require('$'),
                    winSize = self.__self.getWindowSize(),
                    BEMHTML = require('bemhtml'),
                    blocks = require('bem').blocks,
                    BEM = require('bem').BEM,
                    document = require('document'),
                    $de = $(document.documentElement);

                BEM.blocks['i-queue'].enqueue();

                // Выставляем класс на тег <html/>
                $de.removeClass('page_index')
                   .addClass('page_config');
                    
                // IE10
                if (window.matchMedia && window.matchMedia("screen and (-ms-high-contrast: active), (-ms-high-contrast: none)").matches) {
                    $de.addClass('ie10');
                    self.setMod('ie', '10');
                }

                // VB-314
                self.delMod('bookmarks');

                // VB-331
                self.delMod('width');

                // VB-711
                self.setMod('os', vb.osName);

                var settings = BEM.blocks['i-cache'].cache('settings'),
                    userSettings = vb.getSettings();                        // Получаем пользовательские настройки

                BEM.blocks['i-cache'].cache('userSettings', userSettings);

                // Формируем начльный объект с настройками для сохранения
                // сначала наполняем его значениями из инита и getSettings
                BEM.blocks['i-cache'].cache('saveSettings', {
                    x: settings.x,
                    y: settings.y,
                    showBookmarks: userSettings.showBookmarks,
                    sendStat: userSettings.sendStat,
                    showSearchForm: userSettings.showSearchForm,
                    changeUserImage: false,
                    bgImage: userSettings.selectedBgImage,
                    thumbs: $.extend({}, settings.thumbs)
                });

                var BEMJSON = blocks['b-page'](settings, 'config', winSize.width, winSize.height);
                var html = BEMHTML.apply(BEMJSON);
                BEM.DOM.destruct(false, self.domElem, true);
                self.domElem.html(html);

                // Запускаем инициализацию блоков в отдельном потоке
                setTimeout(function() {
                    BEM.DOM.init(self._afterInit, self);
                }, 0);
            }
        }
    },

    _onLoad: function() {
        var self = this,
            vb = require('vb'),
            BEM = require('bem').BEM;

        // Локализуем заголовок
        self.__self.doc[0].title = vb.getLocalizedString('app.name');

        // Инициализация страницы
        vb.onRequest.addListener("init", function(settings) {
            self._onInit(settings);
        });

        // Получаем данные об изменении тумб
        vb.onRequest.addListener("thumbChanged", function(items) {
            BEM.blocks['i-queue'].push("thumbChanged", arguments);
            self._onThumbChanged(items);
        });

        // Получаем данные о цвете фона и подложке для тумб в библиотеке
        vb.onRequest.addListener("historyThumbChanged", function(item) {
            BEM.blocks['i-queue'].push("historyThumbChanged", arguments);
            self._onHistoryThumbChanged(item);
        });

        // Получаем данные об изменении закладок
        vb.onRequest.addListener("bookmarksStateChanged", function(bookmarks) {
            self._onBookmarksStateChanged(bookmarks);
        });

        // Мы готововы принимать все события, ставим их в очередь до момента
        // окончания инициализации страницы
        BEM.blocks['i-queue'].enqueue();

        // Принудительно запрашиваем инициализацию
        vb.requestInit();
    },

    _onWinResize: function() {
        var self = this,
            vb = require('vb');

        if (self._winResizeTimerId) {
            clearTimeout(self._winResizeTimerId);
        }

        self._winResizeTimerId = setTimeout(function() {
            var winSize = self.__self.getWindowSize(),
                isNull = !self._windowWidth && !self._windowHeight;             // Первая загрузка — перерисовка не нужна

            // Проверяем изменились ли размеры окна
            // Из-за особенностей ИЕ проверяем так же размеры окна с и без учета скролбара
            if ((self._windowWidth !== winSize.width && self._windowWidth !== (winSize.width + self._scrollbarWidth) && self._windowWidth !== (winSize.width - self._scrollbarWidth))
            || (self._windowHeight !== winSize.height && self._windowHeight !== (winSize.height + self._scrollbarHeight) && self._windowHeight !== (winSize.height - self._scrollbarHeight))) {
                self._windowWidth = winSize.width;
                self._windowHeight = winSize.height;

                // Перерисовываем страницу с новыми размерами окна
                if (!isNull) {
                    var page = self.getMod('page');
                    self.delMod('page').setMod('page', page);
                }
            }
        }, 300);
    },

    _onInit: function(settings) {
        var self = this,
            vb = require('vb'),
            BEM = require('bem').BEM;

        // Выставляем текущие настройки пришедшие в init и сохраняем в кэш настройки пользователя
        BEM.blocks['i-cache'].cache('settings', settings);
        self.delMod('page');
        self.setMod('page', 'index');

        //прячем обучалку
        self.delMod('banner');
        if(settings.searchStatus == 1 )
            self.setMod('banner', 'no');


    },

    _onThumbChanged: function(items) {
        var self = this,
            $ = require('$'),
            BEM = require('bem').BEM;

        // Обрабатываем thumbChanged только на главной странице
        if (!self.hasMod('page', 'index')) {
            return;
        }

        var settings = BEM.blocks['i-cache'].cache('settings'),
            updated = [];

        // Обновляем соответствующие тумбы в кэше
        for (var i = 0, keys = Object.keys(items), len = keys.length; i < len; i++) {
            var index = keys[i],
                item = items[index];

            var diff = self._thumbChangesDiff(settings.thumbs[index], item),
                changedPropertiesCount = Object.keys(diff).length,
                newThumb = {};

            // Если изменений нет, пропускаем
            if (!changedPropertiesCount) {
                continue;
            }

            // VB-545
            // VB-514
            // Если изменился url
            if (diff.hasOwnProperty('url')) {
                // Тумба опустошилась
                if (!item.url) {
                    newThumb = null;

                // В тумбу пришел новый урл — полностью перерисовываем
                } else {
                    newThumb = $.extend({}, item);
                }

            // Изменился один из параметров влияющих на отображение всей тумбы — полностью перерисовываем
            } else if (diff.hasOwnProperty('title') || diff.hasOwnProperty('backgroundColor') || diff.hasOwnProperty('backgroundImage') || diff.hasOwnProperty('fontColor') || diff.hasOwnProperty('favicon')) {
                newThumb = $.extend({}, settings.thumbs[index], diff);

            // Если изменено _только_ одно поле и это поле 'pinned', то считаем, что
            // перерисовывать не надо и разберется b-tumb::_onPin / b-tumb::_onUnpin
            } else {
                self.trigger('thumbRepin', { index: index, pinned: item.pinned });
                continue;
            }

            // Иначе добавляем индекс в стек для обновления и сохраняем в хранилище
            updated.push(index);
            settings.thumbs[index] = newThumb;
        }
        BEM.blocks['i-cache'].cache('settings', settings);

        // Тригирим событие о необходимости перерисовать тумбы
        self.trigger('thumbChanged', updated);
    },

    /**
     * Получаем различия между тумбой из хранлища и пришедшей в thumbChanged
     *
     * @param {Object} originalThumb Тумба из хранилища
     * @param {Object} newThumb Новая тумба для сравнения
     * @private
     * @return {Object}
     */
    _thumbChangesDiff: function(originalThumb, newThumb) {
        var diff = {},
            keys, key, i, len;

        // Проходимся по всем ключам из newThumb
        for (i = 0, keys = Object.keys(newThumb), len = keys.length; i < len; i++) {
            key = keys[i];

            // Если его нет в оригинальном объекте, то считаем что он добавился
            if (!originalThumb || !originalThumb.hasOwnProperty(key)) {
                diff[key] = newThumb[key];

            // Если параметр есть в обоих объектах сравниваем изменился ли он
            } else if (originalThumb.hasOwnProperty(key) && newThumb.hasOwnProperty(key)) {
                if (originalThumb[key] !== newThumb[key]) {
                    diff[key] = newThumb[key];
                }
            }
        }
        return diff;
    },

    _onHistoryThumbChanged: function(item) {
        var self = this,
            $ = require('$'),
            BEM = require('bem').BEM,
            historyThumbs;

        // Пытаемся получить данные про тамбы из истории
        try {
            historyThumbs = BEM.blocks['i-cache'].cache('historyThumbs');
        } catch (err) {
            // Считаем что пришел скрытый таб
            historyThumbs = {};
        }

        historyThumbs[item.url] = $.extend({}, historyThumbs[item.url] || {}, item);
        BEM.blocks['i-cache'].cache('historyThumbs', historyThumbs);
        self.trigger('historyThumbChanged', item.url);
    },

    _onBookmarksStateChanged: function(bookmarks) {
        var self = this,
            BEM = require('bem').BEM;

        // Сохраняем загруженные заградки в кэш
        BEM.blocks['i-cache'].cache('bookmarks', bookmarks);

        // Вызываем кастомное событие из-под b-page`а
        self.trigger('bookmarksStateChanged');
    },

    _afterInit: function() {
        var self = this,
            BEM = require('bem').BEM;

        // Страница инициализирова, дальше можно обрабатывать
        // события в штатном режиме
        BEM.blocks['i-queue'].dequeue();

        // Итерируемся по всем накопленным в очереди событиям и
        // вызываем соответсвующие им обработчики
        BEM.blocks['i-queue'].iterator(function(task) {
            for (var i = 0, keys = Object.keys(task), len = keys.length; i < len; i++) {
                var key = keys[i],
                    handler = '_on' + key.capitalize();

                if (!(handler in this)) {
                    throw ReferenceError('No handler for event "' + key + '" need implementation of method "' + handler + '"');
                }
                this[handler].apply(this, task[key]);
            }
        }, self);
    }

});

}(jQuery, BEM));;
/* ../../blocks-desktop/b-page/b-page.js: end */ /**/

/* ../../blocks-desktop/b-background/b-background.js: begin */ /**/
blocks['b-background'] = function(data) {
    var vb = require('vb'),
        isFf = (vb.navigator === 'firefox');

    return [
        {
            block: 'b-background',
            mods: {
                ff: 'yes'
            },
            js: {
                backgroundImage: data.backgroundImage
            }
        },
        '<!--[if lt IE 8]><v:rect id="bg" stroked="false" class="vml b-background b-background_ie_yes"><v:fill type="frame" aspect="atleast" src="' + data.backgroundImage + '" class="vml" style="position:absolute;width:100%;height:100%;"></v:fill></v:rect><![endif]-->'
    ];
};

BEM.DOM.decl({ block: 'b-background', modName: 'ff', modVal: 'yes'}, {
    onSetMod : {
        js : function() {
            var url = this.params.backgroundImage.replace(/\\/g, '/');
            this.domElem.css({
                'background-image': 'url("' + url + '")'
            });
        }
    }
});

//BEM.DOM.decl({ block: 'b-background', modName: 'ie', modVal: 'yes'}, {
//    onSetMod : {
//        js : function() {
////            this.__self.doc[0].execCommand("BackgroundImageCache", false, true);
//            this.domElem.attr('src', this.params.backgroundImage);
//        }
//    }
//});
;
/* ../../blocks-desktop/b-background/b-background.js: end */ /**/

/* ../../blocks-desktop/b-tumbs/b-tumbs.js: begin */ /**/
/**
 * @requires BEM
 * @requires BEM.DOM
 */


blocks['b-tumbs'] = function(data, width, height, type) {
    var blocks = require('bem').blocks,
        Lib = require('lib'),
        contentWidth = Lib.getContentSize(width, height),
        size = Lib.getThumbSize(data.x, data.y, contentWidth, height),
        modSize = Lib.getThumbSizeMod(size);

    return {
        block: 'b-tumbs',
        js: true,
        mods: {
            size: modSize,
            type: type,
            row: '' + data.y
        },
        content: (function(data) {
            var rows = [],
                i = 0,
                row, item;

            for (var y = 0; y < data.y; y++) {
                row = [];

                for (var x = 0; x < data.x; x++) {
                    item = null;
                    if (i in data.thumbs) {
                        item = data.thumbs[i];
                    }
                    row.push({
                        elem: 'item',
                        mods: data.thumbs[i] ? null : type == 'index' ? { state: 'empty' } : null,
                        content: blocks['b-tumb'](data, item, i, size, type)
                    });
                    i++;
                }

                rows.push({
                    elem: 'row',
                    content: row
                });
            }

            return rows;
        })(data)
    };
};

/**
 * @namespace
 * @name Block
 */
BEM.DOM.decl('b-tumbs', /** @lends Block.prototype */ {

    onSetMod : {
        js : function() {
            /**
             *
             * @type {Block}
             */
            var self = this,
                $ = require('$'),
                BEM = require('bem').BEM,
                vb = require('vb'),
                settings = BEM.blocks['i-cache'].cache('settings'),
                bPage = self.findBlockOutside('b-page');

            // Инициируем обработчики
            BEM.blocks['b-page'].on('thumbChanged', this._onThumbChanged, this);
            BEM.blocks['b-page'].on('thumbRepin', this._onThumbRepin, this);

            // Пиним тумбу
            BEM.blocks['b-tumb'].on('config_pin', function(e, index) {
                settings.thumbs[index].pinned = true;
                BEM.blocks['i-cache'].cache('settings', settings);
            });

            // Отпиниваем тумбу
            BEM.blocks['b-tumb'].on('config_unpin', function(e, index) {
                settings.thumbs[index].pinned = false;
                BEM.blocks['i-cache'].cache('settings', settings);
            });
        }
    },

    destruct: function() {
        var BEM = require('bem').BEM;

        // Удаляем  обработчики вместе с уничтожением объекта
        BEM.blocks['b-page'].un('thumbChanged', this._onThumbChanged, this);
        BEM.blocks['b-page'].un('thumbRepin', this._onThumbRepin, this);

        BEM.blocks['b-tumb'].un('config_pin');
        BEM.blocks['b-tumb'].un('config_unpin');

        // Вызывавем базовый метод
        this.__base.apply(this, arguments);
    },

    _onThumbChanged: function(e, updated) {
        var self = this,
            BEM = require('bem').BEM,
            blocks = require('bem').blocks,
            BEMHTML = require('bemhtml'),
            winSize = self.__self.getWindowSize(),
            settings = BEM.blocks['i-cache'].cache('settings'),
            Lib = require('lib'),
            contentWidth = Lib.getContentSize(winSize.width, winSize.height),
            size = Lib.getThumbSize(settings.x, settings.y, contentWidth, winSize.height),
            type = self.getMod('type');

        for (var i = 0, len = updated.length; i < len; i++) {
            var index = updated[i],
                item = settings.thumbs[index],
                thumb = self.findBlockInside({ block: 'b-tumb', modName: 'index', modVal: '' + index });

            if (thumb) {
                var bTumb = blocks['b-tumb'](settings, item, index, size, type);
                BEM.DOM.update(thumb.domElem.parent(), BEMHTML.apply(bTumb));
            }
        }
    },

    /**
     * Обрабатываем пин / отпин тумбы в других табах
     * пытаемся внутри тумбы с индексом посланным триггером
     * найти элемент с типом противоположным выставленному состоянию
     * в случае успеха сменяем его модификатор
     *
     * @event
     * @param e
     * @param data
     * @private
     */
    _onThumbRepin: function(e, data) {
        var self = this,
            thumb = self.findBlockInside({ block: 'b-tumb', modName: 'index', modVal: '' + data.index }),
            item = thumb && thumb.findElem('control-item', 'type', (data.pinned ? 'pin' : 'unpin'));            // Находим внутри необходимой тумбы еще _непереключенную_ кнопку

        thumb && item && thumb.setMod(item, 'type', (data.pinned ? 'unpin' : 'pin'));
    }
});
;
/* ../../blocks-desktop/b-tumbs/b-tumbs.js: end */ /**/

/* ../../lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: begin */ /**/
/**
 * leftClick event plugin
 *
 * Copyright (c) 2010 Filatov Dmitry (alpha@zforms.ru)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 * @version 1.0.0
 */

(function($) {

var leftClick = $.event.special.leftclick = {

    setup : function() {

        $(this).bind('click', leftClick.handler);

    },

    teardown : function() {

        $(this).unbind('click', leftClick.handler);

    },

    handler : function(e) {

        if(!e.button) {
            e.type = 'leftclick';
            $.event.handle.apply(this, arguments);
            e.type = 'click';
        }

    }

};

})(jQuery);;
/* ../../lego/bem-bl/blocks-common/i-jquery/__leftclick/i-jquery__leftclick.js: end */ /**/

/* ../../lego/blocks-desktop/b-popupa/b-popupa.js: begin */ /**/
(function($) {

/**
 @namespace JS-API блока b-popupa
 @name block */

BEM.DOM.decl('b-popupa',  /** @lends block.prototype */ {

    onSetMod : {

        'js' : function() {

            /**
             * DOM-элемент, для которого открывается попап
             * @private
             * @type jQuery
             */
            this._owner = null;

            /**
             * Состояние видимости
             * @private
             * @type Boolean
             */
            this._isShowed = false;

            /**
             * Приоритетное направление для открытия попапа
             * @private
             * @type String
             */
            this._direction = this.getMod('direction') || 'down';

            /**
             * Последнее удачное направление открытия (когда попап полностью попал в окно)
             * @private
             * @type String
             */
            this._lastDirection = null;

        }

    },

    /**
     * Показывает попап
     * @param {jQuery|Object} owner DOM-элемент или координаты { left : x, top : y }, относительно которых рассчитывается положение
     */
    show : function(owner) {

        if(!this._isShowed || this._owner !== owner) {
            this._owner = owner;
            this._getUnder().show({ left : -10000, top : -10000 });
            this.pos();
            this._getUnder().setMod('animate','yes');
        }

        return this;

    },

    /**
     * Скрывает попап
     */
    hide : function() {

        this._isShowed && this._getUnder().hide();
        return this;

    },

    /**
     * Показывает/скрывает попап в зависимости от текущего состояния
     * @param {jQuery|Object} owner DOM-элемент или координаты { left : x, top : y }, относительно которых рассчитывается положение
     */
    toggle : function(owner) {

        return this.isShowed()?
            this.hide() :
            this.show(owner);

    },

    /**
     * Позиционирует попап
     */
    _pos : function() {

        var params = this._calcParams(this._owner);

        this.elem('tail').css(params.tailOffsets);
        this
            .setMod('direction', params.direction)
            ._getUnder().show(params.offsets);

        return this;

    },

    /**
     * Позиционирует попап, если он виден
     */
    pos : function() {

        if (!this._isShowed)
            return this;

        return this._pos();
    },

    /**
     * Возвращает состояние видимости попапа
     * @returns {Boolean}
     */
    isShowed : function() {

        return this._isShowed;

    },

    /**
     * Устанавливает приоритетное направление открытия попапа
     * @param {String} direction направление (up|right|down|left)
     */
    setDirection : function(direction) {

        if(this._direction != direction) {
            this._direction = direction;
            this.isShowed() && this.pos();
        }

    },

    /**
     * Устанавливает контент попапа
     * @param {String|jQuery} content контент
     * @param {Function} [callback] обработчик, вызываемый после инициализации
     * @param {Object} [callbackCtx] контекст обработчика
     */
    setContent : function(content, callback, callbackCtx) {

        BEM.DOM.update(this.elem('content'), content, callback, callbackCtx);
        return this.isShowed()? this.pos() : this;

    },

    /**
     * Проверяет, является ли владелец попапа DOM-элементом
     * @returns {Boolean}
     */
    _isOwnerNode : function() {

        return !!(this._owner && this._owner.jquery);

    },

    /**
     * Вычисляет необходимые метрики для расчета направления открытия попапа
     * @private
     * @returns {Object}
     */
    _calcDimensions : function() {

        var posElem = this._getUnder().domElem,
            underElem = this._getUnder()._getUnder(),
            win = this.__self.win,
            owner = this._owner,
            isOwnerNode = this._isOwnerNode(),
            ownerOffset = isOwnerNode? owner.offset() : owner,
            ownerWidth = isOwnerNode? owner.outerWidth() : 0,
            ownerHeight = isOwnerNode? owner.outerHeight() : 0,
            scrollLeft = win.scrollLeft(),
            scrollTop = win.scrollTop(),
            winSize = this.__self.getWindowSize(),
            borderWidth = parseInt(this.elem('content').css('border-top-width'), 10);

        return {
            ownerWidth: ownerWidth,
            ownerHeight: ownerHeight,
            ownerLeft: ownerOffset.left,
            ownerTop: ownerOffset.top,
            ownerRight: ownerOffset.left + ownerWidth,
            ownerBottom: ownerOffset.top + ownerHeight,
            ownerHorizMiddle: ownerOffset.left + ownerWidth / 2,
            ownerVertMiddle: ownerOffset.top + ownerHeight / 2,
            posWidth: posElem.outerWidth(),
            posHeight: posElem.outerHeight(),
            underWidth: underElem.outerWidth(),
            underHeight: underElem.outerHeight(),
            borderWidth: isNaN(borderWidth)? 0: borderWidth,
            windowLeft: scrollLeft,
            windowRight: scrollLeft + winSize.width,
            windowTop: scrollTop,
            windowBottom: scrollTop + winSize.height
        };

    },

    /**
     * Вычисляет параметры открытия попапа
     * @private
     * @returns {Object} хэш вида { direction, offset.left, offset.top }
     */
    _calcParams : function() {

        var d = this._calcDimensions();

        if(this.hasMod('adjustable', 'no'))
            return calcDirectionParams(this._direction, d);

        var checkedDirections = {},
            allowedDirections = this.params.directions,
            currentDirectionIdx = $.inArray(this._direction, allowedDirections);

        // обработка случая когда текущее направление открытия не является допустимым
        currentDirectionIdx > -1 || (currentDirectionIdx = 0);

        var priorityDirectionIdx = currentDirectionIdx,
            currentDirection, params;

        do {
            currentDirection = allowedDirections[currentDirectionIdx];
            params = checkedDirections[currentDirection] = calcDirectionParams(currentDirection, d);
            if(!params.factor) {// значит полностью попал в окно
                this._lastDirection = currentDirection;
                return params;
            }

            // находим следующее возможное направление открытия, если оно есть
            ++currentDirectionIdx == allowedDirections.length && (currentDirectionIdx = 0);

        } while(currentDirectionIdx !== priorityDirectionIdx);

        return checkedDirections[this._lastDirection || allowedDirections[0]];

    },

    getDefaultParams : function() {

        return {
            directions : ALLOWED_DIRECTIONS
        };

    },

    destruct : function() {

        var under = this._under;
        if(!under) {
            this.__base.apply(this, arguments);
        }
        else if(!this._destructing) {
            this._destructing = true;
            this.hide();
            BEM.DOM.destruct(false, under.domElem);
            this.__base(true);
        }

    },

    /**
     * Возвращает подложку
     * @private
     * @returns {BEM.DOM.blocks['i-popup']}
     */
    _getUnder : function() {

        if(!this._under) {
            var under = $(BEM.HTML.build({
                block : 'i-popup',
                zIndex : this.params.zIndex,
                mods : {
                    autoclosable : this.getMod('autoclosable') || 'yes',
                    fixed : this.hasMod('direction', 'fixed') && 'yes'
                },
                underMods : this.params.underMods,
                underMix : [{ block : 'b-popupa', elem : 'under' }]
            }));

            (this._under = this.findBlockOn(under, 'i-popup'))
                .on(
                    {
                        'show'          : this._onUnderShowed,
                        'hide'          : this._onUnderHidden,
                        'outside-click' : this._onUnderOutsideClicked
                    },
                    this)
                .elem('content').append(this.domElem);

        }

        return this._under;

    },

    _onUnderShowed : function() {

        this._isShowed = true;

        this
            .bindToWin('resize', this.pos)
            ._isOwnerNode() &&
                this.bindToDomElem(
                    this._owner.parents().add(this.__self.win),
                    'scroll',
                    this.pos);

        this.trigger('show');

    },

    _onUnderHidden : function() {

        this._isShowed = false;

        this
            .unbindFromWin('resize')
            ._isOwnerNode() &&
                this.unbindFromDomElem(
                    this._owner.parents().add(this.__self.win),
                    'scroll');

        this.trigger('hide');
    },

    _onUnderOutsideClicked : function() {

        this.trigger.apply(this, arguments);

    }

}, /** @lends block */ {

    live : function() {

        this.liveBindTo('close', 'leftclick', function() {
            this.hide();
        });

    }

});

var TAIL_OFFSET = 19,
    TAIL_WIDTH_HORIZONTAL = 9,
    TAIL_WIDTH_VERTICAL = 19,
    TAIL_HEIGHT_HORIZONTAL = 19,
    TAIL_HEIGHT_VERTICAL = 10,
    SHADOW_SIZE = 7,
    ALLOWED_DIRECTIONS = [
        'down-right', 'down', 'down-left', 'up', 'up-right', 'up-left',
        'right-down', 'right', 'right-up', 'left-down', 'left', 'left-up'
    ];

/**
 * Рассчитывает параметры открытия попапа в заданном направлении
 * @private
 * @param {String} direction направление
 * @param {Object} d метрики
 * @returns {Object}
 */
function calcDirectionParams(direction, d) {

    var factor, // фактор попадания в окно

        // смещение попапа
        offsets = {
            top: 0,
            left: 0
        },

        // отступы для хвостика
        tailOffsets = {
            marginLeft: 0,
            marginTop: 0
        },

        // генеральное направление (up, down, left, right)
        calcDirection = direction.split('-')[0],

        // коррекция на тот случай, если owner меньше хвостика
        correctionHoriz = d.ownerWidth < TAIL_WIDTH_VERTICAL
            ? (TAIL_WIDTH_VERTICAL - d.ownerWidth)/2
            : 0,
        correctionVert = d.ownerHeight < TAIL_HEIGHT_HORIZONTAL
            ? (TAIL_HEIGHT_HORIZONTAL - d.ownerHeight)/2
            : 0;

    switch(direction) {
        case 'up':
        case 'down':

            offsets.left = d.ownerHorizMiddle - d.posWidth / 2;

            offsets.top = direction == 'down'
                ? d.ownerBottom + TAIL_HEIGHT_VERTICAL
                : d.ownerTop - d.posHeight - TAIL_HEIGHT_VERTICAL;

            tailOffsets.marginLeft = d.posWidth / 2 - TAIL_WIDTH_VERTICAL / 2;

            tailOffsets.marginTop = direction == 'down'
                ? 0 - TAIL_HEIGHT_VERTICAL
                : 0;
        break;

        case 'up-left':
        case 'up-right':
        case 'down-left':
        case 'down-right':

            offsets.left = direction == 'down-right' || direction == 'up-right'
                ? d.ownerLeft - correctionHoriz
                : d.ownerRight - d.posWidth + correctionHoriz;

            offsets.top = calcDirection == 'down'
                ? d.ownerBottom + TAIL_HEIGHT_VERTICAL
                : d.ownerTop - d.posHeight - TAIL_HEIGHT_VERTICAL;

            tailOffsets.marginLeft = d.ownerWidth > d.posWidth
                ? d.posWidth / 2 - TAIL_WIDTH_VERTICAL / 2
                : d.ownerHorizMiddle - offsets.left - TAIL_WIDTH_VERTICAL / 2;

            tailOffsets.marginTop = calcDirection == 'down'
                ? d.borderWidth - TAIL_HEIGHT_VERTICAL
                : 0 - d.borderWidth;
        break;

        case 'left-down':
        case 'right-down':

            offsets.left = direction == 'left-down'
                ? d.ownerLeft - d.posWidth - TAIL_WIDTH_HORIZONTAL
                : d.ownerRight + TAIL_WIDTH_HORIZONTAL;

            offsets.top = d.ownerTop - correctionVert;

            tailOffsets.marginLeft = direction == 'left-down'
                ? 0 - d.borderWidth
                : d.borderWidth - TAIL_WIDTH_HORIZONTAL;

            tailOffsets.marginTop = d.ownerHeight < d.posHeight
                ? d.ownerVertMiddle - offsets.top - TAIL_HEIGHT_HORIZONTAL / 2
                : d.posHeight / 2 - TAIL_HEIGHT_HORIZONTAL / 2;
        break;

        case 'left':
        case 'right':

            offsets.left = direction == 'left'
                ? d.ownerLeft - d.posWidth - TAIL_WIDTH_HORIZONTAL
                : d.ownerRight + TAIL_WIDTH_HORIZONTAL;

            offsets.top = d.ownerVertMiddle - d.posHeight / 2;

            tailOffsets.marginLeft = direction == 'left'
                ? 0 - d.borderWidth
                : d.borderWidth - TAIL_WIDTH_HORIZONTAL;

            tailOffsets.marginTop = d.posHeight / 2 - TAIL_HEIGHT_HORIZONTAL / 2;
        break;

        case 'left-up':
        case 'right-up':

            offsets.left = direction == 'left-up'
                ? d.ownerLeft - d.posWidth - TAIL_WIDTH_HORIZONTAL
                : d.ownerRight + TAIL_WIDTH_HORIZONTAL;

            offsets.top = d.ownerBottom - d.posHeight + correctionVert;

            tailOffsets.marginLeft = calcDirection == 'left'
                ? 0 - d.borderWidth
                : d.borderWidth - TAIL_WIDTH_HORIZONTAL;

            tailOffsets.marginTop = d.ownerHeight > d.posHeight
                ? d.posHeight / 2 - TAIL_HEIGHT_HORIZONTAL / 2
                : d.ownerVertMiddle - offsets.top - TAIL_HEIGHT_HORIZONTAL / 2;
    }

    factor = calcInWindowFactor(offsets, d);

    return {
        direction : calcDirection,
        factor : factor,
        offsets : offsets,
        tailOffsets : tailOffsets
    };
}

/**
 * Вычисляет фактор попадания объекта в окно
 * @param {Object} pos параметры объекта
 * @param {Object} d метрики
 * @returns {Number} фактор попадания (0 - полностью попадает, далее чем больше, тем хуже)
 */
function calcInWindowFactor(pos, d) {

    var res = 0;

    d.windowTop > pos.top && (res += d.windowTop - pos.top);
    pos.top + d.underHeight > d.windowBottom && (res += pos.top + d.underHeight - d.windowBottom);
    d.windowLeft > pos.left && (res += d.windowLeft - pos.left);
    pos.left + d.underWidth > d.windowRight && (res += pos.left + d.underWidth - d.windowRight);

    return res;

}

BEM.HTML.decl('b-popupa', {

    onBlock : function(ctx) {

        var hasClose = false;
        $.each(ctx.param('content'), function(i, item) {
            return !(hasClose = item.elem == 'close');
        });
        ctx
            .mods({ theme : 'ffffff', direction : 'down', 'has-close' : hasClose && 'yes' })
            .js(true)
            .afterContent({ elem : 'shadow' });

    },

    onElem : {

        'content' : function(ctx) {

            ctx
                .wrap({ elem : 'wrap-cell', tag : 'td' })
                .wrap({ tag : 'tr' })
                .wrap({ elem : 'wrap', tag : 'table' });

        },

        'close' : function(ctx) {

            ctx.tag('i');

        },

        'shadow' : function(ctx) {

            ctx.tag('i');

        },

        'tail' : function(ctx) {

            ctx
                .tag('i')
                .wrapContent({ elem : 'tail-i', tag : 'i' });

        }

    }

});

})(jQuery);
;
/* ../../lego/blocks-desktop/b-popupa/b-popupa.js: end */ /**/

/* ../../lego/blocks-desktop/i-popup/i-popup.js: begin */ /**/
(function($) {

/**
 * Шаблон для подложки
 * @private
 * @type jQuery
 */
var template,

/**
 * Пул подложек
 * @private
 * @type Array
 */
    underPool = [],

    browser = $.browser;

/**
 * Достает подложку из пула, при необходимости создает новую
 * @private
 * @returns jQuery
 */
function getUnder() {

    return underPool.length?
        underPool.shift() :
        template?
            template.clone() :
            template = createUnder();

}

/**
 * Возвращает подложку в пул
 * @private
 * @param {jQuery} under
 */
function putUnder(under) {

    underPool.push(under);

}

/**
 * Создает подложку
 * @private
 * @returns {jQuery}
 */
function createUnder() {

    // TODO пока только для мобильного сафари отдаем div, нужно сделать более умно для тех браузеров, которым достаточно div
    return $((browser.safari || browser.webkit) && navigator.userAgent.toLowerCase().indexOf('mobile') > -1?
        '<div/>' :
        '<iframe' + (browser.msie && browser.version < 9? ' frameborder="0"' : '') + '/>');

}

BEM.DOM.decl('i-popup', {

    onSetMod : {

        'visibility' : {

            'visible' : function() {

                var under = this._getUnder(),
                    underParent = under.parent();

                this.hasMod(under, 'type', 'paranja')?
                    underParent.is('body') || under.appendTo('body') :
                    (underParent[0] !== this.domElem[0]) && under.prependTo(this.domElem);

                this._inBody || (this._inBody = !!this.domElem.appendTo('body'));

                this.trigger('show');

            },

            '' : function() {

                var under = this._getUnder();

                this.hasMod(under, 'type', 'paranja') && under.remove();
                this._putUnder();
                this.trigger('hide');

            }

        }

    },

    /**
     * Получает элемент подложки
     * @private
     * @returns {jQuery}
     */
    _getUnder : function() {

        return this._under ||
            (this._under = getUnder().attr(
                'class',
                this._underClass || (this._underClass = this.findElem('under').remove().attr('class'))));

    },

    /**
     * Возвращает элемент подложки
     * @private
     */
    _putUnder : function() {

        putUnder(this._under);
        delete this._under;

    },

    /**
     * Открывает попап
     * @param {Object} css объект css-свойств, описывающих положение попапа
     * @returns {BEM.DOM}
     */
    show : function(css) {

        css && this.domElem.css(css);
        return this.setMod('visibility', 'visible');

    },

    /**
     * Закрывает попап
     * @returns {BEM.DOM}
     */
    hide : function() {

        return this.delMod('animate').delMod('visibility');

    }

}, {

    live : true

});

})(jQuery);

BEM.HTML.decl('i-popup', {

    onBlock : function(ctx) {

        ctx
            .mod('autoclosable', 'yes')
            .js(true)
            .wrapContent({ elem : 'content' })
            .afterContent({
                elem : 'under',
                mods : ctx.param('underMods'),
                mix : ctx.param('underMix')})
            .param('zIndex') &&
                ctx.attr('style', 'z-index:' + (32700 + ctx.param('zIndex')));


    }

});;
/* ../../lego/blocks-desktop/i-popup/i-popup.js: end */ /**/

/* ../../lego/blocks-desktop/i-popup/_autoclosable/i-popup_autoclosable_yes.js: begin */ /**/
(function($) {

var KEYDOWN_EVENT = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown';

BEM.DOM.decl({ name : 'i-popup', modName : 'autoclosable', modVal : 'yes' }, {

    onSetMod : {

        'visibility' : {

            'visible' : function() {

                this.afterCurrentEvent(function() {
                    // Из-за асинхронности, модификатор уже может быть снят
                    // в этот момент, поэтому нужно его еще раз
                    // проверить, чтобы не оказалось "повисших" подписок.
                    if (this.hasMod('visibility', 'visible')) {

                        var under = this._under;

                        this.bindToDoc('leftclick', function(e) {
                                this.containsDomElem($(e.target)) || this._onOutClick(e);
                            })
                            .bindToDoc(KEYDOWN_EVENT, function(e) {
                                // на Escape закрываем
                                e.keyCode == 27 && this.hide();
                            });

                        if (under && under.is('iframe') && this.hasMod(under, 'type', 'paranja')) {

                            // NOTE Предусматривать отвязку не нужно, т.к. после
                            //      вызова метода hide сам элемент (паранжа) удаляется.
                            // NOTE У пустого iframe:
                            //      IE7-8 ловят клик на contentWindow.document
                            //      Другие браузеры ловят только на contentWindow.
                            this.bindToDomElem(
                                $([under[0].contentWindow, under[0].contentWindow.document]),
                                'leftclick',
                                this.hide
                            );
                        }
                    }
                });
                this.__base.apply(this, arguments);

            },

            '' : function() {

                return this
                    .unbindFromDoc('leftclick ' + KEYDOWN_EVENT)
                    .__base.apply(this, arguments);

            }

        }

    },

    _onOutClick : function(domEvent) {

        var e = $.Event('outside-click');
        this.trigger(e, { domEvent : domEvent });
        e.isDefaultPrevented() || this.hide();

    }

});
})(jQuery);
;
/* ../../lego/blocks-desktop/i-popup/_autoclosable/i-popup_autoclosable_yes.js: end */ /**/

/* ../../blocks-desktop/b-tumb/b-tumb.js: begin */ /**/
/**
 * Метод построения BEM-дерева тумбы
 *
 * @param {Object} data Данные из vb рекурсивно пробрасывается во все функции
 * @param {Object} item Данные о конкретной тумбе
 * @param {Number} index Порядковый номер тумбы начиная с 0-ля
 * @param {Number} size Ширина тумбы в px, высота считается как size / 2
 * @param {String} type Тип тумбы (index, config)
 * @return {Object}
 */
blocks['b-tumb'] = function(data, item, index, size, type) {
    var vb = require('vb'),
        blocks = require('bem').blocks,
        BEM = require('bem').BEM,
        Lib = require('lib'),
        TITLE_MAX_LENGTH = Lib.getThumbTitleMaxLength(size),
        SUBTITLE_MAX_LENGTH = Lib.getThumbSubTitleMaxLength(size),
        DEFAULT_THUMB_BGCOLOR = '#e5e5e5';

    // Возвращаем заглушку если данных нет
    if (!item) {
        return blocks['b-tumb_state_empty'].apply(this, arguments);
    }

    return {
        block: 'b-tumb',
        url: (type === 'index') ? item.url : '',
        bg: item.backgroundColor && '#' + item.backgroundColor || DEFAULT_THUMB_BGCOLOR,
        mods: {
            type: type,
            index: '' + index,
            color: item.fontColor && 'ffffff' || '000000'
        },
        attrs: {
            title: BEM.blocks['i-common__string'].escapeHTML(item.title.trim()),
            draggable: (type === 'config')
        },
        js: {
            index: index
        },
        content: [
            {
                elem: 'content',
                elemMods: {
                    type: item.backgroundImage && 'icon' || 'text',
                    valign: (item.backgroundImage && !item.isIndexPage) ? 'bottom' : ''
                },
                content: (function(data, item, index, size) {
                    var title = BEM.blocks['i-common__string'].escapeHTML(
                        BEM.blocks['i-common__string'].cleverSubstring(
                            item.title.trim(),
                            TITLE_MAX_LENGTH,
                            0
                        )
                    ), subTitle = BEM.blocks['i-common__string'].escapeHTML(
                        BEM.blocks['i-common__string'].cleverSubstring(
                            item.title.trim(),
                            SUBTITLE_MAX_LENGTH,
                            0
                        )
                    );

                    if (!item.backgroundImage && !item.favicon) {
                        return title;
                    } else if (item.backgroundImage) {
                        return [
                            {
                                block: 'b-icon',
                                url: item.backgroundImage,
                                alt: BEM.blocks['i-common__string'].escapeHTML(item.title.trim()),
                                width: size,
                                height: (size / 2)
                            },
                            !item.isIndexPage && subTitle && {
                                elem: 'desc',
                                content: subTitle
                            }
                        ]
                    } else {
                        return [
                            {
                                elem: 'fav',
                                content: {
                                    block: 'b-icon',
                                    url: item.favicon,
                                    alt: BEM.blocks['i-common__string'].escapeHTML(item.title.trim())
                                }
                            },
                            title
                        ]
                    }
                })(data, item, index, size)
            },
            !item.backgroundImage && item.favicon && {
                elem: 'fade',
                attrs: { style: 'background: -moz-linear-gradient(right, #fff 10%, rgba(255, 255, 255, .2))' }
            },
            {
                elem: 'glow'
            },
            {
                elem: 'control',
                elemMods: {
                    hide: (type === 'index') ? 'yes' : ''                   // По-умолчанию контролы скрыты только на главной
                },
                content: (function(data, item, index, size, type) {
                    var control;
                    if (type === 'index') {
                        control = [
                            {
                                elem: 'control-item',
                                elemMods: {
                                    type: item.pinned ? 'unpin' : 'pin'
                                },
                                attrs: {
                                    title: item.pinned ? vb.getLocalizedString('app.unpinThumb') : vb.getLocalizedString('app.pinThumb')
                                },
                                js: {
                                    index: index
                                }
                            }
                        ];
                    } else {
                        control = [
                            {
                                elem: 'control-item',
                                elemMods: {
                                    type: 'set'
                                },
                                attrs: {
                                    title: vb.getLocalizedString('app.editThumb')
                                },
                                js: {
                                    index: index
                                }
                            },
                            {
                                elem: 'control-item',
                                elemMods: {
                                    type: item.pinned ? 'unpin' : 'pin'
                                },
                                attrs: {
                                    title: item.pinned ? vb.getLocalizedString('app.unpinThumb') : vb.getLocalizedString('app.pinThumb')
                                },
                                js: {
                                    index: index
                                }
                            },
                            {
                                elem: 'control-item',
                                elemMods: {
                                    type: 'del'
                                },
                                attrs: {
                                    title: vb.getLocalizedString('app.removeThumb')
                                },
                                js: {
                                    index: index
                                }
                            }
                        ];
                    }

                    return control;
                })(data, item, index, size, type)
            }
        ]
    };
}
;

/**
 * Метод построения BEM-дерева пустой прозрачной тумбы заглушки
 *
 * @param {Object} data Данные из vb рекурсивно пробрасывается во все функции
 * @param {Object} item Данные о конкретной тумбе
 * @param {Number} index Порядковый номер тумбы начиная с 0-ля
 * @param {Number} size Ширина тумбы в px, высота считается как size / 2
 * @param {String} type Тип тумбы (index, config)
 * @return {Object}
 */
blocks['b-tumb_state_empty'] = function(data, item, index, size, type) {
    var vb = require('vb');

    return {
        block: 'b-tumb',
        bg: 'transparent',
        mods: {
            type: type,
            index: '' + index,
            color: '000000',
            theme: (type === 'config') ? 'add' : '',
            action: (type === 'config') ? 'add' : ''
        },
        js: {
            index: index,
            empty: 'yes'
        },
        attrs: {
            draggable: false
        }
    };
};

/**
 * @namespace
 * @name Block
 */
BEM.DOM.decl('b-tumb', /** @lends Block.prototype */ {

    onElemSetMod: {
        'control-item': {
            type: {
                pin: function(elem) {
                    var vb = require('vb');
                    elem.attr('title', vb.getLocalizedString('app.pinThumb'));
                },

                unpin: function(elem) {
                    var vb = require('vb');
                    elem.attr('title', vb.getLocalizedString('app.unpinThumb'));
                }
            }
        }
    },

    _onControlItemClick: function(e) {
        e.stopPropagation();
        e.preventDefault();

        var type = this.getMod(e.data.domElem, 'type'),
            handler = '_on' + type.capitalize();

        if (!(handler in this)) {
            throw ReferenceError('No handler for control item type "' + type + '" need implementation of method "' + handler + '"');
        }
        this[handler].apply(this, arguments);
    },

    _onPin: function(e) {
        var vb = require('vb'),
            index = ~~this.elemParams(e.data.domElem).index;

        this.setMod(e.data.domElem, 'type', 'unpin')
            .trigger('config_pin', index);
        if (this.getMod('type') == 'index')
            vb.pinThumb(index);
    },

    _onUnpin: function(e) {
        var vb = require('vb'),
            index = ~~this.elemParams(e.data.domElem).index;

        this.setMod(e.data.domElem, 'type', 'pin')
            .trigger('config_unpin', index);
        if (this.getMod('type') == 'index')
            vb.unpinThumb(index);
    },

    _onDel: function(e) {
        this.findBlockOutside('b-page').findBlockInside('b-setting').setMod('hide', 'yes');
        this.trigger('config_delete', this.elemParams(e.data.domElem).index);
    },

    _onSet: function(e) {
        var BEM = require('bem').BEM,
            settings = BEM.blocks['i-cache'].cache('settings'),
            bSetting = this.findBlockOutside('b-page').findBlockInside('b-setting'); // позиционирование попапы настроек

        if (bSetting) {
            var blockTail = bSetting.findElem('tail');                                             // хвостик настроек

            // Выставляем флаги того что тумба текущая и что ее начали редактировать
            this.findBlockOutside('b-tumbs').findBlocksInside(this.__self.getName()).forEach(function(block) {
                block.delMod('state').delMod('editing');
            });
            this.setMod('state', 'current').setMod('editing', 'yes');

            // TODO: нужно передать положение тумбы в b-setting  setting.top = tumb.top+tumb.height
            // TODO: и tail по tumb.x-tumb.width/2
            var position = this.domElem.offset(),
                height = parseInt(this.domElem.height()),
                width = parseInt(this.domElem.width());

            bSetting.domElem.css('top', Math.round(position.top + 25 + height / 2) + 'px');
            blockTail.css('left', Math.round(position.left - 10 + width / 2) + 'px');

            // Выставляем значения в полях из параметров тумбы
            var item = settings.thumbs[this.params.index];
            bSetting.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'url' }).val(item && item.url || '');
            bSetting.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'title' }).val(item && item.title.trim() || '');

            bSetting.delMod('hide');
        }
    },

    _getNavigateCode: function(e /** {Event} */) {
        var code = 1;

        // Открываем в новом окне
        if (e.shiftKey) {
            code = 2;
            // Открываем в новом табе
        } else if (e.ctrlKey || e.metaKey) {
            code = 3;
        }
        return code;
    }
}, /** @lend Block */ {

    live: function() {
        var self = this;
        self.liveBindTo('control-item', 'leftclick', function(e) {
            this._onControlItemClick.apply(this, arguments);
            return false;
        });

        return false;
    }

});;
/* ../../blocks-desktop/b-tumb/b-tumb.js: end */ /**/

/* ../../blocks-desktop/b-tumb/_type/b-tumb_type_index.js: begin */ /**/

/**
 * @namespace
 * @name Block
 */
BEM.DOM.decl({ block: 'b-tumb', modName: 'type', modVal: 'index' }, /** @lends Block.prototype */ {

    _timerId: null,

    _on: function() {
        var self = this;
        this._timerId = setTimeout(function() {
            self._onControlHide();
        }, 400);
    },

    _off: function() {
        this.setMod(this.findElem('control'), 'hide', 'yes');
        this._timerId && clearTimeout(this._timerId);
    },

    _onControlHide: function() {
        try {
            this.delMod(this.findElem('control'), 'hide');
        } catch(e) {

        }
    },

    /**
     * Обрабатываем клик по тумбе
     *
     * @event
     * @param {Event} e
     * @private
     */
    _onClick: function (e) {
        if (!this.hasMod('state', 'empty') && !this.params.empty) {
            var vb = require('vb');
            vb.openThumb(this.domElem[0].href, parseInt(this.params.index), this._getNavigateCode(e));
        }

        return true;
    }

}, /** @lend Block */ {

    live: function() {
        var self = this;
        self.__base.apply(self, arguments);

        // Показываем и скрываем панель управления тумбы с задержкой
        self.liveBindTo('mouseover', function() {
            this._on.apply(this, arguments);
        });

        self.liveBindTo('mouseout', function() {
            this._off.apply(this, arguments);
        });

        self.liveBindTo('control', 'mouseover', function() {
            this._onControlHide.apply(this, arguments);
        });

        // Обрабатываем переход только для индексных тумб
        self.liveBindTo('leftclick', function(e) {
            this._onClick.apply(this, arguments);
        });
    }

});;
/* ../../blocks-desktop/b-tumb/_type/b-tumb_type_index.js: end */ /**/

/* ../../blocks-desktop/b-tumb/_action/b-tumb_action_add.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

/**
 * @namespace
 * @name Block
 */
BEM.DOM.decl({ block: 'b-tumb', modName: 'action', modVal: 'add'}, /** @lends Block.prototype */ {

}, /** @lend Block */ {

    live: function() {
        var self = this;
        self.__base.apply(self, arguments);

        self.liveBindTo('leftclick', function(e) {
            this._onSet.apply(this, arguments);
        });
    }

});

})();
;
/* ../../blocks-desktop/b-tumb/_action/b-tumb_action_add.js: end */ /**/

/* ../../blocks-desktop/b-vb-droptop/b-vb-droptop.js: begin */ /**/
BEM.DOM.decl('b-vb-droptop', {

    onSetMod : {
        'js': function() {
            this.bindTo('close', 'click', function(){
                this.setMod('hide', 'yes');
            })
        }
    }

});
;
/* ../../blocks-desktop/b-vb-droptop/b-vb-droptop.js: end */ /**/

/* ../../lego/blocks-desktop/b-link/b-link.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.HTML */

BEM.HTML.decl('b-link', {
    onBlock: function(ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'));

        var props = ['title', 'target'], p;
        while(p = props.pop()) ctx.param(p) && (ctx.attr(p, ctx.param(p)));
    }
});
;
/* ../../lego/blocks-desktop/b-link/b-link.js: end */ /**/

/* ../../blocks-desktop/b-link/_omni/b-link_omni_yes.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'omni', modVal: 'yes'}, {

onSetMod: {

        js: function() {
            var self = this;
            self.on('click', function() {
                 vb.search.useExample($(self.domElem).text());
            });
        }

    }
});
})();
;
/* ../../blocks-desktop/b-link/_omni/b-link_omni_yes.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_close-search-tutorial.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'close-search-tutorial'}, {

onSetMod: {

        js: function() {
            var self = this;
            self.on('click', function() {
                  vb.search.suppressTutorial();
                  self.findBlockOutside('b-page').setMod('banner', 'no');
            });
        }

    }
});
})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_close-search-tutorial.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_make-homepage.js: begin */ /**/
(function($){
    $('.b-link_action_make-homepage').live('click', function() {
        var vb = require('vb');

        vb.setAsHomePage();
        $(this).parent().html(vb.getLocalizedString('settings.isHomePage'));
        return false;
    });
})(jQuery);
/* ../../blocks-desktop/b-link/_action/b-link_action_make-homepage.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_show-bookmarks.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'show-bookmarks'}, {

    onSetMod: {

        js: function() {
            this.on('click', this._openExternalWindow, this);
        }

    },

    destruct: function() {
        this.un('click', this._openExternalWindow, this);
        this.__base.apply(this, arguments);
    },

    _openExternalWindow: function() {
        var vb = require('vb');

        vb.openExternalWindow('bookmarks');
    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_show-bookmarks.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_show-downloads.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'show-downloads'}, {

    onSetMod: {

        js: function() {
            this.on('click', this._openExternalWindow, this);
        }

    },

    destruct: function() {
        this.un('click', this._openExternalWindow, this);
        this.__base.apply(this, arguments);
    },

    _openExternalWindow: function() {
        var vb = require('vb');

        vb.openExternalWindow('downloads');
    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_show-downloads.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_show-history.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'show-history'}, {

    onSetMod: {

        js: function() {
            this.on('click', this._openExternalWindow, this);
        }

    },

    destruct: function() {
        this.un('click', this._openExternalWindow, this);
        this.__base.apply(this, arguments);
    },

    _openExternalWindow: function() {
        var vb = require('vb');

        vb.openExternalWindow('history');
    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_show-history.js: end */ /**/

/* ../../blocks-desktop/b-debug/b-debug.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

blocks['b-debug'] = function(data) {
    return {
        block: 'b-debug',
        tag: 'ol',
        js: true
    };
};

(function(undefined) {

BEM.DOM.decl('b-debug', {

    onSetMod: {
        js: function() {
            // Слайдим консоль по ctrl + ~
            this.bindToDoc('keydown', function(e){
                if ((e.ctrlKey || e.metaKey) && (e.keyCode === 192 || e.keyCode === 96 || e.keyCode === 191 || e.keyCode === 221)) {
                    this.domElem.slideToggle();
                }
            });
        }
    }

});

})();
;
/* ../../blocks-desktop/b-debug/b-debug.js: end */ /**/

/* ../../blocks-desktop/i-queue/i-queue.js: begin */ /**/
/** @requires BEM */
/** @requires BEM */

(function(undefined) {

/**
 * Абстрактный статический блок очереди
 */
BEM.decl('i-queue', {}, {

    /**
     * Семафор активации / деактивации очереди
     *
     * @private
     * @type {Boolean}
     */
    _mutex: false,

    /**
     * Очередь задач
     *
     * @private
     * @type {Array}
     */
    _tasks: [],

    /**
     * Добавляем задачу в очередь, если последняя активна
     *
     * @param {String} task Имя здачи
     * @param {Arguments} args Массив параметров
     * @return {*}
     */
    push: function(task, args) {
        if (!this._mutex) {
            return;
        }

        var item = {};
        item[task] = args;
        this._tasks.push(item);
        return this;
    },

    /**
     * Вытаскиваем последнюю задачу из очереди
     *
     * @return {*}
     */
    pop: function() {
        if (!this._mutex) {
            return;
        }

        return this._tasks.pop();
    },

    /**
     * Активизируем очередь
     *
     * @return {Object}
     */
    enqueue: function() {
        this._mutex = true;
        return this;
    },

    /**
     * Деактивируем очередь
     *
     * @return {Object}
     */
    dequeue: function() {
        this._mutex = false;
        return this;
    },

    /**
     * Итерируемся по списку задач и для каждой из них вызываем
     * callback в контексте callbackCtx
     *
     * @param {Function} callback Коллбек вызываемый для решения задачи
     * @param {Object} callbackCtx Контекст в рамках которого будет вызван коллбек
     */
    iterator: function(callback, callbackCtx) {
        for (var i = 0, len = this._tasks.length; i < len; i++) {
            callback.call(callbackCtx, this._tasks[i]);
        }
    }

});

})();
;
/* ../../blocks-desktop/i-queue/i-queue.js: end */ /**/

/* ../../blocks-desktop/i-cache/i-cache.js: begin */ /**/
/**
 * @requires BEM
 * @requires BEM.DOM
 */

(function($, BEM, undefined) {

/**
 * @namespace
 * @name Block
 */
BEM.decl('i-cache', /** @lends Block.prototype */ {}, /** @lends Block */ {

    _storage: {},

    cache: function(key, value) {
        // Setter
        if (value !== undefined) {
            this._storage[key] = value;
            return this;
        }

        // Getter
        if (!this._storage.hasOwnProperty(key)) {
            throw ReferenceError('No data in cache for key "' + key + '"');
        }
        return this._storage[key];
    }

});

})(jQuery, BEM);
;
/* ../../blocks-desktop/i-cache/i-cache.js: end */ /**/

/* ../../blocks-desktop/b-vb-config/b-vb-config.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

blocks['b-vb-config'] = function(data, width, height) {
    var vb = require('vb'),
        blocks = require('bem').blocks,
        BEM = require('bem').BEM,
        settings = BEM.blocks['i-cache'].cache('userSettings');

    return {
        block: "b-vb-config",
        js: true,
        content: [
            {
                elem: 'head',
                content: [
                    {
                        elem: 'wrapper',
                        content: [
                            {
                                block: 'b-page-title',
                                content: vb.getLocalizedString('settings')
                            },
                            {
                                elem: 'text',
                                content: [
                                    vb.getLocalizedString('settings.thumbsNum') + ': ' + vb.getLocalizedString('settings.layoutX') + ' ',
                                    blocks['b-form-select_action_set-x'](data, settings),
                                    '&emsp; ' + vb.getLocalizedString('settings.layoutY') + ' ',
                                    blocks['b-form-select_action_set-y'](data, settings)
                                ]
                            },
                            blocks['b-select-theme'](data, settings)
                        ]
                    }
                ]
            },
            {
                elem: 'content',
                content: [
                    blocks['b-background'](data),
                    blocks['b-tumbs'](data, width, height, 'config')
                ]
            },
            {
                elem: 'foot',
                content: [
                    {
                        elem: 'wrapper',
                        content: [
                            {
                                elem: 'text',
                                elemMods: { chbox: 'yes' },
                                tag: 'label',
                                attrs: { 'for' : 'set-show-searchform' },
                                content: [
                                    {
                                        block: 'b-form-checkbox',
                                        mods: {
                                            theme: 'grey-m',
                                            size: 'm',
                                            action: 'set-show-searchform',
                                            checked: settings.showSearchForm ? 'yes' : ''
                                        },
                                        checkboxAttrs: { id: 'set-show-searchform', value: '1', name: 'text' }
                                    }, vb.getLocalizedString('settings.showSearchForm')
                                ]
                            },
                            {
                                elem: 'text',
                                elemMods: { chbox: 'yes' },
                                tag: 'label',
                                attrs: { 'for' : 'set-show-bookmarks' },
                                content: [
                                    {
                                        block: 'b-form-checkbox',
                                        mods: {
                                            theme: 'grey-m',
                                            size: 'm',
                                            action: 'set-show-bookmarks',
                                            checked: settings.showBookmarks ? 'yes' : ''
                                        },
                                        checkboxAttrs: { id: 'set-show-bookmarks', value: '1', name: 'text' }
                                    }, ' ' + vb.getLocalizedString('settings.showBookmarksPanel')
                                ]
                            },
                            {
                                elem: 'text',
                                elemMods: { chbox: 'yes' },
                                tag: 'label',
                                attrs: { 'for' : 'set-send-stat' },
                                content: [
                                    {
                                        block: 'b-form-checkbox',
                                        mods: {
                                            theme: 'grey-m',
                                            size: 'm',
                                            action: 'set-send-stat',
                                            checked: settings.sendStat ? 'yes' : ''
                                        },
                                        checkboxAttrs: { id: 'set-send-stat', value: '1', name: 'text' }
                                    }, ' ' + vb.getLocalizedString('settings.sendstat')
                                ]
                            },
                            (function (settings) {
                                if (!settings.isHomePage)
                                return {
                                    block: 'b-vb-config',
                                    elem: 'text',
                                    mods: {
                                        text: 'margin_25'
                                    },
                                    content: {
                                            block: 'b-link',
                                            js: true,
                                            mods: {'action' : 'make-homepage'},
                                            url: '#',
                                            content: vb.getLocalizedString('settings.setAsHomePage')
                                    }
                                }
                            })(settings)
                        ]
                    },
                    blocks['b-foot'](data)
                ]
            }
        ]
    };
};

blocks['b-vb-config__confirm'] = function(data) {
    var vb = require('vb');

    return {
        block: 'b-vb-config',
        elem: 'confirm',
        content: {
            elem: 'wrapper',
            content: [
                {
                    block: 'b-form-button',
                    mods: { theme: 'grey-l', size: 'l', action: 'save-settings' },
                    content: vb.getLocalizedString('settings.save')
                },
                {
                    block: 'b-link',
                    mods: { pseudo: 'yes', border: 'none', action: 'index' },
                    content: vb.getLocalizedString('settings.cancel')
                }
            ]
        }
    };
};

/**
 * Блок является «диспетчерезитором» всего редактирования
 * элементы посылают ему кастомные события с аргументами или без них,
 * а b-vb-config соответствующим образом все их обрабатывает, внося изменения в
 * хранилище настроек BEM.blocks['i-cache'].cache('saveSettings')
 */
BEM.DOM.decl('b-vb-config', {

    onSetMod: {

        js: function() {
            var vb = require('vb'),
                BEM = require('bem').BEM,
                saveSettings = BEM.blocks['i-cache'].cache('saveSettings');

            // Выбрали количество колонок
            BEM.blocks['b-form-select'].on('config_set-x', function(e, x) {
                saveSettings.x = ~~x;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Выбрали количество строк
            BEM.blocks['b-form-select'].on('config_set-y', function(e, y) {
                saveSettings.y = ~~y;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Выставили / сняли галочку про показ закладок
            BEM.blocks['b-form-checkbox'].on('config_set-show-bookmarks', function(e, showBookmarks) {
                saveSettings.showBookmarks = showBookmarks;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Выставили / сняли галочку про поиск
            BEM.blocks['b-form-checkbox'].on('config_set-show-searchform', function(e, showSearchForm) {
                saveSettings.showSearchForm = showSearchForm;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Выставили / сняли галочку про участие в улучшении сервисов
            BEM.blocks['b-form-checkbox'].on('config_set-send-stat', function(e, sendStat) {
                saveSettings.sendStat = sendStat;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Удаляем тумбу
            BEM.blocks['b-tumb'].on('config_delete', this._onDelete, this);

            // Пиним тумбу
            BEM.blocks['b-tumb'].on('config_pin', function(e, index) {
                saveSettings.thumbs[index].pinned = true;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Отпиниваем тумбу
            BEM.blocks['b-tumb'].on('config_unpin', function(e, index) {
                saveSettings.thumbs[index].pinned = false;
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
            });

            // Заменяем тумбу тумбой из последних посещенных
            BEM.blocks['b-tumb-lib'].on('config_set-tumb-lib', this._onSetTumbLib, this);

            // Обновляем параметры в тумбе измененные пользователем
            BEM.blocks['b-setting'].on('config_set-tumb-params', this._onSetTumbParams, this);

            // Загрузить пользовательскую картинку для фона
            BEM.blocks['b-link'].on('config_upload-background-image', this._onUploadBackgroundImage, this);

            // Выбираем текущий фон
            BEM.blocks['b-select-theme'].on('config_set-bg-image', this._onSetBgImage, this);

            // Сохраняем изменения
            BEM.blocks['b-form-button'].on('config_save-settings', this._onSave, this);

            // Отмена
            BEM.blocks['b-link'].on('config_cancel', this._onCancel, this);
        }
    },

    destruct: function() {
        var BEM = require('bem').BEM;

        // Удаляем  обработчики вместе с уничтожением объекта
        BEM.blocks['b-form-select'].un('config_set-x');
        BEM.blocks['b-form-select'].un('config_set-y');
        BEM.blocks['b-form-checkbox'].un('config_set-show-bookmarks');
        BEM.blocks['b-form-checkbox'].un('config_set-send-stat');
        BEM.blocks['b-tumb'].un('config_delete', this._onDelete, this);
        BEM.blocks['b-tumb'].un('config_pin');
        BEM.blocks['b-tumb'].un('config_unpin');
        BEM.blocks['b-tumb-lib'].un('config_set-tumb-lib', this._onSetTumbLib, this);
        BEM.blocks['b-setting'].un('config_set-tumb-params', this._onSetTumbParams, this);
        BEM.blocks['b-link'].un('config_upload-background-image', this._onUploadBackgroundImage, this);
        BEM.blocks['b-select-theme'].un('config_set-bg-image', this._onSetBgImage, this);
        BEM.blocks['b-form-button'].un('config_save-settings', this._onSave, this);
        BEM.blocks['b-link'].un('config_cancel', this._onCancel, this);

        // Вызывавем базовый метод
        this.__base.apply(this, arguments);
    },

    _onDelete: function(e, index) {
        var self = this,
            BEM = require('bem').BEM,
            BEMHTML = require('bemhtml'),
            settings = BEM.blocks['i-cache'].cache('settings'),
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings'),
            blocks = require('bem').blocks,
            Lib = require('lib'),
            winSize = self.__self.getWindowSize(),
            size = Lib.getThumbSize(settings.x, settings.y, winSize.width, winSize.height),
            thumb = self.findBlockInside({ block: 'b-tumb', modName: 'index', modVal: '' + index });

        if (thumb) {
            // Заменяем удаленную тумбу пустой
            BEM.DOM.update(thumb.domElem.parent(), BEMHTML.apply(
                blocks['b-tumb'](settings, null, index, size, 'config')
            ));

            // Удаляем тумбу из хранилища
            delete saveSettings.thumbs[index];
            BEM.blocks['i-cache'].cache('saveSettings', saveSettings);

            // Удаляем тумбу из хранилища
            delete settings.thumbs[index];
            BEM.blocks['i-cache'].cache('settings', settings);
        }
    },

    _onSetTumbLib: function(e, item) {
        var self = this,
            BEM = require('bem').BEM,
            BEMHTML = require('bemhtml'),
            settings = BEM.blocks['i-cache'].cache('settings'),
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings'),
            blocks = require('bem').blocks,
            Lib = require('lib'),
            winSize = self.__self.getWindowSize(),
            size = Lib.getThumbSize(settings.x, settings.y, winSize.width, winSize.height),
            thumb = this.findBlockInside({ block: 'b-tumb', modName: 'editing', modVal: 'yes' });

        if (thumb) {
            var index = ~~thumb.getMod('index'),
                item = $.extend({}, item, { pinned: true });

            // Заменяем тумбу тумбой из библиотеки последних посещенных
            BEM.DOM.update(thumb.domElem.parent(), BEMHTML.apply(
                blocks['b-tumb'](settings, item, index, size, 'config')
            ));

            // Обновляем данные о тумбе в хранилще
            settings.thumbs[index] = item;
            BEM.blocks['i-cache'].cache('settings', settings);

            // Подготавливаем данные о тумбе для сохранения
            saveSettings.thumbs[index] = item;
            BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
        }
    },

    _onSetTumbParams: function() {
        var self = this,
            $ = require('$'),
            BEM = require('bem').BEM,
            BEMHTML = require('bemhtml'),
            settings = BEM.blocks['i-cache'].cache('settings'),
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings'),
            blocks = require('bem').blocks,
            Lib = require('lib'),
            winSize = self.__self.getWindowSize(),
            size = Lib.getThumbSize(settings.x, settings.y, winSize.width, winSize.height),
            bThumb = self.findBlockInside({ block: 'b-tumb', modName: 'editing', modVal: 'yes' }),
            bPage = self.findBlockOutside('b-page'),
            bSetting = bPage && bPage.findBlockInside('b-setting');

        if (bThumb && bSetting) {
            var index = ~~bThumb.getMod('index'),
                url = bSetting.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'url' }).val(),
                title = bSetting.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'title' }).val(),
                item = $.extend({}, {                                           // Расширяем данные о тумбе параметрами из формы
                    pinned: true,
                    url: url,
                    title: title
                }),
                newItem = $.extend({}, {
                    pinned: true,
                    url: url,
                    title: title || url
                });

            // Заменяем тумбу тумбой полученной после редактирования
            BEM.DOM.update(bThumb.domElem.parent(), BEMHTML.apply(
                blocks['b-tumb'](settings, newItem, index, size, 'config')
            ));

            // Обновляем данные о тумбе в хранилще
            settings.thumbs[index] = item;
            BEM.blocks['i-cache'].cache('settings', settings);

            // Подготавливаем данные о тумбе для сохранения
            saveSettings.thumbs[index] = item;
            BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
        }
    },

    _onUploadBackgroundImage: function() {
        var vb = require('vb'),
            BEM = require('bem').BEM,
            BEMHTML = require('bemhtml'),
            blocks = require('bem').blocks,
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings'),
            userSettings = BEM.blocks['i-cache'].cache('userSettings'),
            url = vb.uploadUserBackground(),
            bSelectTheme = this.findBlockInside('b-select-theme'),
            userImageWrapper = bSelectTheme && bSelectTheme.findElem('item', 'user', 'yes');

            if (url) {
                saveSettings.userImage = url;
                userSettings.userImage = url;
                saveSettings.changeUserImage = true;
                newBSelectTheme = BEMHTML.apply(blocks['b-select-theme'](null, userSettings, saveSettings));
                BEM.DOM.update(
                        bSelectTheme.domElem,
                        newBSelectTheme
                );
                BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
                BEM.blocks['i-cache'].cache('userSettings', userSettings);
            }
    },

    _onSetBgImage: function(e, data) {
        var bg,
            BEM = require('bem').BEM,
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings');

        if (data.isUser) {
            bg = 'user';
        } else {
            bg = data.bIcon.domElem[0].src;
        }

        saveSettings.bgImage = bg;
        BEM.blocks['i-cache'].cache('saveSettings', saveSettings);
    },

    _onSave: function() {

        var vb = require('vb'),
            BEMHTML = require('bemhtml'),
            BEM = require('bem').BEM,
            saveSettings = BEM.blocks['i-cache'].cache('saveSettings');

        $('body').append(BEMHTML.apply({ block : 'b-paranja' }));
        vb.saveSettings(
            saveSettings.x,
            saveSettings.y,
            saveSettings.showBookmarks,
            saveSettings.sendStat,
            saveSettings.showSearchForm,
            saveSettings.changeUserImage,
            saveSettings.bgImage,
            saveSettings.thumbs
        );
    },

    _onCancel: function() {
        var vb = require('vb');

        vb.requestInit();
    }

});;
/* ../../blocks-desktop/b-vb-config/b-vb-config.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_index.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'index'}, {

    onSetMod: {

        js: function() {
            var self = this;
            self.on('click', function(e) {
                this.trigger('config_cancel');
            });
        }

    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_index.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_upload-background-image.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

    BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'upload-background-image'}, {}, {

        live : function() {
            this.on('click', function() {
                this.trigger('config_upload-background-image');
            });

        }

    })
})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_upload-background-image.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-button/b-form-button.js: begin */ /**/
BEM.DOM.decl('b-form-button', {

    onSetMod : {

        'js' : function() {

            var disabled = this.isDisabled();

            (this._href = this.domElem.attr('href')) && disabled &&
                this.domElem.removeAttr('href');

            this.elem('input').attr('disabled', disabled);

        },

        'focused' : {

            'yes' : function() {

                var _this = this;

                if(_this.isDisabled())
                    return false;

                _this
                    .bindTo('keydown', this._onKeyDown)
                    .elem('input').is(':focus') || _this.elem('input').focus();

                _this._unloadInited ||
                    (_this._unloadInited = $(window).bind('unload', function() {
                        _this.delMod('focused');
                    }));

            },

            '' : function() {

                this
                    .unbindFrom('keydown')
                    .elem('input').blur();

            }

        },

        'disabled' : function(modName, modVal) {

            var disable = modVal == 'yes';

            this._href && (disable?
                this.domElem.removeAttr('href') :
                this.domElem.attr('href', this._href));

            disable && this.domElem.keyup();

            this.afterCurrentEvent(function() {
                this.domElem && this.elem('input').attr('disabled', disable);
            });

        },

        'pressed' : function(modName, modVal) {

            this.isDisabled() || this.trigger(modVal == 'yes'? 'press' : 'release');

        },

        'hovered' : {

            '' : function() {

                this.delMod('pressed');

            }

        },

        '*' : function(modName) {

            if(this.isDisabled() && 'hovered pressed'.indexOf(modName) > -1)
                return false;

        }

    },

    /**
     * Шорткат для проверки модификатора disabled_yes
     * @returns {Boolean}
     */
    isDisabled : function() {

        return this.hasMod('disabled', 'yes');

    },

    /**
     * Получение/установка урла (для кнопки-ссылки)
     * @param {String} [val] урл
     */
    url : function(val) {

        if(typeof val == 'undefined') {
            return this._href;
        } else {
            this._href = val;
            this.isDisabled() || this.domElem.attr('href', val);
            return this;
        }

    },

    _onKeyDown : function(e) {

        var keyCode = e.keyCode;
        // имитируем state_pressed по нажатию на enter и space
        if((keyCode == 13 || keyCode == 32) && !this._keyDowned) {
            this._keyDowned = true;
            this
                .setMod('pressed', 'yes')
                .bindTo('keyup', function() {
                    this
                        .delMod('pressed')
                        .unbindFrom('keyup');
                    delete this._keyDowned;
                    // делаем переход по ссылке по space
                    if(keyCode == 32 && this.domElem.attr('href')) {
                        document.location = this.domElem.attr('href');
                    }
                });
        }

    },

    _onClick : function(e) {

        this.isDisabled()?
            e.preventDefault() :
            this.afterCurrentEvent(function() {
                this.trigger('click');
            });
    },
    destruct : function () {
        this.delMod('focused');
        this.__base.apply(this, arguments);
    }

}, {

    live : function() {

        var eventsToMods = {
            'mouseover' : { name : 'hovered', val : 'yes' },
            'mouseout' : { name : 'hovered' },
            'mousedown' : { name : 'pressed', val : 'yes' },
            'mouseup' : { name : 'pressed' },
            'focusin' : { name : 'focused', val : 'yes' },
            'focusout' : { name : 'focused' }
        };

        this
            .liveBindTo('leftclick', function(e) {
                this._onClick(e);
            })
            .liveBindTo('mouseover mouseout mouseup focusin focusout', function(e) {
                var mod = eventsToMods[e.type];
                this.setMod(mod.name, mod.val || '');
            })
            .liveBindTo('mousedown', function(e) {
                var mod = eventsToMods[e.type];
                e.which == 1 && this.setMod(mod.name, mod.val || '');
            });
    }

});

BEM.HTML.decl('b-form-button', {

    onBlock : function(ctx) {

        ctx
            .tag(ctx.param('url')? 'a' : 'span')
            .attrs({ href : ctx.param('url'), target : ctx.param('target') })
            .mods({
                size : ctx.mod('size'),
                theme : ctx.mod('theme')
            })
            .content(
                [
                    { elem : 'left', tag : 'i' },
                    {
                        elem : 'content',
                        tag : 'span',
                        content : {
                            elem : 'text',
                            tag : 'span',
                            content : ctx.content()
                        }
                    }
                ],
                true)
            .afterContent(
                ctx.param('type')?
                    {
                        elem : 'input',
                        attrs : {
                            value : ctx.param('value') || '',
                            type : ctx.param('type'),
                            name : ctx.param('name'),
                            disabled : ctx.mod('disabled') && 'disabled'
                        }
                    } :
                    { elem : 'click' })
            .js(true);

    },

    onElem : {

       'input' : function(ctx) {

           ctx.tag('input');

       },

       'click' : function(ctx) {

           ctx.tag('i');

       }

    }

});
;
/* ../../lego/blocks-desktop/b-form-button/b-form-button.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-select/b-form-select.js: begin */ /**/
(function($, BEM, undefined) {

var DOM = BEM.DOM,
    HTML = BEM.HTML,

    KEYDOWN_EVENT = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown',

    /** {String} */
    BLOCK_NAME = 'b-form-select';

/**
  Вариант данных для API
  @example
  var data = [
   {
       item: 'optgroup',
       label: 'Russia',
       disabled: 1,    // optional
       content: [
         { item: 'option', value: '1', content: 'Moscow' },
         { item: 'option', value: '1', content: 'Saint-Peterburg', disabled: 1 }
       ]
   },
   { item: 'option', value: '3', content: 'Paris', selected: 1 },
   { item: 'option', value: '7', content: 'California', disabled: 1 }
  ];

  formSelect.setOptions(data);
 */

/**
 * @param {Object} item
 * @param {Number} i
 * @param {Object} [params]
 * @returns {BEMJSON}
 */
function buildOption(item, i, params) {
    var it = {};

    if(item.item === 'option') {

        it = {
            block: BLOCK_NAME,
            elem: 'option',
            tag: 'option',
            attrs: { value: item.value },
            content: item.content
        };

        item.disabled && (it.attrs.disabled = 'disabled');
        item.selected && (it.attrs.selected = 'selected');

    } else if(item.item === 'optgroup') {

        it = {
            elem: 'option-group',
            tag: 'optgroup',
            attrs: { label: item.label }
        };

        item.disabled && (it.attrs.disabled = 'disabled');

        it.content = Array.isArray(item.content) ?
            item.content.map(function(node, i) {
                return buildOption(node, i);
            })
            : item.content;

    }

    it.block = BLOCK_NAME;

    if(params) {
        for(var p in params) if(params.hasOwnProperty(p)) it[k] = val;
    }

    return it;
}

/**
 * @private
 * @param {JQuery} node
 * @param {String|Object|Array} content
 * @param {Object} elMods
 * @returns {BEMJSON} BEMJSON-представление элемента
 */
function buildItemJson(node, content, elMods) {
    var item = {
            block: BLOCK_NAME,
            elem: 'item',
            content: {
                elem: 'text',
                tag: 'span',
                content: content || ' &nbsp; '
            },
            mods: {}
        };

    elMods && (item.mods = elMods);

    return item;
}

/**
 * @private
 * @param {Array} data
 * @returns {String}
 */
function buildItemsHtml(data) {
    /** {String} Имя блока */
    var block = BLOCK_NAME,
        /** {BEMJSON} разделитель в списке элементов */
        separatorItem = { block: block, elem: 'separator', tag: 'i' },
        items = [{ block: block, elem: 'fade', tag: 'i' }],
        inGroup = false;

    /**
     * @param {jQuery|[HTMLElement]} data
     * @param {Object} mods
     */
    function iterateNodes(data, mods) {
        var len = data.length;
        if(len) {
            var i = 0;

            do {
                var item = $(data[i]),
                    isDisabled = item.attr('disabled') && { disabled: 'yes' };

                if(item.is('optgroup')) {
                    inGroup = true;

                    !item.prev().is('optgroup') && items.push(separatorItem);
                    items.push(buildItemJson(item, item.attr('label'),
                        $.extend({ label: 'yes' }, isDisabled, mods)));

                    iterateNodes(item.children(), $.extend({ inner: 'yes' }, isDisabled, mods));
                } else {
                    items.push(buildItemJson(item, item.text(),
                        $.extend(isDisabled, item.is(':selected') && { selected: 'yes' }, mods)));
                }
            } while(++i < len || (inGroup && (items.push(separatorItem), inGroup = false)));
        }
    }

    iterateNodes(data);

    return HTML.build(items);
}


DOM.decl('b-form-select', {

    onSetMod : {

        'js': function() {

            this._items = [];
            this._curItemIndex = -1;

            /** {Number} Высота строки в списке по-умолчанию */
            this._rowHeight = 22;

            // тригерим `change` у select-а, для синхронизации надписи на кнопке и выбранного пункта
            this._getSelectedText() !== this._buttonText() &&
                this.elem('select').trigger('change');

        },

        'disabled' : function(modName, modVal) {

            var disabled = modVal === 'yes';

            this.elem('select').attr('disabled', disabled);
            this._getButton().setMod(modName, modVal);

            disabled && this.delMod('opened').delMod('focused');

        },

        'focused' : {

            'yes' : function(modName, modVal) {

                if(this.hasMod('disabled', 'yes'))
                    return false;

                this._getButton().setMod(modName, modVal);

                this
                    .bindTo('keypress', function(e) {
                        this._onKeyPress(e);
                    })
                    .bindTo(KEYDOWN_EVENT, function(e) {
                        this._onKeyDown(e);
                    })
                    .trigger('focusin');

            },

            '' : function(modName) {

                this
                    .delMod('opened')
                    ._getButton().delMod(modName);

                this
                    .unbindFrom('keypress ' + KEYDOWN_EVENT)
                    .trigger('focusout');

            }

        },

        'opened' : {

            'yes' : function() {

                if(this.hasMod('disabled', 'yes'))
                    return false;

                this._focus()._drawPopup();

                this.bindToWin('scroll resize', this._updatePopupPos)

            },

            '' : function() {

                this._getPopup().hide();

                this.unbindFromWin('scroll resize');

            }

        }

    },

    open : function() {

        return this.setMod('opened', 'yes');

    },

    close : function() {

        return this.delMod('opened');

    },

    isOpened : function() {

        return this.hasMod('opened', 'yes');

    },

    /**
     * Устанавливает/возвращает выбранное значение
     * @param {String} [val]
     * @returns {String|BEM.DOM}
     */
    val : function(val) {

        if(typeof val === 'undefined') {
            return this.elem('select').val();
        }

        // NOTE: `$(select).val('value')` позволяет выбрать за-disable-нный элемент
        var valIndex = -1, optgroup;
        this.findElem('option').each(function(idx) {
            this.value === val && !this.disabled &&
                (optgroup = $(this).parent('optgroup')[0], !(optgroup && optgroup.disabled)) &&
                (valIndex = idx);
        });

        valIndex > -1 && this._selectedIndex(valIndex);

        return this;
    },

    /**
     * Устанавливает/возвращает номер выбранного элемента
     * @private
     * @param {Number} [index]
     * @returns {Number}
     */
    _selectedIndex : function(index) {

        var prevIdx = this._getSelectedIndex();
        if(typeof index === 'undefined' || index === prevIdx) {
            // LEGO-7139: не тригерить `change` если значение не изменилось
            return prevIdx;
        }

        // jQuery 1.6+ only
        //this.elem('select').prop('selectedIndex', index);
        this.elem('select')[0].selectedIndex = index;

        this._buttonText(this._getSelectedText());

        if(this._items[0]) {
            var current = this._items.eq(index);
            this
                .delMod(this._items, 'selected')
                .setMod(current, 'selected', 'yes');
        }

        this.trigger('change', { index: index, prev: prevIdx });

        return index;

    },

    /**
     * Устанавливает новое содержимое select-а
     * @param {[Object]} data
     * @returns {BEM.DOM}
     */
    setOptions : function(data) {

        if(!data) return;

        DOM.update(this.elem('select'), HTML.build($.map(data, buildOption)));

        return this.updateItems();

    },

    /**
     * Обновить контент попапа
     */
    updateItems : function() {

        this._popup && this._redrawList();

        this.elem('select').trigger('change');

        return this;

    },

    _focus : function() {

        return this.setMod('focused', 'yes');

    },

    _blur : function() {

        return this.delMod('focused');

    },

    /**
     * Хелпер для чтения/обновления текста кнопки
     * @private
     * @param {String} [text]
     */
    _buttonText : function(text) {

        if(typeof text === 'undefined') {
            return this._getButton().elem('text').text();
        }

        return this._getButton().elem('text').html(text || ' &nbsp; ');

    },


    /* Events */

    _onClick : function(e) {

        this.toggleMod('opened', 'yes', '');

    },

    _onFocus : function(e) {

        this.toggleMod('focused', 'yes', '', e.type === 'focusin');

    },

    _onSelectChange : function(e) {
        var _this = this;

        _this._buttonText(_this._getSelectedText());

        // XXX: иначе неверно работает в IE
        setTimeout(function() {
            _this.trigger('change', {
                index: _this._getSelectedIndex(),
                prev: -1
            });
        }, 1);
    },

    _onKeyPress : function(e) {

        if(e.keyCode === 13) {
            e.preventDefault();

            if(this.isOpened()) {
                this._curItemIndex > -1 ?
                    this._onSelectItem(this._items.eq(this._curItemIndex)) : this.close();
            } else {
                // LEGO-6711
                return this._getButton().delMod('pressed');
            }
        }

    },

    _onKeyDown : function(e) {

        var keyCode = e.keyCode;

        if(keyCode === 38 || keyCode === 40) {
            e.preventDefault();

            if(!this.isOpened())
                return this.open(e);

            var len = this._items.length;
            if(len) {
                var direction = keyCode - 39, // пользуемся особенностями кодов клавиш "вверх"/"вниз" ;-)
                    idx = this._curItemIndex,
                    i = 0;

                do {
                    idx += direction;
                } while(idx >= 0 && idx < len &&
                    this._onEnterItem(this._items.eq(idx), true) === false && ++i < len);
            }
        } else if(keyCode === 32 && !this._keyPressed) {

            this._keyPressed = true;
            this._onClick();

            // XXX: LEGO-6757
            this.bindTo('keyup', function() {
                this.unbindFrom('keyup');
                this._keyPressed = false;
            });

        }

    },

    _onEnterItem : function(item, byKeyboard) {

        if(!this._isSelectableItem(item)) {
            return false;
        }

        var items = this._items,
            idx = this._curItemIndex;

        idx > -1 && this.delMod(items.eq(idx), 'hovered');
        idx = this._getItemIndex(item);
        idx > -1 && this.setMod(items.eq(this._curItemIndex = idx), 'hovered', 'yes');

        if(byKeyboard) {
            this._selectedIndex(this._curItemIndex);

            this._scrollToCurrent();
        }

    },

    _onLeaveItem : function(item) {

        var idx = this._curItemIndex;
        if(idx > -1 && idx === this._getItemIndex(item)) {
            this.delMod(this._items.eq(idx), 'hovered')._curItemIndex = -1;
        }

    },

    _onSelectItem : function(item) {

        if(this._isSelectableItem(item))
            this._selectedIndex(this._curItemIndex);

        // (HACK): Превентим сброс фокуса у b-form-button после выбора элемента
        this.afterCurrentEvent(function() {
            this._getButton().setMod('focused', 'yes');
        });

        return this.close();

    },

    _isOutsideClicked : function(e, data) {

        return this.containsDomElem($(data.domEvent.target));

    },


    /* Helpers */

    _getItemIndex : function(item) {

        return $.inArray(item.get(0), this._items);

    },

    _getSelectedText : function() {

        return this.elem('select').find(':selected').text();

    },

    _getSelectedIndex : function() {

        return this.elem('select')[0].selectedIndex;

    },

    /**
     * @private
     * @param {jQuery} item
     * @returns {Boolean}
     */
    _isSelectableItem : function(item) {

        return !(this.hasMod(item, 'disabled', 'yes') || this.hasMod(item, 'label', 'yes'));

    },

    /**
     * Ленивый поиск кнопки
     * @private
     * @returns {BEM.DOM}
     */
    _getButton : function() {

        return this._button || (this._button = this.findBlockInside('b-form-button'));

    },

    /**
     * Ленивое построение попапа
     * @private
     * @returns {BEM.DOM}
     */
    _getPopup : function() {

        if(this._popup) return this._popup;

        var _this = this,
            blockName = _this.__self.getName(),
            list = {
                block: blockName,
                elem: 'list'
            },
            popupMix = {
                block: blockName,
                elem: 'popup',
                mods: {}
            };

        // пробрасываем нужные модификаторы из блока в popup
        ['size', 'layout', 'theme', 'width'].forEach(function(mod, i) {
            _this.hasMod(mod) && (popupMix.mods[mod] = _this.getMod(mod));
        });

        var popup = $(HTML.build({
                block: 'i-popup',
                underMix : [{ block : 'b-popupa', elem : 'under' }],
                content: {
                    block: 'b-popupa',
                    mods: _this.params.popupMods,
                    mix: [
                        {
                            block: blockName
                        },
                        popupMix
                    ],
                    content: {
                        elem: 'content',
                        content: list
                    }
                }
            }));

        (_this._popup = _this.findBlockOn(popup, 'i-popup'))
            .on({
                'show' : function() {

                    _this._curItemIndex = _this._getSelectedIndex();

                    var current = _this._items.eq(_this._curItemIndex);
                    _this
                        .delMod(_this._items, 'selected')
                        .setMod(current, 'hovered', 'yes')
                        .setMod(current, 'selected', 'yes')
                        .bindToDoc('keydown', function(e) {
                            // Ловим `focusout` select-а с клавиатуры
                            if(e.keyCode === 9 && _this.isOpened()) {
                                _this._blur();
                            }
                        });

                },

                'outside-click' : function(e, data) {

                    _this._isOutsideClicked(e, data) ?
                            e.preventDefault() : _this._blur();

                },

                'hide' : function() {

                    _this._curItemIndex = -1;

                    _this
                        .delMod('opened')
                        .delMod(_this._items, 'hovered')
                        .delMod(_this.findElem(_this._popup.domElem, 'popup'), 'scrollable')
                        .unbindFromDoc('keydown');

                }
            })
            .bindTo('mousedown', function(e) {
                e.preventDefault();
            });

        BEM.DOM.append('body', _this._popup.domElem);

        _this._redrawList();

        /*
         * (HACK, LEGO-7251)
         */
        _this._outPopup = _this.findBlockOutside('button', 'b-popupa');
        _this._outPopup && _this._outPopup.on('outside-click', function(e, data) {
                _this._popup.containsDomElem($(data.domEvent.target)) &&
                    e.preventDefault();
            });

        return this._popup;
    },

    _redrawList : function() {

        var _this = this,
            popup = _this._getPopup().domElem,
            items;

        DOM.update(this.findElem(popup, 'list'), buildItemsHtml(this.elem('select').children()));

        items = this.findElem(popup, 'item');

        this._curItemIndex = -1;
        this._items = items.filter(function() {
            return !_this.hasMod($(this), 'label', 'yes');
        });

        // (XXX, LEGO-7889): Результат отказа от связки попапы и селекта через `_uniqId`
        this.bindTo(items, {
            'mouseup' : function(e) {
                e.which === 1 &&
                    (e.preventDefault(), _this._onSelectItem(e.data.domElem));
            },
            'mouseover' : function(e) {
                _this._onEnterItem(e.data.domElem);
            },
            'mouseout' : function(e) {
                _this._onLeaveItem(e.data.domElem);
            }
        });

        return this;

    },

    _popupPos : function() {

        var btn = this._getButton().domElem,
            css = btn.offset();

        css.top += btn.outerHeight();

        return css;

    },

    _updatePopupPos : function() {

        var css = this._popupPos();

        css && this._getPopup().domElem.css(css);

    },

    _drawPopup : function() {

        var css = this._popupPos(),
            popup = this._getPopup();

        popup.show(css);

        this._calcPopupDimensions();

        this._scrollToCurrent();

    },

    _getRowHeight : function() {

        return this.findElem(this._getPopup().domElem, 'item').outerHeight();

    },

    _calcPopupDimensions : function () {

        if(!this._popupContent)
            this._popupContent = this._getPopup().findBlockInside('b-popupa').elem('content');

        var rows = parseInt(this.params.rows, 10) || false;
        if(rows && this.findElem(this._popupContent, 'item').size() > rows) {
            this._rowHeight = this._getRowHeight();

            this._popupContent.css('height', rows * this._rowHeight);

            this.setMod(this.findElem(this._getPopup().domElem, 'popup'), 'scrollable', 'yes');
        }

    },

    _scrollToCurrent : function() {

        if(!this._popupContent || this._curItemIndex < 0) return;

        var curOffsetTop = this.findElem(
                this._getPopup().domElem, 'item', 'selected', 'yes').get(0).offsetTop,
            popContent = this._popupContent,
            popScrollTop = popContent.scrollTop(),

            disp = curOffsetTop - popScrollTop,
            fact = this._rowHeight * 2,
            newScrollTop;

        if(disp > popContent.height() - fact) {
            newScrollTop = curOffsetTop - fact;
        } else if(popScrollTop && disp < fact) {
            newScrollTop = curOffsetTop - popContent.height() + fact;
        }

        newScrollTop && popContent.scrollTop(newScrollTop);

    },

    destruct : function() {

        this._outPopup && this._outPopup.un('outside-click');

        var popup = this._popup;
        popup && popup.destruct();

        this.__base.apply(this, arguments);

    },

    getDefaultParams : function() {

        return {
            rows: 13,
            popupMods: {
                direction: 'down'
            }
        };

    }

}, {

    live : function() {

        this
            .liveBindTo('button', 'focusin focusout', function(e) {
                this._onFocus(e);
            })
            .liveBindTo('button', 'mousedown', function(e) {
                e.which === 1 &&
                    (e.preventDefault(), this._onClick(e));
            })
            .liveBindTo('select', 'change', function(e) {
                this._onSelectChange();
            });

        return false;

    }

});

}(jQuery, BEM));
;
/* ../../lego/blocks-desktop/b-form-select/b-form-select.js: end */ /**/

/* ../../blocks-desktop/b-form-select/b-form-select.js: begin */ /**/
//TODO это полное переопределение лего!
(function($, BEM, undefined) {

var DOM = BEM.DOM,
    HTML = BEM.HTML,

    KEYDOWN_EVENT = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown',
    IS_MSIE_LT_9 = $.browser.msie && $.browser.version < 9,

    /** {String} */
    BLOCK_NAME = 'b-form-select';

/**
  Вариант данных для API
  @example
  var data = [
   {
       item: 'optgroup',
       label: 'Russia',
       disabled: 1,    // optional
       content: [
         { item: 'option', value: '1', content: 'Moscow' },
         { item: 'option', value: '1', content: 'Saint-Peterburg', disabled: 1 }
       ]
   },
   { item: 'option', value: '3', content: 'Paris', selected: 1 },
   { item: 'option', value: '7', content: 'California', disabled: 1 }
  ];

  formSelect.setOptions(data);
 */

/**
 * @param {Object} item
 * @param {Number} i
 * @param {Object} [params]
 * @returns {BEMJSON}
 */
function buildOption(item, i, params) {
    var it = {};

    if(item.item === 'option') {

        it = {
            block: BLOCK_NAME,
            elem: 'option',
            tag: 'option',
            attrs: { value: item.value },
            content: item.content
        };

        item.disabled && (it.attrs.disabled = 'disabled');
        item.selected && (it.attrs.selected = 'selected');

    } else if(item.item === 'optgroup') {

        it = {
            elem: 'option-group',
            tag: 'optgroup',
            attrs: { label: item.label }
        };

        item.disabled && (it.attrs.disabled = 'disabled');

        it.content = Array.isArray(item.content) ?
            item.content.map(function(node, i) {
                return buildOption(node, i);
            })
            : item.content;

    }

    it.block = BLOCK_NAME;

    if(params) {
        for(var p in params) if(params.hasOwnProperty(p)) it[k] = val;
    }

    return it;
}

/**
 * @private
 * @param {JQuery} node
 * @param {String|Object|Array} content
 * @param {Object} elMods
 * @returns {BEMJSON} BEMJSON-представление элемента
 */
function buildItemJson(node, content, elMods) {
    var item = {
            block: BLOCK_NAME,
            elem: 'item',
            content: {
                elem: 'text',
                tag: 'span',
                content: content || ' &nbsp; '
            },
            mods: {}
        };

    elMods && (item.mods = elMods);

    return item;
}

/**
 * @private
 * @param {Array} data
 * @returns {String}
 */
function buildItemsHtml(data) {
    /** {String} Имя блока */
    var block = BLOCK_NAME,
        /** {BEMJSON} разделитель в списке элементов */
        separatorItem = { block: block, elem: 'separator', tag: 'i' },
        items = [{ block: block, elem: 'fade', tag: 'i' }],
        inGroup = false;

    /**
     * @param {jQuery|[HTMLElement]} data
     * @param {Object} mods
     */
    function iterateNodes(data, mods) {
        var len = data.length;
        if(len) {
            var i = 0;

            do {
                var item = $(data[i]),
                    isDisabled = item.attr('disabled') && { disabled: 'yes' };

                if(item.is('optgroup')) {
                    inGroup = true;

                    !item.prev().is('optgroup') && items.push(separatorItem);
                    items.push(buildItemJson(item, item.attr('label'),
                        $.extend({ label: 'yes' }, isDisabled, mods)));

                    iterateNodes(item.children(), $.extend({ inner: 'yes' }, isDisabled, mods));
                } else {
                    items.push(buildItemJson(item, item.text(),
                        $.extend(isDisabled, item.is(':selected') && { selected: 'yes' }, mods)));
                }
            } while(++i < len || (inGroup && (items.push(separatorItem), inGroup = false)));
        }
    }

    iterateNodes(data);

    return HTML.build(items);
}


DOM.decl('b-form-select', {


}, {

    live : function() {

        this
            .liveBindTo('button', 'focusin focusout', function(e) {

                // LEGO-8208
                if(IS_MSIE_LT_9 && e.type == 'focusout') {
                    return;
                }

                this._onFocus(e);
            })
            .liveBindTo('button', 'mousedown', function(e) {
                e.which === 1 &&
                    (e.preventDefault(), this._onClick(e));
            })
            .liveBindTo('select', 'change', function(e) {
                this._onSelectChange();
            });

        return false;

    }

});

}(jQuery, BEM));
;
/* ../../blocks-desktop/b-form-select/b-form-select.js: end */ /**/

/* ../../blocks-desktop/b-form-select/_action/b-form-select_action_set-x.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

blocks['b-form-select_action_set-x'] = function(data, settings) {
    var MIN_LAYOUT_X = 1;

    return {
        block: 'b-form-select',
        name: 'col-horiz',
        mods: { size: 's', theme: 'grey', action: 'set-x' },
        content: [
            {
                block: 'b-form-button',
                type: 'button',
                mods: { size: 's', theme: 'grey-s', valign: 'middle' },
                content: '' + data.x
            },
            {
                elem: 'select',
                content: (function(data, settings) {
                    var items = [];
                    for (var i = MIN_LAYOUT_X; i <= settings.maxLayoutX; i++) {
                        items.push({
                            elem: 'option',
                            elemMods: {
                                selected: (i === data.x) ? 'yes' : ''
                            },
                            attrs: (function(data, i) {
                                var attrs = { value: i };

                                if (i === data.x) {
                                    attrs.selected = 'selected';
                                }
                                return attrs;
                            })(data, i),
                            content: '' + i
                        });
                    }
                    return items;
                })(data, settings)
            }
        ]
    };
};

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-select', modName: 'action', modVal: 'set-x'}, {

    _onSelectItem: function(item) {
        this.__base.apply(this, arguments);
        this.trigger('config_set-x', this.val());
    }

});

})();
;
/* ../../blocks-desktop/b-form-select/_action/b-form-select_action_set-x.js: end */ /**/

/* ../../blocks-desktop/b-form-select/_action/b-form-select_action_set-y.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

blocks['b-form-select_action_set-y'] = function(data, settings) {
    var MIN_LAYOUT_Y = 1;

    return {
        block: 'b-form-select',
        name: 'col-vert',
        mods: { size: 's', theme: 'grey', action: 'set-y' },
        content: [
            {
                block: 'b-form-button',
                type: 'button',
                mods: { size: 's', theme: 'grey-s', valign: 'middle' },
                content: '' + data.y
            },
            {
                elem: 'select',
                content: (function(data, settings) {
                    var items = [];
                    for (var i = MIN_LAYOUT_Y; i <= settings.maxLayoutY; i++) {
                        items.push({
                            elem: 'option',
                            elemMods: {
                                selected: (i === data.y) ? 'yes' : ''
                            },
                            attrs: (function(data, i) {
                                var attrs = { value: i };

                                if (i === data.y) {
                                    attrs.selected = 'selected';
                                }
                                return attrs;
                            })(data, i),
                            content: '' + i
                        });
                    }
                    return items;
                })(data, settings)
            }
        ]
    };
};

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-select', modName: 'action', modVal: 'set-y'}, {

    _onSelectItem: function(item) {
        this.__base.apply(this, arguments);
        this.trigger('config_set-y', this.val());
    }

});

})();
;
/* ../../blocks-desktop/b-form-select/_action/b-form-select_action_set-y.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-checkbox/b-form-checkbox.js: begin */ /**/
BEM.DOM.decl('b-form-checkbox', {

    onSetMod : {

        'js' : function() {

            var _this = this,
                checkboxElem = _this.elem('checkbox');

            try {
                // В iframe в IE9 происходит "Error: Unspecified error."
                var activeNode = _this.__self.doc[0].activeElement;
            } catch(e) {}

            _this.setMod('checked', checkboxElem.attr('checked')? 'yes' : '');
            activeNode === checkboxElem[0] && _this.setMod('focused', 'yes');

        },

        'focused' : {

            'yes' : function() {

                if(this.isDisabled())
                    return false;

                this.elem('checkbox').focus();

            },

            '' : function() {

                this.elem('checkbox').blur();

            }

        },

        'checked' : function(modName, modVal) {
            this.elem('checkbox').attr('checked', modVal == 'yes');
            this.elem('tick').attr('alt', ((modVal == 'yes')? ' v' : ''));
            this.afterCurrentEvent(function(){
               this.trigger('change');
            });
        },

        'disabled' : function(modName, modVal) {
            this.elem('checkbox').attr('disabled', modVal == 'yes');
        }

    },

    /**
     * Шорткат для проверки модификатора disabled_yes
     * @returns {Boolean}
     */
    isDisabled : function() {
        return this.hasMod('disabled', 'yes');
    },

    isChecked : function() {
        return this.hasMod('checked', 'yes');
    },

    toggle : function() {
        this.toggleMod('checked', 'yes', '');
    },

    val : function(val) {
        var checkbox = this.elem('checkbox');
        return val == undefined?
            checkbox.val() :
            checkbox.val(val);
    },

    _onClick : function(e) {
        // Нам нужен только клик левой кнопки мыши и нажатие пробела
        if (e.button) return;

        this.isDisabled() || this.setMod('focused', 'yes');
    },

    _onChange : function(e) {
        e.target.checked?
            this.setMod('checked', 'yes') :
            this.delMod('checked');
    }

}, {

    live : function() {

        this
            .liveBindTo('checkbox', 'click', function(e) {
                this._onClick(e);
            })
            .liveBindTo('checkbox', 'change', function(e) {
                this._onChange(e);
            })
            .liveBindTo('checkbox', 'focusin focusout', function(e) {
                this.setMod('focused', e.type == 'focusin'? 'yes' : '');
            });

        return false;
    }

});

BEM.HTML.decl('b-form-checkbox', {

    onBlock: function(ctx){
        var checkboxAttrs = ctx.param('checkboxAttrs') || {};
        ctx
            .js(true)
            .mix(!ctx.mod('size') ? [{ block: 'b-form-checkbox', mods: { size: 'm' } }] : '')
            .tag('span')
            .tParam('checkboxAttrs', $.extend(checkboxAttrs || {}, {
                id: ctx.param('id') || checkboxAttrs.id || $.identify(),
                checked: ctx.mod('checked') ? 'checked' : undefined,
                disabled: ctx.mod('disabled') ? 'disabled' : undefined
            }))
            .beforeContent({
                elem: 'inner',
                content: [
                    {
                        elem: 'checkbox',
                        attrs: ctx.tParam('checkboxAttrs')
                    },
                    { elem: 'bg' }
                ]
            });
    },

    onElem: {

        'label': function(ctx) {
            ctx
                .tag('label')
                .attr('for', ctx.tParam('checkboxAttrs').id)
        },

        'checkbox': function(ctx){
            ctx
                .tag('input')
                .attrs($.extend(ctx.attrs(), { type: 'checkbox' }))
        },

        'bg': function(ctx){
            ctx
                .tag('i')
                .content({elem: 'tick'})
        },

        'tick': function(ctx){
            ctx.tag('i')
        },

        'inner': function(ctx){
            ctx.tag('span')
        }

    }

});
;
/* ../../lego/blocks-desktop/b-form-checkbox/b-form-checkbox.js: end */ /**/

/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-show-bookmarks.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-checkbox', modName: 'action', modVal: 'set-show-bookmarks'}, {

    _onChange:function() {
        this.__base.apply(this, arguments);
        this.trigger('config_set-show-bookmarks', this.isChecked());
    }

});

})();
;
/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-show-bookmarks.js: end */ /**/

/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-send-stat.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-checkbox', modName: 'action', modVal: 'set-send-stat'}, {

    _onChange:function() {
        this.__base.apply(this, arguments);
        this.trigger('config_set-send-stat', this.isChecked());
    }

});

})();
;
/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-send-stat.js: end */ /**/

/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-show-searchform.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-checkbox', modName: 'action', modVal: 'set-show-searchform'}, {

    _onChange:function() {
        this.__base.apply(this, arguments);
        this.trigger('config_set-show-searchform', this.isChecked());
    }

});

})();
;
/* ../../blocks-desktop/b-form-checkbox/_action/b-form-checkbox_action_set-show-searchform.js: end */ /**/

/* ../../blocks-desktop/b-form-button/_action/b-form-button_action_save-settings.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-button', modName: 'action', modVal: 'save-settings'}, {

    _onClick : function(e) {
        this.__base.apply(this, arguments);
        this.trigger('config_save-settings');
    }

});

})();
;
/* ../../blocks-desktop/b-form-button/_action/b-form-button_action_save-settings.js: end */ /**/

/* ../../blocks-desktop/b-select-theme/b-select-theme.js: begin */ /**/
blocks['b-select-theme'] = function(data, settings, saveSettings) {
    var vb = require('vb'),
        blocks = require('bem').blocks;

    return {
        block: 'b-select-theme',
        js: true,
        content: [
            {
                elem: 'item',
                elemMods: { type: 'title' },
                content: vb.getLocalizedString('settings.backgroundImage')
            },
            (function(data, settings, saveSettings) {
                var items = [],
                    images = settings.bgImages,
                    reg =/\?.*/,
                    isCurrent;
                for (var i = 0, len = images.length; i < len; i++) {
                    var url = images[i];
                    if (!saveSettings)
                        isCurrent = url.replace(reg, '') === settings.selectedBgImage.replace(reg, '');
                    else
                        isCurrent = url.replace(reg, '') === saveSettings.bgImage.replace(reg, '');
                    items.push(
                        blocks['b-select-theme__item'](data, settings, url, isCurrent)
                    )
                }

                //для выбранных пользователей
                var arrOfSelectedBg = settings.selectedBgImage.replace(reg, '').split('/');
                isCurrent = arrOfSelectedBg[arrOfSelectedBg.length-1].replace(/\..*/, '') == 'temp_user';
                isCurrent = isCurrent || arrOfSelectedBg[arrOfSelectedBg.length-1].replace(/\..*/, '') == 'user';

                if (settings.userImage) {
                    var item = blocks['b-select-theme__item'](
                            data,
                            settings,
                            settings.userImage,
                            isCurrent
                        );
                    item.elemMods.user = 'yes';
                    items.push(item);
                }

                return items;
            })(data, settings, saveSettings),
            {
                elem: 'item',
                elemMods: { type: 'load' },
                content: [
                    {
                        block: 'b-link',
                        mods: {
                            pseudo: 'yes',
                            border: 'none',
                            action: 'upload-background-image'
                        },
                        content: vb.getLocalizedString('settings.upload')
                    }
                ]
            }
        ]
    };
};

blocks['b-select-theme__item'] = function(data, settings, url, isCurrent) {
    var item = {
        block: 'b-select-theme',
        elem: 'item',
        js: {
            skin: url
        },
        elemMods: {
            type: 'img'
        },
        content: [
            {
                block: 'b-select-theme',
                elem: 'select'
            },
            {
                block: 'b-select-theme',
                elem: 'glow'
            },
            url && {
                block: 'b-icon',
                url: url,
                width: 60,
                height: 60
            }
        ]
    };

    if (isCurrent) {
        item.elemMods.state = 'current';
    }
    return item;
};

BEM.DOM.decl('b-select-theme', {

    onSetMod : {

        js : function() {
            var self = this;
            this.bindTo(this.findElem('item', 'type', 'img'), 'click', function(e){
                var item = e.data.domElem;
                self.delMod(self.findElem('item', 'state', 'current'), 'state');
                self.setMod(item, 'state', 'current');

                var bIcon = self.findBlockInside(item, 'b-icon'),
                    isUser = self.hasMod(item, 'user', 'yes');
                self.trigger('config_set-bg-image', {
                    bIcon: bIcon,
                    isUser: isUser
                });
            })
        }
    }
});;
/* ../../blocks-desktop/b-select-theme/b-select-theme.js: end */ /**/

/* ../../lego/blocks-desktop/b-icon/b-icon.js: begin */ /**/
BEM.HTML.decl('b-icon', {

    onBlock : function(ctx) {

        var a = { src: '//yandex.st/lego/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif', alt: '' },
            params = ctx.params(),
            props = ['alt', 'width', 'height'], p;

        params.url && (a.src = params.url);
        while(p = props.shift()) params[p] && (a[p] = params[p]);

        ctx
           .tag('img')
           .attrs(a);

    }

});
;
/* ../../lego/blocks-desktop/b-icon/b-icon.js: end */ /**/

/* ../../blocks-desktop-ie/b-icon/b-icon.js: begin */ /**/
BEM.HTML.decl('b-icon', {
    onBlock : function(ctx) {
        ctx.attr('src', 'fd://res/layout/_/La6qi18Z8LwgnZdsAr1qy1GwCwo.gif');
    }
});
;
/* ../../blocks-desktop-ie/b-icon/b-icon.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-attach/b-form-attach.js: begin */ /**/
BEM.DOM.decl('b-form-attach', {

    onSetMod : {

        'js' : function() {

            this._noFileText = this.elem('text').text();
            this._update();

            this.bindTo('reset', 'click', this.resetFile);

        }

    },

    /**
     * @returns {String}
     */
    getPath : function() {

        return this.findBlockInside('b-form-button').findElem('input').val();

    },

    resetFile : function() {

        var buttonInput = this.findBlockInside('b-form-button').findElem('input');

        buttonInput.replaceWith(BEM.HTML.build({
            block: 'b-form-button',
            elem: 'input',
            tag: 'input',
            attrs: { name: buttonInput.attr('name') || 'attachment', type: 'file' }
        }));

        this._update();
        this.delMod(this.elem('reset'), 'visibility');

        return this;
    },

    /**
     * @private
     */
    _update : function() {

        var fileName = this._getFileByPath(this.getPath());
        this._setFile(fileName);
        this._setExtension(this._getExtension(fileName));
        this.setMod(this.elem('reset'), 'visibility', 'visible');

    },

    /**
     * @private
     * @param {String} path
     * @returns {String}
     */
    _getFileByPath : function(path) {

        return path.split('\\').pop();

    },

    /**
     * @private
     * @param {String} fileName
     */
    _setFile : function(fileName) {

        this.setMod(this.elem('holder'), 'state', fileName ? '' : 'hidden');
        this.elem('text').text(fileName || this._noFileText);

    },

    _extensionsToMods: {
        'zip' : 'archive',
        'rar' : 'archive',
        'tar' : 'archive',
        'gz' : 'archive',
        '7z' : 'archive',
        'gif' : 'gif',
        'jpg' : 'jpg',
        'jpeg' : 'jpg',
        'png' : 'png',
        'eml' : 'eml',
        'exe' : 'exe',
        'm4a' : 'audio',
        'ogg' : 'audio',
        'mp3' : 'mp3',
        'wav' : 'wav',
        'wma' : 'wma',
        'flv' : 'video',
        'mov' : 'mov',
        'wmv' : 'wmv',
        'mp4' : 'mp4',
        'avi' : 'avi',
        'xls' : 'xls',
        'doc' : 'doc',
        'docx' : 'doc',
        'txt' : 'txt',
        'pdf' : 'pdf',
        'ppt' : 'ppt'
    },

    /**
     * @private
     * @param {String} fileName
     * @returns {String}
     */
    _getExtension : function(fileName) {

        return this._extensionsToMods[fileName.split('.').pop().toLowerCase()] || '';

    },

    /**
     * @private
     * @param {String} extension
     */
    _setExtension : function(extension) {

        this.setMod(this.elem('holder'), 'file', extension || 'unknown');

    }

}, {

    live : function() {

        this.liveBindTo('change', function() {
            this._update();
        });

        if ($.browser.msie && parseInt($.browser.version) <= 8) {

            var intervalId,
                prevPath;

            this.liveBindTo('click', function() {

                if (typeof prevPath == 'undefined')
                    prevPath = this.getPath();

                var that = this;

                intervalId = setInterval(function() {
                    var path = that.getPath();
                    if (prevPath != path) {
                        clearInterval(intervalId);
                        prevPath = path;
                        that._update();
                    }
                }, 300);

            });

        }

        return false;

    }

});
;
/* ../../lego/blocks-desktop/b-form-attach/b-form-attach.js: end */ /**/

/* ../../blocks-desktop/b-tumbs/_type/b-tumbs_type_config.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-tumbs', modName: 'type', modVal: 'config'}, {

    onSetMod: {

        js: function() {
            var self = this,
                vb = require('vb');

            // Вызывавем базовый метод
            self.__base.apply(self, arguments);

            // Небольшие хаки для драг н дропа в ие
            if (vb.navigator === 'ie' && vb.navigatorMajorVersion < 10) {
                // Вместо хака с mouseover получаем все вложенные [draggable="true"] ноды и
                // у каждой ноды вызываем dragDrop по событию selectstart
                self.findBlocksInside('b-tumb').forEach(function(block) {
                    block.bindTo('selectstart', function(/* Event */ $e) {
                        $e.preventDefault();
                        $e.data.domElem[0].dragDrop();
                    });
                });

                self.bindTo('drag', function(/* Event */ $e) {
                    var self = this,
                        e = $e.originalEvent,
                        dt = e.dataTransfer;

                    if (self.__self._clone && !dt.setDragImage) {
//                                self.__self._clone.css({ left: pos.left + (e.clientX - (self.__self._clone.width() / 2)) + 'px', top: pos.top + (e.clientY - (self.__self._clone.height() / 2)) + 'px' });
                        // Т.к. в IE под курсором должно быть место для сброса,
                        // нельзя оцентровывать клон относительно курсора,
                        // потому что в этом случае он всегда считает,
                        // что под курсором клон
                        self.__self._clone.css({
                            left: (1 + e.clientX) + 'px',
                            top: (1 + e.clientY) + 'px'
                        });
                    }
                });
            }

            self.bindTo('dragstart', function(/* Event */ $e) {
                /**
                 * @type {Event}
                 */
                var self = this,
                    e = $e.originalEvent,
                    dt = e.dataTransfer,
                    $target = $($e.target),
                    $thumb;

                if ($target.hasClass('b-tumb')) {
                    $thumb = $target;
                } else if ($target.hasClass('b-tumb__click')) {
                    $thumb = $target.parent();
                }

                self.__self._dragged = $thumb.bem('b-tumb').setMod('state', 'dragged');
                self.__self._clone = $thumb.clone();

                // Убираем из склонированного блока все лишние элементы
                self.__self._clone.find(self.__self._dragged.buildSelector('fade')).remove().end()
                    .find(self.__self._dragged.buildSelector('glow')).remove().end()
                    .find(self.__self._dragged.buildSelector('control')).remove().end()
                    .find(self.__self._dragged.buildSelector('control-item')).remove();

                // Добавляем его на страницу и скрываем через позиционирование
                self.__self._clone.appendTo(self.__self.doc[0].body).css({ position: 'absolute', left: '-9999px', zIndex: 9999 });

                /**
                 * @type {DataTransfer}
                 */
                dt.dropEffect = "move";
                dt.effectAllowed = "move";

                if (dt.setDragImage) {
                    dt.setData("index", self.__self._dragged.params.index);
                    dt.setDragImage(self.__self._clone[0], ~~(self.__self._clone.width() / 2), ~~(self.__self._clone.height() / 2));
                }
            })
                .bindTo('dragend', function(/* Event */ $e) {
                    var self = this,
                        e = $e.originalEvent;

                    this.findBlocksInside({ block: 'b-tumb', modName: 'state', modVal: 'dragged' })
                        .forEach(function(block) {
                            block.delMod('state');
                        });

                    // Подчищаем созданые объекты
                    if (self.__self._clone) {
                        self.__self._clone.remove();
                    }
                })
                .bindTo('dragover', function(/* Event */ $e) {
                    $e.preventDefault();

                    var e = $e.originalEvent;
                })
                .bindTo('dragenter', function(/* Event */ $e) {
                    $e.preventDefault();

                    var self = this,
                        e = $e.originalEvent,
                        $target = $($e.target);

                    if ($target.hasClass(self.__self._dragged.buildSelector('click').substring(1))) {
                        self.setMod($target.parent().parent(), 'state', 'current');
                    }
                })
                .bindTo('dragleave', function(/* Event */ $e) {
                    var self = this,
                        e = $e.originalEvent,
                        $target = $($e.target);

                    // Увидим с пододящей тумбы — убираем с нее стиль активной
                    if ($target.hasClass(self.__self._dragged.buildSelector('click').substring(1))) {
                        self.findElem('item', 'state', 'current').each(function(index) {
                            self.delMod($(this), 'state', 'current');
                        });
                    }
                })
                .bindTo('drop', function(/* Event */ $e) {
                    $e.preventDefault();

                    var self = this,
                        e = $e.originalEvent,
                        $target = $($e.target);

                    // Если выбрали место куда перетаскиваем
                    if ($target.hasClass(self.__self._dragged.buildSelector('click').substring(1))) {
                        self.__self._dropzone = $target.parent().bem('b-tumb');

                        var settings = BEM.blocks['i-cache'].cache('settings'),
                            saveSettings = BEM.blocks['i-cache'].cache('saveSettings'),
                            thumbs = settings.thumbs,
                            newThumb = thumbs[self.__self._dragged.params.index] && $.extend({}, thumbs[self.__self._dragged.params.index], { pinned: true }) || null,
                            movedThumb = thumbs[self.__self._dropzone.params.index] && $.extend({}, thumbs[self.__self._dropzone.params.index]) || null;

                        settings.thumbs[self.__self._dropzone.params.index] = newThumb;
                        settings.thumbs[self.__self._dragged.params.index] = movedThumb;

                        saveSettings.thumbs[self.__self._dropzone.params.index] = newThumb;

                        // Если заменяем на существующу тумбу
                        if (movedThumb) {
                            saveSettings.thumbs[self.__self._dragged.params.index] = movedThumb;
                            // Если меняем на пустую тумбу — удаляем её из стека
                        } else {
                            delete saveSettings.thumbs[self.__self._dragged.params.index];
                        }

                        self._onThumbChanged(null, [self.__self._dragged.params.index, self.__self._dropzone.params.index]);

                        // Сбрасываем состояние перетаскивания
                        self.findBlocksInside({ block: 'b-tumb', modName: 'state', modVal: 'dragged' })
                            .forEach(function(block) {
                                block.delMod('state');
                            });

                        self.findElem('item', 'state', 'current').each(function(index) {
                            self.delMod($(this), 'state', 'current');
                        });

                        BEM.blocks['i-cache'].cache('settings', settings);
                        BEM.blocks['i-cache'].cache('saveSettings', saveSettings);

                        // Навешиваем обработчик на свежеперенесенные элементы
                        if (vb.navigator === 'ie') {
                            self.domElem.find('[draggable="true"]').on('selectstart', function(/* Event */ $e) {
                                $e.preventDefault();
                                this.dragDrop();
                            });
                        }
                    }

                    // Подчищаем созданые объекты
                    self.__self._clone.remove();
                    self.__self._dragged = null;
                    self.__self._dropzone = null;
                })
            ;
        }

    }

}, {

    /**
     * Перетаскиваемая тумба
     *
     * @type {Object|null}
     */
    _dragged: null,

    /**
     * Тумба на место которой бросают тумбу
     *
     * @type {Object|null}
     */
    _dropzone: null,

    /**
     * Клон перетаскиваемого блока для отображения
     *
     * @type {Object|null}
     */
    _clone: null

});

})();
;
/* ../../blocks-desktop/b-tumbs/_type/b-tumbs_type_config.js: end */ /**/

/* ../../blocks-desktop/b-foot/b-foot.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

blocks['b-foot'] = function(data) {
    var vb = require('vb'),
        BEM = require('bem').BEM,
        settings = BEM.blocks['i-cache'].cache('userSettings'),
        reg = /(.*)\[(.+)\]\((.+)\)(.*)/i,
        bCopyright = settings.copyright;

    settings.copyright.replace(reg, function(str, pretext, title, link, posttext) {
        if (!pretext) return;
        bCopyright = [
            pretext,
            {
                block: 'b-link',
                url: link,
                mods: {
                    type: 'copyright'
                },
                content: title
            },
            posttext || ''
        ];
    });
    return {
        block: 'b-foot',
        mods: { type: 'visual' },
        content: {
            elem: 'layout',
            content: [
                {
                    elem: 'layout-column',
                    elemMods: { type: 'left' },
                    content: [
                        {
                            elem: 'links',
                            content: {
                                elem: 'link',
                                attr: { type: 'agreement' },
                                url: settings.licenseURL,
                                content: vb.getLocalizedString('settings.licenseAgreement.title')
                            }
                        }
                    ]
                },
                {
                    elem: 'layout-column',
                    elemMods: { type : 'center' },
                    content: [
                        vb.getLocalizedString('app.name'),
                        ' ',
                        {
                            elem: 'version',
                            attrs: {
                                title: settings.build
                            },
                            content: settings.rev
                        },
                        ', ',
                        vb.getLocalizedString('settings.releaseDate'),
                        ' ',
                        (new Date(settings.buildDate * 1000)).format()
                    ]
                },
                {
                    elem: 'layout-column',
                    elemMods: { type: 'right' },
                    content: bCopyright
                }
            ]
        }
    };
};

Date.prototype.format = function() {
    var date = this.getDate(),
        month = this.getMonth() + 1,
        year = this.getFullYear();

    date = (date < 10) ? '0' + date : date;
    month = (month < 10) ? '0' + month : month;
    return [
        date,
        month,
        year
    ].join('.')
};;
/* ../../blocks-desktop/b-foot/b-foot.js: end */ /**/

/* ../../blocks-desktop/b-setting/b-setting.js: begin */ /**/
blocks['b-setting'] = function(data) {
    var vb = require('vb'),
        blocks = require('bem').blocks;

    return {
        block: 'b-setting',
        mods: { 'hide': 'yes' },
        js: true,
        content: [
            {
                elem: 'tail'
            },
            {
                elem: 'wrapper',
                content: [
                    {
                        elem: 'close'
                    },
                    {
                        elem: 'content',
                        content: [
                            {
                                block: 'b-form-input',
                                mods: { theme: 'grey', size: 'l', type: 'url', autocomplete: 'yes' },
                                js: {
                                    dataprovider: {
                                        name: 'i-vb-search-history-suggest-dataprovider'
                                    },
                                    popupMods: { 'size': 'l' }
                                },
                                content: [
                                    { elem: 'hint', content: vb.getLocalizedString('settings.urlInput.placeholder') },
                                    { elem: 'input' }
                                ]
                            },
                            {
                                block: 'b-form-input',
                                mods: { theme: 'grey', size: 'l', type: 'title' },
                                content: [
                                    { elem: 'hint', content: vb.getLocalizedString('settings.titleInput.placeholder') },
                                    { elem: 'input' }
                                ]
                            },
                            blocks['b-tumbs-lib'](data),
                            {
                                elem: 'control',
                                content: [
                                    {
                                        block: 'b-form-button',
                                        mods: { theme: 'grey-l', size: 'l', action: 'set-thumb-params' },
                                        type: 'submit',
                                        name: 'save-change',
                                        value: 'save',
                                        content: vb.getLocalizedString('settings.save')
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ]
    };
};

BEM.DOM.decl('b-setting', {

    _paranja: null,
    _inputUrl: null,
    _inputTitle: null,
    _buttonSave: null,

    onSetMod : {
        js: function() {
            //VB-555
            this._paranja = this.findBlockOutside('b-page').findBlockInside('b-paranja');
            this._inputUrl = this.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'url' });
            this._inputTitle = this.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'title' });
            this._buttonSave = this.findBlockInside({ block: 'b-form-button', modName: 'action', modVal: 'set-thumb-params' });

            this.bindTo('close', 'click', function(){
                this.setMod('hide', 'yes');
            });

            // Скрываем паранжу по ESC
            this.bindToDoc('keyup', function(e){
                if (e.keyCode == 27) {
                    this.setMod('hide', 'yes');
                }
            });

            // Обрабатываем отправку формы настроек, например по Enter в поле
            this.bindTo('submit', this._onSubmit);

            this._inputUrl.on('change', this._onInputUrlChange, this);
        },
        hide : {
            '' : function() {
                var self = this,
                            bFormInput = self.findBlockInside({
                                'blockName' : 'b-form-input',
                                'modName' : 'type',
                                'modVal' : 'url'
                    });

                self._onShow();
                self.afterCurrentEvent(function() {
                    var bPage = self.findBlockOutside('b-page')
                    $(bFormInput.domElem).find('input').select();
                    $('html, body').scrollTop(bPage.__self.getWindowSize().height);
                    self._paranja.delMod('hide');
                });
            },
            yes: function() {
                this.findBlockOutside('b-page').findBlockInside('b-vb-config').delMod('scroll');
                this._paranja.setMod('hide', 'yes');
            }
        }
    },

    destruct: function() {
        // Отписываемя от событий
        this._inputUrl.un('change', this._onInputUrlChange, this);

        // Уничтожаем связанные блоки
        this._paranja && this._paranja.destruct();
        this._inputUrl && this._inputUrl.destruct();
        this._inputTitle && this._inputTitle.destruct();
        this._buttonSave && this._buttonSave.destruct();

        this.__base.apply(this, arguments);
    },

    _onShow: function() {
        // VB-530
        // Дизейблим кнопку если текущее значение пустое
        var url = this._inputUrl && this._inputUrl.val(),
            bFormInput = this.findBlockInside({
                    'blockName' : 'b-form-input',
                    'modName' : 'type',
                    'modVal' : 'url'
            }),
            bPage = this.findBlockOutside('b-page');


        bPage.findBlockInside('b-vb-config').setMod('scroll', 'hide');
        this._buttonSave.setMod('disabled', !url && 'yes' || '');
        return this;
    },

    _onInputUrlChange: function(e) {
        // VB-530
        // Дизейблим кнопку если текущее значение пустое
        var url = this._inputUrl && this._inputUrl.val();
        this._buttonSave.setMod('disabled', !url && 'yes' || '');
    },

    /**
     * Обработчик отправки формы редактирования параметров тумбы
     *
     * @event
     * @param {Event} e
     * @private
     */
    _onSubmit: function(e) {
        e.preventDefault();

        this.trigger('config_set-tumb-params');
        this.setMod('hide', 'yes');
    }

});
;
/* ../../blocks-desktop/b-setting/b-setting.js: end */ /**/

/* ../../blocks-desktop/b-tumbs-lib/b-tumbs-lib.js: begin */ /**/
blocks['b-tumbs-lib'] = function(data) {
    var rows = [],
        blocks = require('bem').blocks;

    for (var i = 0; i < 2; i++) {
        var items = [];

        for (var j = 0; j < 4; j++) {
            items.push({
                elem: 'item',
                content: [
                    blocks['b-tumb-lib'](data)
                ]
            });
        }

        rows.push({
            elem: 'row',
            content: items
        });
    }

    return {
        block: 'b-tumbs-lib',
        js: true,
        content: rows
    };
};

BEM.DOM.decl('b-tumbs-lib', {

    // Количество тумб по горизонтали и вертикали в библиотеке последних посещенных сайтов
    _x: 4,
    _y: 2,

    onSetMod : {
        js: function() {
            var self = this,
                vb = require('vb'),
                Lib = require('lib'),
                $ = require('$'),
                BEM = require('bem').BEM,
                blocks = require('bem').blocks,
                BEMHTML = require('bemhtml'),
                winSize = self.__self.getWindowSize(),
                settings = BEM.blocks['i-cache'].cache('settings'),
                size = Lib.getThumbSize(this._x, this._y, winSize.width, winSize.height);

            vb.requestLastVisited(0, function(items) {
                var historyThumbs = {},
                    elems = self.findElem('item');

                elems.each(function(index, elem) {
                    if (!items[index] || !items[index].url) {
                        return;
                    }

                    historyThumbs[items[index].url] = items[index];
                    $(elem).html(BEMHTML.apply(
                        blocks['b-tumb-lib'](settings, items[index], size)
                    ));
                });

                setTimeout(function() {
                    BEM.DOM.init(self.domElem);
                }, 0);
                BEM.blocks['i-cache'].cache('historyThumbs', historyThumbs);
            });

            // Инициируем обработчики
            BEM.blocks['b-page'].on('historyThumbChanged', this._onHistoryThumbChanged, this);
        }
    },

    destruct: function() {
        var BEM = require('bem').BEM;

        // Удаляем  обработчики вместе с уничтожением объекта
        BEM.blocks['b-page'].un('historyThumbChanged', this._onHistoryThumbChanged, this);

        // Вызывавем базовый метод
        this.__base.apply(this, arguments);
    },

    _onHistoryThumbChanged: function(e, url) {
        var self = this,
            thumbsDomElem = $('[href="' + url + '"]', self.domElem);

        if (!thumbsDomElem.length) {
            return;
        }

        var blocks = require('bem').blocks,
            Lib = require('lib'),
            BEM = require('bem').BEM,
            settings = BEM.blocks['i-cache'].cache('settings'),
            historyThumbs = BEM.blocks['i-cache'].cache('historyThumbs'),
            BEMHTML = require('bemhtml'),
            winSize = self.__self.getWindowSize(),
            size = Lib.getThumbSize(self._x, self._y, winSize.width, winSize.height),
            BEMJSON = blocks['b-tumb-lib'](settings, historyThumbs[url], size);

        thumbsDomElem.each(function() {
            var bTumbLib = $(this).bem('b-tumb-lib');
            bTumbLib && BEM.DOM.update(bTumbLib.domElem.parent(), BEMHTML.apply(BEMJSON));
        });
    }

});
;
/* ../../blocks-desktop/b-tumbs-lib/b-tumbs-lib.js: end */ /**/

/* ../../blocks-desktop/b-tumb-lib/b-tumb-lib.js: begin */ /**/
blocks['b-tumb-lib'] = function(data, item, size) {
    var BEM = require('bem').BEM,
        Lib = require('lib'),
        TITLE_MAX_LENGTH = Lib.getThumbTitleMaxLength(size);

    return item && {
        block: 'b-tumb-lib',
        bg: item.backgroundColor && '#' + item.backgroundColor || '#e5e5e5',
        url: item && item.url,
        mods: {
            type: 'config',
            color: item.fontColor && 'ffffff' || '000000'
        },
        attrs: {
            title: item && item.title.trim()
        },
        js: {
            item: item
        },
        content: [
            {
                elem: 'content',
                elemMods: {
                    type: item && item.backgroundImage && 'icon' || 'text'
                },
                content: (function(data, item) {
                    if (!item) {
                        return null;
                    }

                    return item.backgroundImage && {
                        block: 'b-icon',
                        url: item.backgroundImage,
                        alt: item.title.trim()
                    } || [
                        item.favicon && {
                            elem: 'fav',
                            content: {
                                block: 'b-icon',
                                url: item.favicon,
                                alt: item.title.trim()
                            }
                        },
                        BEM.blocks['i-common__string'].cleverSubstring(item.title.trim(), TITLE_MAX_LENGTH, 0)
                    ]
                })(data, item)
            },
            {
                elem: 'glow'
            }
        ]
    };
};

BEM.DOM.decl('b-tumb-lib', {
    onSetMod : {
        js : function() {
            this.bindTo('click', this._onClick);
        }
    },

    /**
     * Обрабатываем клик по тумбе автоподбора
     *
     * @event
     * @param {Event} e
     * @private
     */
    _onClick: function(e) {
        e.preventDefault();

        this.trigger('config_set-tumb-lib', this.params.item);

        var bSetting = this.findBlockOutside('b-setting');
        bSetting && bSetting.setMod('hide', 'yes');
    }
});
;
/* ../../blocks-desktop/b-tumb-lib/b-tumb-lib.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-input/b-form-input.js: begin */ /**/
(function() {

var instances,
    sysChannel,
    update = function () {
        var instance, i = 0;
        while(instance = instances[i++]) instance.val(instance.elem('input').val());
    },
    getActiveElement = function (doc) {
        // В iframe в IE9: "Error: Unspecified error."
        try { return doc.activeElement } catch (e) {}
    };

BEM.DOM.decl('b-form-input', {

    onSetMod : {

        'js' : function() {

            var _this = this,
                input = _this.elem('input'),
                activeElement = getActiveElement(_this.__self.doc[0]),
                haveToSetAutoFocus =
                    _this.params.autoFocus &&
                    !(activeElement && $(activeElement).is('input, textarea'));

            _this._val = input.val();

            if (activeElement === input[0] || haveToSetAutoFocus) {
                _this.setMod('focused', 'yes')._focused = true;
            }

            // факт подписки
            if(!sysChannel) {
                instances = [];
                sysChannel = _this.channel('sys')
                    .on({
                        'tick' : update,
                        'idle' : function() {
                            sysChannel.un('tick', update);
                        },
                        'wakeup' : function() {
                            sysChannel.on('tick', update);
                        }});
            }

            // сохраняем индекс в массиве инстансов чтобы потом быстро из него удалять
            _this._instanceIndex = instances.push(
                _this.bindTo(input, {
                    focus : _this._onFocus,
                    blur  : _this._onBlur
                })
            ) - 1;

            // шорткат для перехода в инпут - crtl+стрелка вверх
            _this.params.shortcut && _this.bindToDoc('keydown', function(e) {
                if(e.ctrlKey && e.keyCode == 38 && !$(e.target).is('input, textarea')) {
                    _this.setMod('focused', 'yes');
                }
            });
        },

        'disabled' : function(modName, modVal) {

            this.elem('input').attr('disabled', modVal == 'yes');

        },

        'focused' : function(modName, modVal) {

            if(this.hasMod('disabled', 'yes'))
                return false;

            var focused = modVal == 'yes';

            focused?
                this._focused || this._focus() :
                this._focused && this._blur();

            this.afterCurrentEvent(function() {
                this.trigger(focused? 'focus' : 'blur');
            });

        }

    },

    onElemSetMod : {

        'message' : {

            'visibility' : function(elem, modName, modVal) {

                var _this = this,
                    type = _this.getMod(elem, 'type');

                if(type) {
                    var needSetMod = true;
                    modVal || _this.elem('message', 'type', type).each(function() {
                        this != elem[0] && _this.hasMod($(this), 'visibility', 'visible') && (needSetMod = false);
                    });
                    needSetMod && _this.toggleMod('message-' + type, 'yes', '', modVal === 'visible');
                }

            }

        }

    },

    /**
     * Возвращает/устанавливает текущее значение
     * @param {String} [val] значение
     * @param {Object} [data] дополнительные данные
     * @returns {String|BEM} если передан параметр val, то возвращается сам блок, если не передан -- текущее значение
     */
    val : function(val, data) {

        if(typeof val == 'undefined') return this._val;

        if(this._val != val) {
            var input = this.elem('input');
            input.val() != val && input.val(val);
            this._val = val;
            this.trigger('change', data);
        }

        return this;

    },

    /**
     * @see http://stackoverflow.com/questions/4185821#4186100
     * @return {Number} Позиция конца выделения. Если ничего не выделено, то возвращается 0.
     */
    getSelectionEnd : function() {
        var input = this.elem('input')[0],
            end = 0;
        if(typeof(input.selectionEnd) == 'number') {
            end = input.selectionEnd;
        } else {
            var range = document.selection.createRange();
            if(range && range.parentElement() == input) {
                var len = input.value.length,
                    textInputRange = input.createTextRange();
                textInputRange.moveToBookmark(range.getBookmark());

                var endRange = input.createTextRange();
                endRange.collapse(false);
                end = textInputRange.compareEndPoints('EndToEnd', endRange) > -1 ?
                    len :
                    -textInputRange.moveEnd('character', -len);
            }
        }
        return end;
    },

    name : function(name) {
        return this.elem('input').attr('name');
    },

    _onFocus : function() {

        this._focused = true;
        return this.setMod('focused', 'yes');

    },

    _onBlur : function() {

        this._focused = false;
        return this.delMod('focused');

    },

    /**
     * Нормализует установку фокуса для IE
     * @private
     */
    _focus : function() {

        var input = this.elem('input')[0];
        if(input.createTextRange && !input.selectionStart) {
            var range = input.createTextRange();
            range.move('character', input.value.length);
            range.select();
        } else {
            input.focus();
        }

    },

    _blur : function() {

        this.elem('input').blur();

    },

    destruct : function() {

        this.__base.apply(this, arguments);

        this.params.shortcut && this.unbindFromDoc('keydown');
        instances.splice(this._instanceIndex, 1);

        var i = this._instanceIndex,
            instance;

        while(instance = instances[i++]) --instance._instanceIndex;

    }

});

BEM.HTML.decl('b-form-input', {

    onBlock : function(ctx) {

        var id = ctx.param('id') || ctx.generateId();

        ctx
            .tag('span')
            .tParam('id', id)
            .tParam('has-clear', ctx.mod('has-clear') === 'yes')
            .tParam('type', ctx.mod('type') || 'input')
            .afterContent(
                {
                    elem : 'box',
                    tag : 'span',
                    content : {
                        elem : 'input',
                        attrs : {
                            value : ctx.param('value'),
                            name : ctx.param('name'),
                            id : id
                        }
                    }
                })
            .js(true);

    },

    onElem : {

        'input' : function(ctx) {

            ctx.tag(ctx.tParam('type'));

        },

        'label' : function(ctx) {

            ctx
                .tag('label')
                .attr('for', ctx.tParam('id'));

        },

        'box': function (ctx) {

            if (ctx.tParam('has-clear')) {
                ctx.afterContent({elem: 'clear', tag: 'span'});
            }

        },

        'hint' : function(ctx) {

            ctx
                .tag('label')
                .attr('for', ctx.tParam('id'))

        }

    }

});

})();
;
/* ../../lego/blocks-desktop/b-form-input/b-form-input.js: end */ /**/

/* ../../blocks-desktop/b-form-input/b-form-input.js: begin */ /**/
blocks['b-form-input'] = function(data, fieldName) {
    return {
        block: 'b-form-input',
        mods: { theme: 'grey', size: 'l', type: 'search', autocomplete: 'yes' },
        mix: [{ block: 'b-search', elem: 'input' }],
        js: {
            dataprovider: {
                name: 'i-vb-search-suggest-dataprovider'
            },
            popupMods: { 'size': 'l' }
        },
        name: fieldName,
        content: {
            elem: 'input',
            attrs: { name: 'text' }
        }
    };
};;
/* ../../blocks-desktop/b-form-input/b-form-input.js: end */ /**/

/* ../../lego/blocks-desktop/i-system/i-system.js: begin */ /**/
(function() {

var timer,
    counter = 0,
    isIdle = false,
    idleInterval = 0,
    channel = BEM.channel('sys'),
    TICK_INTERVAL = 50;

BEM.decl('i-system', {}, {

    start : function() {

        $(document).bind('mousemove keydown', function() {
            idleInterval = 0;
            if(isIdle) {
                isIdle = false;
                channel.trigger('wakeup');
            }
        });

        this._tick();

    },

    _tick : function() {

        var _this = this;

        channel.trigger('tick', { counter : counter++ });

        if(!isIdle && (idleInterval += TICK_INTERVAL) > 3000) {
            isIdle = true;
            channel.trigger('idle');
        }

        timer = setTimeout(function() {
            _this._tick();
        }, TICK_INTERVAL);

    }

}).start();

})();;
/* ../../lego/blocks-desktop/i-system/i-system.js: end */ /**/

/* ../../lego/blocks-common/i-request/i-request.js: begin */ /**/
(function() {

var cache = {};

BEM.decl('i-request', {

    onSetMod : {

        'js' : function() {

            this._preventCache = false;

        }

    },

    get : function(request, onSuccess, onError, params) {

        if(!$.isFunction(onError)) {
            params = onError;
            onError = this.params.onError;
        }

        this._get(request, onSuccess, onError, $.extend({}, this.params, params));

    },

    _get : function(request, onSuccess, onError, params) {

        var key = this._buildCacheKey(request, params),
            cacheGroup = cache[params.cacheGroup];

        params.cache && cacheGroup && key in cacheGroup.data?
            onSuccess.call(this.params.callbackCtx, cacheGroup.data[key]) :
            this._do(request, onSuccess, onError, params);
    },

    _do : function(request, onSuccess, onError, params) {},

    _onSuccess : function(requestKey, request, data, params) {

        params.cache && !this._preventCache && this.putToCache(params, requestKey, data);
        this._preventCache = false;

    },

    _buildCacheKey : function(obj, params) {

        return typeof obj == 'string' ? obj : $.param(obj);

    },

    putToCache : function(params, request, data) {

        var cacheGroup = cache[params.cacheGroup] || (cache[params.cacheGroup] = { keys : [], data : {}});

        if(cacheGroup.keys.length >= params.cacheSize) {
            delete cacheGroup.data[cacheGroup.keys.shift()];
        }

        var key = this._buildCacheKey(request, params);

        cacheGroup.data[key] = data;
        cacheGroup.keys.push(key);
    },

    dropCache : function() {

        delete cache[this.params.cacheGroup];

    },

    getDefaultParams : function() {

        return {
            cache : false,
            cacheGroup : 'default',
            cacheSize : 100,
            callbackCtx : this
        };

    }

});

})();;
/* ../../lego/blocks-common/i-request/i-request.js: end */ /**/

/* ../../lego/blocks-common/i-request/_type/i-request_type_ajax.js: begin */ /**/
BEM.decl({ block : 'i-request_type_ajax', baseBlock : 'i-request' }, {

    onSetMod : {

        'js' : function() {

            this.__base();
            this._requestNumber = this._number = this._preventNumber = this._retryCount = 0;

        }

    },

    _get : function(request, onSuccess, onError, params) {

        this._number++;
        this._requestNumber++;
        this._retryCount = params.retryCount;

        this.__base.apply(this, arguments);

    },

    _do : function(request, onSuccess, onError, params) {

        var _this = this;
        if(_this._number > _this._preventNumber) { // условие на случай, если кто-то синхронно позовет preventCallbacks
            var args = arguments,
                settings = {
                    data : params.data?
                        $.extend({}, params.data, request) :
                        request,
                    success : _this._wrapCallback(function(respArgs, requestNumber, number) {
                            _this._onSuccess(_this._buildCacheKey(request, params), request, respArgs[0], params);
                            _this._allowCallback(requestNumber, number) &&
                            onSuccess.apply(params.callbackCtx, respArgs);
                        }),
                    error : _this._wrapCallback(function(respArgs, requestNumber, number) {
                            _this._allowCallback(requestNumber, number) &&
                                (_this._retryCount-- > 0?
                                    setTimeout(
                                        function() {
                                            _this._do.apply(_this, args);
                                        },
                                        params.retryInterval) :
                                    onError && onError.apply(params.callbackCtx, respArgs));
                            })
                };

            $.each(['url', 'dataType', 'timeout', 'type', 'jsonp', 'jsonpCallback'].concat(params.paramsToSettings || []), function(i, name) {
                settings[name] = params[name];
            });

            $.ajax(settings);
        }

    },

    _wrapCallback : function(callback) {

        var requestNumber = this._requestNumber,
            number = this._number;

        return function(data) {
            data !== null && callback(arguments, requestNumber, number);
        };

    },

    _allowCallback : function(requestNumber, number) {

        return number > this._preventNumber && this._requestNumber == requestNumber;

    },

    _buildCacheKey : function(obj, params) {

        return typeof obj == 'string'?
            obj :
            this.__base(obj) + params.url;

    },

    abort : function() {

        this._preventNumber = ++this._number;

    },

    /**
     * @deprecated использовать abort
     */
    preventCallbacks : function() {

        this.abort();

    },

    getDefaultParams : function() {

        return $.extend(
            this.__base(),
            {
                cache         : true,
                type          : 'GET',
                dataType      : 'jsonp',
                timeout       : 20000,
                retryCount    : 0,
                retryInterval : 2000
            });

    }

});
;
/* ../../lego/blocks-common/i-request/_type/i-request_type_ajax.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-input/dataprovider/b-form-input__dataprovider.js: begin */ /**/
BEM.decl({ name : 'b-form-input__dataprovider', baseBlock : 'i-request_type_ajax' }, {

    get : function(request, callback) {

        return this.__base(
            { part : request },
            function(data) {
                callback.call(this, { items: data[1], metainfo: data[2] })
            });

    }

});
;
/* ../../lego/blocks-desktop/b-form-input/dataprovider/b-form-input__dataprovider.js: end */ /**/

/* ../../blocks-desktop/b-form-input/__dataprovider/_type/b-form-input__dataprovider_type_vb.js: begin */ /**/
/** @requires BEM */

BEM.decl({ name : 'i-vb-search-suggest-dataprovider', baseBlock : 'i-request_type_ajax' }, {

    get : function(request, callback) {
        var self = this,
            vb = require('vb');

        if (request) {
            vb.search.suggest(request, function() {
                self._onSuccess.apply(self, Array.prototype.slice.call(arguments).concat(callback));
            });
        } else {
            var input = $('.b-page').bem('b-page').findBlockInside({blockName: 'b-form-input', modName:'autocomplete', modVal: 'yes'});
            input._getPopup().hide();
        }
    },

    _onSuccess: function(data, callback) {
        callback.call(this, { items: data[1] });
    }

});

BEM.decl({ name : 'i-vb-search-history-suggest-dataprovider', baseBlock : 'i-request_type_ajax' }, {

    get : function(request, callback) {
        var self = this,
            vb = require('vb');

        if (request) {
            vb.search.historySuggest(request, function(query, data) {
                self._onSuccess.call(self, data, callback);
            });
        } else {
            var input = $('.b-page').bem('b-page').findBlockInside({blockName: 'b-form-input', modName:'autocomplete', modVal: 'yes'});
            input._getPopup().hide();
        }
    },

    _onSuccess: function(data, callback) {
        callback.call(
            this,
            {
                items: data.map(function(item) {
                    return ['history'].concat(item);
                })
            }
        );
    }

});
;
/* ../../blocks-desktop/b-form-input/__dataprovider/_type/b-form-input__dataprovider_type_vb.js: end */ /**/

/* ../../blocks-desktop/b-form-input/_type/b-form-input_type_url.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-input', modName: 'type', modVal: 'url'}, {

    onSetMod: {
        js: function() {
            this.on('select', this._onAutocompleteSelect, this);
            this.__base.apply(this, arguments);
        }
    },

    destruct: function() {
        this.un('select', this._onAutocompleteSelect, this);
        this.__base.apply(this, arguments);
    },

    _onAutocompleteSelect: function(e, data) {
        var block = e.block,
            bSetting = block.findBlockOutside('b-setting'),
            bTitle = bSetting.findBlockInside({ block: 'b-form-input', modName: 'type', modVal: 'title'});

        // Выставляем url и заголовок в соответствующие поля формы
        block.val(data.item.params.url);
        bTitle && bTitle.val(data.item.params.title);
        return true;
    }

});

})();
;
/* ../../blocks-desktop/b-form-input/_type/b-form-input_type_url.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-input/hint/b-form-input__hint.js: begin */ /**/
BEM.DOM.decl('b-form-input', {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);
            (this._hasHint = !!this.elem('hint')[0]) &&
                this
                    .on('change', this._updateHint)
                    ._updateHint();

        },

        'focused' : function() {

            this.__base.apply(this, arguments);
            this._hasHint && this._updateHint();

        }

    },

    /**
     * Показывает/скрывает хинт
     * @private
     */
    _updateHint : function() {

        this.toggleMod(this.elem('hint-wrap'), 'visibility', 'visible', !(this._focused || this.val()));

    }

});
;
/* ../../lego/blocks-desktop/b-form-input/hint/b-form-input__hint.js: end */ /**/

/* ../../blocks-desktop/b-paranja/b-paranja.js: begin */ /**/
blocks['b-paranja'] = function(data) {
    return {
        block: 'b-paranja',
        js: true,
        mods: { hide: 'yes' }
    };
};

BEM.DOM.decl('b-paranja', {

    onSetMod : {
        'js': function() {
            var setting = this.findBlockOutside('b-page').findBlockInside('b-setting');

            this.bindTo('click', function(){
                setting.setMod('hide', 'yes')
            })
        }
    }

});

;
/* ../../blocks-desktop/b-paranja/b-paranja.js: end */ /**/

/* ../../blocks-desktop/b-decor/b-decor.js: begin */ /**/
blocks['b-decor'] = function(data) {
    return {
        block: 'b-decor',
        mods: { theme: 'white' }
    };
};;
/* ../../blocks-desktop/b-decor/b-decor.js: end */ /**/

/* ../../blocks-desktop/b-bookmarks/b-bookmarks.js: begin */ /**/
blocks['b-bookmarks'] = function(data, width, height) {
    if (data.showBookmarks) {
        return [
            {
                block: 'b-bookmarks',
                js: {
                    width: width,
                    height: height
                }
            },
            {
                block: 'b-popupa',
                mods: { theme: 'ffffff', type: 'bookmarks' },
                content: [
                    { elem: 'tail' },
                    {
                        elem: 'content',
                        content: {
                            block: 'b-spin',
                            mods: {
                                progress: 'yes'
                            }
                        }
                    }
                ]
            }
        ]
    }
};

BEM.DOM.decl('b-bookmarks', {
    TITLE_MAX_LENGTH: 19,
    BOOKMARK_WIDTH: 150,
    BOOKMARKS_MARGIN: 50,
    OTHERS_RESERVERD_WIDTH: 150,
    _popupa: null,
    _menu: null,
    onSetMod: {
        js: function() {
            var BEM = require('bem').BEM,
                settings = BEM.blocks['i-cache'].cache('settings');

            if (!settings.showBookmarks) {
                return;
            }

            this._popupa = this.findBlockOutside('b-page').findBlockInside({
                blockName: 'b-popupa',
                modName: 'type',
                modVal: 'bookmarks'
            });

            // Инициируем обработчики
            BEM.blocks['b-link'].on('open-folder', this._openFolder, this);
            BEM.blocks['b-page'].on('bookmarksStateChanged', this._onBbookmarksStateChanged, this);

            // Проверяем есть ли уже загруженные закладки, если да выставляем состояние „loaded“
            try {
                var bookmarks = BEM.blocks['i-cache'].cache('bookmarks');
                if (bookmarks) {
                    this.setMod('state', 'loaded');
                }
            } catch (err) {}
        },

        state: {
            loaded: function() {
                var self = this,
                    BEM = require('bem').BEM,
                    BEMHTML = require('bemhtml'),
                    items = [],
                    bookmarks = BEM.blocks['i-cache'].cache('bookmarks');

                for (var i = 0, len = bookmarks.length; i < len; i++) {
                    var item = bookmarks[i];
                    items.push(item.isFolder ? self._folderItem(item) : self._linkItem(item));
                }

                // Добавляем последний пункт списка под «Другие закладки»
                items.push(self._lastOthersItem());
                BEM.DOM.update(self.domElem, BEMHTML.apply({
                    block: 'b-menu-horiz',
                    mods: { layout: 'normal', type: 'bookmarks' },
                    js: false,
                    content: items
                }), function() {
                    self.afterCurrentEvent(function() {
                        // По завершению вставки в DOM сменяем состояние на inserted
                        self.setMod('state', 'inserted');
                    });
                });
            },

            inserted: function() {
                var self = this,
                    $ = require('$'),
                    BEM = require('bem').BEM,
                    BEMHTML = require('bemhtml'),
                    bookmarks = BEM.blocks['i-cache'].cache('bookmarks');

                self._menu = self.findBlockInside({
                    block: 'b-menu-horiz',
                    modName: 'type',
                    modVal: 'bookmarks'
                });

                // Проверяем хватает ли на экране места для всех закладок,
                // если нет убираем невлезающие под кат
                var maxWidth = self.params.width - self.OTHERS_RESERVERD_WIDTH - self.BOOKMARKS_MARGIN,
                    isNotEnough = (self.domElem.outerWidth() > self.params.width),
                    menuItems = self._menu && self._menu.findElem('item'),
                    items = [],
                    item,
                    i = bookmarks.length - 1;

                // Если недостаточно места под все закладки перемищаем часть в «Другие закладки»
                while (isNotEnough) {
                    // Удаляем все элементы меню которые не входят на странице
                    // и создаем их копии в «Других закладках»
                    $(menuItems[i]).parent().remove();

                    item = bookmarks[i];
                    items.push(item.isFolder ? self._vertFolderItem(item) : self._vertLinkItem(item));

                    isNotEnough = (self.domElem.outerWidth() > maxWidth && i > 0);
                    i--;
                }

                if (items.length) {
                    // Внтри горизонтильного меню находим попупу для других закладок
                    self._menu.findBlockInside({
                        block: 'b-popupa',
                        modName: 'type',
                        modVal: 'others-bookmarks'
                    }).setContent(BEMHTML.apply({
                        block: 'b-menu-vert',
                        mods: { type: 'bookmarks' },
                        js: true,
                        content: items.reverse()
                    }));
                    //прячем другие закладки если окно маленькое
                    if (self.params.width >= self.OTHERS_RESERVERD_WIDTH) {
                        self._menu.findElem('item', 'type', 'others').show();
                    }
                }

                self.afterCurrentEvent(function() {
                    // После пересчета геометрии и фильтрации необходимых пунктов
                    // выставляем статус готовности
                    self.setMod('state', 'ready');
                });
            }
        }
    },

    destruct: function() {
        var BEM = require('bem').BEM;

        // Удаляем  обработчики вместе с уничтожением объекта
        BEM.blocks['b-link'].un('open-folder', this._openFolder, this);
        BEM.blocks['b-page'].un('bookmarksStateChanged', this._onBbookmarksStateChanged, this);

        var popup = this._popupa;
        popup && popup.destruct();

        // Вызывавем базовый метод
        this.__base.apply(this, arguments);
    },

    _onBbookmarksStateChanged: function() {
        // Выставляем статус того, что новые закладки успешно загружены
        this.setMod('state', 'loaded');
    },

    _linkItem: function(item) {
        var BEM = require('bem').BEM;

        return {
            elem: 'item',
            content: {
                block: 'b-link',
                url: item.url,
                content: BEM.blocks['i-common__string'].cleverSubstring(item.title.trim(), this.TITLE_MAX_LENGTH, 0),
                attrs: {
                    id: 'bookmark-' + item.id,
                    title: item.title.trim()
                }
            }
        };
    },

    _folderItem: function(item) {
        var BEM = require('bem').BEM;

        return {
            elem: 'item',
            content: [
                {
                    block: 'b-link',
                    mods: {
                        pseudo: 'yes',
                        border: 'none',
                        type: 'folder',
                        action: 'open-folder'
                    },
                    js: {
                        id: item.id
                    },
                    mix: [
                        {
                            block: 'b-bookmarks',
                            elem: 'folder',
                            js: {
                                id: item.id
                            }
                        }
                    ],
                    url: item.url,
                    content: BEM.blocks['i-common__string'].cleverSubstring(item.title.trim(), this.TITLE_MAX_LENGTH, 0) + ' &#x25BC;', // ▼ BLACK DOWN-POINTING TRIANGLE Unicode: U+25BC, UTF-8: E2 96 BC
                    attrs: {
                        id: 'bookmark-' + item.id,
                        title: item.title.trim()
                    }
                }
            ]
        };

    },

    _lastOthersItem: function() {
        var vb = require('vb');
        return {
            elem: 'item',
            elemMods: {
                type: 'others'
            },
            content: [
                {
                    block: 'b-dropdowna',
                    content: [
                        {
                            elem: 'switcher',
                            content: [
                                {
                                    block: 'b-link',
                                    mods: {
                                        pseudo: 'yes',
                                        border: 'none',
                                        type: 'folder',
                                        action: 'open-others'
                                    },
                                    content: vb.getLocalizedString('bookmarks.otherBookmarks') + ' &#x25BC;' // ▼ BLACK DOWN-POINTING TRIANGLE Unicode: U+25BC, UTF-8: E2 96 BC
                                }
                            ]
                        },
                        {
                            block: 'b-popupa',
                            mods: {
                                theme: 'ffffff',
                                type: 'others-bookmarks',
                                direction: 'left'
                            },
                            content: [
                                { elem: 'tail' },
                                { elem: 'content' }
                            ]
                        }
                    ]
                }
            ]
        };
    },

    _vertFolderItem: function(item) {
        var BEM = require('bem').BEM;

        return {
            elem: 'item',
            content: [
                {
                    block: 'b-link',
                    mods: {
                        pseudo: 'yes',
                        inner: 'yes',
                        border: 'none',
                        action: 'open-folder',
                        type: 'open-sub-folder'
                    },
                    mix: [
                        { block: 'b-menu-vert', elem: 'item-selector'}
                    ],
                    js: {
                        id: item.id
                    },
                    url: item.url,
                    content: [
                        {
                            block: 'b-icon',
                            mods: {
                                type: 'folder'
                            },
                            mix: [
                                {
                                    block: 'b-link',
                                    elem: 'icon'
                                }
                            ]
                        },
                        {
                            elem: 'inner',
                            content: BEM.blocks['i-common__string'].cleverSubstring(item.title.trim(), this.TITLE_MAX_LENGTH, 0),
                            attrs: {
                                title: item.title.trim()
                            }
                        }
                    ],
                    attrs: {
                        id: 'bookmark-' + item.id
                    }
                }
            ]
        };
    },

    _vertLinkItem: function(item) {
        var BEM = require('bem').BEM;

        return {
            elem: 'item',
            content: {
                block: 'b-link',
                mods: { inner: 'yes' },
                url: item.url,
                content: [
                    item.favicon && {
                        block: 'b-icon',
                        mix: [
                            { block: 'b-link', elem: 'icon'}
                        ],
                        url: item.favicon,
                        width: 16,
                        height: 16,
                        alt: item.title.trim()
                    },
                    {
                        elem: 'inner',
                        content: BEM.blocks['i-common__string'].cleverSubstring(item.title.trim(), this.TITLE_MAX_LENGTH, 0),
                        attrs: {
                            title: item.title.trim()
                        }
                    }
                ],
                attrs: {
                    id: 'bookmark-' + item.id
                }
            }
        };
    },

    _openFolder: function(e) {
        var self = this,
            link = e.target,
            vb = require('vb'),
            BEMHTML = require('bemhtml');

        // Тоглим попапу, только если кликаем по закладкам верхнего уровня
        if (!link.hasMod('type', 'open-sub-folder')) {
            // Если кликаем по той же ссылке закрываем попапу
            if (link.domElem === self._popupa._owner) {
                self._popupa.toggle(link.domElem[0]);
            } else {
                // Вставляем прелоадер на время загрузки данных
                self._popupa.setContent(BEMHTML.apply({
                    block: 'b-spin',
                    mods: {
                        progress: 'yes'
                    }
                }));
                self._popupa.show(link.domElem);
            }
        }

        vb.requestBookmarksBranch(link.params.id, function(bookmarks) {
            var items = [],
                len = bookmarks.length;

            // Есть вложенные объекты
            if (len) {
                for (var i = 0; i < len; i++) {
                    var item = bookmarks[i];
                    items.push(item.isFolder ? self._vertFolderItem(item) : self._vertLinkItem(item));
                }

            // Папка пуста
            } else {
                items.push({
                    elem: 'item',
                    content: {
                        block: 'b-link',
                        mods: { inner: 'yes', pseudo: 'yes', disabled: 'yes'  },
                        content: vb.getLocalizedString('app.empty')
                    }
                })
            }

            if (link.hasMod('type', 'open-sub-folder')) {
                link.toggleMod('opened', 'yes');

                if (link.hasMod('opened', 'yes')) {
                    var submenu = BEMHTML.apply({
                        block: 'b-menu-vert',
                        elem: 'item-content',
                        elemMods: { 'visibility' : 'visible' },
                        content: {
                            elem: 'submenu',
                            content: items
                        }
                    });

                    link.domElem.after(submenu);
                    link.setMod('loaded', 'yes');
                } else {
                    var menu = link.findBlockOutside('b-menu-vert');
                    menu.toggleMod(menu.findElem(link.domElem.parent(), 'item-content'), 'visibility', 'visible');
                }
            } else {
                var menu = BEMHTML.apply({
                    block: 'b-menu-vert',
                    mods: { type: 'bookmarks' },
                    js: true,
                    content: items
                });

                self._popupa.setContent(menu);
            }
        });
    }
});
;
/* ../../blocks-desktop/b-bookmarks/b-bookmarks.js: end */ /**/

/* ../../lego/blocks-desktop/b-spin/b-spin.js: begin */ /**/
BEM.DOM.decl('b-spin', {

    onSetMod : {

        'js' : function() {

            this._size = this.getMod('size') || /[\d]+/.exec(this.getMod('theme'))[0];

            this._bgProp = 'background-position';
            this._posPrefix = '0 -';

            if (this.elem('icon').css('background-position-y')) { /* В IE нельзя получить свойство background-position, только background-position-y, поэтому костыляем */
                this._bgProp = 'background-position-y';
                this._posPrefix = '-';
            }

            this._curFrame = 0;

            this.hasMod('progress') && this.channel('sys').on('tick', this._onTick, this);

        },

        'progress' : {

            'yes' : function() {

                this.channel('sys').on('tick', this._onTick, this);

            },

            '' : function() {

                this.channel('sys').un('tick', this._onTick, this);

            }

        }
    },

    _onTick: function(){

        var y = ++this._curFrame * this._size;

        (y >= this._size * 36) && (this._curFrame = y = 0);

        this.elem('icon').css(this._bgProp, this._posPrefix + y +'px');

    },

    destruct : function() {

        this.channel('sys').un('tick', this._onTick, this);
        this.__base.apply(this, arguments);

    }

});
;
/* ../../lego/blocks-desktop/b-spin/b-spin.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_open-folder.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'open-folder' }, {

    onSetMod: {
        js: function() {
            var self = this;
            self.on('click', function(e) {
                this.trigger('open-folder', e);
            });
        }
    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_open-folder.js: end */ /**/

/* ../../lego/blocks-desktop/b-dropdowna/b-dropdowna.js: begin */ /**/
(function($) {
BEM.DOM.decl('b-dropdowna', {

    onSetMod : {

        'js' : function() {

            this._getSwitcher().on('click', this._toggle, this);

        },

        'disabled' : function(modName, modVal) {

            this._getSwitcher().setMod(modName, modVal);
            modVal == 'yes' && this.getPopup().hide();

        }

    },

    /**
     * Возвращает блок свитчера
     * @private
     */
    _getSwitcher : function() {

        return this._switcher ||
            (this._switcher =
                this.findBlockInside('b-' + (this.getMod(this.elem('switcher'), 'type') || 'link' )));

    },

    _toggle : function() {

        this.getPopup().toggle(this.elem('switcher'));

    },

    getPopup : function() {

        return this._popup || (this._popup = this.findBlockInside('b-popupa'))
            .on('outside-click', function(e, data) {
                this._getSwitcher().containsDomElem($(data.domEvent.target)) && e.preventDefault();
            }, this);

    },

    destruct : function() {

        var popup = this._popup;
        popup && popup.destruct();

        this.__base.apply(this, arguments);

    }

}, {

    live : function() {

        this.liveInitOnEvent('switcher', 'leftclick', function() {});

    }

});
})(jQuery);

BEM.HTML.decl('b-dropdowna', {

    onBlock: function (ctx) {
        ctx.js(true);
    }

});
;
/* ../../lego/blocks-desktop/b-dropdowna/b-dropdowna.js: end */ /**/

/* ../../lego/blocks-desktop/b-dropdowna/switcher/b-dropdowna__switcher.js: begin */ /**/
BEM.HTML.decl('b-dropdowna', {

    onElem: {

        'switcher': function (ctx) {
            ctx.tag('span');
        }

    }

});
;
/* ../../lego/blocks-desktop/b-dropdowna/switcher/b-dropdowna__switcher.js: end */ /**/

/* ../../lego/bem-bl/blocks-desktop/i-menu/i-menu.js: begin */ /**/
/** @requires BEM */
/** @requires BEM */

(function() {

BEM.DOM.decl('i-menu', {

    onElemSetMod : {

        'item' : {

            'state': {

                'current' : function(elem, modName, modVal, oldModVal) {

                    if (oldModVal == 'disabled') return false;

                    var prev = this.elem('item', 'state', 'current');
                    this
                        .delMod(prev, 'state')
                        .trigger('current', {
                            prev    : prev,
                            current : elem
                        });
                }
            }
        }
    },
    onItemSelectorClick : function(e) {

        var item = this._getItemByEvent(e);
        this.setMod(item, 'state', 'current');

    },

    _getItemByEvent : function(e) {
        return e.data.domElem.closest(this.buildSelector('item'));
    }

}, {

    live : function() {
        this.liveBindTo('item-selector', 'leftclick', function(e) {
            this.onItemSelectorClick(e);
        });
    }

});

})();
;
/* ../../lego/bem-bl/blocks-desktop/i-menu/i-menu.js: end */ /**/

/* ../../lego/bem-bl/blocks-desktop/b-menu-horiz/b-menu-horiz.js: begin */ /**/
/** @requires BEM.DOM */

(function() {

BEM.DOM.decl({ name: 'b-menu-horiz', baseBlock: 'i-menu' });

})();
;
/* ../../lego/bem-bl/blocks-desktop/b-menu-horiz/b-menu-horiz.js: end */ /**/

/* ../../lego/bem-bl/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: begin */ /**/
BEM.DOM.decl({'name': 'b-link', 'modName': 'pseudo', 'modVal': 'yes'}, {

    _onClick : function(e) {

        e.preventDefault();

        this.hasMod('disabled', 'yes') || this.afterCurrentEvent(function() {
            this.trigger('click');
        });

    }

}, {

    live : function() {

        this.__base.apply(this, arguments);

        this.liveBindTo({ modName : 'pseudo', modVal : 'yes' }, 'leftclick', function(e) {
            this._onClick(e);
        });

    }

});
;
/* ../../lego/bem-bl/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: end */ /**/

/* ../../lego/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.HTML */

BEM.HTML.decl({name: 'b-link', modName: 'pseudo', modVal: 'yes'}, {
    onBlock: function(ctx) {
        ctx.tag(ctx.param('url') ? 'a': 'span');

        ctx.wrapContent({ elem : 'inner' });

        ctx.js(true);
    },

    onElem : {
        'inner': function(ctx) {
            ctx.tag('span');
        }
     }
});

;
/* ../../lego/blocks-desktop/b-link/_pseudo/b-link_pseudo_yes.js: end */ /**/

/* ../../blocks-desktop/b-link/_open/b-link_open_apps.js: begin */ /**/
BEM.DOM.decl({ name : 'b-link', modName : 'open', modVal : 'apps' }, {

    onSetMod : {

        js : function() {
            var _self = this,
                block_all = this.findBlockOutside('b-vb-foot').findBlocksInside('b-vb-droptop');

            this.bindTo('click', function() {
                this.toggleMod('state', 'current');
                block_all.forEach(function(e){
                    if(e.hasMod('type', 'apps')){ e.toggleMod('hide', 'yes'); } else { e.setMod('hide', 'yes') }
                });
            });
        }
    }
});
;
/* ../../blocks-desktop/b-link/_open/b-link_open_apps.js: end */ /**/

/* ../../blocks-desktop/b-link/_open/b-link_open_bookmark.js: begin */ /**/
BEM.DOM.decl({ block: 'b-link', modName: 'open', modVal: 'bookmark' }, {
    _popupa: null,
    onSetMod : {
        js : function() {
            var self = this,
                vb = require('vb'),
//                BEM = require('bem').BEM,
                BEMHTML = require('bemhtml');

            self._popupa = self._popupa || self.findBlockOutside('b-dropdowna')
                                               .findBlockInside('b-popupa');

            self.on('click', function(e) {
                vb.requestClosedPagesList(function(pages) {
                    var items = [],
                        len = pages.length;

                    if (len) {
                        for (var i = 0; i < len; i++) {
                            var item = pages[i];

                            items.push({
                                elem: 'item',
                                content: {
                                    block: 'b-link',
                                    mods: { inner: 'yes' },
                                    url: item.url,
                                    content: [
                                        item.favicon && {
                                            block: 'b-icon',
                                            mix: [ { block: 'b-link', elem: 'icon'} ],
                                            url: item.favicon,
                                            width: 16,
                                            height: 16,
                                            alt: item.title.trim()
                                        },
                                        {
                                            elem: 'inner',
                                            content: item.title.trim()
                                        }
                                    ]
                                }
                            });
                        }
                    } else {
                        items.push({
                            elem: 'item',
                            content: {
                                block: 'b-link',
                                mods: { inner: 'yes', pseudo: 'yes', disabled: 'yes'  },
                                content: vb.getLocalizedString('app.empty')
                            }
                        });
                    }

                    self._popupa.setContent(BEMHTML.apply({
                        block: 'b-menu-vert',
                        mods: {
                            type: 'close-bookmark'
                        },
                        js: true,
                        content: items
                    }), function() {
                        self.toggleMod('state', 'current');
                    });
                });
            });
        }
    }
});
;
/* ../../blocks-desktop/b-link/_open/b-link_open_bookmark.js: end */ /**/

/* ../../lego/bem-bl/blocks-desktop/b-menu-vert/b-menu-vert.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function() {

BEM.DOM.decl({ name: 'b-menu-vert', baseBlock: 'i-menu' }, {}, {

    live : function() {
        this.__base();
    }

});

})();
;
/* ../../lego/bem-bl/blocks-desktop/b-menu-vert/b-menu-vert.js: end */ /**/

/* ../../blocks-desktop/b-vb/b-vb.js: begin */ /**/
blocks['b-vb'] = function(data, width, height) {
    var Lib = require('lib'),
        modSize = Lib.getContentSizeMod(width, height),
        blocks = require('bem').blocks;

    return {
        block: "b-vb",
        content: [
            {
                elem: 'head',
                content: [
                    blocks['b-vb-head'](data)
                ]
            },
            {
                elem: 'content',
                elemMods: { width: modSize },
                content: [
                    blocks['b-tumbs'](data, width, height, 'index')
                ]
            }
        ]
    };
};;
/* ../../blocks-desktop/b-vb/b-vb.js: end */ /**/

/* ../../blocks-desktop/b-vb-head/b-vb-head.js: begin */ /**/
blocks['b-vb-head'] = function(data) {
    var vb = require('vb'),
        blocks = require('bem').blocks,
        showSearchForm = (data.searchStatus === 2), // Показывается поисковая форма
        search = [{
                elem: 'logo',
                content: [
                    blocks['b-head-logo'](data)
                ]
            },
            {
                elem: 'search',
                content: [
                    blocks['b-head-search'](data)
                ]
            }];
        ;
    return {
        block: 'b-vb-head',
        mix: [ { block: 'i-clearfix'} ],
        content: showSearchForm ? search : blocks['b-question']()
    };
};;
/* ../../blocks-desktop/b-vb-head/b-vb-head.js: end */ /**/

/* ../../blocks-desktop/b-question/b-question.js: begin */ /**/
blocks['b-question'] = function () {
    return {
        block: 'b-question',
        content: [
            {
                //TODO не знаю как правильно переопределить тег img у b-icon
                block: 'myblock',
                mix: [{
                    block: 'b-icon',
                    mods: { quest: 'top' }
                }]
            },
            {
                elem: 'quest-text',
                content: [
                    vb.getLocalizedString('app.searchTutorial.description') + ' ' + vb.getLocalizedString('app.searchExampleTitle') + ', ',
                    {
                        block: 'b-link',
                        mods: {pseudo:'yes', omni: 'yes'},
                        js: true,
                        url: '#',
                        content: vb.getLocalizedString('app.searchTutorial.example')
                    }
                ]
            },
            {
                elem: 'quest-close',
                content: {
                    block: 'b-link',
                    mods: {pseudo:'yes', action: 'close-search-tutorial'},
                    js: true,
                    url: '#',
                    content: vb.getLocalizedString('app.searchTutorial.thanks')
                }
            }
        ]
    }
};
/* ../../blocks-desktop/b-question/b-question.js: end */ /**/

/* ../../blocks-desktop/b-head-logo/b-head-logo.js: begin */ /**/
/** @requires BEM.DOM */

blocks['b-head-logo'] = function(data) {
    return {
        block: 'b-head-logo',
        content: [
            {
                elem: 'logo',
                content: {
                    elem: 'link',
                    content: {
                        elem: 'img',
                        url: data.branding.logo.img
                    },
                    attrs: {
                        title: data.branding.logo.title
                    },
                    url: data.branding.logo.url
                }
            }
//            // FIXME: Забыли в API слоган
//            {
//                elem: 'text',
//                content: data.branding.logo.alt
//            }
        ]
    };
};;
/* ../../blocks-desktop/b-head-logo/b-head-logo.js: end */ /**/

/* ../../lego/blocks-desktop/i-statface/i-statface.js: begin */ /**/
BEM.decl('i-statface', {

    onSetMod : {

        'js' : function() {

            this._data = {};
            this._needSend = false;
            this.hasMod('send', 'manual') || $(window).unload(this.changeThis(this.send));

        }

    },

    /**
     * @param {Object|string} name
     * @param {string} [val]
     */
    set : function(name, val) {

        this._needSend = true;
        var data = this._data;
        if(typeof name == 'object') {
            $.each(name, function(key, value) {
                data[key] = value;
            })
        } else {
            data[name] = val;
        }

        return this;
    },

    reset : function() {

        var _this = this;
        arguments[0]?
            $.each(arguments, function(i, key) {
                delete _this._data[key];
            }) :
            this._data = {};
        $.isEmptyObject(this._data) && (this._needSend = false);
        return this;

    },

    serialize : function() {

        var _this = this;

        return $.map(_this.params.keys, function(val) {
            return _this._data[val];
        }).join('.') + (_this.params.customKeys?
            $.map(_this.params.customKeys, function(key) {
                var val = _this._data[key];
                return '/' + key + '=' + (val == undefined ? '' : val)
            }).join('') :
            '');

    },

    /**
     * @param {Function} [onComplete]
     */
    send : function(onComplete) {

        if(this._needSend) {
            var params = this.params,
                url = ['//', params.host, '/jclck/dtype=stred/pid=', params.pid,
                '/cid=', params.cid, '/path=', this.serialize(), '/*data=' + encodeURIComponent('url=' + encodeURIComponent(location.href))].join('');

            $.ajax({
                type: 'GET',
                url: url,
                data: null,
                complete: onComplete || $.noop,
                dataType: 'script',
                timeout: 500
            });
            this._needSend = false;
        }
        return this;

    },

    getDefaultParams : function() {

        return {
            host : 'clck.yandex.ru'
        };

    }

});
;
/* ../../lego/blocks-desktop/i-statface/i-statface.js: end */ /**/

/* ../../blocks-desktop/b-head-search/b-head-search.js: begin */ /**/
/** @requires BEM.DOM */

blocks['b-head-search'] = function(data) {
    var vb = require('vb'),
        url = data.branding.search.url,
        matches = url.match(/([\w_-]+)\=\{searchTerms\}/),
        defaultAction = url.replace(matches[0], '');

    return {
        block: 'b-head-search',
        content: {
            block: 'b-search',
            attrs: { action: defaultAction },
            js: {
                url: url
            },
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'col',
                            mix: [{ elem: 'input' }],
                            content: [
                                blocks['b-form-input'](data, matches[1])
                            ]
                        },
                        {
                            elem: 'col',
                            mix: [{ elem: 'button' }],
                            content: [
                                {
                                    block: 'b-form-button',
                                    mods: { size: 'l', theme: 'grey-no-transparent-l' },
                                    mix: [{ block: 'b-search', elem: 'button' }],
                                    type: 'submit',
                                    content: vb.getLocalizedString('app.searchButtonTitle')
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'col',
                            mix: [{ elem: 'under' }],
                            attrs: { colspan: 2 },
                            content: [
//                                (function(data) {
//                                    var example = vb.search.useExample();
//
//                                    return {
//                                        elem: 'sample',
//                                        content: [
//                                            {
//                                                elem: 'intro',
//                                                content: [
//                                                    {
//                                                        block: 'i-bem',
//                                                        elem: 'i18n',
//                                                        keyset: 'b-search',
//                                                        key: 'for-example',
//                                                        text: vb.getLocalizedString('app.searchExampleTitle') // vb.getLocalizedString('app.searchExampleTitle')
//                                                    },
//                                                    ', '
//                                                ]
//                                            },
//                                            {
//                                                block: 'b-link', mods: { pseudo: 'yes' },
//                                                content: 'гольф с пробегом'
//                                            }
//                                        ]
//                                    };
//                                }())
                            ]
                        }
                    ]
                }
            ]
        }
    };
};
;
/* ../../blocks-desktop/b-head-search/b-head-search.js: end */ /**/

/* ../../blocks-desktop/b-form-input/_type/b-form-input_type_search.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-input', modName: 'type', modVal: 'search'}, {

    onSetMod: {
        js: function() {
            this.on('select', this._onAutocompleteSelect, this);
            this.__base.apply(this, arguments);
        }
    },

    destruct: function() {
        this.un('select', this._onAutocompleteSelect, this);
        this.__base.apply(this, arguments);
    },

    _onAutocompleteSelect: function(e) {
        var block = e.block,
            bSearch = block.findBlockOutside('b-search'),
            query = bSearch.params.url.replace('{searchTerms}', block.val());

        bSearch.domElem
            .attr('action', query)
            .submit();

        return true;
    }


});

})();
;
/* ../../blocks-desktop/b-form-input/_type/b-form-input_type_search.js: end */ /**/

/* ../../blocks-desktop/b-search/b-search.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl('b-search', {

    onSetMod : {

        'js' : function() {
            this.bindTo('submit', this._onSubmit, this);
        }

    },

    _onSubmit: function(e) {
        var query = this.findBlockInside('b-form-input').val();
        this.__self.doc[0].location.href = this.params.url.replace('{searchTerms}', encodeURIComponent(query));
        return false;
    }

});

})();
;
/* ../../blocks-desktop/b-search/b-search.js: end */ /**/

/* ../../lego/blocks-desktop/b-search/input/b-search__input.js: begin */ /**/
BEM.DOM.decl('b-search__input', {

    onSetMod : {

        js : function() {

            Lego.block['b-search__input'].call(this.domElem, this.params);

        }

    }

});


(function($, Lego){

Lego.block['b-search__input'] = function(params){

    var _this = this;
    var _params = $.extend({focus: false, shortcut: false}, params);

    if(_params.focus || _this.data('lego:focused')) {
        if(!_this.data('lego:focused')) {
            var activeNode = document.activeElement;
            (activeNode && 'input textarea'.indexOf(activeNode.tagName.toLowerCase()) > -1) ||
                setTimeout(function() {
                    _this.focus();
                    if(_this[0].createTextRange) { // ставим каретку в конец для opera и ie
                        var range = _this[0].createTextRange(),
                        len = _this.val().length;

                        range.collapse();
                        range.moveStart('character', len);
                        range.moveEnd('character', len);
                        range.select();
                    }
                    _this.data('lego:focused', true);
                }, 0);
        }
        if(!!window.history.length && !$.trim(_this.val())) { // только если есть хистори и пустое поле
            _this.bind('keydown', function(e) {
                if(e.keyCode == 8) { // если первое нажатие Backspace
                    if (!$.trim(_this.val())) return window.history.back();
                }
                _this.unbind('keydown', arguments.callee);
            });
        }
        _this.blur(function() {
            _this.data('lego:focused', false);
        }).focus(function() { //b-suggest делает blur-focus для установки autocomplete=off, это может сломать инициализацию клавиатуры
            _this.data('lego:focused', true);
        });
    }

    if(_params.shortcut) {
        $(document).keydown(function(e) {
            if(!e.ctrlKey || $(e.target).is('input, textarea')) {
                return;
            }

            if(e.keyCode == 38) {
                _this.focus().select();
            }
        });
    }

};

})(jQuery, window.Lego);
;
/* ../../lego/blocks-desktop/b-search/input/b-search__input.js: end */ /**/

/* ../../lego/blocks-desktop/b-search/sample/b-search__sample.js: begin */ /**/
BEM.DOM.decl('b-search__sample', {

    onSetMod : {

        js : function() {

            Lego.block['b-search__sample'].call(this.domElem, this.params);

        }

    }

});


(function($, Lego){

/*
 * @param params.for имя поля для подстановки примера, если не указан "text"
 * @param params.nl cоздавать ли параметр nl=1 (используется для статистики)
 */
Lego.block['b-search__sample'] = function(params){
    var $this = this,
        form = $this.closest('form'),
        input = form.find("input[name='"+ (params['for'] || 'text') +"']"),
        nl;

    $this.find('.b-link_pseudo_yes').click(function(e){
        input
            .focus()
            .attr('value', params['text'] || $(e.target).text());
        nl = form.find("input[name='nl']");
        if (params.nl && !nl.length) nl = $('<input type="hidden" name="nl" value="1"/>').insertAfter(input);
        $(document).trigger('popupsClose.lego');
        e.preventDefault();
    });
};

})(jQuery, window.Lego);
;
/* ../../lego/blocks-desktop/b-search/sample/b-search__sample.js: end */ /**/

/* ../../lego/blocks-desktop/b-form-input/_autocomplete/b-form-input_autocomplete_yes.js: begin */ /**/
(function($) {

var HTML = BEM.HTML,
    DOM = BEM.DOM,

    /** {HTMLElement} */
    activeNode;

// LEGO-3098
$(function() {
    $(window).bind('focus', function() {
        activeNode = document.activeElement;
    });
});

DOM.decl({ name : 'b-form-input', modName : 'autocomplete', modVal : 'yes' }, {

    onSetMod : {

        'js' : function() {

            var _this = this;

            _this.params.foot && (_this.foot = _this.params.foot); // упячка!

            _this._preventRequest = true;
            _this._preventPopupShow = false;
            _this._isPopupShown = false;

            _this.__base.apply(_this, arguments);

            // последнее значение, введенное пользователем с клавиатуры
            _this._userVal = _this.val();

            // выключаем браузерный автокомплит
            var focused = _this._focused;
            focused && _this.delMod('focused');
            _this.elem('input').attr('autocomplete', 'off');
            _this._preventRequest = false;
            focused && _this.setMod('focused', 'yes');

            _this._items = [];
            _this._curItemIndex = -1;

            _this._doRequest = $.debounce(_this._doRequest, _this.params.debounceDelay);

        },

        'focused' : {

            'yes' : function() {

                this.__base();
                // Не открывать автокомплит по фокусу при наличии параметра `showListOnFocus`
                var onChangeFn = this.params.showListOnFocus ?
                    this._onChange() : this._onChange;
                this.on('change', onChangeFn);

            },

            '' : function() {

                this.__base();
                this
                    .un('change', this._onChange)
                    ._preventHide || this._getPopup().hide();

            }

        }

    },

    onElemSetMod : {

        'popup' : {

            'fixed' : {

                'yes' : function() {
                    this._isPopupShown && this.afterCurrentEvent(function() {
                        this._updatePopupPos();
                    });
                },

                '' : function() {
                    this._isPopupShown && this.afterCurrentEvent(function() {
                        this._updatePopupPos();
                    });
                }

            }

        }

    },

    /**
     * Возвращает dataprovider
     */
    getDataprovider: function() {

        var url = this.params.dataprovider.url;

        return this._dataprovider || (this._dataprovider = BEM.create(
            this.params.dataprovider.name || this.__self.getName() + '__dataprovider',
            $.extend(this.params.dataprovider, {
                url: url,
                callbackCtx : this
            })));

    },

    _onChange : function() {

        /**
         * (LEGO-3098) Не отправлять запрос и не показывать попап
         * при переключении между вкладками
         */
        activeNode === this.elem('input')[0] ?
            activeNode = null :
            this._preventRequest || this._doRequest();

        return this._onChange;

    },

    _onKeyDown : function(e) {

        var isArrow = e.keyCode == 38 || e.keyCode == 40;

        if(isArrow && !e.shiftKey) {
            e.preventDefault();
            var len = this._items.length,
                out = false;
            if(len) {
                var direction = e.keyCode - 39, // пользуемся особенностями кодов клавиш "вверх"/"вниз" ;-)
                    index = this._curItemIndex,
                    i = 0;

                do {
                    // если выбор перемещается с крайнего элемента вовне списка,
                    // то ставим фокус на инпут и возвращаем в него пользовательское значение
                    out = ((index == 0 && direction == -1) || (index + direction >= len)) && this._onLeaveItem(this._items[index], true);

                    index += direction;
                    index = index < 0? len - 1 : index >= len? 0 : index;
                } while(!out && this._onEnterItem(this._items[index], true) === false && ++i < len);
            }
        }

    },

    _onKeyPress : function(e) {

        if (e.keyCode == 13 &&
            this._curItemIndex > -1 &&
            this._isCurItemEnteredByKeyboard) {

            e.preventDefault();
            this._onSelectItem(this._items[this._curItemIndex], true);
        }

    },

    /**
     * Ленивое получение попапа
     * @returns {BEM} блок попапа
     */
    _getPopup : function() {

        var _this = this;
        if(!_this._popup) {
            var keyDownEvent = ($.browser.opera && $.browser.version < 12.10) ? 'keypress' : 'keydown',
                block = _this.__self.getName(),
                content = [{ elem : 'items', tag : 'ul', mix : [{ block : block, elem : 'popup-items' }]},
                    { block: 'b-form-input', elem: 'shadow', tag: 'i' }
                ];

            _this._hasPopupFade() && content.push({ block : block, elem : 'fade' });

            _this._popup = $(HTML.build({
                    block : 'i-popup',
                    mix : [
                        {
                            block : block,
                            elem : 'popup',
                            mods : _this.params.popupMods,
                            js : { uniqId: _this._uniqId }
                        }
                    ],
                    content : content
                })).bem('i-popup')
                    .on({
                        'show' : function() {
                            _this
                                .trigger('popup-shown')
                                .bindTo('keypress', _this._onKeyPress)
                                .bindTo(keyDownEvent, _this._onKeyDown)
                                .bindToWin('resize', _this._updatePopupPos)
                                ._isPopupShown = true;
                        },
                        'outside-click' : function(e, data) {
                            _this.containsDomElem($(data.domEvent.target)) && e.preventDefault();
                        },
                        'hide' : function() {
                            _this
                                .trigger('popup-hidden')
                                .unbindFrom('keypress ' + keyDownEvent)
                                .unbindFromWin('resize')
                                ._curItemIndex = -1;
                            _this._isPopupShown = false;
                        }
                    });

            // при первом создании попапа подписываемся на live-события его элементов
            $.each({
                    mouseover : _this._onEnterItem,
                    mouseout  : _this._onLeaveItem,
                    mousedown : _this._onSelectItem
                }, function(e, fn) {
                    BEM.blocks['b-autocomplete-item'].on(_this._popup.domElem, e, function(e) {
                        fn.call(_this, e.block);
                    });
                });

            DOM.init(_this._popup.domElem);
        }

        return _this._popup;

    },

    getPopup : function() {
        
        return this._getPopup();

    },

    _hasPopupFade : function() {

        return (this.params.popupMods || {}).fade == 'yes';

    },

    _updatePopupPos : function() {

        var box = this.elem('box'),
            css = box.offset();

        css.top += box.outerHeight();
        this.hasMod(this.elem('popup'), 'fixed') && (css.top -= DOM.win.scrollTop());
        this._hasPopupFade() && (css.width = box.outerWidth());

        this._preventPopupShow || this._getPopup().show(css);

    },

    _onEnterItem : function(item, byKeyboard) {

        if(item.hasMod('enterable', 'no')) return false;

        var items = this._items,
            index = this._curItemIndex;

        index > -1 && items[index].delMod('hovered');
        index = this._getItemIndex(item);
        index > -1 && items[index].setMod('hovered', 'yes');

        this._curItemIndex = index;
        this._isCurItemEnteredByKeyboard = !!byKeyboard;

        if(byKeyboard && this.params.updateOnEnter) {
            this._preventRequest = true;
            this
                .val(
                    item.enter() !== false? item.val() : this._userVal,
                    { source : 'autocomplete', itemIndex: this._curItemIndex })
                .del('_preventRequest');
        }

    },

    _onLeaveItem : function(item, byKeyboard) {

        var index = this._curItemIndex;
        if(index > -1 && index == this._getItemIndex(item)) {
            this._items[index].delMod('hovered');
            this._curItemIndex = -1;
        }

        byKeyboard && this.val(this._userVal);

        return true;

    },

    _onSelectItem : function(item, byKeyboard) {

        var selectResult = item.select(byKeyboard || false),
            needUpdate = (typeof selectResult == 'object')
                             ? selectResult.needUpdate
                             : selectResult !== false,
            needEvent = (typeof selectResult == 'object') && selectResult.needEvent;
        this._preventRequest = true;
        needUpdate && this
            .val(
                this._userVal = item.val(),
                { source : 'autocomplete', itemIndex: this._curItemIndex })
            ._getPopup().hide();

        if(byKeyboard) {
            this.del('_preventRequest');
        } else {
            needUpdate || (this._preventHide = true);
            this.afterCurrentEvent(function() {
                this
                    .setMod('focused', 'yes')
                    .del('_preventRequest', '_preventHide');
            });
        }

        (needUpdate || needEvent) && this.trigger('select', { item: item, byKeyboard: byKeyboard });

    },

    _getItemIndex : function(item) {

        return $.inArray(item, this._items);

    },

    _doRequest : function() {

        var _this = this;
        _this.enablePopup();
        _this._userVal = _this.val();
        _this
            .trigger('data-requested')
            .getDataprovider().get(
                _this.val(),
                function(data) {
                    _this.trigger('data-received', data);

                    var popup = _this._getPopup(),
                        dataItems = data.items || data;

                    _this.foot && dataItems.length && ($.inArray(_this.foot, dataItems) == -1) && dataItems.push(_this.foot);

                    if(dataItems.length) {
                        _this._curItemIndex = -1;
                        DOM.update(popup.elem('items'), _this._buildItemsHtml(dataItems), function() {
                            _this._updatePopupPos();
                            _this._items = popup.findBlocksInside('b-autocomplete-item');
                            _this.trigger('update-items');
                        });
                    } else {
                        popup.hide();
                    }
                });

    },

    _buildItemsHtml : function(data) {

        var _this = this;

        return HTML.build($.map(data, function(data, i) {

            var autocompleteItem = {
                    block : 'b-autocomplete-item',
                    data  : data,
                    mods  : { type : $.isArray(data)? data[0] : 'text' },
                    suggestVersion: _this.params.dataprovider.version
                },
                prefs;

            ($.isArray(data)) && $.isPlainObject(prefs = data.concat().pop()) && $.extend(autocompleteItem, prefs);

            return autocompleteItem;

        }));

    },

    setFoot : function(data) {

        return this.foot = data;

    },

    getDefaultParams : function() {

        return $.extend(this.__base(), {
            updateOnEnter : true,
            debounceDelay : 50,
            showListOnFocus: true
        });

    },

    enablePopup : function() {

        this._preventPopupShow = false;

    },

    disablePopup : function() {

        this._preventPopupShow = true;

    }

});

})(jQuery);
;
/* ../../lego/blocks-desktop/b-form-input/_autocomplete/b-form-input_autocomplete_yes.js: end */ /**/

/* ../../blocks-desktop/b-form-input/_autocomplete/b-form-input_autocomplete_yes.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-form-input', modName: 'autocomplete', modVal: 'yes'}, {

    _onKeyPress : function (e) {
        //VB-724
        if (e.keyCode == 13) {
            var selected = this
                .findBlockOutside('b-page')
                .findBlockInside(
                    {
                        blockName : 'b-autocomplete-item',
                        modName: 'hovered',
                        modVal: 'yes'
                    }
                );

            if (selected) {
                if (selected.getMod('type') == 'nav') {
                    e.preventDefault();
                    vb.navigateUrlWithReferer(selected.params.url, 1);
                }
            }
        }

        this.__base.apply(this, arguments);
    }

});

})();
;
/* ../../blocks-desktop/b-form-input/_autocomplete/b-form-input_autocomplete_yes.js: end */ /**/

/* ../../lego/blocks-desktop/i-common/string/i-common__string.js: begin */ /**/
BEM.decl('i-common__string', {}, {

    /**
     * Обрезать входную строку `str` до `maxLength` символов.
     * Порт функции `lego:clever-substring()` из i-common.xsl.
     *
     * @param {String} str строка на вход
     * @param {Nubmer} maxLength максимальная длина в символах
     * @param {Number} maxLengthRelative погрешность при обрезе сверх макс. длины
     *
     * @return {String}
     */
    cleverSubstring : (function() {

        var ellipsisChar = '…';

        return function(str, maxLength, maxLengthRelative) {
            return (str.length > maxLength + maxLengthRelative) ? str.substring(0, maxLength - 1) + ellipsisChar : str;
        }

    })(),


    /**
     * Экранирование специальных символов HTML
     *
     * @param {String} string экранируемая строка
     *
     * @return {String}
     */
    escapeHTML : (function() {

        var map = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': '&quot;',
                "'": '&#39;'
            },
            f = function(t) { return map[t] || t };

        return function(string) {
            return String(string).replace(/&(?!\w+;)|[<>"']/g, function(s) {
                return map[s] || s
            });
        }

    })(),

    /**
     * Экранирование специальных символов регулярных выражений в строке
     *
     * @param {String} string
     *
     * @return {String}
     */
    escapeRegExp : function(string) {

        return string.replace(/([.?*+^$[\]\\(){}|-])/g, '\\$1');

    },

    /**
     * Подсветка частей строки по заданным позициям.
     * Изначально подоразумевается для использования в поисквых подсказках.
     *
     * @param {String} text Исходная строка.
     * @param {Array} ranges Массив пар начала-конца диапазонов выделения.
     *
     * @return {String|Array} Массив строк и бэм-сущностей, предназначающийся для вставки в bemjson, либо исходная строка.
     */
    highlight  : function(text, ranges) {

        if (!$.isArray(ranges)) return text;

        var emphasized = [],
            cursor = 0, index,
            _ranges = ranges.sort(function(a, b) {
                return a[0] - b[0];
            })

        _ranges.forEach(function(range) {
            index = (cursor > range[0]) ? cursor : range[0];
            emphasized.push({
                tag: 'span',
                elem: 'span',
                content: this.escapeHTML(text.slice(cursor, index))
            });
            emphasized.push({
                tag: 'em',
                elem: 'em',
                content: this.escapeHTML(text.slice(index, cursor = range[1]))
            });
        }, this);

        emphasized.push({
            tag: 'span',
            elem: 'span',
            content: this.escapeHTML(text.slice(cursor))
        });

        return emphasized;

    }

});
;
/* ../../lego/blocks-desktop/i-common/string/i-common__string.js: end */ /**/

/* ../../blocks-desktop/i-common/__string/i-common__string.js: begin */ /**/
/** @requires BEM */
/** @requires BEM */

(function(undefined) {

BEM.decl('i-common__string', {}, {

    /**
     * Обрезать входную строку `str` до `maxLength` символов.
     * Порт функции `lego:clever-substring()` из i-common.xsl.
     *
     * @param {String} str строка на вход
     * @param {Nubmer} maxLength максимальная длина в символах
     * @param {Number} maxLengthRelative погрешность при обрезе сверх макс. длины
     *
     * @return {String}
     */
    cleverSubstring : (function() {

        var ellipsisChar = '&#x2026;'; // … HORIZONTAL ELLIPSIS  Unicode: U+2026, UTF-8: E2 80 A6

        return function(str, maxLength, maxLengthRelative) {
            return (str.length > maxLength + maxLengthRelative) ? str.substring(0, maxLength - 1) + ellipsisChar : str;
        }

    })(),
    /**
     * Экранирование специальных символов HTML
     *
     * @param {String} string экранируемая строка
     *
     * @return {String}
     */
    escapeHTML : (function() {

        var map = {
                "<": "&lt;",
                ">": "&gt;",
                '"': '&quot;',
                "'": '&#39;'
            },
            f = function(t) { return map[t] || t };

        return function(string) {
            return String(string).replace(/&(?!\w+;)|[<>"']/g, function(s) {
                return map[s] || s
            });
        }

    })()

});

})();
;
/* ../../blocks-desktop/i-common/__string/i-common__string.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/b-autocomplete-item.js: begin */ /**/
BEM.DOM.decl('b-autocomplete-item', {

    /**
     * Возвращает значение, которое надо вставить в input.
     * @returns {String}
     */
    val : function() {
        return this.params.val || this.elem('text').text() || this.domElem.text();
    },

    /**
     * Действие на наведение на пункт клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит подставлять значение пункта не надо
     */
    enter : function() {},

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит пункт сам сделал все необходимые действия
     */
    select : function(byKeyboard) {}

}, {

    live : function() {

        this.liveBindTo('mouseover mouseout mousedown', function(e) {
            this.trigger(e.type);
        });

    }

});

BEM.HTML.decl('b-autocomplete-item', {

    onBlock : function(ctx) {

        var data = ctx.param('data'),
            text = BEM.blocks['i-common__string'].escapeHTML($.isArray(data) ? data[1] : data);

        $.isArray(ctx.param('search_cgi')) && ctx.js({ cgi: ctx.param('search_cgi') });

        ctx
            .tag('li')
            .mod('pers', ctx.param('pers') ? 'yes' : false)
            .content(BEM.blocks['i-common__string'].highlight(text, ctx.param('hl')))
            .js(true);

    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/b-autocomplete-item.js: end */ /**/

/* ../../blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_history.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-autocomplete-item', modName: 'type', modVal: 'history'}, {

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true|Object} Если возвращается false, значит пункт сам сделал все необходимые действия
     */
    select : function(byKeyboard) {
        return {
            needUpdate: true
        }
    }

});

BEM.HTML.decl({ block: 'b-autocomplete-item', modName: 'type', modVal: 'history'}, {

    onBlock : function(ctx) {

        var BEM = require('bem').BEM,
            Lib = require('lib'),
            data = ctx.param('data').slice(1),
            clearUrl = data[0].replace(/^\w+:\/\//, ''),
            clearTitle = data[1];

        clearUrl = BEM.blocks['i-common__string'].cleverSubstring(
            clearUrl.substr(0, clearUrl.length - 5),
            Lib.getHistorySuggestMaxLength(),
            0
        ) + clearUrl.substr(clearUrl.length - 5);

        clearTitle = BEM.blocks['i-common__string'].cleverSubstring(
            clearTitle.substr(0, clearTitle.length - 5),
            Lib.getHistorySuggestMaxLength(),
            0
        ) + clearTitle.substr(clearTitle.length - 5);

        ctx
            .content([
                { tag : 'span', elem : 'text', content : BEM.blocks['i-common__string'].highlight(clearUrl, ctx.param('hl')) },
                { tag : 'span', elem : 'fact', content : [' — ', BEM.blocks['i-common__string'].escapeHTML(clearTitle)] }
            ])
            .js({ url : data[0], title: data[1] });

    }

});

})();
;
/* ../../blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_history.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nav.js: begin */ /**/
BEM.DOM.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nav' }, {

   enter : function() {

       return false;

   },

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит пункт сам сделал все необходимые действия
     * @returns {Object.<needUpdate|needEvent>}
     */
    select : function(byKeyboard) {
        // открываем ссылку только когда выбрали с помощью клавиатуры, если выбрали мышкой, то сработает обычная ссылка
        byKeyboard && $('<form style="display:none" action="' + this.val() + '" target="_blank"/>')
            .appendTo('body')
            .submit()
            .remove();

        return { needEvent: true };

    }

});

BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nav' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data'),
            isV4 = ctx.param('suggestVersion') == 4,
            urlData = data[4] || data[3],
            url = (urlData.match(/^\w[\w-]*:\/\//g)? '' : 'http://') + urlData;

        ctx
            .js({ val : url })
            .content({
                elem : 'link',
                url  : url,
                title : BEM.blocks['i-common__string'].escapeHTML(isV4 ? data[3] : data[2]),
                description : BEM.blocks['i-common__string'].highlight(isV4 ? data[2] : data[1], ctx.param('hl'))
            });

    },

    onElem : {

        'link' : function(ctx) {

            ctx
                .tag('a')
                .attrs({ href : ctx.param('url'), target : '_blank' })
                .content([
                    { elem : 'link-url', tag : 'span', content : ctx.param('title') },
                    { elem : 'link-info', tag : 'span', content : ['&nbsp;&mdash; '].concat(ctx.param('description')) }
                ]);

        }


    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nav.js: end */ /**/

/* ../../blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nav.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-autocomplete-item', modName: 'type', modVal: 'nav'}, {

    _NAVIGATE_CODE_CURRENT: 1,              // в текущем табе
    _NAVIGATE_CODE_NEW_WINDOW: 2,           // в новом окне
    _NAVIGATE_CODE_NEW_TAB: 3,              // в новом табе

    onSetMod: {
        js: function() {
            this.bindTo('mousedown', this._onSelectItem, this);
        }
    },

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит пункт сам сделал все необходимые действия
     */
    select : function(byKeyboard) {
        var vb = require('vb');
        byKeyboard && vb.navigateUrlWithReferer(
            this.params.url,
            this._NAVIGATE_CODE_CURRENT
        );

        return false;
    },

    _onSelectItem: function(e, data) {
        var vb = require('vb');
        vb.navigateUrlWithReferer(this.params.url, this._getNavigateCode(e));
        return true;
    },

    _getNavigateCode: function(e /** {Event} */) {
        var code = this._NAVIGATE_CODE_CURRENT;

        // Открываем в новом окне
        if (e.shiftKey) {
            code = this._NAVIGATE_CODE_NEW_WINDOW;
        // Открываем в новом табе
        } else if (e.ctrlKey || e.metaKey) {
            code = this._NAVIGATE_CODE_NEW_TAB;
        }
        return code;
    }

});

BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nav' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data'),
            isV4 = ctx.param('suggestVersion') == 4,
            urlData = data[4] || data[3],
            url = (urlData.match(/^\w[\w-]*:\/\//g)? '' : 'http://') + urlData;

        ctx
            .js({ url : url })
            .content({
                elem : 'vb-link',
                title : BEM.blocks['i-common__string'].escapeHTML(isV4 ? data[3] : data[2]),
                description : BEM.blocks['i-common__string'].highlight(isV4 ? data[2] : data[1], ctx.param('hl'))
            });

    },

    onElem : {

        'vb-link' : function(ctx) {

            ctx
                .tag('span')
                .content([
                { elem : 'link-url', tag : 'span', content : ctx.param('title') },
                { elem : 'link-info', tag : 'span', content : ['&nbsp;&mdash; '].concat(ctx.param('description')) }
            ]);

        }


    }

});


})();
;
/* ../../blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nav.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_hl.js: begin */ /**/
BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'hl' }, {

    onBlock : function(ctx) {

        ctx.content($.map(ctx.param('data').slice(1), function(chunk) {
            return $.isArray(chunk)?
                { tag : 'span', elem : 'highlight', content : chunk[0] } :
                chunk;
        }));

    }

});

;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_hl.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_fact.js: begin */ /**/
BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'fact' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data').slice(1);

        ctx.content([
            { tag : 'span', elem : 'text', content : BEM.blocks['i-common__string'].highlight(data[0], ctx.param('hl')) },
            { tag : 'span', elem : 'fact', content : [' — ', BEM.blocks['i-common__string'].escapeHTML(data[1])] }
        ]);

    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_fact.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nah.js: begin */ /**/
BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'nah' }, {
    onBlock : function(ctx) {

        ctx.content(ctx.param('data')[1])

    }
});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_nah.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_href.js: begin */ /**/
BEM.DOM.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'href' }, {

    url : function() {
        
        return this.findBlockInside('b-link').domElem.attr('href');

    },

    enter : function() {

        return false;

    },

    /**
     * Действие на выбор пункта
     * @param {Boolean} [byKeyboard=false] выбор осуществлен клавиатурой
     * @returns {Boolean=true} Если возвращается false, значит пункт сам сделал все необходимые действия
     */
    select : function(byKeyboard) {
        // открываем ссылку только когда выбрали с помощью клавиатуры, если выбрали мышкой, то сработает обычная ссылка
//        byKeyboard && $('<form style="display:none" method="get" action="' + this.url() + '" />')
//            .appendTo('body')
//            .submit()
//            .remove();
        
        byKeyboard && (location.href = this.url());

        return false;

    }

});

BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'href' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data').slice(1);

        ctx.content(
            { block: 'b-link', content : data[0], url: data[1] }
        );

    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_href.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_weather.js: begin */ /**/
BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'weather' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data').slice(1),
            escapeHTML = BEM.blocks['i-common__string'].escapeHTML;

        ctx.content([
            { tag: 'span', elem: 'text', content: escapeHTML(data[0]) },
            { tag: 'i', elem: 'icon', mods: { weather: data[2].replace('+', '_') } },
            { tag: 'span', elem: 'value', content: escapeHTML(data[1].replace('-', '&ndash;')) }
        ]);

    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_weather.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_traffic.js: begin */ /**/
BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'traffic' }, {

    onBlock : function(ctx) {

        var data = ctx.param('data').slice(1),
            escapeHTML = BEM.blocks['i-common__string'].escapeHTML;

        ctx.content([
            { tag: 'span', elem: 'text', content: escapeHTML(data[0]) },
            { tag: 'i', elem: 'icon', mods: { traffic: data[2] } },
            { tag: 'span', elem: 'value', content: escapeHTML(data[1]) }
        ]);

    }

});
;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_traffic.js: end */ /**/

/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_foot.js: begin */ /**/
BEM.DOM.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'foot' }, {

    select : function() {
        return false;
    }

});

BEM.HTML.decl({ block : 'b-autocomplete-item', modName : 'type', modVal : 'foot' }, {

    onBlock : function(ctx) {

        ctx
            .mod('enterable', 'no')
            .content($.map(ctx.param('data').slice(1), function(chunk) {
                return $.isArray(chunk)?
                    { tag : 'span', elem : 'foot', content : chunk[0] } :
                    chunk;
            }));

    }

});

;
/* ../../lego/blocks-desktop/b-autocomplete-item/_type/b-autocomplete-item_type_foot.js: end */ /**/

/* ../../blocks-desktop/b-vb-foot/b-vb-foot.js: begin */ /**/
blocks['b-vb-foot'] = function(data) {
    var vb = require('vb'),
        ie78 = (vb.navigator === 'ie' && vb.navigatorMajorVersion < 9);

    return {
        block: 'b-vb-foot',
        js: true,
        content: [
            {
                elem: 'content',
                content: [
                    {
                        block: 'b-menu-horiz',
                        mods: { layout: 'normal', type: 'foot', pos: 'left' },
                        js: false,
                        content: [
                            {
                                block: 'b-dropdowna',
                                content: [
                                    {
                                        elem: 'switcher',
                                        content: [
                                            {
                                                block: 'b-link',
                                                mods: { pseudo: 'yes', border: 'none', open: 'bookmark' },
                                                content: vb.getLocalizedString('footer.closedTabs')
                                            }
                                        ]
                                    },
                                    {
                                        block: 'b-popupa',
                                        mods: { theme: 'ffffff', type: 'closed-bookmarks' },
                                        content: [
                                            { elem: 'tail' },
                                            {
                                                elem: 'content',
                                                content: [
                                                    {
                                                        block: 'b-spin',
                                                        mods: {
                                                            progress: 'yes'
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        block: 'b-menu-horiz',
                        mods: { layout: 'normal', type: 'foot', pos: 'center' },
                        js: false,
                        content: [
                            !ie78 && {
                                elem: 'item',
                                content: {
                                    block: 'b-link',
                                    mods: { pseudo: 'yes', border: 'none', action: 'show-downloads' },
                                    content: vb.getLocalizedString('footer.downloads')
                                }
                            },
                            {
                                elem: 'item',
                                content: {
                                    block: 'b-link',
                                    mods: { pseudo: 'yes', border: 'none', action: 'show-bookmarks' },
                                    content: vb.getLocalizedString('footer.bookmarks')
                                }
                            },
                            {
                                elem: 'item',
                                content: {
                                    block: 'b-link',
                                    mods: { pseudo: 'yes', border: 'none', action: 'show-history' },
                                    content: vb.getLocalizedString('footer.history')
                                }
                            },
                            {
                                elem: 'item',
                                content: {
                                    block: 'b-link',
                                    mods: { pseudo: 'yes', border: 'none', action: 'config' },
                                    content: vb.getLocalizedString('settings')
                                }
                            }
                        ]
                    }
                ]
            }
        ]
    };
};;
/* ../../blocks-desktop/b-vb-foot/b-vb-foot.js: end */ /**/

/* ../../blocks-desktop/b-link/_action/b-link_action_config.js: begin */ /**/
/** @requires BEM */
/** @requires BEM.DOM */

(function(undefined) {

BEM.DOM.decl({ block: 'b-link', modName: 'action', modVal: 'config'}, {

    onSetMod: {
        js: function() {
            this.on('click', this._openConfigPage, this);
        }
    },

    destruct: function() {
        this.un('click', this._openConfigPage, this);
        this.__base.apply(this, arguments);
    },

    _openConfigPage: function() {
        this.findBlockOutside('b-page').setMod('page', 'config');
    }

});

})();
;
/* ../../blocks-desktop/b-link/_action/b-link_action_config.js: end */ /**/



/* added by builder */
return {
    "BEM": BEM,
    "blocks": blocks
};
})
},{})